/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import android.util.Log;
import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbACAudioControlEndpoint;
import com.android.server.usb.descriptors.UsbACAudioStreamEndpoint;
import com.android.server.usb.descriptors.UsbACMidiEndpoint;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.UsbDescriptorParser;
import com.android.server.usb.descriptors.UsbInterfaceDescriptor;

abstract class UsbACEndpoint
extends UsbDescriptor {
    private static final String TAG = "UsbACEndpoint";
    protected final byte mSubclass;
    protected byte mSubtype;

    UsbACEndpoint(int length, byte type, byte subclass) {
        super(length, type);
        this.mSubclass = subclass;
    }

    public byte getSubclass() {
        return this.mSubclass;
    }

    public byte getSubtype() {
        return this.mSubtype;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mSubtype = stream.getByte();
        return this.mLength;
    }

    public static UsbDescriptor allocDescriptor(UsbDescriptorParser parser, int length, byte type) {
        UsbInterfaceDescriptor interfaceDesc = parser.getCurInterface();
        byte subClass = interfaceDesc.getUsbSubclass();
        switch (subClass) {
            case 1: {
                return new UsbACAudioControlEndpoint(length, type, subClass);
            }
            case 2: {
                return new UsbACAudioStreamEndpoint(length, type, subClass);
            }
            case 3: {
                return new UsbACMidiEndpoint(length, type, subClass);
            }
        }
        Log.w(TAG, "Unknown Audio Class Endpoint id:0x" + Integer.toHexString(subClass));
        return null;
    }
}

