/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbDescriptor;
import com.android.server.usb.descriptors.report.ReportCanvas;
import com.android.server.usb.descriptors.report.UsbStrings;

public final class UsbDeviceDescriptor
extends UsbDescriptor {
    private static final String TAG = "UsbDeviceDescriptor";
    public static final int USBSPEC_1_0 = 256;
    public static final int USBSPEC_1_1 = 272;
    public static final int USBSPEC_2_0 = 512;
    private int mSpec;
    private byte mDevClass;
    private byte mDevSubClass;
    private byte mProtocol;
    private byte mPacketSize;
    private int mVendorID;
    private int mProductID;
    private int mDeviceRelease;
    private byte mMfgIndex;
    private byte mProductIndex;
    private byte mSerialNum;
    private byte mNumConfigs;

    UsbDeviceDescriptor(int length, byte type) {
        super(length, type);
        this.mHierarchyLevel = 1;
    }

    public int getSpec() {
        return this.mSpec;
    }

    public byte getDevClass() {
        return this.mDevClass;
    }

    public byte getDevSubClass() {
        return this.mDevSubClass;
    }

    public byte getProtocol() {
        return this.mProtocol;
    }

    public byte getPacketSize() {
        return this.mPacketSize;
    }

    public int getVendorID() {
        return this.mVendorID;
    }

    public int getProductID() {
        return this.mProductID;
    }

    public int getDeviceRelease() {
        return this.mDeviceRelease;
    }

    public byte getMfgIndex() {
        return this.mMfgIndex;
    }

    public byte getProductIndex() {
        return this.mProductIndex;
    }

    public byte getSerialNum() {
        return this.mSerialNum;
    }

    public byte getNumConfigs() {
        return this.mNumConfigs;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mSpec = stream.unpackUsbShort();
        this.mDevClass = stream.getByte();
        this.mDevSubClass = stream.getByte();
        this.mProtocol = stream.getByte();
        this.mPacketSize = stream.getByte();
        this.mVendorID = stream.unpackUsbShort();
        this.mProductID = stream.unpackUsbShort();
        this.mDeviceRelease = stream.unpackUsbShort();
        this.mMfgIndex = stream.getByte();
        this.mProductIndex = stream.getByte();
        this.mSerialNum = stream.getByte();
        this.mNumConfigs = stream.getByte();
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        int spec = this.getSpec();
        canvas.writeListItem("Spec: " + ReportCanvas.getBCDString(spec));
        byte devClass = this.getDevClass();
        String classStr = UsbStrings.getClassName(devClass);
        byte devSubClass = this.getDevSubClass();
        String subClasStr = UsbStrings.getClassName(devSubClass);
        canvas.writeListItem("Class " + devClass + ": " + classStr + " Subclass" + devSubClass + ": " + subClasStr);
        canvas.writeListItem("Vendor ID: " + ReportCanvas.getHexString(this.getVendorID()) + " Product ID: " + ReportCanvas.getHexString(this.getProductID()) + " Product Release: " + ReportCanvas.getBCDString(this.getDeviceRelease()));
        byte mfgIndex = this.getMfgIndex();
        String manufacturer = UsbDescriptor.getUsbDescriptorString(canvas.getConnection(), mfgIndex);
        byte productIndex = this.getProductIndex();
        String product = UsbDescriptor.getUsbDescriptorString(canvas.getConnection(), productIndex);
        canvas.writeListItem("Manufacturer " + mfgIndex + ": " + manufacturer + " Product " + productIndex + ": " + product);
        canvas.closeList();
    }
}

