/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wallpaper;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.PendingIntent;
import android.app.UserSwitchObserver;
import android.app.WallpaperColors;
import android.app.WallpaperInfo;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.system.ErrnoException;
import android.system.Os;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.Display;
import android.view.IWindowManager;
import android.view.WindowManager;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.server.FgThread;
import com.android.server.SystemService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class WallpaperManagerService
extends IWallpaperManager.Stub {
    static final String TAG = "WallpaperManagerService";
    static final boolean DEBUG = false;
    static final boolean DEBUG_LIVE = true;
    final Object mLock = new Object();
    static final long MIN_WALLPAPER_CRASH_TIME = 10000L;
    static final int MAX_WALLPAPER_COMPONENT_LOG_LENGTH = 128;
    static final String WALLPAPER = "wallpaper_orig";
    static final String WALLPAPER_CROP = "wallpaper";
    static final String WALLPAPER_LOCK_ORIG = "wallpaper_lock_orig";
    static final String WALLPAPER_LOCK_CROP = "wallpaper_lock";
    static final String WALLPAPER_INFO = "wallpaper_info.xml";
    static final String[] sPerUserFiles = new String[]{"wallpaper_orig", "wallpaper", "wallpaper_lock_orig", "wallpaper_lock", "wallpaper_info.xml"};
    final Context mContext;
    final IWindowManager mIWindowManager;
    final IPackageManager mIPackageManager;
    final MyPackageMonitor mMonitor;
    final AppOpsManager mAppOpsManager;
    final SparseArray<RemoteCallbackList<IWallpaperManagerCallback>> mColorsChangedListeners;
    WallpaperData mLastWallpaper;
    IWallpaperManagerCallback mKeyguardListener;
    boolean mWaitingForUnlock;
    boolean mShuttingDown;
    int mWallpaperId;
    final ComponentName mImageWallpaper;
    final ComponentName mDefaultWallpaperComponent;
    final SparseArray<WallpaperData> mWallpaperMap = new SparseArray();
    final SparseArray<WallpaperData> mLockWallpaperMap = new SparseArray();
    final SparseArray<Boolean> mUserRestorecon = new SparseArray();
    int mCurrentUserId;

    void notifyLockWallpaperChanged() {
        IWallpaperManagerCallback cb = this.mKeyguardListener;
        if (cb != null) {
            try {
                cb.onWallpaperChanged();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWallpaperColorsChanged(WallpaperData wallpaper, int which) {
        boolean needsExtraction;
        Object object = this.mLock;
        synchronized (object) {
            RemoteCallbackList<IWallpaperManagerCallback> currentUserColorListeners = this.mColorsChangedListeners.get(wallpaper.userId);
            RemoteCallbackList<IWallpaperManagerCallback> userAllColorListeners = this.mColorsChangedListeners.get(-1);
            if (WallpaperManagerService.emptyCallbackList(currentUserColorListeners) && WallpaperManagerService.emptyCallbackList(userAllColorListeners)) {
                return;
            }
            needsExtraction = wallpaper.primaryColors == null;
        }
        this.notifyColorListeners(wallpaper.primaryColors, which, wallpaper.userId);
        if (needsExtraction) {
            this.extractColors(wallpaper);
            object = this.mLock;
            synchronized (object) {
                if (wallpaper.primaryColors == null) {
                    return;
                }
                // MONITOREXIT @DISABLED, blocks:[1, 2, 4, 9] lbl25 : MonitorExitStatement: MONITOREXIT : var3_3
                this.notifyColorListeners(wallpaper.primaryColors, which, wallpaper.userId);
            }
        }
    }

    private static <T extends IInterface> boolean emptyCallbackList(RemoteCallbackList<T> list) {
        return list == null || list.getRegisteredCallbackCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyColorListeners(WallpaperColors wallpaperColors, int which, int userId) {
        IWallpaperManagerCallback keyguardListener;
        ArrayList<IWallpaperManagerCallback> colorListeners = new ArrayList<IWallpaperManagerCallback>();
        Object object = this.mLock;
        synchronized (object) {
            int i;
            int count;
            RemoteCallbackList<IWallpaperManagerCallback> currentUserColorListeners = this.mColorsChangedListeners.get(userId);
            RemoteCallbackList<IWallpaperManagerCallback> userAllColorListeners = this.mColorsChangedListeners.get(-1);
            keyguardListener = this.mKeyguardListener;
            if (currentUserColorListeners != null) {
                count = currentUserColorListeners.beginBroadcast();
                for (i = 0; i < count; ++i) {
                    colorListeners.add(currentUserColorListeners.getBroadcastItem(i));
                }
                currentUserColorListeners.finishBroadcast();
            }
            if (userAllColorListeners != null) {
                count = userAllColorListeners.beginBroadcast();
                for (i = 0; i < count; ++i) {
                    colorListeners.add(userAllColorListeners.getBroadcastItem(i));
                }
                userAllColorListeners.finishBroadcast();
            }
        }
        int count = colorListeners.size();
        for (int i = 0; i < count; ++i) {
            try {
                ((IWallpaperManagerCallback)colorListeners.get(i)).onWallpaperColorsChanged(wallpaperColors, which, userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (keyguardListener != null) {
            try {
                keyguardListener.onWallpaperColorsChanged(wallpaperColors, which, userId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractColors(WallpaperData wallpaper) {
        Bitmap bitmap;
        int wallpaperId;
        String cropFile = null;
        Object object = this.mLock;
        synchronized (object) {
            boolean imageWallpaper;
            boolean bl = imageWallpaper = this.mImageWallpaper.equals(wallpaper.wallpaperComponent) || wallpaper.wallpaperComponent == null;
            if (imageWallpaper && wallpaper.cropFile != null && wallpaper.cropFile.exists()) {
                cropFile = wallpaper.cropFile.getAbsolutePath();
            }
            wallpaperId = wallpaper.wallpaperId;
        }
        WallpaperColors colors = null;
        if (cropFile != null && (bitmap = BitmapFactory.decodeFile(cropFile)) != null) {
            colors = WallpaperColors.fromBitmap(bitmap);
            bitmap.recycle();
        }
        if (colors == null) {
            Slog.w(TAG, "Cannot extract colors because wallpaper could not be read.");
            return;
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            if (wallpaper.wallpaperId == wallpaperId) {
                wallpaper.primaryColors = colors;
                this.saveSettingsLocked(wallpaper.userId);
            } else {
                Slog.w(TAG, "Not setting primary colors since wallpaper changed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCrop(WallpaperData wallpaper) {
        boolean success = false;
        Rect cropHint = new Rect(wallpaper.cropHint);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(wallpaper.wallpaperFile.getAbsolutePath(), options);
        if (options.outWidth <= 0 || options.outHeight <= 0) {
            Slog.w(TAG, "Invalid wallpaper data");
            success = false;
        } else {
            boolean needCrop = false;
            boolean needScale = false;
            if (cropHint.isEmpty()) {
                cropHint.top = 0;
                cropHint.left = 0;
                cropHint.right = options.outWidth;
                cropHint.bottom = options.outHeight;
            } else {
                cropHint.offset(cropHint.right > options.outWidth ? options.outWidth - cropHint.right : 0, cropHint.bottom > options.outHeight ? options.outHeight - cropHint.bottom : 0);
                if (cropHint.left < 0) {
                    cropHint.left = 0;
                }
                if (cropHint.top < 0) {
                    cropHint.top = 0;
                }
                needCrop = options.outHeight > cropHint.height() || options.outWidth > cropHint.width();
            }
            boolean bl = needScale = wallpaper.height != cropHint.height();
            if (!needCrop && !needScale) {
                success = FileUtils.copyFile(wallpaper.wallpaperFile, wallpaper.cropFile);
                if (!success) {
                    wallpaper.cropFile.delete();
                }
            } else {
                FileOutputStream f = null;
                BufferedOutputStream bos = null;
                try {
                    BitmapFactory.Options scaler;
                    BitmapRegionDecoder decoder = BitmapRegionDecoder.newInstance(wallpaper.wallpaperFile.getAbsolutePath(), false);
                    int actualScale = cropHint.height() / wallpaper.height;
                    int scale = 1;
                    while (2 * scale < actualScale) {
                        scale *= 2;
                    }
                    if (scale > 1) {
                        scaler = new BitmapFactory.Options();
                        scaler.inSampleSize = scale;
                    } else {
                        scaler = null;
                    }
                    Bitmap cropped = decoder.decodeRegion(cropHint, scaler);
                    decoder.recycle();
                    if (cropped == null) {
                        Slog.e(TAG, "Could not decode new wallpaper");
                    } else {
                        cropHint.offsetTo(0, 0);
                        cropHint.right /= scale;
                        cropHint.bottom /= scale;
                        float heightR = (float)wallpaper.height / (float)cropHint.height();
                        int destWidth = (int)((float)cropHint.width() * heightR);
                        Bitmap finalCrop = Bitmap.createScaledBitmap(cropped, destWidth, wallpaper.height, true);
                        f = new FileOutputStream(wallpaper.cropFile);
                        bos = new BufferedOutputStream(f, 32768);
                        finalCrop.compress(Bitmap.CompressFormat.JPEG, 100, bos);
                        bos.flush();
                        success = true;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    IoUtils.closeQuietly(bos);
                    IoUtils.closeQuietly(f);
                }
            }
        }
        if (!success) {
            Slog.e(TAG, "Unable to apply new wallpaper");
            wallpaper.cropFile.delete();
        }
        if (wallpaper.cropFile.exists()) {
            boolean bl = SELinux.restorecon(wallpaper.cropFile.getAbsoluteFile());
        }
    }

    int makeWallpaperIdLocked() {
        do {
            ++this.mWallpaperId;
        } while (this.mWallpaperId == 0);
        return this.mWallpaperId;
    }

    public WallpaperManagerService(Context context) {
        this.mContext = context;
        this.mShuttingDown = false;
        this.mImageWallpaper = ComponentName.unflattenFromString(context.getResources().getString(17039964));
        this.mDefaultWallpaperComponent = WallpaperManager.getDefaultWallpaperComponent(context);
        this.mIWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mIPackageManager = AppGlobals.getPackageManager();
        this.mAppOpsManager = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mMonitor = new MyPackageMonitor();
        this.mMonitor.register(context, null, UserHandle.ALL, true);
        WallpaperManagerService.getWallpaperDir(0).mkdirs();
        this.loadSettingsLocked(0, false);
        this.getWallpaperSafeLocked(0, 1);
        this.mColorsChangedListeners = new SparseArray();
    }

    private static File getWallpaperDir(int userId) {
        return Environment.getUserSystemDirectory(userId);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        for (int i = 0; i < this.mWallpaperMap.size(); ++i) {
            WallpaperData wallpaper = this.mWallpaperMap.valueAt(i);
            wallpaper.wallpaperObserver.stopWatching();
        }
    }

    void systemReady() {
        WallpaperData wallpaper = this.mWallpaperMap.get(0);
        if (this.mImageWallpaper.equals(wallpaper.nextWallpaperComponent)) {
            if (!wallpaper.cropExists()) {
                this.generateCrop(wallpaper);
            }
            if (!wallpaper.cropExists()) {
                this.clearWallpaperLocked(false, 1, 0, null);
            }
        }
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_REMOVED".equals(action)) {
                    WallpaperManagerService.this.onRemoveUser(intent.getIntExtra("android.intent.extra.user_handle", -10000));
                }
            }
        }, userFilter);
        IntentFilter shutdownFilter = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if ("android.intent.action.ACTION_SHUTDOWN".equals(intent.getAction())) {
                    Object object = WallpaperManagerService.this.mLock;
                    synchronized (object) {
                        WallpaperManagerService.this.mShuttingDown = true;
                    }
                }
            }
        }, shutdownFilter);
        try {
            ActivityManager.getService().registerUserSwitchObserver(new UserSwitchObserver(){

                @Override
                public void onUserSwitching(int newUserId, IRemoteCallback reply) {
                    WallpaperManagerService.this.switchUser(newUserId, reply);
                }
            }, TAG);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        if (Binder.getCallingUid() != 1000) {
            throw new RuntimeException("getName() can only be called from the system process");
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.mWallpaperMap.get((int)0).name;
        }
    }

    void stopObserver(WallpaperData wallpaper) {
        if (wallpaper != null && wallpaper.wallpaperObserver != null) {
            wallpaper.wallpaperObserver.stopWatching();
            wallpaper.wallpaperObserver = null;
        }
    }

    void stopObserversLocked(int userId) {
        this.stopObserver(this.mWallpaperMap.get(userId));
        this.stopObserver(this.mLockWallpaperMap.get(userId));
        this.mWallpaperMap.remove(userId);
        this.mLockWallpaperMap.remove(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUnlockUser(final int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentUserId == userId) {
                if (this.mWaitingForUnlock) {
                    this.switchUser(userId, null);
                }
                if (this.mUserRestorecon.get(userId) != Boolean.TRUE) {
                    this.mUserRestorecon.put(userId, Boolean.TRUE);
                    Runnable relabeler = new Runnable(){

                        @Override
                        public void run() {
                            File wallpaperDir = WallpaperManagerService.getWallpaperDir(userId);
                            for (String filename : sPerUserFiles) {
                                File f = new File(wallpaperDir, filename);
                                if (!f.exists()) continue;
                                SELinux.restorecon(f);
                            }
                        }
                    };
                    BackgroundThread.getHandler().post(relabeler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRemoveUser(int userId) {
        if (userId < 1) {
            return;
        }
        File wallpaperDir = WallpaperManagerService.getWallpaperDir(userId);
        Object object = this.mLock;
        synchronized (object) {
            this.stopObserversLocked(userId);
            for (String filename : sPerUserFiles) {
                new File(wallpaperDir, filename).delete();
            }
            this.mUserRestorecon.remove(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchUser(int userId, IRemoteCallback reply) {
        WallpaperData lockWallpaper;
        WallpaperData systemWallpaper;
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentUserId = userId;
            systemWallpaper = this.getWallpaperSafeLocked(userId, 1);
            WallpaperData tmpLockWallpaper = this.mLockWallpaperMap.get(userId);
            WallpaperData wallpaperData = lockWallpaper = tmpLockWallpaper == null ? systemWallpaper : tmpLockWallpaper;
            if (systemWallpaper.wallpaperObserver == null) {
                systemWallpaper.wallpaperObserver = new WallpaperObserver(systemWallpaper);
                systemWallpaper.wallpaperObserver.startWatching();
            }
            this.switchWallpaper(systemWallpaper, reply);
        }
        FgThread.getHandler().post(() -> {
            this.notifyWallpaperColorsChanged(systemWallpaper, 1);
            this.notifyWallpaperColorsChanged(lockWallpaper, 2);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchWallpaper(WallpaperData wallpaper, IRemoteCallback reply) {
        Object object = this.mLock;
        synchronized (object) {
            ComponentName cname;
            this.mWaitingForUnlock = false;
            ComponentName componentName = cname = wallpaper.wallpaperComponent != null ? wallpaper.wallpaperComponent : wallpaper.nextWallpaperComponent;
            if (!this.bindWallpaperComponentLocked(cname, true, false, wallpaper, reply)) {
                ServiceInfo si = null;
                try {
                    si = this.mIPackageManager.getServiceInfo(cname, 262144, wallpaper.userId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (si == null) {
                    Slog.w(TAG, "Failure starting previous wallpaper; clearing");
                    this.clearWallpaperLocked(false, 1, wallpaper.userId, reply);
                } else {
                    Slog.w(TAG, "Wallpaper isn't direct boot aware; using fallback until unlocked");
                    wallpaper.wallpaperComponent = wallpaper.nextWallpaperComponent;
                    WallpaperData fallback = new WallpaperData(wallpaper.userId, WALLPAPER_LOCK_ORIG, WALLPAPER_LOCK_CROP);
                    this.ensureSaneWallpaperData(fallback);
                    this.bindWallpaperComponentLocked(this.mImageWallpaper, true, false, fallback, reply);
                    this.mWaitingForUnlock = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWallpaper(String callingPackage, int which, int userId) {
        this.checkPermission("android.permission.SET_WALLPAPER");
        if (!this.isWallpaperSupported(callingPackage) || !this.isSetWallpaperAllowed(callingPackage)) {
            return;
        }
        userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "clearWallpaper", null);
        WallpaperData data = null;
        Object object = this.mLock;
        synchronized (object) {
            this.clearWallpaperLocked(false, which, userId, null);
            if (which == 2) {
                data = this.mLockWallpaperMap.get(userId);
            }
            if (which == 1 || data == null) {
                data = this.mWallpaperMap.get(userId);
            }
        }
        if (data != null) {
            this.notifyWallpaperColorsChanged(data, which);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void clearWallpaperLocked(boolean defaultFailed, int which, int userId, IRemoteCallback reply) {
        IllegalArgumentException e;
        long ident;
        WallpaperData wallpaper;
        block22: {
            block21: {
                block20: {
                    if (which != 1 && which != 2) {
                        throw new IllegalArgumentException("Must specify exactly one kind of wallpaper to read");
                    }
                    wallpaper = null;
                    if (which == 2) {
                        wallpaper = this.mLockWallpaperMap.get(userId);
                        if (wallpaper == null) {
                            return;
                        }
                    } else {
                        wallpaper = this.mWallpaperMap.get(userId);
                        if (wallpaper == null) {
                            this.loadSettingsLocked(userId, false);
                            wallpaper = this.mWallpaperMap.get(userId);
                        }
                    }
                    if (wallpaper == null) {
                        return;
                    }
                    ident = Binder.clearCallingIdentity();
                    if (!wallpaper.wallpaperFile.exists()) break block20;
                    wallpaper.wallpaperFile.delete();
                    wallpaper.cropFile.delete();
                    if (which != 2) break block20;
                    this.mLockWallpaperMap.remove(userId);
                    IWallpaperManagerCallback cb = this.mKeyguardListener;
                    if (cb != null) {
                        try {
                            cb.onWallpaperChanged();
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    this.saveSettingsLocked(userId);
                    Binder.restoreCallingIdentity(ident);
                    return;
                }
                e = null;
                wallpaper.primaryColors = null;
                wallpaper.imageWallpaperPending = false;
                if (userId == this.mCurrentUserId) break block21;
                Binder.restoreCallingIdentity(ident);
                return;
            }
            if (!this.bindWallpaperComponentLocked(defaultFailed ? this.mImageWallpaper : null, true, false, wallpaper, reply)) break block22;
            Binder.restoreCallingIdentity(ident);
            return;
        }
        try {
            block24: {
                break block24;
                {
                    catch (IllegalArgumentException e1) {
                        e = e1;
                    }
                }
            }
            Slog.e(TAG, "Default wallpaper component not found!", e);
            this.clearWallpaperComponentLocked(wallpaper);
            if (reply != null) {
                try {
                    reply.sendResult(null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasNamedWallpaper(String name) {
        Object object = this.mLock;
        synchronized (object) {
            block10: {
                List<UserInfo> users;
                long ident = Binder.clearCallingIdentity();
                try {
                    users = ((UserManager)this.mContext.getSystemService("user")).getUsers();
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
                Iterator<UserInfo> iterator = users.iterator();
                while (iterator.hasNext()) {
                    UserInfo user = iterator.next();
                    if (user.isManagedProfile()) continue;
                    WallpaperData wd = this.mWallpaperMap.get(user.id);
                    if (wd == null) {
                        this.loadSettingsLocked(user.id, false);
                        wd = this.mWallpaperMap.get(user.id);
                    }
                    if (wd == null || !name.equals(wd.name)) {
                        continue;
                    }
                    break block10;
                }
                return false;
            }
            return true;
        }
    }

    private Point getDefaultDisplaySize() {
        Point p = new Point();
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display d = wm.getDefaultDisplay();
        d.getRealSize(p);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDimensionHints(int width, int height, String callingPackage) throws RemoteException {
        this.checkPermission("android.permission.SET_WALLPAPER_HINTS");
        if (!this.isWallpaperSupported(callingPackage)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getCallingUserId();
            WallpaperData wallpaper = this.getWallpaperSafeLocked(userId, 1);
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("width and height must be > 0");
            }
            Point displaySize = this.getDefaultDisplaySize();
            width = Math.max(width, displaySize.x);
            height = Math.max(height, displaySize.y);
            if (width != wallpaper.width || height != wallpaper.height) {
                wallpaper.width = width;
                wallpaper.height = height;
                this.saveSettingsLocked(userId);
                if (this.mCurrentUserId != userId) {
                    return;
                }
                if (wallpaper.connection != null) {
                    if (wallpaper.connection.mEngine != null) {
                        try {
                            wallpaper.connection.mEngine.setDesiredSize(width, height);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        this.notifyCallbacksLocked(wallpaper);
                    } else if (wallpaper.connection.mService != null) {
                        wallpaper.connection.mDimensionsChanged = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidthHint() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(UserHandle.getCallingUserId());
            if (wallpaper != null) {
                return wallpaper.width;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeightHint() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(UserHandle.getCallingUserId());
            if (wallpaper != null) {
                return wallpaper.height;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplayPadding(Rect padding, String callingPackage) {
        this.checkPermission("android.permission.SET_WALLPAPER_HINTS");
        if (!this.isWallpaperSupported(callingPackage)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getCallingUserId();
            WallpaperData wallpaper = this.getWallpaperSafeLocked(userId, 1);
            if (padding.left < 0 || padding.top < 0 || padding.right < 0 || padding.bottom < 0) {
                throw new IllegalArgumentException("padding must be positive: " + padding);
            }
            if (!padding.equals(wallpaper.padding)) {
                wallpaper.padding.set(padding);
                this.saveSettingsLocked(userId);
                if (this.mCurrentUserId != userId) {
                    return;
                }
                if (wallpaper.connection != null) {
                    if (wallpaper.connection.mEngine != null) {
                        try {
                            wallpaper.connection.mEngine.setDisplayPadding(padding);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        this.notifyCallbacksLocked(wallpaper);
                    } else if (wallpaper.connection.mService != null) {
                        wallpaper.connection.mPaddingChanged = true;
                    }
                }
            }
        }
    }

    private void enforceCallingOrSelfPermissionAndAppOp(String permission2, String callingPkg, int callingUid, String message) {
        int appOpMode;
        this.mContext.enforceCallingOrSelfPermission(permission2, message);
        String opName = AppOpsManager.permissionToOp(permission2);
        if (opName != null && (appOpMode = this.mAppOpsManager.noteOp(opName, callingUid, callingPkg)) != 0) {
            throw new SecurityException(message + ": " + callingPkg + " is not allowed to " + permission2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor getWallpaper(String callingPkg, IWallpaperManagerCallback cb, int which, Bundle outParams, int wallpaperUserId) {
        int hasPrivilege = this.mContext.checkCallingOrSelfPermission("android.permission.READ_WALLPAPER_INTERNAL");
        if (hasPrivilege != 0) {
            this.enforceCallingOrSelfPermissionAndAppOp("android.permission.READ_EXTERNAL_STORAGE", callingPkg, Binder.getCallingUid(), "read wallpaper");
        }
        wallpaperUserId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), wallpaperUserId, false, true, "getWallpaper", null);
        if (which != 1 && which != 2) {
            throw new IllegalArgumentException("Must specify exactly one kind of wallpaper to read");
        }
        Object object = this.mLock;
        synchronized (object) {
            SparseArray<WallpaperData> whichSet = which == 2 ? this.mLockWallpaperMap : this.mWallpaperMap;
            WallpaperData wallpaper = whichSet.get(wallpaperUserId);
            if (wallpaper == null) {
                return null;
            }
            try {
                if (outParams != null) {
                    outParams.putInt("width", wallpaper.width);
                    outParams.putInt("height", wallpaper.height);
                }
                if (cb != null) {
                    wallpaper.callbacks.register(cb);
                }
                if (!wallpaper.cropFile.exists()) {
                    return null;
                }
                return ParcelFileDescriptor.open(wallpaper.cropFile, 0x10000000);
            }
            catch (FileNotFoundException e) {
                Slog.w(TAG, "Error getting wallpaper", e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WallpaperInfo getWallpaperInfo(int userId) {
        userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "getWallpaperInfo", null);
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper != null && wallpaper.connection != null) {
                return wallpaper.connection.mInfo;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWallpaperIdForUser(int which, int userId) {
        userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "getWallpaperIdForUser", null);
        if (which != 1 && which != 2) {
            throw new IllegalArgumentException("Must specify exactly one kind of wallpaper");
        }
        SparseArray<WallpaperData> map = which == 2 ? this.mLockWallpaperMap : this.mWallpaperMap;
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper = map.get(userId);
            if (wallpaper != null) {
                return wallpaper.wallpaperId;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWallpaperColorsCallback(IWallpaperManagerCallback cb, int userId) {
        userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, true, "registerWallpaperColorsCallback", null);
        Object object = this.mLock;
        synchronized (object) {
            RemoteCallbackList<IWallpaperManagerCallback> userColorsChangedListeners = this.mColorsChangedListeners.get(userId);
            if (userColorsChangedListeners == null) {
                userColorsChangedListeners = new RemoteCallbackList();
                this.mColorsChangedListeners.put(userId, userColorsChangedListeners);
            }
            userColorsChangedListeners.register(cb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterWallpaperColorsCallback(IWallpaperManagerCallback cb, int userId) {
        userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, true, "unregisterWallpaperColorsCallback", null);
        Object object = this.mLock;
        synchronized (object) {
            RemoteCallbackList<IWallpaperManagerCallback> userColorsChangedListeners = this.mColorsChangedListeners.get(userId);
            if (userColorsChangedListeners != null) {
                userColorsChangedListeners.unregister(cb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setLockWallpaperCallback(IWallpaperManagerCallback cb) {
        this.checkPermission("android.permission.INTERNAL_SYSTEM_WINDOW");
        Object object = this.mLock;
        synchronized (object) {
            this.mKeyguardListener = cb;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WallpaperColors getWallpaperColors(int which, int userId) throws RemoteException {
        boolean shouldExtract;
        if (which != 2 && which != 1) {
            throw new IllegalArgumentException("which should be either FLAG_LOCK or FLAG_SYSTEM");
        }
        userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "getWallpaperColors", null);
        WallpaperData wallpaperData = null;
        Object object = this.mLock;
        synchronized (object) {
            if (which == 2) {
                wallpaperData = this.mLockWallpaperMap.get(userId);
            }
            if (wallpaperData == null) {
                wallpaperData = this.mWallpaperMap.get(userId);
            }
            if (wallpaperData == null) {
                return null;
            }
            shouldExtract = wallpaperData.primaryColors == null;
        }
        if (shouldExtract) {
            this.extractColors(wallpaperData);
        }
        object = this.mLock;
        synchronized (object) {
            return wallpaperData.primaryColors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor setWallpaper(String name, String callingPackage, Rect cropHint, boolean allowBackup, Bundle extras, int which, IWallpaperManagerCallback completion, int userId) {
        userId = ActivityManager.handleIncomingUser(WallpaperManagerService.getCallingPid(), WallpaperManagerService.getCallingUid(), userId, false, true, "changing wallpaper", null);
        this.checkPermission("android.permission.SET_WALLPAPER");
        if ((which & 3) == 0) {
            String msg = "Must specify a valid wallpaper category to set";
            Slog.e(TAG, "Must specify a valid wallpaper category to set");
            throw new IllegalArgumentException("Must specify a valid wallpaper category to set");
        }
        if (!this.isWallpaperSupported(callingPackage) || !this.isSetWallpaperAllowed(callingPackage)) {
            return null;
        }
        if (cropHint == null) {
            cropHint = new Rect(0, 0, 0, 0);
        } else if (cropHint.isEmpty() || cropHint.left < 0 || cropHint.top < 0) {
            throw new IllegalArgumentException("Invalid crop rect supplied: " + cropHint);
        }
        Object object = this.mLock;
        synchronized (object) {
            ParcelFileDescriptor parcelFileDescriptor;
            if (which == 1 && this.mLockWallpaperMap.get(userId) == null) {
                this.migrateSystemToLockWallpaperLocked(userId);
            }
            WallpaperData wallpaper = this.getWallpaperSafeLocked(userId, which);
            long ident = Binder.clearCallingIdentity();
            try {
                ParcelFileDescriptor pfd = this.updateWallpaperBitmapLocked(name, wallpaper, extras);
                if (pfd != null) {
                    wallpaper.imageWallpaperPending = true;
                    wallpaper.whichPending = which;
                    wallpaper.setComplete = completion;
                    wallpaper.cropHint.set(cropHint);
                    wallpaper.allowBackup = allowBackup;
                }
                parcelFileDescriptor = pfd;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return parcelFileDescriptor;
        }
    }

    private void migrateSystemToLockWallpaperLocked(int userId) {
        WallpaperData sysWP = this.mWallpaperMap.get(userId);
        if (sysWP == null) {
            return;
        }
        WallpaperData lockWP = new WallpaperData(userId, WALLPAPER_LOCK_ORIG, WALLPAPER_LOCK_CROP);
        lockWP.wallpaperId = sysWP.wallpaperId;
        lockWP.cropHint.set(sysWP.cropHint);
        lockWP.width = sysWP.width;
        lockWP.height = sysWP.height;
        lockWP.allowBackup = sysWP.allowBackup;
        lockWP.primaryColors = sysWP.primaryColors;
        try {
            Os.rename(sysWP.wallpaperFile.getAbsolutePath(), lockWP.wallpaperFile.getAbsolutePath());
            Os.rename(sysWP.cropFile.getAbsolutePath(), lockWP.cropFile.getAbsolutePath());
        }
        catch (ErrnoException e) {
            Slog.e(TAG, "Can't migrate system wallpaper: " + e.getMessage());
            lockWP.wallpaperFile.delete();
            lockWP.cropFile.delete();
            return;
        }
        this.mLockWallpaperMap.put(userId, lockWP);
    }

    ParcelFileDescriptor updateWallpaperBitmapLocked(String name, WallpaperData wallpaper, Bundle extras) {
        if (name == null) {
            name = "";
        }
        try {
            File dir = WallpaperManagerService.getWallpaperDir(wallpaper.userId);
            if (!dir.exists()) {
                dir.mkdir();
                FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
            }
            ParcelFileDescriptor fd = ParcelFileDescriptor.open(wallpaper.wallpaperFile, 0x3C000000);
            if (!SELinux.restorecon(wallpaper.wallpaperFile)) {
                return null;
            }
            wallpaper.name = name;
            wallpaper.wallpaperId = this.makeWallpaperIdLocked();
            if (extras != null) {
                extras.putInt("android.service.wallpaper.extra.ID", wallpaper.wallpaperId);
            }
            wallpaper.primaryColors = null;
            return fd;
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "Error setting wallpaper", e);
            return null;
        }
    }

    @Override
    public void setWallpaperComponentChecked(ComponentName name, String callingPackage, int userId) {
        if (this.isWallpaperSupported(callingPackage) && this.isSetWallpaperAllowed(callingPackage)) {
            this.setWallpaperComponent(name, userId);
        }
    }

    @Override
    public void setWallpaperComponent(ComponentName name) {
        this.setWallpaperComponent(name, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWallpaperComponent(ComponentName name, int userId) {
        WallpaperData wallpaper;
        userId = ActivityManager.handleIncomingUser(WallpaperManagerService.getCallingPid(), WallpaperManagerService.getCallingUid(), userId, false, true, "changing live wallpaper", null);
        this.checkPermission("android.permission.SET_WALLPAPER_COMPONENT");
        int which = 1;
        boolean shouldNotifyColors = false;
        Object object = this.mLock;
        synchronized (object) {
            wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper == null) {
                throw new IllegalStateException("Wallpaper not yet initialized for user " + userId);
            }
            long ident = Binder.clearCallingIdentity();
            if (this.mImageWallpaper.equals(wallpaper.wallpaperComponent) && this.mLockWallpaperMap.get(userId) == null) {
                this.migrateSystemToLockWallpaperLocked(userId);
            }
            if (this.mLockWallpaperMap.get(userId) == null) {
                which |= 2;
            }
            try {
                wallpaper.imageWallpaperPending = false;
                boolean same = this.changingToSame(name, wallpaper);
                if (this.bindWallpaperComponentLocked(name, false, true, wallpaper, null)) {
                    if (!same) {
                        wallpaper.primaryColors = null;
                    }
                    wallpaper.wallpaperId = this.makeWallpaperIdLocked();
                    this.notifyCallbacksLocked(wallpaper);
                    shouldNotifyColors = true;
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        if (shouldNotifyColors) {
            this.notifyWallpaperColorsChanged(wallpaper, which);
        }
    }

    private boolean changingToSame(ComponentName componentName, WallpaperData wallpaper) {
        return wallpaper.connection != null && (wallpaper.wallpaperComponent == null ? componentName == null : wallpaper.wallpaperComponent.equals(componentName));
    }

    boolean bindWallpaperComponentLocked(ComponentName componentName, boolean force, boolean fromUser, WallpaperData wallpaper, IRemoteCallback reply) {
        Slog.v(TAG, "bindWallpaperComponentLocked: componentName=" + componentName);
        if (!force && this.changingToSame(componentName, wallpaper)) {
            return true;
        }
        try {
            int serviceUserId;
            ServiceInfo si;
            if (componentName == null && (componentName = this.mDefaultWallpaperComponent) == null) {
                componentName = this.mImageWallpaper;
                Slog.v(TAG, "No default component; using image wallpaper");
            }
            if ((si = this.mIPackageManager.getServiceInfo(componentName, 4224, serviceUserId = wallpaper.userId)) == null) {
                Slog.w(TAG, "Attempted wallpaper " + componentName + " is unavailable");
                return false;
            }
            if (!"android.permission.BIND_WALLPAPER".equals(si.permission)) {
                String msg = "Selected service does not require android.permission.BIND_WALLPAPER: " + componentName;
                if (fromUser) {
                    throw new SecurityException(msg);
                }
                Slog.w(TAG, msg);
                return false;
            }
            WallpaperInfo wi = null;
            Intent intent = new Intent("android.service.wallpaper.WallpaperService");
            if (componentName != null && !componentName.equals(this.mImageWallpaper)) {
                List ris = this.mIPackageManager.queryIntentServices(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 128, serviceUserId).getList();
                for (int i = 0; i < ris.size(); ++i) {
                    ServiceInfo rsi = ((ResolveInfo)ris.get((int)i)).serviceInfo;
                    if (!rsi.name.equals(si.name) || !rsi.packageName.equals(si.packageName)) continue;
                    try {
                        wi = new WallpaperInfo(this.mContext, (ResolveInfo)ris.get(i));
                        break;
                    }
                    catch (XmlPullParserException e) {
                        if (fromUser) {
                            throw new IllegalArgumentException(e);
                        }
                        Slog.w(TAG, e);
                        return false;
                    }
                    catch (IOException e) {
                        if (fromUser) {
                            throw new IllegalArgumentException(e);
                        }
                        Slog.w(TAG, e);
                        return false;
                    }
                }
                if (wi == null) {
                    String msg = "Selected service is not a wallpaper: " + componentName;
                    if (fromUser) {
                        throw new SecurityException(msg);
                    }
                    Slog.w(TAG, msg);
                    return false;
                }
            }
            WallpaperConnection newConn = new WallpaperConnection(wi, wallpaper);
            intent.setComponent(componentName);
            intent.putExtra("android.intent.extra.client_label", 17040941);
            intent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivityAsUser(this.mContext, 0, Intent.createChooser(new Intent("android.intent.action.SET_WALLPAPER"), this.mContext.getText(17039612)), 0, null, new UserHandle(serviceUserId)));
            if (!this.mContext.bindServiceAsUser(intent, newConn, 0x22000001, new UserHandle(serviceUserId))) {
                String msg = "Unable to bind service: " + componentName;
                if (fromUser) {
                    throw new IllegalArgumentException(msg);
                }
                Slog.w(TAG, msg);
                return false;
            }
            if (wallpaper.userId == this.mCurrentUserId && this.mLastWallpaper != null) {
                this.detachWallpaperLocked(this.mLastWallpaper);
            }
            wallpaper.wallpaperComponent = componentName;
            wallpaper.connection = newConn;
            newConn.mReply = reply;
            try {
                if (wallpaper.userId == this.mCurrentUserId) {
                    this.mIWindowManager.addWindowToken(newConn.mToken, 2013, 0);
                    this.mLastWallpaper = wallpaper;
                }
            }
            catch (RemoteException remoteException) {}
        }
        catch (RemoteException e) {
            String msg = "Remote exception for " + componentName + "\n" + e;
            if (fromUser) {
                throw new IllegalArgumentException(msg);
            }
            Slog.w(TAG, msg);
            return false;
        }
        return true;
    }

    void detachWallpaperLocked(WallpaperData wallpaper) {
        if (wallpaper.connection != null) {
            if (wallpaper.connection.mReply != null) {
                try {
                    wallpaper.connection.mReply.sendResult(null);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                wallpaper.connection.mReply = null;
            }
            if (wallpaper.connection.mEngine != null) {
                try {
                    wallpaper.connection.mEngine.destroy();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mContext.unbindService(wallpaper.connection);
            try {
                this.mIWindowManager.removeWindowToken(wallpaper.connection.mToken, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            wallpaper.connection.mService = null;
            wallpaper.connection.mEngine = null;
            wallpaper.connection = null;
        }
    }

    void clearWallpaperComponentLocked(WallpaperData wallpaper) {
        wallpaper.wallpaperComponent = null;
        this.detachWallpaperLocked(wallpaper);
    }

    void attachServiceLocked(WallpaperConnection conn, WallpaperData wallpaper) {
        block2: {
            try {
                conn.mService.attach(conn, conn.mToken, 2013, false, wallpaper.width, wallpaper.height, wallpaper.padding);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed attaching wallpaper; clearing", e);
                if (wallpaper.wallpaperUpdating) break block2;
                this.bindWallpaperComponentLocked(null, false, false, wallpaper, null);
            }
        }
    }

    private void notifyCallbacksLocked(WallpaperData wallpaper) {
        int n = wallpaper.callbacks.beginBroadcast();
        for (int i = 0; i < n; ++i) {
            try {
                ((IWallpaperManagerCallback)wallpaper.callbacks.getBroadcastItem(i)).onWallpaperChanged();
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        wallpaper.callbacks.finishBroadcast();
        Intent intent = new Intent("android.intent.action.WALLPAPER_CHANGED");
        this.mContext.sendBroadcastAsUser(intent, new UserHandle(this.mCurrentUserId));
    }

    private void checkPermission(String permission2) {
        if (0 != this.mContext.checkCallingOrSelfPermission(permission2)) {
            throw new SecurityException("Access denied to process: " + Binder.getCallingPid() + ", must have permission " + permission2);
        }
    }

    @Override
    public boolean isWallpaperSupported(String callingPackage) {
        return this.mAppOpsManager.checkOpNoThrow(48, Binder.getCallingUid(), callingPackage) == 0;
    }

    @Override
    public boolean isSetWallpaperAllowed(String callingPackage) {
        PackageManager pm = this.mContext.getPackageManager();
        String[] uidPackages = pm.getPackagesForUid(Binder.getCallingUid());
        boolean uidMatchPackage = Arrays.asList(uidPackages).contains(callingPackage);
        if (!uidMatchPackage) {
            return false;
        }
        DevicePolicyManager dpm = this.mContext.getSystemService(DevicePolicyManager.class);
        if (dpm.isDeviceOwnerApp(callingPackage) || dpm.isProfileOwnerApp(callingPackage)) {
            return true;
        }
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        return !um.hasUserRestriction("no_set_wallpaper");
    }

    @Override
    public boolean isWallpaperBackupEligible(int which, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call isWallpaperBackupEligible");
        }
        WallpaperData wallpaper = which == 2 ? this.mLockWallpaperMap.get(userId) : this.mWallpaperMap.get(userId);
        return wallpaper != null ? wallpaper.allowBackup : false;
    }

    private static JournaledFile makeJournaledFile(int userId) {
        String base = new File(WallpaperManagerService.getWallpaperDir(userId), WALLPAPER_INFO).getAbsolutePath();
        return new JournaledFile(new File(base), new File(base + ".tmp"));
    }

    private void saveSettingsLocked(int userId) {
        JournaledFile journal = WallpaperManagerService.makeJournaledFile(userId);
        FileOutputStream fstream = null;
        BufferedOutputStream stream = null;
        try {
            FastXmlSerializer out = new FastXmlSerializer();
            fstream = new FileOutputStream(journal.chooseForWrite(), false);
            stream = new BufferedOutputStream(fstream);
            out.setOutput(stream, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            WallpaperData wallpaper = this.mWallpaperMap.get(userId);
            if (wallpaper != null) {
                this.writeWallpaperAttributes(out, "wp", wallpaper);
            }
            if ((wallpaper = this.mLockWallpaperMap.get(userId)) != null) {
                this.writeWallpaperAttributes(out, "kwp", wallpaper);
            }
            out.endDocument();
            stream.flush();
            FileUtils.sync(fstream);
            stream.close();
            journal.commit();
        }
        catch (IOException e) {
            IoUtils.closeQuietly(stream);
            journal.rollback();
        }
    }

    private void writeWallpaperAttributes(XmlSerializer out, String tag, WallpaperData wallpaper) throws IllegalArgumentException, IllegalStateException, IOException {
        out.startTag(null, tag);
        out.attribute(null, "id", Integer.toString(wallpaper.wallpaperId));
        out.attribute(null, "width", Integer.toString(wallpaper.width));
        out.attribute(null, "height", Integer.toString(wallpaper.height));
        out.attribute(null, "cropLeft", Integer.toString(wallpaper.cropHint.left));
        out.attribute(null, "cropTop", Integer.toString(wallpaper.cropHint.top));
        out.attribute(null, "cropRight", Integer.toString(wallpaper.cropHint.right));
        out.attribute(null, "cropBottom", Integer.toString(wallpaper.cropHint.bottom));
        if (wallpaper.padding.left != 0) {
            out.attribute(null, "paddingLeft", Integer.toString(wallpaper.padding.left));
        }
        if (wallpaper.padding.top != 0) {
            out.attribute(null, "paddingTop", Integer.toString(wallpaper.padding.top));
        }
        if (wallpaper.padding.right != 0) {
            out.attribute(null, "paddingRight", Integer.toString(wallpaper.padding.right));
        }
        if (wallpaper.padding.bottom != 0) {
            out.attribute(null, "paddingBottom", Integer.toString(wallpaper.padding.bottom));
        }
        if (wallpaper.primaryColors != null) {
            int colorsCount = wallpaper.primaryColors.getMainColors().size();
            out.attribute(null, "colorsCount", Integer.toString(colorsCount));
            if (colorsCount > 0) {
                for (int i = 0; i < colorsCount; ++i) {
                    Color wc = wallpaper.primaryColors.getMainColors().get(i);
                    out.attribute(null, "colorValue" + i, Integer.toString(wc.toArgb()));
                }
            }
            out.attribute(null, "colorHints", Integer.toString(wallpaper.primaryColors.getColorHints()));
        }
        out.attribute(null, "name", wallpaper.name);
        if (wallpaper.wallpaperComponent != null && !wallpaper.wallpaperComponent.equals(this.mImageWallpaper)) {
            out.attribute(null, "component", wallpaper.wallpaperComponent.flattenToShortString());
        }
        if (wallpaper.allowBackup) {
            out.attribute(null, "backup", "true");
        }
        out.endTag(null, tag);
    }

    private void migrateFromOld() {
        File preNWallpaper = new File(WallpaperManagerService.getWallpaperDir(0), WALLPAPER_CROP);
        File originalWallpaper = new File("/data/data/com.android.settings/files/wallpaper");
        File newWallpaper = new File(WallpaperManagerService.getWallpaperDir(0), WALLPAPER);
        if (preNWallpaper.exists()) {
            if (!newWallpaper.exists()) {
                FileUtils.copyFile(preNWallpaper, newWallpaper);
            }
        } else if (originalWallpaper.exists()) {
            File oldInfo = new File("/data/system/wallpaper_info.xml");
            if (oldInfo.exists()) {
                File newInfo = new File(WallpaperManagerService.getWallpaperDir(0), WALLPAPER_INFO);
                oldInfo.renameTo(newInfo);
            }
            FileUtils.copyFile(originalWallpaper, preNWallpaper);
            originalWallpaper.renameTo(newWallpaper);
        }
    }

    private int getAttributeInt(XmlPullParser parser, String name, int defValue) {
        String value = parser.getAttributeValue(null, name);
        if (value == null) {
            return defValue;
        }
        return Integer.parseInt(value);
    }

    private WallpaperData getWallpaperSafeLocked(int userId, int which) {
        SparseArray<WallpaperData> whichSet = which == 2 ? this.mLockWallpaperMap : this.mWallpaperMap;
        WallpaperData wallpaper = whichSet.get(userId);
        if (wallpaper == null) {
            this.loadSettingsLocked(userId, false);
            wallpaper = whichSet.get(userId);
            if (wallpaper == null) {
                if (which == 2) {
                    wallpaper = new WallpaperData(userId, WALLPAPER_LOCK_ORIG, WALLPAPER_LOCK_CROP);
                    this.mLockWallpaperMap.put(userId, wallpaper);
                    this.ensureSaneWallpaperData(wallpaper);
                } else {
                    Slog.wtf(TAG, "Didn't find wallpaper in non-lock case!");
                    wallpaper = new WallpaperData(userId, WALLPAPER, WALLPAPER_CROP);
                    this.mWallpaperMap.put(userId, wallpaper);
                    this.ensureSaneWallpaperData(wallpaper);
                }
            }
        }
        return wallpaper;
    }

    private void loadSettingsLocked(int userId, boolean keepDimensionHints) {
        JournaledFile journal = WallpaperManagerService.makeJournaledFile(userId);
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        WallpaperData wallpaper = this.mWallpaperMap.get(userId);
        if (wallpaper == null) {
            this.migrateFromOld();
            wallpaper = new WallpaperData(userId, WALLPAPER, WALLPAPER_CROP);
            wallpaper.allowBackup = true;
            this.mWallpaperMap.put(userId, wallpaper);
            if (!wallpaper.cropExists()) {
                if (wallpaper.sourceExists()) {
                    this.generateCrop(wallpaper);
                } else {
                    Slog.i(TAG, "No static wallpaper imagery; defaults will be shown");
                }
            }
        }
        boolean success = false;
        try {
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            do {
                if ((type = parser.next()) != 2) continue;
                String tag = parser.getName();
                if ("wp".equals(tag)) {
                    this.parseWallpaperAttributes(parser, wallpaper, keepDimensionHints);
                    String comp = parser.getAttributeValue(null, "component");
                    ComponentName componentName = wallpaper.nextWallpaperComponent = comp != null ? ComponentName.unflattenFromString(comp) : null;
                    if (wallpaper.nextWallpaperComponent != null && !"android".equals(wallpaper.nextWallpaperComponent.getPackageName())) continue;
                    wallpaper.nextWallpaperComponent = this.mImageWallpaper;
                    continue;
                }
                if (!"kwp".equals(tag)) continue;
                WallpaperData lockWallpaper = this.mLockWallpaperMap.get(userId);
                if (lockWallpaper == null) {
                    lockWallpaper = new WallpaperData(userId, WALLPAPER_LOCK_ORIG, WALLPAPER_LOCK_CROP);
                    this.mLockWallpaperMap.put(userId, lockWallpaper);
                }
                this.parseWallpaperAttributes(parser, lockWallpaper, false);
            } while (type != 1);
            success = true;
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "no current wallpaper -- first boot?");
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "failed parsing " + file + " " + e);
        }
        IoUtils.closeQuietly(stream);
        if (!success) {
            wallpaper.width = -1;
            wallpaper.height = -1;
            wallpaper.cropHint.set(0, 0, 0, 0);
            wallpaper.padding.set(0, 0, 0, 0);
            wallpaper.name = "";
            this.mLockWallpaperMap.remove(userId);
        } else if (wallpaper.wallpaperId <= 0) {
            wallpaper.wallpaperId = this.makeWallpaperIdLocked();
        }
        this.ensureSaneWallpaperData(wallpaper);
        WallpaperData lockWallpaper = this.mLockWallpaperMap.get(userId);
        if (lockWallpaper != null) {
            this.ensureSaneWallpaperData(lockWallpaper);
        }
    }

    private void ensureSaneWallpaperData(WallpaperData wallpaper) {
        int baseSize = this.getMaximumSizeDimension();
        if (wallpaper.width < baseSize) {
            wallpaper.width = baseSize;
        }
        if (wallpaper.height < baseSize) {
            wallpaper.height = baseSize;
        }
        if (wallpaper.cropHint.width() <= 0 || wallpaper.cropHint.height() <= 0) {
            wallpaper.cropHint.set(0, 0, wallpaper.width, wallpaper.height);
        }
    }

    private void parseWallpaperAttributes(XmlPullParser parser, WallpaperData wallpaper, boolean keepDimensionHints) {
        String idString = parser.getAttributeValue(null, "id");
        if (idString != null) {
            wallpaper.wallpaperId = Integer.parseInt(idString);
            int id2 = wallpaper.wallpaperId;
            if (id2 > this.mWallpaperId) {
                this.mWallpaperId = id2;
            }
        } else {
            wallpaper.wallpaperId = this.makeWallpaperIdLocked();
        }
        if (!keepDimensionHints) {
            wallpaper.width = Integer.parseInt(parser.getAttributeValue(null, "width"));
            wallpaper.height = Integer.parseInt(parser.getAttributeValue(null, "height"));
        }
        wallpaper.cropHint.left = this.getAttributeInt(parser, "cropLeft", 0);
        wallpaper.cropHint.top = this.getAttributeInt(parser, "cropTop", 0);
        wallpaper.cropHint.right = this.getAttributeInt(parser, "cropRight", 0);
        wallpaper.cropHint.bottom = this.getAttributeInt(parser, "cropBottom", 0);
        wallpaper.padding.left = this.getAttributeInt(parser, "paddingLeft", 0);
        wallpaper.padding.top = this.getAttributeInt(parser, "paddingTop", 0);
        wallpaper.padding.right = this.getAttributeInt(parser, "paddingRight", 0);
        wallpaper.padding.bottom = this.getAttributeInt(parser, "paddingBottom", 0);
        int colorsCount = this.getAttributeInt(parser, "colorsCount", 0);
        if (colorsCount > 0) {
            Color primary = null;
            Color secondary = null;
            Color tertiary = null;
            for (int i = 0; i < colorsCount; ++i) {
                Color color2 = Color.valueOf(this.getAttributeInt(parser, "colorValue" + i, 0));
                if (i == 0) {
                    primary = color2;
                    continue;
                }
                if (i == 1) {
                    secondary = color2;
                    continue;
                }
                if (i != 2) break;
                tertiary = color2;
            }
            int colorHints = this.getAttributeInt(parser, "colorHints", 0);
            wallpaper.primaryColors = new WallpaperColors(primary, secondary, tertiary, colorHints);
        }
        wallpaper.name = parser.getAttributeValue(null, "name");
        wallpaper.allowBackup = "true".equals(parser.getAttributeValue(null, "backup"));
    }

    private int getMaximumSizeDimension() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display d = wm.getDefaultDisplay();
        return d.getMaximumSizeDimension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingsRestored() {
        if (Binder.getCallingUid() != 1000) {
            throw new RuntimeException("settingsRestored() can only be called from the system process");
        }
        WallpaperData wallpaper = null;
        boolean success = false;
        Object object = this.mLock;
        synchronized (object) {
            this.loadSettingsLocked(0, false);
            wallpaper = this.mWallpaperMap.get(0);
            wallpaper.wallpaperId = this.makeWallpaperIdLocked();
            wallpaper.allowBackup = true;
            if (wallpaper.nextWallpaperComponent != null && !wallpaper.nextWallpaperComponent.equals(this.mImageWallpaper)) {
                if (!this.bindWallpaperComponentLocked(wallpaper.nextWallpaperComponent, false, false, wallpaper, null)) {
                    this.bindWallpaperComponentLocked(null, false, false, wallpaper, null);
                }
                success = true;
            } else {
                success = "".equals(wallpaper.name) ? true : this.restoreNamedResourceLocked(wallpaper);
                if (success) {
                    this.generateCrop(wallpaper);
                    this.bindWallpaperComponentLocked(wallpaper.nextWallpaperComponent, true, false, wallpaper, null);
                }
            }
        }
        if (!success) {
            Slog.e(TAG, "Failed to restore wallpaper: '" + wallpaper.name + "'");
            wallpaper.name = "";
            WallpaperManagerService.getWallpaperDir(0).delete();
        }
        object = this.mLock;
        synchronized (object) {
            this.saveSettingsLocked(0);
        }
    }

    /*
     * Exception decompiling
     */
    boolean restoreNamedResourceLocked(WallpaperData wallpaper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            WallpaperData wallpaper;
            int i;
            pw.println("System wallpaper state:");
            for (i = 0; i < this.mWallpaperMap.size(); ++i) {
                wallpaper = this.mWallpaperMap.valueAt(i);
                pw.print(" User ");
                pw.print(wallpaper.userId);
                pw.print(": id=");
                pw.println(wallpaper.wallpaperId);
                pw.print("  mWidth=");
                pw.print(wallpaper.width);
                pw.print(" mHeight=");
                pw.println(wallpaper.height);
                pw.print("  mCropHint=");
                pw.println(wallpaper.cropHint);
                pw.print("  mPadding=");
                pw.println(wallpaper.padding);
                pw.print("  mName=");
                pw.println(wallpaper.name);
                pw.print("  mAllowBackup=");
                pw.println(wallpaper.allowBackup);
                pw.print("  mWallpaperComponent=");
                pw.println(wallpaper.wallpaperComponent);
                if (wallpaper.connection == null) continue;
                WallpaperConnection conn = wallpaper.connection;
                pw.print("  Wallpaper connection ");
                pw.print(conn);
                pw.println(":");
                if (conn.mInfo != null) {
                    pw.print("    mInfo.component=");
                    pw.println(conn.mInfo.getComponent());
                }
                pw.print("    mToken=");
                pw.println(conn.mToken);
                pw.print("    mService=");
                pw.println(conn.mService);
                pw.print("    mEngine=");
                pw.println(conn.mEngine);
                pw.print("    mLastDiedTime=");
                pw.println(wallpaper.lastDiedTime - SystemClock.uptimeMillis());
            }
            pw.println("Lock wallpaper state:");
            for (i = 0; i < this.mLockWallpaperMap.size(); ++i) {
                wallpaper = this.mLockWallpaperMap.valueAt(i);
                pw.print(" User ");
                pw.print(wallpaper.userId);
                pw.print(": id=");
                pw.println(wallpaper.wallpaperId);
                pw.print("  mWidth=");
                pw.print(wallpaper.width);
                pw.print(" mHeight=");
                pw.println(wallpaper.height);
                pw.print("  mCropHint=");
                pw.println(wallpaper.cropHint);
                pw.print("  mPadding=");
                pw.println(wallpaper.padding);
                pw.print("  mName=");
                pw.println(wallpaper.name);
                pw.print("  mAllowBackup=");
                pw.println(wallpaper.allowBackup);
            }
        }
    }

    class MyPackageMonitor
    extends PackageMonitor {
        MyPackageMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageUpdateFinished(String packageName, int uid) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                ComponentName wpService;
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null && (wpService = wallpaper.wallpaperComponent) != null && wpService.getPackageName().equals(packageName)) {
                    Slog.i(WallpaperManagerService.TAG, "Wallpaper " + wpService + " update has finished");
                    wallpaper.wallpaperUpdating = false;
                    WallpaperManagerService.this.clearWallpaperComponentLocked(wallpaper);
                    if (!WallpaperManagerService.this.bindWallpaperComponentLocked(wpService, false, false, wallpaper, null)) {
                        Slog.w(WallpaperManagerService.TAG, "Wallpaper " + wpService + " no longer available; reverting to default");
                        WallpaperManagerService.this.clearWallpaperLocked(false, 1, wallpaper.userId, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageModified(String packageName) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null) {
                    if (wallpaper.wallpaperComponent == null || !wallpaper.wallpaperComponent.getPackageName().equals(packageName)) {
                        return;
                    }
                    this.doPackagesChangedLocked(true, wallpaper);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageUpdateStarted(String packageName, int uid) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null && wallpaper.wallpaperComponent != null && wallpaper.wallpaperComponent.getPackageName().equals(packageName)) {
                    Slog.i(WallpaperManagerService.TAG, "Wallpaper service " + wallpaper.wallpaperComponent + " is updating");
                    wallpaper.wallpaperUpdating = true;
                    if (wallpaper.connection != null) {
                        FgThread.getHandler().removeCallbacks(wallpaper.connection.mResetRunnable);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                boolean changed = false;
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return false;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null) {
                    boolean res = this.doPackagesChangedLocked(doit, wallpaper);
                    changed |= res;
                }
                return changed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSomePackagesChanged() {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mCurrentUserId != this.getChangingUserId()) {
                    return;
                }
                WallpaperData wallpaper = WallpaperManagerService.this.mWallpaperMap.get(WallpaperManagerService.this.mCurrentUserId);
                if (wallpaper != null) {
                    this.doPackagesChangedLocked(true, wallpaper);
                }
            }
        }

        boolean doPackagesChangedLocked(boolean doit, WallpaperData wallpaper) {
            int change;
            boolean changed = false;
            if (wallpaper.wallpaperComponent != null && ((change = this.isPackageDisappearing(wallpaper.wallpaperComponent.getPackageName())) == 3 || change == 2)) {
                changed = true;
                if (doit) {
                    Slog.w(WallpaperManagerService.TAG, "Wallpaper uninstalled, removing: " + wallpaper.wallpaperComponent);
                    WallpaperManagerService.this.clearWallpaperLocked(false, 1, wallpaper.userId, null);
                }
            }
            if (wallpaper.nextWallpaperComponent != null && ((change = this.isPackageDisappearing(wallpaper.nextWallpaperComponent.getPackageName())) == 3 || change == 2)) {
                wallpaper.nextWallpaperComponent = null;
            }
            if (wallpaper.wallpaperComponent != null && this.isPackageModified(wallpaper.wallpaperComponent.getPackageName())) {
                try {
                    WallpaperManagerService.this.mContext.getPackageManager().getServiceInfo(wallpaper.wallpaperComponent, 786432);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.w(WallpaperManagerService.TAG, "Wallpaper component gone, removing: " + wallpaper.wallpaperComponent);
                    WallpaperManagerService.this.clearWallpaperLocked(false, 1, wallpaper.userId, null);
                }
            }
            if (wallpaper.nextWallpaperComponent != null && this.isPackageModified(wallpaper.nextWallpaperComponent.getPackageName())) {
                try {
                    WallpaperManagerService.this.mContext.getPackageManager().getServiceInfo(wallpaper.nextWallpaperComponent, 786432);
                }
                catch (PackageManager.NameNotFoundException e) {
                    wallpaper.nextWallpaperComponent = null;
                }
            }
            return changed;
        }
    }

    class WallpaperConnection
    extends IWallpaperConnection.Stub
    implements ServiceConnection {
        private static final long WALLPAPER_RECONNECT_TIMEOUT_MS = 10000L;
        final WallpaperInfo mInfo;
        final Binder mToken = new Binder();
        IWallpaperService mService;
        IWallpaperEngine mEngine;
        WallpaperData mWallpaper;
        IRemoteCallback mReply;
        boolean mDimensionsChanged = false;
        boolean mPaddingChanged = false;
        private Runnable mResetRunnable = () -> {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mShuttingDown) {
                    Slog.i(WallpaperManagerService.TAG, "Ignoring relaunch timeout during shutdown");
                    return;
                }
                if (!this.mWallpaper.wallpaperUpdating && this.mWallpaper.userId == WallpaperManagerService.this.mCurrentUserId) {
                    Slog.w(WallpaperManagerService.TAG, "Wallpaper reconnect timed out for " + this.mWallpaper.wallpaperComponent + ", reverting to built-in wallpaper!");
                    WallpaperManagerService.this.clearWallpaperLocked(true, 1, this.mWallpaper.userId, null);
                }
            }
        };

        public WallpaperConnection(WallpaperInfo info, WallpaperData wallpaper) {
            this.mInfo = info;
            this.mWallpaper = wallpaper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (this.mWallpaper.connection == this) {
                    this.mService = IWallpaperService.Stub.asInterface(service);
                    WallpaperManagerService.this.attachServiceLocked(this, this.mWallpaper);
                    WallpaperManagerService.this.saveSettingsLocked(this.mWallpaper.userId);
                    FgThread.getHandler().removeCallbacks(this.mResetRunnable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                Slog.w(WallpaperManagerService.TAG, "Wallpaper service gone: " + name);
                if (!Objects.equals(name, this.mWallpaper.wallpaperComponent)) {
                    Slog.e(WallpaperManagerService.TAG, "Does not match expected wallpaper component " + this.mWallpaper.wallpaperComponent);
                }
                this.mService = null;
                this.mEngine = null;
                if (this.mWallpaper.connection == this && !this.mWallpaper.wallpaperUpdating) {
                    WallpaperManagerService.this.mContext.getMainThreadHandler().postDelayed(() -> this.processDisconnect(this), 1000L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processDisconnect(ServiceConnection connection) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (connection == this.mWallpaper.connection) {
                    ComponentName wpService = this.mWallpaper.wallpaperComponent;
                    if (!(this.mWallpaper.wallpaperUpdating || this.mWallpaper.userId != WallpaperManagerService.this.mCurrentUserId || Objects.equals(WallpaperManagerService.this.mDefaultWallpaperComponent, wpService) || Objects.equals(WallpaperManagerService.this.mImageWallpaper, wpService))) {
                        if (this.mWallpaper.lastDiedTime != 0L && this.mWallpaper.lastDiedTime + 10000L > SystemClock.uptimeMillis()) {
                            Slog.w(WallpaperManagerService.TAG, "Reverting to built-in wallpaper!");
                            WallpaperManagerService.this.clearWallpaperLocked(true, 1, this.mWallpaper.userId, null);
                        } else {
                            this.mWallpaper.lastDiedTime = SystemClock.uptimeMillis();
                            Handler fgHandler = FgThread.getHandler();
                            fgHandler.removeCallbacks(this.mResetRunnable);
                            fgHandler.postDelayed(this.mResetRunnable, 10000L);
                            Slog.i(WallpaperManagerService.TAG, "Started wallpaper reconnect timeout for " + wpService);
                        }
                        String flattened = wpService.flattenToString();
                        EventLog.writeEvent(33000, flattened.substring(0, Math.min(flattened.length(), 128)));
                    }
                } else {
                    Slog.i(WallpaperManagerService.TAG, "Wallpaper changed during disconnect tracking; ignoring");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWallpaperColorsChanged(WallpaperColors primaryColors) {
            int which;
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (WallpaperManagerService.this.mImageWallpaper.equals(this.mWallpaper.wallpaperComponent)) {
                    return;
                }
                this.mWallpaper.primaryColors = primaryColors;
                which = 1;
                WallpaperData lockedWallpaper = WallpaperManagerService.this.mLockWallpaperMap.get(this.mWallpaper.userId);
                if (lockedWallpaper == null) {
                    which |= 2;
                }
            }
            if (which != 0) {
                WallpaperManagerService.this.notifyWallpaperColorsChanged(this.mWallpaper, which);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attachEngine(IWallpaperEngine engine) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                this.mEngine = engine;
                if (this.mDimensionsChanged) {
                    try {
                        this.mEngine.setDesiredSize(this.mWallpaper.width, this.mWallpaper.height);
                    }
                    catch (RemoteException e) {
                        Slog.w(WallpaperManagerService.TAG, "Failed to set wallpaper dimensions", e);
                    }
                    this.mDimensionsChanged = false;
                }
                if (this.mPaddingChanged) {
                    try {
                        this.mEngine.setDisplayPadding(this.mWallpaper.padding);
                    }
                    catch (RemoteException e) {
                        Slog.w(WallpaperManagerService.TAG, "Failed to set wallpaper padding", e);
                    }
                    this.mPaddingChanged = false;
                }
                try {
                    this.mEngine.requestWallpaperColors();
                }
                catch (RemoteException e) {
                    Slog.w(WallpaperManagerService.TAG, "Failed to request wallpaper colors", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void engineShown(IWallpaperEngine engine) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (this.mReply != null) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mReply.sendResult(null);
                    }
                    catch (RemoteException e) {
                        Binder.restoreCallingIdentity(ident);
                    }
                    this.mReply = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParcelFileDescriptor setWallpaper(String name) {
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (this.mWallpaper.connection == this) {
                    return WallpaperManagerService.this.updateWallpaperBitmapLocked(name, this.mWallpaper, null);
                }
                return null;
            }
        }
    }

    static class WallpaperData {
        int userId;
        final File wallpaperFile;
        final File cropFile;
        boolean imageWallpaperPending;
        int whichPending;
        IWallpaperManagerCallback setComplete;
        boolean allowBackup;
        String name = "";
        ComponentName wallpaperComponent;
        ComponentName nextWallpaperComponent;
        int wallpaperId;
        WallpaperColors primaryColors;
        WallpaperConnection connection;
        long lastDiedTime;
        boolean wallpaperUpdating;
        WallpaperObserver wallpaperObserver;
        private RemoteCallbackList<IWallpaperManagerCallback> callbacks = new RemoteCallbackList();
        int width = -1;
        int height = -1;
        final Rect cropHint = new Rect(0, 0, 0, 0);
        final Rect padding = new Rect(0, 0, 0, 0);

        WallpaperData(int userId, String inputFileName, String cropFileName) {
            this.userId = userId;
            File wallpaperDir = WallpaperManagerService.getWallpaperDir(userId);
            this.wallpaperFile = new File(wallpaperDir, inputFileName);
            this.cropFile = new File(wallpaperDir, cropFileName);
        }

        boolean cropExists() {
            return this.cropFile.exists();
        }

        boolean sourceExists() {
            return this.wallpaperFile.exists();
        }
    }

    private class WallpaperObserver
    extends FileObserver {
        final int mUserId;
        final WallpaperData mWallpaper;
        final File mWallpaperDir;
        final File mWallpaperFile;
        final File mWallpaperLockFile;

        public WallpaperObserver(WallpaperData wallpaper) {
            super(WallpaperManagerService.getWallpaperDir(wallpaper.userId).getAbsolutePath(), 1672);
            this.mUserId = wallpaper.userId;
            this.mWallpaperDir = WallpaperManagerService.getWallpaperDir(wallpaper.userId);
            this.mWallpaper = wallpaper;
            this.mWallpaperFile = new File(this.mWallpaperDir, WallpaperManagerService.WALLPAPER);
            this.mWallpaperLockFile = new File(this.mWallpaperDir, WallpaperManagerService.WALLPAPER_LOCK_ORIG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private WallpaperData dataForEvent(boolean sysChanged, boolean lockChanged) {
            WallpaperData wallpaper = null;
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (lockChanged) {
                    wallpaper = WallpaperManagerService.this.mLockWallpaperMap.get(this.mUserId);
                }
                if (wallpaper == null) {
                    wallpaper = WallpaperManagerService.this.mWallpaperMap.get(this.mUserId);
                }
            }
            return wallpaper != null ? wallpaper : this.mWallpaper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(int event, String path) {
            if (path == null) {
                return;
            }
            boolean moved = event == 128;
            boolean written = event == 8 || moved;
            File changedFile = new File(this.mWallpaperDir, path);
            boolean sysWallpaperChanged = this.mWallpaperFile.equals(changedFile);
            boolean lockWallpaperChanged = this.mWallpaperLockFile.equals(changedFile);
            int notifyColorsWhich = 0;
            WallpaperData wallpaper = this.dataForEvent(sysWallpaperChanged, lockWallpaperChanged);
            if (moved && lockWallpaperChanged) {
                SELinux.restorecon(changedFile);
                WallpaperManagerService.this.notifyLockWallpaperChanged();
                WallpaperManagerService.this.notifyWallpaperColorsChanged(wallpaper, 2);
                return;
            }
            Object object = WallpaperManagerService.this.mLock;
            synchronized (object) {
                if (sysWallpaperChanged || lockWallpaperChanged) {
                    WallpaperManagerService.this.notifyCallbacksLocked(wallpaper);
                    if ((wallpaper.wallpaperComponent == null || event != 8 || wallpaper.imageWallpaperPending) && written) {
                        SELinux.restorecon(changedFile);
                        if (moved) {
                            WallpaperManagerService.this.loadSettingsLocked(wallpaper.userId, true);
                        }
                        WallpaperManagerService.this.generateCrop(wallpaper);
                        wallpaper.imageWallpaperPending = false;
                        if (sysWallpaperChanged) {
                            WallpaperManagerService.this.bindWallpaperComponentLocked(WallpaperManagerService.this.mImageWallpaper, true, false, wallpaper, null);
                            notifyColorsWhich |= 1;
                        }
                        if (lockWallpaperChanged || (wallpaper.whichPending & 2) != 0) {
                            if (!lockWallpaperChanged) {
                                WallpaperManagerService.this.mLockWallpaperMap.remove(wallpaper.userId);
                            }
                            WallpaperManagerService.this.notifyLockWallpaperChanged();
                            notifyColorsWhich |= 2;
                        }
                        WallpaperManagerService.this.saveSettingsLocked(wallpaper.userId);
                        if (wallpaper.setComplete != null) {
                            try {
                                wallpaper.setComplete.onWallpaperChanged();
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (notifyColorsWhich != 0) {
                WallpaperManagerService.this.notifyWallpaperColorsChanged(wallpaper, notifyColorsWhich);
            }
        }
    }

    public static class Lifecycle
    extends SystemService {
        private WallpaperManagerService mService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            this.mService = new WallpaperManagerService(this.getContext());
            this.publishBinderService(WallpaperManagerService.WALLPAPER_CROP, this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 550) {
                this.mService.systemReady();
            } else if (phase == 600) {
                this.mService.switchUser(0, null);
            }
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mService.onUnlockUser(userHandle);
        }
    }
}

