/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.AnimationHandler;
import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.util.ArrayMap;
import android.view.WindowManagerInternal;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.server.wm.AppTransition;
import com.android.server.wm.BoundsAnimationTarget;
import com.android.server.wm.WindowManagerService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BoundsAnimationController {
    private static final boolean DEBUG_LOCAL = false;
    private static final boolean DEBUG = false;
    private static final String TAG = "WindowManager";
    private static final int DEBUG_ANIMATION_SLOW_DOWN_FACTOR = 1;
    private static final int DEFAULT_TRANSITION_DURATION = 425;
    public static final int NO_PIP_MODE_CHANGED_CALLBACKS = 0;
    public static final int SCHEDULE_PIP_MODE_CHANGED_ON_START = 1;
    public static final int SCHEDULE_PIP_MODE_CHANGED_ON_END = 2;
    private ArrayMap<BoundsAnimationTarget, BoundsAnimator> mRunningAnimations = new ArrayMap();
    private final Handler mHandler;
    private final AppTransition mAppTransition;
    private final AppTransitionNotifier mAppTransitionNotifier = new AppTransitionNotifier();
    private final Interpolator mFastOutSlowInInterpolator;
    private boolean mFinishAnimationAfterTransition = false;
    private final AnimationHandler mAnimationHandler;
    private static final int WAIT_FOR_DRAW_TIMEOUT_MS = 3000;

    BoundsAnimationController(Context context, AppTransition transition2, Handler handler, AnimationHandler animationHandler) {
        this.mHandler = handler;
        this.mAppTransition = transition2;
        this.mAppTransition.registerListenerLocked(this.mAppTransitionNotifier);
        this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.mAnimationHandler = animationHandler;
    }

    public void animateBounds(BoundsAnimationTarget target, Rect from, Rect to, int animationDuration, int schedulePipModeChangedState, boolean moveFromFullscreen, boolean moveToFullscreen) {
        this.animateBoundsImpl(target, from, to, animationDuration, schedulePipModeChangedState, moveFromFullscreen, moveToFullscreen);
    }

    BoundsAnimator animateBoundsImpl(BoundsAnimationTarget target, Rect from, Rect to, int animationDuration, int schedulePipModeChangedState, boolean moveFromFullscreen, boolean moveToFullscreen) {
        BoundsAnimator existing = this.mRunningAnimations.get(target);
        boolean replacing = existing != null;
        int prevSchedulePipModeChangedState = 0;
        if (replacing) {
            if (existing.isAnimatingTo(to)) {
                return existing;
            }
            prevSchedulePipModeChangedState = existing.mSchedulePipModeChangedState;
            if (existing.mSchedulePipModeChangedState == 1) {
                if (schedulePipModeChangedState != 1) {
                    schedulePipModeChangedState = 2;
                }
            } else if (existing.mSchedulePipModeChangedState == 2 && schedulePipModeChangedState != 1) {
                schedulePipModeChangedState = 2;
            }
            existing.cancel();
        }
        BoundsAnimator animator2 = new BoundsAnimator(target, from, to, schedulePipModeChangedState, prevSchedulePipModeChangedState, moveFromFullscreen, moveToFullscreen);
        this.mRunningAnimations.put(target, animator2);
        animator2.setFloatValues(0.0f, 1.0f);
        animator2.setDuration((animationDuration != -1 ? animationDuration : 425) * 1);
        animator2.setInterpolator(this.mFastOutSlowInInterpolator);
        animator2.start();
        return animator2;
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public void onAllWindowsDrawn() {
        this.mHandler.post(this::resume);
    }

    private void resume() {
        for (int i = 0; i < this.mRunningAnimations.size(); ++i) {
            BoundsAnimator b = this.mRunningAnimations.valueAt(i);
            b.resume();
        }
    }

    private void updateBooster() {
        WindowManagerService.sThreadPriorityBooster.setBoundsAnimationRunning(!this.mRunningAnimations.isEmpty());
    }

    final class BoundsAnimator
    extends ValueAnimator
    implements ValueAnimator.AnimatorUpdateListener,
    Animator.AnimatorListener {
        private final BoundsAnimationTarget mTarget;
        private final Rect mFrom = new Rect();
        private final Rect mTo = new Rect();
        private final Rect mTmpRect = new Rect();
        private final Rect mTmpTaskBounds = new Rect();
        private boolean mSkipFinalResize;
        private boolean mSkipAnimationEnd;
        private boolean mMoveFromFullscreen;
        private boolean mMoveToFullscreen;
        private int mSchedulePipModeChangedState;
        private int mPrevSchedulePipModeChangedState;
        private final int mFrozenTaskWidth;
        private final int mFrozenTaskHeight;
        private final Runnable mResumeRunnable = () -> this.resume();

        BoundsAnimator(BoundsAnimationTarget target, Rect from, Rect to, int schedulePipModeChangedState, int prevShedulePipModeChangedState, boolean moveFromFullscreen, boolean moveToFullscreen) {
            this.mTarget = target;
            this.mFrom.set(from);
            this.mTo.set(to);
            this.mSchedulePipModeChangedState = schedulePipModeChangedState;
            this.mPrevSchedulePipModeChangedState = prevShedulePipModeChangedState;
            this.mMoveFromFullscreen = moveFromFullscreen;
            this.mMoveToFullscreen = moveToFullscreen;
            this.addUpdateListener(this);
            this.addListener(this);
            if (this.animatingToLargerSize()) {
                this.mFrozenTaskWidth = this.mTo.width();
                this.mFrozenTaskHeight = this.mTo.height();
            } else {
                this.mFrozenTaskWidth = this.mFrom.width();
                this.mFrozenTaskHeight = this.mFrom.height();
            }
        }

        @Override
        public void onAnimationStart(Animator animation) {
            BoundsAnimationController.this.mFinishAnimationAfterTransition = false;
            this.mTmpRect.set(this.mFrom.left, this.mFrom.top, this.mFrom.left + this.mFrozenTaskWidth, this.mFrom.top + this.mFrozenTaskHeight);
            BoundsAnimationController.this.updateBooster();
            if (this.mPrevSchedulePipModeChangedState == 0) {
                this.mTarget.onAnimationStart(this.mSchedulePipModeChangedState == 1, false);
                if (this.mMoveFromFullscreen) {
                    this.pause();
                }
            } else if (this.mPrevSchedulePipModeChangedState == 2 && this.mSchedulePipModeChangedState == 1) {
                this.mTarget.onAnimationStart(true, true);
            }
            if (this.animatingToLargerSize()) {
                this.mTarget.setPinnedStackSize(this.mFrom, this.mTmpRect);
                if (this.mMoveToFullscreen) {
                    this.pause();
                }
            }
        }

        @Override
        public void pause() {
            super.pause();
            BoundsAnimationController.this.mHandler.postDelayed(this.mResumeRunnable, 3000L);
        }

        @Override
        public void resume() {
            BoundsAnimationController.this.mHandler.removeCallbacks(this.mResumeRunnable);
            super.resume();
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            float remains = 1.0f - value;
            this.mTmpRect.left = (int)((float)this.mFrom.left * remains + (float)this.mTo.left * value + 0.5f);
            this.mTmpRect.top = (int)((float)this.mFrom.top * remains + (float)this.mTo.top * value + 0.5f);
            this.mTmpRect.right = (int)((float)this.mFrom.right * remains + (float)this.mTo.right * value + 0.5f);
            this.mTmpRect.bottom = (int)((float)this.mFrom.bottom * remains + (float)this.mTo.bottom * value + 0.5f);
            this.mTmpTaskBounds.set(this.mTmpRect.left, this.mTmpRect.top, this.mTmpRect.left + this.mFrozenTaskWidth, this.mTmpRect.top + this.mFrozenTaskHeight);
            if (!this.mTarget.setPinnedStackSize(this.mTmpRect, this.mTmpTaskBounds)) {
                if (this.mSchedulePipModeChangedState == 1) {
                    this.mSchedulePipModeChangedState = 2;
                }
                this.cancelAndCallAnimationEnd();
            }
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            if (BoundsAnimationController.this.mAppTransition.isRunning() && !BoundsAnimationController.this.mFinishAnimationAfterTransition) {
                BoundsAnimationController.this.mFinishAnimationAfterTransition = true;
                return;
            }
            if (!this.mSkipAnimationEnd) {
                this.mTarget.onAnimationEnd(this.mSchedulePipModeChangedState == 2, !this.mSkipFinalResize ? this.mTo : null, this.mMoveToFullscreen);
            }
            this.removeListener(this);
            this.removeUpdateListener(this);
            BoundsAnimationController.this.mRunningAnimations.remove(this.mTarget);
            BoundsAnimationController.this.updateBooster();
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            this.mSkipFinalResize = true;
            this.mMoveToFullscreen = false;
        }

        private void cancelAndCallAnimationEnd() {
            this.mSkipAnimationEnd = false;
            super.cancel();
        }

        @Override
        public void cancel() {
            this.mSkipAnimationEnd = true;
            super.cancel();
        }

        boolean isAnimatingTo(Rect bounds) {
            return this.mTo.equals(bounds);
        }

        boolean animatingToLargerSize() {
            return this.mFrom.width() * this.mFrom.height() <= this.mTo.width() * this.mTo.height();
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }

        @Override
        public AnimationHandler getAnimationHandler() {
            if (BoundsAnimationController.this.mAnimationHandler != null) {
                return BoundsAnimationController.this.mAnimationHandler;
            }
            return super.getAnimationHandler();
        }
    }

    private final class AppTransitionNotifier
    extends WindowManagerInternal.AppTransitionListener
    implements Runnable {
        private AppTransitionNotifier() {
        }

        public void onAppTransitionCancelledLocked() {
            this.animationFinished();
        }

        @Override
        public void onAppTransitionFinishedLocked(IBinder token) {
            this.animationFinished();
        }

        private void animationFinished() {
            if (BoundsAnimationController.this.mFinishAnimationAfterTransition) {
                BoundsAnimationController.this.mHandler.removeCallbacks(this);
                BoundsAnimationController.this.mHandler.post(this);
            }
        }

        @Override
        public void run() {
            for (int i = 0; i < BoundsAnimationController.this.mRunningAnimations.size(); ++i) {
                BoundsAnimator b = (BoundsAnimator)BoundsAnimationController.this.mRunningAnimations.valueAt(i);
                b.onAnimationEnd(null);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SchedulePipModeChangedState {
    }
}

