/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.TypedValue;
import com.android.server.wm.DimLayer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowStateAnimator;
import java.io.PrintWriter;

class DimLayerController {
    private static final String TAG_LOCAL = "DimLayerController";
    private static final String TAG = "WindowManager";
    private static final int DEFAULT_DIM_DURATION = 200;
    private static final float DEFAULT_DIM_AMOUNT_DEAD_WINDOW = 0.5f;
    private DimLayer mSharedFullScreenDimLayer;
    private ArrayMap<DimLayer.DimLayerUser, DimLayerState> mState = new ArrayMap();
    private DisplayContent mDisplayContent;
    private Rect mTmpBounds = new Rect();

    DimLayerController(DisplayContent displayContent) {
        this.mDisplayContent = displayContent;
    }

    void updateDimLayer(DimLayer.DimLayerUser dimLayerUser) {
        DimLayer newDimLayer;
        DimLayerState state = this.getOrCreateDimLayerState(dimLayerUser);
        boolean previousFullscreen = state.dimLayer != null && state.dimLayer == this.mSharedFullScreenDimLayer;
        int displayId = this.mDisplayContent.getDisplayId();
        if (dimLayerUser.dimFullscreen()) {
            if (previousFullscreen && this.mSharedFullScreenDimLayer != null) {
                this.mSharedFullScreenDimLayer.setBoundsForFullscreen();
                return;
            }
            newDimLayer = this.mSharedFullScreenDimLayer;
            if (newDimLayer == null) {
                newDimLayer = state.dimLayer != null ? state.dimLayer : new DimLayer(this.mDisplayContent.mService, dimLayerUser, displayId, DimLayerController.getDimLayerTag(dimLayerUser));
                dimLayerUser.getDimBounds(this.mTmpBounds);
                newDimLayer.setBounds(this.mTmpBounds);
                this.mSharedFullScreenDimLayer = newDimLayer;
            } else if (state.dimLayer != null) {
                state.dimLayer.destroySurface();
            }
        } else {
            newDimLayer = state.dimLayer == null || previousFullscreen ? new DimLayer(this.mDisplayContent.mService, dimLayerUser, displayId, DimLayerController.getDimLayerTag(dimLayerUser)) : state.dimLayer;
            dimLayerUser.getDimBounds(this.mTmpBounds);
            newDimLayer.setBounds(this.mTmpBounds);
        }
        state.dimLayer = newDimLayer;
    }

    private static String getDimLayerTag(DimLayer.DimLayerUser dimLayerUser) {
        return "DimLayerController/" + dimLayerUser.toShortString();
    }

    private DimLayerState getOrCreateDimLayerState(DimLayer.DimLayerUser dimLayerUser) {
        DimLayerState state = this.mState.get(dimLayerUser);
        if (state == null) {
            state = new DimLayerState();
            this.mState.put(dimLayerUser, state);
        }
        return state;
    }

    private void setContinueDimming(DimLayer.DimLayerUser dimLayerUser) {
        DimLayerState state = this.mState.get(dimLayerUser);
        if (state == null) {
            return;
        }
        state.continueDimming = true;
    }

    boolean isDimming() {
        for (int i = this.mState.size() - 1; i >= 0; --i) {
            DimLayerState state = this.mState.valueAt(i);
            if (state.dimLayer == null || !state.dimLayer.isDimming()) continue;
            return true;
        }
        return false;
    }

    void resetDimming() {
        for (int i = this.mState.size() - 1; i >= 0; --i) {
            this.mState.valueAt((int)i).continueDimming = false;
        }
    }

    private boolean getContinueDimming(DimLayer.DimLayerUser dimLayerUser) {
        DimLayerState state = this.mState.get(dimLayerUser);
        return state != null && state.continueDimming;
    }

    void startDimmingIfNeeded(DimLayer.DimLayerUser dimLayerUser, WindowStateAnimator newWinAnimator, boolean aboveApp) {
        DimLayerState state = this.getOrCreateDimLayerState(dimLayerUser);
        state.dimAbove = aboveApp;
        if (newWinAnimator.getShown() && (state.animator == null || !state.animator.getShown() || state.animator.mAnimLayer <= newWinAnimator.mAnimLayer)) {
            state.animator = newWinAnimator;
            if (state.animator.mWin.mAppToken == null && !dimLayerUser.dimFullscreen()) {
                this.mDisplayContent.getLogicalDisplayRect(this.mTmpBounds);
            } else {
                dimLayerUser.getDimBounds(this.mTmpBounds);
            }
            state.dimLayer.setBounds(this.mTmpBounds);
        }
    }

    void stopDimmingIfNeeded() {
        for (int i = this.mState.size() - 1; i >= 0; --i) {
            DimLayer.DimLayerUser dimLayerUser = this.mState.keyAt(i);
            this.stopDimmingIfNeeded(dimLayerUser);
        }
    }

    private void stopDimmingIfNeeded(DimLayer.DimLayerUser dimLayerUser) {
        DimLayerState state = this.mState.get(dimLayerUser);
        if (state.animator != null && state.animator.mWin.mWillReplaceWindow) {
            return;
        }
        if (!state.continueDimming && state.dimLayer.isDimming()) {
            state.animator = null;
            dimLayerUser.getDimBounds(this.mTmpBounds);
            state.dimLayer.setBounds(this.mTmpBounds);
        }
    }

    boolean animateDimLayers() {
        int fullScreen = -1;
        int fullScreenAndDimming = -1;
        int topFullScreenUserLayer = 0;
        boolean result = false;
        for (int i = this.mState.size() - 1; i >= 0; --i) {
            DimLayer.DimLayerUser user = this.mState.keyAt(i);
            DimLayerState state = this.mState.valueAt(i);
            if (!user.isAttachedToDisplay()) {
                Slog.w(TAG, "Leaked dim user=" + user.toShortString() + " state=" + state);
                this.removeDimLayerUser(user);
                continue;
            }
            if (user.dimFullscreen() && state.dimLayer == this.mSharedFullScreenDimLayer) {
                fullScreen = i;
                if (!state.continueDimming || topFullScreenUserLayer != 0 && (state.animator == null || state.animator.mAnimLayer <= topFullScreenUserLayer)) continue;
                fullScreenAndDimming = i;
                if (state.animator == null) continue;
                topFullScreenUserLayer = state.animator.mAnimLayer;
                continue;
            }
            result |= this.animateDimLayers(user);
        }
        if (fullScreenAndDimming != -1) {
            result |= this.animateDimLayers(this.mState.keyAt(fullScreenAndDimming));
        } else if (fullScreen != -1) {
            result |= this.animateDimLayers(this.mState.keyAt(fullScreen));
        }
        return result;
    }

    private boolean animateDimLayers(DimLayer.DimLayerUser dimLayerUser) {
        float dimAmount;
        int dimLayer;
        DimLayerState state = this.mState.get(dimLayerUser);
        if (state.animator == null) {
            dimLayer = state.dimLayer.getLayer();
            dimAmount = 0.0f;
        } else if (state.dimAbove) {
            dimLayer = state.animator.mAnimLayer + 1;
            dimAmount = 0.5f;
        } else {
            dimLayer = dimLayerUser.getLayerForDim(state.animator, 1, state.animator.mAnimLayer - 1);
            dimAmount = state.animator.mWin.mAttrs.dimAmount;
        }
        float targetAlpha = state.dimLayer.getTargetAlpha();
        if (targetAlpha != dimAmount) {
            if (state.animator == null) {
                state.dimLayer.hide(200L);
            } else {
                long duration;
                long l = duration = state.animator.mAnimating && state.animator.mAnimation != null ? state.animator.mAnimation.computeDurationHint() : 200L;
                if (targetAlpha > dimAmount) {
                    duration = this.getDimLayerFadeDuration(duration);
                }
                state.dimLayer.show(dimLayer, dimAmount, duration);
                if (targetAlpha == 0.0f) {
                    this.mDisplayContent.pendingLayoutChanges |= 1;
                    this.mDisplayContent.setLayoutNeeded();
                }
            }
        } else if (state.dimLayer.getLayer() != dimLayer) {
            state.dimLayer.setLayer(dimLayer);
        }
        if (state.dimLayer.isAnimating()) {
            if (!this.mDisplayContent.okToAnimate()) {
                state.dimLayer.show();
            } else {
                return state.dimLayer.stepAnimation();
            }
        }
        return false;
    }

    boolean isDimming(DimLayer.DimLayerUser dimLayerUser, WindowStateAnimator winAnimator) {
        DimLayerState state = this.mState.get(dimLayerUser);
        return state != null && state.animator == winAnimator && state.dimLayer.isDimming();
    }

    private long getDimLayerFadeDuration(long duration) {
        TypedValue tv = new TypedValue();
        this.mDisplayContent.mService.mContext.getResources().getValue(0x1130001, tv, true);
        if (tv.type == 6) {
            duration = (long)tv.getFraction(duration, duration);
        } else if (tv.type >= 16 && tv.type <= 31) {
            duration = tv.data;
        }
        return duration;
    }

    void close() {
        for (int i = this.mState.size() - 1; i >= 0; --i) {
            DimLayerState state = this.mState.valueAt(i);
            state.dimLayer.destroySurface();
        }
        this.mState.clear();
        this.mSharedFullScreenDimLayer = null;
    }

    void removeDimLayerUser(DimLayer.DimLayerUser dimLayerUser) {
        DimLayerState state = this.mState.get(dimLayerUser);
        if (state != null) {
            if (state.dimLayer != this.mSharedFullScreenDimLayer) {
                state.dimLayer.destroySurface();
            }
            this.mState.remove(dimLayerUser);
        }
        if (this.mState.isEmpty()) {
            this.mSharedFullScreenDimLayer = null;
        }
    }

    boolean hasDimLayerUser(DimLayer.DimLayerUser dimLayerUser) {
        return this.mState.containsKey(dimLayerUser);
    }

    boolean hasSharedFullScreenDimLayer() {
        return this.mSharedFullScreenDimLayer != null;
    }

    void applyDimBehind(DimLayer.DimLayerUser dimLayerUser, WindowStateAnimator animator2) {
        this.applyDim(dimLayerUser, animator2, false);
    }

    void applyDimAbove(DimLayer.DimLayerUser dimLayerUser, WindowStateAnimator animator2) {
        this.applyDim(dimLayerUser, animator2, true);
    }

    void applyDim(DimLayer.DimLayerUser dimLayerUser, WindowStateAnimator animator2, boolean aboveApp) {
        if (dimLayerUser == null) {
            Slog.e(TAG, "Trying to apply dim layer for: " + this + ", but no dim layer user found.");
            return;
        }
        if (!this.getContinueDimming(dimLayerUser)) {
            this.setContinueDimming(dimLayerUser);
            if (!this.isDimming(dimLayerUser, animator2)) {
                this.startDimmingIfNeeded(dimLayerUser, animator2, aboveApp);
            }
        }
    }

    void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + TAG_LOCAL);
        String doubleSpace = "  ";
        String prefixPlusDoubleSpace = prefix + "  ";
        int n = this.mState.size();
        for (int i = 0; i < n; ++i) {
            pw.println(prefixPlusDoubleSpace + this.mState.keyAt(i).toShortString());
            DimLayerState state = this.mState.valueAt(i);
            pw.println(prefixPlusDoubleSpace + "  " + "dimLayer=" + (state.dimLayer == this.mSharedFullScreenDimLayer ? "shared" : state.dimLayer) + ", animator=" + state.animator + ", continueDimming=" + state.continueDimming);
            if (state.dimLayer == null) continue;
            state.dimLayer.printTo(prefixPlusDoubleSpace + "  ", pw);
        }
    }

    private static class DimLayerState {
        WindowStateAnimator animator;
        boolean continueDimming;
        DimLayer dimLayer;
        boolean dimAbove;

        private DimLayerState() {
        }
    }
}

