/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.Trace;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.view.BatchedInputEventReceiver;
import android.view.Choreographer;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.MotionEvent;
import com.android.server.input.InputApplicationHandle;
import com.android.server.input.InputWindowHandle;
import com.android.server.wm.DimLayer;
import com.android.server.wm.Task;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class TaskPositioner
implements DimLayer.DimLayerUser {
    private static final boolean DEBUG_ORIENTATION_VIOLATIONS = false;
    private static final String TAG_LOCAL = "TaskPositioner";
    private static final String TAG = "WindowManager";
    static final int SIDE_MARGIN_DIP = 100;
    private static final int CTRL_NONE = 0;
    private static final int CTRL_LEFT = 1;
    private static final int CTRL_RIGHT = 2;
    private static final int CTRL_TOP = 4;
    private static final int CTRL_BOTTOM = 8;
    public static final float RESIZING_HINT_ALPHA = 0.5f;
    public static final int RESIZING_HINT_DURATION_MS = 0;
    static final float MIN_ASPECT = 1.2f;
    private final WindowManagerService mService;
    private WindowPositionerEventReceiver mInputEventReceiver;
    private Display mDisplay;
    private final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    private DimLayer mDimLayer;
    private int mCurrentDimSide;
    private Rect mTmpRect = new Rect();
    private int mSideMargin;
    private int mMinVisibleWidth;
    private int mMinVisibleHeight;
    private Task mTask;
    private boolean mResizing;
    private boolean mPreserveOrientation;
    private boolean mStartOrientationWasLandscape;
    private final Rect mWindowOriginalBounds = new Rect();
    private final Rect mWindowDragBounds = new Rect();
    private final Point mMaxVisibleSize = new Point();
    private float mStartDragX;
    private float mStartDragY;
    private int mCtrlType = 0;
    private boolean mDragEnded = false;
    InputChannel mServerChannel;
    InputChannel mClientChannel;
    InputApplicationHandle mDragApplicationHandle;
    InputWindowHandle mDragWindowHandle;

    TaskPositioner(WindowManagerService service) {
        this.mService = service;
    }

    Rect getWindowDragBounds() {
        return this.mWindowDragBounds;
    }

    void register(Display display) {
        if (this.mClientChannel != null) {
            Slog.e(TAG, "Task positioner already registered");
            return;
        }
        this.mDisplay = display;
        this.mDisplay.getMetrics(this.mDisplayMetrics);
        InputChannel[] channels = InputChannel.openInputChannelPair(TAG);
        this.mServerChannel = channels[0];
        this.mClientChannel = channels[1];
        this.mService.mInputManager.registerInputChannel(this.mServerChannel, null);
        this.mInputEventReceiver = new WindowPositionerEventReceiver(this.mClientChannel, this.mService.mAnimationHandler.getLooper(), this.mService.mAnimator.getChoreographer());
        this.mDragApplicationHandle = new InputApplicationHandle(null);
        this.mDragApplicationHandle.name = TAG;
        this.mDragApplicationHandle.dispatchingTimeoutNanos = 5000000000L;
        this.mDragWindowHandle = new InputWindowHandle(this.mDragApplicationHandle, null, null, this.mDisplay.getDisplayId());
        this.mDragWindowHandle.name = TAG;
        this.mDragWindowHandle.inputChannel = this.mServerChannel;
        this.mDragWindowHandle.layer = this.mService.getDragLayerLocked();
        this.mDragWindowHandle.layoutParamsFlags = 0;
        this.mDragWindowHandle.layoutParamsType = 2016;
        this.mDragWindowHandle.dispatchingTimeoutNanos = 5000000000L;
        this.mDragWindowHandle.visible = true;
        this.mDragWindowHandle.canReceiveKeys = false;
        this.mDragWindowHandle.hasFocus = true;
        this.mDragWindowHandle.hasWallpaper = false;
        this.mDragWindowHandle.paused = false;
        this.mDragWindowHandle.ownerPid = Process.myPid();
        this.mDragWindowHandle.ownerUid = Process.myUid();
        this.mDragWindowHandle.inputFeatures = 0;
        this.mDragWindowHandle.scaleFactor = 1.0f;
        this.mDragWindowHandle.touchableRegion.setEmpty();
        this.mDragWindowHandle.frameLeft = 0;
        this.mDragWindowHandle.frameTop = 0;
        Point p = new Point();
        this.mDisplay.getRealSize(p);
        this.mDragWindowHandle.frameRight = p.x;
        this.mDragWindowHandle.frameBottom = p.y;
        this.mService.pauseRotationLocked();
        this.mDimLayer = new DimLayer(this.mService, this, this.mDisplay.getDisplayId(), TAG_LOCAL);
        this.mSideMargin = WindowManagerService.dipToPixel(100, this.mDisplayMetrics);
        this.mMinVisibleWidth = WindowManagerService.dipToPixel(48, this.mDisplayMetrics);
        this.mMinVisibleHeight = WindowManagerService.dipToPixel(32, this.mDisplayMetrics);
        this.mDisplay.getRealSize(this.mMaxVisibleSize);
        this.mDragEnded = false;
    }

    void unregister() {
        if (this.mClientChannel == null) {
            Slog.e(TAG, "Task positioner not registered");
            return;
        }
        this.mService.mInputManager.unregisterInputChannel(this.mServerChannel);
        this.mInputEventReceiver.dispose();
        this.mInputEventReceiver = null;
        this.mClientChannel.dispose();
        this.mServerChannel.dispose();
        this.mClientChannel = null;
        this.mServerChannel = null;
        this.mDragWindowHandle = null;
        this.mDragApplicationHandle = null;
        this.mDisplay = null;
        if (this.mDimLayer != null) {
            this.mDimLayer.destroySurface();
            this.mDimLayer = null;
        }
        this.mCurrentDimSide = 0;
        this.mDragEnded = true;
        this.mService.resumeRotationLocked();
    }

    void startDrag(WindowState win, boolean resize, boolean preserveOrientation, float startX, float startY) {
        this.mTask = win.getTask();
        this.mTask.getDimBounds(this.mTmpRect);
        this.startDrag(resize, preserveOrientation, startX, startY, this.mTmpRect);
    }

    void startDrag(boolean resize, boolean preserveOrientation, float startX, float startY, Rect startBounds) {
        this.mCtrlType = 0;
        this.mStartDragX = startX;
        this.mStartDragY = startY;
        this.mPreserveOrientation = preserveOrientation;
        if (resize) {
            if (startX < (float)startBounds.left) {
                this.mCtrlType |= 1;
            }
            if (startX > (float)startBounds.right) {
                this.mCtrlType |= 2;
            }
            if (startY < (float)startBounds.top) {
                this.mCtrlType |= 4;
            }
            if (startY > (float)startBounds.bottom) {
                this.mCtrlType |= 8;
            }
            this.mResizing = this.mCtrlType != 0;
        }
        this.mStartOrientationWasLandscape = startBounds.width() >= startBounds.height();
        this.mWindowOriginalBounds.set(startBounds);
        this.mWindowDragBounds.set(startBounds);
    }

    private void endDragLocked() {
        this.mResizing = false;
        this.mTask.setDragResizing(false, 0);
    }

    private boolean notifyMoveLocked(float x, float y) {
        if (this.mCtrlType != 0) {
            this.resizeDrag(x, y);
            this.mTask.setDragResizing(true, 0);
            return false;
        }
        this.mTask.mStack.getDimBounds(this.mTmpRect);
        int nX = (int)x;
        int nY = (int)y;
        if (!this.mTmpRect.contains(nX, nY)) {
            nX = Math.min(Math.max(nX, this.mTmpRect.left), this.mTmpRect.right);
            nY = Math.min(Math.max(nY, this.mTmpRect.top), this.mTmpRect.bottom);
        }
        this.updateWindowDragBounds(nX, nY, this.mTmpRect);
        this.updateDimLayerVisibility(nX);
        return false;
    }

    void resizeDrag(float x, float y) {
        int deltaX = Math.round(x - this.mStartDragX);
        int deltaY = Math.round(y - this.mStartDragY);
        int left = this.mWindowOriginalBounds.left;
        int top = this.mWindowOriginalBounds.top;
        int right = this.mWindowOriginalBounds.right;
        int bottom = this.mWindowOriginalBounds.bottom;
        float minAspect = !this.mPreserveOrientation ? 1.0f : (this.mStartOrientationWasLandscape ? 1.2f : 0.8333333f);
        int width = right - left;
        int height = bottom - top;
        if ((this.mCtrlType & 1) != 0) {
            width = Math.max(this.mMinVisibleWidth, width - deltaX);
        } else if ((this.mCtrlType & 2) != 0) {
            width = Math.max(this.mMinVisibleWidth, width + deltaX);
        }
        if ((this.mCtrlType & 4) != 0) {
            height = Math.max(this.mMinVisibleHeight, height - deltaY);
        } else if ((this.mCtrlType & 8) != 0) {
            height = Math.max(this.mMinVisibleHeight, height + deltaY);
        }
        float aspect = (float)width / (float)height;
        if (this.mPreserveOrientation && (this.mStartOrientationWasLandscape && aspect < 1.2f || !this.mStartOrientationWasLandscape && (double)aspect > 0.8333333002196431)) {
            boolean grows;
            int height2;
            int width2;
            int height1;
            int width1;
            if (this.mStartOrientationWasLandscape) {
                width1 = Math.max(this.mMinVisibleWidth, Math.min(this.mMaxVisibleSize.x, width));
                height1 = Math.min(height, Math.round((float)width1 / 1.2f));
                if (height1 < this.mMinVisibleHeight) {
                    height1 = this.mMinVisibleHeight;
                    width1 = Math.max(this.mMinVisibleWidth, Math.min(this.mMaxVisibleSize.x, Math.round((float)height1 * 1.2f)));
                }
                if ((width2 = Math.max(width, Math.round((float)(height2 = Math.max(this.mMinVisibleHeight, Math.min(this.mMaxVisibleSize.y, height))) * 1.2f))) < this.mMinVisibleWidth) {
                    width2 = this.mMinVisibleWidth;
                    height2 = Math.max(this.mMinVisibleHeight, Math.min(this.mMaxVisibleSize.y, Math.round((float)width2 / 1.2f)));
                }
            } else {
                width1 = Math.max(this.mMinVisibleWidth, Math.min(this.mMaxVisibleSize.x, width));
                height1 = Math.max(height, Math.round((float)width1 * 1.2f));
                if (height1 < this.mMinVisibleHeight) {
                    height1 = this.mMinVisibleHeight;
                    width1 = Math.max(this.mMinVisibleWidth, Math.min(this.mMaxVisibleSize.x, Math.round((float)height1 / 1.2f)));
                }
                if ((width2 = Math.min(width, Math.round((float)(height2 = Math.max(this.mMinVisibleHeight, Math.min(this.mMaxVisibleSize.y, height))) / 1.2f))) < this.mMinVisibleWidth) {
                    width2 = this.mMinVisibleWidth;
                    height2 = Math.max(this.mMinVisibleHeight, Math.min(this.mMaxVisibleSize.y, Math.round((float)width2 * 1.2f)));
                }
            }
            if ((grows = width > right - left || height > bottom - top) == width1 * height1 > width2 * height2) {
                width = width1;
                height = height1;
            } else {
                width = width2;
                height = height2;
            }
        }
        this.updateDraggedBounds(left, top, right, bottom, width, height);
    }

    void updateDraggedBounds(int left, int top, int right, int bottom, int newWidth, int newHeight) {
        if ((this.mCtrlType & 1) != 0) {
            left = right - newWidth;
        } else {
            right = left + newWidth;
        }
        if ((this.mCtrlType & 4) != 0) {
            top = bottom - newHeight;
        } else {
            bottom = top + newHeight;
        }
        this.mWindowDragBounds.set(left, top, right, bottom);
        this.checkBoundsForOrientationViolations(this.mWindowDragBounds);
    }

    private void checkBoundsForOrientationViolations(Rect bounds) {
    }

    private void updateWindowDragBounds(int x, int y, Rect stackBounds) {
        int offsetX = Math.round((float)x - this.mStartDragX);
        int offsetY = Math.round((float)y - this.mStartDragY);
        this.mWindowDragBounds.set(this.mWindowOriginalBounds);
        int maxLeft = stackBounds.right - this.mMinVisibleWidth;
        int minLeft = stackBounds.left + this.mMinVisibleWidth - this.mWindowOriginalBounds.width();
        int minTop = stackBounds.top;
        int maxTop = stackBounds.bottom - this.mMinVisibleHeight;
        this.mWindowDragBounds.offsetTo(Math.min(Math.max(this.mWindowOriginalBounds.left + offsetX, minLeft), maxLeft), Math.min(Math.max(this.mWindowOriginalBounds.top + offsetY, minTop), maxTop));
    }

    private void updateDimLayerVisibility(int x) {
        int dimSide = this.getDimSide(x);
        if (dimSide == this.mCurrentDimSide) {
            return;
        }
        this.mCurrentDimSide = dimSide;
        this.mService.openSurfaceTransaction();
        if (this.mCurrentDimSide == 0) {
            this.mDimLayer.hide();
        } else {
            this.showDimLayer();
        }
        this.mService.closeSurfaceTransaction();
    }

    private int getDimSide(int x) {
        if (this.mTask.mStack.mStackId != 2 || !this.mTask.mStack.fillsParent() || this.mTask.mStack.getConfiguration().orientation != 2) {
            return 0;
        }
        this.mTask.mStack.getDimBounds(this.mTmpRect);
        if (x - this.mSideMargin <= this.mTmpRect.left) {
            return 1;
        }
        if (x + this.mSideMargin >= this.mTmpRect.right) {
            return 2;
        }
        return 0;
    }

    private void showDimLayer() {
        this.mTask.mStack.getDimBounds(this.mTmpRect);
        if (this.mCurrentDimSide == 1) {
            this.mTmpRect.right = this.mTmpRect.centerX();
        } else if (this.mCurrentDimSide == 2) {
            this.mTmpRect.left = this.mTmpRect.centerX();
        }
        this.mDimLayer.setBounds(this.mTmpRect);
        this.mDimLayer.show(this.mService.getDragLayerLocked(), 0.5f, 0L);
    }

    @Override
    public boolean dimFullscreen() {
        return this.isFullscreen();
    }

    boolean isFullscreen() {
        return false;
    }

    @Override
    public DisplayInfo getDisplayInfo() {
        return this.mTask.mStack.getDisplayInfo();
    }

    @Override
    public boolean isAttachedToDisplay() {
        return this.mTask != null && this.mTask.getDisplayContent() != null;
    }

    @Override
    public void getDimBounds(Rect out) {
    }

    @Override
    public String toShortString() {
        return TAG;
    }

    private final class WindowPositionerEventReceiver
    extends BatchedInputEventReceiver {
        public WindowPositionerEventReceiver(InputChannel inputChannel, Looper looper, Choreographer choreographer) {
            super(inputChannel, looper, choreographer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInputEvent(InputEvent event, int displayId) {
            if (!(event instanceof MotionEvent) || (event.getSource() & 2) == 0) {
                return;
            }
            MotionEvent motionEvent = (MotionEvent)event;
            boolean handled = false;
            try {
                if (TaskPositioner.this.mDragEnded) {
                    handled = true;
                    return;
                }
                float newX = motionEvent.getRawX();
                float newY = motionEvent.getRawY();
                switch (motionEvent.getAction()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        WindowHashMap windowHashMap = ((TaskPositioner)TaskPositioner.this).mService.mWindowMap;
                        synchronized (windowHashMap) {
                            try {
                                WindowManagerService.boostPriorityForLockedSection();
                                TaskPositioner.this.mDragEnded = TaskPositioner.this.notifyMoveLocked(newX, newY);
                                TaskPositioner.this.mTask.getDimBounds(TaskPositioner.this.mTmpRect);
                                // MONITOREXIT @DISABLED, blocks:[0, 2, 7, 9, 11] lbl22 : MonitorExitStatement: MONITOREXIT : var7_8
                                WindowManagerService.resetPriorityAfterLockedSection();
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT @DISABLED, blocks:[0, 7, 9, 11, 15] lbl26 : MonitorExitStatement: MONITOREXIT : var7_8
                                WindowManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                        }
                        if (TaskPositioner.this.mTmpRect.equals(TaskPositioner.this.mWindowDragBounds)) break;
                        Trace.traceBegin(32L, "wm.TaskPositioner.resizeTask");
                        try {
                            ((TaskPositioner)TaskPositioner.this).mService.mActivityManager.resizeTask(((TaskPositioner)TaskPositioner.this).mTask.mTaskId, TaskPositioner.this.mWindowDragBounds, 1);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        Trace.traceEnd(32L);
                        break;
                    }
                    case 1: {
                        TaskPositioner.this.mDragEnded = true;
                        break;
                    }
                    case 3: {
                        TaskPositioner.this.mDragEnded = true;
                    }
                }
                if (TaskPositioner.this.mDragEnded) {
                    boolean wasResizing = TaskPositioner.this.mResizing;
                    WindowHashMap windowHashMap = ((TaskPositioner)TaskPositioner.this).mService.mWindowMap;
                    synchronized (windowHashMap) {
                        try {
                            WindowManagerService.boostPriorityForLockedSection();
                            TaskPositioner.this.endDragLocked();
                            TaskPositioner.this.mTask.getDimBounds(TaskPositioner.this.mTmpRect);
                            // MONITOREXIT @DISABLED, blocks:[0, 4, 8, 26] lbl54 : MonitorExitStatement: MONITOREXIT : var8_12
                            WindowManagerService.resetPriorityAfterLockedSection();
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[0, 17, 8, 26] lbl58 : MonitorExitStatement: MONITOREXIT : var8_12
                            WindowManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                    try {
                        if (wasResizing && !TaskPositioner.this.mTmpRect.equals(TaskPositioner.this.mWindowDragBounds)) {
                            ((TaskPositioner)TaskPositioner.this).mService.mActivityManager.resizeTask(((TaskPositioner)TaskPositioner.this).mTask.mTaskId, TaskPositioner.this.mWindowDragBounds, 3);
                        }
                        if (TaskPositioner.this.mCurrentDimSide != 0) {
                            int createMode = TaskPositioner.this.mCurrentDimSide == 1 ? 0 : 1;
                            ((TaskPositioner)TaskPositioner.this).mService.mActivityManager.moveTaskToDockedStack(((TaskPositioner)TaskPositioner.this).mTask.mTaskId, createMode, true, true, null);
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    ((TaskPositioner)TaskPositioner.this).mService.mH.sendEmptyMessage(40);
                }
                handled = true;
            }
            catch (Exception e) {
                Slog.e(TaskPositioner.TAG, "Exception caught by drag handleMotion", e);
            }
            finally {
                this.finishInputEvent(event, handled);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface CtrlType {
    }
}

