/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.os.Process;
import android.os.SystemClock;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.AtomicFile;
import com.android.server.wm.nano.WindowManagerProtos;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;

class TaskSnapshotPersister {
    private static final String TAG = "WindowManager";
    private static final String SNAPSHOTS_DIRNAME = "snapshots";
    private static final String REDUCED_POSTFIX = "_reduced";
    static final float REDUCED_SCALE = ActivityManager.isLowRamDeviceStatic() ? 0.6f : 0.5f;
    static final boolean DISABLE_FULL_SIZED_BITMAPS = ActivityManager.isLowRamDeviceStatic();
    private static final long DELAY_MS = 100L;
    private static final int QUALITY = 95;
    private static final String PROTO_EXTENSION = ".proto";
    private static final String BITMAP_EXTENSION = ".jpg";
    private static final int MAX_STORE_QUEUE_DEPTH = 2;
    @GuardedBy(value="mLock")
    private final ArrayDeque<WriteQueueItem> mWriteQueue = new ArrayDeque();
    @GuardedBy(value="mLock")
    private final ArrayDeque<StoreWriteQueueItem> mStoreQueueItems = new ArrayDeque();
    @GuardedBy(value="mLock")
    private boolean mQueueIdling;
    @GuardedBy(value="mLock")
    private boolean mPaused;
    private boolean mStarted;
    private final Object mLock = new Object();
    private final DirectoryResolver mDirectoryResolver;
    @GuardedBy(value="mLock")
    private final ArraySet<Integer> mPersistedTaskIdsSinceLastRemoveObsolete = new ArraySet();
    private Thread mPersister = new Thread("TaskSnapshotPersister"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority(10);
            while (true) {
                WriteQueueItem next;
                Object object = TaskSnapshotPersister.this.mLock;
                synchronized (object) {
                    if (TaskSnapshotPersister.this.mPaused) {
                        next = null;
                    } else {
                        next = (WriteQueueItem)TaskSnapshotPersister.this.mWriteQueue.poll();
                        if (next != null) {
                            next.onDequeuedLocked();
                        }
                    }
                }
                if (next != null) {
                    next.write();
                    SystemClock.sleep(100L);
                }
                object = TaskSnapshotPersister.this.mLock;
                synchronized (object) {
                    boolean writeQueueEmpty = TaskSnapshotPersister.this.mWriteQueue.isEmpty();
                    if (!writeQueueEmpty && !TaskSnapshotPersister.this.mPaused) {
                        continue;
                    }
                    try {
                        TaskSnapshotPersister.this.mQueueIdling = writeQueueEmpty;
                        TaskSnapshotPersister.this.mLock.wait();
                        TaskSnapshotPersister.this.mQueueIdling = false;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    };

    TaskSnapshotPersister(DirectoryResolver resolver) {
        this.mDirectoryResolver = resolver;
    }

    void start() {
        if (!this.mStarted) {
            this.mStarted = true;
            this.mPersister.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistSnapshot(int taskId, int userId, ActivityManager.TaskSnapshot snapshot) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPersistedTaskIdsSinceLastRemoveObsolete.add(taskId);
            this.sendToQueueLocked(new StoreWriteQueueItem(taskId, userId, snapshot));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTaskRemovedFromRecents(int taskId, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPersistedTaskIdsSinceLastRemoveObsolete.remove(taskId);
            this.sendToQueueLocked(new DeleteWriteQueueItem(taskId, userId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObsoleteFiles(ArraySet<Integer> persistentTaskIds, int[] runningUserIds) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPersistedTaskIdsSinceLastRemoveObsolete.clear();
            this.sendToQueueLocked(new RemoveObsoleteFilesQueueItem(persistentTaskIds, runningUserIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPaused(boolean paused) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPaused = paused;
            if (!paused) {
                this.mLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForQueueEmpty() {
        while (true) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mWriteQueue.isEmpty() && this.mQueueIdling) {
                    return;
                }
            }
            SystemClock.sleep(100L);
        }
    }

    @GuardedBy(value="mLock")
    private void sendToQueueLocked(WriteQueueItem item) {
        this.mWriteQueue.offer(item);
        item.onQueuedLocked();
        this.ensureStoreQueueDepthLocked();
        if (!this.mPaused) {
            this.mLock.notifyAll();
        }
    }

    @GuardedBy(value="mLock")
    private void ensureStoreQueueDepthLocked() {
        while (this.mStoreQueueItems.size() > 2) {
            StoreWriteQueueItem item = this.mStoreQueueItems.poll();
            this.mWriteQueue.remove(item);
            Slog.i(TAG, "Queue is too deep! Purged item with taskid=" + item.mTaskId);
        }
    }

    private File getDirectory(int userId) {
        return new File(this.mDirectoryResolver.getSystemDirectoryForUser(userId), SNAPSHOTS_DIRNAME);
    }

    File getProtoFile(int taskId, int userId) {
        return new File(this.getDirectory(userId), taskId + PROTO_EXTENSION);
    }

    File getBitmapFile(int taskId, int userId) {
        if (DISABLE_FULL_SIZED_BITMAPS) {
            Slog.wtf(TAG, "This device does not support full sized resolution bitmaps.");
            return null;
        }
        return new File(this.getDirectory(userId), taskId + BITMAP_EXTENSION);
    }

    File getReducedResolutionBitmapFile(int taskId, int userId) {
        return new File(this.getDirectory(userId), taskId + REDUCED_POSTFIX + BITMAP_EXTENSION);
    }

    private boolean createDirectory(int userId) {
        File dir = this.getDirectory(userId);
        return dir.exists() || dir.mkdirs();
    }

    private void deleteSnapshot(int taskId, int userId) {
        File protoFile = this.getProtoFile(taskId, userId);
        File bitmapReducedFile = this.getReducedResolutionBitmapFile(taskId, userId);
        protoFile.delete();
        bitmapReducedFile.delete();
        if (!DISABLE_FULL_SIZED_BITMAPS) {
            File bitmapFile = this.getBitmapFile(taskId, userId);
            bitmapFile.delete();
        }
    }

    class RemoveObsoleteFilesQueueItem
    extends WriteQueueItem {
        private final ArraySet<Integer> mPersistentTaskIds;
        private final int[] mRunningUserIds;

        RemoveObsoleteFilesQueueItem(ArraySet<Integer> persistentTaskIds, int[] runningUserIds) {
            this.mPersistentTaskIds = persistentTaskIds;
            this.mRunningUserIds = runningUserIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void write() {
            ArraySet newPersistedTaskIds;
            Object object = TaskSnapshotPersister.this.mLock;
            synchronized (object) {
                newPersistedTaskIds = new ArraySet(TaskSnapshotPersister.this.mPersistedTaskIdsSinceLastRemoveObsolete);
            }
            for (Object userId : (Object)this.mRunningUserIds) {
                File dir = TaskSnapshotPersister.this.getDirectory((int)userId);
                String[] files = dir.list();
                if (files == null) continue;
                for (String file : files) {
                    int taskId = this.getTaskId(file);
                    if (this.mPersistentTaskIds.contains(taskId) || newPersistedTaskIds.contains(taskId)) continue;
                    new File(dir, file).delete();
                }
            }
        }

        int getTaskId(String fileName) {
            if (!fileName.endsWith(TaskSnapshotPersister.PROTO_EXTENSION) && !fileName.endsWith(TaskSnapshotPersister.BITMAP_EXTENSION)) {
                return -1;
            }
            int end = fileName.lastIndexOf(46);
            if (end == -1) {
                return -1;
            }
            String name = fileName.substring(0, end);
            if (name.endsWith(TaskSnapshotPersister.REDUCED_POSTFIX)) {
                name = name.substring(0, name.length() - TaskSnapshotPersister.REDUCED_POSTFIX.length());
            }
            try {
                return Integer.parseInt(name);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
    }

    private class DeleteWriteQueueItem
    extends WriteQueueItem {
        private final int mTaskId;
        private final int mUserId;

        DeleteWriteQueueItem(int taskId, int userId) {
            this.mTaskId = taskId;
            this.mUserId = userId;
        }

        @Override
        void write() {
            TaskSnapshotPersister.this.deleteSnapshot(this.mTaskId, this.mUserId);
        }
    }

    private class StoreWriteQueueItem
    extends WriteQueueItem {
        private final int mTaskId;
        private final int mUserId;
        private final ActivityManager.TaskSnapshot mSnapshot;

        StoreWriteQueueItem(int taskId, int userId, ActivityManager.TaskSnapshot snapshot) {
            this.mTaskId = taskId;
            this.mUserId = userId;
            this.mSnapshot = snapshot;
        }

        @Override
        void onQueuedLocked() {
            TaskSnapshotPersister.this.mStoreQueueItems.offer(this);
        }

        @Override
        void onDequeuedLocked() {
            TaskSnapshotPersister.this.mStoreQueueItems.remove(this);
        }

        @Override
        void write() {
            if (!TaskSnapshotPersister.this.createDirectory(this.mUserId)) {
                Slog.e(TaskSnapshotPersister.TAG, "Unable to create snapshot directory for user dir=" + TaskSnapshotPersister.this.getDirectory(this.mUserId));
            }
            boolean failed = false;
            if (!this.writeProto()) {
                failed = true;
            }
            if (!this.writeBuffer()) {
                failed = true;
            }
            if (failed) {
                TaskSnapshotPersister.this.deleteSnapshot(this.mTaskId, this.mUserId);
            }
        }

        boolean writeProto() {
            WindowManagerProtos.TaskSnapshotProto proto = new WindowManagerProtos.TaskSnapshotProto();
            proto.orientation = this.mSnapshot.getOrientation();
            proto.insetLeft = this.mSnapshot.getContentInsets().left;
            proto.insetTop = this.mSnapshot.getContentInsets().top;
            proto.insetRight = this.mSnapshot.getContentInsets().right;
            proto.insetBottom = this.mSnapshot.getContentInsets().bottom;
            byte[] bytes = WindowManagerProtos.TaskSnapshotProto.toByteArray(proto);
            File file = TaskSnapshotPersister.this.getProtoFile(this.mTaskId, this.mUserId);
            AtomicFile atomicFile = new AtomicFile(file);
            FileOutputStream fos = null;
            try {
                fos = atomicFile.startWrite();
                fos.write(bytes);
                atomicFile.finishWrite(fos);
            }
            catch (IOException e) {
                atomicFile.failWrite(fos);
                Slog.e(TaskSnapshotPersister.TAG, "Unable to open " + file + " for persisting. " + e);
                return false;
            }
            return true;
        }

        boolean writeBuffer() {
            Bitmap bitmap = Bitmap.createHardwareBitmap(this.mSnapshot.getSnapshot());
            if (bitmap == null) {
                Slog.e(TaskSnapshotPersister.TAG, "Invalid task snapshot hw bitmap");
                return false;
            }
            Bitmap swBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
            File reducedFile = TaskSnapshotPersister.this.getReducedResolutionBitmapFile(this.mTaskId, this.mUserId);
            Bitmap reduced = this.mSnapshot.isReducedResolution() ? swBitmap : Bitmap.createScaledBitmap(swBitmap, (int)((float)bitmap.getWidth() * REDUCED_SCALE), (int)((float)bitmap.getHeight() * REDUCED_SCALE), true);
            try {
                FileOutputStream reducedFos = new FileOutputStream(reducedFile);
                reduced.compress(Bitmap.CompressFormat.JPEG, 95, reducedFos);
                reducedFos.close();
            }
            catch (IOException e) {
                Slog.e(TaskSnapshotPersister.TAG, "Unable to open " + reducedFile + " for persisting.", e);
                return false;
            }
            if (this.mSnapshot.isReducedResolution()) {
                return true;
            }
            File file = TaskSnapshotPersister.this.getBitmapFile(this.mTaskId, this.mUserId);
            try {
                FileOutputStream fos = new FileOutputStream(file);
                swBitmap.compress(Bitmap.CompressFormat.JPEG, 95, fos);
                fos.close();
            }
            catch (IOException e) {
                Slog.e(TaskSnapshotPersister.TAG, "Unable to open " + file + " for persisting.", e);
                return false;
            }
            return true;
        }
    }

    private abstract class WriteQueueItem {
        private WriteQueueItem() {
        }

        abstract void write();

        void onQueuedLocked() {
        }

        void onDequeuedLocked() {
        }
    }

    static interface DirectoryResolver {
        public File getSystemDirectoryForUser(int var1);
    }
}

