/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Process;
import com.android.internal.annotations.GuardedBy;
import com.android.server.AnimationThread;
import com.android.server.ThreadPriorityBooster;

class WindowManagerThreadPriorityBooster
extends ThreadPriorityBooster {
    private final Object mLock = new Object();
    private final int mAnimationThreadId = AnimationThread.get().getThreadId();
    @GuardedBy(value="mLock")
    private boolean mAppTransitionRunning;
    @GuardedBy(value="mLock")
    private boolean mBoundsAnimationRunning;

    WindowManagerThreadPriorityBooster() {
        super(-4, 5);
    }

    @Override
    public void boost() {
        if (Process.myTid() == this.mAnimationThreadId) {
            return;
        }
        super.boost();
    }

    @Override
    public void reset() {
        if (Process.myTid() == this.mAnimationThreadId) {
            return;
        }
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppTransitionRunning(boolean running) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAppTransitionRunning != running) {
                this.mAppTransitionRunning = running;
                this.updatePriorityLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBoundsAnimationRunning(boolean running) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBoundsAnimationRunning != running) {
                this.mBoundsAnimationRunning = running;
                this.updatePriorityLocked();
            }
        }
    }

    @GuardedBy(value="mLock")
    private void updatePriorityLocked() {
        int priority = this.mAppTransitionRunning || this.mBoundsAnimationRunning ? -10 : -4;
        this.setBoostToPriority(priority);
        Process.setThreadPriority(this.mAnimationThreadId, priority);
    }
}

