/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.MediaRange;
import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.header.ContentTypeHeader;

public class ContentType
extends ParametersHeader
implements ContentTypeHeader {
    private static final long serialVersionUID = 8475682204373446610L;
    protected MediaRange mediaRange;

    public ContentType() {
        super("Content-Type");
    }

    public ContentType(String contentType, String contentSubtype) {
        this();
        this.setContentType(contentType, contentSubtype);
    }

    public int compareMediaRange(String media) {
        return (this.mediaRange.type + "/" + this.mediaRange.subtype).compareToIgnoreCase(media);
    }

    @Override
    public String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    @Override
    protected StringBuffer encodeBody(StringBuffer buffer) {
        this.mediaRange.encode(buffer);
        if (this.hasParameters()) {
            buffer.append(";");
            this.parameters.encode(buffer);
        }
        return buffer;
    }

    public MediaRange getMediaRange() {
        return this.mediaRange;
    }

    public String getMediaType() {
        return this.mediaRange.type;
    }

    public String getMediaSubType() {
        return this.mediaRange.subtype;
    }

    @Override
    public String getContentSubType() {
        return this.mediaRange == null ? null : this.mediaRange.getSubtype();
    }

    @Override
    public String getContentType() {
        return this.mediaRange == null ? null : this.mediaRange.getType();
    }

    @Override
    public String getCharset() {
        return this.getParameter("charset");
    }

    public void setMediaRange(MediaRange m) {
        this.mediaRange = m;
    }

    @Override
    public void setContentType(String contentType, String contentSubType) {
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setType(contentType);
        this.mediaRange.setSubtype(contentSubType);
    }

    @Override
    public void setContentType(String contentType) throws ParseException {
        if (contentType == null) {
            throw new NullPointerException("null arg");
        }
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setType(contentType);
    }

    @Override
    public void setContentSubType(String contentType) throws ParseException {
        if (contentType == null) {
            throw new NullPointerException("null arg");
        }
        if (this.mediaRange == null) {
            this.mediaRange = new MediaRange();
        }
        this.mediaRange.setSubtype(contentType);
    }

    @Override
    public Object clone() {
        ContentType retval = (ContentType)super.clone();
        if (this.mediaRange != null) {
            retval.mediaRange = (MediaRange)this.mediaRange.clone();
        }
        return retval;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ContentTypeHeader) {
            ContentTypeHeader o = (ContentTypeHeader)other;
            return this.getContentType().equalsIgnoreCase(o.getContentType()) && this.getContentSubType().equalsIgnoreCase(o.getContentSubType()) && this.equalParameters(o);
        }
        return false;
    }
}

