/*
 * Decompiled with CFR 0.152.
 */
package libcore.net;

import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class UriCodec
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static char INVALID_INPUT_CHARACTER = '\ufffd';

    private void $$robo$$libcore_net_UriCodec$__constructor__() {
    }

    protected abstract boolean isRetained(char var1);

    private static final boolean $$robo$$libcore_net_UriCodec$isWhitelisted(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    private final boolean $$robo$$libcore_net_UriCodec$isWhitelistedOrRetained(char c) {
        return UriCodec.isWhitelisted(c) || this.isRetained(c);
    }

    private final String $$robo$$libcore_net_UriCodec$validate(String uri, int start, int end, String name) throws URISyntaxException {
        int i = start;
        while (i < end) {
            char c;
            if (this.isWhitelistedOrRetained(c = uri.charAt(i++))) continue;
            if (c != '%') {
                throw UriCodec.unexpectedCharacterException(uri, name, c, i - 1);
            }
            for (int j = 0; j < 2; ++j) {
                if (UriCodec.hexCharToValue(c = UriCodec.getNextCharacter(uri, i++, end, name)) >= 0) continue;
                throw UriCodec.unexpectedCharacterException(uri, name, c, i - 1);
            }
        }
        return uri.substring(start, end);
    }

    private static final int $$robo$$libcore_net_UriCodec$hexCharToValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return 10 + c - 97;
        }
        if ('A' <= c && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    private static final URISyntaxException $$robo$$libcore_net_UriCodec$unexpectedCharacterException(String uri, String name, char unexpected, int index) {
        String nameString = name == null ? "" : " in [" + name + "]";
        return new URISyntaxException(uri, "Unexpected character" + nameString + ": " + unexpected, index);
    }

    private static final char $$robo$$libcore_net_UriCodec$getNextCharacter(String uri, int index, int end, String name) throws URISyntaxException {
        if (index >= end) {
            String nameString = name == null ? "" : " in [" + name + "]";
            throw new URISyntaxException(uri, "Unexpected end of string" + nameString, index);
        }
        return uri.charAt(index);
    }

    private static final void $$robo$$libcore_net_UriCodec$validateSimple(String uri, String legal) throws URISyntaxException {
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (UriCodec.isWhitelisted(c) || legal.indexOf(c) >= 0) continue;
            throw UriCodec.unexpectedCharacterException(uri, null, c, i);
        }
    }

    private final String $$robo$$libcore_net_UriCodec$encode(String s, Charset charset) {
        StringBuilder builder = new StringBuilder(s.length());
        this.appendEncoded(builder, s, charset, false);
        return builder.toString();
    }

    private final void $$robo$$libcore_net_UriCodec$appendEncoded(StringBuilder builder, String s) {
        this.appendEncoded(builder, s, StandardCharsets.UTF_8, false);
    }

    private final void $$robo$$libcore_net_UriCodec$appendPartiallyEncoded(StringBuilder builder, String s) {
        this.appendEncoded(builder, s, StandardCharsets.UTF_8, true);
    }

    private final void $$robo$$libcore_net_UriCodec$appendEncoded(StringBuilder builder, String s, Charset charset, boolean partiallyEncoded) {
        CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer cBuffer = CharBuffer.allocate(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%' && partiallyEncoded) {
                UriCodec.flushEncodingCharBuffer(builder, encoder, cBuffer);
                builder.append('%');
                continue;
            }
            if (c == ' ' && this.isRetained(' ')) {
                UriCodec.flushEncodingCharBuffer(builder, encoder, cBuffer);
                builder.append('+');
                continue;
            }
            if (this.isWhitelistedOrRetained(c)) {
                UriCodec.flushEncodingCharBuffer(builder, encoder, cBuffer);
                builder.append(c);
                continue;
            }
            cBuffer.put(c);
        }
        UriCodec.flushEncodingCharBuffer(builder, encoder, cBuffer);
    }

    private static final void $$robo$$libcore_net_UriCodec$flushEncodingCharBuffer(StringBuilder builder, CharsetEncoder encoder, CharBuffer cBuffer) {
        if (cBuffer.position() == 0) {
            return;
        }
        cBuffer.flip();
        ByteBuffer byteBuffer = ByteBuffer.allocate(cBuffer.remaining() * (int)Math.ceil(encoder.maxBytesPerChar()));
        byteBuffer.position(0);
        CoderResult result = encoder.encode(cBuffer, byteBuffer, true);
        if (result != CoderResult.UNDERFLOW) {
            throw new IllegalArgumentException("Error encoding, unexpected result [" + result.toString() + "] using encoder for [" + encoder.charset().name() + "]");
        }
        if (cBuffer.hasRemaining()) {
            throw new IllegalArgumentException("Encoder for [" + encoder.charset().name() + "] failed with underflow with " + "remaining input [" + cBuffer + "]");
        }
        encoder.flush(byteBuffer);
        if (result != CoderResult.UNDERFLOW) {
            throw new IllegalArgumentException("Error encoding, unexpected result [" + result.toString() + "] flushing encoder for [" + encoder.charset().name() + "]");
        }
        encoder.reset();
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            byte b = byteBuffer.get();
            builder.append('%');
            builder.append(UriCodec.intToHexDigit((b & 0xF0) >>> 4));
            builder.append(UriCodec.intToHexDigit(b & 0xF));
        }
        cBuffer.flip();
        cBuffer.limit(cBuffer.capacity());
    }

    private static final char $$robo$$libcore_net_UriCodec$intToHexDigit(int b) {
        if (b < 10) {
            return (char)(48 + b);
        }
        return (char)(65 + b - 10);
    }

    private static final String $$robo$$libcore_net_UriCodec$decode(String s, boolean convertPlus, Charset charset, boolean throwOnFailure) {
        StringBuilder builder = new StringBuilder(s.length());
        UriCodec.appendDecoded(builder, s, convertPlus, charset, throwOnFailure);
        return builder.toString();
    }

    private static final void $$robo$$libcore_net_UriCodec$appendDecoded(StringBuilder builder, String s, boolean convertPlus, Charset charset, boolean throwOnFailure) {
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).replaceWith("\ufffd").onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer byteBuffer = ByteBuffer.allocate(s.length());
        int i = 0;
        block6: while (i < s.length()) {
            char c = s.charAt(i);
            ++i;
            switch (c) {
                case '+': {
                    UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                    builder.append(convertPlus ? (char)' ' : '+');
                    continue block6;
                }
                case '%': {
                    byte hexValue = 0;
                    for (int j = 0; j < 2; ++j) {
                        try {
                            c = UriCodec.getNextCharacter(s, i, s.length(), null);
                        }
                        catch (URISyntaxException e) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(e);
                            }
                            UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            return;
                        }
                        ++i;
                        int newDigit = UriCodec.hexCharToValue(c);
                        if (newDigit < 0) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(UriCodec.unexpectedCharacterException(s, null, c, i - 1));
                            }
                            UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            break;
                        }
                        hexValue = (byte)(hexValue * 16 + newDigit);
                    }
                    byteBuffer.put(hexValue);
                    continue block6;
                }
            }
            UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
            builder.append(c);
        }
        UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$libcore_net_UriCodec$flushDecodingByteAccumulator(StringBuilder builder, CharsetDecoder decoder, ByteBuffer byteBuffer, boolean throwOnFailure) {
        if (byteBuffer.position() == 0) {
            return;
        }
        byteBuffer.flip();
        try {
            builder.append(decoder.decode(byteBuffer));
        }
        catch (CharacterCodingException e) {
            if (throwOnFailure) {
                throw new IllegalArgumentException(e);
            }
            builder.append('\ufffd');
        }
        finally {
            byteBuffer.flip();
            byteBuffer.limit(byteBuffer.capacity());
        }
    }

    private static final String $$robo$$libcore_net_UriCodec$decode(String s) {
        return UriCodec.decode(s, false, StandardCharsets.UTF_8, true);
    }

    private void __constructor__() {
        this.$$robo$$libcore_net_UriCodec$__constructor__();
    }

    public UriCodec() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_net_UriCodec$__constructor__(), 0, this);
    }

    private static boolean isWhitelisted(char c) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isWhitelisted", $$robo$$libcore_net_UriCodec$isWhitelisted(char ), 0, (char)c);
    }

    private boolean isWhitelistedOrRetained(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWhitelistedOrRetained", $$robo$$libcore_net_UriCodec$isWhitelistedOrRetained(char ), 0, this, c);
    }

    public String validate(String string2, int n, int n2, String string3) throws URISyntaxException {
        return InvokeDynamicSupport.bootstrap("validate", $$robo$$libcore_net_UriCodec$validate(java.lang.String int int java.lang.String ), 0, this, string2, n, n2, string3);
    }

    private static int hexCharToValue(char c) {
        return (int)InvokeDynamicSupport.bootstrapStatic("hexCharToValue", $$robo$$libcore_net_UriCodec$hexCharToValue(char ), 0, (char)c);
    }

    private static URISyntaxException unexpectedCharacterException(String string2, String string3, char c, int n) {
        return InvokeDynamicSupport.bootstrapStatic("unexpectedCharacterException", $$robo$$libcore_net_UriCodec$unexpectedCharacterException(java.lang.String java.lang.String char int ), 0, (String)string2, (String)string3, (char)c, (int)n);
    }

    private static char getNextCharacter(String string2, int n, int n2, String string3) throws URISyntaxException {
        return (char)InvokeDynamicSupport.bootstrapStatic("getNextCharacter", $$robo$$libcore_net_UriCodec$getNextCharacter(java.lang.String int int java.lang.String ), 0, (String)string2, (int)n, (int)n2, (String)string3);
    }

    public static void validateSimple(String string2, String string3) throws URISyntaxException {
        InvokeDynamicSupport.bootstrapStatic("validateSimple", $$robo$$libcore_net_UriCodec$validateSimple(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public String encode(String string2, Charset charset) {
        return InvokeDynamicSupport.bootstrap("encode", $$robo$$libcore_net_UriCodec$encode(java.lang.String java.nio.charset.Charset ), 0, this, string2, charset);
    }

    public void appendEncoded(StringBuilder stringBuilder, String string2) {
        InvokeDynamicSupport.bootstrap("appendEncoded", $$robo$$libcore_net_UriCodec$appendEncoded(java.lang.StringBuilder java.lang.String ), 0, this, stringBuilder, string2);
    }

    public void appendPartiallyEncoded(StringBuilder stringBuilder, String string2) {
        InvokeDynamicSupport.bootstrap("appendPartiallyEncoded", $$robo$$libcore_net_UriCodec$appendPartiallyEncoded(java.lang.StringBuilder java.lang.String ), 0, this, stringBuilder, string2);
    }

    private void appendEncoded(StringBuilder stringBuilder, String string2, Charset charset, boolean bl) {
        InvokeDynamicSupport.bootstrap("appendEncoded", $$robo$$libcore_net_UriCodec$appendEncoded(java.lang.StringBuilder java.lang.String java.nio.charset.Charset boolean ), 0, this, stringBuilder, string2, charset, bl);
    }

    private static void flushEncodingCharBuffer(StringBuilder stringBuilder, CharsetEncoder charsetEncoder, CharBuffer charBuffer) {
        InvokeDynamicSupport.bootstrapStatic("flushEncodingCharBuffer", $$robo$$libcore_net_UriCodec$flushEncodingCharBuffer(java.lang.StringBuilder java.nio.charset.CharsetEncoder java.nio.CharBuffer ), 0, (StringBuilder)stringBuilder, (CharsetEncoder)charsetEncoder, (CharBuffer)charBuffer);
    }

    private static char intToHexDigit(int n) {
        return (char)InvokeDynamicSupport.bootstrapStatic("intToHexDigit", $$robo$$libcore_net_UriCodec$intToHexDigit(int ), 0, (int)n);
    }

    public static String decode(String string2, boolean bl, Charset charset, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_net_UriCodec$decode(java.lang.String boolean java.nio.charset.Charset boolean ), 0, (String)string2, (boolean)bl, (Charset)charset, (boolean)bl2);
    }

    private static void appendDecoded(StringBuilder stringBuilder, String string2, boolean bl, Charset charset, boolean bl2) {
        InvokeDynamicSupport.bootstrapStatic("appendDecoded", $$robo$$libcore_net_UriCodec$appendDecoded(java.lang.StringBuilder java.lang.String boolean java.nio.charset.Charset boolean ), 0, (StringBuilder)stringBuilder, (String)string2, (boolean)bl, (Charset)charset, (boolean)bl2);
    }

    private static void flushDecodingByteAccumulator(StringBuilder stringBuilder, CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("flushDecodingByteAccumulator", $$robo$$libcore_net_UriCodec$flushDecodingByteAccumulator(java.lang.StringBuilder java.nio.charset.CharsetDecoder java.nio.ByteBuffer boolean ), 0, (StringBuilder)stringBuilder, (CharsetDecoder)charsetDecoder, (ByteBuffer)byteBuffer, (boolean)bl);
    }

    public static String decode(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$libcore_net_UriCodec$decode(java.lang.String ), 0, (String)string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UriCodec)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

