/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.icu.util.TimeZone;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import libcore.util.TimeZoneDataFiles;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class TimeZoneFinder
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TZLOOKUP_FILE_NAME = "tzlookup.xml";
    private static String TIMEZONES_ELEMENT = "timezones";
    private static String COUNTRY_ZONES_ELEMENT = "countryzones";
    private static String COUNTRY_ELEMENT = "country";
    private static String COUNTRY_CODE_ATTRIBUTE = "code";
    private static String ID_ELEMENT = "id";
    private static TimeZoneFinder instance;
    private ReaderSupplier xmlSource;
    private String lastCountryIso;
    private List<TimeZone> lastCountryTimeZones;

    private void $$robo$$libcore_util_TimeZoneFinder$__constructor__(ReaderSupplier xmlSource) {
        this.xmlSource = xmlSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TimeZoneFinder $$robo$$libcore_util_TimeZoneFinder$getInstance() {
        Class<TimeZoneFinder> clazz = TimeZoneFinder.class;
        synchronized (TimeZoneFinder.class) {
            if (instance == null) {
                String[] tzLookupFilePaths = TimeZoneDataFiles.getTimeZoneFilePaths("tzlookup.xml");
                instance = TimeZoneFinder.createInstanceWithFallback(tzLookupFilePaths[0], tzLookupFilePaths[1]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static final TimeZoneFinder $$robo$$libcore_util_TimeZoneFinder$createInstanceWithFallback(String ... tzLookupFilePaths) {
        IOException lastException = null;
        for (String tzLookupFilePath : tzLookupFilePaths) {
            try {
                return TimeZoneFinder.createInstance(tzLookupFilePath);
            }
            catch (IOException e) {
                if (lastException != null) {
                    e.addSuppressed(lastException);
                }
                lastException = e;
            }
        }
        InvokeDynamicSupport.bootstrapIntrinsic("logE", "java.lang.System", (String)("No valid file found in set: " + Arrays.toString(tzLookupFilePaths) + " Printing exceptions and falling back to empty map."), (Throwable)lastException);
        return TimeZoneFinder.createInstanceForTests("<timezones><countryzones /></timezones>");
    }

    private static final TimeZoneFinder $$robo$$libcore_util_TimeZoneFinder$createInstance(String path) throws IOException {
        ReaderSupplier xmlSupplier = ReaderSupplier.forFile(path, StandardCharsets.UTF_8);
        return new TimeZoneFinder(xmlSupplier);
    }

    private static final TimeZoneFinder $$robo$$libcore_util_TimeZoneFinder$createInstanceForTests(String xml2) {
        return new TimeZoneFinder(ReaderSupplier.forString(xml2));
    }

    private final void $$robo$$libcore_util_TimeZoneFinder$validate() throws IOException {
        try {
            this.processXml(new CountryZonesValidator());
        }
        catch (XmlPullParserException e) {
            throw new IOException("Parsing error", e);
        }
    }

    private final TimeZone $$robo$$libcore_util_TimeZoneFinder$lookupTimeZoneByCountryAndOffset(String countryIso, int offsetSeconds, boolean isDst, long whenMillis, TimeZone bias) {
        List<TimeZone> candidates = this.lookupTimeZonesByCountry(countryIso);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        TimeZone firstMatch = null;
        for (int i = 0; i < candidates.size(); ++i) {
            TimeZone match = candidates.get(i);
            if (!TimeZoneFinder.offsetMatchesAtTime(match, offsetSeconds, isDst, whenMillis)) continue;
            if (firstMatch == null) {
                if (bias == null) {
                    return match;
                }
                firstMatch = match;
            }
            if (!match.getID().equals(bias.getID())) continue;
            return match;
        }
        return firstMatch;
    }

    private static final boolean $$robo$$libcore_util_TimeZoneFinder$offsetMatchesAtTime(TimeZone timeZone, int offsetMillis, boolean isDst, long whenMillis) {
        boolean zoneIsDst;
        int[] offsets = new int[2];
        timeZone.getOffset(whenMillis, false, offsets);
        boolean bl = zoneIsDst = offsets[1] != 0;
        if (isDst != zoneIsDst) {
            return false;
        }
        return offsetMillis == offsets[0] + offsets[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<TimeZone> $$robo$$libcore_util_TimeZoneFinder$lookupTimeZonesByCountry(String countryIso) {
        TimeZoneFinder timeZoneFinder = this;
        synchronized (timeZoneFinder) {
            if (countryIso.equals(this.lastCountryIso)) {
                return this.lastCountryTimeZones;
            }
        }
        CountryZonesExtractor extractor = new CountryZonesExtractor(countryIso);
        List<TimeZone> countryTimeZones = null;
        try {
            this.processXml(extractor);
            countryTimeZones = extractor.getMatchedZones();
        }
        catch (IOException e) {
            InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)"Error reading country zones ", (Throwable)e);
            countryIso = null;
        }
        catch (XmlPullParserException e) {
            InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)"Error reading country zones ", (Throwable)e);
        }
        TimeZoneFinder timeZoneFinder2 = this;
        synchronized (timeZoneFinder2) {
            this.lastCountryIso = countryIso;
            this.lastCountryTimeZones = countryTimeZones;
        }
        return countryTimeZones;
    }

    private final void $$robo$$libcore_util_TimeZoneFinder$processXml(CountryZonesProcessor processor) throws XmlPullParserException, IOException {
        try (Reader reader = this.xmlSource.get();){
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(false);
            XmlPullParser parser = xmlPullParserFactory.newPullParser();
            parser.setInput(reader);
            TimeZoneFinder.findRequiredStartTag(parser, "timezones");
            TimeZoneFinder.findRequiredStartTag(parser, "countryzones");
            if (!TimeZoneFinder.processCountryZones(parser, processor)) {
                return;
            }
            TimeZoneFinder.checkOnEndTag(parser, "countryzones");
            parser.next();
            TimeZoneFinder.consumeUntilEndTag(parser, "timezones");
            TimeZoneFinder.checkOnEndTag(parser, "timezones");
        }
    }

    private static final boolean $$robo$$libcore_util_TimeZoneFinder$processCountryZones(XmlPullParser parser, CountryZonesProcessor processor) throws IOException, XmlPullParserException {
        while (TimeZoneFinder.findOptionalStartTag(parser, "country")) {
            if (processor == null) {
                TimeZoneFinder.consumeUntilEndTag(parser, "country");
            } else {
                String code = parser.getAttributeValue(null, "code");
                if (code == null || code.isEmpty()) {
                    throw new XmlPullParserException("Unable to find country code: " + parser.getPositionDescription());
                }
                String debugInfo = parser.getPositionDescription();
                List<String> timeZoneIds = TimeZoneFinder.parseZoneIds(parser);
                if (!processor.process(code, timeZoneIds, debugInfo)) {
                    return false;
                }
            }
            TimeZoneFinder.checkOnEndTag(parser, "country");
        }
        return true;
    }

    private static final List<String> $$robo$$libcore_util_TimeZoneFinder$parseZoneIds(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<String> timeZones = new ArrayList<String>();
        while (TimeZoneFinder.findOptionalStartTag(parser, "id")) {
            String zoneIdString = TimeZoneFinder.consumeText(parser);
            TimeZoneFinder.checkOnEndTag(parser, "id");
            timeZones.add(zoneIdString);
        }
        return Collections.unmodifiableList(timeZones);
    }

    private static final void $$robo$$libcore_util_TimeZoneFinder$findRequiredStartTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        TimeZoneFinder.findStartTag(parser, elementName, true);
    }

    private static final boolean $$robo$$libcore_util_TimeZoneFinder$findOptionalStartTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        return TimeZoneFinder.findStartTag(parser, elementName, false);
    }

    private static final boolean $$robo$$libcore_util_TimeZoneFinder$findStartTag(XmlPullParser parser, String elementName, boolean elementRequired) throws IOException, XmlPullParserException {
        int type;
        while ((type = parser.next()) != 1) {
            switch (type) {
                case 2: {
                    String currentElementName = parser.getName();
                    if (elementName.equals(currentElementName)) {
                        return true;
                    }
                    parser.next();
                    TimeZoneFinder.consumeUntilEndTag(parser, currentElementName);
                    break;
                }
                case 3: {
                    if (elementRequired) {
                        throw new XmlPullParserException("No child element found with name " + elementName);
                    }
                    return false;
                }
            }
        }
        throw new XmlPullParserException("Unexpected end of document while looking for " + elementName);
    }

    private static final void $$robo$$libcore_util_TimeZoneFinder$consumeUntilEndTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        if (parser.getEventType() == 3 && elementName.equals(parser.getName())) {
            return;
        }
        int requiredDepth = parser.getDepth();
        if (parser.getEventType() == 2) {
            --requiredDepth;
        }
        while (parser.getEventType() != 1) {
            int type = parser.next();
            int currentDepth = parser.getDepth();
            if (currentDepth < requiredDepth) {
                throw new XmlPullParserException("Unexpected depth while looking for end tag: " + parser.getPositionDescription());
            }
            if (currentDepth != requiredDepth || type != 3) continue;
            if (elementName.equals(parser.getName())) {
                return;
            }
            throw new XmlPullParserException("Unexpected eng tag: " + parser.getPositionDescription());
        }
        throw new XmlPullParserException("Unexpected end of document");
    }

    private static final String $$robo$$libcore_util_TimeZoneFinder$consumeText(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type = parser.next();
        if (type != 4) {
            throw new XmlPullParserException("Text not found. Found type=" + type + " at " + parser.getPositionDescription());
        }
        String text = parser.getText();
        type = parser.next();
        if (type != 3) {
            throw new XmlPullParserException("Unexpected nested tag or end of document when expecting text: type=" + type + " at " + parser.getPositionDescription());
        }
        return text;
    }

    private static final void $$robo$$libcore_util_TimeZoneFinder$checkOnEndTag(XmlPullParser parser, String elementName) throws XmlPullParserException {
        if (parser.getEventType() != 3 || !parser.getName().equals(elementName)) {
            throw new XmlPullParserException("Unexpected tag encountered: " + parser.getPositionDescription());
        }
    }

    private void __constructor__(ReaderSupplier readerSupplier) {
        this.$$robo$$libcore_util_TimeZoneFinder$__constructor__(readerSupplier);
    }

    private TimeZoneFinder(ReaderSupplier readerSupplier) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder$__constructor__(libcore.util.TimeZoneFinder$ReaderSupplier ), 0, this, readerSupplier);
    }

    public static TimeZoneFinder getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$libcore_util_TimeZoneFinder$getInstance(), 0);
    }

    public static TimeZoneFinder createInstanceWithFallback(String ... stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("createInstanceWithFallback", $$robo$$libcore_util_TimeZoneFinder$createInstanceWithFallback(java.lang.String[] ), 0, (String[])stringArray);
    }

    public static TimeZoneFinder createInstance(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createInstance", $$robo$$libcore_util_TimeZoneFinder$createInstance(java.lang.String ), 0, (String)string2);
    }

    public static TimeZoneFinder createInstanceForTests(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createInstanceForTests", $$robo$$libcore_util_TimeZoneFinder$createInstanceForTests(java.lang.String ), 0, (String)string2);
    }

    public void validate() throws IOException {
        InvokeDynamicSupport.bootstrap("validate", $$robo$$libcore_util_TimeZoneFinder$validate(), 0, this);
    }

    public TimeZone lookupTimeZoneByCountryAndOffset(String string2, int n, boolean bl, long l, TimeZone timeZone) {
        return InvokeDynamicSupport.bootstrap("lookupTimeZoneByCountryAndOffset", $$robo$$libcore_util_TimeZoneFinder$lookupTimeZoneByCountryAndOffset(java.lang.String int boolean long android.icu.util.TimeZone ), 0, this, string2, n, bl, l, timeZone);
    }

    private static boolean offsetMatchesAtTime(TimeZone timeZone, int n, boolean bl, long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("offsetMatchesAtTime", $$robo$$libcore_util_TimeZoneFinder$offsetMatchesAtTime(android.icu.util.TimeZone int boolean long ), 0, (TimeZone)timeZone, (int)n, (boolean)bl, (long)l);
    }

    public List<TimeZone> lookupTimeZonesByCountry(String string2) {
        return InvokeDynamicSupport.bootstrap("lookupTimeZonesByCountry", $$robo$$libcore_util_TimeZoneFinder$lookupTimeZonesByCountry(java.lang.String ), 0, this, string2);
    }

    private void processXml(CountryZonesProcessor countryZonesProcessor) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("processXml", $$robo$$libcore_util_TimeZoneFinder$processXml(libcore.util.TimeZoneFinder$CountryZonesProcessor ), 0, this, countryZonesProcessor);
    }

    private static boolean processCountryZones(XmlPullParser xmlPullParser, CountryZonesProcessor countryZonesProcessor) throws IOException, XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("processCountryZones", $$robo$$libcore_util_TimeZoneFinder$processCountryZones(org.xmlpull.v1.XmlPullParser libcore.util.TimeZoneFinder$CountryZonesProcessor ), 0, (XmlPullParser)xmlPullParser, (CountryZonesProcessor)countryZonesProcessor);
    }

    private static List<String> parseZoneIds(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrapStatic("parseZoneIds", $$robo$$libcore_util_TimeZoneFinder$parseZoneIds(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static void findRequiredStartTag(XmlPullParser xmlPullParser, String string2) throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrapStatic("findRequiredStartTag", $$robo$$libcore_util_TimeZoneFinder$findRequiredStartTag(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static boolean findOptionalStartTag(XmlPullParser xmlPullParser, String string2) throws IOException, XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("findOptionalStartTag", $$robo$$libcore_util_TimeZoneFinder$findOptionalStartTag(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static boolean findStartTag(XmlPullParser xmlPullParser, String string2, boolean bl) throws IOException, XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("findStartTag", $$robo$$libcore_util_TimeZoneFinder$findStartTag(org.xmlpull.v1.XmlPullParser java.lang.String boolean ), 0, (XmlPullParser)xmlPullParser, (String)string2, (boolean)bl);
    }

    private static void consumeUntilEndTag(XmlPullParser xmlPullParser, String string2) throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrapStatic("consumeUntilEndTag", $$robo$$libcore_util_TimeZoneFinder$consumeUntilEndTag(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static String consumeText(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrapStatic("consumeText", $$robo$$libcore_util_TimeZoneFinder$consumeText(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    private static void checkOnEndTag(XmlPullParser xmlPullParser, String string2) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrapStatic("checkOnEndTag", $$robo$$libcore_util_TimeZoneFinder$checkOnEndTag(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    public /* synthetic */ TimeZoneFinder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimeZoneFinder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static interface ReaderSupplier
    extends InstrumentedInterface {
        public Reader get() throws IOException;

        public static ReaderSupplier forFile(String fileName, Charset charSet) throws IOException {
            Path file = Paths.get(fileName, new String[0]);
            if (!Files.exists(file, new LinkOption[0])) {
                throw new FileNotFoundException(fileName + " does not exist");
            }
            if (!Files.isRegularFile(file, new LinkOption[0]) && Files.isReadable(file)) {
                throw new IOException(fileName + " must be a regular readable file.");
            }
            return () -> Files.newBufferedReader(file, charSet);
        }

        public static ReaderSupplier forString(String xml2) {
            return () -> new StringReader(xml2);
        }
    }

    private static class CountryZonesExtractor
    implements CountryZonesProcessor,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String countryCodeToMatch;
        private List<TimeZone> matchedZones;

        private void $$robo$$libcore_util_TimeZoneFinder_CountryZonesExtractor$__constructor__(String countryCodeToMatch) {
            this.countryCodeToMatch = countryCodeToMatch;
        }

        private final boolean $$robo$$libcore_util_TimeZoneFinder_CountryZonesExtractor$process(String countryCode, List<String> timeZoneIds, String debugInfo) {
            if (!this.countryCodeToMatch.equals(countryCode)) {
                return true;
            }
            ArrayList<Object> timeZones = new ArrayList<Object>();
            for (String zoneIdString : timeZoneIds) {
                TimeZone tz = TimeZone.getTimeZone(zoneIdString);
                if (tz.getID().equals("Etc/Unknown")) {
                    InvokeDynamicSupport.bootstrapIntrinsic("logW", "java.lang.System", (String)("Skipping invalid zone: " + zoneIdString + " at " + debugInfo));
                    continue;
                }
                timeZones.add(tz.freeze());
            }
            this.matchedZones = Collections.unmodifiableList(timeZones);
            return false;
        }

        private final List<TimeZone> $$robo$$libcore_util_TimeZoneFinder_CountryZonesExtractor$getMatchedZones() {
            return this.matchedZones;
        }

        private /* synthetic */ void $$robo$$libcore_util_TimeZoneFinder_CountryZonesExtractor$__constructor__(String x0, 1 x1) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$libcore_util_TimeZoneFinder_CountryZonesExtractor$__constructor__(string2);
        }

        private CountryZonesExtractor(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_CountryZonesExtractor$__constructor__(java.lang.String ), 0, this, string2);
        }

        @Override
        public boolean process(String string2, List<String> list, String string3) {
            return (boolean)InvokeDynamicSupport.bootstrap("process", $$robo$$libcore_util_TimeZoneFinder_CountryZonesExtractor$process(java.lang.String java.util.List<java.lang.String> java.lang.String ), 0, this, string2, list, string3);
        }

        List<TimeZone> getMatchedZones() {
            return InvokeDynamicSupport.bootstrap("getMatchedZones", $$robo$$libcore_util_TimeZoneFinder_CountryZonesExtractor$getMatchedZones(), 0, this);
        }

        private /* synthetic */ void __constructor__(String string2, 1 var2_2) {
            this.$$robo$$libcore_util_TimeZoneFinder_CountryZonesExtractor$__constructor__(string2, var2_2);
        }

        public /* synthetic */ CountryZonesExtractor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CountryZonesExtractor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class CountryZonesValidator
    implements CountryZonesProcessor,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Set<String> knownCountryCodes;

        private void $$robo$$libcore_util_TimeZoneFinder_CountryZonesValidator$__constructor__() {
            this.knownCountryCodes = new HashSet<String>();
        }

        private final boolean $$robo$$libcore_util_TimeZoneFinder_CountryZonesValidator$process(String countryCode, List<String> timeZoneIds, String debugInfo) throws XmlPullParserException {
            if (this.knownCountryCodes.contains(countryCode)) {
                throw new XmlPullParserException("Second entry for country code: " + countryCode + " at " + debugInfo);
            }
            if (timeZoneIds.isEmpty()) {
                throw new XmlPullParserException("No time zone IDs for country code: " + countryCode + " at " + debugInfo);
            }
            this.knownCountryCodes.add(countryCode);
            return true;
        }

        private /* synthetic */ void $$robo$$libcore_util_TimeZoneFinder_CountryZonesValidator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$libcore_util_TimeZoneFinder_CountryZonesValidator$__constructor__();
        }

        private CountryZonesValidator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_util_TimeZoneFinder_CountryZonesValidator$__constructor__(), 0, this);
        }

        @Override
        public boolean process(String string2, List<String> list, String string3) throws XmlPullParserException {
            return (boolean)InvokeDynamicSupport.bootstrap("process", $$robo$$libcore_util_TimeZoneFinder_CountryZonesValidator$process(java.lang.String java.util.List<java.lang.String> java.lang.String ), 0, this, string2, list, string3);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$libcore_util_TimeZoneFinder_CountryZonesValidator$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CountryZonesValidator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface CountryZonesProcessor
    extends InstrumentedInterface {
        public static final boolean CONTINUE = true;
        public static final boolean HALT = false;

        public boolean process(String var1, List<String> var2, String var3) throws XmlPullParserException;
    }
}

