/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.dalvik.ddmc;

import dalvik.annotation.optimization.FastNative;
import java.util.Collection;
import java.util.HashMap;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;

public class DdmServer {
    public static final int CLIENT_PROTOCOL_VERSION = 1;
    private static HashMap<Integer, ChunkHandler> mHandlerMap = new HashMap();
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 2;
    private static volatile boolean mRegistrationComplete = false;
    private static boolean mRegistrationTimedOut = false;

    private DdmServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerHandler(int type, ChunkHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler == null");
        }
        HashMap<Integer, ChunkHandler> hashMap = mHandlerMap;
        synchronized (hashMap) {
            if (mHandlerMap.get(type) != null) {
                throw new RuntimeException("type " + Integer.toHexString(type) + " already registered");
            }
            mHandlerMap.put(type, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChunkHandler unregisterHandler(int type) {
        HashMap<Integer, ChunkHandler> hashMap = mHandlerMap;
        synchronized (hashMap) {
            return mHandlerMap.remove(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrationComplete() {
        HashMap<Integer, ChunkHandler> hashMap = mHandlerMap;
        synchronized (hashMap) {
            mRegistrationComplete = true;
            mHandlerMap.notifyAll();
        }
    }

    public static void sendChunk(Chunk chunk) {
        DdmServer.nativeSendChunk(chunk.type, chunk.data, chunk.offset, chunk.length);
    }

    @FastNative
    private static native void nativeSendChunk(int var0, byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void broadcast(int event) {
        HashMap<Integer, ChunkHandler> hashMap = mHandlerMap;
        synchronized (hashMap) {
            Collection<ChunkHandler> values = mHandlerMap.values();
            block7: for (ChunkHandler handler : values) {
                switch (event) {
                    case 1: {
                        handler.connected();
                        continue block7;
                    }
                    case 2: {
                        handler.disconnected();
                        continue block7;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Chunk dispatch(int type, byte[] data, int offset, int length) {
        ChunkHandler handler;
        HashMap<Integer, ChunkHandler> hashMap = mHandlerMap;
        synchronized (hashMap) {
            while (!mRegistrationComplete && !mRegistrationTimedOut) {
                try {
                    mHandlerMap.wait(1000L);
                }
                catch (InterruptedException ie) {
                    continue;
                }
                if (mRegistrationComplete) continue;
                mRegistrationTimedOut = true;
            }
            handler = mHandlerMap.get(type);
        }
        if (handler == null) {
            return null;
        }
        Chunk chunk = new Chunk(type, data, offset, length);
        return handler.handleChunk(chunk);
    }
}

