/*
 * Decompiled with CFR 0.152.
 */
package org.kxml2.io;

import com.google.errorprone.annotations.DoNotMock;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import libcore.internal.StringPool;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class KXmlParser
implements XmlPullParser,
Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String PROPERTY_XMLDECL_VERSION = "http://xmlpull.org/v1/doc/properties.html#xmldecl-version";
    private static String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone";
    private static String PROPERTY_LOCATION = "http://xmlpull.org/v1/doc/properties.html#location";
    private static String FEATURE_RELAXED = "http://xmlpull.org/v1/doc/features.html#relaxed";
    private static Map<String, String> DEFAULT_ENTITIES;
    private static int ELEMENTDECL = 11;
    private static int ENTITYDECL = 12;
    private static int ATTLISTDECL = 13;
    private static int NOTATIONDECL = 14;
    private static int PARAMETER_ENTITY_REF = 15;
    private static char[] START_COMMENT;
    private static char[] END_COMMENT;
    private static char[] COMMENT_DOUBLE_DASH;
    private static char[] START_CDATA;
    private static char[] END_CDATA;
    private static char[] START_PROCESSING_INSTRUCTION;
    private static char[] END_PROCESSING_INSTRUCTION;
    private static char[] START_DOCTYPE;
    private static char[] SYSTEM;
    private static char[] PUBLIC;
    private static char[] START_ELEMENT;
    private static char[] START_ATTLIST;
    private static char[] START_ENTITY;
    private static char[] START_NOTATION;
    private static char[] EMPTY;
    private static char[] ANY;
    private static char[] NDATA;
    private static char[] NOTATION;
    private static char[] REQUIRED;
    private static char[] IMPLIED;
    private static char[] FIXED;
    private static String UNEXPECTED_EOF = "Unexpected EOF";
    private static String ILLEGAL_TYPE = "Wrong event type";
    private static int XML_DECLARATION = 998;
    private String location;
    private String version;
    private Boolean standalone;
    private String rootElementName;
    private String systemId;
    private String publicId;
    private boolean processDocDecl;
    private boolean processNsp;
    private boolean relaxed;
    private boolean keepNamespaceAttributes;
    private StringBuilder bufferCapture;
    private Map<String, char[]> documentEntities;
    private Map<String, Map<String, String>> defaultAttributes;
    private int depth;
    private String[] elementStack;
    private String[] nspStack;
    private int[] nspCounts;
    private Reader reader;
    private String encoding;
    private ContentSource nextContentSource;
    private char[] buffer;
    private int position;
    private int limit;
    private int bufferStartLine;
    private int bufferStartColumn;
    private int type;
    private boolean isWhitespace;
    private String namespace;
    private String prefix;
    private String name;
    private String text;
    private boolean degenerated;
    private int attributeCount;
    private boolean parsedTopLevelStartTag;
    private String[] attributes;
    private String error;
    private boolean unresolved;
    public StringPool stringPool;
    private static char[] SINGLE_QUOTE;
    private static char[] DOUBLE_QUOTE;

    private void $$robo$$org_kxml2_io_KXmlParser$__constructor__() {
        this.elementStack = new String[16];
        this.nspStack = new String[8];
        this.nspCounts = new int[4];
        this.buffer = new char[8192];
        this.position = 0;
        this.limit = 0;
        this.attributes = new String[16];
        this.stringPool = new StringPool();
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$keepNamespaceAttributes() {
        this.keepNamespaceAttributes = true;
    }

    private final boolean $$robo$$org_kxml2_io_KXmlParser$adjustNsp() throws XmlPullParserException {
        int cut;
        int cut2;
        String attrName;
        int i;
        boolean any = false;
        for (i = 0; i < this.attributeCount << 2; i += 4) {
            String prefix;
            attrName = this.attributes[i + 2];
            cut2 = attrName.indexOf(58);
            if (cut2 != -1) {
                prefix = attrName.substring(0, cut2);
                attrName = attrName.substring(cut2 + 1);
            } else {
                if (!attrName.equals("xmlns")) continue;
                prefix = attrName;
                attrName = null;
            }
            if (!prefix.equals("xmlns")) {
                any = true;
                continue;
            }
            int n = this.depth;
            int n2 = this.nspCounts[n];
            this.nspCounts[n] = n2 + 1;
            int j = n2 << 1;
            this.nspStack = this.ensureCapacity(this.nspStack, j + 2);
            this.nspStack[j] = attrName;
            this.nspStack[j + 1] = this.attributes[i + 3];
            if (attrName != null && this.attributes[i + 3].isEmpty()) {
                this.checkRelaxed("illegal empty namespace");
            }
            if (this.keepNamespaceAttributes) {
                this.attributes[i] = "http://www.w3.org/2000/xmlns/";
                any = true;
                continue;
            }
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.attributes, (int)(i + 4), (Object)this.attributes, (int)i, (int)((--this.attributeCount << 2) - i));
            i -= 4;
        }
        if (any) {
            for (i = (this.attributeCount << 2) - 4; i >= 0; i -= 4) {
                attrName = this.attributes[i + 2];
                cut2 = attrName.indexOf(58);
                if (cut2 == 0 && !this.relaxed) {
                    throw new RuntimeException("illegal attribute name: " + attrName + " at " + this);
                }
                if (cut2 == -1) continue;
                String attrPrefix = attrName.substring(0, cut2);
                attrName = attrName.substring(cut2 + 1);
                String attrNs = this.getNamespace(attrPrefix);
                if (attrNs == null && !this.relaxed) {
                    throw new RuntimeException("Undefined Prefix: " + attrPrefix + " in " + this);
                }
                this.attributes[i] = attrNs;
                this.attributes[i + 1] = attrPrefix;
                this.attributes[i + 2] = attrName;
            }
        }
        if ((cut = this.name.indexOf(58)) == 0) {
            this.checkRelaxed("illegal tag name: " + this.name);
        }
        if (cut != -1) {
            this.prefix = this.name.substring(0, cut);
            this.name = this.name.substring(cut + 1);
        }
        this.namespace = this.getNamespace(this.prefix);
        if (this.namespace == null) {
            if (this.prefix != null) {
                this.checkRelaxed("undefined prefix: " + this.prefix);
            }
            this.namespace = "";
        }
        return any;
    }

    private final String[] $$robo$$org_kxml2_io_KXmlParser$ensureCapacity(String[] arr, int required) {
        if (arr.length >= required) {
            return arr;
        }
        String[] bigger = new String[required + 16];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)arr, (int)0, (Object)bigger, (int)0, (int)arr.length);
        return bigger;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$checkRelaxed(String errorMessage) throws XmlPullParserException {
        if (!this.relaxed) {
            throw new XmlPullParserException(errorMessage, this, null);
        }
        if (this.error == null) {
            this.error = "Error: " + errorMessage;
        }
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$next() throws XmlPullParserException, IOException {
        return this.next(false);
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$nextToken() throws XmlPullParserException, IOException {
        return this.next(true);
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$next(boolean justOneToken) throws IOException, XmlPullParserException {
        if (this.reader == null) {
            throw new XmlPullParserException("setInput() must be called first.", this, null);
        }
        if (this.type == 3) {
            --this.depth;
        }
        if (this.degenerated) {
            this.degenerated = false;
            this.type = 3;
            return this.type;
        }
        if (this.error != null) {
            if (justOneToken) {
                this.text = this.error;
                this.type = 9;
                this.error = null;
                return this.type;
            }
            this.error = null;
        }
        this.type = this.peekType(false);
        if (this.type == 998) {
            this.readXmlDeclaration();
            this.type = this.peekType(false);
        }
        this.text = null;
        this.isWhitespace = true;
        this.prefix = null;
        this.name = null;
        this.namespace = null;
        this.attributeCount = -1;
        boolean throwOnResolveFailure = !justOneToken;
        while (true) {
            switch (this.type) {
                case 2: {
                    this.parseStartTag(false, throwOnResolveFailure);
                    return this.type;
                }
                case 3: {
                    this.readEndTag();
                    return this.type;
                }
                case 1: {
                    return this.type;
                }
                case 6: {
                    if (justOneToken) {
                        StringBuilder entityTextBuilder = new StringBuilder();
                        this.readEntity(entityTextBuilder, true, throwOnResolveFailure, ValueContext.TEXT);
                        this.text = entityTextBuilder.toString();
                        break;
                    }
                }
                case 4: {
                    this.text = this.readValue('<', !justOneToken, throwOnResolveFailure, ValueContext.TEXT);
                    if (this.depth != 0 || !this.isWhitespace) break;
                    this.type = 7;
                    break;
                }
                case 5: {
                    this.read(START_CDATA);
                    this.text = this.readUntil(END_CDATA, true);
                    break;
                }
                case 9: {
                    String commentText = this.readComment(justOneToken);
                    if (!justOneToken) break;
                    this.text = commentText;
                    break;
                }
                case 8: {
                    this.read(START_PROCESSING_INSTRUCTION);
                    String processingInstruction = this.readUntil(END_PROCESSING_INSTRUCTION, justOneToken);
                    if (!justOneToken) break;
                    this.text = processingInstruction;
                    break;
                }
                case 10: {
                    this.readDoctype(justOneToken);
                    if (!this.parsedTopLevelStartTag) break;
                    throw new XmlPullParserException("Unexpected token", this, null);
                }
                default: {
                    throw new XmlPullParserException("Unexpected token", this, null);
                }
            }
            if (this.depth == 0 && (this.type == 6 || this.type == 4 || this.type == 5)) {
                throw new XmlPullParserException("Unexpected token", this, null);
            }
            if (justOneToken) {
                return this.type;
            }
            if (this.type == 7) {
                this.text = null;
            }
            int peek = this.peekType(false);
            if (this.text != null && !this.text.isEmpty() && peek < 4) {
                this.type = 4;
                return this.type;
            }
            this.type = peek;
        }
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$readUntil(char[] delimiter, boolean returnText) throws IOException, XmlPullParserException {
        int start = this.position;
        StringBuilder result = null;
        if (returnText && this.text != null) {
            result = new StringBuilder();
            result.append(this.text);
        }
        block0: while (true) {
            if (this.position + delimiter.length > this.limit) {
                if (start < this.position && returnText) {
                    if (result == null) {
                        result = new StringBuilder();
                    }
                    result.append(this.buffer, start, this.position - start);
                }
                if (!this.fillBuffer(delimiter.length)) {
                    this.checkRelaxed("Unexpected EOF");
                    this.type = 9;
                    return null;
                }
                start = this.position;
            }
            for (int i = 0; i < delimiter.length; ++i) {
                if (this.buffer[this.position + i] == delimiter[i]) continue;
                ++this.position;
                continue block0;
            }
            break;
        }
        int end = this.position;
        this.position += delimiter.length;
        if (!returnText) {
            return null;
        }
        if (result == null) {
            return this.stringPool.get(this.buffer, start, end - start);
        }
        result.append(this.buffer, start, end - start);
        return result.toString();
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readXmlDeclaration() throws IOException, XmlPullParserException {
        if (this.bufferStartLine != 0 || this.bufferStartColumn != 0 || this.position != 0) {
            this.checkRelaxed("processing instructions must not start with xml");
        }
        this.read(START_PROCESSING_INSTRUCTION);
        this.parseStartTag(true, true);
        if (this.attributeCount < 1 || !"version".equals(this.attributes[2])) {
            this.checkRelaxed("version expected");
        }
        this.version = this.attributes[3];
        int pos = 1;
        if (pos < this.attributeCount && "encoding".equals(this.attributes[6])) {
            this.encoding = this.attributes[7];
            ++pos;
        }
        if (pos < this.attributeCount && "standalone".equals(this.attributes[4 * pos + 2])) {
            String st = this.attributes[3 + 4 * pos];
            if ("yes".equals(st)) {
                this.standalone = Boolean.TRUE;
            } else if ("no".equals(st)) {
                this.standalone = Boolean.FALSE;
            } else {
                this.checkRelaxed("illegal standalone value: " + st);
            }
            ++pos;
        }
        if (pos != this.attributeCount) {
            this.checkRelaxed("unexpected attributes in XML declaration");
        }
        this.isWhitespace = true;
        this.text = null;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$readComment(boolean returnText) throws IOException, XmlPullParserException {
        this.read(START_COMMENT);
        if (this.relaxed) {
            return this.readUntil(END_COMMENT, returnText);
        }
        String commentText = this.readUntil(COMMENT_DOUBLE_DASH, returnText);
        if (this.peekCharacter() != 62) {
            throw new XmlPullParserException("Comments may not contain --", this, null);
        }
        ++this.position;
        return commentText;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readDoctype(boolean saveDtdText) throws IOException, XmlPullParserException {
        this.read(START_DOCTYPE);
        int startPosition = -1;
        if (saveDtdText) {
            this.bufferCapture = new StringBuilder();
            startPosition = this.position;
        }
        try {
            this.skip();
            this.rootElementName = this.readName();
            this.readExternalId(true, true);
            this.skip();
            if (this.peekCharacter() == 91) {
                this.readInternalSubset();
            }
            this.skip();
        }
        finally {
            if (saveDtdText) {
                this.bufferCapture.append(this.buffer, 0, this.position);
                this.bufferCapture.delete(0, startPosition);
                this.text = this.bufferCapture.toString();
                this.bufferCapture = null;
            }
        }
        this.read('>');
        this.skip();
    }

    private final boolean $$robo$$org_kxml2_io_KXmlParser$readExternalId(boolean requireSystemName, boolean assignFields) throws IOException, XmlPullParserException {
        int delimiter;
        this.skip();
        int c = this.peekCharacter();
        if (c == 83) {
            this.read(SYSTEM);
        } else if (c == 80) {
            this.read(PUBLIC);
            this.skip();
            if (assignFields) {
                this.publicId = this.readQuotedId(true);
            } else {
                this.readQuotedId(false);
            }
        } else {
            return false;
        }
        this.skip();
        if (!requireSystemName && (delimiter = this.peekCharacter()) != 34 && delimiter != 39) {
            return true;
        }
        if (assignFields) {
            this.systemId = this.readQuotedId(true);
        } else {
            this.readQuotedId(false);
        }
        return true;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$readQuotedId(boolean returnText) throws IOException, XmlPullParserException {
        char[] delimiter;
        int quote = this.peekCharacter();
        if (quote == 34) {
            delimiter = DOUBLE_QUOTE;
        } else if (quote == 39) {
            delimiter = SINGLE_QUOTE;
        } else {
            throw new XmlPullParserException("Expected a quoted string", this, null);
        }
        ++this.position;
        return this.readUntil(delimiter, returnText);
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readInternalSubset() throws IOException, XmlPullParserException {
        this.read('[');
        block9: while (true) {
            this.skip();
            if (this.peekCharacter() == 93) {
                ++this.position;
                return;
            }
            int declarationType = this.peekType(true);
            switch (declarationType) {
                case 11: {
                    this.readElementDeclaration();
                    continue block9;
                }
                case 13: {
                    this.readAttributeListDeclaration();
                    continue block9;
                }
                case 12: {
                    this.readEntityDeclaration();
                    continue block9;
                }
                case 14: {
                    this.readNotationDeclaration();
                    continue block9;
                }
                case 8: {
                    this.read(START_PROCESSING_INSTRUCTION);
                    this.readUntil(END_PROCESSING_INSTRUCTION, false);
                    continue block9;
                }
                case 9: {
                    this.readComment(false);
                    continue block9;
                }
                case 15: {
                    throw new XmlPullParserException("Parameter entity references are not supported", this, null);
                }
            }
            break;
        }
        throw new XmlPullParserException("Unexpected token", this, null);
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readElementDeclaration() throws IOException, XmlPullParserException {
        this.read(START_ELEMENT);
        this.skip();
        this.readName();
        this.readContentSpec();
        this.skip();
        this.read('>');
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readContentSpec() throws IOException, XmlPullParserException {
        this.skip();
        int c = this.peekCharacter();
        if (c == 40) {
            int depth = 0;
            do {
                if (c == 40) {
                    ++depth;
                } else if (c == 41) {
                    --depth;
                } else if (c == -1) {
                    throw new XmlPullParserException("Unterminated element content spec", this, null);
                }
                ++this.position;
                c = this.peekCharacter();
            } while (depth > 0);
            if (c == 42 || c == 63 || c == 43) {
                ++this.position;
            }
        } else if (c == EMPTY[0]) {
            this.read(EMPTY);
        } else if (c == ANY[0]) {
            this.read(ANY);
        } else {
            throw new XmlPullParserException("Expected element content spec", this, null);
        }
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readAttributeListDeclaration() throws IOException, XmlPullParserException {
        this.read(START_ATTLIST);
        this.skip();
        String elementName = this.readName();
        while (true) {
            String attributeName;
            int c;
            block15: {
                this.skip();
                c = this.peekCharacter();
                if (c == 62) {
                    ++this.position;
                    return;
                }
                attributeName = this.readName();
                this.skip();
                if (this.position + 1 >= this.limit && !this.fillBuffer(2)) {
                    throw new XmlPullParserException("Malformed attribute list", this, null);
                }
                if (this.buffer[this.position] == NOTATION[0] && this.buffer[this.position + 1] == NOTATION[1]) {
                    this.read(NOTATION);
                    this.skip();
                }
                if ((c = this.peekCharacter()) == 40) {
                    ++this.position;
                    while (true) {
                        this.skip();
                        this.readName();
                        this.skip();
                        c = this.peekCharacter();
                        if (c == 41) {
                            ++this.position;
                            break block15;
                        }
                        if (c != 124) break;
                        ++this.position;
                    }
                    throw new XmlPullParserException("Malformed attribute type", this, null);
                }
                this.readName();
            }
            this.skip();
            c = this.peekCharacter();
            if (c == 35) {
                ++this.position;
                c = this.peekCharacter();
                if (c == 82) {
                    this.read(REQUIRED);
                } else if (c == 73) {
                    this.read(IMPLIED);
                } else if (c == 70) {
                    this.read(FIXED);
                } else {
                    throw new XmlPullParserException("Malformed attribute type", this, null);
                }
                this.skip();
                c = this.peekCharacter();
            }
            if (c != 34 && c != 39) continue;
            ++this.position;
            String value = this.readValue((char)c, true, true, ValueContext.ATTRIBUTE);
            if (this.peekCharacter() == c) {
                ++this.position;
            }
            this.defineAttributeDefault(elementName, attributeName, value);
        }
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$defineAttributeDefault(String elementName, String attributeName, String value) {
        Map<String, String> elementAttributes;
        if (this.defaultAttributes == null) {
            this.defaultAttributes = new HashMap<String, Map<String, String>>();
        }
        if ((elementAttributes = this.defaultAttributes.get(elementName)) == null) {
            elementAttributes = new HashMap<String, String>();
            this.defaultAttributes.put(elementName, elementAttributes);
        }
        elementAttributes.put(attributeName, value);
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readEntityDeclaration() throws IOException, XmlPullParserException {
        String entityValue;
        this.read(START_ENTITY);
        boolean generalEntity = true;
        this.skip();
        if (this.peekCharacter() == 37) {
            generalEntity = false;
            ++this.position;
            this.skip();
        }
        String name = this.readName();
        this.skip();
        int quote = this.peekCharacter();
        if (quote == 34 || quote == 39) {
            ++this.position;
            entityValue = this.readValue((char)quote, true, false, ValueContext.ENTITY_DECLARATION);
            if (this.peekCharacter() == quote) {
                ++this.position;
            }
        } else if (this.readExternalId(true, false)) {
            entityValue = "";
            this.skip();
            if (this.peekCharacter() == NDATA[0]) {
                this.read(NDATA);
                this.skip();
                this.readName();
            }
        } else {
            throw new XmlPullParserException("Expected entity value or external ID", this, null);
        }
        if (generalEntity && this.processDocDecl) {
            if (this.documentEntities == null) {
                this.documentEntities = new HashMap<String, char[]>();
            }
            this.documentEntities.put(name, entityValue.toCharArray());
        }
        this.skip();
        this.read('>');
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readNotationDeclaration() throws IOException, XmlPullParserException {
        this.read(START_NOTATION);
        this.skip();
        this.readName();
        if (!this.readExternalId(false, false)) {
            throw new XmlPullParserException("Expected external ID or public ID for notation", this, null);
        }
        this.skip();
        this.read('>');
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readEndTag() throws IOException, XmlPullParserException {
        this.read('<');
        this.read('/');
        this.name = this.readName();
        this.skip();
        this.read('>');
        int sp = (this.depth - 1) * 4;
        if (this.depth == 0) {
            this.checkRelaxed("read end tag " + this.name + " with no tags open");
            this.type = 9;
            return;
        }
        if (this.name.equals(this.elementStack[sp + 3])) {
            this.namespace = this.elementStack[sp];
            this.prefix = this.elementStack[sp + 1];
            this.name = this.elementStack[sp + 2];
        } else if (!this.relaxed) {
            throw new XmlPullParserException("expected: /" + this.elementStack[sp + 3] + " read: " + this.name, this, null);
        }
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$peekType(boolean inDeclaration) throws IOException, XmlPullParserException {
        if (this.position >= this.limit && !this.fillBuffer(1)) {
            return 1;
        }
        switch (this.buffer[this.position]) {
            case '&': {
                return 6;
            }
            case '<': {
                if (this.position + 3 >= this.limit && !this.fillBuffer(4)) {
                    throw new XmlPullParserException("Dangling <", this, null);
                }
                switch (this.buffer[this.position + 1]) {
                    case '/': {
                        return 3;
                    }
                    case '?': {
                        if (!(this.position + 5 >= this.limit && !this.fillBuffer(6) || this.buffer[this.position + 2] != 'x' && this.buffer[this.position + 2] != 'X' || this.buffer[this.position + 3] != 'm' && this.buffer[this.position + 3] != 'M' || this.buffer[this.position + 4] != 'l' && this.buffer[this.position + 4] != 'L' || this.buffer[this.position + 5] != ' ')) {
                            return 998;
                        }
                        return 8;
                    }
                    case '!': {
                        switch (this.buffer[this.position + 2]) {
                            case 'D': {
                                return 10;
                            }
                            case '[': {
                                return 5;
                            }
                            case '-': {
                                return 9;
                            }
                            case 'E': {
                                switch (this.buffer[this.position + 3]) {
                                    case 'L': {
                                        return 11;
                                    }
                                    case 'N': {
                                        return 12;
                                    }
                                }
                                break;
                            }
                            case 'A': {
                                return 13;
                            }
                            case 'N': {
                                return 14;
                            }
                        }
                        throw new XmlPullParserException("Unexpected <!", this, null);
                    }
                }
                return 2;
            }
            case '%': {
                return inDeclaration ? 15 : 4;
            }
        }
        return 4;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$parseStartTag(boolean xmldecl, boolean throwOnResolveFailure) throws IOException, XmlPullParserException {
        Map<String, String> elementDefaultAttributes;
        if (!xmldecl) {
            this.read('<');
        }
        this.name = this.readName();
        this.attributeCount = 0;
        while (true) {
            this.skip();
            if (this.position >= this.limit && !this.fillBuffer(1)) {
                this.checkRelaxed("Unexpected EOF");
                return;
            }
            char c = this.buffer[this.position];
            if (xmldecl) {
                if (c == '?') {
                    ++this.position;
                    this.read('>');
                    return;
                }
            } else {
                if (c == '/') {
                    this.degenerated = true;
                    ++this.position;
                    this.skip();
                    this.read('>');
                    break;
                }
                if (c == '>') {
                    ++this.position;
                    break;
                }
            }
            String attrName = this.readName();
            int i = this.attributeCount++ * 4;
            this.attributes = this.ensureCapacity(this.attributes, i + 4);
            this.attributes[i] = "";
            this.attributes[i + 1] = null;
            this.attributes[i + 2] = attrName;
            this.skip();
            if (this.position >= this.limit && !this.fillBuffer(1)) {
                this.checkRelaxed("Unexpected EOF");
                return;
            }
            if (this.buffer[this.position] == '=') {
                ++this.position;
                this.skip();
                if (this.position >= this.limit && !this.fillBuffer(1)) {
                    this.checkRelaxed("Unexpected EOF");
                    return;
                }
                int delimiter = this.buffer[this.position];
                if (delimiter == 39 || delimiter == 34) {
                    ++this.position;
                } else if (this.relaxed) {
                    delimiter = 32;
                } else {
                    throw new XmlPullParserException("attr value delimiter missing!", this, null);
                }
                this.attributes[i + 3] = this.readValue((char)delimiter, true, throwOnResolveFailure, ValueContext.ATTRIBUTE);
                if (delimiter == 32 || this.peekCharacter() != delimiter) continue;
                ++this.position;
                continue;
            }
            if (this.relaxed) {
                this.attributes[i + 3] = attrName;
                continue;
            }
            this.checkRelaxed("Attr.value missing f. " + attrName);
            this.attributes[i + 3] = attrName;
        }
        int sp = this.depth++ * 4;
        if (this.depth == 1) {
            this.parsedTopLevelStartTag = true;
        }
        this.elementStack = this.ensureCapacity(this.elementStack, sp + 4);
        this.elementStack[sp + 3] = this.name;
        if (this.depth >= this.nspCounts.length) {
            int[] bigger = new int[this.depth + 4];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.nspCounts, (int)0, (int[])bigger, (int)0, (int)this.nspCounts.length);
            this.nspCounts = bigger;
        }
        this.nspCounts[this.depth] = this.nspCounts[this.depth - 1];
        if (this.processNsp) {
            this.adjustNsp();
        } else {
            this.namespace = "";
        }
        if (this.defaultAttributes != null && (elementDefaultAttributes = this.defaultAttributes.get(this.name)) != null) {
            for (Map.Entry<String, String> entry : elementDefaultAttributes.entrySet()) {
                if (this.getAttributeValue(null, entry.getKey()) != null) continue;
                int i = this.attributeCount++ * 4;
                this.attributes = this.ensureCapacity(this.attributes, i + 4);
                this.attributes[i] = "";
                this.attributes[i + 1] = null;
                this.attributes[i + 2] = entry.getKey();
                this.attributes[i + 3] = entry.getValue();
            }
        }
        this.elementStack[sp] = this.namespace;
        this.elementStack[sp + 1] = this.prefix;
        this.elementStack[sp + 2] = this.name;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$readEntity(StringBuilder out, boolean isEntityToken, boolean throwOnResolveFailure, ValueContext valueContext) throws IOException, XmlPullParserException {
        char[] resolved;
        int start;
        block16: {
            start = out.length();
            if (this.buffer[this.position++] != '&') {
                throw new AssertionError();
            }
            out.append('&');
            while (true) {
                int c;
                if ((c = this.peekCharacter()) == 59) {
                    out.append(';');
                    ++this.position;
                    break block16;
                }
                if (!(c >= 128 || c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95 || c == 45) && c != 35) break;
                ++this.position;
                out.append((char)c);
            }
            if (this.relaxed) {
                return;
            }
            throw new XmlPullParserException("unterminated entity ref", this, null);
        }
        String code = out.substring(start + 1, out.length() - 1);
        if (isEntityToken) {
            this.name = code;
        }
        if (code.startsWith("#")) {
            try {
                int c = code.startsWith("#x") ? Integer.parseInt(code.substring(2), 16) : Integer.parseInt(code.substring(1));
                out.delete(start, out.length());
                out.appendCodePoint(c);
                this.unresolved = false;
                return;
            }
            catch (NumberFormatException notANumber) {
                throw new XmlPullParserException("Invalid character reference: &" + code);
            }
            catch (IllegalArgumentException invalidCodePoint) {
                throw new XmlPullParserException("Invalid character reference: &" + code);
            }
        }
        if (valueContext == ValueContext.ENTITY_DECLARATION) {
            return;
        }
        String defaultEntity = DEFAULT_ENTITIES.get(code);
        if (defaultEntity != null) {
            out.delete(start, out.length());
            this.unresolved = false;
            out.append(defaultEntity);
            return;
        }
        if (this.documentEntities != null && (resolved = this.documentEntities.get(code)) != null) {
            out.delete(start, out.length());
            this.unresolved = false;
            if (this.processDocDecl) {
                this.pushContentSource(resolved);
            } else {
                out.append(resolved);
            }
            return;
        }
        if (this.systemId != null) {
            out.delete(start, out.length());
            return;
        }
        this.unresolved = true;
        if (throwOnResolveFailure) {
            this.checkRelaxed("unresolved: &" + code + ";");
        }
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$readValue(char delimiter, boolean resolveEntities, boolean throwOnResolveFailure, ValueContext valueContext) throws IOException, XmlPullParserException {
        int start = this.position;
        StringBuilder result = null;
        if (valueContext == ValueContext.TEXT && this.text != null) {
            result = new StringBuilder();
            result.append(this.text);
        }
        while (true) {
            int c;
            if (this.position >= this.limit) {
                if (start < this.position) {
                    if (result == null) {
                        result = new StringBuilder();
                    }
                    result.append(this.buffer, start, this.position - start);
                }
                if (!this.fillBuffer(1)) {
                    return result != null ? result.toString() : "";
                }
                start = this.position;
            }
            if ((c = this.buffer[this.position]) == delimiter || delimiter == ' ' && (c <= 32 || c == 62) || c == 38 && !resolveEntities) break;
            if (!(c == 13 || c == 10 && valueContext == ValueContext.ATTRIBUTE || c == 38 || c == 60 || c == 93 && valueContext == ValueContext.TEXT || c == 37 && valueContext == ValueContext.ENTITY_DECLARATION)) {
                this.isWhitespace &= c <= 32;
                ++this.position;
                continue;
            }
            if (result == null) {
                result = new StringBuilder();
            }
            result.append(this.buffer, start, this.position - start);
            if (c == 13) {
                if ((this.position + 1 < this.limit || this.fillBuffer(2)) && this.buffer[this.position + 1] == '\n') {
                    ++this.position;
                }
                c = valueContext == ValueContext.ATTRIBUTE ? 32 : 10;
            } else if (c == 10) {
                c = 32;
            } else {
                if (c == 38) {
                    this.isWhitespace = false;
                    this.readEntity(result, false, throwOnResolveFailure, valueContext);
                    start = this.position;
                    continue;
                }
                if (c == 60) {
                    if (valueContext == ValueContext.ATTRIBUTE) {
                        this.checkRelaxed("Illegal: \"<\" inside attribute value");
                    }
                    this.isWhitespace = false;
                } else if (c == 93) {
                    if ((this.position + 2 < this.limit || this.fillBuffer(3)) && this.buffer[this.position + 1] == ']' && this.buffer[this.position + 2] == '>') {
                        this.checkRelaxed("Illegal: \"]]>\" outside CDATA section");
                    }
                    this.isWhitespace = false;
                } else {
                    if (c == 37) {
                        throw new XmlPullParserException("This parser doesn't support parameter entities", this, null);
                    }
                    throw new AssertionError();
                }
            }
            result.append((char)c);
            start = ++this.position;
        }
        if (result == null) {
            return this.stringPool.get(this.buffer, start, this.position - start);
        }
        result.append(this.buffer, start, this.position - start);
        return result.toString();
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$read(char expected) throws IOException, XmlPullParserException {
        int c = this.peekCharacter();
        if (c != expected) {
            this.checkRelaxed("expected: '" + expected + "' actual: '" + (char)c + "'");
            if (c == -1) {
                return;
            }
        }
        ++this.position;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$read(char[] chars) throws IOException, XmlPullParserException {
        if (this.position + chars.length > this.limit && !this.fillBuffer(chars.length)) {
            this.checkRelaxed("expected: '" + new String(chars) + "' but was EOF");
            return;
        }
        for (int i = 0; i < chars.length; ++i) {
            if (this.buffer[this.position + i] == chars[i]) continue;
            this.checkRelaxed("expected: \"" + new String(chars) + "\" but was \"" + new String(this.buffer, this.position, chars.length) + "...\"");
        }
        this.position += chars.length;
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$peekCharacter() throws IOException, XmlPullParserException {
        if (this.position < this.limit || this.fillBuffer(1)) {
            return this.buffer[this.position];
        }
        return -1;
    }

    private final boolean $$robo$$org_kxml2_io_KXmlParser$fillBuffer(int minimum) throws IOException, XmlPullParserException {
        int total;
        while (this.nextContentSource != null) {
            if (this.position < this.limit) {
                throw new XmlPullParserException("Unbalanced entity!", this, null);
            }
            this.popContentSource();
            if (this.limit - this.position < minimum) continue;
            return true;
        }
        for (int i = 0; i < this.position; ++i) {
            if (this.buffer[i] == '\n') {
                ++this.bufferStartLine;
                this.bufferStartColumn = 0;
                continue;
            }
            ++this.bufferStartColumn;
        }
        if (this.bufferCapture != null) {
            this.bufferCapture.append(this.buffer, 0, this.position);
        }
        if (this.limit != this.position) {
            this.limit -= this.position;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.buffer, (int)this.position, (char[])this.buffer, (int)0, (int)this.limit);
        } else {
            this.limit = 0;
        }
        this.position = 0;
        while ((total = this.reader.read(this.buffer, this.limit, this.buffer.length - this.limit)) != -1) {
            this.limit += total;
            if (this.limit < minimum) continue;
            return true;
        }
        return false;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$readName() throws IOException, XmlPullParserException {
        if (this.position >= this.limit && !this.fillBuffer(1)) {
            this.checkRelaxed("name expected");
            return "";
        }
        int start = this.position;
        StringBuilder result = null;
        char c = this.buffer[this.position];
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == ':' || c >= '\u00c0' || this.relaxed) {
            ++this.position;
        } else {
            this.checkRelaxed("name expected");
            return "";
        }
        while (true) {
            if (this.position >= this.limit) {
                if (result == null) {
                    result = new StringBuilder();
                }
                result.append(this.buffer, start, this.position - start);
                if (!this.fillBuffer(1)) {
                    return result.toString();
                }
                start = this.position;
            }
            if (!((c = this.buffer[this.position]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == ':' || c == '.') && c < '\u00b7') break;
            ++this.position;
        }
        if (result == null) {
            return this.stringPool.get(this.buffer, start, this.position - start);
        }
        result.append(this.buffer, start, this.position - start);
        return result.toString();
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$skip() throws IOException, XmlPullParserException {
        char c;
        while ((this.position < this.limit || this.fillBuffer(1)) && (c = this.buffer[this.position]) <= ' ') {
            ++this.position;
        }
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$setInput(Reader reader) throws XmlPullParserException {
        this.reader = reader;
        this.type = 0;
        this.parsedTopLevelStartTag = false;
        this.name = null;
        this.namespace = null;
        this.degenerated = false;
        this.attributeCount = -1;
        this.encoding = null;
        this.version = null;
        this.standalone = null;
        if (reader == null) {
            return;
        }
        this.position = 0;
        this.limit = 0;
        this.bufferStartLine = 0;
        this.bufferStartColumn = 0;
        this.depth = 0;
        this.documentEntities = null;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$setInput(InputStream is, String charset) throws XmlPullParserException {
        boolean detectCharset;
        this.position = 0;
        this.limit = 0;
        boolean bl = detectCharset = charset == null;
        if (is == null) {
            throw new IllegalArgumentException("is == null");
        }
        try {
            if (detectCharset) {
                int i;
                int firstFourBytes = 0;
                while (this.limit < 4 && (i = is.read()) != -1) {
                    firstFourBytes = firstFourBytes << 8 | i;
                    this.buffer[this.limit++] = (char)i;
                }
                if (this.limit == 4) {
                    block1 : switch (firstFourBytes) {
                        case 65279: {
                            charset = "UTF-32BE";
                            this.limit = 0;
                            break;
                        }
                        case -131072: {
                            charset = "UTF-32LE";
                            this.limit = 0;
                            break;
                        }
                        case 60: {
                            charset = "UTF-32BE";
                            this.buffer[0] = 60;
                            this.limit = 1;
                            break;
                        }
                        case 0x3C000000: {
                            charset = "UTF-32LE";
                            this.buffer[0] = 60;
                            this.limit = 1;
                            break;
                        }
                        case 3932223: {
                            charset = "UTF-16BE";
                            this.buffer[0] = 60;
                            this.buffer[1] = 63;
                            this.limit = 2;
                            break;
                        }
                        case 1006649088: {
                            charset = "UTF-16LE";
                            this.buffer[0] = 60;
                            this.buffer[1] = 63;
                            this.limit = 2;
                            break;
                        }
                        case 1010792557: {
                            while ((i = is.read()) != -1) {
                                this.buffer[this.limit++] = (char)i;
                                if (i != 62) continue;
                                String s = new String(this.buffer, 0, this.limit);
                                int i0 = s.indexOf("encoding");
                                if (i0 == -1) break block1;
                                while (s.charAt(i0) != '\"' && s.charAt(i0) != '\'') {
                                    ++i0;
                                }
                                char deli = s.charAt(i0++);
                                int i1 = s.indexOf(deli, i0);
                                charset = s.substring(i0, i1);
                                break block1;
                            }
                            break;
                        }
                        default: {
                            if ((firstFourBytes & 0xFFFF0000) == -16842752) {
                                charset = "UTF-16BE";
                                this.buffer[0] = (char)(this.buffer[2] << 8 | this.buffer[3]);
                                this.limit = 1;
                                break;
                            }
                            if ((firstFourBytes & 0xFFFF0000) == -131072) {
                                charset = "UTF-16LE";
                                this.buffer[0] = (char)(this.buffer[3] << 8 | this.buffer[2]);
                                this.limit = 1;
                                break;
                            }
                            if ((firstFourBytes & 0xFFFFFF00) != -272908544) break;
                            charset = "UTF-8";
                            this.buffer[0] = this.buffer[3];
                            this.limit = 1;
                        }
                    }
                }
            }
            if (charset == null) {
                charset = "UTF-8";
            }
            int savedLimit = this.limit;
            this.setInput(new InputStreamReader(is, charset));
            this.encoding = charset;
            this.limit = savedLimit;
            if (!detectCharset && this.peekCharacter() == 65279) {
                --this.limit;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.buffer, (int)1, (char[])this.buffer, (int)0, (int)this.limit);
            }
        }
        catch (Exception e) {
            throw new XmlPullParserException("Invalid stream or encoding: " + e, this, e);
        }
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private final boolean $$robo$$org_kxml2_io_KXmlParser$getFeature(String feature) {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(feature)) {
            return this.processNsp;
        }
        if ("http://xmlpull.org/v1/doc/features.html#relaxed".equals(feature)) {
            return this.relaxed;
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-docdecl".equals(feature)) {
            return this.processDocDecl;
        }
        return false;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getInputEncoding() {
        return this.encoding;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$defineEntityReplacementText(String entity, String value) throws XmlPullParserException {
        if (this.processDocDecl) {
            throw new IllegalStateException("Entity replacement text may not be defined with DOCTYPE processing enabled.");
        }
        if (this.reader == null) {
            throw new IllegalStateException("Entity replacement text must be defined after setInput()");
        }
        if (this.documentEntities == null) {
            this.documentEntities = new HashMap<String, char[]>();
        }
        this.documentEntities.put(entity, value.toCharArray());
    }

    private final Object $$robo$$org_kxml2_io_KXmlParser$getProperty(String property) {
        if (property.equals("http://xmlpull.org/v1/doc/properties.html#xmldecl-version")) {
            return this.version;
        }
        if (property.equals("http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone")) {
            return this.standalone;
        }
        if (property.equals("http://xmlpull.org/v1/doc/properties.html#location")) {
            return this.location != null ? this.location : this.reader.toString();
        }
        return null;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getRootElementName() {
        return this.rootElementName;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getSystemId() {
        return this.systemId;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getPublicId() {
        return this.publicId;
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$getNamespaceCount(int depth) {
        if (depth > this.depth) {
            throw new IndexOutOfBoundsException();
        }
        return this.nspCounts[depth];
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getNamespacePrefix(int pos) {
        return this.nspStack[pos * 2];
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getNamespaceUri(int pos) {
        return this.nspStack[pos * 2 + 1];
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getNamespace(String prefix) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (int i = (this.getNamespaceCount(this.depth) << 1) - 2; i >= 0; i -= 2) {
            if (!(prefix == null ? this.nspStack[i] == null : prefix.equals(this.nspStack[i]))) continue;
            return this.nspStack[i + 1];
        }
        return null;
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$getDepth() {
        return this.depth;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getPositionDescription() {
        StringBuilder buf = new StringBuilder(this.type < TYPES.length ? TYPES[this.type] : "unknown");
        buf.append(' ');
        if (this.type == 2 || this.type == 3) {
            if (this.degenerated) {
                buf.append("(empty) ");
            }
            buf.append('<');
            if (this.type == 3) {
                buf.append('/');
            }
            if (this.prefix != null) {
                buf.append("{" + this.namespace + "}" + this.prefix + ":");
            }
            buf.append(this.name);
            int cnt = this.attributeCount * 4;
            for (int i = 0; i < cnt; i += 4) {
                buf.append(' ');
                if (this.attributes[i + 1] != null) {
                    buf.append("{" + this.attributes[i] + "}" + this.attributes[i + 1] + ":");
                }
                buf.append(this.attributes[i + 2] + "='" + this.attributes[i + 3] + "'");
            }
            buf.append('>');
        } else if (this.type != 7) {
            if (this.type != 4) {
                buf.append(this.getText());
            } else if (this.isWhitespace) {
                buf.append("(whitespace)");
            } else {
                String text = this.getText();
                if (text.length() > 16) {
                    text = text.substring(0, 16) + "...";
                }
                buf.append(text);
            }
        }
        buf.append("@" + this.getLineNumber() + ":" + this.getColumnNumber());
        if (this.location != null) {
            buf.append(" in ");
            buf.append(this.location);
        } else if (this.reader != null) {
            buf.append(" in ");
            buf.append(this.reader.toString());
        }
        return buf.toString();
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$getLineNumber() {
        int result = this.bufferStartLine;
        for (int i = 0; i < this.position; ++i) {
            if (this.buffer[i] != '\n') continue;
            ++result;
        }
        return result + 1;
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$getColumnNumber() {
        int result = this.bufferStartColumn;
        for (int i = 0; i < this.position; ++i) {
            if (this.buffer[i] == '\n') {
                result = 0;
                continue;
            }
            ++result;
        }
        return result + 1;
    }

    private final boolean $$robo$$org_kxml2_io_KXmlParser$isWhitespace() throws XmlPullParserException {
        if (this.type != 4 && this.type != 7 && this.type != 5) {
            throw new XmlPullParserException("Wrong event type", this, null);
        }
        return this.isWhitespace;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getText() {
        if (this.type < 4 || this.type == 6 && this.unresolved) {
            return null;
        }
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

    private final char[] $$robo$$org_kxml2_io_KXmlParser$getTextCharacters(int[] poslen) {
        String text = this.getText();
        if (text == null) {
            poslen[0] = -1;
            poslen[1] = -1;
            return null;
        }
        char[] result = text.toCharArray();
        poslen[0] = 0;
        poslen[1] = result.length;
        return result;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getNamespace() {
        return this.namespace;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getName() {
        return this.name;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getPrefix() {
        return this.prefix;
    }

    private final boolean $$robo$$org_kxml2_io_KXmlParser$isEmptyElementTag() throws XmlPullParserException {
        if (this.type != 2) {
            throw new XmlPullParserException("Wrong event type", this, null);
        }
        return this.degenerated;
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$getAttributeCount() {
        return this.attributeCount;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getAttributeType(int index) {
        return "CDATA";
    }

    private final boolean $$robo$$org_kxml2_io_KXmlParser$isAttributeDefault(int index) {
        return false;
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getAttributeNamespace(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[index * 4];
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getAttributeName(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[index * 4 + 2];
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getAttributePrefix(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[index * 4 + 1];
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getAttributeValue(int index) {
        if (index >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[index * 4 + 3];
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$getAttributeValue(String namespace, String name) {
        for (int i = this.attributeCount * 4 - 4; i >= 0; i -= 4) {
            if (!this.attributes[i + 2].equals(name) || namespace != null && !this.attributes[i].equals(namespace)) continue;
            return this.attributes[i + 3];
        }
        return null;
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$getEventType() throws XmlPullParserException {
        return this.type;
    }

    private final int $$robo$$org_kxml2_io_KXmlParser$nextTag() throws XmlPullParserException, IOException {
        this.next();
        if (this.type == 4 && this.isWhitespace) {
            this.next();
        }
        if (this.type != 3 && this.type != 2) {
            throw new XmlPullParserException("unexpected type", this, null);
        }
        return this.type;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (type != this.type || namespace != null && !namespace.equals(this.getNamespace()) || name != null && !name.equals(this.getName())) {
            throw new XmlPullParserException("expected: " + TYPES[type] + " {" + namespace + "}" + name, this, null);
        }
    }

    private final String $$robo$$org_kxml2_io_KXmlParser$nextText() throws XmlPullParserException, IOException {
        String result;
        if (this.type != 2) {
            throw new XmlPullParserException("precondition: START_TAG", this, null);
        }
        this.next();
        if (this.type == 4) {
            result = this.getText();
            this.next();
        } else {
            result = "";
        }
        if (this.type != 3) {
            throw new XmlPullParserException("END_TAG expected", this, null);
        }
        return result;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$setFeature(String feature, boolean value) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(feature)) {
            this.processNsp = value;
        } else if ("http://xmlpull.org/v1/doc/features.html#process-docdecl".equals(feature)) {
            this.processDocDecl = value;
        } else if ("http://xmlpull.org/v1/doc/features.html#relaxed".equals(feature)) {
            this.relaxed = value;
        } else {
            throw new XmlPullParserException("unsupported feature: " + feature, this, null);
        }
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$setProperty(String property, Object value) throws XmlPullParserException {
        if (!property.equals("http://xmlpull.org/v1/doc/properties.html#location")) {
            throw new XmlPullParserException("unsupported property: " + property);
        }
        this.location = String.valueOf(value);
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$pushContentSource(char[] newBuffer) {
        this.nextContentSource = new ContentSource(this.nextContentSource, this.buffer, this.position, this.limit);
        this.buffer = newBuffer;
        this.position = 0;
        this.limit = newBuffer.length;
    }

    private final void $$robo$$org_kxml2_io_KXmlParser$popContentSource() {
        this.buffer = this.nextContentSource.buffer;
        this.position = this.nextContentSource.position;
        this.limit = this.nextContentSource.limit;
        this.nextContentSource = this.nextContentSource.next;
    }

    static void __staticInitializer__() {
        DEFAULT_ENTITIES = new HashMap<String, String>();
        DEFAULT_ENTITIES.put("lt", "<");
        DEFAULT_ENTITIES.put("gt", ">");
        DEFAULT_ENTITIES.put("amp", "&");
        DEFAULT_ENTITIES.put("apos", "'");
        DEFAULT_ENTITIES.put("quot", "\"");
        START_COMMENT = new char[]{'<', '!', '-', '-'};
        END_COMMENT = new char[]{'-', '-', '>'};
        COMMENT_DOUBLE_DASH = new char[]{'-', '-'};
        START_CDATA = new char[]{'<', '!', '[', 'C', 'D', 'A', 'T', 'A', '['};
        END_CDATA = new char[]{']', ']', '>'};
        START_PROCESSING_INSTRUCTION = new char[]{'<', '?'};
        END_PROCESSING_INSTRUCTION = new char[]{'?', '>'};
        START_DOCTYPE = new char[]{'<', '!', 'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
        SYSTEM = new char[]{'S', 'Y', 'S', 'T', 'E', 'M'};
        PUBLIC = new char[]{'P', 'U', 'B', 'L', 'I', 'C'};
        START_ELEMENT = new char[]{'<', '!', 'E', 'L', 'E', 'M', 'E', 'N', 'T'};
        START_ATTLIST = new char[]{'<', '!', 'A', 'T', 'T', 'L', 'I', 'S', 'T'};
        START_ENTITY = new char[]{'<', '!', 'E', 'N', 'T', 'I', 'T', 'Y'};
        START_NOTATION = new char[]{'<', '!', 'N', 'O', 'T', 'A', 'T', 'I', 'O', 'N'};
        EMPTY = new char[]{'E', 'M', 'P', 'T', 'Y'};
        ANY = new char[]{'A', 'N', 'Y'};
        NDATA = new char[]{'N', 'D', 'A', 'T', 'A'};
        NOTATION = new char[]{'N', 'O', 'T', 'A', 'T', 'I', 'O', 'N'};
        REQUIRED = new char[]{'R', 'E', 'Q', 'U', 'I', 'R', 'E', 'D'};
        IMPLIED = new char[]{'I', 'M', 'P', 'L', 'I', 'E', 'D'};
        FIXED = new char[]{'F', 'I', 'X', 'E', 'D'};
        SINGLE_QUOTE = new char[]{'\''};
        DOUBLE_QUOTE = new char[]{'\"'};
    }

    private void __constructor__() {
        this.$$robo$$org_kxml2_io_KXmlParser$__constructor__();
    }

    public KXmlParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_kxml2_io_KXmlParser$__constructor__(), 0, this);
    }

    public void keepNamespaceAttributes() {
        InvokeDynamicSupport.bootstrap("keepNamespaceAttributes", $$robo$$org_kxml2_io_KXmlParser$keepNamespaceAttributes(), 0, this);
    }

    private boolean adjustNsp() throws XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrap("adjustNsp", $$robo$$org_kxml2_io_KXmlParser$adjustNsp(), 0, this);
    }

    private String[] ensureCapacity(String[] stringArray, int n) {
        return InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$org_kxml2_io_KXmlParser$ensureCapacity(java.lang.String[] int ), 0, this, stringArray, n);
    }

    private void checkRelaxed(String string2) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("checkRelaxed", $$robo$$org_kxml2_io_KXmlParser$checkRelaxed(java.lang.String ), 0, this, string2);
    }

    @Override
    public int next() throws XmlPullParserException, IOException {
        return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$org_kxml2_io_KXmlParser$next(), 0, this);
    }

    @Override
    public int nextToken() throws XmlPullParserException, IOException {
        return (int)InvokeDynamicSupport.bootstrap("nextToken", $$robo$$org_kxml2_io_KXmlParser$nextToken(), 0, this);
    }

    private int next(boolean bl) throws IOException, XmlPullParserException {
        return (int)InvokeDynamicSupport.bootstrap("next", $$robo$$org_kxml2_io_KXmlParser$next(boolean ), 0, this, bl);
    }

    private String readUntil(char[] cArray, boolean bl) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrap("readUntil", $$robo$$org_kxml2_io_KXmlParser$readUntil(char[] boolean ), 0, this, cArray, bl);
    }

    private void readXmlDeclaration() throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readXmlDeclaration", $$robo$$org_kxml2_io_KXmlParser$readXmlDeclaration(), 0, this);
    }

    private String readComment(boolean bl) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrap("readComment", $$robo$$org_kxml2_io_KXmlParser$readComment(boolean ), 0, this, bl);
    }

    private void readDoctype(boolean bl) throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readDoctype", $$robo$$org_kxml2_io_KXmlParser$readDoctype(boolean ), 0, this, bl);
    }

    private boolean readExternalId(boolean bl, boolean bl2) throws IOException, XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrap("readExternalId", $$robo$$org_kxml2_io_KXmlParser$readExternalId(boolean boolean ), 0, this, bl, bl2);
    }

    private String readQuotedId(boolean bl) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrap("readQuotedId", $$robo$$org_kxml2_io_KXmlParser$readQuotedId(boolean ), 0, this, bl);
    }

    private void readInternalSubset() throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readInternalSubset", $$robo$$org_kxml2_io_KXmlParser$readInternalSubset(), 0, this);
    }

    private void readElementDeclaration() throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readElementDeclaration", $$robo$$org_kxml2_io_KXmlParser$readElementDeclaration(), 0, this);
    }

    private void readContentSpec() throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readContentSpec", $$robo$$org_kxml2_io_KXmlParser$readContentSpec(), 0, this);
    }

    private void readAttributeListDeclaration() throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readAttributeListDeclaration", $$robo$$org_kxml2_io_KXmlParser$readAttributeListDeclaration(), 0, this);
    }

    private void defineAttributeDefault(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("defineAttributeDefault", $$robo$$org_kxml2_io_KXmlParser$defineAttributeDefault(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    private void readEntityDeclaration() throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readEntityDeclaration", $$robo$$org_kxml2_io_KXmlParser$readEntityDeclaration(), 0, this);
    }

    private void readNotationDeclaration() throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readNotationDeclaration", $$robo$$org_kxml2_io_KXmlParser$readNotationDeclaration(), 0, this);
    }

    private void readEndTag() throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readEndTag", $$robo$$org_kxml2_io_KXmlParser$readEndTag(), 0, this);
    }

    private int peekType(boolean bl) throws IOException, XmlPullParserException {
        return (int)InvokeDynamicSupport.bootstrap("peekType", $$robo$$org_kxml2_io_KXmlParser$peekType(boolean ), 0, this, bl);
    }

    private void parseStartTag(boolean bl, boolean bl2) throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("parseStartTag", $$robo$$org_kxml2_io_KXmlParser$parseStartTag(boolean boolean ), 0, this, bl, bl2);
    }

    private void readEntity(StringBuilder stringBuilder, boolean bl, boolean bl2, ValueContext valueContext) throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("readEntity", $$robo$$org_kxml2_io_KXmlParser$readEntity(java.lang.StringBuilder boolean boolean org.kxml2.io.KXmlParser$ValueContext ), 0, this, stringBuilder, bl, bl2, valueContext);
    }

    private String readValue(char c, boolean bl, boolean bl2, ValueContext valueContext) throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrap("readValue", $$robo$$org_kxml2_io_KXmlParser$readValue(char boolean boolean org.kxml2.io.KXmlParser$ValueContext ), 0, this, c, bl, bl2, valueContext);
    }

    private void read(char c) throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("read", $$robo$$org_kxml2_io_KXmlParser$read(char ), 0, this, c);
    }

    private void read(char[] cArray) throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("read", $$robo$$org_kxml2_io_KXmlParser$read(char[] ), 0, this, cArray);
    }

    private int peekCharacter() throws IOException, XmlPullParserException {
        return (int)InvokeDynamicSupport.bootstrap("peekCharacter", $$robo$$org_kxml2_io_KXmlParser$peekCharacter(), 0, this);
    }

    private boolean fillBuffer(int n) throws IOException, XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrap("fillBuffer", $$robo$$org_kxml2_io_KXmlParser$fillBuffer(int ), 0, this, n);
    }

    private String readName() throws IOException, XmlPullParserException {
        return InvokeDynamicSupport.bootstrap("readName", $$robo$$org_kxml2_io_KXmlParser$readName(), 0, this);
    }

    private void skip() throws IOException, XmlPullParserException {
        InvokeDynamicSupport.bootstrap("skip", $$robo$$org_kxml2_io_KXmlParser$skip(), 0, this);
    }

    @Override
    public void setInput(Reader reader) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("setInput", $$robo$$org_kxml2_io_KXmlParser$setInput(java.io.Reader ), 0, this, reader);
    }

    @Override
    public void setInput(InputStream inputStream, String string2) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("setInput", $$robo$$org_kxml2_io_KXmlParser$setInput(java.io.InputStream java.lang.String ), 0, this, inputStream, string2);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$org_kxml2_io_KXmlParser$close(), 0, this);
    }

    @Override
    public boolean getFeature(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getFeature", $$robo$$org_kxml2_io_KXmlParser$getFeature(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getInputEncoding() {
        return InvokeDynamicSupport.bootstrap("getInputEncoding", $$robo$$org_kxml2_io_KXmlParser$getInputEncoding(), 0, this);
    }

    @Override
    public void defineEntityReplacementText(String string2, String string3) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("defineEntityReplacementText", $$robo$$org_kxml2_io_KXmlParser$defineEntityReplacementText(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public Object getProperty(String string2) {
        return InvokeDynamicSupport.bootstrap("getProperty", $$robo$$org_kxml2_io_KXmlParser$getProperty(java.lang.String ), 0, this, string2);
    }

    public String getRootElementName() {
        return InvokeDynamicSupport.bootstrap("getRootElementName", $$robo$$org_kxml2_io_KXmlParser$getRootElementName(), 0, this);
    }

    public String getSystemId() {
        return InvokeDynamicSupport.bootstrap("getSystemId", $$robo$$org_kxml2_io_KXmlParser$getSystemId(), 0, this);
    }

    public String getPublicId() {
        return InvokeDynamicSupport.bootstrap("getPublicId", $$robo$$org_kxml2_io_KXmlParser$getPublicId(), 0, this);
    }

    @Override
    public int getNamespaceCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNamespaceCount", $$robo$$org_kxml2_io_KXmlParser$getNamespaceCount(int ), 0, this, n);
    }

    @Override
    public String getNamespacePrefix(int n) {
        return InvokeDynamicSupport.bootstrap("getNamespacePrefix", $$robo$$org_kxml2_io_KXmlParser$getNamespacePrefix(int ), 0, this, n);
    }

    @Override
    public String getNamespaceUri(int n) {
        return InvokeDynamicSupport.bootstrap("getNamespaceUri", $$robo$$org_kxml2_io_KXmlParser$getNamespaceUri(int ), 0, this, n);
    }

    @Override
    public String getNamespace(String string2) {
        return InvokeDynamicSupport.bootstrap("getNamespace", $$robo$$org_kxml2_io_KXmlParser$getNamespace(java.lang.String ), 0, this, string2);
    }

    @Override
    public int getDepth() {
        return (int)InvokeDynamicSupport.bootstrap("getDepth", $$robo$$org_kxml2_io_KXmlParser$getDepth(), 0, this);
    }

    @Override
    public String getPositionDescription() {
        return InvokeDynamicSupport.bootstrap("getPositionDescription", $$robo$$org_kxml2_io_KXmlParser$getPositionDescription(), 0, this);
    }

    @Override
    public int getLineNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getLineNumber", $$robo$$org_kxml2_io_KXmlParser$getLineNumber(), 0, this);
    }

    @Override
    public int getColumnNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getColumnNumber", $$robo$$org_kxml2_io_KXmlParser$getColumnNumber(), 0, this);
    }

    @Override
    public boolean isWhitespace() throws XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrap("isWhitespace", $$robo$$org_kxml2_io_KXmlParser$isWhitespace(), 0, this);
    }

    @Override
    public String getText() {
        return InvokeDynamicSupport.bootstrap("getText", $$robo$$org_kxml2_io_KXmlParser$getText(), 0, this);
    }

    @Override
    public char[] getTextCharacters(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getTextCharacters", $$robo$$org_kxml2_io_KXmlParser$getTextCharacters(int[] ), 0, this, nArray);
    }

    @Override
    public String getNamespace() {
        return InvokeDynamicSupport.bootstrap("getNamespace", $$robo$$org_kxml2_io_KXmlParser$getNamespace(), 0, this);
    }

    @Override
    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$org_kxml2_io_KXmlParser$getName(), 0, this);
    }

    @Override
    public String getPrefix() {
        return InvokeDynamicSupport.bootstrap("getPrefix", $$robo$$org_kxml2_io_KXmlParser$getPrefix(), 0, this);
    }

    @Override
    public boolean isEmptyElementTag() throws XmlPullParserException {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmptyElementTag", $$robo$$org_kxml2_io_KXmlParser$isEmptyElementTag(), 0, this);
    }

    @Override
    public int getAttributeCount() {
        return (int)InvokeDynamicSupport.bootstrap("getAttributeCount", $$robo$$org_kxml2_io_KXmlParser$getAttributeCount(), 0, this);
    }

    @Override
    public String getAttributeType(int n) {
        return InvokeDynamicSupport.bootstrap("getAttributeType", $$robo$$org_kxml2_io_KXmlParser$getAttributeType(int ), 0, this, n);
    }

    @Override
    public boolean isAttributeDefault(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAttributeDefault", $$robo$$org_kxml2_io_KXmlParser$isAttributeDefault(int ), 0, this, n);
    }

    @Override
    public String getAttributeNamespace(int n) {
        return InvokeDynamicSupport.bootstrap("getAttributeNamespace", $$robo$$org_kxml2_io_KXmlParser$getAttributeNamespace(int ), 0, this, n);
    }

    @Override
    public String getAttributeName(int n) {
        return InvokeDynamicSupport.bootstrap("getAttributeName", $$robo$$org_kxml2_io_KXmlParser$getAttributeName(int ), 0, this, n);
    }

    @Override
    public String getAttributePrefix(int n) {
        return InvokeDynamicSupport.bootstrap("getAttributePrefix", $$robo$$org_kxml2_io_KXmlParser$getAttributePrefix(int ), 0, this, n);
    }

    @Override
    public String getAttributeValue(int n) {
        return InvokeDynamicSupport.bootstrap("getAttributeValue", $$robo$$org_kxml2_io_KXmlParser$getAttributeValue(int ), 0, this, n);
    }

    @Override
    public String getAttributeValue(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getAttributeValue", $$robo$$org_kxml2_io_KXmlParser$getAttributeValue(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public int getEventType() throws XmlPullParserException {
        return (int)InvokeDynamicSupport.bootstrap("getEventType", $$robo$$org_kxml2_io_KXmlParser$getEventType(), 0, this);
    }

    @Override
    public int nextTag() throws XmlPullParserException, IOException {
        return (int)InvokeDynamicSupport.bootstrap("nextTag", $$robo$$org_kxml2_io_KXmlParser$nextTag(), 0, this);
    }

    @Override
    public void require(int n, String string2, String string3) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("require", $$robo$$org_kxml2_io_KXmlParser$require(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
    }

    @Override
    public String nextText() throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("nextText", $$robo$$org_kxml2_io_KXmlParser$nextText(), 0, this);
    }

    @Override
    public void setFeature(String string2, boolean bl) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("setFeature", $$robo$$org_kxml2_io_KXmlParser$setFeature(java.lang.String boolean ), 0, this, string2, bl);
    }

    @Override
    public void setProperty(String string2, Object object) throws XmlPullParserException {
        InvokeDynamicSupport.bootstrap("setProperty", $$robo$$org_kxml2_io_KXmlParser$setProperty(java.lang.String java.lang.Object ), 0, this, string2, object);
    }

    private void pushContentSource(char[] cArray) {
        InvokeDynamicSupport.bootstrap("pushContentSource", $$robo$$org_kxml2_io_KXmlParser$pushContentSource(char[] ), 0, this, cArray);
    }

    private void popContentSource() {
        InvokeDynamicSupport.bootstrap("popContentSource", $$robo$$org_kxml2_io_KXmlParser$popContentSource(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(KXmlParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KXmlParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ContentSource
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ContentSource next;
        private char[] buffer;
        private int position;
        private int limit;

        private void $$robo$$org_kxml2_io_KXmlParser_ContentSource$__constructor__(ContentSource next, char[] buffer, int position, int limit) {
            this.next = next;
            this.buffer = buffer;
            this.position = position;
            this.limit = limit;
        }

        private void __constructor__(ContentSource contentSource, char[] cArray, int n, int n2) {
            this.$$robo$$org_kxml2_io_KXmlParser_ContentSource$__constructor__(contentSource, cArray, n, n2);
        }

        ContentSource(ContentSource contentSource, char[] cArray, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_kxml2_io_KXmlParser_ContentSource$__constructor__(org.kxml2.io.KXmlParser$ContentSource char[] int int ), 0, this, contentSource, cArray, n, n2);
        }

        public /* synthetic */ ContentSource() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ContentSource)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    public static final class ValueContext
    extends Enum<ValueContext> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ValueContext ATTRIBUTE;
        public static /* enum */ ValueContext TEXT;
        public static /* enum */ ValueContext ENTITY_DECLARATION;
        private static /* synthetic */ ValueContext[] $VALUES;

        private static final ValueContext[] $$robo$$org_kxml2_io_KXmlParser_ValueContext$values() {
            return (ValueContext[])$VALUES.clone();
        }

        private static final ValueContext $$robo$$org_kxml2_io_KXmlParser_ValueContext$valueOf(String name) {
            return Enum.valueOf(ValueContext.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$org_kxml2_io_KXmlParser_ValueContext$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            ATTRIBUTE = new ValueContext();
            TEXT = new ValueContext();
            ENTITY_DECLARATION = new ValueContext();
            $VALUES = new ValueContext[]{ATTRIBUTE, TEXT, ENTITY_DECLARATION};
        }

        public static ValueContext[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$org_kxml2_io_KXmlParser_ValueContext$values(), 0);
        }

        public static ValueContext valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$org_kxml2_io_KXmlParser_ValueContext$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$org_kxml2_io_KXmlParser_ValueContext$__constructor__(string2, n);
        }

        private ValueContext() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$org_kxml2_io_KXmlParser_ValueContext$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ValueContext.class);
        }

        public /* synthetic */ ValueContext() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ValueContext)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

