/*
 * Decompiled with CFR 0.152.
 */
package android.accessibilityservice;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.os.Handler;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class FingerprintGestureController
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int FINGERPRINT_GESTURE_SWIPE_RIGHT = 1;
    public static int FINGERPRINT_GESTURE_SWIPE_LEFT = 2;
    public static int FINGERPRINT_GESTURE_SWIPE_UP = 4;
    public static int FINGERPRINT_GESTURE_SWIPE_DOWN = 8;
    private static String LOG_TAG = "FingerprintGestureController";
    private Object mLock;
    private IAccessibilityServiceConnection mAccessibilityServiceConnection;
    private ArrayMap<FingerprintGestureCallback, Handler> mCallbackHandlerMap;

    @VisibleForTesting
    private void $$robo$$android_accessibilityservice_FingerprintGestureController$__constructor__(IAccessibilityServiceConnection connection) {
        this.mLock = new Object();
        this.mCallbackHandlerMap = new ArrayMap(1);
        this.mAccessibilityServiceConnection = connection;
    }

    private final boolean $$robo$$android_accessibilityservice_FingerprintGestureController$isGestureDetectionAvailable() {
        try {
            return this.mAccessibilityServiceConnection.isFingerprintGestureDetectionAvailable();
        }
        catch (RemoteException re) {
            Log.w("FingerprintGestureController", "Failed to check if fingerprint gestures are active", re);
            re.rethrowFromSystemServer();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accessibilityservice_FingerprintGestureController$registerFingerprintGestureCallback(FingerprintGestureCallback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackHandlerMap.put(callback, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accessibilityservice_FingerprintGestureController$unregisterFingerprintGestureCallback(FingerprintGestureCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackHandlerMap.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accessibilityservice_FingerprintGestureController$onGestureDetectionActiveChanged(boolean active) {
        ArrayMap<FingerprintGestureCallback, Handler> handlerMap;
        Object object = this.mLock;
        synchronized (object) {
            handlerMap = new ArrayMap<FingerprintGestureCallback, Handler>(this.mCallbackHandlerMap);
        }
        int numListeners = handlerMap.size();
        for (int i = 0; i < numListeners; ++i) {
            FingerprintGestureCallback callback = handlerMap.keyAt(i);
            Handler handler = handlerMap.valueAt(i);
            if (handler != null) {
                handler.post(() -> callback.onGestureDetectionAvailabilityChanged(active));
                continue;
            }
            callback.onGestureDetectionAvailabilityChanged(active);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_accessibilityservice_FingerprintGestureController$onGesture(int gesture) {
        ArrayMap<FingerprintGestureCallback, Handler> handlerMap;
        Object object = this.mLock;
        synchronized (object) {
            handlerMap = new ArrayMap<FingerprintGestureCallback, Handler>(this.mCallbackHandlerMap);
        }
        int numListeners = handlerMap.size();
        for (int i = 0; i < numListeners; ++i) {
            FingerprintGestureCallback callback = handlerMap.keyAt(i);
            Handler handler = handlerMap.valueAt(i);
            if (handler != null) {
                handler.post(() -> callback.onGestureDetected(gesture));
                continue;
            }
            callback.onGestureDetected(gesture);
        }
    }

    private void __constructor__(IAccessibilityServiceConnection iAccessibilityServiceConnection) {
        this.$$robo$$android_accessibilityservice_FingerprintGestureController$__constructor__(iAccessibilityServiceConnection);
    }

    public FingerprintGestureController(IAccessibilityServiceConnection iAccessibilityServiceConnection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_FingerprintGestureController$__constructor__(android.accessibilityservice.IAccessibilityServiceConnection ), this, iAccessibilityServiceConnection);
    }

    public boolean isGestureDetectionAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGestureDetectionAvailable", $$robo$$android_accessibilityservice_FingerprintGestureController$isGestureDetectionAvailable(), this);
    }

    public void registerFingerprintGestureCallback(FingerprintGestureCallback fingerprintGestureCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerFingerprintGestureCallback", $$robo$$android_accessibilityservice_FingerprintGestureController$registerFingerprintGestureCallback(android.accessibilityservice.FingerprintGestureController$FingerprintGestureCallback android.os.Handler ), this, fingerprintGestureCallback, handler);
    }

    public void unregisterFingerprintGestureCallback(FingerprintGestureCallback fingerprintGestureCallback) {
        InvokeDynamicSupport.bootstrap("unregisterFingerprintGestureCallback", $$robo$$android_accessibilityservice_FingerprintGestureController$unregisterFingerprintGestureCallback(android.accessibilityservice.FingerprintGestureController$FingerprintGestureCallback ), this, fingerprintGestureCallback);
    }

    public void onGestureDetectionActiveChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onGestureDetectionActiveChanged", $$robo$$android_accessibilityservice_FingerprintGestureController$onGestureDetectionActiveChanged(boolean ), this, bl);
    }

    public void onGesture(int n) {
        InvokeDynamicSupport.bootstrap("onGesture", $$robo$$android_accessibilityservice_FingerprintGestureController$onGesture(int ), this, n);
    }

    public /* synthetic */ FingerprintGestureController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FingerprintGestureController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class FingerprintGestureCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_accessibilityservice_FingerprintGestureController_FingerprintGestureCallback$__constructor__() {
        }

        private final void $$robo$$android_accessibilityservice_FingerprintGestureController_FingerprintGestureCallback$onGestureDetectionAvailabilityChanged(boolean available) {
        }

        private final void $$robo$$android_accessibilityservice_FingerprintGestureController_FingerprintGestureCallback$onGestureDetected(int gesture) {
        }

        private void __constructor__() {
            this.$$robo$$android_accessibilityservice_FingerprintGestureController_FingerprintGestureCallback$__constructor__();
        }

        public FingerprintGestureCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_accessibilityservice_FingerprintGestureController_FingerprintGestureCallback$__constructor__(), this);
        }

        public void onGestureDetectionAvailabilityChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onGestureDetectionAvailabilityChanged", $$robo$$android_accessibilityservice_FingerprintGestureController_FingerprintGestureCallback$onGestureDetectionAvailabilityChanged(boolean ), this, bl);
        }

        public void onGestureDetected(int n) {
            InvokeDynamicSupport.bootstrap("onGestureDetected", $$robo$$android_accessibilityservice_FingerprintGestureController_FingerprintGestureCallback$onGestureDetected(int ), this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FingerprintGestureCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

