/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.FloatKeyframeSet;
import android.animation.IntKeyframeSet;
import android.animation.Keyframe;
import android.animation.Keyframes;
import android.animation.PathKeyframes;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.util.Log;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyframeSet
implements Keyframes,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    int mNumKeyframes;
    Keyframe mFirstKeyframe;
    Keyframe mLastKeyframe;
    TimeInterpolator mInterpolator;
    List<Keyframe> mKeyframes;
    TypeEvaluator mEvaluator;

    private void $$robo$$android_animation_KeyframeSet$__constructor__(Keyframe ... keyframes) {
        this.mNumKeyframes = keyframes.length;
        this.mKeyframes = Arrays.asList(keyframes);
        this.mFirstKeyframe = keyframes[0];
        this.mLastKeyframe = keyframes[this.mNumKeyframes - 1];
        this.mInterpolator = this.mLastKeyframe.getInterpolator();
    }

    private final List<Keyframe> $$robo$$android_animation_KeyframeSet$getKeyframes() {
        return this.mKeyframes;
    }

    private static final KeyframeSet $$robo$$android_animation_KeyframeSet$ofInt(int ... values) {
        int numKeyframes = values.length;
        Keyframe.IntKeyframe[] keyframes = new Keyframe.IntKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f);
            keyframes[1] = (Keyframe.IntKeyframe)Keyframe.ofInt(1.0f, values[0]);
        } else {
            keyframes[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f, values[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.IntKeyframe)Keyframe.ofInt((float)i / (float)(numKeyframes - 1), values[i]);
            }
        }
        return new IntKeyframeSet(keyframes);
    }

    private static final KeyframeSet $$robo$$android_animation_KeyframeSet$ofFloat(float ... values) {
        boolean badValue = false;
        int numKeyframes = values.length;
        Keyframe.FloatKeyframe[] keyframes = new Keyframe.FloatKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f);
            keyframes[1] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(1.0f, values[0]);
            if (Float.isNaN(values[0])) {
                badValue = true;
            }
        } else {
            keyframes[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f, values[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.FloatKeyframe)Keyframe.ofFloat((float)i / (float)(numKeyframes - 1), values[i]);
                if (!Float.isNaN(values[i])) continue;
                badValue = true;
            }
        }
        if (badValue) {
            Log.w("Animator", "Bad value (NaN) in float animator");
        }
        return new FloatKeyframeSet(keyframes);
    }

    private static final KeyframeSet $$robo$$android_animation_KeyframeSet$ofKeyframe(Keyframe ... keyframes) {
        int numKeyframes = keyframes.length;
        boolean hasFloat = false;
        boolean hasInt = false;
        boolean hasOther = false;
        for (int i = 0; i < numKeyframes; ++i) {
            if (keyframes[i] instanceof Keyframe.FloatKeyframe) {
                hasFloat = true;
                continue;
            }
            if (keyframes[i] instanceof Keyframe.IntKeyframe) {
                hasInt = true;
                continue;
            }
            hasOther = true;
        }
        if (hasFloat && !hasInt && !hasOther) {
            Keyframe.FloatKeyframe[] floatKeyframes = new Keyframe.FloatKeyframe[numKeyframes];
            for (int i = 0; i < numKeyframes; ++i) {
                floatKeyframes[i] = (Keyframe.FloatKeyframe)keyframes[i];
            }
            return new FloatKeyframeSet(floatKeyframes);
        }
        if (hasInt && !hasFloat && !hasOther) {
            Keyframe.IntKeyframe[] intKeyframes = new Keyframe.IntKeyframe[numKeyframes];
            for (int i = 0; i < numKeyframes; ++i) {
                intKeyframes[i] = (Keyframe.IntKeyframe)keyframes[i];
            }
            return new IntKeyframeSet(intKeyframes);
        }
        return new KeyframeSet(keyframes);
    }

    private static final KeyframeSet $$robo$$android_animation_KeyframeSet$ofObject(Object ... values) {
        int numKeyframes = values.length;
        Keyframe[] keyframes = new Keyframe.ObjectKeyframe[Math.max(numKeyframes, 2)];
        if (numKeyframes == 1) {
            keyframes[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f);
            keyframes[1] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(1.0f, values[0]);
        } else {
            keyframes[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f, values[0]);
            for (int i = 1; i < numKeyframes; ++i) {
                keyframes[i] = (Keyframe.ObjectKeyframe)Keyframe.ofObject((float)i / (float)(numKeyframes - 1), values[i]);
            }
        }
        return new KeyframeSet(keyframes);
    }

    private static final PathKeyframes $$robo$$android_animation_KeyframeSet$ofPath(Path path) {
        return new PathKeyframes(path);
    }

    private static final PathKeyframes $$robo$$android_animation_KeyframeSet$ofPath(Path path, float error) {
        return new PathKeyframes(path, error);
    }

    private final void $$robo$$android_animation_KeyframeSet$setEvaluator(TypeEvaluator evaluator) {
        this.mEvaluator = evaluator;
    }

    private final Class $$robo$$android_animation_KeyframeSet$getType() {
        return this.mFirstKeyframe.getType();
    }

    private final KeyframeSet $$robo$$android_animation_KeyframeSet$clone() {
        List<Keyframe> keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe[] newKeyframes = new Keyframe[numKeyframes];
        for (int i = 0; i < numKeyframes; ++i) {
            newKeyframes[i] = keyframes.get(i).clone();
        }
        KeyframeSet newSet = new KeyframeSet(newKeyframes);
        return newSet;
    }

    private final Object $$robo$$android_animation_KeyframeSet$getValue(float fraction2) {
        if (this.mNumKeyframes == 2) {
            if (this.mInterpolator != null) {
                fraction2 = this.mInterpolator.getInterpolation(fraction2);
            }
            return this.mEvaluator.evaluate(fraction2, this.mFirstKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        if (fraction2 <= 0.0f) {
            Keyframe nextKeyframe = this.mKeyframes.get(1);
            TimeInterpolator interpolator2 = nextKeyframe.getInterpolator();
            if (interpolator2 != null) {
                fraction2 = interpolator2.getInterpolation(fraction2);
            }
            float prevFraction = this.mFirstKeyframe.getFraction();
            float intervalFraction = (fraction2 - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, this.mFirstKeyframe.getValue(), nextKeyframe.getValue());
        }
        if (fraction2 >= 1.0f) {
            Keyframe prevKeyframe = this.mKeyframes.get(this.mNumKeyframes - 2);
            TimeInterpolator interpolator3 = this.mLastKeyframe.getInterpolator();
            if (interpolator3 != null) {
                fraction2 = interpolator3.getInterpolation(fraction2);
            }
            float prevFraction = prevKeyframe.getFraction();
            float intervalFraction = (fraction2 - prevFraction) / (this.mLastKeyframe.getFraction() - prevFraction);
            return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        Keyframe prevKeyframe = this.mFirstKeyframe;
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe nextKeyframe = this.mKeyframes.get(i);
            if (fraction2 < nextKeyframe.getFraction()) {
                TimeInterpolator interpolator4 = nextKeyframe.getInterpolator();
                float prevFraction = prevKeyframe.getFraction();
                float intervalFraction = (fraction2 - prevFraction) / (nextKeyframe.getFraction() - prevFraction);
                if (interpolator4 != null) {
                    intervalFraction = interpolator4.getInterpolation(intervalFraction);
                }
                return this.mEvaluator.evaluate(intervalFraction, prevKeyframe.getValue(), nextKeyframe.getValue());
            }
            prevKeyframe = nextKeyframe;
        }
        return this.mLastKeyframe.getValue();
    }

    private final String $$robo$$android_animation_KeyframeSet$toString() {
        String returnVal = " ";
        for (int i = 0; i < this.mNumKeyframes; ++i) {
            returnVal = returnVal + this.mKeyframes.get(i).getValue() + "  ";
        }
        return returnVal;
    }

    private void __constructor__(Keyframe ... keyframeArray) {
        this.$$robo$$android_animation_KeyframeSet$__constructor__(keyframeArray);
    }

    public KeyframeSet(Keyframe ... keyframeArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_KeyframeSet$__constructor__(android.animation.Keyframe[] ), this, keyframeArray);
    }

    @Override
    public List<Keyframe> getKeyframes() {
        return InvokeDynamicSupport.bootstrap("getKeyframes", $$robo$$android_animation_KeyframeSet$getKeyframes(), this);
    }

    public static KeyframeSet ofInt(int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofInt", $$robo$$android_animation_KeyframeSet$ofInt(int[] ), (int[])nArray);
    }

    public static KeyframeSet ofFloat(float ... fArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofFloat", $$robo$$android_animation_KeyframeSet$ofFloat(float[] ), (float[])fArray);
    }

    public static KeyframeSet ofKeyframe(Keyframe ... keyframeArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofKeyframe", $$robo$$android_animation_KeyframeSet$ofKeyframe(android.animation.Keyframe[] ), (Keyframe[])keyframeArray);
    }

    public static KeyframeSet ofObject(Object ... objectArray) {
        return InvokeDynamicSupport.bootstrapStatic("ofObject", $$robo$$android_animation_KeyframeSet$ofObject(java.lang.Object[] ), (Object[])objectArray);
    }

    public static PathKeyframes ofPath(Path path) {
        return InvokeDynamicSupport.bootstrapStatic("ofPath", $$robo$$android_animation_KeyframeSet$ofPath(android.graphics.Path ), (Path)path);
    }

    public static PathKeyframes ofPath(Path path, float f) {
        return InvokeDynamicSupport.bootstrapStatic("ofPath", $$robo$$android_animation_KeyframeSet$ofPath(android.graphics.Path float ), (Path)path, (float)f);
    }

    @Override
    public void setEvaluator(TypeEvaluator typeEvaluator) {
        InvokeDynamicSupport.bootstrap("setEvaluator", $$robo$$android_animation_KeyframeSet$setEvaluator(android.animation.TypeEvaluator ), this, typeEvaluator);
    }

    @Override
    public Class getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_animation_KeyframeSet$getType(), this);
    }

    @Override
    public KeyframeSet clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_KeyframeSet$clone(), this);
    }

    @Override
    public Object getValue(float f) {
        return InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_animation_KeyframeSet$getValue(float ), this, f);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_animation_KeyframeSet$toString(), this);
    }

    public /* synthetic */ KeyframeSet() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyframeSet)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

