/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.KeyframeSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LayoutTransition
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int CHANGE_APPEARING = 0;
    public static int CHANGE_DISAPPEARING = 1;
    public static int APPEARING = 2;
    public static int DISAPPEARING = 3;
    public static int CHANGING = 4;
    private static int FLAG_APPEARING = 1;
    private static int FLAG_DISAPPEARING = 2;
    private static int FLAG_CHANGE_APPEARING = 4;
    private static int FLAG_CHANGE_DISAPPEARING = 8;
    private static int FLAG_CHANGING = 16;
    private Animator mDisappearingAnim;
    private Animator mAppearingAnim;
    private Animator mChangingAppearingAnim;
    private Animator mChangingDisappearingAnim;
    private Animator mChangingAnim;
    private static ObjectAnimator defaultChange;
    private static ObjectAnimator defaultChangeIn;
    private static ObjectAnimator defaultChangeOut;
    private static ObjectAnimator defaultFadeIn;
    private static ObjectAnimator defaultFadeOut;
    private static long DEFAULT_DURATION;
    private long mChangingAppearingDuration;
    private long mChangingDisappearingDuration;
    private long mChangingDuration;
    private long mAppearingDuration;
    private long mDisappearingDuration;
    private long mAppearingDelay;
    private long mDisappearingDelay;
    private long mChangingAppearingDelay;
    private long mChangingDisappearingDelay;
    private long mChangingDelay;
    private long mChangingAppearingStagger;
    private long mChangingDisappearingStagger;
    private long mChangingStagger;
    private static TimeInterpolator ACCEL_DECEL_INTERPOLATOR;
    private static TimeInterpolator DECEL_INTERPOLATOR;
    private static TimeInterpolator sAppearingInterpolator;
    private static TimeInterpolator sDisappearingInterpolator;
    private static TimeInterpolator sChangingAppearingInterpolator;
    private static TimeInterpolator sChangingDisappearingInterpolator;
    private static TimeInterpolator sChangingInterpolator;
    private TimeInterpolator mAppearingInterpolator;
    private TimeInterpolator mDisappearingInterpolator;
    private TimeInterpolator mChangingAppearingInterpolator;
    private TimeInterpolator mChangingDisappearingInterpolator;
    private TimeInterpolator mChangingInterpolator;
    private HashMap<View, Animator> pendingAnimations;
    private LinkedHashMap<View, Animator> currentChangingAnimations;
    private LinkedHashMap<View, Animator> currentAppearingAnimations;
    private LinkedHashMap<View, Animator> currentDisappearingAnimations;
    private HashMap<View, View.OnLayoutChangeListener> layoutChangeListenerMap;
    private long staggerDelay;
    private int mTransitionTypes;
    private ArrayList<TransitionListener> mListeners;
    private boolean mAnimateParentHierarchy;

    private void $$robo$$android_animation_LayoutTransition$__constructor__() {
        this.mDisappearingAnim = null;
        this.mAppearingAnim = null;
        this.mChangingAppearingAnim = null;
        this.mChangingDisappearingAnim = null;
        this.mChangingAnim = null;
        this.mChangingAppearingDuration = DEFAULT_DURATION;
        this.mChangingDisappearingDuration = DEFAULT_DURATION;
        this.mChangingDuration = DEFAULT_DURATION;
        this.mAppearingDuration = DEFAULT_DURATION;
        this.mDisappearingDuration = DEFAULT_DURATION;
        this.mAppearingDelay = DEFAULT_DURATION;
        this.mDisappearingDelay = 0L;
        this.mChangingAppearingDelay = 0L;
        this.mChangingDisappearingDelay = DEFAULT_DURATION;
        this.mChangingDelay = 0L;
        this.mChangingAppearingStagger = 0L;
        this.mChangingDisappearingStagger = 0L;
        this.mChangingStagger = 0L;
        this.mAppearingInterpolator = sAppearingInterpolator;
        this.mDisappearingInterpolator = sDisappearingInterpolator;
        this.mChangingAppearingInterpolator = sChangingAppearingInterpolator;
        this.mChangingDisappearingInterpolator = sChangingDisappearingInterpolator;
        this.mChangingInterpolator = sChangingInterpolator;
        this.pendingAnimations = new HashMap();
        this.currentChangingAnimations = new LinkedHashMap();
        this.currentAppearingAnimations = new LinkedHashMap();
        this.currentDisappearingAnimations = new LinkedHashMap();
        this.layoutChangeListenerMap = new HashMap();
        this.mTransitionTypes = 15;
        this.mAnimateParentHierarchy = true;
        if (defaultChangeIn == null) {
            PropertyValuesHolder pvhLeft = PropertyValuesHolder.ofInt("left", 0, 1);
            PropertyValuesHolder pvhTop = PropertyValuesHolder.ofInt("top", 0, 1);
            PropertyValuesHolder pvhRight = PropertyValuesHolder.ofInt("right", 0, 1);
            PropertyValuesHolder pvhBottom = PropertyValuesHolder.ofInt("bottom", 0, 1);
            PropertyValuesHolder pvhScrollX = PropertyValuesHolder.ofInt("scrollX", 0, 1);
            PropertyValuesHolder pvhScrollY = PropertyValuesHolder.ofInt("scrollY", 0, 1);
            defaultChangeIn = ObjectAnimator.ofPropertyValuesHolder(null, new PropertyValuesHolder[]{pvhLeft, pvhTop, pvhRight, pvhBottom, pvhScrollX, pvhScrollY});
            defaultChangeIn.setDuration(DEFAULT_DURATION);
            defaultChangeIn.setStartDelay(this.mChangingAppearingDelay);
            defaultChangeIn.setInterpolator(this.mChangingAppearingInterpolator);
            defaultChangeOut = defaultChangeIn.clone();
            defaultChangeOut.setStartDelay(this.mChangingDisappearingDelay);
            defaultChangeOut.setInterpolator(this.mChangingDisappearingInterpolator);
            defaultChange = defaultChangeIn.clone();
            defaultChange.setStartDelay(this.mChangingDelay);
            defaultChange.setInterpolator(this.mChangingInterpolator);
            defaultFadeIn = ObjectAnimator.ofFloat(null, "alpha", 0.0f, 1.0f);
            defaultFadeIn.setDuration(DEFAULT_DURATION);
            defaultFadeIn.setStartDelay(this.mAppearingDelay);
            defaultFadeIn.setInterpolator(this.mAppearingInterpolator);
            defaultFadeOut = ObjectAnimator.ofFloat(null, "alpha", 1.0f, 0.0f);
            defaultFadeOut.setDuration(DEFAULT_DURATION);
            defaultFadeOut.setStartDelay(this.mDisappearingDelay);
            defaultFadeOut.setInterpolator(this.mDisappearingInterpolator);
        }
        this.mChangingAppearingAnim = defaultChangeIn;
        this.mChangingDisappearingAnim = defaultChangeOut;
        this.mChangingAnim = defaultChange;
        this.mAppearingAnim = defaultFadeIn;
        this.mDisappearingAnim = defaultFadeOut;
    }

    private final void $$robo$$android_animation_LayoutTransition$setDuration(long duration) {
        this.mChangingAppearingDuration = duration;
        this.mChangingDisappearingDuration = duration;
        this.mChangingDuration = duration;
        this.mAppearingDuration = duration;
        this.mDisappearingDuration = duration;
    }

    private final void $$robo$$android_animation_LayoutTransition$enableTransitionType(int transitionType) {
        switch (transitionType) {
            case 2: {
                this.mTransitionTypes |= 1;
                break;
            }
            case 3: {
                this.mTransitionTypes |= 2;
                break;
            }
            case 0: {
                this.mTransitionTypes |= 4;
                break;
            }
            case 1: {
                this.mTransitionTypes |= 8;
                break;
            }
            case 4: {
                this.mTransitionTypes |= 0x10;
            }
        }
    }

    private final void $$robo$$android_animation_LayoutTransition$disableTransitionType(int transitionType) {
        switch (transitionType) {
            case 2: {
                this.mTransitionTypes &= 0xFFFFFFFE;
                break;
            }
            case 3: {
                this.mTransitionTypes &= 0xFFFFFFFD;
                break;
            }
            case 0: {
                this.mTransitionTypes &= 0xFFFFFFFB;
                break;
            }
            case 1: {
                this.mTransitionTypes &= 0xFFFFFFF7;
                break;
            }
            case 4: {
                this.mTransitionTypes &= 0xFFFFFFEF;
            }
        }
    }

    private final boolean $$robo$$android_animation_LayoutTransition$isTransitionTypeEnabled(int transitionType) {
        switch (transitionType) {
            case 2: {
                return (this.mTransitionTypes & 1) == 1;
            }
            case 3: {
                return (this.mTransitionTypes & 2) == 2;
            }
            case 0: {
                return (this.mTransitionTypes & 4) == 4;
            }
            case 1: {
                return (this.mTransitionTypes & 8) == 8;
            }
            case 4: {
                return (this.mTransitionTypes & 0x10) == 16;
            }
        }
        return false;
    }

    private final void $$robo$$android_animation_LayoutTransition$setStartDelay(int transitionType, long delay) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingDelay = delay;
                break;
            }
            case 1: {
                this.mChangingDisappearingDelay = delay;
                break;
            }
            case 4: {
                this.mChangingDelay = delay;
                break;
            }
            case 2: {
                this.mAppearingDelay = delay;
                break;
            }
            case 3: {
                this.mDisappearingDelay = delay;
            }
        }
    }

    private final long $$robo$$android_animation_LayoutTransition$getStartDelay(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingDelay;
            }
            case 1: {
                return this.mChangingDisappearingDelay;
            }
            case 4: {
                return this.mChangingDelay;
            }
            case 2: {
                return this.mAppearingDelay;
            }
            case 3: {
                return this.mDisappearingDelay;
            }
        }
        return 0L;
    }

    private final void $$robo$$android_animation_LayoutTransition$setDuration(int transitionType, long duration) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingDuration = duration;
                break;
            }
            case 1: {
                this.mChangingDisappearingDuration = duration;
                break;
            }
            case 4: {
                this.mChangingDuration = duration;
                break;
            }
            case 2: {
                this.mAppearingDuration = duration;
                break;
            }
            case 3: {
                this.mDisappearingDuration = duration;
            }
        }
    }

    private final long $$robo$$android_animation_LayoutTransition$getDuration(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingDuration;
            }
            case 1: {
                return this.mChangingDisappearingDuration;
            }
            case 4: {
                return this.mChangingDuration;
            }
            case 2: {
                return this.mAppearingDuration;
            }
            case 3: {
                return this.mDisappearingDuration;
            }
        }
        return 0L;
    }

    private final void $$robo$$android_animation_LayoutTransition$setStagger(int transitionType, long duration) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingStagger = duration;
                break;
            }
            case 1: {
                this.mChangingDisappearingStagger = duration;
                break;
            }
            case 4: {
                this.mChangingStagger = duration;
            }
        }
    }

    private final long $$robo$$android_animation_LayoutTransition$getStagger(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingStagger;
            }
            case 1: {
                return this.mChangingDisappearingStagger;
            }
            case 4: {
                return this.mChangingStagger;
            }
        }
        return 0L;
    }

    private final void $$robo$$android_animation_LayoutTransition$setInterpolator(int transitionType, TimeInterpolator interpolator2) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingInterpolator = interpolator2;
                break;
            }
            case 1: {
                this.mChangingDisappearingInterpolator = interpolator2;
                break;
            }
            case 4: {
                this.mChangingInterpolator = interpolator2;
                break;
            }
            case 2: {
                this.mAppearingInterpolator = interpolator2;
                break;
            }
            case 3: {
                this.mDisappearingInterpolator = interpolator2;
            }
        }
    }

    private final TimeInterpolator $$robo$$android_animation_LayoutTransition$getInterpolator(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingInterpolator;
            }
            case 1: {
                return this.mChangingDisappearingInterpolator;
            }
            case 4: {
                return this.mChangingInterpolator;
            }
            case 2: {
                return this.mAppearingInterpolator;
            }
            case 3: {
                return this.mDisappearingInterpolator;
            }
        }
        return null;
    }

    private final void $$robo$$android_animation_LayoutTransition$setAnimator(int transitionType, Animator animator2) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingAnim = animator2;
                break;
            }
            case 1: {
                this.mChangingDisappearingAnim = animator2;
                break;
            }
            case 4: {
                this.mChangingAnim = animator2;
                break;
            }
            case 2: {
                this.mAppearingAnim = animator2;
                break;
            }
            case 3: {
                this.mDisappearingAnim = animator2;
            }
        }
    }

    private final Animator $$robo$$android_animation_LayoutTransition$getAnimator(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingAnim;
            }
            case 1: {
                return this.mChangingDisappearingAnim;
            }
            case 4: {
                return this.mChangingAnim;
            }
            case 2: {
                return this.mAppearingAnim;
            }
            case 3: {
                return this.mDisappearingAnim;
            }
        }
        return null;
    }

    private final void $$robo$$android_animation_LayoutTransition$runChangeTransition(ViewGroup parent, View newView, int changeReason) {
        long duration;
        Animator baseAnimator = null;
        ObjectAnimator parentAnimator = null;
        switch (changeReason) {
            case 2: {
                baseAnimator = this.mChangingAppearingAnim;
                duration = this.mChangingAppearingDuration;
                parentAnimator = defaultChangeIn;
                break;
            }
            case 3: {
                baseAnimator = this.mChangingDisappearingAnim;
                duration = this.mChangingDisappearingDuration;
                parentAnimator = defaultChangeOut;
                break;
            }
            case 4: {
                baseAnimator = this.mChangingAnim;
                duration = this.mChangingDuration;
                parentAnimator = defaultChange;
                break;
            }
            default: {
                duration = 0L;
            }
        }
        if (baseAnimator == null) {
            return;
        }
        this.staggerDelay = 0L;
        ViewTreeObserver observer = parent.getViewTreeObserver();
        if (!observer.isAlive()) {
            return;
        }
        int numChildren = parent.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            View child = parent.getChildAt(i);
            if (child == newView) continue;
            this.setupChangeAnimation(parent, changeReason, baseAnimator, duration, child);
        }
        if (this.mAnimateParentHierarchy) {
            ViewGroup tempParent = parent;
            while (tempParent != null) {
                ViewParent parentParent = tempParent.getParent();
                if (parentParent instanceof ViewGroup) {
                    this.setupChangeAnimation((ViewGroup)parentParent, changeReason, parentAnimator, duration, tempParent);
                    tempParent = (ViewGroup)parentParent;
                    continue;
                }
                tempParent = null;
            }
        }
        CleanupCallback callback = new CleanupCallback(this.layoutChangeListenerMap, parent);
        observer.addOnPreDrawListener(callback);
        parent.addOnAttachStateChangeListener(callback);
    }

    private final void $$robo$$android_animation_LayoutTransition$setAnimateParentHierarchy(boolean animateParentHierarchy) {
        this.mAnimateParentHierarchy = animateParentHierarchy;
    }

    private final void $$robo$$android_animation_LayoutTransition$setupChangeAnimation(ViewGroup parent, int changeReason, Animator baseAnimator, long duration, View child) {
        if (this.layoutChangeListenerMap.get(child) != null) {
            return;
        }
        if (child.getWidth() == 0 && child.getHeight() == 0) {
            return;
        }
        Object anim2 = baseAnimator.clone();
        ((Animator)anim2).setTarget(child);
        ((Animator)anim2).setupStartValues();
        Animator currentAnimation = this.pendingAnimations.get(child);
        if (currentAnimation != null) {
            currentAnimation.cancel();
            this.pendingAnimations.remove(child);
        }
        this.pendingAnimations.put(child, (Animator)anim2);
        Animator pendingAnimRemover = ValueAnimator.ofFloat(0.0f, 1.0f).setDuration(duration + 100L);
        pendingAnimRemover.addListener((Animator.AnimatorListener)new ShadowedObject(this, child){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ View val$child;
            /* synthetic */ LayoutTransition this$0;

            private void $$robo$$android_animation_LayoutTransition_1$__constructor__(LayoutTransition this$0, View view) {
                this.this$0 = this$0;
                this.val$child = view;
            }

            private final void $$robo$$android_animation_LayoutTransition_1$onAnimationEnd(Animator animation) {
                this.this$0.pendingAnimations.remove(this.val$child);
            }

            private void __constructor__(LayoutTransition layoutTransition, View view) {
                this.$$robo$$android_animation_LayoutTransition_1$__constructor__(layoutTransition, view);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_LayoutTransition_1$__constructor__(android.animation.LayoutTransition android.view.View ), this, layoutTransition, view);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_LayoutTransition_1$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        ((ValueAnimator)pendingAnimRemover).start();
        View.OnLayoutChangeListener listener = new View.OnLayoutChangeListener(this, (Animator)anim2, changeReason, duration, child, parent){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Animator val$anim;
            /* synthetic */ int val$changeReason;
            /* synthetic */ long val$duration;
            /* synthetic */ View val$child;
            /* synthetic */ ViewGroup val$parent;
            /* synthetic */ LayoutTransition this$0;

            private void $$robo$$android_animation_LayoutTransition_2$__constructor__(LayoutTransition this$0, Animator animator2, int n, long l, View view, ViewGroup viewGroup) {
                this.this$0 = this$0;
                this.val$anim = animator2;
                this.val$changeReason = n;
                this.val$duration = l;
                this.val$child = view;
                this.val$parent = viewGroup;
            }

            private final void $$robo$$android_animation_LayoutTransition_2$onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Animator pendingAnimation;
                this.val$anim.setupEndValues();
                if (this.val$anim instanceof ValueAnimator) {
                    boolean valuesDiffer = false;
                    ValueAnimator valueAnim = (ValueAnimator)this.val$anim;
                    PropertyValuesHolder[] oldValues = valueAnim.getValues();
                    for (int i = 0; i < oldValues.length; ++i) {
                        PropertyValuesHolder pvh = oldValues[i];
                        if (pvh.mKeyframes instanceof KeyframeSet) {
                            KeyframeSet keyframeSet = (KeyframeSet)pvh.mKeyframes;
                            if (keyframeSet.mFirstKeyframe != null && keyframeSet.mLastKeyframe != null && keyframeSet.mFirstKeyframe.getValue().equals(keyframeSet.mLastKeyframe.getValue())) continue;
                            valuesDiffer = true;
                            continue;
                        }
                        if (pvh.mKeyframes.getValue(0.0f).equals(pvh.mKeyframes.getValue(1.0f))) continue;
                        valuesDiffer = true;
                    }
                    if (!valuesDiffer) {
                        return;
                    }
                }
                long startDelay = 0L;
                switch (this.val$changeReason) {
                    case 2: {
                        startDelay = this.this$0.mChangingAppearingDelay + this.this$0.staggerDelay;
                        this.this$0.staggerDelay += this.this$0.mChangingAppearingStagger;
                        if (this.this$0.mChangingAppearingInterpolator == sChangingAppearingInterpolator) break;
                        this.val$anim.setInterpolator(this.this$0.mChangingAppearingInterpolator);
                        break;
                    }
                    case 3: {
                        startDelay = this.this$0.mChangingDisappearingDelay + this.this$0.staggerDelay;
                        this.this$0.staggerDelay += this.this$0.mChangingDisappearingStagger;
                        if (this.this$0.mChangingDisappearingInterpolator == sChangingDisappearingInterpolator) break;
                        this.val$anim.setInterpolator(this.this$0.mChangingDisappearingInterpolator);
                        break;
                    }
                    case 4: {
                        startDelay = this.this$0.mChangingDelay + this.this$0.staggerDelay;
                        this.this$0.staggerDelay += this.this$0.mChangingStagger;
                        if (this.this$0.mChangingInterpolator == sChangingInterpolator) break;
                        this.val$anim.setInterpolator(this.this$0.mChangingInterpolator);
                    }
                }
                this.val$anim.setStartDelay(startDelay);
                this.val$anim.setDuration(this.val$duration);
                Animator prevAnimation = (Animator)this.this$0.currentChangingAnimations.get(this.val$child);
                if (prevAnimation != null) {
                    prevAnimation.cancel();
                }
                if ((pendingAnimation = (Animator)this.this$0.pendingAnimations.get(this.val$child)) != null) {
                    this.this$0.pendingAnimations.remove(this.val$child);
                }
                this.this$0.currentChangingAnimations.put(this.val$child, this.val$anim);
                this.val$parent.requestTransitionStart(this.this$0);
                this.val$child.removeOnLayoutChangeListener(this);
                this.this$0.layoutChangeListenerMap.remove(this.val$child);
            }

            private void __constructor__(LayoutTransition layoutTransition, Animator animator2, int n, long l, View view, ViewGroup viewGroup) {
                this.$$robo$$android_animation_LayoutTransition_2$__constructor__(layoutTransition, animator2, n, l, view, viewGroup);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_LayoutTransition_2$__constructor__(android.animation.LayoutTransition android.animation.Animator int long android.view.View android.view.ViewGroup ), this, layoutTransition, animator2, n, l, view, viewGroup);
            }

            @Override
            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                InvokeDynamicSupport.bootstrap("onLayoutChange", $$robo$$android_animation_LayoutTransition_2$onLayoutChange(android.view.View int int int int int int int int ), this, view, n, n2, n3, n4, n5, n6, n7, n8);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        ((Animator)anim2).addListener((Animator.AnimatorListener)new ShadowedObject(this, parent, child, changeReason, listener){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ViewGroup val$parent;
            /* synthetic */ View val$child;
            /* synthetic */ int val$changeReason;
            /* synthetic */ View.OnLayoutChangeListener val$listener;
            /* synthetic */ LayoutTransition this$0;

            private void $$robo$$android_animation_LayoutTransition_3$__constructor__(LayoutTransition this$0, ViewGroup viewGroup, View view, int n, View.OnLayoutChangeListener onLayoutChangeListener) {
                this.this$0 = this$0;
                this.val$parent = viewGroup;
                this.val$child = view;
                this.val$changeReason = n;
                this.val$listener = onLayoutChangeListener;
            }

            private final void $$robo$$android_animation_LayoutTransition_3$onAnimationStart(Animator animator2) {
                if (this.this$0.hasListeners()) {
                    ArrayList listeners = (ArrayList)this.this$0.mListeners.clone();
                    for (TransitionListener listener : listeners) {
                        listener.startTransition(this.this$0, this.val$parent, this.val$child, this.val$changeReason == 2 ? 0 : (this.val$changeReason == 3 ? 1 : 4));
                    }
                }
            }

            private final void $$robo$$android_animation_LayoutTransition_3$onAnimationCancel(Animator animator2) {
                this.val$child.removeOnLayoutChangeListener(this.val$listener);
                this.this$0.layoutChangeListenerMap.remove(this.val$child);
            }

            private final void $$robo$$android_animation_LayoutTransition_3$onAnimationEnd(Animator animator2) {
                this.this$0.currentChangingAnimations.remove(this.val$child);
                if (this.this$0.hasListeners()) {
                    ArrayList listeners = (ArrayList)this.this$0.mListeners.clone();
                    for (TransitionListener listener : listeners) {
                        listener.endTransition(this.this$0, this.val$parent, this.val$child, this.val$changeReason == 2 ? 0 : (this.val$changeReason == 3 ? 1 : 4));
                    }
                }
            }

            private void __constructor__(LayoutTransition layoutTransition, ViewGroup viewGroup, View view, int n, View.OnLayoutChangeListener onLayoutChangeListener) {
                this.$$robo$$android_animation_LayoutTransition_3$__constructor__(layoutTransition, viewGroup, view, n, onLayoutChangeListener);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_LayoutTransition_3$__constructor__(android.animation.LayoutTransition android.view.ViewGroup android.view.View int android.view.View$OnLayoutChangeListener ), this, layoutTransition, viewGroup, view, n, onLayoutChangeListener);
            }

            @Override
            public void onAnimationStart(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$android_animation_LayoutTransition_3$onAnimationStart(android.animation.Animator ), this, animator2);
            }

            @Override
            public void onAnimationCancel(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$android_animation_LayoutTransition_3$onAnimationCancel(android.animation.Animator ), this, animator2);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_LayoutTransition_3$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        child.addOnLayoutChangeListener(listener);
        this.layoutChangeListenerMap.put(child, listener);
    }

    private final void $$robo$$android_animation_LayoutTransition$startChangingAnimations() {
        LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
        for (Animator anim2 : currentAnimCopy.values()) {
            if (anim2 instanceof ObjectAnimator) {
                ((ObjectAnimator)anim2).setCurrentPlayTime(0L);
            }
            anim2.start();
        }
    }

    private final void $$robo$$android_animation_LayoutTransition$endChangingAnimations() {
        LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
        for (Animator anim2 : currentAnimCopy.values()) {
            anim2.start();
            anim2.end();
        }
        this.currentChangingAnimations.clear();
    }

    private final boolean $$robo$$android_animation_LayoutTransition$isChangingLayout() {
        return this.currentChangingAnimations.size() > 0;
    }

    private final boolean $$robo$$android_animation_LayoutTransition$isRunning() {
        return this.currentChangingAnimations.size() > 0 || this.currentAppearingAnimations.size() > 0 || this.currentDisappearingAnimations.size() > 0;
    }

    private final void $$robo$$android_animation_LayoutTransition$cancel() {
        LinkedHashMap currentAnimCopy;
        if (this.currentChangingAnimations.size() > 0) {
            currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
            for (Animator anim2 : currentAnimCopy.values()) {
                anim2.cancel();
            }
            this.currentChangingAnimations.clear();
        }
        if (this.currentAppearingAnimations.size() > 0) {
            currentAnimCopy = (LinkedHashMap)this.currentAppearingAnimations.clone();
            for (Animator anim2 : currentAnimCopy.values()) {
                anim2.end();
            }
            this.currentAppearingAnimations.clear();
        }
        if (this.currentDisappearingAnimations.size() > 0) {
            currentAnimCopy = (LinkedHashMap)this.currentDisappearingAnimations.clone();
            for (Animator anim2 : currentAnimCopy.values()) {
                anim2.end();
            }
            this.currentDisappearingAnimations.clear();
        }
    }

    private final void $$robo$$android_animation_LayoutTransition$cancel(int transitionType) {
        switch (transitionType) {
            case 0: 
            case 1: 
            case 4: {
                if (this.currentChangingAnimations.size() <= 0) break;
                LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
                for (Animator anim2 : currentAnimCopy.values()) {
                    anim2.cancel();
                }
                this.currentChangingAnimations.clear();
                break;
            }
            case 2: {
                if (this.currentAppearingAnimations.size() <= 0) break;
                LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentAppearingAnimations.clone();
                for (Animator anim3 : currentAnimCopy.values()) {
                    anim3.end();
                }
                this.currentAppearingAnimations.clear();
                break;
            }
            case 3: {
                if (this.currentDisappearingAnimations.size() <= 0) break;
                LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentDisappearingAnimations.clone();
                for (Animator anim4 : currentAnimCopy.values()) {
                    anim4.end();
                }
                this.currentDisappearingAnimations.clear();
            }
        }
    }

    private final void $$robo$$android_animation_LayoutTransition$runAppearingTransition(ViewGroup parent, View child) {
        Animator currentAnimation = this.currentDisappearingAnimations.get(child);
        if (currentAnimation != null) {
            currentAnimation.cancel();
        }
        if (this.mAppearingAnim == null) {
            if (this.hasListeners()) {
                ArrayList listeners = (ArrayList)this.mListeners.clone();
                for (TransitionListener listener : listeners) {
                    listener.endTransition(this, parent, child, 2);
                }
            }
            return;
        }
        Object anim2 = this.mAppearingAnim.clone();
        ((Animator)anim2).setTarget(child);
        ((Animator)anim2).setStartDelay(this.mAppearingDelay);
        ((Animator)anim2).setDuration(this.mAppearingDuration);
        if (this.mAppearingInterpolator != sAppearingInterpolator) {
            ((Animator)anim2).setInterpolator(this.mAppearingInterpolator);
        }
        if (anim2 instanceof ObjectAnimator) {
            ((ObjectAnimator)anim2).setCurrentPlayTime(0L);
        }
        ((Animator)anim2).addListener((Animator.AnimatorListener)new ShadowedObject(this, child, parent){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ View val$child;
            /* synthetic */ ViewGroup val$parent;
            /* synthetic */ LayoutTransition this$0;

            private void $$robo$$android_animation_LayoutTransition_4$__constructor__(LayoutTransition this$0, View view, ViewGroup viewGroup) {
                this.this$0 = this$0;
                this.val$child = view;
                this.val$parent = viewGroup;
            }

            private final void $$robo$$android_animation_LayoutTransition_4$onAnimationEnd(Animator anim2) {
                this.this$0.currentAppearingAnimations.remove(this.val$child);
                if (this.this$0.hasListeners()) {
                    ArrayList listeners = (ArrayList)this.this$0.mListeners.clone();
                    for (TransitionListener listener : listeners) {
                        listener.endTransition(this.this$0, this.val$parent, this.val$child, 2);
                    }
                }
            }

            private void __constructor__(LayoutTransition layoutTransition, View view, ViewGroup viewGroup) {
                this.$$robo$$android_animation_LayoutTransition_4$__constructor__(layoutTransition, view, viewGroup);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_LayoutTransition_4$__constructor__(android.animation.LayoutTransition android.view.View android.view.ViewGroup ), this, layoutTransition, view, viewGroup);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_LayoutTransition_4$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.currentAppearingAnimations.put(child, (Animator)anim2);
        ((Animator)anim2).start();
    }

    private final void $$robo$$android_animation_LayoutTransition$runDisappearingTransition(ViewGroup parent, View child) {
        Animator currentAnimation = this.currentAppearingAnimations.get(child);
        if (currentAnimation != null) {
            currentAnimation.cancel();
        }
        if (this.mDisappearingAnim == null) {
            if (this.hasListeners()) {
                ArrayList listeners = (ArrayList)this.mListeners.clone();
                for (TransitionListener listener : listeners) {
                    listener.endTransition(this, parent, child, 3);
                }
            }
            return;
        }
        Object anim2 = this.mDisappearingAnim.clone();
        ((Animator)anim2).setStartDelay(this.mDisappearingDelay);
        ((Animator)anim2).setDuration(this.mDisappearingDuration);
        if (this.mDisappearingInterpolator != sDisappearingInterpolator) {
            ((Animator)anim2).setInterpolator(this.mDisappearingInterpolator);
        }
        ((Animator)anim2).setTarget(child);
        float preAnimAlpha = child.getAlpha();
        ((Animator)anim2).addListener((Animator.AnimatorListener)new ShadowedObject(this, child, preAnimAlpha, parent){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ View val$child;
            /* synthetic */ float val$preAnimAlpha;
            /* synthetic */ ViewGroup val$parent;
            /* synthetic */ LayoutTransition this$0;

            private void $$robo$$android_animation_LayoutTransition_5$__constructor__(LayoutTransition this$0, View view, float f, ViewGroup viewGroup) {
                this.this$0 = this$0;
                this.val$child = view;
                this.val$preAnimAlpha = f;
                this.val$parent = viewGroup;
            }

            private final void $$robo$$android_animation_LayoutTransition_5$onAnimationEnd(Animator anim2) {
                this.this$0.currentDisappearingAnimations.remove(this.val$child);
                this.val$child.setAlpha(this.val$preAnimAlpha);
                if (this.this$0.hasListeners()) {
                    ArrayList listeners = (ArrayList)this.this$0.mListeners.clone();
                    for (TransitionListener listener : listeners) {
                        listener.endTransition(this.this$0, this.val$parent, this.val$child, 3);
                    }
                }
            }

            private void __constructor__(LayoutTransition layoutTransition, View view, float f, ViewGroup viewGroup) {
                this.$$robo$$android_animation_LayoutTransition_5$__constructor__(layoutTransition, view, f, viewGroup);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_LayoutTransition_5$__constructor__(android.animation.LayoutTransition android.view.View float android.view.ViewGroup ), this, layoutTransition, view, f, viewGroup);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_LayoutTransition_5$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        if (anim2 instanceof ObjectAnimator) {
            ((ObjectAnimator)anim2).setCurrentPlayTime(0L);
        }
        this.currentDisappearingAnimations.put(child, (Animator)anim2);
        ((Animator)anim2).start();
    }

    private final void $$robo$$android_animation_LayoutTransition$addChild(ViewGroup parent, View child, boolean changesLayout) {
        if (parent.getWindowVisibility() != 0) {
            return;
        }
        if ((this.mTransitionTypes & 1) == 1) {
            this.cancel(3);
        }
        if (changesLayout && (this.mTransitionTypes & 4) == 4) {
            this.cancel(0);
            this.cancel(4);
        }
        if (this.hasListeners() && (this.mTransitionTypes & 1) == 1) {
            ArrayList listeners = (ArrayList)this.mListeners.clone();
            for (TransitionListener listener : listeners) {
                listener.startTransition(this, parent, child, 2);
            }
        }
        if (changesLayout && (this.mTransitionTypes & 4) == 4) {
            this.runChangeTransition(parent, child, 2);
        }
        if ((this.mTransitionTypes & 1) == 1) {
            this.runAppearingTransition(parent, child);
        }
    }

    private final boolean $$robo$$android_animation_LayoutTransition$hasListeners() {
        return this.mListeners != null && this.mListeners.size() > 0;
    }

    private final void $$robo$$android_animation_LayoutTransition$layoutChange(ViewGroup parent) {
        if (parent.getWindowVisibility() != 0) {
            return;
        }
        if ((this.mTransitionTypes & 0x10) == 16 && !this.isRunning()) {
            this.runChangeTransition(parent, null, 4);
        }
    }

    private final void $$robo$$android_animation_LayoutTransition$addChild(ViewGroup parent, View child) {
        this.addChild(parent, child, true);
    }

    @Deprecated
    private final void $$robo$$android_animation_LayoutTransition$showChild(ViewGroup parent, View child) {
        this.addChild(parent, child, true);
    }

    private final void $$robo$$android_animation_LayoutTransition$showChild(ViewGroup parent, View child, int oldVisibility) {
        this.addChild(parent, child, oldVisibility == 8);
    }

    private final void $$robo$$android_animation_LayoutTransition$removeChild(ViewGroup parent, View child, boolean changesLayout) {
        if (parent.getWindowVisibility() != 0) {
            return;
        }
        if ((this.mTransitionTypes & 2) == 2) {
            this.cancel(2);
        }
        if (changesLayout && (this.mTransitionTypes & 8) == 8) {
            this.cancel(1);
            this.cancel(4);
        }
        if (this.hasListeners() && (this.mTransitionTypes & 2) == 2) {
            ArrayList listeners = (ArrayList)this.mListeners.clone();
            for (TransitionListener listener : listeners) {
                listener.startTransition(this, parent, child, 3);
            }
        }
        if (changesLayout && (this.mTransitionTypes & 8) == 8) {
            this.runChangeTransition(parent, child, 3);
        }
        if ((this.mTransitionTypes & 2) == 2) {
            this.runDisappearingTransition(parent, child);
        }
    }

    private final void $$robo$$android_animation_LayoutTransition$removeChild(ViewGroup parent, View child) {
        this.removeChild(parent, child, true);
    }

    @Deprecated
    private final void $$robo$$android_animation_LayoutTransition$hideChild(ViewGroup parent, View child) {
        this.removeChild(parent, child, true);
    }

    private final void $$robo$$android_animation_LayoutTransition$hideChild(ViewGroup parent, View child, int newVisibility) {
        this.removeChild(parent, child, newVisibility == 8);
    }

    private final void $$robo$$android_animation_LayoutTransition$addTransitionListener(TransitionListener listener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener);
    }

    private final void $$robo$$android_animation_LayoutTransition$removeTransitionListener(TransitionListener listener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener);
    }

    private final List<TransitionListener> $$robo$$android_animation_LayoutTransition$getTransitionListeners() {
        return this.mListeners;
    }

    static void __staticInitializer__() {
        DEFAULT_DURATION = 300L;
        ACCEL_DECEL_INTERPOLATOR = new AccelerateDecelerateInterpolator();
        DECEL_INTERPOLATOR = new DecelerateInterpolator();
        sAppearingInterpolator = ACCEL_DECEL_INTERPOLATOR;
        sDisappearingInterpolator = ACCEL_DECEL_INTERPOLATOR;
        sChangingAppearingInterpolator = DECEL_INTERPOLATOR;
        sChangingDisappearingInterpolator = DECEL_INTERPOLATOR;
        sChangingInterpolator = DECEL_INTERPOLATOR;
    }

    private void __constructor__() {
        this.$$robo$$android_animation_LayoutTransition$__constructor__();
    }

    public LayoutTransition() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_LayoutTransition$__constructor__(), this);
    }

    public void setDuration(long l) {
        InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_animation_LayoutTransition$setDuration(long ), this, l);
    }

    public void enableTransitionType(int n) {
        InvokeDynamicSupport.bootstrap("enableTransitionType", $$robo$$android_animation_LayoutTransition$enableTransitionType(int ), this, n);
    }

    public void disableTransitionType(int n) {
        InvokeDynamicSupport.bootstrap("disableTransitionType", $$robo$$android_animation_LayoutTransition$disableTransitionType(int ), this, n);
    }

    public boolean isTransitionTypeEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransitionTypeEnabled", $$robo$$android_animation_LayoutTransition$isTransitionTypeEnabled(int ), this, n);
    }

    public void setStartDelay(int n, long l) {
        InvokeDynamicSupport.bootstrap("setStartDelay", $$robo$$android_animation_LayoutTransition$setStartDelay(int long ), this, n, l);
    }

    public long getStartDelay(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$android_animation_LayoutTransition$getStartDelay(int ), this, n);
    }

    public void setDuration(int n, long l) {
        InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_animation_LayoutTransition$setDuration(int long ), this, n, l);
    }

    public long getDuration(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_animation_LayoutTransition$getDuration(int ), this, n);
    }

    public void setStagger(int n, long l) {
        InvokeDynamicSupport.bootstrap("setStagger", $$robo$$android_animation_LayoutTransition$setStagger(int long ), this, n, l);
    }

    public long getStagger(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getStagger", $$robo$$android_animation_LayoutTransition$getStagger(int ), this, n);
    }

    public void setInterpolator(int n, TimeInterpolator timeInterpolator) {
        InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$android_animation_LayoutTransition$setInterpolator(int android.animation.TimeInterpolator ), this, n, timeInterpolator);
    }

    public TimeInterpolator getInterpolator(int n) {
        return InvokeDynamicSupport.bootstrap("getInterpolator", $$robo$$android_animation_LayoutTransition$getInterpolator(int ), this, n);
    }

    public void setAnimator(int n, Animator animator2) {
        InvokeDynamicSupport.bootstrap("setAnimator", $$robo$$android_animation_LayoutTransition$setAnimator(int android.animation.Animator ), this, n, animator2);
    }

    public Animator getAnimator(int n) {
        return InvokeDynamicSupport.bootstrap("getAnimator", $$robo$$android_animation_LayoutTransition$getAnimator(int ), this, n);
    }

    private void runChangeTransition(ViewGroup viewGroup, View view, int n) {
        InvokeDynamicSupport.bootstrap("runChangeTransition", $$robo$$android_animation_LayoutTransition$runChangeTransition(android.view.ViewGroup android.view.View int ), this, viewGroup, view, n);
    }

    public void setAnimateParentHierarchy(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAnimateParentHierarchy", $$robo$$android_animation_LayoutTransition$setAnimateParentHierarchy(boolean ), this, bl);
    }

    private void setupChangeAnimation(ViewGroup viewGroup, int n, Animator animator2, long l, View view) {
        InvokeDynamicSupport.bootstrap("setupChangeAnimation", $$robo$$android_animation_LayoutTransition$setupChangeAnimation(android.view.ViewGroup int android.animation.Animator long android.view.View ), this, viewGroup, n, animator2, l, view);
    }

    public void startChangingAnimations() {
        InvokeDynamicSupport.bootstrap("startChangingAnimations", $$robo$$android_animation_LayoutTransition$startChangingAnimations(), this);
    }

    public void endChangingAnimations() {
        InvokeDynamicSupport.bootstrap("endChangingAnimations", $$robo$$android_animation_LayoutTransition$endChangingAnimations(), this);
    }

    public boolean isChangingLayout() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChangingLayout", $$robo$$android_animation_LayoutTransition$isChangingLayout(), this);
    }

    public boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_animation_LayoutTransition$isRunning(), this);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_animation_LayoutTransition$cancel(), this);
    }

    public void cancel(int n) {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_animation_LayoutTransition$cancel(int ), this, n);
    }

    private void runAppearingTransition(ViewGroup viewGroup, View view) {
        InvokeDynamicSupport.bootstrap("runAppearingTransition", $$robo$$android_animation_LayoutTransition$runAppearingTransition(android.view.ViewGroup android.view.View ), this, viewGroup, view);
    }

    private void runDisappearingTransition(ViewGroup viewGroup, View view) {
        InvokeDynamicSupport.bootstrap("runDisappearingTransition", $$robo$$android_animation_LayoutTransition$runDisappearingTransition(android.view.ViewGroup android.view.View ), this, viewGroup, view);
    }

    private void addChild(ViewGroup viewGroup, View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_animation_LayoutTransition$addChild(android.view.ViewGroup android.view.View boolean ), this, viewGroup, view, bl);
    }

    private boolean hasListeners() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasListeners", $$robo$$android_animation_LayoutTransition$hasListeners(), this);
    }

    public void layoutChange(ViewGroup viewGroup) {
        InvokeDynamicSupport.bootstrap("layoutChange", $$robo$$android_animation_LayoutTransition$layoutChange(android.view.ViewGroup ), this, viewGroup);
    }

    public void addChild(ViewGroup viewGroup, View view) {
        InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_animation_LayoutTransition$addChild(android.view.ViewGroup android.view.View ), this, viewGroup, view);
    }

    @Deprecated
    public void showChild(ViewGroup viewGroup, View view) {
        InvokeDynamicSupport.bootstrap("showChild", $$robo$$android_animation_LayoutTransition$showChild(android.view.ViewGroup android.view.View ), this, viewGroup, view);
    }

    public void showChild(ViewGroup viewGroup, View view, int n) {
        InvokeDynamicSupport.bootstrap("showChild", $$robo$$android_animation_LayoutTransition$showChild(android.view.ViewGroup android.view.View int ), this, viewGroup, view, n);
    }

    private void removeChild(ViewGroup viewGroup, View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("removeChild", $$robo$$android_animation_LayoutTransition$removeChild(android.view.ViewGroup android.view.View boolean ), this, viewGroup, view, bl);
    }

    public void removeChild(ViewGroup viewGroup, View view) {
        InvokeDynamicSupport.bootstrap("removeChild", $$robo$$android_animation_LayoutTransition$removeChild(android.view.ViewGroup android.view.View ), this, viewGroup, view);
    }

    @Deprecated
    public void hideChild(ViewGroup viewGroup, View view) {
        InvokeDynamicSupport.bootstrap("hideChild", $$robo$$android_animation_LayoutTransition$hideChild(android.view.ViewGroup android.view.View ), this, viewGroup, view);
    }

    public void hideChild(ViewGroup viewGroup, View view, int n) {
        InvokeDynamicSupport.bootstrap("hideChild", $$robo$$android_animation_LayoutTransition$hideChild(android.view.ViewGroup android.view.View int ), this, viewGroup, view, n);
    }

    public void addTransitionListener(TransitionListener transitionListener) {
        InvokeDynamicSupport.bootstrap("addTransitionListener", $$robo$$android_animation_LayoutTransition$addTransitionListener(android.animation.LayoutTransition$TransitionListener ), this, transitionListener);
    }

    public void removeTransitionListener(TransitionListener transitionListener) {
        InvokeDynamicSupport.bootstrap("removeTransitionListener", $$robo$$android_animation_LayoutTransition$removeTransitionListener(android.animation.LayoutTransition$TransitionListener ), this, transitionListener);
    }

    public List<TransitionListener> getTransitionListeners() {
        return InvokeDynamicSupport.bootstrap("getTransitionListeners", $$robo$$android_animation_LayoutTransition$getTransitionListeners(), this);
    }

    static {
        RobolectricInternals.classInitializing(LayoutTransition.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutTransition)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class CleanupCallback
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Map<View, View.OnLayoutChangeListener> layoutChangeListenerMap;
        ViewGroup parent;

        private void $$robo$$android_animation_LayoutTransition_CleanupCallback$__constructor__(Map<View, View.OnLayoutChangeListener> listenerMap, ViewGroup parent) {
            this.layoutChangeListenerMap = listenerMap;
            this.parent = parent;
        }

        private final void $$robo$$android_animation_LayoutTransition_CleanupCallback$cleanup() {
            this.parent.getViewTreeObserver().removeOnPreDrawListener(this);
            this.parent.removeOnAttachStateChangeListener(this);
            int count = this.layoutChangeListenerMap.size();
            if (count > 0) {
                Set<View> views = this.layoutChangeListenerMap.keySet();
                for (View view : views) {
                    View.OnLayoutChangeListener listener = this.layoutChangeListenerMap.get(view);
                    view.removeOnLayoutChangeListener(listener);
                }
                this.layoutChangeListenerMap.clear();
            }
        }

        private final void $$robo$$android_animation_LayoutTransition_CleanupCallback$onViewAttachedToWindow(View v) {
        }

        private final void $$robo$$android_animation_LayoutTransition_CleanupCallback$onViewDetachedFromWindow(View v) {
            this.cleanup();
        }

        private final boolean $$robo$$android_animation_LayoutTransition_CleanupCallback$onPreDraw() {
            this.cleanup();
            return true;
        }

        private void __constructor__(Map<View, View.OnLayoutChangeListener> map, ViewGroup viewGroup) {
            this.$$robo$$android_animation_LayoutTransition_CleanupCallback$__constructor__(map, viewGroup);
        }

        public CleanupCallback(Map<View, View.OnLayoutChangeListener> map, ViewGroup viewGroup) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_LayoutTransition_CleanupCallback$__constructor__(java.util.Map<android.view.View, android.view.View$OnLayoutChangeListener> android.view.ViewGroup ), this, map, viewGroup);
        }

        private void cleanup() {
            InvokeDynamicSupport.bootstrap("cleanup", $$robo$$android_animation_LayoutTransition_CleanupCallback$cleanup(), this);
        }

        @Override
        public void onViewAttachedToWindow(View view) {
            InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$android_animation_LayoutTransition_CleanupCallback$onViewAttachedToWindow(android.view.View ), this, view);
        }

        @Override
        public void onViewDetachedFromWindow(View view) {
            InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$android_animation_LayoutTransition_CleanupCallback$onViewDetachedFromWindow(android.view.View ), this, view);
        }

        @Override
        public boolean onPreDraw() {
            return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$android_animation_LayoutTransition_CleanupCallback$onPreDraw(), this);
        }

        public /* synthetic */ CleanupCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CleanupCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface TransitionListener {
        public void startTransition(LayoutTransition var1, ViewGroup var2, View var3, int var4);

        public void endTransition(LayoutTransition var1, ViewGroup var2, View var3, int var4);
    }
}

