/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.res.ConstantState;
import android.util.StateSet;
import android.view.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StateListAnimator
implements Cloneable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private ArrayList<Tuple> mTuples;
    private Tuple mLastMatch;
    private Animator mRunningAnimator;
    private WeakReference<View> mViewRef;
    private StateListAnimatorConstantState mConstantState;
    private AnimatorListenerAdapter mAnimatorListener;
    private int mChangingConfigurations;

    private void $$robo$$android_animation_StateListAnimator$__constructor__() {
        this.mTuples = new ArrayList();
        this.mLastMatch = null;
        this.mRunningAnimator = null;
        this.initAnimatorListener();
    }

    private final void $$robo$$android_animation_StateListAnimator$initAnimatorListener() {
        this.mAnimatorListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ StateListAnimator this$0;

            private void $$robo$$android_animation_StateListAnimator_1$__constructor__(StateListAnimator this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_animation_StateListAnimator_1$onAnimationEnd(Animator animation) {
                animation.setTarget(null);
                if (this.this$0.mRunningAnimator == animation) {
                    this.this$0.mRunningAnimator = null;
                }
            }

            private void __constructor__(StateListAnimator stateListAnimator) {
                this.$$robo$$android_animation_StateListAnimator_1$__constructor__(stateListAnimator);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_StateListAnimator_1$__constructor__(android.animation.StateListAnimator ), this, stateListAnimator);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_animation_StateListAnimator_1$onAnimationEnd(android.animation.Animator ), this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_animation_StateListAnimator$addState(int[] specs, Animator animator2) {
        Tuple tuple = new Tuple(specs, animator2, null);
        tuple.mAnimator.addListener(this.mAnimatorListener);
        this.mTuples.add(tuple);
        this.mChangingConfigurations |= animator2.getChangingConfigurations();
    }

    private final Animator $$robo$$android_animation_StateListAnimator$getRunningAnimator() {
        return this.mRunningAnimator;
    }

    private final View $$robo$$android_animation_StateListAnimator$getTarget() {
        return this.mViewRef == null ? null : (View)this.mViewRef.get();
    }

    private final void $$robo$$android_animation_StateListAnimator$setTarget(View view) {
        View current = this.getTarget();
        if (current == view) {
            return;
        }
        if (current != null) {
            this.clearTarget();
        }
        if (view != null) {
            this.mViewRef = new WeakReference<View>(view);
        }
    }

    private final void $$robo$$android_animation_StateListAnimator$clearTarget() {
        int size = this.mTuples.size();
        for (int i = 0; i < size; ++i) {
            this.mTuples.get((int)i).mAnimator.setTarget(null);
        }
        this.mViewRef = null;
        this.mLastMatch = null;
        this.mRunningAnimator = null;
    }

    private final StateListAnimator $$robo$$android_animation_StateListAnimator$clone() {
        try {
            StateListAnimator clone = (StateListAnimator)super.clone();
            clone.mTuples = new ArrayList(this.mTuples.size());
            clone.mLastMatch = null;
            clone.mRunningAnimator = null;
            clone.mViewRef = null;
            clone.mAnimatorListener = null;
            clone.initAnimatorListener();
            int tupleSize = this.mTuples.size();
            for (int i = 0; i < tupleSize; ++i) {
                Tuple tuple = this.mTuples.get(i);
                Object animatorClone = tuple.mAnimator.clone();
                ((Animator)animatorClone).removeListener(this.mAnimatorListener);
                clone.addState(tuple.mSpecs, (Animator)animatorClone);
            }
            clone.setChangingConfigurations(this.getChangingConfigurations());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("cannot clone state list animator", e);
        }
    }

    private final void $$robo$$android_animation_StateListAnimator$setState(int[] state) {
        Tuple match = null;
        int count = this.mTuples.size();
        for (int i = 0; i < count; ++i) {
            Tuple tuple = this.mTuples.get(i);
            if (!StateSet.stateSetMatches(tuple.mSpecs, state)) continue;
            match = tuple;
            break;
        }
        if (match == this.mLastMatch) {
            return;
        }
        if (this.mLastMatch != null) {
            this.cancel();
        }
        this.mLastMatch = match;
        if (match != null) {
            this.start(match);
        }
    }

    private final void $$robo$$android_animation_StateListAnimator$start(Tuple match) {
        match.mAnimator.setTarget(this.getTarget());
        this.mRunningAnimator = match.mAnimator;
        this.mRunningAnimator.start();
    }

    private final void $$robo$$android_animation_StateListAnimator$cancel() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.cancel();
            this.mRunningAnimator = null;
        }
    }

    private final ArrayList<Tuple> $$robo$$android_animation_StateListAnimator$getTuples() {
        return this.mTuples;
    }

    private final void $$robo$$android_animation_StateListAnimator$jumpToCurrentState() {
        if (this.mRunningAnimator != null) {
            this.mRunningAnimator.end();
        }
    }

    private final int $$robo$$android_animation_StateListAnimator$getChangingConfigurations() {
        return this.mChangingConfigurations;
    }

    private final void $$robo$$android_animation_StateListAnimator$setChangingConfigurations(int configs) {
        this.mChangingConfigurations = configs;
    }

    private final void $$robo$$android_animation_StateListAnimator$appendChangingConfigurations(int configs) {
        this.mChangingConfigurations |= configs;
    }

    private final ConstantState<StateListAnimator> $$robo$$android_animation_StateListAnimator$createConstantState() {
        return new StateListAnimatorConstantState(this);
    }

    private void __constructor__() {
        this.$$robo$$android_animation_StateListAnimator$__constructor__();
    }

    public StateListAnimator() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_StateListAnimator$__constructor__(), this);
    }

    private void initAnimatorListener() {
        InvokeDynamicSupport.bootstrap("initAnimatorListener", $$robo$$android_animation_StateListAnimator$initAnimatorListener(), this);
    }

    public void addState(int[] nArray, Animator animator2) {
        InvokeDynamicSupport.bootstrap("addState", $$robo$$android_animation_StateListAnimator$addState(int[] android.animation.Animator ), this, nArray, animator2);
    }

    public Animator getRunningAnimator() {
        return InvokeDynamicSupport.bootstrap("getRunningAnimator", $$robo$$android_animation_StateListAnimator$getRunningAnimator(), this);
    }

    public View getTarget() {
        return InvokeDynamicSupport.bootstrap("getTarget", $$robo$$android_animation_StateListAnimator$getTarget(), this);
    }

    public void setTarget(View view) {
        InvokeDynamicSupport.bootstrap("setTarget", $$robo$$android_animation_StateListAnimator$setTarget(android.view.View ), this, view);
    }

    private void clearTarget() {
        InvokeDynamicSupport.bootstrap("clearTarget", $$robo$$android_animation_StateListAnimator$clearTarget(), this);
    }

    public StateListAnimator clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_animation_StateListAnimator$clone(), this);
    }

    public void setState(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_animation_StateListAnimator$setState(int[] ), this, nArray);
    }

    private void start(Tuple tuple) {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_animation_StateListAnimator$start(android.animation.StateListAnimator$Tuple ), this, tuple);
    }

    private void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_animation_StateListAnimator$cancel(), this);
    }

    public ArrayList<Tuple> getTuples() {
        return InvokeDynamicSupport.bootstrap("getTuples", $$robo$$android_animation_StateListAnimator$getTuples(), this);
    }

    public void jumpToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpToCurrentState", $$robo$$android_animation_StateListAnimator$jumpToCurrentState(), this);
    }

    public int getChangingConfigurations() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_animation_StateListAnimator$getChangingConfigurations(), this);
    }

    public void setChangingConfigurations(int n) {
        InvokeDynamicSupport.bootstrap("setChangingConfigurations", $$robo$$android_animation_StateListAnimator$setChangingConfigurations(int ), this, n);
    }

    public void appendChangingConfigurations(int n) {
        InvokeDynamicSupport.bootstrap("appendChangingConfigurations", $$robo$$android_animation_StateListAnimator$appendChangingConfigurations(int ), this, n);
    }

    public ConstantState<StateListAnimator> createConstantState() {
        return InvokeDynamicSupport.bootstrap("createConstantState", $$robo$$android_animation_StateListAnimator$createConstantState(), this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateListAnimator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class StateListAnimatorConstantState
    extends ConstantState<StateListAnimator> {
        public /* synthetic */ Object __robo_data__;
        StateListAnimator mAnimator;
        int mChangingConf;

        private void $$robo$$android_animation_StateListAnimator_StateListAnimatorConstantState$__constructor__(StateListAnimator animator2) {
            this.mAnimator = animator2;
            this.mAnimator.mConstantState = this;
            this.mChangingConf = this.mAnimator.getChangingConfigurations();
        }

        private final int $$robo$$android_animation_StateListAnimator_StateListAnimatorConstantState$getChangingConfigurations() {
            return this.mChangingConf;
        }

        private final StateListAnimator $$robo$$android_animation_StateListAnimator_StateListAnimatorConstantState$newInstance() {
            Object clone = this.mAnimator.clone();
            ((StateListAnimator)clone).mConstantState = this;
            return clone;
        }

        private void __constructor__(StateListAnimator stateListAnimator) {
            this.$$robo$$android_animation_StateListAnimator_StateListAnimatorConstantState$__constructor__(stateListAnimator);
        }

        public StateListAnimatorConstantState(StateListAnimator stateListAnimator) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_StateListAnimator_StateListAnimatorConstantState$__constructor__(android.animation.StateListAnimator ), this, stateListAnimator);
        }

        @Override
        public int getChangingConfigurations() {
            return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_animation_StateListAnimator_StateListAnimatorConstantState$getChangingConfigurations(), this);
        }

        @Override
        public StateListAnimator newInstance() {
            return InvokeDynamicSupport.bootstrap("newInstance", $$robo$$android_animation_StateListAnimator_StateListAnimatorConstantState$newInstance(), this);
        }

        public /* synthetic */ StateListAnimatorConstantState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StateListAnimatorConstantState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Tuple
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int[] mSpecs;
        Animator mAnimator;

        private void $$robo$$android_animation_StateListAnimator_Tuple$__constructor__(int[] specs, Animator animator2) {
            this.mSpecs = specs;
            this.mAnimator = animator2;
        }

        private final int[] $$robo$$android_animation_StateListAnimator_Tuple$getSpecs() {
            return this.mSpecs;
        }

        private final Animator $$robo$$android_animation_StateListAnimator_Tuple$getAnimator() {
            return this.mAnimator;
        }

        private /* synthetic */ void $$robo$$android_animation_StateListAnimator_Tuple$__constructor__(int[] x0, Animator x1, 1 x2) {
        }

        private void __constructor__(int[] nArray, Animator animator2) {
            this.$$robo$$android_animation_StateListAnimator_Tuple$__constructor__(nArray, animator2);
        }

        public Tuple(int[] nArray, Animator animator2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_StateListAnimator_Tuple$__constructor__(int[] android.animation.Animator ), this, nArray, animator2);
        }

        public int[] getSpecs() {
            return InvokeDynamicSupport.bootstrap("getSpecs", $$robo$$android_animation_StateListAnimator_Tuple$getSpecs(), this);
        }

        public Animator getAnimator() {
            return InvokeDynamicSupport.bootstrap("getAnimator", $$robo$$android_animation_StateListAnimator_Tuple$getAnimator(), this);
        }

        private /* synthetic */ void __constructor__(int[] nArray, Animator animator2, 1 var3_3) {
            this.$$robo$$android_animation_StateListAnimator_Tuple$__constructor__(nArray, animator2, var3_3);
        }

        public /* synthetic */ Tuple(int[] nArray, Animator animator2, 1 var3_3) {
            this(nArray, animator2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_animation_StateListAnimator_Tuple$__constructor__(int[] android.animation.Animator android.animation.StateListAnimator$1 ), this, nArray, animator2, var3_3);
        }

        public /* synthetic */ Tuple() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Tuple)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

