/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.Activity;
import android.app.ActivityManagerInternal;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.GrantedUriPermission;
import android.app.IActivityManager;
import android.app.IAppTask;
import android.app.IUidObserver;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Singleton;
import android.util.Size;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.MemInfoReader;
import com.android.server.LocalServices;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlSerializer;

public class ActivityManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static int gMaxRecentTasks;
    private Context mContext;
    private static volatile boolean sSystemReady;
    private static int FIRST_START_FATAL_ERROR_CODE = -100;
    private static int LAST_START_FATAL_ERROR_CODE = -1;
    private static int FIRST_START_SUCCESS_CODE = 0;
    private static int LAST_START_SUCCESS_CODE = 99;
    private static int FIRST_START_NON_FATAL_ERROR_CODE = 100;
    private static int LAST_START_NON_FATAL_ERROR_CODE = 199;
    ArrayMap<OnUidImportanceListener, UidObserver> mImportanceListeners;
    public static int BUGREPORT_OPTION_FULL = 0;
    public static int BUGREPORT_OPTION_INTERACTIVE = 1;
    public static int BUGREPORT_OPTION_REMOTE = 2;
    public static int BUGREPORT_OPTION_WEAR = 3;
    public static int BUGREPORT_OPTION_TELEPHONY = 4;
    public static int BUGREPORT_OPTION_WIFI = 5;
    public static String META_HOME_ALTERNATE = "android.app.home.alternate";
    public static int START_VOICE_HIDDEN_SESSION = -100;
    public static int START_VOICE_NOT_ACTIVE_SESSION = -99;
    public static int START_NOT_CURRENT_USER_ACTIVITY = -98;
    public static int START_NOT_VOICE_COMPATIBLE = -97;
    public static int START_CANCELED = -96;
    public static int START_NOT_ACTIVITY = -95;
    public static int START_PERMISSION_DENIED = -94;
    public static int START_FORWARD_AND_REQUEST_CONFLICT = -93;
    public static int START_CLASS_NOT_FOUND = -92;
    public static int START_INTENT_NOT_RESOLVED = -91;
    public static int START_ASSISTANT_HIDDEN_SESSION = -90;
    public static int START_ASSISTANT_NOT_ACTIVE_SESSION = -89;
    public static int START_SUCCESS = 0;
    public static int START_RETURN_INTENT_TO_CALLER = 1;
    public static int START_TASK_TO_FRONT = 2;
    public static int START_DELIVERED_TO_TOP = 3;
    public static int START_SWITCHES_CANCELED = 100;
    public static int START_RETURN_LOCK_TASK_MODE_VIOLATION = 101;
    public static int START_ABORTED = 102;
    public static int START_FLAG_ONLY_IF_NEEDED = 1;
    public static int START_FLAG_DEBUG = 2;
    public static int START_FLAG_TRACK_ALLOCATION = 4;
    public static int START_FLAG_NATIVE_DEBUGGING = 8;
    public static int BROADCAST_SUCCESS = 0;
    public static int BROADCAST_STICKY_CANT_HAVE_PERMISSION = -1;
    public static int BROADCAST_FAILED_USER_STOPPED = -2;
    public static int INTENT_SENDER_BROADCAST = 1;
    public static int INTENT_SENDER_ACTIVITY = 2;
    public static int INTENT_SENDER_ACTIVITY_RESULT = 3;
    public static int INTENT_SENDER_SERVICE = 4;
    public static int INTENT_SENDER_FOREGROUND_SERVICE = 5;
    public static int USER_OP_SUCCESS = 0;
    public static int USER_OP_UNKNOWN_USER = -1;
    public static int USER_OP_IS_CURRENT = -2;
    public static int USER_OP_ERROR_IS_SYSTEM = -3;
    public static int USER_OP_ERROR_RELATED_USERS_CANNOT_STOP = -4;
    public static int PROCESS_STATE_UNKNOWN = -1;
    public static int PROCESS_STATE_PERSISTENT = 0;
    public static int PROCESS_STATE_PERSISTENT_UI = 1;
    public static int PROCESS_STATE_TOP = 2;
    public static int PROCESS_STATE_FOREGROUND_SERVICE = 3;
    public static int PROCESS_STATE_BOUND_FOREGROUND_SERVICE = 4;
    public static int PROCESS_STATE_IMPORTANT_FOREGROUND = 5;
    public static int PROCESS_STATE_IMPORTANT_BACKGROUND = 6;
    public static int PROCESS_STATE_TRANSIENT_BACKGROUND = 7;
    public static int PROCESS_STATE_BACKUP = 8;
    public static int PROCESS_STATE_SERVICE = 9;
    public static int PROCESS_STATE_RECEIVER = 10;
    public static int PROCESS_STATE_TOP_SLEEPING = 11;
    public static int PROCESS_STATE_HEAVY_WEIGHT = 12;
    public static int PROCESS_STATE_HOME = 13;
    public static int PROCESS_STATE_LAST_ACTIVITY = 14;
    public static int PROCESS_STATE_CACHED_ACTIVITY = 15;
    public static int PROCESS_STATE_CACHED_ACTIVITY_CLIENT = 16;
    public static int PROCESS_STATE_CACHED_RECENT = 17;
    public static int PROCESS_STATE_CACHED_EMPTY = 18;
    public static int PROCESS_STATE_NONEXISTENT = 19;
    public static int MIN_PROCESS_STATE = 0;
    public static int MAX_PROCESS_STATE = 19;
    public static int ASSIST_CONTEXT_BASIC = 0;
    public static int ASSIST_CONTEXT_FULL = 1;
    public static int ASSIST_CONTEXT_AUTOFILL = 2;
    public static int UID_OBSERVER_PROCSTATE = 1;
    public static int UID_OBSERVER_GONE = 2;
    public static int UID_OBSERVER_IDLE = 4;
    public static int UID_OBSERVER_ACTIVE = 8;
    public static int UID_OBSERVER_CACHED = 16;
    public static int APP_START_MODE_NORMAL = 0;
    public static int APP_START_MODE_DELAYED = 1;
    public static int APP_START_MODE_DELAYED_RIGID = 2;
    public static int APP_START_MODE_DISABLED = 3;
    public static int LOCK_TASK_MODE_NONE = 0;
    public static int LOCK_TASK_MODE_LOCKED = 1;
    public static int LOCK_TASK_MODE_PINNED = 2;
    Point mAppTaskThumbnailSize;
    public static int COMPAT_MODE_ALWAYS = -1;
    public static int COMPAT_MODE_NEVER = -2;
    public static int COMPAT_MODE_UNKNOWN = -3;
    public static int COMPAT_MODE_DISABLED = 0;
    public static int COMPAT_MODE_ENABLED = 1;
    public static int COMPAT_MODE_TOGGLE = 2;
    private static boolean DEVELOPMENT_FORCE_LOW_RAM;
    public static int SPLIT_SCREEN_CREATE_MODE_TOP_OR_LEFT = 0;
    public static int SPLIT_SCREEN_CREATE_MODE_BOTTOM_OR_RIGHT = 1;
    public static int RESIZE_MODE_SYSTEM = 0;
    public static int RESIZE_MODE_PRESERVE_WINDOW = 1;
    public static int RESIZE_MODE_FORCED = 2;
    public static int RESIZE_MODE_SYSTEM_SCREEN_ROTATION = 1;
    public static int RESIZE_MODE_USER = 1;
    public static int RESIZE_MODE_USER_FORCED = 3;
    public static int RECENT_WITH_EXCLUDED = 1;
    public static int RECENT_IGNORE_UNAVAILABLE = 2;
    public static int MOVE_TASK_WITH_HOME = 1;
    public static int MOVE_TASK_NO_USER_ACTION = 2;
    public static int FLAG_OR_STOPPED = 1;
    public static int FLAG_AND_LOCKED = 2;
    public static int FLAG_AND_UNLOCKED = 4;
    public static int FLAG_AND_UNLOCKING_OR_UNLOCKED = 8;
    private static Singleton<IActivityManager> IActivityManagerSingleton;
    public static String ACTION_REPORT_HEAP_LIMIT = "android.app.action.REPORT_HEAP_LIMIT";

    private static final int $$robo$$android_app_ActivityManager$processStateAmToProto(int amInt) {
        switch (amInt) {
            case -1: {
                return 999;
            }
            case 0: {
                return 1000;
            }
            case 1: {
                return 1001;
            }
            case 2: {
                return 1002;
            }
            case 3: {
                return 1003;
            }
            case 4: {
                return 1004;
            }
            case 5: {
                return 1005;
            }
            case 6: {
                return 1006;
            }
            case 7: {
                return 1007;
            }
            case 8: {
                return 1008;
            }
            case 9: {
                return 1009;
            }
            case 10: {
                return 1010;
            }
            case 11: {
                return 1011;
            }
            case 12: {
                return 1012;
            }
            case 13: {
                return 1013;
            }
            case 14: {
                return 1014;
            }
            case 15: {
                return 1015;
            }
            case 16: {
                return 1016;
            }
            case 17: {
                return 1017;
            }
            case 18: {
                return 1018;
            }
            case 19: {
                return 1019;
            }
        }
        return 998;
    }

    private static final boolean $$robo$$android_app_ActivityManager$isProcStateBackground(int procState) {
        return procState >= 7;
    }

    private void $$robo$$android_app_ActivityManager$__constructor__(Context context, Handler handler) {
        this.mImportanceListeners = new ArrayMap();
        this.mContext = context;
    }

    private static final boolean $$robo$$android_app_ActivityManager$isStartResultSuccessful(int result) {
        return 0 <= result && result <= 99;
    }

    private static final boolean $$robo$$android_app_ActivityManager$isStartResultFatalError(int result) {
        return -100 <= result && result <= -1;
    }

    private final int $$robo$$android_app_ActivityManager$getFrontActivityScreenCompatMode() {
        try {
            return ActivityManager.getService().getFrontActivityScreenCompatMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$setFrontActivityScreenCompatMode(int mode) {
        try {
            ActivityManager.getService().setFrontActivityScreenCompatMode(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ActivityManager$getPackageScreenCompatMode(String packageName) {
        try {
            return ActivityManager.getService().getPackageScreenCompatMode(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$setPackageScreenCompatMode(String packageName, int mode) {
        try {
            ActivityManager.getService().setPackageScreenCompatMode(packageName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$getPackageAskScreenCompat(String packageName) {
        try {
            return ActivityManager.getService().getPackageAskScreenCompat(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$setPackageAskScreenCompat(String packageName, boolean ask) {
        try {
            ActivityManager.getService().setPackageAskScreenCompat(packageName, ask);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ActivityManager$getMemoryClass() {
        return ActivityManager.staticGetMemoryClass();
    }

    private static final int $$robo$$android_app_ActivityManager$staticGetMemoryClass() {
        String vmHeapSize = SystemProperties.get("dalvik.vm.heapgrowthlimit", "");
        if (vmHeapSize != null && !"".equals(vmHeapSize)) {
            return Integer.parseInt(vmHeapSize.substring(0, vmHeapSize.length() - 1));
        }
        return ActivityManager.staticGetLargeMemoryClass();
    }

    private final int $$robo$$android_app_ActivityManager$getLargeMemoryClass() {
        return ActivityManager.staticGetLargeMemoryClass();
    }

    private static final int $$robo$$android_app_ActivityManager$staticGetLargeMemoryClass() {
        String vmHeapSize = SystemProperties.get("dalvik.vm.heapsize", "16m");
        return Integer.parseInt(vmHeapSize.substring(0, vmHeapSize.length() - 1));
    }

    private final boolean $$robo$$android_app_ActivityManager$isLowRamDevice() {
        return ActivityManager.isLowRamDeviceStatic();
    }

    private static final boolean $$robo$$android_app_ActivityManager$isLowRamDeviceStatic() {
        return RoSystemProperties.CONFIG_LOW_RAM || Build.IS_DEBUGGABLE && DEVELOPMENT_FORCE_LOW_RAM;
    }

    private static final boolean $$robo$$android_app_ActivityManager$isSmallBatteryDevice() {
        return RoSystemProperties.CONFIG_SMALL_BATTERY;
    }

    private static final boolean $$robo$$android_app_ActivityManager$isHighEndGfx() {
        return !ActivityManager.isLowRamDeviceStatic() && !RoSystemProperties.CONFIG_AVOID_GFX_ACCEL && !Resources.getSystem().getBoolean(0x1120020);
    }

    private final long $$robo$$android_app_ActivityManager$getTotalRam() {
        MemInfoReader memreader = new MemInfoReader();
        memreader.readMemInfo();
        return memreader.getTotalSize();
    }

    private static final int $$robo$$android_app_ActivityManager$getMaxRecentTasksStatic() {
        if (gMaxRecentTasks < 0) {
            gMaxRecentTasks = ActivityManager.isLowRamDeviceStatic() ? 36 : 48;
            return gMaxRecentTasks;
        }
        return gMaxRecentTasks;
    }

    private static final int $$robo$$android_app_ActivityManager$getDefaultAppRecentsLimitStatic() {
        return ActivityManager.getMaxRecentTasksStatic() / 6;
    }

    private static final int $$robo$$android_app_ActivityManager$getMaxAppRecentsLimitStatic() {
        return ActivityManager.getMaxRecentTasksStatic() / 2;
    }

    private static final boolean $$robo$$android_app_ActivityManager$supportsMultiWindow(Context context) {
        boolean isWatch = context.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        return (!ActivityManager.isLowRamDeviceStatic() || isWatch) && Resources.getSystem().getBoolean(17957045);
    }

    private static final boolean $$robo$$android_app_ActivityManager$supportsSplitScreenMultiWindow(Context context) {
        return ActivityManager.supportsMultiWindow(context) && Resources.getSystem().getBoolean(17957046);
    }

    @Deprecated
    private static final int $$robo$$android_app_ActivityManager$getMaxNumPictureInPictureActions() {
        return 3;
    }

    @Deprecated
    private final List<RecentTaskInfo> $$robo$$android_app_ActivityManager$getRecentTasks(int maxNum, int flags) throws SecurityException {
        try {
            if (maxNum < 0) {
                throw new IllegalArgumentException("The requested number of tasks should be >= 0");
            }
            return ActivityManager.getService().getRecentTasks(maxNum, flags, this.mContext.getUserId()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<AppTask> $$robo$$android_app_ActivityManager$getAppTasks() {
        List<IBinder> appTasks;
        ArrayList<AppTask> tasks = new ArrayList<AppTask>();
        try {
            appTasks = ActivityManager.getService().getAppTasks(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        int numAppTasks = appTasks.size();
        for (int i = 0; i < numAppTasks; ++i) {
            tasks.add(new AppTask(IAppTask.Stub.asInterface(appTasks.get(i))));
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Size $$robo$$android_app_ActivityManager$getAppTaskThumbnailSize() {
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            this.ensureAppTaskThumbnailSizeLocked();
            return new Size(this.mAppTaskThumbnailSize.x, this.mAppTaskThumbnailSize.y);
        }
    }

    private final void $$robo$$android_app_ActivityManager$ensureAppTaskThumbnailSizeLocked() {
        if (this.mAppTaskThumbnailSize == null) {
            try {
                this.mAppTaskThumbnailSize = ActivityManager.getService().getAppTaskThumbnailSize();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_app_ActivityManager$addAppTask(Activity activity, Intent intent, TaskDescription description, Bitmap thumbnail) {
        Point size;
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            this.ensureAppTaskThumbnailSizeLocked();
            size = this.mAppTaskThumbnailSize;
        }
        int tw = thumbnail.getWidth();
        int th = thumbnail.getHeight();
        if (tw != size.x || th != size.y) {
            float scale;
            Bitmap bm = Bitmap.createBitmap(size.x, size.y, thumbnail.getConfig());
            float dx = 0.0f;
            float dy = 0.0f;
            if (tw * size.x > size.y * th) {
                scale = (float)size.x / (float)th;
                dx = ((float)size.y - (float)tw * scale) * 0.5f;
            } else {
                scale = (float)size.y / (float)tw;
                dy = ((float)size.x - (float)th * scale) * 0.5f;
            }
            Matrix matrix = new Matrix();
            matrix.setScale(scale, scale);
            matrix.postTranslate((int)(dx + 0.5f), 0.0f);
            Canvas canvas = new Canvas(bm);
            canvas.drawBitmap(thumbnail, matrix, null);
            canvas.setBitmap(null);
            thumbnail = bm;
        }
        if (description == null) {
            description = new TaskDescription();
        }
        try {
            return ActivityManager.getService().addAppTask(activity.getActivityToken(), intent, description, thumbnail);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final List<RunningTaskInfo> $$robo$$android_app_ActivityManager$getRunningTasks(int maxNum) throws SecurityException {
        try {
            return ActivityManager.getService().getTasks(maxNum);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$setTaskWindowingMode(int taskId, int windowingMode, boolean toTop) throws SecurityException {
        try {
            ActivityManager.getService().setTaskWindowingMode(taskId, windowingMode, toTop);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$setTaskWindowingModeSplitScreenPrimary(int taskId, int createMode, boolean toTop, boolean animate, Rect initialBounds, boolean showRecents) throws SecurityException {
        try {
            ActivityManager.getService().setTaskWindowingModeSplitScreenPrimary(taskId, createMode, toTop, animate, initialBounds, showRecents);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$resizeStack(int stackId, Rect bounds) throws SecurityException {
        try {
            ActivityManager.getService().resizeStack(stackId, bounds, false, false, false, -1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$removeStacksInWindowingModes(int[] windowingModes) throws SecurityException {
        try {
            ActivityManager.getService().removeStacksInWindowingModes(windowingModes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$removeStacksWithActivityTypes(int[] activityTypes) throws SecurityException {
        try {
            ActivityManager.getService().removeStacksWithActivityTypes(activityTypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$moveTaskToFront(int taskId, int flags) {
        this.moveTaskToFront(taskId, flags, null);
    }

    private final void $$robo$$android_app_ActivityManager$moveTaskToFront(int taskId, int flags, Bundle options) {
        try {
            ActivityManager.getService().moveTaskToFront(taskId, flags, options);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final List<RunningServiceInfo> $$robo$$android_app_ActivityManager$getRunningServices(int maxNum) throws SecurityException {
        try {
            return ActivityManager.getService().getServices(maxNum, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final PendingIntent $$robo$$android_app_ActivityManager$getRunningServiceControlPanel(ComponentName service) throws SecurityException {
        try {
            return ActivityManager.getService().getRunningServiceControlPanel(service);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$getMemoryInfo(MemoryInfo outInfo) {
        try {
            ActivityManager.getService().getMemoryInfo(outInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        try {
            return ActivityManager.getService().clearApplicationUserData(packageName, false, observer, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$clearApplicationUserData() {
        return this.clearApplicationUserData(this.mContext.getPackageName(), null);
    }

    private final ParceledListSlice<GrantedUriPermission> $$robo$$android_app_ActivityManager$getGrantedUriPermissions(String packageName) {
        try {
            ParceledListSlice castedList = ActivityManager.getService().getGrantedUriPermissions(packageName, this.mContext.getUserId());
            return castedList;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$clearGrantedUriPermissions(String packageName) {
        try {
            ActivityManager.getService().clearGrantedUriPermissions(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ProcessErrorStateInfo> $$robo$$android_app_ActivityManager$getProcessesInErrorState() {
        try {
            return ActivityManager.getService().getProcessesInErrorState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ApplicationInfo> $$robo$$android_app_ActivityManager$getRunningExternalApplications() {
        try {
            return ActivityManager.getService().getRunningExternalApplications();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$isBackgroundRestricted() {
        try {
            return ActivityManager.getService().isBackgroundRestricted(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$setProcessMemoryTrimLevel(String process, int userId, int level) {
        try {
            return ActivityManager.getService().setProcessMemoryTrimLevel(process, userId, level);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<RunningAppProcessInfo> $$robo$$android_app_ActivityManager$getRunningAppProcesses() {
        try {
            return ActivityManager.getService().getRunningAppProcesses();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final int $$robo$$android_app_ActivityManager$getPackageImportance(String packageName) {
        try {
            int procState = ActivityManager.getService().getPackageProcessState(packageName, this.mContext.getOpPackageName());
            return RunningAppProcessInfo.procStateToImportanceForClient(procState, this.mContext);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final int $$robo$$android_app_ActivityManager$getUidImportance(int uid) {
        try {
            int procState = ActivityManager.getService().getUidProcessState(uid, this.mContext.getOpPackageName());
            return RunningAppProcessInfo.procStateToImportanceForClient(procState, this.mContext);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final void $$robo$$android_app_ActivityManager$addOnUidImportanceListener(OnUidImportanceListener listener, int importanceCutpoint) {
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            if (this.mImportanceListeners.containsKey(listener)) {
                throw new IllegalArgumentException("Listener already registered: " + listener);
            }
            UidObserver observer = new UidObserver(listener, this.mContext);
            try {
                ActivityManager.getService().registerUidObserver(observer, 3, RunningAppProcessInfo.importanceToProcState(importanceCutpoint), this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mImportanceListeners.put(listener, observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    private final void $$robo$$android_app_ActivityManager$removeOnUidImportanceListener(OnUidImportanceListener listener) {
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            UidObserver observer = this.mImportanceListeners.remove(listener);
            if (observer == null) {
                throw new IllegalArgumentException("Listener not registered: " + listener);
            }
            try {
                ActivityManager.getService().unregisterUidObserver(observer);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private static final void $$robo$$android_app_ActivityManager$getMyMemoryState(RunningAppProcessInfo outState) {
        try {
            ActivityManager.getService().getMyMemoryState(outState);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Debug.MemoryInfo[] $$robo$$android_app_ActivityManager$getProcessMemoryInfo(int[] pids) {
        try {
            return ActivityManager.getService().getProcessMemoryInfo(pids);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_app_ActivityManager$restartPackage(String packageName) {
        this.killBackgroundProcesses(packageName);
    }

    private final void $$robo$$android_app_ActivityManager$killBackgroundProcesses(String packageName) {
        try {
            ActivityManager.getService().killBackgroundProcesses(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_app_ActivityManager$killUid(int uid, String reason) {
        try {
            ActivityManager.getService().killUid(UserHandle.getAppId(uid), UserHandle.getUserId(uid), reason);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$forceStopPackageAsUser(String packageName, int userId) {
        try {
            ActivityManager.getService().forceStopPackage(packageName, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_app_ActivityManager$forceStopPackage(String packageName) {
        this.forceStopPackageAsUser(packageName, this.mContext.getUserId());
    }

    private final ConfigurationInfo $$robo$$android_app_ActivityManager$getDeviceConfigurationInfo() {
        try {
            return ActivityManager.getService().getDeviceConfigurationInfo();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_app_ActivityManager$getLauncherLargeIconDensity() {
        Resources res = this.mContext.getResources();
        int density = res.getDisplayMetrics().densityDpi;
        int sw = res.getConfiguration().smallestScreenWidthDp;
        if (sw < 600) {
            return density;
        }
        switch (density) {
            case 120: {
                return 160;
            }
            case 160: {
                return 240;
            }
            case 213: {
                return 320;
            }
            case 240: {
                return 320;
            }
            case 320: {
                return 480;
            }
            case 480: {
                return 640;
            }
        }
        return (int)((float)density * 1.5f + 0.5f);
    }

    private final int $$robo$$android_app_ActivityManager$getLauncherLargeIconSize() {
        return ActivityManager.getLauncherLargeIconSizeInner(this.mContext);
    }

    private static final int $$robo$$android_app_ActivityManager$getLauncherLargeIconSizeInner(Context context) {
        Resources res = context.getResources();
        int size = res.getDimensionPixelSize(0x1050000);
        int sw = res.getConfiguration().smallestScreenWidthDp;
        if (sw < 600) {
            return size;
        }
        int density = res.getDisplayMetrics().densityDpi;
        switch (density) {
            case 120: {
                return size * 160 / 120;
            }
            case 160: {
                return size * 240 / 160;
            }
            case 213: {
                return size * 320 / 240;
            }
            case 240: {
                return size * 320 / 240;
            }
            case 320: {
                return size * 480 / 320;
            }
            case 480: {
                return size * 320 * 2 / 480;
            }
        }
        return (int)((float)size * 1.5f + 0.5f);
    }

    private static final boolean $$robo$$android_app_ActivityManager$isUserAMonkey() {
        try {
            return ActivityManager.getService().isUserAMonkey();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final boolean $$robo$$android_app_ActivityManager$isRunningInTestHarness() {
        return SystemProperties.getBoolean("ro.test_harness", false);
    }

    private final void $$robo$$android_app_ActivityManager$alwaysShowUnsupportedCompileSdkWarning(ComponentName activity) {
        try {
            ActivityManager.getService().alwaysShowUnsupportedCompileSdkWarning(activity);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final int $$robo$$android_app_ActivityManager$checkComponentPermission(String permission2, int uid, int owningUid, boolean exported) {
        int appId = UserHandle.getAppId(uid);
        if (appId == 0 || appId == 1000) {
            return 0;
        }
        if (UserHandle.isIsolated(uid)) {
            return -1;
        }
        if (owningUid >= 0 && UserHandle.isSameApp(uid, owningUid)) {
            return 0;
        }
        if (!exported) {
            return -1;
        }
        if (permission2 == null) {
            return 0;
        }
        try {
            return AppGlobals.getPackageManager().checkUidPermission(permission2, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final int $$robo$$android_app_ActivityManager$checkUidPermission(String permission2, int uid) {
        try {
            return AppGlobals.getPackageManager().checkUidPermission(permission2, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final int $$robo$$android_app_ActivityManager$handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, boolean requireFull, String name, String callerPackage) {
        if (UserHandle.getUserId(callingUid) == userId) {
            return userId;
        }
        try {
            return ActivityManager.getService().handleIncomingUser(callingPid, callingUid, userId, allowAll, requireFull, name, callerPackage);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private static final int $$robo$$android_app_ActivityManager$getCurrentUser() {
        try {
            UserInfo ui = ActivityManager.getService().getCurrentUser();
            return ui != null ? ui.id : 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$switchUser(int userid) {
        try {
            return ActivityManager.getService().switchUser(userid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final void $$robo$$android_app_ActivityManager$logoutCurrentUser() {
        int currentUser = ActivityManager.getCurrentUser();
        if (currentUser != 0) {
            try {
                ActivityManager.getService().switchUser(0);
                ActivityManager.getService().stopUser(currentUser, false, null);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$isUserRunning(int userId) {
        try {
            return ActivityManager.getService().isUserRunning(userId, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_app_ActivityManager$isVrModePackageEnabled(ComponentName component) {
        try {
            return ActivityManager.getService().isVrModePackageEnabled(component);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$dumpPackageState(FileDescriptor fd, String packageName) {
        ActivityManager.dumpPackageStateStatic(fd, packageName);
    }

    private static final void $$robo$$android_app_ActivityManager$dumpPackageStateStatic(FileDescriptor fd, String packageName) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        ActivityManager.dumpService(pw, fd, "package", new String[]{packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "activity", new String[]{"-a", "package", packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "meminfo", new String[]{"--local", "--package", packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "procstats", new String[]{packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "usagestats", new String[]{packageName});
        ((PrintWriter)pw).println();
        ActivityManager.dumpService(pw, fd, "batterystats", new String[]{packageName});
        ((PrintWriter)pw).flush();
    }

    private static final boolean $$robo$$android_app_ActivityManager$isSystemReady() {
        if (!sSystemReady) {
            sSystemReady = ActivityThread.isSystem() ? LocalServices.getService(ActivityManagerInternal.class).isSystemReady() : true;
        }
        return sSystemReady;
    }

    private static final void $$robo$$android_app_ActivityManager$broadcastStickyIntent(Intent intent, int userId) {
        ActivityManager.broadcastStickyIntent(intent, -1, userId);
    }

    private static final void $$robo$$android_app_ActivityManager$broadcastStickyIntent(Intent intent, int appOp, int userId) {
        try {
            ActivityManager.getService().broadcastIntent(null, intent, null, null, -1, null, null, null, appOp, null, false, true, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_app_ActivityManager$noteWakeupAlarm(PendingIntent ps, WorkSource workSource, int sourceUid, String sourcePkg, String tag) {
        try {
            ActivityManager.getService().noteWakeupAlarm(ps != null ? ps.getTarget() : null, workSource, sourceUid, sourcePkg, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_app_ActivityManager$noteAlarmStart(PendingIntent ps, WorkSource workSource, int sourceUid, String tag) {
        try {
            ActivityManager.getService().noteAlarmStart(ps != null ? ps.getTarget() : null, workSource, sourceUid, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_app_ActivityManager$noteAlarmFinish(PendingIntent ps, WorkSource workSource, int sourceUid, String tag) {
        try {
            ActivityManager.getService().noteAlarmFinish(ps != null ? ps.getTarget() : null, workSource, sourceUid, tag);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final IActivityManager $$robo$$android_app_ActivityManager$getService() {
        return IActivityManagerSingleton.get();
    }

    private static final void $$robo$$android_app_ActivityManager$dumpService(PrintWriter pw, FileDescriptor fd, String name, String[] args) {
        pw.print("DUMP OF SERVICE ");
        pw.print(name);
        pw.println(":");
        IBinder service = ServiceManager.checkService(name);
        if (service == null) {
            pw.println("  (Service not found)");
            pw.flush();
            return;
        }
        pw.flush();
        if (service instanceof Binder) {
            try {
                service.dump(fd, args);
            }
            catch (Throwable e) {
                pw.println("Failure dumping service:");
                e.printStackTrace(pw);
                pw.flush();
            }
        } else {
            TransferPipe tp = null;
            try {
                pw.flush();
                tp = new TransferPipe();
                tp.setBufferPrefix("  ");
                service.dumpAsync(tp.getWriteFd().getFileDescriptor(), args);
                tp.go(fd, 10000L);
            }
            catch (Throwable e) {
                if (tp != null) {
                    tp.kill();
                }
                pw.println("Failure dumping service:");
                e.printStackTrace(pw);
            }
        }
    }

    private final void $$robo$$android_app_ActivityManager$setWatchHeapLimit(long pssSize) {
        try {
            ActivityManager.getService().setDumpHeapDebugLimit(null, 0, pssSize, this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_ActivityManager$clearWatchHeapLimit() {
        try {
            ActivityManager.getService().setDumpHeapDebugLimit(null, 0, 0L, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_app_ActivityManager$isInLockTaskMode() {
        return this.getLockTaskModeState() != 0;
    }

    private final int $$robo$$android_app_ActivityManager$getLockTaskModeState() {
        try {
            return ActivityManager.getService().getLockTaskModeState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final void $$robo$$android_app_ActivityManager$setVrThread(int tid) {
        try {
            ActivityManager.getService().setVrThread(tid);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final void $$robo$$android_app_ActivityManager$setPersistentVrThread(int tid) {
        try {
            ActivityManager.getService().setPersistentVrThread(tid);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static void __staticInitializer__() {
        TAG = "ActivityManager";
        gMaxRecentTasks = -1;
        sSystemReady = false;
        DEVELOPMENT_FORCE_LOW_RAM = SystemProperties.getBoolean("debug.force_low_ram", false);
        IActivityManagerSingleton = new Singleton<IActivityManager>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_ActivityManager_1$__constructor__() {
            }

            private final IActivityManager $$robo$$android_app_ActivityManager_1$create() {
                IBinder b = ServiceManager.getService("activity");
                IActivityManager am = IActivityManager.Stub.asInterface(b);
                return am;
            }

            private void __constructor__() {
                this.$$robo$$android_app_ActivityManager_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_1$__constructor__(), this);
            }

            @Override
            protected IActivityManager create() {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$android_app_ActivityManager_1$create(), this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static int processStateAmToProto(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("processStateAmToProto", $$robo$$android_app_ActivityManager$processStateAmToProto(int ), (int)n);
    }

    public static boolean isProcStateBackground(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isProcStateBackground", $$robo$$android_app_ActivityManager$isProcStateBackground(int ), (int)n);
    }

    private void __constructor__(Context context, Handler handler) {
        this.$$robo$$android_app_ActivityManager$__constructor__(context, handler);
    }

    public ActivityManager(Context context, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager$__constructor__(android.content.Context android.os.Handler ), this, context, handler);
    }

    public static boolean isStartResultSuccessful(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStartResultSuccessful", $$robo$$android_app_ActivityManager$isStartResultSuccessful(int ), (int)n);
    }

    public static boolean isStartResultFatalError(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStartResultFatalError", $$robo$$android_app_ActivityManager$isStartResultFatalError(int ), (int)n);
    }

    public int getFrontActivityScreenCompatMode() {
        return (int)InvokeDynamicSupport.bootstrap("getFrontActivityScreenCompatMode", $$robo$$android_app_ActivityManager$getFrontActivityScreenCompatMode(), this);
    }

    public void setFrontActivityScreenCompatMode(int n) {
        InvokeDynamicSupport.bootstrap("setFrontActivityScreenCompatMode", $$robo$$android_app_ActivityManager$setFrontActivityScreenCompatMode(int ), this, n);
    }

    public int getPackageScreenCompatMode(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getPackageScreenCompatMode", $$robo$$android_app_ActivityManager$getPackageScreenCompatMode(java.lang.String ), this, string2);
    }

    public void setPackageScreenCompatMode(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setPackageScreenCompatMode", $$robo$$android_app_ActivityManager$setPackageScreenCompatMode(java.lang.String int ), this, string2, n);
    }

    public boolean getPackageAskScreenCompat(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPackageAskScreenCompat", $$robo$$android_app_ActivityManager$getPackageAskScreenCompat(java.lang.String ), this, string2);
    }

    public void setPackageAskScreenCompat(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setPackageAskScreenCompat", $$robo$$android_app_ActivityManager$setPackageAskScreenCompat(java.lang.String boolean ), this, string2, bl);
    }

    public int getMemoryClass() {
        return (int)InvokeDynamicSupport.bootstrap("getMemoryClass", $$robo$$android_app_ActivityManager$getMemoryClass(), this);
    }

    public static int staticGetMemoryClass() {
        return (int)InvokeDynamicSupport.bootstrapStatic("staticGetMemoryClass", $$robo$$android_app_ActivityManager$staticGetMemoryClass());
    }

    public int getLargeMemoryClass() {
        return (int)InvokeDynamicSupport.bootstrap("getLargeMemoryClass", $$robo$$android_app_ActivityManager$getLargeMemoryClass(), this);
    }

    public static int staticGetLargeMemoryClass() {
        return (int)InvokeDynamicSupport.bootstrapStatic("staticGetLargeMemoryClass", $$robo$$android_app_ActivityManager$staticGetLargeMemoryClass());
    }

    public boolean isLowRamDevice() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLowRamDevice", $$robo$$android_app_ActivityManager$isLowRamDevice(), this);
    }

    public static boolean isLowRamDeviceStatic() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLowRamDeviceStatic", $$robo$$android_app_ActivityManager$isLowRamDeviceStatic());
    }

    public static boolean isSmallBatteryDevice() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSmallBatteryDevice", $$robo$$android_app_ActivityManager$isSmallBatteryDevice());
    }

    public static boolean isHighEndGfx() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isHighEndGfx", $$robo$$android_app_ActivityManager$isHighEndGfx());
    }

    public long getTotalRam() {
        return (long)InvokeDynamicSupport.bootstrap("getTotalRam", $$robo$$android_app_ActivityManager$getTotalRam(), this);
    }

    public static int getMaxRecentTasksStatic() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxRecentTasksStatic", $$robo$$android_app_ActivityManager$getMaxRecentTasksStatic());
    }

    public static int getDefaultAppRecentsLimitStatic() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultAppRecentsLimitStatic", $$robo$$android_app_ActivityManager$getDefaultAppRecentsLimitStatic());
    }

    public static int getMaxAppRecentsLimitStatic() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxAppRecentsLimitStatic", $$robo$$android_app_ActivityManager$getMaxAppRecentsLimitStatic());
    }

    public static boolean supportsMultiWindow(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("supportsMultiWindow", $$robo$$android_app_ActivityManager$supportsMultiWindow(android.content.Context ), (Context)context);
    }

    public static boolean supportsSplitScreenMultiWindow(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("supportsSplitScreenMultiWindow", $$robo$$android_app_ActivityManager$supportsSplitScreenMultiWindow(android.content.Context ), (Context)context);
    }

    @Deprecated
    public static int getMaxNumPictureInPictureActions() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxNumPictureInPictureActions", $$robo$$android_app_ActivityManager$getMaxNumPictureInPictureActions());
    }

    @Deprecated
    public List<RecentTaskInfo> getRecentTasks(int n, int n2) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getRecentTasks", $$robo$$android_app_ActivityManager$getRecentTasks(int int ), this, n, n2);
    }

    public List<AppTask> getAppTasks() {
        return InvokeDynamicSupport.bootstrap("getAppTasks", $$robo$$android_app_ActivityManager$getAppTasks(), this);
    }

    public Size getAppTaskThumbnailSize() {
        return InvokeDynamicSupport.bootstrap("getAppTaskThumbnailSize", $$robo$$android_app_ActivityManager$getAppTaskThumbnailSize(), this);
    }

    private void ensureAppTaskThumbnailSizeLocked() {
        InvokeDynamicSupport.bootstrap("ensureAppTaskThumbnailSizeLocked", $$robo$$android_app_ActivityManager$ensureAppTaskThumbnailSizeLocked(), this);
    }

    public int addAppTask(Activity activity, Intent intent, TaskDescription taskDescription, Bitmap bitmap) {
        return (int)InvokeDynamicSupport.bootstrap("addAppTask", $$robo$$android_app_ActivityManager$addAppTask(android.app.Activity android.content.Intent android.app.ActivityManager$TaskDescription android.graphics.Bitmap ), this, activity, intent, taskDescription, bitmap);
    }

    @Deprecated
    public List<RunningTaskInfo> getRunningTasks(int n) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getRunningTasks", $$robo$$android_app_ActivityManager$getRunningTasks(int ), this, n);
    }

    public void setTaskWindowingMode(int n, int n2, boolean bl) throws SecurityException {
        InvokeDynamicSupport.bootstrap("setTaskWindowingMode", $$robo$$android_app_ActivityManager$setTaskWindowingMode(int int boolean ), this, n, n2, bl);
    }

    public void setTaskWindowingModeSplitScreenPrimary(int n, int n2, boolean bl, boolean bl2, Rect rect, boolean bl3) throws SecurityException {
        InvokeDynamicSupport.bootstrap("setTaskWindowingModeSplitScreenPrimary", $$robo$$android_app_ActivityManager$setTaskWindowingModeSplitScreenPrimary(int int boolean boolean android.graphics.Rect boolean ), this, n, n2, bl, bl2, rect, bl3);
    }

    public void resizeStack(int n, Rect rect) throws SecurityException {
        InvokeDynamicSupport.bootstrap("resizeStack", $$robo$$android_app_ActivityManager$resizeStack(int android.graphics.Rect ), this, n, rect);
    }

    public void removeStacksInWindowingModes(int[] nArray) throws SecurityException {
        InvokeDynamicSupport.bootstrap("removeStacksInWindowingModes", $$robo$$android_app_ActivityManager$removeStacksInWindowingModes(int[] ), this, nArray);
    }

    public void removeStacksWithActivityTypes(int[] nArray) throws SecurityException {
        InvokeDynamicSupport.bootstrap("removeStacksWithActivityTypes", $$robo$$android_app_ActivityManager$removeStacksWithActivityTypes(int[] ), this, nArray);
    }

    public void moveTaskToFront(int n, int n2) {
        InvokeDynamicSupport.bootstrap("moveTaskToFront", $$robo$$android_app_ActivityManager$moveTaskToFront(int int ), this, n, n2);
    }

    public void moveTaskToFront(int n, int n2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("moveTaskToFront", $$robo$$android_app_ActivityManager$moveTaskToFront(int int android.os.Bundle ), this, n, n2, bundle);
    }

    @Deprecated
    public List<RunningServiceInfo> getRunningServices(int n) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getRunningServices", $$robo$$android_app_ActivityManager$getRunningServices(int ), this, n);
    }

    public PendingIntent getRunningServiceControlPanel(ComponentName componentName) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("getRunningServiceControlPanel", $$robo$$android_app_ActivityManager$getRunningServiceControlPanel(android.content.ComponentName ), this, componentName);
    }

    public void getMemoryInfo(MemoryInfo memoryInfo) {
        InvokeDynamicSupport.bootstrap("getMemoryInfo", $$robo$$android_app_ActivityManager$getMemoryInfo(android.app.ActivityManager$MemoryInfo ), this, memoryInfo);
    }

    public boolean clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearApplicationUserData", $$robo$$android_app_ActivityManager$clearApplicationUserData(java.lang.String android.content.pm.IPackageDataObserver ), this, string2, iPackageDataObserver);
    }

    public boolean clearApplicationUserData() {
        return (boolean)InvokeDynamicSupport.bootstrap("clearApplicationUserData", $$robo$$android_app_ActivityManager$clearApplicationUserData(), this);
    }

    public ParceledListSlice<GrantedUriPermission> getGrantedUriPermissions(String string2) {
        return InvokeDynamicSupport.bootstrap("getGrantedUriPermissions", $$robo$$android_app_ActivityManager$getGrantedUriPermissions(java.lang.String ), this, string2);
    }

    public void clearGrantedUriPermissions(String string2) {
        InvokeDynamicSupport.bootstrap("clearGrantedUriPermissions", $$robo$$android_app_ActivityManager$clearGrantedUriPermissions(java.lang.String ), this, string2);
    }

    public List<ProcessErrorStateInfo> getProcessesInErrorState() {
        return InvokeDynamicSupport.bootstrap("getProcessesInErrorState", $$robo$$android_app_ActivityManager$getProcessesInErrorState(), this);
    }

    public List<ApplicationInfo> getRunningExternalApplications() {
        return InvokeDynamicSupport.bootstrap("getRunningExternalApplications", $$robo$$android_app_ActivityManager$getRunningExternalApplications(), this);
    }

    public boolean isBackgroundRestricted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBackgroundRestricted", $$robo$$android_app_ActivityManager$isBackgroundRestricted(), this);
    }

    public boolean setProcessMemoryTrimLevel(String string2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setProcessMemoryTrimLevel", $$robo$$android_app_ActivityManager$setProcessMemoryTrimLevel(java.lang.String int int ), this, string2, n, n2);
    }

    public List<RunningAppProcessInfo> getRunningAppProcesses() {
        return InvokeDynamicSupport.bootstrap("getRunningAppProcesses", $$robo$$android_app_ActivityManager$getRunningAppProcesses(), this);
    }

    @SystemApi
    public int getPackageImportance(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getPackageImportance", $$robo$$android_app_ActivityManager$getPackageImportance(java.lang.String ), this, string2);
    }

    @SystemApi
    public int getUidImportance(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getUidImportance", $$robo$$android_app_ActivityManager$getUidImportance(int ), this, n);
    }

    @SystemApi
    public void addOnUidImportanceListener(OnUidImportanceListener onUidImportanceListener, int n) {
        InvokeDynamicSupport.bootstrap("addOnUidImportanceListener", $$robo$$android_app_ActivityManager$addOnUidImportanceListener(android.app.ActivityManager$OnUidImportanceListener int ), this, onUidImportanceListener, n);
    }

    @SystemApi
    public void removeOnUidImportanceListener(OnUidImportanceListener onUidImportanceListener) {
        InvokeDynamicSupport.bootstrap("removeOnUidImportanceListener", $$robo$$android_app_ActivityManager$removeOnUidImportanceListener(android.app.ActivityManager$OnUidImportanceListener ), this, onUidImportanceListener);
    }

    public static void getMyMemoryState(RunningAppProcessInfo runningAppProcessInfo) {
        InvokeDynamicSupport.bootstrapStatic("getMyMemoryState", $$robo$$android_app_ActivityManager$getMyMemoryState(android.app.ActivityManager$RunningAppProcessInfo ), (RunningAppProcessInfo)runningAppProcessInfo);
    }

    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getProcessMemoryInfo", $$robo$$android_app_ActivityManager$getProcessMemoryInfo(int[] ), this, nArray);
    }

    @Deprecated
    public void restartPackage(String string2) {
        InvokeDynamicSupport.bootstrap("restartPackage", $$robo$$android_app_ActivityManager$restartPackage(java.lang.String ), this, string2);
    }

    public void killBackgroundProcesses(String string2) {
        InvokeDynamicSupport.bootstrap("killBackgroundProcesses", $$robo$$android_app_ActivityManager$killBackgroundProcesses(java.lang.String ), this, string2);
    }

    @SystemApi
    public void killUid(int n, String string2) {
        InvokeDynamicSupport.bootstrap("killUid", $$robo$$android_app_ActivityManager$killUid(int java.lang.String ), this, n, string2);
    }

    public void forceStopPackageAsUser(String string2, int n) {
        InvokeDynamicSupport.bootstrap("forceStopPackageAsUser", $$robo$$android_app_ActivityManager$forceStopPackageAsUser(java.lang.String int ), this, string2, n);
    }

    @SystemApi
    public void forceStopPackage(String string2) {
        InvokeDynamicSupport.bootstrap("forceStopPackage", $$robo$$android_app_ActivityManager$forceStopPackage(java.lang.String ), this, string2);
    }

    public ConfigurationInfo getDeviceConfigurationInfo() {
        return InvokeDynamicSupport.bootstrap("getDeviceConfigurationInfo", $$robo$$android_app_ActivityManager$getDeviceConfigurationInfo(), this);
    }

    public int getLauncherLargeIconDensity() {
        return (int)InvokeDynamicSupport.bootstrap("getLauncherLargeIconDensity", $$robo$$android_app_ActivityManager$getLauncherLargeIconDensity(), this);
    }

    public int getLauncherLargeIconSize() {
        return (int)InvokeDynamicSupport.bootstrap("getLauncherLargeIconSize", $$robo$$android_app_ActivityManager$getLauncherLargeIconSize(), this);
    }

    static int getLauncherLargeIconSizeInner(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLauncherLargeIconSizeInner", $$robo$$android_app_ActivityManager$getLauncherLargeIconSizeInner(android.content.Context ), (Context)context);
    }

    public static boolean isUserAMonkey() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUserAMonkey", $$robo$$android_app_ActivityManager$isUserAMonkey());
    }

    public static boolean isRunningInTestHarness() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRunningInTestHarness", $$robo$$android_app_ActivityManager$isRunningInTestHarness());
    }

    public void alwaysShowUnsupportedCompileSdkWarning(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("alwaysShowUnsupportedCompileSdkWarning", $$robo$$android_app_ActivityManager$alwaysShowUnsupportedCompileSdkWarning(android.content.ComponentName ), this, componentName);
    }

    public static int checkComponentPermission(String string2, int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkComponentPermission", $$robo$$android_app_ActivityManager$checkComponentPermission(java.lang.String int int boolean ), (String)string2, (int)n, (int)n2, (boolean)bl);
    }

    public static int checkUidPermission(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkUidPermission", $$robo$$android_app_ActivityManager$checkUidPermission(java.lang.String int ), (String)string2, (int)n);
    }

    public static int handleIncomingUser(int n, int n2, int n3, boolean bl, boolean bl2, String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("handleIncomingUser", $$robo$$android_app_ActivityManager$handleIncomingUser(int int int boolean boolean java.lang.String java.lang.String ), (int)n, (int)n2, (int)n3, (boolean)bl, (boolean)bl2, (String)string2, (String)string3);
    }

    @SystemApi
    public static int getCurrentUser() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCurrentUser", $$robo$$android_app_ActivityManager$getCurrentUser());
    }

    public boolean switchUser(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("switchUser", $$robo$$android_app_ActivityManager$switchUser(int ), this, n);
    }

    public static void logoutCurrentUser() {
        InvokeDynamicSupport.bootstrapStatic("logoutCurrentUser", $$robo$$android_app_ActivityManager$logoutCurrentUser());
    }

    public boolean isUserRunning(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserRunning", $$robo$$android_app_ActivityManager$isUserRunning(int ), this, n);
    }

    public boolean isVrModePackageEnabled(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVrModePackageEnabled", $$robo$$android_app_ActivityManager$isVrModePackageEnabled(android.content.ComponentName ), this, componentName);
    }

    public void dumpPackageState(FileDescriptor fileDescriptor, String string2) {
        InvokeDynamicSupport.bootstrap("dumpPackageState", $$robo$$android_app_ActivityManager$dumpPackageState(java.io.FileDescriptor java.lang.String ), this, fileDescriptor, string2);
    }

    public static void dumpPackageStateStatic(FileDescriptor fileDescriptor, String string2) {
        InvokeDynamicSupport.bootstrapStatic("dumpPackageStateStatic", $$robo$$android_app_ActivityManager$dumpPackageStateStatic(java.io.FileDescriptor java.lang.String ), (FileDescriptor)fileDescriptor, (String)string2);
    }

    public static boolean isSystemReady() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemReady", $$robo$$android_app_ActivityManager$isSystemReady());
    }

    public static void broadcastStickyIntent(Intent intent, int n) {
        InvokeDynamicSupport.bootstrapStatic("broadcastStickyIntent", $$robo$$android_app_ActivityManager$broadcastStickyIntent(android.content.Intent int ), (Intent)intent, (int)n);
    }

    public static void broadcastStickyIntent(Intent intent, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("broadcastStickyIntent", $$robo$$android_app_ActivityManager$broadcastStickyIntent(android.content.Intent int int ), (Intent)intent, (int)n, (int)n2);
    }

    public static void noteWakeupAlarm(PendingIntent pendingIntent, WorkSource workSource, int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("noteWakeupAlarm", $$robo$$android_app_ActivityManager$noteWakeupAlarm(android.app.PendingIntent android.os.WorkSource int java.lang.String java.lang.String ), (PendingIntent)pendingIntent, (WorkSource)workSource, (int)n, (String)string2, (String)string3);
    }

    public static void noteAlarmStart(PendingIntent pendingIntent, WorkSource workSource, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("noteAlarmStart", $$robo$$android_app_ActivityManager$noteAlarmStart(android.app.PendingIntent android.os.WorkSource int java.lang.String ), (PendingIntent)pendingIntent, (WorkSource)workSource, (int)n, (String)string2);
    }

    public static void noteAlarmFinish(PendingIntent pendingIntent, WorkSource workSource, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("noteAlarmFinish", $$robo$$android_app_ActivityManager$noteAlarmFinish(android.app.PendingIntent android.os.WorkSource int java.lang.String ), (PendingIntent)pendingIntent, (WorkSource)workSource, (int)n, (String)string2);
    }

    public static IActivityManager getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_app_ActivityManager$getService());
    }

    private static void dumpService(PrintWriter printWriter, FileDescriptor fileDescriptor, String string2, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("dumpService", $$robo$$android_app_ActivityManager$dumpService(java.io.PrintWriter java.io.FileDescriptor java.lang.String java.lang.String[] ), (PrintWriter)printWriter, (FileDescriptor)fileDescriptor, (String)string2, (String[])stringArray);
    }

    public void setWatchHeapLimit(long l) {
        InvokeDynamicSupport.bootstrap("setWatchHeapLimit", $$robo$$android_app_ActivityManager$setWatchHeapLimit(long ), this, l);
    }

    public void clearWatchHeapLimit() {
        InvokeDynamicSupport.bootstrap("clearWatchHeapLimit", $$robo$$android_app_ActivityManager$clearWatchHeapLimit(), this);
    }

    @Deprecated
    public boolean isInLockTaskMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInLockTaskMode", $$robo$$android_app_ActivityManager$isInLockTaskMode(), this);
    }

    public int getLockTaskModeState() {
        return (int)InvokeDynamicSupport.bootstrap("getLockTaskModeState", $$robo$$android_app_ActivityManager$getLockTaskModeState(), this);
    }

    public static void setVrThread(int n) {
        InvokeDynamicSupport.bootstrapStatic("setVrThread", $$robo$$android_app_ActivityManager$setVrThread(int ), (int)n);
    }

    public static void setPersistentVrThread(int n) {
        InvokeDynamicSupport.bootstrapStatic("setPersistentVrThread", $$robo$$android_app_ActivityManager$setPersistentVrThread(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(ActivityManager.class);
    }

    public /* synthetic */ ActivityManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class AppTask
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private IAppTask mAppTaskImpl;

        private void $$robo$$android_app_ActivityManager_AppTask$__constructor__(IAppTask task) {
            this.mAppTaskImpl = task;
        }

        private final void $$robo$$android_app_ActivityManager_AppTask$finishAndRemoveTask() {
            try {
                this.mAppTaskImpl.finishAndRemoveTask();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final RecentTaskInfo $$robo$$android_app_ActivityManager_AppTask$getTaskInfo() {
            try {
                return this.mAppTaskImpl.getTaskInfo();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_app_ActivityManager_AppTask$moveToFront() {
            try {
                this.mAppTaskImpl.moveToFront();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private final void $$robo$$android_app_ActivityManager_AppTask$startActivity(Context context, Intent intent, Bundle options) {
            ActivityThread thread = ActivityThread.currentActivityThread();
            thread.getInstrumentation().execStartActivityFromAppTask(context, thread.getApplicationThread(), this.mAppTaskImpl, intent, options);
        }

        private final void $$robo$$android_app_ActivityManager_AppTask$setExcludeFromRecents(boolean exclude) {
            try {
                this.mAppTaskImpl.setExcludeFromRecents(exclude);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        private void __constructor__(IAppTask iAppTask) {
            this.$$robo$$android_app_ActivityManager_AppTask$__constructor__(iAppTask);
        }

        public AppTask(IAppTask iAppTask) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_AppTask$__constructor__(android.app.IAppTask ), this, iAppTask);
        }

        public void finishAndRemoveTask() {
            InvokeDynamicSupport.bootstrap("finishAndRemoveTask", $$robo$$android_app_ActivityManager_AppTask$finishAndRemoveTask(), this);
        }

        public RecentTaskInfo getTaskInfo() {
            return InvokeDynamicSupport.bootstrap("getTaskInfo", $$robo$$android_app_ActivityManager_AppTask$getTaskInfo(), this);
        }

        public void moveToFront() {
            InvokeDynamicSupport.bootstrap("moveToFront", $$robo$$android_app_ActivityManager_AppTask$moveToFront(), this);
        }

        public void startActivity(Context context, Intent intent, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("startActivity", $$robo$$android_app_ActivityManager_AppTask$startActivity(android.content.Context android.content.Intent android.os.Bundle ), this, context, intent, bundle);
        }

        public void setExcludeFromRecents(boolean bl) {
            InvokeDynamicSupport.bootstrap("setExcludeFromRecents", $$robo$$android_app_ActivityManager_AppTask$setExcludeFromRecents(boolean ), this, bl);
        }

        public /* synthetic */ AppTask() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppTask)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @SystemApi
    public static interface OnUidImportanceListener {
        public void onUidImportance(int var1, int var2);
    }

    public static class RunningAppProcessInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String processName;
        public int pid;
        public int uid;
        public String[] pkgList;
        public static int FLAG_CANT_SAVE_STATE = 1;
        public static int FLAG_PERSISTENT = 2;
        public static int FLAG_HAS_ACTIVITIES = 4;
        public int flags;
        public int lastTrimLevel;
        public static int IMPORTANCE_FOREGROUND = 100;
        public static int IMPORTANCE_FOREGROUND_SERVICE = 125;
        @Deprecated
        public static int IMPORTANCE_TOP_SLEEPING_PRE_28 = 150;
        public static int IMPORTANCE_VISIBLE = 200;
        public static int IMPORTANCE_PERCEPTIBLE_PRE_26 = 130;
        public static int IMPORTANCE_PERCEPTIBLE = 230;
        public static int IMPORTANCE_CANT_SAVE_STATE_PRE_26 = 170;
        public static int IMPORTANCE_SERVICE = 300;
        public static int IMPORTANCE_TOP_SLEEPING = 325;
        public static int IMPORTANCE_CANT_SAVE_STATE = 350;
        public static int IMPORTANCE_CACHED = 400;
        public static int IMPORTANCE_BACKGROUND = 400;
        @Deprecated
        public static int IMPORTANCE_EMPTY = 500;
        public static int IMPORTANCE_GONE = 1000;
        public int importance;
        public int lru;
        public static int REASON_UNKNOWN = 0;
        public static int REASON_PROVIDER_IN_USE = 1;
        public static int REASON_SERVICE_IN_USE = 2;
        public int importanceReasonCode;
        public int importanceReasonPid;
        public ComponentName importanceReasonComponent;
        public int importanceReasonImportance;
        public int processState;
        public static Parcelable.Creator<RunningAppProcessInfo> CREATOR;

        private static final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportance(int procState) {
            if (procState == 19) {
                return 1000;
            }
            if (procState >= 13) {
                return 400;
            }
            if (procState == 12) {
                return 350;
            }
            if (procState >= 11) {
                return 325;
            }
            if (procState >= 9) {
                return 300;
            }
            if (procState >= 7) {
                return 230;
            }
            if (procState >= 5) {
                return 200;
            }
            if (procState >= 3) {
                return 125;
            }
            return 100;
        }

        private static final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportanceForClient(int procState, Context clientContext) {
            return RunningAppProcessInfo.procStateToImportanceForTargetSdk(procState, clientContext.getApplicationInfo().targetSdkVersion);
        }

        private static final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportanceForTargetSdk(int procState, int targetSdkVersion) {
            int importance = RunningAppProcessInfo.procStateToImportance(procState);
            if (targetSdkVersion < 26) {
                switch (importance) {
                    case 230: {
                        return 130;
                    }
                    case 325: {
                        return 150;
                    }
                    case 350: {
                        return 170;
                    }
                }
            }
            return importance;
        }

        private static final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$importanceToProcState(int importance) {
            if (importance == 1000) {
                return 19;
            }
            if (importance >= 400) {
                return 13;
            }
            if (importance >= 350) {
                return 12;
            }
            if (importance >= 325) {
                return 11;
            }
            if (importance >= 300) {
                return 9;
            }
            if (importance >= 230) {
                return 7;
            }
            if (importance >= 200) {
                return 5;
            }
            if (importance >= 150) {
                return 5;
            }
            if (importance >= 125) {
                return 3;
            }
            return 2;
        }

        private void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__() {
            this.importance = 100;
            this.importanceReasonCode = 0;
            this.processState = 5;
        }

        private void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(String pProcessName, int pPid, String[] pArr) {
            this.processName = pProcessName;
            this.pid = pPid;
            this.pkgList = pArr;
        }

        private final int $$robo$$android_app_ActivityManager_RunningAppProcessInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.processName);
            dest.writeInt(this.pid);
            dest.writeInt(this.uid);
            dest.writeStringArray(this.pkgList);
            dest.writeInt(this.flags);
            dest.writeInt(this.lastTrimLevel);
            dest.writeInt(this.importance);
            dest.writeInt(this.lru);
            dest.writeInt(this.importanceReasonCode);
            dest.writeInt(this.importanceReasonPid);
            ComponentName.writeToParcel(this.importanceReasonComponent, dest);
            dest.writeInt(this.importanceReasonImportance);
            dest.writeInt(this.processState);
        }

        private final void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$readFromParcel(Parcel source) {
            this.processName = source.readString();
            this.pid = source.readInt();
            this.uid = source.readInt();
            this.pkgList = source.readStringArray();
            this.flags = source.readInt();
            this.lastTrimLevel = source.readInt();
            this.importance = source.readInt();
            this.lru = source.readInt();
            this.importanceReasonCode = source.readInt();
            this.importanceReasonPid = source.readInt();
            this.importanceReasonComponent = ComponentName.readFromParcel(source);
            this.importanceReasonImportance = source.readInt();
            this.processState = source.readInt();
        }

        private void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RunningAppProcessInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$__constructor__() {
                }

                private final RunningAppProcessInfo $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$createFromParcel(Parcel source) {
                    return new RunningAppProcessInfo(source, null);
                }

                private final RunningAppProcessInfo[] $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$newArray(int size) {
                    return new RunningAppProcessInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$__constructor__(), this);
                }

                @Override
                public RunningAppProcessInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public RunningAppProcessInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_RunningAppProcessInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public static int procStateToImportance(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("procStateToImportance", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportance(int ), (int)n);
        }

        public static int procStateToImportanceForClient(int n, Context context) {
            return (int)InvokeDynamicSupport.bootstrapStatic("procStateToImportanceForClient", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportanceForClient(int android.content.Context ), (int)n, (Context)context);
        }

        public static int procStateToImportanceForTargetSdk(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("procStateToImportanceForTargetSdk", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$procStateToImportanceForTargetSdk(int int ), (int)n, (int)n2);
        }

        public static int importanceToProcState(int n) {
            return (int)InvokeDynamicSupport.bootstrapStatic("importanceToProcState", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$importanceToProcState(int ), (int)n);
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__();
        }

        public RunningAppProcessInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(), this);
        }

        private void __constructor__(String string2, int n, String[] stringArray) {
            this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(string2, n, stringArray);
        }

        public RunningAppProcessInfo(String string2, int n, String[] stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(java.lang.String int java.lang.String[] ), this, string2, n, stringArray);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$readFromParcel(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(parcel);
        }

        public RunningAppProcessInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ RunningAppProcessInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningAppProcessInfo$__constructor__(android.os.Parcel android.app.ActivityManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RunningAppProcessInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunningAppProcessInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Importance {
        }
    }

    public static class ProcessErrorStateInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int NO_ERROR = 0;
        public static int CRASHED = 1;
        public static int NOT_RESPONDING = 2;
        public int condition;
        public String processName;
        public int pid;
        public int uid;
        public String tag;
        public String shortMsg;
        public String longMsg;
        public String stackTrace;
        public byte[] crashData;
        public static Parcelable.Creator<ProcessErrorStateInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__() {
            this.crashData = null;
        }

        private final int $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.condition);
            dest.writeString(this.processName);
            dest.writeInt(this.pid);
            dest.writeInt(this.uid);
            dest.writeString(this.tag);
            dest.writeString(this.shortMsg);
            dest.writeString(this.longMsg);
            dest.writeString(this.stackTrace);
        }

        private final void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$readFromParcel(Parcel source) {
            this.condition = source.readInt();
            this.processName = source.readString();
            this.pid = source.readInt();
            this.uid = source.readInt();
            this.tag = source.readString();
            this.shortMsg = source.readString();
            this.longMsg = source.readString();
            this.stackTrace = source.readString();
        }

        private void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(Parcel source) {
            this.crashData = null;
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ProcessErrorStateInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$__constructor__() {
                }

                private final ProcessErrorStateInfo $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$createFromParcel(Parcel source) {
                    return new ProcessErrorStateInfo(source, null);
                }

                private final ProcessErrorStateInfo[] $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$newArray(int size) {
                    return new ProcessErrorStateInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$__constructor__(), this);
                }

                @Override
                public ProcessErrorStateInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public ProcessErrorStateInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__();
        }

        public ProcessErrorStateInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$readFromParcel(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(parcel);
        }

        public ProcessErrorStateInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ ProcessErrorStateInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_ProcessErrorStateInfo$__constructor__(android.os.Parcel android.app.ActivityManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(ProcessErrorStateInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessErrorStateInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StackInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int stackId;
        public Rect bounds;
        public int[] taskIds;
        public String[] taskNames;
        public Rect[] taskBounds;
        public int[] taskUserIds;
        public ComponentName topActivity;
        public int displayId;
        public int userId;
        public boolean visible;
        public int position;
        public Configuration configuration;
        public static Parcelable.Creator<StackInfo> CREATOR;

        private final int $$robo$$android_app_ActivityManager_StackInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_StackInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.stackId);
            dest.writeInt(this.bounds.left);
            dest.writeInt(this.bounds.top);
            dest.writeInt(this.bounds.right);
            dest.writeInt(this.bounds.bottom);
            dest.writeIntArray(this.taskIds);
            dest.writeStringArray(this.taskNames);
            int boundsCount = this.taskBounds == null ? 0 : this.taskBounds.length;
            dest.writeInt(boundsCount);
            for (int i = 0; i < boundsCount; ++i) {
                dest.writeInt(this.taskBounds[i].left);
                dest.writeInt(this.taskBounds[i].top);
                dest.writeInt(this.taskBounds[i].right);
                dest.writeInt(this.taskBounds[i].bottom);
            }
            dest.writeIntArray(this.taskUserIds);
            dest.writeInt(this.displayId);
            dest.writeInt(this.userId);
            dest.writeInt(this.visible ? 1 : 0);
            dest.writeInt(this.position);
            if (this.topActivity != null) {
                dest.writeInt(1);
                this.topActivity.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
            this.configuration.writeToParcel(dest, flags);
        }

        private final void $$robo$$android_app_ActivityManager_StackInfo$readFromParcel(Parcel source) {
            this.stackId = source.readInt();
            this.bounds = new Rect(source.readInt(), source.readInt(), source.readInt(), source.readInt());
            this.taskIds = source.createIntArray();
            this.taskNames = source.createStringArray();
            int boundsCount = source.readInt();
            if (boundsCount > 0) {
                this.taskBounds = new Rect[boundsCount];
                for (int i = 0; i < boundsCount; ++i) {
                    this.taskBounds[i] = new Rect();
                    this.taskBounds[i].set(source.readInt(), source.readInt(), source.readInt(), source.readInt());
                }
            } else {
                this.taskBounds = null;
            }
            this.taskUserIds = source.createIntArray();
            this.displayId = source.readInt();
            this.userId = source.readInt();
            this.visible = source.readInt() > 0;
            this.position = source.readInt();
            if (source.readInt() > 0) {
                this.topActivity = ComponentName.readFromParcel(source);
            }
            this.configuration.readFromParcel(source);
        }

        private void $$robo$$android_app_ActivityManager_StackInfo$__constructor__() {
            this.bounds = new Rect();
            this.configuration = new Configuration();
        }

        private void $$robo$$android_app_ActivityManager_StackInfo$__constructor__(Parcel source) {
            this.bounds = new Rect();
            this.configuration = new Configuration();
            this.readFromParcel(source);
        }

        private final String $$robo$$android_app_ActivityManager_StackInfo$toString(String prefix) {
            StringBuilder sb = new StringBuilder(256);
            sb.append(prefix);
            sb.append("Stack id=");
            sb.append(this.stackId);
            sb.append(" bounds=");
            sb.append(this.bounds.toShortString());
            sb.append(" displayId=");
            sb.append(this.displayId);
            sb.append(" userId=");
            sb.append(this.userId);
            sb.append("\n");
            sb.append(" configuration=");
            sb.append(this.configuration);
            sb.append("\n");
            prefix = prefix + "  ";
            for (int i = 0; i < this.taskIds.length; ++i) {
                sb.append(prefix);
                sb.append("taskId=");
                sb.append(this.taskIds[i]);
                sb.append(": ");
                sb.append(this.taskNames[i]);
                if (this.taskBounds != null) {
                    sb.append(" bounds=");
                    sb.append(this.taskBounds[i].toShortString());
                }
                sb.append(" userId=").append(this.taskUserIds[i]);
                sb.append(" visible=").append(this.visible);
                if (this.topActivity != null) {
                    sb.append(" topActivity=").append(this.topActivity);
                }
                sb.append("\n");
            }
            return sb.toString();
        }

        private final String $$robo$$android_app_ActivityManager_StackInfo$toString() {
            return this.toString("");
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_StackInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<StackInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_StackInfo_1$__constructor__() {
                }

                private final StackInfo $$robo$$android_app_ActivityManager_StackInfo_1$createFromParcel(Parcel source) {
                    return new StackInfo(source, null);
                }

                private final StackInfo[] $$robo$$android_app_ActivityManager_StackInfo_1$newArray(int size) {
                    return new StackInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_StackInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_StackInfo_1$__constructor__(), this);
                }

                @Override
                public StackInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_StackInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public StackInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_StackInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_StackInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_StackInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_StackInfo$readFromParcel(android.os.Parcel ), this, parcel);
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_StackInfo$__constructor__();
        }

        public StackInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_StackInfo$__constructor__(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_StackInfo$__constructor__(parcel);
        }

        public StackInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_StackInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        public String toString(String string2) {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_ActivityManager_StackInfo$toString(java.lang.String ), this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_ActivityManager_StackInfo$toString(), this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_StackInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ StackInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_StackInfo$__constructor__(android.os.Parcel android.app.ActivityManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(StackInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StackInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MemoryInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public long availMem;
        public long totalMem;
        public long threshold;
        public boolean lowMemory;
        public long hiddenAppThreshold;
        public long secondaryServerThreshold;
        public long visibleAppThreshold;
        public long foregroundAppThreshold;
        public static Parcelable.Creator<MemoryInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__() {
        }

        private final int $$robo$$android_app_ActivityManager_MemoryInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_MemoryInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.availMem);
            dest.writeLong(this.totalMem);
            dest.writeLong(this.threshold);
            dest.writeInt(this.lowMemory ? 1 : 0);
            dest.writeLong(this.hiddenAppThreshold);
            dest.writeLong(this.secondaryServerThreshold);
            dest.writeLong(this.visibleAppThreshold);
            dest.writeLong(this.foregroundAppThreshold);
        }

        private final void $$robo$$android_app_ActivityManager_MemoryInfo$readFromParcel(Parcel source) {
            this.availMem = source.readLong();
            this.totalMem = source.readLong();
            this.threshold = source.readLong();
            this.lowMemory = source.readInt() != 0;
            this.hiddenAppThreshold = source.readLong();
            this.secondaryServerThreshold = source.readLong();
            this.visibleAppThreshold = source.readLong();
            this.foregroundAppThreshold = source.readLong();
        }

        private void $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<MemoryInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_MemoryInfo_1$__constructor__() {
                }

                private final MemoryInfo $$robo$$android_app_ActivityManager_MemoryInfo_1$createFromParcel(Parcel source) {
                    return new MemoryInfo(source, null);
                }

                private final MemoryInfo[] $$robo$$android_app_ActivityManager_MemoryInfo_1$newArray(int size) {
                    return new MemoryInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_MemoryInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_MemoryInfo_1$__constructor__(), this);
                }

                @Override
                public MemoryInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_MemoryInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public MemoryInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_MemoryInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_MemoryInfo$__constructor__();
        }

        public MemoryInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_MemoryInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_MemoryInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_MemoryInfo$readFromParcel(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(parcel);
        }

        public MemoryInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ MemoryInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_MemoryInfo$__constructor__(android.os.Parcel android.app.ActivityManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(MemoryInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RunningServiceInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ComponentName service;
        public int pid;
        public int uid;
        public String process;
        public boolean foreground;
        public long activeSince;
        public boolean started;
        public int clientCount;
        public int crashCount;
        public long lastActivityTime;
        public long restarting;
        public static int FLAG_STARTED = 1;
        public static int FLAG_FOREGROUND = 2;
        public static int FLAG_SYSTEM_PROCESS = 4;
        public static int FLAG_PERSISTENT_PROCESS = 8;
        public int flags;
        public String clientPackage;
        public int clientLabel;
        public static Parcelable.Creator<RunningServiceInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__() {
        }

        private final int $$robo$$android_app_ActivityManager_RunningServiceInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_RunningServiceInfo$writeToParcel(Parcel dest, int flags) {
            ComponentName.writeToParcel(this.service, dest);
            dest.writeInt(this.pid);
            dest.writeInt(this.uid);
            dest.writeString(this.process);
            dest.writeInt(this.foreground ? 1 : 0);
            dest.writeLong(this.activeSince);
            dest.writeInt(this.started ? 1 : 0);
            dest.writeInt(this.clientCount);
            dest.writeInt(this.crashCount);
            dest.writeLong(this.lastActivityTime);
            dest.writeLong(this.restarting);
            dest.writeInt(this.flags);
            dest.writeString(this.clientPackage);
            dest.writeInt(this.clientLabel);
        }

        private final void $$robo$$android_app_ActivityManager_RunningServiceInfo$readFromParcel(Parcel source) {
            this.service = ComponentName.readFromParcel(source);
            this.pid = source.readInt();
            this.uid = source.readInt();
            this.process = source.readString();
            this.foreground = source.readInt() != 0;
            this.activeSince = source.readLong();
            this.started = source.readInt() != 0;
            this.clientCount = source.readInt();
            this.crashCount = source.readInt();
            this.lastActivityTime = source.readLong();
            this.restarting = source.readLong();
            this.flags = source.readInt();
            this.clientPackage = source.readString();
            this.clientLabel = source.readInt();
        }

        private void $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RunningServiceInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_RunningServiceInfo_1$__constructor__() {
                }

                private final RunningServiceInfo $$robo$$android_app_ActivityManager_RunningServiceInfo_1$createFromParcel(Parcel source) {
                    return new RunningServiceInfo(source, null);
                }

                private final RunningServiceInfo[] $$robo$$android_app_ActivityManager_RunningServiceInfo_1$newArray(int size) {
                    return new RunningServiceInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_RunningServiceInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningServiceInfo_1$__constructor__(), this);
                }

                @Override
                public RunningServiceInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_RunningServiceInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public RunningServiceInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_RunningServiceInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__();
        }

        public RunningServiceInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_RunningServiceInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_RunningServiceInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_RunningServiceInfo$readFromParcel(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(parcel);
        }

        public RunningServiceInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ RunningServiceInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningServiceInfo$__constructor__(android.os.Parcel android.app.ActivityManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RunningServiceInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunningServiceInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MoveTaskFlags {
    }

    public static class TaskSnapshot
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private GraphicBuffer mSnapshot;
        private int mOrientation;
        private Rect mContentInsets;
        private boolean mReducedResolution;
        private boolean mIsRealSnapshot;
        private int mWindowingMode;
        private float mScale;
        private int mSystemUiVisibility;
        private boolean mIsTranslucent;
        public static Parcelable.Creator<TaskSnapshot> CREATOR;

        private void $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(GraphicBuffer snapshot, int orientation, Rect contentInsets, boolean reducedResolution, float scale, boolean isRealSnapshot, int windowingMode, int systemUiVisibility, boolean isTranslucent) {
            this.mSnapshot = snapshot;
            this.mOrientation = orientation;
            this.mContentInsets = new Rect(contentInsets);
            this.mReducedResolution = reducedResolution;
            this.mScale = scale;
            this.mIsRealSnapshot = isRealSnapshot;
            this.mWindowingMode = windowingMode;
            this.mSystemUiVisibility = systemUiVisibility;
            this.mIsTranslucent = isTranslucent;
        }

        private void $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(Parcel source) {
            this.mSnapshot = (GraphicBuffer)source.readParcelable(null);
            this.mOrientation = source.readInt();
            this.mContentInsets = (Rect)source.readParcelable(null);
            this.mReducedResolution = source.readBoolean();
            this.mScale = source.readFloat();
            this.mIsRealSnapshot = source.readBoolean();
            this.mWindowingMode = source.readInt();
            this.mSystemUiVisibility = source.readInt();
            this.mIsTranslucent = source.readBoolean();
        }

        private final GraphicBuffer $$robo$$android_app_ActivityManager_TaskSnapshot$getSnapshot() {
            return this.mSnapshot;
        }

        private final int $$robo$$android_app_ActivityManager_TaskSnapshot$getOrientation() {
            return this.mOrientation;
        }

        private final Rect $$robo$$android_app_ActivityManager_TaskSnapshot$getContentInsets() {
            return this.mContentInsets;
        }

        private final boolean $$robo$$android_app_ActivityManager_TaskSnapshot$isReducedResolution() {
            return this.mReducedResolution;
        }

        private final boolean $$robo$$android_app_ActivityManager_TaskSnapshot$isRealSnapshot() {
            return this.mIsRealSnapshot;
        }

        private final boolean $$robo$$android_app_ActivityManager_TaskSnapshot$isTranslucent() {
            return this.mIsTranslucent;
        }

        private final int $$robo$$android_app_ActivityManager_TaskSnapshot$getWindowingMode() {
            return this.mWindowingMode;
        }

        private final int $$robo$$android_app_ActivityManager_TaskSnapshot$getSystemUiVisibility() {
            return this.mSystemUiVisibility;
        }

        private final float $$robo$$android_app_ActivityManager_TaskSnapshot$getScale() {
            return this.mScale;
        }

        private final int $$robo$$android_app_ActivityManager_TaskSnapshot$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_TaskSnapshot$writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mSnapshot, 0);
            dest.writeInt(this.mOrientation);
            dest.writeParcelable(this.mContentInsets, 0);
            dest.writeBoolean(this.mReducedResolution);
            dest.writeFloat(this.mScale);
            dest.writeBoolean(this.mIsRealSnapshot);
            dest.writeInt(this.mWindowingMode);
            dest.writeInt(this.mSystemUiVisibility);
            dest.writeBoolean(this.mIsTranslucent);
        }

        private final String $$robo$$android_app_ActivityManager_TaskSnapshot$toString() {
            int width = this.mSnapshot != null ? this.mSnapshot.getWidth() : 0;
            int height = this.mSnapshot != null ? this.mSnapshot.getHeight() : 0;
            return "TaskSnapshot{mSnapshot=" + this.mSnapshot + " (" + width + "x" + height + ") mOrientation=" + this.mOrientation + " mContentInsets=" + this.mContentInsets.toShortString() + " mReducedResolution=" + this.mReducedResolution + " mScale=" + this.mScale + " mIsRealSnapshot=" + this.mIsRealSnapshot + " mWindowingMode=" + this.mWindowingMode + " mSystemUiVisibility=" + this.mSystemUiVisibility + " mIsTranslucent=" + this.mIsTranslucent;
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TaskSnapshot>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_TaskSnapshot_1$__constructor__() {
                }

                private final TaskSnapshot $$robo$$android_app_ActivityManager_TaskSnapshot_1$createFromParcel(Parcel source) {
                    return new TaskSnapshot(source, null);
                }

                private final TaskSnapshot[] $$robo$$android_app_ActivityManager_TaskSnapshot_1$newArray(int size) {
                    return new TaskSnapshot[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_TaskSnapshot_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskSnapshot_1$__constructor__(), this);
                }

                @Override
                public TaskSnapshot createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_TaskSnapshot_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public TaskSnapshot[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_TaskSnapshot_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(GraphicBuffer graphicBuffer, int n, Rect rect, boolean bl, float f, boolean bl2, int n2, int n3, boolean bl3) {
            this.$$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(graphicBuffer, n, rect, bl, f, bl2, n2, n3, bl3);
        }

        public TaskSnapshot(GraphicBuffer graphicBuffer, int n, Rect rect, boolean bl, float f, boolean bl2, int n2, int n3, boolean bl3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(android.graphics.GraphicBuffer int android.graphics.Rect boolean float boolean int int boolean ), this, graphicBuffer, n, rect, bl, f, bl2, n2, n3, bl3);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(parcel);
        }

        public TaskSnapshot(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(android.os.Parcel ), this, parcel);
        }

        public GraphicBuffer getSnapshot() {
            return InvokeDynamicSupport.bootstrap("getSnapshot", $$robo$$android_app_ActivityManager_TaskSnapshot$getSnapshot(), this);
        }

        public int getOrientation() {
            return (int)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_app_ActivityManager_TaskSnapshot$getOrientation(), this);
        }

        public Rect getContentInsets() {
            return InvokeDynamicSupport.bootstrap("getContentInsets", $$robo$$android_app_ActivityManager_TaskSnapshot$getContentInsets(), this);
        }

        public boolean isReducedResolution() {
            return (boolean)InvokeDynamicSupport.bootstrap("isReducedResolution", $$robo$$android_app_ActivityManager_TaskSnapshot$isReducedResolution(), this);
        }

        public boolean isRealSnapshot() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRealSnapshot", $$robo$$android_app_ActivityManager_TaskSnapshot$isRealSnapshot(), this);
        }

        public boolean isTranslucent() {
            return (boolean)InvokeDynamicSupport.bootstrap("isTranslucent", $$robo$$android_app_ActivityManager_TaskSnapshot$isTranslucent(), this);
        }

        public int getWindowingMode() {
            return (int)InvokeDynamicSupport.bootstrap("getWindowingMode", $$robo$$android_app_ActivityManager_TaskSnapshot$getWindowingMode(), this);
        }

        public int getSystemUiVisibility() {
            return (int)InvokeDynamicSupport.bootstrap("getSystemUiVisibility", $$robo$$android_app_ActivityManager_TaskSnapshot$getSystemUiVisibility(), this);
        }

        public float getScale() {
            return (float)InvokeDynamicSupport.bootstrap("getScale", $$robo$$android_app_ActivityManager_TaskSnapshot$getScale(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_TaskSnapshot$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_TaskSnapshot$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_ActivityManager_TaskSnapshot$toString(), this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ TaskSnapshot(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskSnapshot$__constructor__(android.os.Parcel android.app.ActivityManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(TaskSnapshot.class);
        }

        public /* synthetic */ TaskSnapshot() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TaskSnapshot)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RunningTaskInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int id;
        public int stackId;
        public ComponentName baseActivity;
        public ComponentName topActivity;
        public Bitmap thumbnail;
        public CharSequence description;
        public int numActivities;
        public int numRunning;
        public long lastActiveTime;
        public boolean supportsSplitScreenMultiWindow;
        public int resizeMode;
        public Configuration configuration;
        public static Parcelable.Creator<RunningTaskInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__() {
            this.configuration = new Configuration();
        }

        private final int $$robo$$android_app_ActivityManager_RunningTaskInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_RunningTaskInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeInt(this.stackId);
            ComponentName.writeToParcel(this.baseActivity, dest);
            ComponentName.writeToParcel(this.topActivity, dest);
            if (this.thumbnail != null) {
                dest.writeInt(1);
                this.thumbnail.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
            TextUtils.writeToParcel(this.description, dest, 1);
            dest.writeInt(this.numActivities);
            dest.writeInt(this.numRunning);
            dest.writeInt(this.supportsSplitScreenMultiWindow ? 1 : 0);
            dest.writeInt(this.resizeMode);
            this.configuration.writeToParcel(dest, flags);
        }

        private final void $$robo$$android_app_ActivityManager_RunningTaskInfo$readFromParcel(Parcel source) {
            this.id = source.readInt();
            this.stackId = source.readInt();
            this.baseActivity = ComponentName.readFromParcel(source);
            this.topActivity = ComponentName.readFromParcel(source);
            this.thumbnail = source.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(source) : null;
            this.description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            this.numActivities = source.readInt();
            this.numRunning = source.readInt();
            this.supportsSplitScreenMultiWindow = source.readInt() != 0;
            this.resizeMode = source.readInt();
            this.configuration.readFromParcel(source);
        }

        private void $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(Parcel source) {
            this.configuration = new Configuration();
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RunningTaskInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_RunningTaskInfo_1$__constructor__() {
                }

                private final RunningTaskInfo $$robo$$android_app_ActivityManager_RunningTaskInfo_1$createFromParcel(Parcel source) {
                    return new RunningTaskInfo(source, null);
                }

                private final RunningTaskInfo[] $$robo$$android_app_ActivityManager_RunningTaskInfo_1$newArray(int size) {
                    return new RunningTaskInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_RunningTaskInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningTaskInfo_1$__constructor__(), this);
                }

                @Override
                public RunningTaskInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_RunningTaskInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public RunningTaskInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_RunningTaskInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__();
        }

        public RunningTaskInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_RunningTaskInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_RunningTaskInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_RunningTaskInfo$readFromParcel(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(parcel);
        }

        public RunningTaskInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ RunningTaskInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RunningTaskInfo$__constructor__(android.os.Parcel android.app.ActivityManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RunningTaskInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunningTaskInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RecentTaskInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int id;
        public int persistentId;
        public Intent baseIntent;
        public ComponentName origActivity;
        public ComponentName realActivity;
        public CharSequence description;
        public int stackId;
        public int userId;
        public long firstActiveTime;
        public long lastActiveTime;
        public TaskDescription taskDescription;
        public int affiliatedTaskId;
        public int affiliatedTaskColor;
        public ComponentName baseActivity;
        public ComponentName topActivity;
        public int numActivities;
        public Rect bounds;
        public boolean supportsSplitScreenMultiWindow;
        public int resizeMode;
        public Configuration configuration;
        public static Parcelable.Creator<RecentTaskInfo> CREATOR;

        private void $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__() {
            this.configuration = new Configuration();
        }

        private final int $$robo$$android_app_ActivityManager_RecentTaskInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_RecentTaskInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.id);
            dest.writeInt(this.persistentId);
            if (this.baseIntent != null) {
                dest.writeInt(1);
                this.baseIntent.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
            ComponentName.writeToParcel(this.origActivity, dest);
            ComponentName.writeToParcel(this.realActivity, dest);
            TextUtils.writeToParcel(this.description, dest, 1);
            if (this.taskDescription != null) {
                dest.writeInt(1);
                this.taskDescription.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.stackId);
            dest.writeInt(this.userId);
            dest.writeLong(this.lastActiveTime);
            dest.writeInt(this.affiliatedTaskId);
            dest.writeInt(this.affiliatedTaskColor);
            ComponentName.writeToParcel(this.baseActivity, dest);
            ComponentName.writeToParcel(this.topActivity, dest);
            dest.writeInt(this.numActivities);
            if (this.bounds != null) {
                dest.writeInt(1);
                this.bounds.writeToParcel(dest, 0);
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.supportsSplitScreenMultiWindow ? 1 : 0);
            dest.writeInt(this.resizeMode);
            this.configuration.writeToParcel(dest, flags);
        }

        private final void $$robo$$android_app_ActivityManager_RecentTaskInfo$readFromParcel(Parcel source) {
            this.id = source.readInt();
            this.persistentId = source.readInt();
            this.baseIntent = source.readInt() > 0 ? Intent.CREATOR.createFromParcel(source) : null;
            this.origActivity = ComponentName.readFromParcel(source);
            this.realActivity = ComponentName.readFromParcel(source);
            this.description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            this.taskDescription = source.readInt() > 0 ? TaskDescription.CREATOR.createFromParcel(source) : null;
            this.stackId = source.readInt();
            this.userId = source.readInt();
            this.lastActiveTime = source.readLong();
            this.affiliatedTaskId = source.readInt();
            this.affiliatedTaskColor = source.readInt();
            this.baseActivity = ComponentName.readFromParcel(source);
            this.topActivity = ComponentName.readFromParcel(source);
            this.numActivities = source.readInt();
            this.bounds = source.readInt() > 0 ? Rect.CREATOR.createFromParcel(source) : null;
            this.supportsSplitScreenMultiWindow = source.readInt() == 1;
            this.resizeMode = source.readInt();
            this.configuration.readFromParcel(source);
        }

        private void $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(Parcel source) {
            this.configuration = new Configuration();
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RecentTaskInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_RecentTaskInfo_1$__constructor__() {
                }

                private final RecentTaskInfo $$robo$$android_app_ActivityManager_RecentTaskInfo_1$createFromParcel(Parcel source) {
                    return new RecentTaskInfo(source, null);
                }

                private final RecentTaskInfo[] $$robo$$android_app_ActivityManager_RecentTaskInfo_1$newArray(int size) {
                    return new RecentTaskInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_RecentTaskInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RecentTaskInfo_1$__constructor__(), this);
                }

                @Override
                public RecentTaskInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_RecentTaskInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public RecentTaskInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_RecentTaskInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__();
        }

        public RecentTaskInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_RecentTaskInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_RecentTaskInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_RecentTaskInfo$readFromParcel(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(parcel);
        }

        public RecentTaskInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ RecentTaskInfo(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_RecentTaskInfo$__constructor__(android.os.Parcel android.app.ActivityManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RecentTaskInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecentTaskInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TaskDescription
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static String ATTR_TASKDESCRIPTION_PREFIX = "task_description_";
        private static String ATTR_TASKDESCRIPTIONLABEL = "task_description_label";
        private static String ATTR_TASKDESCRIPTIONCOLOR_PRIMARY = "task_description_color";
        private static String ATTR_TASKDESCRIPTIONCOLOR_BACKGROUND = "task_description_colorBackground";
        private static String ATTR_TASKDESCRIPTIONICON_FILENAME = "task_description_icon_filename";
        private static String ATTR_TASKDESCRIPTIONICON_RESOURCE = "task_description_icon_resource";
        private String mLabel;
        private Bitmap mIcon;
        private int mIconRes;
        private String mIconFilename;
        private int mColorPrimary;
        private int mColorBackground;
        private int mStatusBarColor;
        private int mNavigationBarColor;
        public static Parcelable.Creator<TaskDescription> CREATOR;

        @Deprecated
        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label, Bitmap icon, int colorPrimary) {
            if (colorPrimary != 0 && Color.alpha(colorPrimary) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label, int iconRes, int colorPrimary) {
            if (colorPrimary != 0 && Color.alpha(colorPrimary) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
        }

        @Deprecated
        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label, Bitmap icon) {
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label, int iconRes) {
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label) {
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__() {
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(String label, Bitmap bitmap, int iconRes, String iconFilename, int colorPrimary, int colorBackground, int statusBarColor, int navigationBarColor) {
            this.mLabel = label;
            this.mIcon = bitmap;
            this.mIconRes = iconRes;
            this.mIconFilename = iconFilename;
            this.mColorPrimary = colorPrimary;
            this.mColorBackground = colorBackground;
            this.mStatusBarColor = statusBarColor;
            this.mNavigationBarColor = navigationBarColor;
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(TaskDescription td) {
            this.copyFrom(td);
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$copyFrom(TaskDescription other) {
            this.mLabel = other.mLabel;
            this.mIcon = other.mIcon;
            this.mIconRes = other.mIconRes;
            this.mIconFilename = other.mIconFilename;
            this.mColorPrimary = other.mColorPrimary;
            this.mColorBackground = other.mColorBackground;
            this.mStatusBarColor = other.mStatusBarColor;
            this.mNavigationBarColor = other.mNavigationBarColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$copyFromPreserveHiddenFields(TaskDescription other) {
            this.mLabel = other.mLabel;
            this.mIcon = other.mIcon;
            this.mIconRes = other.mIconRes;
            this.mIconFilename = other.mIconFilename;
            this.mColorPrimary = other.mColorPrimary;
            if (other.mColorBackground != 0) {
                this.mColorBackground = other.mColorBackground;
            }
            if (other.mStatusBarColor != 0) {
                this.mStatusBarColor = other.mStatusBarColor;
            }
            if (other.mNavigationBarColor != 0) {
                this.mNavigationBarColor = other.mNavigationBarColor;
            }
        }

        private void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(Parcel source) {
            this.readFromParcel(source);
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setLabel(String label) {
            this.mLabel = label;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setPrimaryColor(int primaryColor) {
            if (primaryColor != 0 && Color.alpha(primaryColor) != 255) {
                throw new RuntimeException("A TaskDescription's primary color should be opaque");
            }
            this.mColorPrimary = primaryColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setBackgroundColor(int backgroundColor) {
            if (backgroundColor != 0 && Color.alpha(backgroundColor) != 255) {
                throw new RuntimeException("A TaskDescription's background color should be opaque");
            }
            this.mColorBackground = backgroundColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setStatusBarColor(int statusBarColor) {
            this.mStatusBarColor = statusBarColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setNavigationBarColor(int navigationBarColor) {
            this.mNavigationBarColor = navigationBarColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setIcon(Bitmap icon) {
            this.mIcon = icon;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setIcon(int iconRes) {
            this.mIconRes = iconRes;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$setIconFilename(String iconFilename) {
            this.mIconFilename = iconFilename;
            this.mIcon = null;
        }

        private final String $$robo$$android_app_ActivityManager_TaskDescription$getLabel() {
            return this.mLabel;
        }

        private final Bitmap $$robo$$android_app_ActivityManager_TaskDescription$getIcon() {
            if (this.mIcon != null) {
                return this.mIcon;
            }
            return TaskDescription.loadTaskDescriptionIcon(this.mIconFilename, UserHandle.myUserId());
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$getIconResource() {
            return this.mIconRes;
        }

        private final String $$robo$$android_app_ActivityManager_TaskDescription$getIconFilename() {
            return this.mIconFilename;
        }

        private final Bitmap $$robo$$android_app_ActivityManager_TaskDescription$getInMemoryIcon() {
            return this.mIcon;
        }

        private static final Bitmap $$robo$$android_app_ActivityManager_TaskDescription$loadTaskDescriptionIcon(String iconFilename, int userId) {
            if (iconFilename != null) {
                try {
                    return ActivityManager.getService().getTaskDescriptionIcon(iconFilename, userId);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            return null;
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$getPrimaryColor() {
            return this.mColorPrimary;
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$getBackgroundColor() {
            return this.mColorBackground;
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$getStatusBarColor() {
            return this.mStatusBarColor;
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$getNavigationBarColor() {
            return this.mNavigationBarColor;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$saveToXml(XmlSerializer out) throws IOException {
            if (this.mLabel != null) {
                out.attribute(null, "task_description_label", this.mLabel);
            }
            if (this.mColorPrimary != 0) {
                out.attribute(null, "task_description_color", Integer.toHexString(this.mColorPrimary));
            }
            if (this.mColorBackground != 0) {
                out.attribute(null, "task_description_colorBackground", Integer.toHexString(this.mColorBackground));
            }
            if (this.mIconFilename != null) {
                out.attribute(null, "task_description_icon_filename", this.mIconFilename);
            }
            if (this.mIconRes != 0) {
                out.attribute(null, "task_description_icon_resource", Integer.toString(this.mIconRes));
            }
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$restoreFromXml(String attrName, String attrValue) {
            if ("task_description_label".equals(attrName)) {
                this.setLabel(attrValue);
            } else if ("task_description_color".equals(attrName)) {
                this.setPrimaryColor((int)Long.parseLong(attrValue, 16));
            } else if ("task_description_colorBackground".equals(attrName)) {
                this.setBackgroundColor((int)Long.parseLong(attrValue, 16));
            } else if ("task_description_icon_filename".equals(attrName)) {
                this.setIconFilename(attrValue);
            } else if ("task_description_icon_resource".equals(attrName)) {
                this.setIcon(Integer.parseInt(attrValue, 10));
            }
        }

        private final int $$robo$$android_app_ActivityManager_TaskDescription$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$writeToParcel(Parcel dest, int flags) {
            if (this.mLabel == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeString(this.mLabel);
            }
            if (this.mIcon == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                this.mIcon.writeToParcel(dest, 0);
            }
            dest.writeInt(this.mIconRes);
            dest.writeInt(this.mColorPrimary);
            dest.writeInt(this.mColorBackground);
            dest.writeInt(this.mStatusBarColor);
            dest.writeInt(this.mNavigationBarColor);
            if (this.mIconFilename == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeString(this.mIconFilename);
            }
        }

        private final void $$robo$$android_app_ActivityManager_TaskDescription$readFromParcel(Parcel source) {
            this.mLabel = source.readInt() > 0 ? source.readString() : null;
            this.mIcon = source.readInt() > 0 ? Bitmap.CREATOR.createFromParcel(source) : null;
            this.mIconRes = source.readInt();
            this.mColorPrimary = source.readInt();
            this.mColorBackground = source.readInt();
            this.mStatusBarColor = source.readInt();
            this.mNavigationBarColor = source.readInt();
            this.mIconFilename = source.readInt() > 0 ? source.readString() : null;
        }

        private final String $$robo$$android_app_ActivityManager_TaskDescription$toString() {
            return "TaskDescription Label: " + this.mLabel + " Icon: " + this.mIcon + " IconRes: " + this.mIconRes + " IconFilename: " + this.mIconFilename + " colorPrimary: " + this.mColorPrimary + " colorBackground: " + this.mColorBackground + " statusBarColor: " + this.mColorBackground + " navigationBarColor: " + this.mNavigationBarColor;
        }

        private /* synthetic */ void $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TaskDescription>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_ActivityManager_TaskDescription_1$__constructor__() {
                }

                private final TaskDescription $$robo$$android_app_ActivityManager_TaskDescription_1$createFromParcel(Parcel source) {
                    return new TaskDescription(source, null);
                }

                private final TaskDescription[] $$robo$$android_app_ActivityManager_TaskDescription_1$newArray(int size) {
                    return new TaskDescription[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_ActivityManager_TaskDescription_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription_1$__constructor__(), this);
                }

                @Override
                public TaskDescription createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_ActivityManager_TaskDescription_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public TaskDescription[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_ActivityManager_TaskDescription_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(String string2, Bitmap bitmap, int n) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2, bitmap, n);
        }

        public TaskDescription(String string2, Bitmap bitmap, int n) {
            this(string2, bitmap, 0, null, n, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String android.graphics.Bitmap int ), this, string2, bitmap, n);
        }

        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2, n, n2);
        }

        public TaskDescription(String string2, int n, int n2) {
            this(string2, null, n, null, n2, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String int int ), this, string2, n, n2);
        }

        private void __constructor__(String string2, Bitmap bitmap) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2, bitmap);
        }

        public TaskDescription(String string2, Bitmap bitmap) {
            this(string2, bitmap, 0, null, 0, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String android.graphics.Bitmap ), this, string2, bitmap);
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2, n);
        }

        public TaskDescription(String string2, int n) {
            this(string2, null, n, null, 0, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String int ), this, string2, n);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2);
        }

        public TaskDescription(String string2) {
            this(string2, null, 0, null, 0, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String ), this, string2);
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__();
        }

        public TaskDescription() {
            this(null, null, 0, null, 0, 0, 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(), this);
        }

        private void __constructor__(String string2, Bitmap bitmap, int n, String string3, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(string2, bitmap, n, string3, n2, n3, n4, n5);
        }

        public TaskDescription(String string2, Bitmap bitmap, int n, String string3, int n2, int n3, int n4, int n5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(java.lang.String android.graphics.Bitmap int java.lang.String int int int int ), this, string2, bitmap, n, string3, n2, n3, n4, n5);
        }

        private void __constructor__(TaskDescription taskDescription) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(taskDescription);
        }

        public TaskDescription(TaskDescription taskDescription) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(android.app.ActivityManager$TaskDescription ), this, taskDescription);
        }

        public void copyFrom(TaskDescription taskDescription) {
            InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_app_ActivityManager_TaskDescription$copyFrom(android.app.ActivityManager$TaskDescription ), this, taskDescription);
        }

        public void copyFromPreserveHiddenFields(TaskDescription taskDescription) {
            InvokeDynamicSupport.bootstrap("copyFromPreserveHiddenFields", $$robo$$android_app_ActivityManager_TaskDescription$copyFromPreserveHiddenFields(android.app.ActivityManager$TaskDescription ), this, taskDescription);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(parcel);
        }

        public TaskDescription(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(android.os.Parcel ), this, parcel);
        }

        public void setLabel(String string2) {
            InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_app_ActivityManager_TaskDescription$setLabel(java.lang.String ), this, string2);
        }

        public void setPrimaryColor(int n) {
            InvokeDynamicSupport.bootstrap("setPrimaryColor", $$robo$$android_app_ActivityManager_TaskDescription$setPrimaryColor(int ), this, n);
        }

        public void setBackgroundColor(int n) {
            InvokeDynamicSupport.bootstrap("setBackgroundColor", $$robo$$android_app_ActivityManager_TaskDescription$setBackgroundColor(int ), this, n);
        }

        public void setStatusBarColor(int n) {
            InvokeDynamicSupport.bootstrap("setStatusBarColor", $$robo$$android_app_ActivityManager_TaskDescription$setStatusBarColor(int ), this, n);
        }

        public void setNavigationBarColor(int n) {
            InvokeDynamicSupport.bootstrap("setNavigationBarColor", $$robo$$android_app_ActivityManager_TaskDescription$setNavigationBarColor(int ), this, n);
        }

        public void setIcon(Bitmap bitmap) {
            InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_app_ActivityManager_TaskDescription$setIcon(android.graphics.Bitmap ), this, bitmap);
        }

        public void setIcon(int n) {
            InvokeDynamicSupport.bootstrap("setIcon", $$robo$$android_app_ActivityManager_TaskDescription$setIcon(int ), this, n);
        }

        public void setIconFilename(String string2) {
            InvokeDynamicSupport.bootstrap("setIconFilename", $$robo$$android_app_ActivityManager_TaskDescription$setIconFilename(java.lang.String ), this, string2);
        }

        public String getLabel() {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_app_ActivityManager_TaskDescription$getLabel(), this);
        }

        public Bitmap getIcon() {
            return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_app_ActivityManager_TaskDescription$getIcon(), this);
        }

        public int getIconResource() {
            return (int)InvokeDynamicSupport.bootstrap("getIconResource", $$robo$$android_app_ActivityManager_TaskDescription$getIconResource(), this);
        }

        public String getIconFilename() {
            return InvokeDynamicSupport.bootstrap("getIconFilename", $$robo$$android_app_ActivityManager_TaskDescription$getIconFilename(), this);
        }

        public Bitmap getInMemoryIcon() {
            return InvokeDynamicSupport.bootstrap("getInMemoryIcon", $$robo$$android_app_ActivityManager_TaskDescription$getInMemoryIcon(), this);
        }

        public static Bitmap loadTaskDescriptionIcon(String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("loadTaskDescriptionIcon", $$robo$$android_app_ActivityManager_TaskDescription$loadTaskDescriptionIcon(java.lang.String int ), (String)string2, (int)n);
        }

        public int getPrimaryColor() {
            return (int)InvokeDynamicSupport.bootstrap("getPrimaryColor", $$robo$$android_app_ActivityManager_TaskDescription$getPrimaryColor(), this);
        }

        public int getBackgroundColor() {
            return (int)InvokeDynamicSupport.bootstrap("getBackgroundColor", $$robo$$android_app_ActivityManager_TaskDescription$getBackgroundColor(), this);
        }

        public int getStatusBarColor() {
            return (int)InvokeDynamicSupport.bootstrap("getStatusBarColor", $$robo$$android_app_ActivityManager_TaskDescription$getStatusBarColor(), this);
        }

        public int getNavigationBarColor() {
            return (int)InvokeDynamicSupport.bootstrap("getNavigationBarColor", $$robo$$android_app_ActivityManager_TaskDescription$getNavigationBarColor(), this);
        }

        public void saveToXml(XmlSerializer xmlSerializer) throws IOException {
            InvokeDynamicSupport.bootstrap("saveToXml", $$robo$$android_app_ActivityManager_TaskDescription$saveToXml(org.xmlpull.v1.XmlSerializer ), this, xmlSerializer);
        }

        public void restoreFromXml(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("restoreFromXml", $$robo$$android_app_ActivityManager_TaskDescription$restoreFromXml(java.lang.String java.lang.String ), this, string2, string3);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_ActivityManager_TaskDescription$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_ActivityManager_TaskDescription$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_ActivityManager_TaskDescription$readFromParcel(android.os.Parcel ), this, parcel);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_ActivityManager_TaskDescription$toString(), this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_ActivityManager_TaskDescription$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ TaskDescription(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_TaskDescription$__constructor__(android.os.Parcel android.app.ActivityManager$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(TaskDescription.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TaskDescription)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class StackId
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int INVALID_STACK_ID = -1;

        private void $$robo$$android_app_ActivityManager_StackId$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_app_ActivityManager_StackId$__constructor__();
        }

        public StackId() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_StackId$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StackId)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BugreportMode {
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class UidObserver
    extends IUidObserver.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        OnUidImportanceListener mListener;
        Context mContext;

        private void $$robo$$android_app_ActivityManager_UidObserver$__constructor__(OnUidImportanceListener listener, Context clientContext) {
            this.mListener = listener;
            this.mContext = clientContext;
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidStateChanged(int uid, int procState, long procStateSeq) {
            this.mListener.onUidImportance(uid, RunningAppProcessInfo.procStateToImportanceForClient(procState, this.mContext));
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidGone(int uid, boolean disabled) {
            this.mListener.onUidImportance(uid, 1000);
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidActive(int uid) {
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidIdle(int uid, boolean disabled) {
        }

        private final void $$robo$$android_app_ActivityManager_UidObserver$onUidCachedChanged(int uid, boolean cached) {
        }

        private void __constructor__(OnUidImportanceListener onUidImportanceListener, Context context) {
            this.$$robo$$android_app_ActivityManager_UidObserver$__constructor__(onUidImportanceListener, context);
        }

        public UidObserver(OnUidImportanceListener onUidImportanceListener, Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ActivityManager_UidObserver$__constructor__(android.app.ActivityManager$OnUidImportanceListener android.content.Context ), this, onUidImportanceListener, context);
        }

        @Override
        public void onUidStateChanged(int n, int n2, long l) {
            InvokeDynamicSupport.bootstrap("onUidStateChanged", $$robo$$android_app_ActivityManager_UidObserver$onUidStateChanged(int int long ), this, n, n2, l);
        }

        @Override
        public void onUidGone(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onUidGone", $$robo$$android_app_ActivityManager_UidObserver$onUidGone(int boolean ), this, n, bl);
        }

        @Override
        public void onUidActive(int n) {
            InvokeDynamicSupport.bootstrap("onUidActive", $$robo$$android_app_ActivityManager_UidObserver$onUidActive(int ), this, n);
        }

        @Override
        public void onUidIdle(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onUidIdle", $$robo$$android_app_ActivityManager_UidObserver$onUidIdle(int boolean ), this, n, bl);
        }

        @Override
        public void onUidCachedChanged(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onUidCachedChanged", $$robo$$android_app_ActivityManager_UidObserver$onUidCachedChanged(int boolean ), this, n, bl);
        }

        public /* synthetic */ UidObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UidObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

