/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.app.IAlarmCompleteListener;
import android.app.IAlarmListener;
import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import libcore.util.ZoneInfoDB;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AlarmManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "AlarmManager";
    public static int RTC_WAKEUP = 0;
    public static int RTC = 1;
    public static int ELAPSED_REALTIME_WAKEUP = 2;
    public static int ELAPSED_REALTIME = 3;
    public static String ACTION_NEXT_ALARM_CLOCK_CHANGED = "android.app.action.NEXT_ALARM_CLOCK_CHANGED";
    public static long WINDOW_EXACT = 0L;
    public static long WINDOW_HEURISTIC = -1L;
    public static int FLAG_STANDALONE = 1;
    public static int FLAG_WAKE_FROM_IDLE = 2;
    public static int FLAG_ALLOW_WHILE_IDLE = 4;
    public static int FLAG_ALLOW_WHILE_IDLE_UNRESTRICTED = 8;
    public static int FLAG_IDLE_UNTIL = 16;
    private IAlarmManager mService;
    private Context mContext;
    private String mPackageName;
    private boolean mAlwaysExact;
    private int mTargetSdkVersion;
    private Handler mMainThreadHandler;
    private static ArrayMap<OnAlarmListener, ListenerWrapper> sWrappers;
    public static long INTERVAL_FIFTEEN_MINUTES = 900000L;
    public static long INTERVAL_HALF_HOUR = 1800000L;
    public static long INTERVAL_HOUR = 3600000L;
    public static long INTERVAL_HALF_DAY = 43200000L;
    public static long INTERVAL_DAY = 86400000L;

    private void $$robo$$android_app_AlarmManager$__constructor__(IAlarmManager service, Context ctx) {
        this.mService = service;
        this.mContext = ctx;
        this.mPackageName = ctx.getPackageName();
        this.mTargetSdkVersion = ctx.getApplicationInfo().targetSdkVersion;
        this.mAlwaysExact = this.mTargetSdkVersion < 19;
        this.mMainThreadHandler = new Handler(ctx.getMainLooper());
    }

    private final long $$robo$$android_app_AlarmManager$legacyExactLength() {
        return this.mAlwaysExact ? 0L : -1L;
    }

    private final void $$robo$$android_app_AlarmManager$set(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), 0L, 0, operation, null, null, null, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$set(int type, long triggerAtMillis, String tag, OnAlarmListener listener, Handler targetHandler) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), 0L, 0, null, listener, tag, targetHandler, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$setRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, this.legacyExactLength(), intervalMillis, 0, operation, null, null, null, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$setWindow(int type, long windowStartMillis, long windowLengthMillis, PendingIntent operation) {
        this.setImpl(type, windowStartMillis, windowLengthMillis, 0L, 0, operation, null, null, null, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$setWindow(int type, long windowStartMillis, long windowLengthMillis, String tag, OnAlarmListener listener, Handler targetHandler) {
        this.setImpl(type, windowStartMillis, windowLengthMillis, 0L, 0, null, listener, tag, targetHandler, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$setExact(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, 0, operation, null, null, null, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$setExact(int type, long triggerAtMillis, String tag, OnAlarmListener listener, Handler targetHandler) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, 0, null, listener, tag, targetHandler, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$setIdleUntil(int type, long triggerAtMillis, String tag, OnAlarmListener listener, Handler targetHandler) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, 16, null, listener, tag, targetHandler, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$setAlarmClock(AlarmClockInfo info, PendingIntent operation) {
        this.setImpl(0, info.getTriggerTime(), 0L, 0L, 0, operation, null, null, null, null, info);
    }

    @SystemApi
    private final void $$robo$$android_app_AlarmManager$set(int type, long triggerAtMillis, long windowMillis, long intervalMillis, PendingIntent operation, WorkSource workSource) {
        this.setImpl(type, triggerAtMillis, windowMillis, intervalMillis, 0, operation, null, null, null, workSource, null);
    }

    private final void $$robo$$android_app_AlarmManager$set(int type, long triggerAtMillis, long windowMillis, long intervalMillis, String tag, OnAlarmListener listener, Handler targetHandler, WorkSource workSource) {
        this.setImpl(type, triggerAtMillis, windowMillis, intervalMillis, 0, null, listener, tag, targetHandler, workSource, null);
    }

    @SystemApi
    private final void $$robo$$android_app_AlarmManager$set(int type, long triggerAtMillis, long windowMillis, long intervalMillis, OnAlarmListener listener, Handler targetHandler, WorkSource workSource) {
        this.setImpl(type, triggerAtMillis, windowMillis, intervalMillis, 0, null, listener, null, targetHandler, workSource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_app_AlarmManager$setImpl(int type, long triggerAtMillis, long windowMillis, long intervalMillis, int flags, PendingIntent operation, OnAlarmListener listener, String listenerTag, Handler targetHandler, WorkSource workSource, AlarmClockInfo alarmClock) {
        if (triggerAtMillis < 0L) {
            triggerAtMillis = 0L;
        }
        ListenerWrapper recipientWrapper = null;
        if (listener != null) {
            Class<AlarmManager> clazz = AlarmManager.class;
            // MONITORENTER : android.app.AlarmManager.class
            if (sWrappers == null) {
                sWrappers = new ArrayMap();
            }
            if ((recipientWrapper = sWrappers.get(listener)) == null) {
                recipientWrapper = new ListenerWrapper(this, listener);
                sWrappers.put(listener, recipientWrapper);
            }
            // MONITOREXIT : clazz
            Handler handler = targetHandler != null ? targetHandler : this.mMainThreadHandler;
            recipientWrapper.setHandler(handler);
        }
        try {
            this.mService.set(this.mPackageName, type, triggerAtMillis, windowMillis, intervalMillis, flags, operation, recipientWrapper, listenerTag, workSource, alarmClock);
            return;
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AlarmManager$setInexactRepeating(int type, long triggerAtMillis, long intervalMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, -1L, intervalMillis, 0, operation, null, null, null, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$setAndAllowWhileIdle(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, -1L, 0L, 4, operation, null, null, null, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$setExactAndAllowWhileIdle(int type, long triggerAtMillis, PendingIntent operation) {
        this.setImpl(type, triggerAtMillis, 0L, 0L, 4, operation, null, null, null, null, null);
    }

    private final void $$robo$$android_app_AlarmManager$cancel(PendingIntent operation) {
        if (operation == null) {
            String msg = "cancel() called with a null PendingIntent";
            if (this.mTargetSdkVersion >= 24) {
                throw new NullPointerException("cancel() called with a null PendingIntent");
            }
            Log.e("AlarmManager", "cancel() called with a null PendingIntent");
            return;
        }
        try {
            this.mService.remove(operation, null);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_AlarmManager$cancel(OnAlarmListener listener) {
        if (listener == null) {
            throw new NullPointerException("cancel() called with a null OnAlarmListener");
        }
        ListenerWrapper wrapper = null;
        Class<AlarmManager> clazz = AlarmManager.class;
        synchronized (AlarmManager.class) {
            if (sWrappers != null) {
                wrapper = sWrappers.get(listener);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (wrapper == null) {
                Log.w("AlarmManager", "Unrecognized alarm listener " + listener);
                return;
            }
            wrapper.cancel();
            return;
        }
    }

    private final void $$robo$$android_app_AlarmManager$setTime(long millis) {
        try {
            this.mService.setTime(millis);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_AlarmManager$setTimeZone(String timeZone) {
        if (TextUtils.isEmpty(timeZone)) {
            return;
        }
        if (this.mTargetSdkVersion >= 23) {
            boolean hasTimeZone = false;
            try {
                hasTimeZone = ZoneInfoDB.getInstance().hasTimeZone(timeZone);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!hasTimeZone) {
                throw new IllegalArgumentException("Timezone: " + timeZone + " is not an Olson ID");
            }
        }
        try {
            this.mService.setTimeZone(timeZone);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final long $$robo$$android_app_AlarmManager$getNextWakeFromIdleTime() {
        try {
            return this.mService.getNextWakeFromIdleTime();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final AlarmClockInfo $$robo$$android_app_AlarmManager$getNextAlarmClock() {
        return this.getNextAlarmClock(this.mContext.getUserId());
    }

    private final AlarmClockInfo $$robo$$android_app_AlarmManager$getNextAlarmClock(int userId) {
        try {
            return this.mService.getNextAlarmClock(userId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private void __constructor__(IAlarmManager iAlarmManager, Context context) {
        this.$$robo$$android_app_AlarmManager$__constructor__(iAlarmManager, context);
    }

    public AlarmManager(IAlarmManager iAlarmManager, Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AlarmManager$__constructor__(android.app.IAlarmManager android.content.Context ), this, iAlarmManager, context);
    }

    private long legacyExactLength() {
        return (long)InvokeDynamicSupport.bootstrap("legacyExactLength", $$robo$$android_app_AlarmManager$legacyExactLength(), this);
    }

    public void set(int n, long l, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_app_AlarmManager$set(int long android.app.PendingIntent ), this, n, l, pendingIntent);
    }

    public void set(int n, long l, String string2, OnAlarmListener onAlarmListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_app_AlarmManager$set(int long java.lang.String android.app.AlarmManager$OnAlarmListener android.os.Handler ), this, n, l, string2, onAlarmListener, handler);
    }

    public void setRepeating(int n, long l, long l2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setRepeating", $$robo$$android_app_AlarmManager$setRepeating(int long long android.app.PendingIntent ), this, n, l, l2, pendingIntent);
    }

    public void setWindow(int n, long l, long l2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setWindow", $$robo$$android_app_AlarmManager$setWindow(int long long android.app.PendingIntent ), this, n, l, l2, pendingIntent);
    }

    public void setWindow(int n, long l, long l2, String string2, OnAlarmListener onAlarmListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setWindow", $$robo$$android_app_AlarmManager$setWindow(int long long java.lang.String android.app.AlarmManager$OnAlarmListener android.os.Handler ), this, n, l, l2, string2, onAlarmListener, handler);
    }

    public void setExact(int n, long l, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setExact", $$robo$$android_app_AlarmManager$setExact(int long android.app.PendingIntent ), this, n, l, pendingIntent);
    }

    public void setExact(int n, long l, String string2, OnAlarmListener onAlarmListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setExact", $$robo$$android_app_AlarmManager$setExact(int long java.lang.String android.app.AlarmManager$OnAlarmListener android.os.Handler ), this, n, l, string2, onAlarmListener, handler);
    }

    public void setIdleUntil(int n, long l, String string2, OnAlarmListener onAlarmListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("setIdleUntil", $$robo$$android_app_AlarmManager$setIdleUntil(int long java.lang.String android.app.AlarmManager$OnAlarmListener android.os.Handler ), this, n, l, string2, onAlarmListener, handler);
    }

    public void setAlarmClock(AlarmClockInfo alarmClockInfo, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setAlarmClock", $$robo$$android_app_AlarmManager$setAlarmClock(android.app.AlarmManager$AlarmClockInfo android.app.PendingIntent ), this, alarmClockInfo, pendingIntent);
    }

    @SystemApi
    public void set(int n, long l, long l2, long l3, PendingIntent pendingIntent, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_app_AlarmManager$set(int long long long android.app.PendingIntent android.os.WorkSource ), this, n, l, l2, l3, pendingIntent, workSource);
    }

    public void set(int n, long l, long l2, long l3, String string2, OnAlarmListener onAlarmListener, Handler handler, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_app_AlarmManager$set(int long long long java.lang.String android.app.AlarmManager$OnAlarmListener android.os.Handler android.os.WorkSource ), this, n, l, l2, l3, string2, onAlarmListener, handler, workSource);
    }

    @SystemApi
    public void set(int n, long l, long l2, long l3, OnAlarmListener onAlarmListener, Handler handler, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_app_AlarmManager$set(int long long long android.app.AlarmManager$OnAlarmListener android.os.Handler android.os.WorkSource ), this, n, l, l2, l3, onAlarmListener, handler, workSource);
    }

    private void setImpl(int n, long l, long l2, long l3, int n2, PendingIntent pendingIntent, OnAlarmListener onAlarmListener, String string2, Handler handler, WorkSource workSource, AlarmClockInfo alarmClockInfo) {
        InvokeDynamicSupport.bootstrap("setImpl", $$robo$$android_app_AlarmManager$setImpl(int long long long int android.app.PendingIntent android.app.AlarmManager$OnAlarmListener java.lang.String android.os.Handler android.os.WorkSource android.app.AlarmManager$AlarmClockInfo ), this, n, l, l2, l3, n2, pendingIntent, onAlarmListener, string2, handler, workSource, alarmClockInfo);
    }

    public void setInexactRepeating(int n, long l, long l2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setInexactRepeating", $$robo$$android_app_AlarmManager$setInexactRepeating(int long long android.app.PendingIntent ), this, n, l, l2, pendingIntent);
    }

    public void setAndAllowWhileIdle(int n, long l, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setAndAllowWhileIdle", $$robo$$android_app_AlarmManager$setAndAllowWhileIdle(int long android.app.PendingIntent ), this, n, l, pendingIntent);
    }

    public void setExactAndAllowWhileIdle(int n, long l, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setExactAndAllowWhileIdle", $$robo$$android_app_AlarmManager$setExactAndAllowWhileIdle(int long android.app.PendingIntent ), this, n, l, pendingIntent);
    }

    public void cancel(PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_AlarmManager$cancel(android.app.PendingIntent ), this, pendingIntent);
    }

    public void cancel(OnAlarmListener onAlarmListener) {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_AlarmManager$cancel(android.app.AlarmManager$OnAlarmListener ), this, onAlarmListener);
    }

    public void setTime(long l) {
        InvokeDynamicSupport.bootstrap("setTime", $$robo$$android_app_AlarmManager$setTime(long ), this, l);
    }

    public void setTimeZone(String string2) {
        InvokeDynamicSupport.bootstrap("setTimeZone", $$robo$$android_app_AlarmManager$setTimeZone(java.lang.String ), this, string2);
    }

    public long getNextWakeFromIdleTime() {
        return (long)InvokeDynamicSupport.bootstrap("getNextWakeFromIdleTime", $$robo$$android_app_AlarmManager$getNextWakeFromIdleTime(), this);
    }

    public AlarmClockInfo getNextAlarmClock() {
        return InvokeDynamicSupport.bootstrap("getNextAlarmClock", $$robo$$android_app_AlarmManager$getNextAlarmClock(), this);
    }

    public AlarmClockInfo getNextAlarmClock(int n) {
        return InvokeDynamicSupport.bootstrap("getNextAlarmClock", $$robo$$android_app_AlarmManager$getNextAlarmClock(int ), this, n);
    }

    public /* synthetic */ AlarmManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlarmManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class AlarmClockInfo
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long mTriggerTime;
        private PendingIntent mShowIntent;
        public static Parcelable.Creator<AlarmClockInfo> CREATOR;

        private void $$robo$$android_app_AlarmManager_AlarmClockInfo$__constructor__(long triggerTime, PendingIntent showIntent) {
            this.mTriggerTime = triggerTime;
            this.mShowIntent = showIntent;
        }

        private void $$robo$$android_app_AlarmManager_AlarmClockInfo$__constructor__(Parcel in) {
            this.mTriggerTime = in.readLong();
            this.mShowIntent = (PendingIntent)in.readParcelable(PendingIntent.class.getClassLoader());
        }

        private final long $$robo$$android_app_AlarmManager_AlarmClockInfo$getTriggerTime() {
            return this.mTriggerTime;
        }

        private final PendingIntent $$robo$$android_app_AlarmManager_AlarmClockInfo$getShowIntent() {
            return this.mShowIntent;
        }

        private final int $$robo$$android_app_AlarmManager_AlarmClockInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_AlarmManager_AlarmClockInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.mTriggerTime);
            dest.writeParcelable(this.mShowIntent, flags);
        }

        private final void $$robo$$android_app_AlarmManager_AlarmClockInfo$writeToProto(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10300000001L, this.mTriggerTime);
            this.mShowIntent.writeToProto(proto, 1146756268034L);
            proto.end(token);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<AlarmClockInfo>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_AlarmManager_AlarmClockInfo_1$__constructor__() {
                }

                private final AlarmClockInfo $$robo$$android_app_AlarmManager_AlarmClockInfo_1$createFromParcel(Parcel in) {
                    return new AlarmClockInfo(in);
                }

                private final AlarmClockInfo[] $$robo$$android_app_AlarmManager_AlarmClockInfo_1$newArray(int size) {
                    return new AlarmClockInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_AlarmManager_AlarmClockInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AlarmManager_AlarmClockInfo_1$__constructor__(), this);
                }

                @Override
                public AlarmClockInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_AlarmManager_AlarmClockInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public AlarmClockInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_AlarmManager_AlarmClockInfo_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(long l, PendingIntent pendingIntent) {
            this.$$robo$$android_app_AlarmManager_AlarmClockInfo$__constructor__(l, pendingIntent);
        }

        public AlarmClockInfo(long l, PendingIntent pendingIntent) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AlarmManager_AlarmClockInfo$__constructor__(long android.app.PendingIntent ), this, l, pendingIntent);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_AlarmManager_AlarmClockInfo$__constructor__(parcel);
        }

        public AlarmClockInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AlarmManager_AlarmClockInfo$__constructor__(android.os.Parcel ), this, parcel);
        }

        public long getTriggerTime() {
            return (long)InvokeDynamicSupport.bootstrap("getTriggerTime", $$robo$$android_app_AlarmManager_AlarmClockInfo$getTriggerTime(), this);
        }

        public PendingIntent getShowIntent() {
            return InvokeDynamicSupport.bootstrap("getShowIntent", $$robo$$android_app_AlarmManager_AlarmClockInfo$getShowIntent(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_AlarmManager_AlarmClockInfo$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_AlarmManager_AlarmClockInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
            InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_app_AlarmManager_AlarmClockInfo$writeToProto(android.util.proto.ProtoOutputStream long ), this, protoOutputStream, l);
        }

        static {
            RobolectricInternals.classInitializing(AlarmClockInfo.class);
        }

        public /* synthetic */ AlarmClockInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlarmClockInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class ListenerWrapper
    extends IAlarmListener.Stub
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        OnAlarmListener mListener;
        Handler mHandler;
        IAlarmCompleteListener mCompletion;
        /* synthetic */ AlarmManager this$0;

        private void $$robo$$android_app_AlarmManager_ListenerWrapper$__constructor__(AlarmManager this$0, OnAlarmListener listener) {
            this.this$0 = this$0;
            this.mListener = listener;
        }

        private final void $$robo$$android_app_AlarmManager_ListenerWrapper$setHandler(Handler h) {
            this.mHandler = h;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_AlarmManager_ListenerWrapper$cancel() {
            try {
                this.this$0.mService.remove(null, this);
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
            Class<AlarmManager> clazz = AlarmManager.class;
            synchronized (AlarmManager.class) {
                if (sWrappers != null) {
                    sWrappers.remove(this.mListener);
                }
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_app_AlarmManager_ListenerWrapper$doAlarm(IAlarmCompleteListener alarmManager) {
            this.mCompletion = alarmManager;
            Class<AlarmManager> clazz = AlarmManager.class;
            synchronized (AlarmManager.class) {
                if (sWrappers != null) {
                    sWrappers.remove(this.mListener);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.mHandler.post(this);
                return;
            }
        }

        private final void $$robo$$android_app_AlarmManager_ListenerWrapper$run() {
            try {
                this.mListener.onAlarm();
            }
            finally {
                try {
                    this.mCompletion.alarmComplete(this);
                }
                catch (Exception e) {
                    Log.e("AlarmManager", "Unable to report completion to Alarm Manager!", e);
                }
            }
        }

        private void __constructor__(AlarmManager alarmManager, OnAlarmListener onAlarmListener) {
            this.$$robo$$android_app_AlarmManager_ListenerWrapper$__constructor__(alarmManager, onAlarmListener);
        }

        public ListenerWrapper(AlarmManager alarmManager, OnAlarmListener onAlarmListener) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_AlarmManager_ListenerWrapper$__constructor__(android.app.AlarmManager android.app.AlarmManager$OnAlarmListener ), this, alarmManager, onAlarmListener);
        }

        public void setHandler(Handler handler) {
            InvokeDynamicSupport.bootstrap("setHandler", $$robo$$android_app_AlarmManager_ListenerWrapper$setHandler(android.os.Handler ), this, handler);
        }

        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_app_AlarmManager_ListenerWrapper$cancel(), this);
        }

        @Override
        public void doAlarm(IAlarmCompleteListener iAlarmCompleteListener) {
            InvokeDynamicSupport.bootstrap("doAlarm", $$robo$$android_app_AlarmManager_ListenerWrapper$doAlarm(android.app.IAlarmCompleteListener ), this, iAlarmCompleteListener);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_AlarmManager_ListenerWrapper$run(), this);
        }

        public /* synthetic */ ListenerWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenerWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnAlarmListener {
        public void onAlarm();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlarmType {
    }
}

