/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.SystemApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.net.Uri;
import android.os.Environment;
import android.os.FileUtils;
import android.os.ParcelFileDescriptor;
import android.provider.Downloads;
import android.provider.MediaStore;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DownloadManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String COLUMN_ID = "_id";
    public static String COLUMN_TITLE = "title";
    public static String COLUMN_DESCRIPTION = "description";
    public static String COLUMN_URI = "uri";
    public static String COLUMN_MEDIA_TYPE = "media_type";
    public static String COLUMN_TOTAL_SIZE_BYTES = "total_size";
    public static String COLUMN_LOCAL_URI = "local_uri";
    @Deprecated
    public static String COLUMN_LOCAL_FILENAME = "local_filename";
    public static String COLUMN_STATUS = "status";
    public static String COLUMN_REASON = "reason";
    public static String COLUMN_BYTES_DOWNLOADED_SO_FAR = "bytes_so_far";
    public static String COLUMN_LAST_MODIFIED_TIMESTAMP = "last_modified_timestamp";
    public static String COLUMN_MEDIAPROVIDER_URI = "mediaprovider_uri";
    public static String COLUMN_ALLOW_WRITE = "allow_write";
    public static int STATUS_PENDING = 1;
    public static int STATUS_RUNNING = 2;
    public static int STATUS_PAUSED = 4;
    public static int STATUS_SUCCESSFUL = 8;
    public static int STATUS_FAILED = 16;
    public static int ERROR_UNKNOWN = 1000;
    public static int ERROR_FILE_ERROR = 1001;
    public static int ERROR_UNHANDLED_HTTP_CODE = 1002;
    public static int ERROR_HTTP_DATA_ERROR = 1004;
    public static int ERROR_TOO_MANY_REDIRECTS = 1005;
    public static int ERROR_INSUFFICIENT_SPACE = 1006;
    public static int ERROR_DEVICE_NOT_FOUND = 1007;
    public static int ERROR_CANNOT_RESUME = 1008;
    public static int ERROR_FILE_ALREADY_EXISTS = 1009;
    public static int ERROR_BLOCKED = 1010;
    public static int PAUSED_WAITING_TO_RETRY = 1;
    public static int PAUSED_WAITING_FOR_NETWORK = 2;
    public static int PAUSED_QUEUED_FOR_WIFI = 3;
    public static int PAUSED_UNKNOWN = 4;
    public static String ACTION_DOWNLOAD_COMPLETE = "android.intent.action.DOWNLOAD_COMPLETE";
    public static String ACTION_NOTIFICATION_CLICKED = "android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED";
    public static String ACTION_VIEW_DOWNLOADS = "android.intent.action.VIEW_DOWNLOADS";
    public static String INTENT_EXTRAS_SORT_BY_SIZE = "android.app.DownloadManager.extra_sortBySize";
    public static String EXTRA_DOWNLOAD_ID = "extra_download_id";
    public static String EXTRA_NOTIFICATION_CLICK_DOWNLOAD_IDS = "extra_click_download_ids";
    @SystemApi
    public static String ACTION_DOWNLOAD_COMPLETED = "android.intent.action.DOWNLOAD_COMPLETED";
    public static String[] UNDERLYING_COLUMNS;
    private ContentResolver mResolver;
    private String mPackageName;
    private Uri mBaseUri;
    private boolean mAccessFilename;
    private static String NON_DOWNLOADMANAGER_DOWNLOAD = "non-dwnldmngr-download-dont-retry2download";
    static /* synthetic */ boolean $assertionsDisabled;

    private void $$robo$$android_app_DownloadManager$__constructor__(Context context) {
        this.mBaseUri = Downloads.Impl.CONTENT_URI;
        this.mResolver = context.getContentResolver();
        this.mPackageName = context.getPackageName();
        this.mAccessFilename = context.getApplicationInfo().targetSdkVersion < 24;
    }

    private final void $$robo$$android_app_DownloadManager$setAccessAllDownloads(boolean accessAllDownloads) {
        this.mBaseUri = accessAllDownloads ? Downloads.Impl.ALL_DOWNLOADS_CONTENT_URI : Downloads.Impl.CONTENT_URI;
    }

    private final void $$robo$$android_app_DownloadManager$setAccessFilename(boolean accessFilename) {
        this.mAccessFilename = accessFilename;
    }

    private final long $$robo$$android_app_DownloadManager$enqueue(Request request) {
        ContentValues values = request.toContentValues(this.mPackageName);
        Uri downloadUri = this.mResolver.insert(Downloads.Impl.CONTENT_URI, values);
        long id2 = Long.parseLong(downloadUri.getLastPathSegment());
        return id2;
    }

    private final int $$robo$$android_app_DownloadManager$markRowDeleted(long ... ids) {
        if (ids == null || ids.length == 0) {
            throw new IllegalArgumentException("input param 'ids' can't be null");
        }
        return this.mResolver.delete(this.mBaseUri, DownloadManager.getWhereClauseForIds(ids), DownloadManager.getWhereArgsForIds(ids));
    }

    private final int $$robo$$android_app_DownloadManager$remove(long ... ids) {
        return this.markRowDeleted(ids);
    }

    private final Cursor $$robo$$android_app_DownloadManager$query(Query query) {
        Cursor underlyingCursor = query.runQuery(this.mResolver, UNDERLYING_COLUMNS, this.mBaseUri);
        if (underlyingCursor == null) {
            return null;
        }
        return new CursorTranslator(underlyingCursor, this.mBaseUri, this.mAccessFilename);
    }

    private final ParcelFileDescriptor $$robo$$android_app_DownloadManager$openDownloadedFile(long id2) throws FileNotFoundException {
        return this.mResolver.openFileDescriptor(this.getDownloadUri(id2), "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Uri $$robo$$android_app_DownloadManager$getUriForDownloadedFile(long id2) {
        Query query = new Query().setFilterById(id2);
        try (Cursor cursor = null;){
            int status;
            cursor = this.query(query);
            if (cursor == null) {
                Uri uri = null;
                return uri;
            }
            if (cursor.moveToFirst() && 8 == (status = cursor.getInt(cursor.getColumnIndexOrThrow("status")))) {
                Uri uri = ContentUris.withAppendedId(Downloads.Impl.ALL_DOWNLOADS_CONTENT_URI, id2);
                return uri;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_app_DownloadManager$getMimeTypeForDownloadedFile(long id2) {
        Query query = new Query().setFilterById(id2);
        try (Cursor cursor = null;){
            cursor = this.query(query);
            if (cursor == null) {
                String string2 = null;
                return string2;
            }
            if (cursor.moveToFirst()) {
                String string3 = cursor.getString(cursor.getColumnIndexOrThrow("media_type"));
                return string3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_DownloadManager$restartDownload(long ... ids) {
        try (Cursor cursor = this.query(new Query().setFilterById(ids));){
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                int status = cursor.getInt(cursor.getColumnIndex("status"));
                if (status != 8 && status != 16) {
                    throw new IllegalArgumentException("Cannot restart incomplete download: " + cursor.getLong(cursor.getColumnIndex("_id")));
                }
                cursor.moveToNext();
            }
        }
        ContentValues values = new ContentValues();
        values.put("current_bytes", 0);
        values.put("total_bytes", -1);
        values.putNull("_data");
        values.put("status", 190);
        values.put("numfailed", 0);
        this.mResolver.update(this.mBaseUri, values, DownloadManager.getWhereClauseForIds(ids), DownloadManager.getWhereArgsForIds(ids));
    }

    private final void $$robo$$android_app_DownloadManager$forceDownload(long ... ids) {
        ContentValues values = new ContentValues();
        values.put("status", 190);
        values.put("control", 0);
        values.put("bypass_recommended_size_limit", 1);
        this.mResolver.update(this.mBaseUri, values, DownloadManager.getWhereClauseForIds(ids), DownloadManager.getWhereArgsForIds(ids));
    }

    private static final Long $$robo$$android_app_DownloadManager$getMaxBytesOverMobile(Context context) {
        try {
            return Settings.Global.getLong(context.getContentResolver(), "download_manager_max_bytes_over_mobile");
        }
        catch (Settings.SettingNotFoundException exc) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_DownloadManager$rename(Context context, long id2, String displayName) {
        if (!FileUtils.isValidFatFilename(displayName)) {
            throw new SecurityException(displayName + " is not a valid filename");
        }
        Query query = new Query().setFilterById(id2);
        Cursor cursor = null;
        String oldDisplayName = null;
        String mimeType = null;
        try {
            cursor = this.query(query);
            if (cursor == null) {
                boolean bl = false;
                return bl;
            }
            if (cursor.moveToFirst()) {
                int status = cursor.getInt(cursor.getColumnIndexOrThrow("status"));
                if (8 != status) {
                    boolean bl = false;
                    return bl;
                }
                oldDisplayName = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                mimeType = cursor.getString(cursor.getColumnIndexOrThrow("media_type"));
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (oldDisplayName == null || mimeType == null) {
            throw new IllegalStateException("Document with id " + id2 + " does not exist");
        }
        File parent = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOWNLOADS);
        File before = new File(parent, oldDisplayName);
        File after = new File(parent, displayName);
        if (after.exists()) {
            throw new IllegalStateException("Already exists " + after);
        }
        if (!before.renameTo(after)) {
            throw new IllegalStateException("Failed to rename to " + after);
        }
        if (mimeType.startsWith("image/")) {
            context.getContentResolver().delete(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "_data=?", new String[]{before.getAbsolutePath()});
            Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            intent.setData(Uri.fromFile(after));
            context.sendBroadcast(intent);
        }
        ContentValues values = new ContentValues();
        values.put("title", displayName);
        values.put("_data", after.toString());
        values.putNull("mediaprovider_uri");
        long[] ids = new long[]{id2};
        return this.mResolver.update(this.mBaseUri, values, DownloadManager.getWhereClauseForIds(ids), DownloadManager.getWhereArgsForIds(ids)) == 1;
    }

    private static final Long $$robo$$android_app_DownloadManager$getRecommendedMaxBytesOverMobile(Context context) {
        try {
            return Settings.Global.getLong(context.getContentResolver(), "download_manager_recommended_max_bytes_over_mobile");
        }
        catch (Settings.SettingNotFoundException exc) {
            return null;
        }
    }

    private static final boolean $$robo$$android_app_DownloadManager$isActiveNetworkExpensive(Context context) {
        return false;
    }

    private static final long $$robo$$android_app_DownloadManager$getActiveNetworkWarningBytes(Context context) {
        return -1L;
    }

    private final long $$robo$$android_app_DownloadManager$addCompletedDownload(String title, String description, boolean isMediaScannerScannable, String mimeType, String path, long length, boolean showNotification) {
        return this.addCompletedDownload(title, description, isMediaScannerScannable, mimeType, path, length, showNotification, false, null, null);
    }

    private final long $$robo$$android_app_DownloadManager$addCompletedDownload(String title, String description, boolean isMediaScannerScannable, String mimeType, String path, long length, boolean showNotification, Uri uri, Uri referer) {
        return this.addCompletedDownload(title, description, isMediaScannerScannable, mimeType, path, length, showNotification, false, uri, referer);
    }

    private final long $$robo$$android_app_DownloadManager$addCompletedDownload(String title, String description, boolean isMediaScannerScannable, String mimeType, String path, long length, boolean showNotification, boolean allowWrite) {
        return this.addCompletedDownload(title, description, isMediaScannerScannable, mimeType, path, length, showNotification, allowWrite, null, null);
    }

    private final long $$robo$$android_app_DownloadManager$addCompletedDownload(String title, String description, boolean isMediaScannerScannable, String mimeType, String path, long length, boolean showNotification, boolean allowWrite, Uri uri, Uri referer) {
        DownloadManager.validateArgumentIsNonEmpty("title", title);
        DownloadManager.validateArgumentIsNonEmpty("description", description);
        DownloadManager.validateArgumentIsNonEmpty("path", path);
        DownloadManager.validateArgumentIsNonEmpty("mimeType", mimeType);
        if (length < 0L) {
            throw new IllegalArgumentException(" invalid value for param: totalBytes");
        }
        Request request = uri != null ? new Request(uri) : new Request("non-dwnldmngr-download-dont-retry2download");
        request.setTitle(title).setDescription(description).setMimeType(mimeType);
        if (referer != null) {
            request.addRequestHeader("Referer", referer.toString());
        }
        ContentValues values = request.toContentValues(null);
        values.put("destination", 6);
        values.put("_data", path);
        values.put("status", 200);
        values.put("total_bytes", length);
        values.put("scanned", isMediaScannerScannable ? 0 : 2);
        values.put("visibility", showNotification ? 3 : 2);
        values.put("allow_write", allowWrite ? 1 : 0);
        Uri downloadUri = this.mResolver.insert(Downloads.Impl.CONTENT_URI, values);
        if (downloadUri == null) {
            return -1L;
        }
        return Long.parseLong(downloadUri.getLastPathSegment());
    }

    private static final void $$robo$$android_app_DownloadManager$validateArgumentIsNonEmpty(String paramName, String val) {
        if (TextUtils.isEmpty(val)) {
            throw new IllegalArgumentException(paramName + " can't be null");
        }
    }

    private final Uri $$robo$$android_app_DownloadManager$getDownloadUri(long id2) {
        return ContentUris.withAppendedId(Downloads.Impl.ALL_DOWNLOADS_CONTENT_URI, id2);
    }

    private static final String $$robo$$android_app_DownloadManager$getWhereClauseForIds(long[] ids) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("(");
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                whereClause.append("OR ");
            }
            whereClause.append("_id");
            whereClause.append(" = ? ");
        }
        whereClause.append(")");
        return whereClause.toString();
    }

    private static final String[] $$robo$$android_app_DownloadManager$getWhereArgsForIds(long[] ids) {
        String[] whereArgs = new String[ids.length];
        return DownloadManager.getWhereArgsForIds(ids, whereArgs);
    }

    private static final String[] $$robo$$android_app_DownloadManager$getWhereArgsForIds(long[] ids, String[] args) {
        if (!$assertionsDisabled && args.length < ids.length) {
            throw new AssertionError();
        }
        for (int i = 0; i < ids.length; ++i) {
            args[i] = Long.toString(ids[i]);
        }
        return args;
    }

    static void __staticInitializer__() {
        $assertionsDisabled = !DownloadManager.class.desiredAssertionStatus();
        UNDERLYING_COLUMNS = new String[]{"_id", "_data AS local_filename", "mediaprovider_uri", "destination", "title", "description", "uri", "status", "hint", "mimetype AS media_type", "total_bytes AS total_size", "lastmod AS last_modified_timestamp", "current_bytes AS bytes_so_far", "allow_write", "'placeholder' AS local_uri", "'placeholder' AS reason"};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_DownloadManager$__constructor__(context);
    }

    public DownloadManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_DownloadManager$__constructor__(android.content.Context ), this, context);
    }

    public void setAccessAllDownloads(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAccessAllDownloads", $$robo$$android_app_DownloadManager$setAccessAllDownloads(boolean ), this, bl);
    }

    public void setAccessFilename(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAccessFilename", $$robo$$android_app_DownloadManager$setAccessFilename(boolean ), this, bl);
    }

    public long enqueue(Request request) {
        return (long)InvokeDynamicSupport.bootstrap("enqueue", $$robo$$android_app_DownloadManager$enqueue(android.app.DownloadManager$Request ), this, request);
    }

    public int markRowDeleted(long ... lArray) {
        return (int)InvokeDynamicSupport.bootstrap("markRowDeleted", $$robo$$android_app_DownloadManager$markRowDeleted(long[] ), this, lArray);
    }

    public int remove(long ... lArray) {
        return (int)InvokeDynamicSupport.bootstrap("remove", $$robo$$android_app_DownloadManager$remove(long[] ), this, lArray);
    }

    public Cursor query(Query query) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_app_DownloadManager$query(android.app.DownloadManager$Query ), this, query);
    }

    public ParcelFileDescriptor openDownloadedFile(long l) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openDownloadedFile", $$robo$$android_app_DownloadManager$openDownloadedFile(long ), this, l);
    }

    public Uri getUriForDownloadedFile(long l) {
        return InvokeDynamicSupport.bootstrap("getUriForDownloadedFile", $$robo$$android_app_DownloadManager$getUriForDownloadedFile(long ), this, l);
    }

    public String getMimeTypeForDownloadedFile(long l) {
        return InvokeDynamicSupport.bootstrap("getMimeTypeForDownloadedFile", $$robo$$android_app_DownloadManager$getMimeTypeForDownloadedFile(long ), this, l);
    }

    public void restartDownload(long ... lArray) {
        InvokeDynamicSupport.bootstrap("restartDownload", $$robo$$android_app_DownloadManager$restartDownload(long[] ), this, lArray);
    }

    public void forceDownload(long ... lArray) {
        InvokeDynamicSupport.bootstrap("forceDownload", $$robo$$android_app_DownloadManager$forceDownload(long[] ), this, lArray);
    }

    public static Long getMaxBytesOverMobile(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getMaxBytesOverMobile", $$robo$$android_app_DownloadManager$getMaxBytesOverMobile(android.content.Context ), (Context)context);
    }

    public boolean rename(Context context, long l, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("rename", $$robo$$android_app_DownloadManager$rename(android.content.Context long java.lang.String ), this, context, l, string2);
    }

    public static Long getRecommendedMaxBytesOverMobile(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getRecommendedMaxBytesOverMobile", $$robo$$android_app_DownloadManager$getRecommendedMaxBytesOverMobile(android.content.Context ), (Context)context);
    }

    public static boolean isActiveNetworkExpensive(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isActiveNetworkExpensive", $$robo$$android_app_DownloadManager$isActiveNetworkExpensive(android.content.Context ), (Context)context);
    }

    public static long getActiveNetworkWarningBytes(Context context) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getActiveNetworkWarningBytes", $$robo$$android_app_DownloadManager$getActiveNetworkWarningBytes(android.content.Context ), (Context)context);
    }

    public long addCompletedDownload(String string2, String string3, boolean bl, String string4, String string5, long l, boolean bl2) {
        return (long)InvokeDynamicSupport.bootstrap("addCompletedDownload", $$robo$$android_app_DownloadManager$addCompletedDownload(java.lang.String java.lang.String boolean java.lang.String java.lang.String long boolean ), this, string2, string3, bl, string4, string5, l, bl2);
    }

    public long addCompletedDownload(String string2, String string3, boolean bl, String string4, String string5, long l, boolean bl2, Uri uri, Uri uri2) {
        return (long)InvokeDynamicSupport.bootstrap("addCompletedDownload", $$robo$$android_app_DownloadManager$addCompletedDownload(java.lang.String java.lang.String boolean java.lang.String java.lang.String long boolean android.net.Uri android.net.Uri ), this, string2, string3, bl, string4, string5, l, bl2, uri, uri2);
    }

    public long addCompletedDownload(String string2, String string3, boolean bl, String string4, String string5, long l, boolean bl2, boolean bl3) {
        return (long)InvokeDynamicSupport.bootstrap("addCompletedDownload", $$robo$$android_app_DownloadManager$addCompletedDownload(java.lang.String java.lang.String boolean java.lang.String java.lang.String long boolean boolean ), this, string2, string3, bl, string4, string5, l, bl2, bl3);
    }

    public long addCompletedDownload(String string2, String string3, boolean bl, String string4, String string5, long l, boolean bl2, boolean bl3, Uri uri, Uri uri2) {
        return (long)InvokeDynamicSupport.bootstrap("addCompletedDownload", $$robo$$android_app_DownloadManager$addCompletedDownload(java.lang.String java.lang.String boolean java.lang.String java.lang.String long boolean boolean android.net.Uri android.net.Uri ), this, string2, string3, bl, string4, string5, l, bl2, bl3, uri, uri2);
    }

    private static void validateArgumentIsNonEmpty(String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("validateArgumentIsNonEmpty", $$robo$$android_app_DownloadManager$validateArgumentIsNonEmpty(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    public Uri getDownloadUri(long l) {
        return InvokeDynamicSupport.bootstrap("getDownloadUri", $$robo$$android_app_DownloadManager$getDownloadUri(long ), this, l);
    }

    static String getWhereClauseForIds(long[] lArray) {
        return InvokeDynamicSupport.bootstrapStatic("getWhereClauseForIds", $$robo$$android_app_DownloadManager$getWhereClauseForIds(long[] ), (long[])lArray);
    }

    static String[] getWhereArgsForIds(long[] lArray) {
        return InvokeDynamicSupport.bootstrapStatic("getWhereArgsForIds", $$robo$$android_app_DownloadManager$getWhereArgsForIds(long[] ), (long[])lArray);
    }

    static String[] getWhereArgsForIds(long[] lArray, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("getWhereArgsForIds", $$robo$$android_app_DownloadManager$getWhereArgsForIds(long[] java.lang.String[] ), (long[])lArray, (String[])stringArray);
    }

    static {
        RobolectricInternals.classInitializing(DownloadManager.class);
    }

    public /* synthetic */ DownloadManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DownloadManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CursorTranslator
    extends CursorWrapper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Uri mBaseUri;
        private boolean mAccessFilename;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_app_DownloadManager_CursorTranslator$__constructor__(Cursor cursor, Uri baseUri, boolean accessFilename) {
            this.mBaseUri = baseUri;
            this.mAccessFilename = accessFilename;
        }

        private final int $$robo$$android_app_DownloadManager_CursorTranslator$getInt(int columnIndex) {
            return (int)this.getLong(columnIndex);
        }

        private final long $$robo$$android_app_DownloadManager_CursorTranslator$getLong(int columnIndex) {
            if (this.getColumnName(columnIndex).equals("reason")) {
                return this.getReason(super.getInt(this.getColumnIndex("status")));
            }
            if (this.getColumnName(columnIndex).equals("status")) {
                return this.translateStatus(super.getInt(this.getColumnIndex("status")));
            }
            return super.getLong(columnIndex);
        }

        private final String $$robo$$android_app_DownloadManager_CursorTranslator$getString(int columnIndex) {
            String columnName;
            switch (columnName = this.getColumnName(columnIndex)) {
                case "local_uri": {
                    return this.getLocalUri();
                }
                case "local_filename": {
                    if (this.mAccessFilename) break;
                    throw new SecurityException("COLUMN_LOCAL_FILENAME is deprecated; use ContentResolver.openFileDescriptor() instead");
                }
            }
            return super.getString(columnIndex);
        }

        private final String $$robo$$android_app_DownloadManager_CursorTranslator$getLocalUri() {
            long destinationType = this.getLong(this.getColumnIndex("destination"));
            if (destinationType == 4L || destinationType == 0L || destinationType == 6L) {
                String localPath = super.getString(this.getColumnIndex("local_filename"));
                if (localPath == null) {
                    return null;
                }
                return Uri.fromFile(new File(localPath)).toString();
            }
            long downloadId = this.getLong(this.getColumnIndex("_id"));
            return ContentUris.withAppendedId(Downloads.Impl.ALL_DOWNLOADS_CONTENT_URI, downloadId).toString();
        }

        private final long $$robo$$android_app_DownloadManager_CursorTranslator$getReason(int status) {
            switch (this.translateStatus(status)) {
                case 16: {
                    return this.getErrorCode(status);
                }
                case 4: {
                    return this.getPausedReason(status);
                }
            }
            return 0L;
        }

        private final long $$robo$$android_app_DownloadManager_CursorTranslator$getPausedReason(int status) {
            switch (status) {
                case 194: {
                    return 1L;
                }
                case 195: {
                    return 2L;
                }
                case 196: {
                    return 3L;
                }
            }
            return 4L;
        }

        private final long $$robo$$android_app_DownloadManager_CursorTranslator$getErrorCode(int status) {
            if (400 <= status && status < 488 || 500 <= status && status < 600) {
                return status;
            }
            switch (status) {
                case 492: {
                    return 1001L;
                }
                case 493: 
                case 494: {
                    return 1002L;
                }
                case 495: {
                    return 1004L;
                }
                case 497: {
                    return 1005L;
                }
                case 198: {
                    return 1006L;
                }
                case 199: {
                    return 1007L;
                }
                case 489: {
                    return 1008L;
                }
                case 488: {
                    return 1009L;
                }
            }
            return 1000L;
        }

        private final int $$robo$$android_app_DownloadManager_CursorTranslator$translateStatus(int status) {
            switch (status) {
                case 190: {
                    return 1;
                }
                case 192: {
                    return 2;
                }
                case 193: 
                case 194: 
                case 195: 
                case 196: {
                    return 4;
                }
                case 200: {
                    return 8;
                }
            }
            if (!$assertionsDisabled && !Downloads.Impl.isStatusError(status)) {
                throw new AssertionError();
            }
            return 16;
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !DownloadManager.class.desiredAssertionStatus();
        }

        private void __constructor__(Cursor cursor, Uri uri, boolean bl) {
            this.$$robo$$android_app_DownloadManager_CursorTranslator$__constructor__(cursor, uri, bl);
        }

        public CursorTranslator(Cursor cursor, Uri uri, boolean bl) {
            super(cursor);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_DownloadManager_CursorTranslator$__constructor__(android.database.Cursor android.net.Uri boolean ), this, cursor, uri, bl);
        }

        @Override
        public int getInt(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_app_DownloadManager_CursorTranslator$getInt(int ), this, n);
        }

        @Override
        public long getLong(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$android_app_DownloadManager_CursorTranslator$getLong(int ), this, n);
        }

        @Override
        public String getString(int n) {
            return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_app_DownloadManager_CursorTranslator$getString(int ), this, n);
        }

        private String getLocalUri() {
            return InvokeDynamicSupport.bootstrap("getLocalUri", $$robo$$android_app_DownloadManager_CursorTranslator$getLocalUri(), this);
        }

        private long getReason(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getReason", $$robo$$android_app_DownloadManager_CursorTranslator$getReason(int ), this, n);
        }

        private long getPausedReason(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getPausedReason", $$robo$$android_app_DownloadManager_CursorTranslator$getPausedReason(int ), this, n);
        }

        private long getErrorCode(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getErrorCode", $$robo$$android_app_DownloadManager_CursorTranslator$getErrorCode(int ), this, n);
        }

        private int translateStatus(int n) {
            return (int)InvokeDynamicSupport.bootstrap("translateStatus", $$robo$$android_app_DownloadManager_CursorTranslator$translateStatus(int ), this, n);
        }

        static {
            RobolectricInternals.classInitializing(CursorTranslator.class);
        }

        public /* synthetic */ CursorTranslator() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CursorTranslator)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Query
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int ORDER_ASCENDING = 1;
        public static int ORDER_DESCENDING = 2;
        private long[] mIds;
        private Integer mStatusFlags;
        private String mFilterString;
        private String mOrderByColumn;
        private int mOrderDirection;
        private boolean mOnlyIncludeVisibleInDownloadsUi;

        private void $$robo$$android_app_DownloadManager_Query$__constructor__() {
            this.mIds = null;
            this.mStatusFlags = null;
            this.mFilterString = null;
            this.mOrderByColumn = "lastmod";
            this.mOrderDirection = 2;
            this.mOnlyIncludeVisibleInDownloadsUi = false;
        }

        private final Query $$robo$$android_app_DownloadManager_Query$setFilterById(long ... ids) {
            this.mIds = ids;
            return this;
        }

        private final Query $$robo$$android_app_DownloadManager_Query$setFilterByString(String filter) {
            this.mFilterString = filter;
            return this;
        }

        private final Query $$robo$$android_app_DownloadManager_Query$setFilterByStatus(int flags) {
            this.mStatusFlags = flags;
            return this;
        }

        private final Query $$robo$$android_app_DownloadManager_Query$setOnlyIncludeVisibleInDownloadsUi(boolean value) {
            this.mOnlyIncludeVisibleInDownloadsUi = value;
            return this;
        }

        private final Query $$robo$$android_app_DownloadManager_Query$orderBy(String column, int direction) {
            if (direction != 1 && direction != 2) {
                throw new IllegalArgumentException("Invalid direction: " + direction);
            }
            if (column.equals("last_modified_timestamp")) {
                this.mOrderByColumn = "lastmod";
            } else if (column.equals("total_size")) {
                this.mOrderByColumn = "total_bytes";
            } else {
                throw new IllegalArgumentException("Cannot order by " + column);
            }
            this.mOrderDirection = direction;
            return this;
        }

        private final Cursor $$robo$$android_app_DownloadManager_Query$runQuery(ContentResolver resolver, String[] projection, Uri baseUri) {
            Uri uri = baseUri;
            ArrayList<String> selectionParts = new ArrayList<String>();
            String[] selectionArgs = null;
            int whereArgsCount = this.mIds == null ? 0 : this.mIds.length;
            whereArgsCount = this.mFilterString == null ? whereArgsCount : whereArgsCount + 1;
            selectionArgs = new String[whereArgsCount];
            if (whereArgsCount > 0) {
                if (this.mIds != null) {
                    selectionParts.add(DownloadManager.getWhereClauseForIds(this.mIds));
                    DownloadManager.getWhereArgsForIds(this.mIds, selectionArgs);
                }
                if (this.mFilterString != null) {
                    selectionParts.add("title LIKE ?");
                    selectionArgs[selectionArgs.length - 1] = "%" + this.mFilterString + "%";
                }
            }
            if (this.mStatusFlags != null) {
                ArrayList<String> parts = new ArrayList<String>();
                if ((this.mStatusFlags & 1) != 0) {
                    parts.add(this.statusClause("=", 190));
                }
                if ((this.mStatusFlags & 2) != 0) {
                    parts.add(this.statusClause("=", 192));
                }
                if ((this.mStatusFlags & 4) != 0) {
                    parts.add(this.statusClause("=", 193));
                    parts.add(this.statusClause("=", 194));
                    parts.add(this.statusClause("=", 195));
                    parts.add(this.statusClause("=", 196));
                }
                if ((this.mStatusFlags & 8) != 0) {
                    parts.add(this.statusClause("=", 200));
                }
                if ((this.mStatusFlags & 0x10) != 0) {
                    parts.add("(" + this.statusClause(">=", 400) + " AND " + this.statusClause("<", 600) + ")");
                }
                selectionParts.add(this.joinStrings(" OR ", parts));
            }
            if (this.mOnlyIncludeVisibleInDownloadsUi) {
                selectionParts.add("is_visible_in_downloads_ui != '0'");
            }
            selectionParts.add("deleted != '1'");
            String selection = this.joinStrings(" AND ", selectionParts);
            String orderDirection = this.mOrderDirection == 1 ? "ASC" : "DESC";
            String orderBy = this.mOrderByColumn + " " + orderDirection;
            return resolver.query(uri, projection, selection, selectionArgs, orderBy);
        }

        private final String $$robo$$android_app_DownloadManager_Query$joinStrings(String joiner, Iterable<String> parts) {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String part : parts) {
                if (!first) {
                    builder.append(joiner);
                }
                builder.append(part);
                first = false;
            }
            return builder.toString();
        }

        private final String $$robo$$android_app_DownloadManager_Query$statusClause(String operator, int value) {
            return "status" + operator + "'" + value + "'";
        }

        private void __constructor__() {
            this.$$robo$$android_app_DownloadManager_Query$__constructor__();
        }

        public Query() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_DownloadManager_Query$__constructor__(), this);
        }

        public Query setFilterById(long ... lArray) {
            return InvokeDynamicSupport.bootstrap("setFilterById", $$robo$$android_app_DownloadManager_Query$setFilterById(long[] ), this, lArray);
        }

        public Query setFilterByString(String string2) {
            return InvokeDynamicSupport.bootstrap("setFilterByString", $$robo$$android_app_DownloadManager_Query$setFilterByString(java.lang.String ), this, string2);
        }

        public Query setFilterByStatus(int n) {
            return InvokeDynamicSupport.bootstrap("setFilterByStatus", $$robo$$android_app_DownloadManager_Query$setFilterByStatus(int ), this, n);
        }

        public Query setOnlyIncludeVisibleInDownloadsUi(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setOnlyIncludeVisibleInDownloadsUi", $$robo$$android_app_DownloadManager_Query$setOnlyIncludeVisibleInDownloadsUi(boolean ), this, bl);
        }

        public Query orderBy(String string2, int n) {
            return InvokeDynamicSupport.bootstrap("orderBy", $$robo$$android_app_DownloadManager_Query$orderBy(java.lang.String int ), this, string2, n);
        }

        Cursor runQuery(ContentResolver contentResolver, String[] stringArray, Uri uri) {
            return InvokeDynamicSupport.bootstrap("runQuery", $$robo$$android_app_DownloadManager_Query$runQuery(android.content.ContentResolver java.lang.String[] android.net.Uri ), this, contentResolver, stringArray, uri);
        }

        private String joinStrings(String string2, Iterable<String> iterable) {
            return InvokeDynamicSupport.bootstrap("joinStrings", $$robo$$android_app_DownloadManager_Query$joinStrings(java.lang.String java.lang.Iterable<java.lang.String> ), this, string2, iterable);
        }

        private String statusClause(String string2, int n) {
            return InvokeDynamicSupport.bootstrap("statusClause", $$robo$$android_app_DownloadManager_Query$statusClause(java.lang.String int ), this, string2, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Query)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Request
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int NETWORK_MOBILE = 1;
        public static int NETWORK_WIFI = 2;
        @Deprecated
        public static int NETWORK_BLUETOOTH = 4;
        private Uri mUri;
        private Uri mDestinationUri;
        private List<Pair<String, String>> mRequestHeaders;
        private CharSequence mTitle;
        private CharSequence mDescription;
        private String mMimeType;
        private int mAllowedNetworkTypes;
        private boolean mRoamingAllowed;
        private boolean mMeteredAllowed;
        private int mFlags;
        private boolean mIsVisibleInDownloadsUi;
        private boolean mScannable;
        private static int SCANNABLE_VALUE_YES = 0;
        private static int SCANNABLE_VALUE_NO = 2;
        public static int VISIBILITY_VISIBLE = 0;
        public static int VISIBILITY_VISIBLE_NOTIFY_COMPLETED = 1;
        public static int VISIBILITY_HIDDEN = 2;
        public static int VISIBILITY_VISIBLE_NOTIFY_ONLY_COMPLETION = 3;
        private int mNotificationVisibility;
        static /* synthetic */ boolean $assertionsDisabled;

        private void $$robo$$android_app_DownloadManager_Request$__constructor__(Uri uri) {
            this.mRequestHeaders = new ArrayList<Pair<String, String>>();
            this.mAllowedNetworkTypes = -1;
            this.mRoamingAllowed = true;
            this.mMeteredAllowed = true;
            this.mFlags = 0;
            this.mIsVisibleInDownloadsUi = true;
            this.mScannable = false;
            this.mNotificationVisibility = 0;
            if (uri == null) {
                throw new NullPointerException();
            }
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equals("http") && !scheme.equals("https")) {
                throw new IllegalArgumentException("Can only download HTTP/HTTPS URIs: " + uri);
            }
            this.mUri = uri;
        }

        private void $$robo$$android_app_DownloadManager_Request$__constructor__(String uriString) {
            this.mRequestHeaders = new ArrayList<Pair<String, String>>();
            this.mAllowedNetworkTypes = -1;
            this.mRoamingAllowed = true;
            this.mMeteredAllowed = true;
            this.mFlags = 0;
            this.mIsVisibleInDownloadsUi = true;
            this.mScannable = false;
            this.mNotificationVisibility = 0;
            this.mUri = Uri.parse(uriString);
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setDestinationUri(Uri uri) {
            this.mDestinationUri = uri;
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setDestinationInExternalFilesDir(Context context, String dirType, String subPath) {
            File file = context.getExternalFilesDir(dirType);
            if (file == null) {
                throw new IllegalStateException("Failed to get external storage files directory");
            }
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalStateException(file.getAbsolutePath() + " already exists and is not a directory");
                }
            } else if (!file.mkdirs()) {
                throw new IllegalStateException("Unable to create directory: " + file.getAbsolutePath());
            }
            this.setDestinationFromBase(file, subPath);
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setDestinationInExternalPublicDir(String dirType, String subPath) {
            File file = Environment.getExternalStoragePublicDirectory(dirType);
            if (file == null) {
                throw new IllegalStateException("Failed to get external storage public directory");
            }
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalStateException(file.getAbsolutePath() + " already exists and is not a directory");
                }
            } else if (!file.mkdirs()) {
                throw new IllegalStateException("Unable to create directory: " + file.getAbsolutePath());
            }
            this.setDestinationFromBase(file, subPath);
            return this;
        }

        private final void $$robo$$android_app_DownloadManager_Request$setDestinationFromBase(File base, String subPath) {
            if (subPath == null) {
                throw new NullPointerException("subPath cannot be null");
            }
            this.mDestinationUri = Uri.withAppendedPath(Uri.fromFile(base), subPath);
        }

        private final void $$robo$$android_app_DownloadManager_Request$allowScanningByMediaScanner() {
            this.mScannable = true;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$addRequestHeader(String header, String value) {
            if (header == null) {
                throw new NullPointerException("header cannot be null");
            }
            if (header.contains(":")) {
                throw new IllegalArgumentException("header may not contain ':'");
            }
            if (value == null) {
                value = "";
            }
            this.mRequestHeaders.add(Pair.create(header, value));
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setDescription(CharSequence description) {
            this.mDescription = description;
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setMimeType(String mimeType) {
            this.mMimeType = mimeType;
            return this;
        }

        @Deprecated
        private final Request $$robo$$android_app_DownloadManager_Request$setShowRunningNotification(boolean show) {
            return show ? this.setNotificationVisibility(0) : this.setNotificationVisibility(2);
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setNotificationVisibility(int visibility) {
            this.mNotificationVisibility = visibility;
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setAllowedNetworkTypes(int flags) {
            this.mAllowedNetworkTypes = flags;
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setAllowedOverRoaming(boolean allowed) {
            this.mRoamingAllowed = allowed;
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setAllowedOverMetered(boolean allow) {
            this.mMeteredAllowed = allow;
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setRequiresCharging(boolean requiresCharging) {
            this.mFlags = requiresCharging ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setRequiresDeviceIdle(boolean requiresDeviceIdle) {
            this.mFlags = requiresDeviceIdle ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
            return this;
        }

        private final Request $$robo$$android_app_DownloadManager_Request$setVisibleInDownloadsUi(boolean isVisible) {
            this.mIsVisibleInDownloadsUi = isVisible;
            return this;
        }

        private final ContentValues $$robo$$android_app_DownloadManager_Request$toContentValues(String packageName) {
            ContentValues values = new ContentValues();
            if (!$assertionsDisabled && this.mUri == null) {
                throw new AssertionError();
            }
            values.put("uri", this.mUri.toString());
            values.put("is_public_api", true);
            values.put("notificationpackage", packageName);
            if (this.mDestinationUri != null) {
                values.put("destination", 4);
                values.put("hint", this.mDestinationUri.toString());
            } else {
                values.put("destination", 2);
            }
            values.put("scanned", this.mScannable ? 0 : 2);
            if (!this.mRequestHeaders.isEmpty()) {
                this.encodeHttpHeaders(values);
            }
            this.putIfNonNull(values, "title", this.mTitle);
            this.putIfNonNull(values, "description", this.mDescription);
            this.putIfNonNull(values, "mimetype", this.mMimeType);
            values.put("visibility", this.mNotificationVisibility);
            values.put("allowed_network_types", this.mAllowedNetworkTypes);
            values.put("allow_roaming", this.mRoamingAllowed);
            values.put("allow_metered", this.mMeteredAllowed);
            values.put("flags", this.mFlags);
            values.put("is_visible_in_downloads_ui", this.mIsVisibleInDownloadsUi);
            return values;
        }

        private final void $$robo$$android_app_DownloadManager_Request$encodeHttpHeaders(ContentValues values) {
            int index = 0;
            for (Pair<String, String> header : this.mRequestHeaders) {
                String headerString = (String)header.first + ": " + (String)header.second;
                values.put("http_header_" + index, headerString);
                ++index;
            }
        }

        private final void $$robo$$android_app_DownloadManager_Request$putIfNonNull(ContentValues contentValues, String key, Object value) {
            if (value != null) {
                contentValues.put(key, value.toString());
            }
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !DownloadManager.class.desiredAssertionStatus();
        }

        private void __constructor__(Uri uri) {
            this.$$robo$$android_app_DownloadManager_Request$__constructor__(uri);
        }

        public Request(Uri uri) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_DownloadManager_Request$__constructor__(android.net.Uri ), this, uri);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_app_DownloadManager_Request$__constructor__(string2);
        }

        public Request(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_DownloadManager_Request$__constructor__(java.lang.String ), this, string2);
        }

        public Request setDestinationUri(Uri uri) {
            return InvokeDynamicSupport.bootstrap("setDestinationUri", $$robo$$android_app_DownloadManager_Request$setDestinationUri(android.net.Uri ), this, uri);
        }

        public Request setDestinationInExternalFilesDir(Context context, String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("setDestinationInExternalFilesDir", $$robo$$android_app_DownloadManager_Request$setDestinationInExternalFilesDir(android.content.Context java.lang.String java.lang.String ), this, context, string2, string3);
        }

        public Request setDestinationInExternalPublicDir(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("setDestinationInExternalPublicDir", $$robo$$android_app_DownloadManager_Request$setDestinationInExternalPublicDir(java.lang.String java.lang.String ), this, string2, string3);
        }

        private void setDestinationFromBase(File file, String string2) {
            InvokeDynamicSupport.bootstrap("setDestinationFromBase", $$robo$$android_app_DownloadManager_Request$setDestinationFromBase(java.io.File java.lang.String ), this, file, string2);
        }

        public void allowScanningByMediaScanner() {
            InvokeDynamicSupport.bootstrap("allowScanningByMediaScanner", $$robo$$android_app_DownloadManager_Request$allowScanningByMediaScanner(), this);
        }

        public Request addRequestHeader(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("addRequestHeader", $$robo$$android_app_DownloadManager_Request$addRequestHeader(java.lang.String java.lang.String ), this, string2, string3);
        }

        public Request setTitle(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_app_DownloadManager_Request$setTitle(java.lang.CharSequence ), this, charSequence);
        }

        public Request setDescription(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setDescription", $$robo$$android_app_DownloadManager_Request$setDescription(java.lang.CharSequence ), this, charSequence);
        }

        public Request setMimeType(String string2) {
            return InvokeDynamicSupport.bootstrap("setMimeType", $$robo$$android_app_DownloadManager_Request$setMimeType(java.lang.String ), this, string2);
        }

        @Deprecated
        public Request setShowRunningNotification(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setShowRunningNotification", $$robo$$android_app_DownloadManager_Request$setShowRunningNotification(boolean ), this, bl);
        }

        public Request setNotificationVisibility(int n) {
            return InvokeDynamicSupport.bootstrap("setNotificationVisibility", $$robo$$android_app_DownloadManager_Request$setNotificationVisibility(int ), this, n);
        }

        public Request setAllowedNetworkTypes(int n) {
            return InvokeDynamicSupport.bootstrap("setAllowedNetworkTypes", $$robo$$android_app_DownloadManager_Request$setAllowedNetworkTypes(int ), this, n);
        }

        public Request setAllowedOverRoaming(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setAllowedOverRoaming", $$robo$$android_app_DownloadManager_Request$setAllowedOverRoaming(boolean ), this, bl);
        }

        public Request setAllowedOverMetered(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setAllowedOverMetered", $$robo$$android_app_DownloadManager_Request$setAllowedOverMetered(boolean ), this, bl);
        }

        public Request setRequiresCharging(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setRequiresCharging", $$robo$$android_app_DownloadManager_Request$setRequiresCharging(boolean ), this, bl);
        }

        public Request setRequiresDeviceIdle(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setRequiresDeviceIdle", $$robo$$android_app_DownloadManager_Request$setRequiresDeviceIdle(boolean ), this, bl);
        }

        public Request setVisibleInDownloadsUi(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setVisibleInDownloadsUi", $$robo$$android_app_DownloadManager_Request$setVisibleInDownloadsUi(boolean ), this, bl);
        }

        ContentValues toContentValues(String string2) {
            return InvokeDynamicSupport.bootstrap("toContentValues", $$robo$$android_app_DownloadManager_Request$toContentValues(java.lang.String ), this, string2);
        }

        private void encodeHttpHeaders(ContentValues contentValues) {
            InvokeDynamicSupport.bootstrap("encodeHttpHeaders", $$robo$$android_app_DownloadManager_Request$encodeHttpHeaders(android.content.ContentValues ), this, contentValues);
        }

        private void putIfNonNull(ContentValues contentValues, String string2, Object object) {
            InvokeDynamicSupport.bootstrap("putIfNonNull", $$robo$$android_app_DownloadManager_Request$putIfNonNull(android.content.ContentValues java.lang.String java.lang.Object ), this, contentValues, string2, object);
        }

        static {
            RobolectricInternals.classInitializing(Request.class);
        }

        public /* synthetic */ Request() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Request)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

