/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.BackStackRecord;
import android.app.Fragment;
import android.app.FragmentManagerImpl;
import android.app.SharedElementCallback;
import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.ArrayMap;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.OneShotPreDrawListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FragmentTransition
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int[] INVERSE_OPS;

    private void $$robo$$android_app_FragmentTransition$__constructor__() {
    }

    private static final void $$robo$$android_app_FragmentTransition$startTransitions(FragmentManagerImpl fragmentManager, ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex, boolean isReordered) {
        if (fragmentManager.mCurState < 1) {
            return;
        }
        SparseArray<FragmentContainerTransition> transitioningFragments = new SparseArray<FragmentContainerTransition>();
        for (int i = startIndex; i < endIndex; ++i) {
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            if (isPop) {
                FragmentTransition.calculatePopFragments(record, transitioningFragments, isReordered);
                continue;
            }
            FragmentTransition.calculateFragments(record, transitioningFragments, isReordered);
        }
        if (transitioningFragments.size() != 0) {
            View nonExistentView = new View(fragmentManager.mHost.getContext());
            int numContainers = transitioningFragments.size();
            for (int i = 0; i < numContainers; ++i) {
                int containerId = transitioningFragments.keyAt(i);
                ArrayMap<String, String> nameOverrides = FragmentTransition.calculateNameOverrides(containerId, records, isRecordPop, startIndex, endIndex);
                FragmentContainerTransition containerTransition = transitioningFragments.valueAt(i);
                if (isReordered) {
                    FragmentTransition.configureTransitionsReordered(fragmentManager, containerId, containerTransition, nonExistentView, nameOverrides);
                    continue;
                }
                FragmentTransition.configureTransitionsOrdered(fragmentManager, containerId, containerTransition, nonExistentView, nameOverrides);
            }
        }
    }

    private static final ArrayMap<String, String> $$robo$$android_app_FragmentTransition$calculateNameOverrides(int containerId, ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        ArrayMap<String, String> nameOverrides = new ArrayMap<String, String>();
        for (int recordNum = endIndex - 1; recordNum >= startIndex; --recordNum) {
            ArrayList<String> sources;
            ArrayList<String> targets;
            BackStackRecord record = records.get(recordNum);
            if (!record.interactsWith(containerId)) continue;
            boolean isPop = isRecordPop.get(recordNum);
            if (record.mSharedElementSourceNames == null) continue;
            int numSharedElements = record.mSharedElementSourceNames.size();
            if (isPop) {
                targets = record.mSharedElementSourceNames;
                sources = record.mSharedElementTargetNames;
            } else {
                sources = record.mSharedElementSourceNames;
                targets = record.mSharedElementTargetNames;
            }
            for (int i = 0; i < numSharedElements; ++i) {
                String sourceName = sources.get(i);
                String targetName = targets.get(i);
                String previousTarget = nameOverrides.remove(targetName);
                if (previousTarget != null) {
                    nameOverrides.put(sourceName, previousTarget);
                    continue;
                }
                nameOverrides.put(sourceName, targetName);
            }
        }
        return nameOverrides;
    }

    private static final void $$robo$$android_app_FragmentTransition$configureTransitionsReordered(FragmentManagerImpl fragmentManager, int containerId, FragmentContainerTransition fragments, View nonExistentView, ArrayMap<String, String> nameOverrides) {
        ViewGroup sceneRoot = null;
        if (fragmentManager.mContainer.onHasView()) {
            sceneRoot = (ViewGroup)fragmentManager.mContainer.onFindViewById(containerId);
        }
        if (sceneRoot == null) {
            return;
        }
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        boolean inIsPop = fragments.lastInIsPop;
        boolean outIsPop = fragments.firstOutIsPop;
        ArrayList<View> sharedElementsIn = new ArrayList<View>();
        ArrayList<View> sharedElementsOut = new ArrayList<View>();
        Transition enterTransition = FragmentTransition.getEnterTransition(inFragment, inIsPop);
        Transition exitTransition = FragmentTransition.getExitTransition(outFragment, outIsPop);
        TransitionSet sharedElementTransition = FragmentTransition.configureSharedElementsReordered(sceneRoot, nonExistentView, nameOverrides, fragments, sharedElementsOut, sharedElementsIn, enterTransition, exitTransition);
        if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
            return;
        }
        ArrayList<View> exitingViews = FragmentTransition.configureEnteringExitingViews(exitTransition, outFragment, sharedElementsOut, nonExistentView);
        ArrayList<View> enteringViews = FragmentTransition.configureEnteringExitingViews(enterTransition, inFragment, sharedElementsIn, nonExistentView);
        FragmentTransition.setViewVisibility(enteringViews, 4);
        Transition transition2 = FragmentTransition.mergeTransitions(enterTransition, exitTransition, sharedElementTransition, inFragment, inIsPop);
        if (transition2 != null) {
            FragmentTransition.replaceHide(exitTransition, outFragment, exitingViews);
            transition2.setNameOverrides(nameOverrides);
            FragmentTransition.scheduleRemoveTargets(transition2, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementsIn);
            TransitionManager.beginDelayedTransition(sceneRoot, transition2);
            FragmentTransition.setViewVisibility(enteringViews, 0);
            if (sharedElementTransition != null) {
                sharedElementTransition.getTargets().clear();
                sharedElementTransition.getTargets().addAll(sharedElementsIn);
                FragmentTransition.replaceTargets(sharedElementTransition, sharedElementsOut, sharedElementsIn);
            }
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$configureTransitionsOrdered(FragmentManagerImpl fragmentManager, int containerId, FragmentContainerTransition fragments, View nonExistentView, ArrayMap<String, String> nameOverrides) {
        Transition transition2;
        ViewGroup sceneRoot = null;
        if (fragmentManager.mContainer.onHasView()) {
            sceneRoot = (ViewGroup)fragmentManager.mContainer.onFindViewById(containerId);
        }
        if (sceneRoot == null) {
            return;
        }
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        boolean inIsPop = fragments.lastInIsPop;
        boolean outIsPop = fragments.firstOutIsPop;
        Transition enterTransition = FragmentTransition.getEnterTransition(inFragment, inIsPop);
        Transition exitTransition = FragmentTransition.getExitTransition(outFragment, outIsPop);
        ArrayList<View> sharedElementsOut = new ArrayList<View>();
        ArrayList<View> sharedElementsIn = new ArrayList<View>();
        TransitionSet sharedElementTransition = FragmentTransition.configureSharedElementsOrdered(sceneRoot, nonExistentView, nameOverrides, fragments, sharedElementsOut, sharedElementsIn, enterTransition, exitTransition);
        if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
            return;
        }
        ArrayList<View> exitingViews = FragmentTransition.configureEnteringExitingViews(exitTransition, outFragment, sharedElementsOut, nonExistentView);
        if (exitingViews == null || exitingViews.isEmpty()) {
            exitTransition = null;
        }
        if (enterTransition != null) {
            enterTransition.addTarget(nonExistentView);
        }
        if ((transition2 = FragmentTransition.mergeTransitions(enterTransition, exitTransition, sharedElementTransition, inFragment, fragments.lastInIsPop)) != null) {
            transition2.setNameOverrides(nameOverrides);
            ArrayList<View> enteringViews = new ArrayList<View>();
            FragmentTransition.scheduleRemoveTargets(transition2, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementsIn);
            FragmentTransition.scheduleTargetChange(sceneRoot, inFragment, nonExistentView, sharedElementsIn, enterTransition, enteringViews, exitTransition, exitingViews);
            TransitionManager.beginDelayedTransition(sceneRoot, transition2);
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$replaceHide(Transition exitTransition, Fragment exitingFragment, ArrayList<View> exitingViews) {
        if (exitingFragment != null && exitTransition != null && exitingFragment.mAdded && exitingFragment.mHidden && exitingFragment.mHiddenChanged) {
            exitingFragment.setHideReplaced(true);
            View fragmentView = exitingFragment.getView();
            OneShotPreDrawListener.add(exitingFragment.mContainer, () -> FragmentTransition.setViewVisibility(exitingViews, 4));
            exitTransition.addListener((Transition.TransitionListener)new ShadowedObject(fragmentView, exitingViews){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ View val$fragmentView;
                /* synthetic */ ArrayList val$exitingViews;

                private void $$robo$$android_app_FragmentTransition_1$__constructor__(View view, ArrayList arrayList) {
                    this.val$fragmentView = view;
                    this.val$exitingViews = arrayList;
                }

                private final void $$robo$$android_app_FragmentTransition_1$onTransitionEnd(Transition transition2) {
                    transition2.removeListener(this);
                    this.val$fragmentView.setVisibility(8);
                    FragmentTransition.setViewVisibility(this.val$exitingViews, 0);
                }

                private void __constructor__(View view, ArrayList arrayList) {
                    this.$$robo$$android_app_FragmentTransition_1$__constructor__(view, arrayList);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_FragmentTransition_1$__constructor__(android.view.View java.util.ArrayList ), this, view, arrayList);
                }

                @Override
                public void onTransitionEnd(Transition transition2) {
                    InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_app_FragmentTransition_1$onTransitionEnd(android.transition.Transition ), this, transition2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$scheduleTargetChange(ViewGroup sceneRoot, Fragment inFragment, View nonExistentView, ArrayList<View> sharedElementsIn, Transition enterTransition, ArrayList<View> enteringViews, Transition exitTransition, ArrayList<View> exitingViews) {
        OneShotPreDrawListener.add(sceneRoot, () -> {
            if (enterTransition != null) {
                enterTransition.removeTarget(nonExistentView);
                ArrayList<View> views = FragmentTransition.configureEnteringExitingViews(enterTransition, inFragment, sharedElementsIn, nonExistentView);
                enteringViews.addAll(views);
            }
            if (exitingViews != null) {
                if (exitTransition != null) {
                    ArrayList<View> tempExiting = new ArrayList<View>();
                    tempExiting.add(nonExistentView);
                    FragmentTransition.replaceTargets(exitTransition, exitingViews, tempExiting);
                }
                exitingViews.clear();
                exitingViews.add(nonExistentView);
            }
        });
    }

    private static final TransitionSet $$robo$$android_app_FragmentTransition$getSharedElementTransition(Fragment inFragment, Fragment outFragment, boolean isPop) {
        if (inFragment == null || outFragment == null) {
            return null;
        }
        Transition transition2 = FragmentTransition.cloneTransition(isPop ? outFragment.getSharedElementReturnTransition() : inFragment.getSharedElementEnterTransition());
        if (transition2 == null) {
            return null;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition(transition2);
        return transitionSet;
    }

    private static final Transition $$robo$$android_app_FragmentTransition$getEnterTransition(Fragment inFragment, boolean isPop) {
        if (inFragment == null) {
            return null;
        }
        return FragmentTransition.cloneTransition(isPop ? inFragment.getReenterTransition() : inFragment.getEnterTransition());
    }

    private static final Transition $$robo$$android_app_FragmentTransition$getExitTransition(Fragment outFragment, boolean isPop) {
        if (outFragment == null) {
            return null;
        }
        return FragmentTransition.cloneTransition(isPop ? outFragment.getReturnTransition() : outFragment.getExitTransition());
    }

    private static final Transition $$robo$$android_app_FragmentTransition$cloneTransition(Transition transition2) {
        if (transition2 != null) {
            transition2 = ((Transition)transition2).clone();
        }
        return transition2;
    }

    private static final TransitionSet $$robo$$android_app_FragmentTransition$configureSharedElementsReordered(ViewGroup sceneRoot, View nonExistentView, ArrayMap<String, String> nameOverrides, FragmentContainerTransition fragments, ArrayList<View> sharedElementsOut, ArrayList<View> sharedElementsIn, Transition enterTransition, Transition exitTransition) {
        View epicenterView;
        Rect epicenter;
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        if (inFragment != null) {
            inFragment.getView().setVisibility(0);
        }
        if (inFragment == null || outFragment == null) {
            return null;
        }
        boolean inIsPop = fragments.lastInIsPop;
        TransitionSet sharedElementTransition = nameOverrides.isEmpty() ? null : FragmentTransition.getSharedElementTransition(inFragment, outFragment, inIsPop);
        ArrayMap<String, View> outSharedElements = FragmentTransition.captureOutSharedElements(nameOverrides, sharedElementTransition, fragments);
        ArrayMap<String, View> inSharedElements = FragmentTransition.captureInSharedElements(nameOverrides, sharedElementTransition, fragments);
        if (nameOverrides.isEmpty()) {
            sharedElementTransition = null;
            if (outSharedElements != null) {
                outSharedElements.clear();
            }
            if (inSharedElements != null) {
                inSharedElements.clear();
            }
        } else {
            FragmentTransition.addSharedElementsWithMatchingNames(sharedElementsOut, outSharedElements, nameOverrides.keySet());
            FragmentTransition.addSharedElementsWithMatchingNames(sharedElementsIn, inSharedElements, nameOverrides.values());
        }
        if (enterTransition == null && exitTransition == null && sharedElementTransition == null) {
            return null;
        }
        FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, outSharedElements, true);
        if (sharedElementTransition != null) {
            sharedElementsIn.add(nonExistentView);
            FragmentTransition.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementsOut);
            boolean outIsPop = fragments.firstOutIsPop;
            BackStackRecord outTransaction = fragments.firstOutTransaction;
            FragmentTransition.setOutEpicenter(sharedElementTransition, exitTransition, outSharedElements, outIsPop, outTransaction);
            epicenter = new Rect();
            epicenterView = FragmentTransition.getInEpicenterView(inSharedElements, fragments, enterTransition, inIsPop);
            if (epicenterView != null) {
                enterTransition.setEpicenterCallback((Transition.EpicenterCallback)new ShadowedObject(epicenter){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ Rect val$epicenter;

                    private void $$robo$$android_app_FragmentTransition_2$__constructor__(Rect rect) {
                        this.val$epicenter = rect;
                    }

                    private final Rect $$robo$$android_app_FragmentTransition_2$onGetEpicenter(Transition transition2) {
                        return this.val$epicenter;
                    }

                    private void __constructor__(Rect rect) {
                        this.$$robo$$android_app_FragmentTransition_2$__constructor__(rect);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_FragmentTransition_2$__constructor__(android.graphics.Rect ), this, rect);
                    }

                    @Override
                    public Rect onGetEpicenter(Transition transition2) {
                        return InvokeDynamicSupport.bootstrap("onGetEpicenter", $$robo$$android_app_FragmentTransition_2$onGetEpicenter(android.transition.Transition ), this, transition2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        } else {
            epicenter = null;
            epicenterView = null;
        }
        OneShotPreDrawListener.add(sceneRoot, () -> {
            FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, inSharedElements, false);
            if (epicenterView != null) {
                epicenterView.getBoundsOnScreen(epicenter);
            }
        });
        return sharedElementTransition;
    }

    private static final void $$robo$$android_app_FragmentTransition$addSharedElementsWithMatchingNames(ArrayList<View> views, ArrayMap<String, View> sharedElements, Collection<String> nameOverridesSet) {
        for (int i = sharedElements.size() - 1; i >= 0; --i) {
            View view = sharedElements.valueAt(i);
            if (view == null || !nameOverridesSet.contains(view.getTransitionName())) continue;
            views.add(view);
        }
    }

    private static final TransitionSet $$robo$$android_app_FragmentTransition$configureSharedElementsOrdered(ViewGroup sceneRoot, View nonExistentView, ArrayMap<String, String> nameOverrides, FragmentContainerTransition fragments, ArrayList<View> sharedElementsOut, ArrayList<View> sharedElementsIn, Transition enterTransition, Transition exitTransition) {
        Rect inEpicenter;
        Fragment inFragment = fragments.lastIn;
        Fragment outFragment = fragments.firstOut;
        if (inFragment == null || outFragment == null) {
            return null;
        }
        boolean inIsPop = fragments.lastInIsPop;
        TransitionSet sharedElementTransition = nameOverrides.isEmpty() ? null : FragmentTransition.getSharedElementTransition(inFragment, outFragment, inIsPop);
        ArrayMap<String, View> outSharedElements = FragmentTransition.captureOutSharedElements(nameOverrides, sharedElementTransition, fragments);
        if (nameOverrides.isEmpty()) {
            sharedElementTransition = null;
        } else {
            sharedElementsOut.addAll(outSharedElements.values());
        }
        if (enterTransition == null && exitTransition == null && sharedElementTransition == null) {
            return null;
        }
        FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, outSharedElements, true);
        if (sharedElementTransition != null) {
            inEpicenter = new Rect();
            FragmentTransition.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementsOut);
            boolean outIsPop = fragments.firstOutIsPop;
            BackStackRecord outTransaction = fragments.firstOutTransaction;
            FragmentTransition.setOutEpicenter(sharedElementTransition, exitTransition, outSharedElements, outIsPop, outTransaction);
            if (enterTransition != null) {
                enterTransition.setEpicenterCallback((Transition.EpicenterCallback)new ShadowedObject(inEpicenter){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ Rect val$inEpicenter;

                    private void $$robo$$android_app_FragmentTransition_3$__constructor__(Rect rect) {
                        this.val$inEpicenter = rect;
                    }

                    private final Rect $$robo$$android_app_FragmentTransition_3$onGetEpicenter(Transition transition2) {
                        if (this.val$inEpicenter.isEmpty()) {
                            return null;
                        }
                        return this.val$inEpicenter;
                    }

                    private void __constructor__(Rect rect) {
                        this.$$robo$$android_app_FragmentTransition_3$__constructor__(rect);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_FragmentTransition_3$__constructor__(android.graphics.Rect ), this, rect);
                    }

                    @Override
                    public Rect onGetEpicenter(Transition transition2) {
                        return InvokeDynamicSupport.bootstrap("onGetEpicenter", $$robo$$android_app_FragmentTransition_3$onGetEpicenter(android.transition.Transition ), this, transition2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        } else {
            inEpicenter = null;
        }
        TransitionSet finalSharedElementTransition = sharedElementTransition;
        OneShotPreDrawListener.add(sceneRoot, () -> {
            ArrayMap<String, View> inSharedElements = FragmentTransition.captureInSharedElements(nameOverrides, finalSharedElementTransition, fragments);
            if (inSharedElements != null) {
                sharedElementsIn.addAll(inSharedElements.values());
                sharedElementsIn.add(nonExistentView);
            }
            FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, inSharedElements, false);
            if (finalSharedElementTransition != null) {
                finalSharedElementTransition.getTargets().clear();
                finalSharedElementTransition.getTargets().addAll(sharedElementsIn);
                FragmentTransition.replaceTargets(finalSharedElementTransition, sharedElementsOut, sharedElementsIn);
                View inEpicenterView = FragmentTransition.getInEpicenterView(inSharedElements, fragments, enterTransition, inIsPop);
                if (inEpicenterView != null) {
                    inEpicenterView.getBoundsOnScreen(inEpicenter);
                }
            }
        });
        return sharedElementTransition;
    }

    private static final ArrayMap<String, View> $$robo$$android_app_FragmentTransition$captureOutSharedElements(ArrayMap<String, String> nameOverrides, TransitionSet sharedElementTransition, FragmentContainerTransition fragments) {
        ArrayList<String> names;
        SharedElementCallback sharedElementCallback;
        if (nameOverrides.isEmpty() || sharedElementTransition == null) {
            nameOverrides.clear();
            return null;
        }
        Fragment outFragment = fragments.firstOut;
        ArrayMap<String, View> outSharedElements = new ArrayMap<String, View>();
        outFragment.getView().findNamedViews(outSharedElements);
        BackStackRecord outTransaction = fragments.firstOutTransaction;
        if (fragments.firstOutIsPop) {
            sharedElementCallback = outFragment.getEnterTransitionCallback();
            names = outTransaction.mSharedElementTargetNames;
        } else {
            sharedElementCallback = outFragment.getExitTransitionCallback();
            names = outTransaction.mSharedElementSourceNames;
        }
        outSharedElements.retainAll(names);
        if (sharedElementCallback != null) {
            sharedElementCallback.onMapSharedElements(names, outSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String name = names.get(i);
                View view = outSharedElements.get(name);
                if (view == null) {
                    nameOverrides.remove(name);
                    continue;
                }
                if (name.equals(view.getTransitionName())) continue;
                String targetValue = nameOverrides.remove(name);
                nameOverrides.put(view.getTransitionName(), targetValue);
            }
        } else {
            nameOverrides.retainAll(outSharedElements.keySet());
        }
        return outSharedElements;
    }

    private static final ArrayMap<String, View> $$robo$$android_app_FragmentTransition$captureInSharedElements(ArrayMap<String, String> nameOverrides, TransitionSet sharedElementTransition, FragmentContainerTransition fragments) {
        ArrayList<String> names;
        SharedElementCallback sharedElementCallback;
        Fragment inFragment = fragments.lastIn;
        View fragmentView = inFragment.getView();
        if (nameOverrides.isEmpty() || sharedElementTransition == null || fragmentView == null) {
            nameOverrides.clear();
            return null;
        }
        ArrayMap<String, View> inSharedElements = new ArrayMap<String, View>();
        fragmentView.findNamedViews(inSharedElements);
        BackStackRecord inTransaction = fragments.lastInTransaction;
        if (fragments.lastInIsPop) {
            sharedElementCallback = inFragment.getExitTransitionCallback();
            names = inTransaction.mSharedElementSourceNames;
        } else {
            sharedElementCallback = inFragment.getEnterTransitionCallback();
            names = inTransaction.mSharedElementTargetNames;
        }
        if (names != null) {
            inSharedElements.retainAll(names);
        }
        if (names != null && sharedElementCallback != null) {
            sharedElementCallback.onMapSharedElements(names, inSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String key;
                String name = names.get(i);
                View view = inSharedElements.get(name);
                if (view == null) {
                    key = FragmentTransition.findKeyForValue(nameOverrides, name);
                    if (key == null) continue;
                    nameOverrides.remove(key);
                    continue;
                }
                if (name.equals(view.getTransitionName()) || (key = FragmentTransition.findKeyForValue(nameOverrides, name)) == null) continue;
                nameOverrides.put(key, view.getTransitionName());
            }
        } else {
            FragmentTransition.retainValues(nameOverrides, inSharedElements);
        }
        return inSharedElements;
    }

    private static final String $$robo$$android_app_FragmentTransition$findKeyForValue(ArrayMap<String, String> map, String value) {
        int numElements = map.size();
        for (int i = 0; i < numElements; ++i) {
            if (!value.equals(map.valueAt(i))) continue;
            return map.keyAt(i);
        }
        return null;
    }

    private static final View $$robo$$android_app_FragmentTransition$getInEpicenterView(ArrayMap<String, View> inSharedElements, FragmentContainerTransition fragments, Transition enterTransition, boolean inIsPop) {
        BackStackRecord inTransaction = fragments.lastInTransaction;
        if (enterTransition != null && inSharedElements != null && inTransaction.mSharedElementSourceNames != null && !inTransaction.mSharedElementSourceNames.isEmpty()) {
            String targetName = inIsPop ? inTransaction.mSharedElementSourceNames.get(0) : inTransaction.mSharedElementTargetNames.get(0);
            return inSharedElements.get(targetName);
        }
        return null;
    }

    private static final void $$robo$$android_app_FragmentTransition$setOutEpicenter(TransitionSet sharedElementTransition, Transition exitTransition, ArrayMap<String, View> outSharedElements, boolean outIsPop, BackStackRecord outTransaction) {
        if (outTransaction.mSharedElementSourceNames != null && !outTransaction.mSharedElementSourceNames.isEmpty()) {
            String sourceName = outIsPop ? outTransaction.mSharedElementTargetNames.get(0) : outTransaction.mSharedElementSourceNames.get(0);
            View outEpicenterView = outSharedElements.get(sourceName);
            FragmentTransition.setEpicenter(sharedElementTransition, outEpicenterView);
            if (exitTransition != null) {
                FragmentTransition.setEpicenter(exitTransition, outEpicenterView);
            }
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$setEpicenter(Transition transition2, View view) {
        if (view != null) {
            Rect epicenter = new Rect();
            view.getBoundsOnScreen(epicenter);
            transition2.setEpicenterCallback((Transition.EpicenterCallback)new ShadowedObject(epicenter){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Rect val$epicenter;

                private void $$robo$$android_app_FragmentTransition_4$__constructor__(Rect rect) {
                    this.val$epicenter = rect;
                }

                private final Rect $$robo$$android_app_FragmentTransition_4$onGetEpicenter(Transition transition2) {
                    return this.val$epicenter;
                }

                private void __constructor__(Rect rect) {
                    this.$$robo$$android_app_FragmentTransition_4$__constructor__(rect);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_FragmentTransition_4$__constructor__(android.graphics.Rect ), this, rect);
                }

                @Override
                public Rect onGetEpicenter(Transition transition2) {
                    return InvokeDynamicSupport.bootstrap("onGetEpicenter", $$robo$$android_app_FragmentTransition_4$onGetEpicenter(android.transition.Transition ), this, transition2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$retainValues(ArrayMap<String, String> nameOverrides, ArrayMap<String, View> namedViews) {
        for (int i = nameOverrides.size() - 1; i >= 0; --i) {
            String targetName = nameOverrides.valueAt(i);
            if (namedViews.containsKey(targetName)) continue;
            nameOverrides.removeAt(i);
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$callSharedElementStartEnd(Fragment inFragment, Fragment outFragment, boolean isPop, ArrayMap<String, View> sharedElements, boolean isStart) {
        SharedElementCallback sharedElementCallback;
        SharedElementCallback sharedElementCallback2 = sharedElementCallback = isPop ? outFragment.getEnterTransitionCallback() : inFragment.getEnterTransitionCallback();
        if (sharedElementCallback != null) {
            ArrayList<View> views = new ArrayList<View>();
            ArrayList<String> names = new ArrayList<String>();
            int count = sharedElements == null ? 0 : sharedElements.size();
            for (int i = 0; i < count; ++i) {
                names.add(sharedElements.keyAt(i));
                views.add(sharedElements.valueAt(i));
            }
            if (isStart) {
                sharedElementCallback.onSharedElementStart(names, views, null);
            } else {
                sharedElementCallback.onSharedElementEnd(names, views, null);
            }
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$setSharedElementTargets(TransitionSet transition2, View nonExistentView, ArrayList<View> sharedViews) {
        List<View> views = transition2.getTargets();
        views.clear();
        int count = sharedViews.size();
        for (int i = 0; i < count; ++i) {
            View view = sharedViews.get(i);
            FragmentTransition.bfsAddViewChildren(views, view);
        }
        views.add(nonExistentView);
        sharedViews.add(nonExistentView);
        FragmentTransition.addTargets(transition2, sharedViews);
    }

    private static final void $$robo$$android_app_FragmentTransition$bfsAddViewChildren(List<View> views, View startView) {
        int startIndex = views.size();
        if (FragmentTransition.containedBeforeIndex(views, startView, startIndex)) {
            return;
        }
        views.add(startView);
        for (int index = startIndex; index < views.size(); ++index) {
            View view = views.get(index);
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                View child = viewGroup.getChildAt(childIndex);
                if (FragmentTransition.containedBeforeIndex(views, child, startIndex)) continue;
                views.add(child);
            }
        }
    }

    private static final boolean $$robo$$android_app_FragmentTransition$containedBeforeIndex(List<View> views, View view, int maxIndex) {
        for (int i = 0; i < maxIndex; ++i) {
            if (views.get(i) != view) continue;
            return true;
        }
        return false;
    }

    private static final void $$robo$$android_app_FragmentTransition$scheduleRemoveTargets(Transition overalTransition, Transition enterTransition, ArrayList<View> enteringViews, Transition exitTransition, ArrayList<View> exitingViews, TransitionSet sharedElementTransition, ArrayList<View> sharedElementsIn) {
        overalTransition.addListener((Transition.TransitionListener)new ShadowedObject(enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementsIn){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Transition val$enterTransition;
            /* synthetic */ ArrayList val$enteringViews;
            /* synthetic */ Transition val$exitTransition;
            /* synthetic */ ArrayList val$exitingViews;
            /* synthetic */ TransitionSet val$sharedElementTransition;
            /* synthetic */ ArrayList val$sharedElementsIn;

            private void $$robo$$android_app_FragmentTransition_5$__constructor__(Transition transition2, ArrayList arrayList, Transition transition3, ArrayList arrayList2, TransitionSet transitionSet, ArrayList arrayList3) {
                this.val$enterTransition = transition2;
                this.val$enteringViews = arrayList;
                this.val$exitTransition = transition3;
                this.val$exitingViews = arrayList2;
                this.val$sharedElementTransition = transitionSet;
                this.val$sharedElementsIn = arrayList3;
            }

            private final void $$robo$$android_app_FragmentTransition_5$onTransitionStart(Transition transition2) {
                if (this.val$enterTransition != null) {
                    FragmentTransition.replaceTargets(this.val$enterTransition, this.val$enteringViews, null);
                }
                if (this.val$exitTransition != null) {
                    FragmentTransition.replaceTargets(this.val$exitTransition, this.val$exitingViews, null);
                }
                if (this.val$sharedElementTransition != null) {
                    FragmentTransition.replaceTargets(this.val$sharedElementTransition, this.val$sharedElementsIn, null);
                }
            }

            private void __constructor__(Transition transition2, ArrayList arrayList, Transition transition3, ArrayList arrayList2, TransitionSet transitionSet, ArrayList arrayList3) {
                this.$$robo$$android_app_FragmentTransition_5$__constructor__(transition2, arrayList, transition3, arrayList2, transitionSet, arrayList3);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_FragmentTransition_5$__constructor__(android.transition.Transition java.util.ArrayList android.transition.Transition java.util.ArrayList android.transition.TransitionSet java.util.ArrayList ), this, transition2, arrayList, transition3, arrayList2, transitionSet, arrayList3);
            }

            @Override
            public void onTransitionStart(Transition transition2) {
                InvokeDynamicSupport.bootstrap("onTransitionStart", $$robo$$android_app_FragmentTransition_5$onTransitionStart(android.transition.Transition ), this, transition2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private static final void $$robo$$android_app_FragmentTransition$replaceTargets(Transition transition2, ArrayList<View> oldTargets, ArrayList<View> newTargets) {
        block4: {
            int i;
            List<View> targets;
            block3: {
                if (!(transition2 instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition2;
                int numTransitions = set.getTransitionCount();
                for (int i2 = 0; i2 < numTransitions; ++i2) {
                    Transition child = set.getTransitionAt(i2);
                    FragmentTransition.replaceTargets(child, oldTargets, newTargets);
                }
                break block4;
            }
            if (FragmentTransition.hasSimpleTarget(transition2) || (targets = transition2.getTargets()) == null || targets.size() != oldTargets.size() || !targets.containsAll(oldTargets)) break block4;
            int targetCount = newTargets == null ? 0 : newTargets.size();
            for (i = 0; i < targetCount; ++i) {
                transition2.addTarget(newTargets.get(i));
            }
            for (i = oldTargets.size() - 1; i >= 0; --i) {
                transition2.removeTarget(oldTargets.get(i));
            }
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$addTargets(Transition transition2, ArrayList<View> views) {
        block4: {
            List<View> targets;
            block3: {
                if (transition2 == null) {
                    return;
                }
                if (!(transition2 instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition2;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    FragmentTransition.addTargets(child, views);
                }
                break block4;
            }
            if (FragmentTransition.hasSimpleTarget(transition2) || !FragmentTransition.isNullOrEmpty(targets = transition2.getTargets())) break block4;
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                transition2.addTarget(views.get(i));
            }
        }
    }

    private static final boolean $$robo$$android_app_FragmentTransition$hasSimpleTarget(Transition transition2) {
        return !FragmentTransition.isNullOrEmpty(transition2.getTargetIds()) || !FragmentTransition.isNullOrEmpty(transition2.getTargetNames()) || !FragmentTransition.isNullOrEmpty(transition2.getTargetTypes());
    }

    private static final boolean $$robo$$android_app_FragmentTransition$isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    private static final ArrayList<View> $$robo$$android_app_FragmentTransition$configureEnteringExitingViews(Transition transition2, Fragment fragment, ArrayList<View> sharedElements, View nonExistentView) {
        ArrayList<View> viewList = null;
        if (transition2 != null) {
            viewList = new ArrayList<View>();
            View root = fragment.getView();
            if (root != null) {
                root.captureTransitioningViews(viewList);
            }
            if (sharedElements != null) {
                viewList.removeAll(sharedElements);
            }
            if (!viewList.isEmpty()) {
                viewList.add(nonExistentView);
                FragmentTransition.addTargets(transition2, viewList);
            }
        }
        return viewList;
    }

    private static final void $$robo$$android_app_FragmentTransition$setViewVisibility(ArrayList<View> views, int visibility) {
        if (views == null) {
            return;
        }
        for (int i = views.size() - 1; i >= 0; --i) {
            View view = views.get(i);
            view.setVisibility(visibility);
        }
    }

    private static final Transition $$robo$$android_app_FragmentTransition$mergeTransitions(Transition enterTransition, Transition exitTransition, Transition sharedElementTransition, Fragment inFragment, boolean isPop) {
        Transition transition2;
        boolean overlap = true;
        if (enterTransition != null && exitTransition != null && inFragment != null) {
            boolean bl = overlap = isPop ? inFragment.getAllowReturnTransitionOverlap() : inFragment.getAllowEnterTransitionOverlap();
        }
        if (overlap) {
            TransitionSet transitionSet = new TransitionSet();
            if (enterTransition != null) {
                transitionSet.addTransition(enterTransition);
            }
            if (exitTransition != null) {
                transitionSet.addTransition(exitTransition);
            }
            if (sharedElementTransition != null) {
                transitionSet.addTransition(sharedElementTransition);
            }
            transition2 = transitionSet;
        } else {
            Transition staggered = null;
            if (exitTransition != null && enterTransition != null) {
                staggered = new TransitionSet().addTransition(exitTransition).addTransition(enterTransition).setOrdering(1);
            } else if (exitTransition != null) {
                staggered = exitTransition;
            } else if (enterTransition != null) {
                staggered = enterTransition;
            }
            if (sharedElementTransition != null) {
                TransitionSet together = new TransitionSet();
                if (staggered != null) {
                    together.addTransition(staggered);
                }
                together.addTransition(sharedElementTransition);
                transition2 = together;
            } else {
                transition2 = staggered;
            }
        }
        return transition2;
    }

    private static final void $$robo$$android_app_FragmentTransition$calculateFragments(BackStackRecord transaction, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isReordered) {
        int numOps = transaction.mOps.size();
        for (int opNum = 0; opNum < numOps; ++opNum) {
            BackStackRecord.Op op = transaction.mOps.get(opNum);
            FragmentTransition.addToFirstInLastOut(transaction, op, transitioningFragments, false, isReordered);
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$calculatePopFragments(BackStackRecord transaction, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isReordered) {
        if (!transaction.mManager.mContainer.onHasView()) {
            return;
        }
        int numOps = transaction.mOps.size();
        for (int opNum = numOps - 1; opNum >= 0; --opNum) {
            BackStackRecord.Op op = transaction.mOps.get(opNum);
            FragmentTransition.addToFirstInLastOut(transaction, op, transitioningFragments, true, isReordered);
        }
    }

    private static final void $$robo$$android_app_FragmentTransition$addToFirstInLastOut(BackStackRecord transaction, BackStackRecord.Op op, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isPop, boolean isReorderedTransaction) {
        Fragment fragment = op.fragment;
        if (fragment == null) {
            return;
        }
        int containerId = fragment.mContainerId;
        if (containerId == 0) {
            return;
        }
        int command = isPop ? INVERSE_OPS[op.cmd] : op.cmd;
        boolean setLastIn = false;
        boolean wasRemoved = false;
        boolean setFirstOut = false;
        boolean wasAdded = false;
        switch (command) {
            case 5: {
                setLastIn = isReorderedTransaction ? fragment.mHiddenChanged && !fragment.mHidden && fragment.mAdded : fragment.mHidden;
                wasAdded = true;
                break;
            }
            case 1: 
            case 7: {
                setLastIn = isReorderedTransaction ? fragment.mIsNewlyAdded : !fragment.mAdded && !fragment.mHidden;
                wasAdded = true;
                break;
            }
            case 4: {
                setFirstOut = isReorderedTransaction ? fragment.mHiddenChanged && fragment.mAdded && fragment.mHidden : fragment.mAdded && !fragment.mHidden;
                wasRemoved = true;
                break;
            }
            case 3: 
            case 6: {
                setFirstOut = isReorderedTransaction ? !fragment.mAdded && fragment.mView != null && fragment.mView.getVisibility() == 0 && fragment.mView.getTransitionAlpha() > 0.0f : fragment.mAdded && !fragment.mHidden;
                wasRemoved = true;
            }
        }
        FragmentContainerTransition containerTransition = transitioningFragments.get(containerId);
        if (setLastIn) {
            containerTransition = FragmentTransition.ensureContainer(containerTransition, transitioningFragments, containerId);
            containerTransition.lastIn = fragment;
            containerTransition.lastInIsPop = isPop;
            containerTransition.lastInTransaction = transaction;
        }
        if (!isReorderedTransaction && wasAdded) {
            if (containerTransition != null && containerTransition.firstOut == fragment) {
                containerTransition.firstOut = null;
            }
            FragmentManagerImpl manager = transaction.mManager;
            if (fragment.mState < 1 && manager.mCurState >= 1 && manager.mHost.getContext().getApplicationInfo().targetSdkVersion >= 24 && !transaction.mReorderingAllowed) {
                manager.makeActive(fragment);
                manager.moveToState(fragment, 1, 0, 0, false);
            }
        }
        if (setFirstOut && (containerTransition == null || containerTransition.firstOut == null)) {
            containerTransition = FragmentTransition.ensureContainer(containerTransition, transitioningFragments, containerId);
            containerTransition.firstOut = fragment;
            containerTransition.firstOutIsPop = isPop;
            containerTransition.firstOutTransaction = transaction;
        }
        if (!isReorderedTransaction && wasRemoved && containerTransition != null && containerTransition.lastIn == fragment) {
            containerTransition.lastIn = null;
        }
    }

    private static final FragmentContainerTransition $$robo$$android_app_FragmentTransition$ensureContainer(FragmentContainerTransition containerTransition, SparseArray<FragmentContainerTransition> transitioningFragments, int containerId) {
        if (containerTransition == null) {
            containerTransition = new FragmentContainerTransition();
            transitioningFragments.put(containerId, containerTransition);
        }
        return containerTransition;
    }

    static void __staticInitializer__() {
        INVERSE_OPS = new int[]{0, 3, 0, 1, 5, 4, 7, 6, 9, 8};
    }

    private void __constructor__() {
        this.$$robo$$android_app_FragmentTransition$__constructor__();
    }

    public FragmentTransition() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_FragmentTransition$__constructor__(), this);
    }

    static void startTransitions(FragmentManagerImpl fragmentManagerImpl, ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("startTransitions", $$robo$$android_app_FragmentTransition$startTransitions(android.app.FragmentManagerImpl java.util.ArrayList<android.app.BackStackRecord> java.util.ArrayList<java.lang.Boolean> int int boolean ), (FragmentManagerImpl)fragmentManagerImpl, arrayList, arrayList2, (int)n, (int)n2, (boolean)bl);
    }

    private static ArrayMap<String, String> calculateNameOverrides(int n, ArrayList<BackStackRecord> arrayList, ArrayList<Boolean> arrayList2, int n2, int n3) {
        return InvokeDynamicSupport.bootstrapStatic("calculateNameOverrides", $$robo$$android_app_FragmentTransition$calculateNameOverrides(int java.util.ArrayList<android.app.BackStackRecord> java.util.ArrayList<java.lang.Boolean> int int ), (int)n, arrayList, arrayList2, (int)n2, (int)n3);
    }

    private static void configureTransitionsReordered(FragmentManagerImpl fragmentManagerImpl, int n, FragmentContainerTransition fragmentContainerTransition, View view, ArrayMap<String, String> arrayMap) {
        InvokeDynamicSupport.bootstrapStatic("configureTransitionsReordered", $$robo$$android_app_FragmentTransition$configureTransitionsReordered(android.app.FragmentManagerImpl int android.app.FragmentTransition$FragmentContainerTransition android.view.View android.util.ArrayMap<java.lang.String, java.lang.String> ), (FragmentManagerImpl)fragmentManagerImpl, (int)n, (FragmentContainerTransition)fragmentContainerTransition, (View)view, arrayMap);
    }

    private static void configureTransitionsOrdered(FragmentManagerImpl fragmentManagerImpl, int n, FragmentContainerTransition fragmentContainerTransition, View view, ArrayMap<String, String> arrayMap) {
        InvokeDynamicSupport.bootstrapStatic("configureTransitionsOrdered", $$robo$$android_app_FragmentTransition$configureTransitionsOrdered(android.app.FragmentManagerImpl int android.app.FragmentTransition$FragmentContainerTransition android.view.View android.util.ArrayMap<java.lang.String, java.lang.String> ), (FragmentManagerImpl)fragmentManagerImpl, (int)n, (FragmentContainerTransition)fragmentContainerTransition, (View)view, arrayMap);
    }

    private static void replaceHide(Transition transition2, Fragment fragment, ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("replaceHide", $$robo$$android_app_FragmentTransition$replaceHide(android.transition.Transition android.app.Fragment java.util.ArrayList<android.view.View> ), (Transition)transition2, (Fragment)fragment, arrayList);
    }

    private static void scheduleTargetChange(ViewGroup viewGroup, Fragment fragment, View view, ArrayList<View> arrayList, Transition transition2, ArrayList<View> arrayList2, Transition transition3, ArrayList<View> arrayList3) {
        InvokeDynamicSupport.bootstrapStatic("scheduleTargetChange", $$robo$$android_app_FragmentTransition$scheduleTargetChange(android.view.ViewGroup android.app.Fragment android.view.View java.util.ArrayList<android.view.View> android.transition.Transition java.util.ArrayList<android.view.View> android.transition.Transition java.util.ArrayList<android.view.View> ), (ViewGroup)viewGroup, (Fragment)fragment, (View)view, arrayList, (Transition)transition2, arrayList2, (Transition)transition3, arrayList3);
    }

    private static TransitionSet getSharedElementTransition(Fragment fragment, Fragment fragment2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getSharedElementTransition", $$robo$$android_app_FragmentTransition$getSharedElementTransition(android.app.Fragment android.app.Fragment boolean ), (Fragment)fragment, (Fragment)fragment2, (boolean)bl);
    }

    private static Transition getEnterTransition(Fragment fragment, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getEnterTransition", $$robo$$android_app_FragmentTransition$getEnterTransition(android.app.Fragment boolean ), (Fragment)fragment, (boolean)bl);
    }

    private static Transition getExitTransition(Fragment fragment, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getExitTransition", $$robo$$android_app_FragmentTransition$getExitTransition(android.app.Fragment boolean ), (Fragment)fragment, (boolean)bl);
    }

    private static Transition cloneTransition(Transition transition2) {
        return InvokeDynamicSupport.bootstrapStatic("cloneTransition", $$robo$$android_app_FragmentTransition$cloneTransition(android.transition.Transition ), (Transition)transition2);
    }

    private static TransitionSet configureSharedElementsReordered(ViewGroup viewGroup, View view, ArrayMap<String, String> arrayMap, FragmentContainerTransition fragmentContainerTransition, ArrayList<View> arrayList, ArrayList<View> arrayList2, Transition transition2, Transition transition3) {
        return InvokeDynamicSupport.bootstrapStatic("configureSharedElementsReordered", $$robo$$android_app_FragmentTransition$configureSharedElementsReordered(android.view.ViewGroup android.view.View android.util.ArrayMap<java.lang.String, java.lang.String> android.app.FragmentTransition$FragmentContainerTransition java.util.ArrayList<android.view.View> java.util.ArrayList<android.view.View> android.transition.Transition android.transition.Transition ), (ViewGroup)viewGroup, (View)view, arrayMap, (FragmentContainerTransition)fragmentContainerTransition, arrayList, arrayList2, (Transition)transition2, (Transition)transition3);
    }

    private static void addSharedElementsWithMatchingNames(ArrayList<View> arrayList, ArrayMap<String, View> arrayMap, Collection<String> collection) {
        InvokeDynamicSupport.bootstrapStatic("addSharedElementsWithMatchingNames", $$robo$$android_app_FragmentTransition$addSharedElementsWithMatchingNames(java.util.ArrayList<android.view.View> android.util.ArrayMap<java.lang.String, android.view.View> java.util.Collection<java.lang.String> ), arrayList, arrayMap, collection);
    }

    private static TransitionSet configureSharedElementsOrdered(ViewGroup viewGroup, View view, ArrayMap<String, String> arrayMap, FragmentContainerTransition fragmentContainerTransition, ArrayList<View> arrayList, ArrayList<View> arrayList2, Transition transition2, Transition transition3) {
        return InvokeDynamicSupport.bootstrapStatic("configureSharedElementsOrdered", $$robo$$android_app_FragmentTransition$configureSharedElementsOrdered(android.view.ViewGroup android.view.View android.util.ArrayMap<java.lang.String, java.lang.String> android.app.FragmentTransition$FragmentContainerTransition java.util.ArrayList<android.view.View> java.util.ArrayList<android.view.View> android.transition.Transition android.transition.Transition ), (ViewGroup)viewGroup, (View)view, arrayMap, (FragmentContainerTransition)fragmentContainerTransition, arrayList, arrayList2, (Transition)transition2, (Transition)transition3);
    }

    private static ArrayMap<String, View> captureOutSharedElements(ArrayMap<String, String> arrayMap, TransitionSet transitionSet, FragmentContainerTransition fragmentContainerTransition) {
        return InvokeDynamicSupport.bootstrapStatic("captureOutSharedElements", $$robo$$android_app_FragmentTransition$captureOutSharedElements(android.util.ArrayMap<java.lang.String, java.lang.String> android.transition.TransitionSet android.app.FragmentTransition$FragmentContainerTransition ), arrayMap, (TransitionSet)transitionSet, (FragmentContainerTransition)fragmentContainerTransition);
    }

    private static ArrayMap<String, View> captureInSharedElements(ArrayMap<String, String> arrayMap, TransitionSet transitionSet, FragmentContainerTransition fragmentContainerTransition) {
        return InvokeDynamicSupport.bootstrapStatic("captureInSharedElements", $$robo$$android_app_FragmentTransition$captureInSharedElements(android.util.ArrayMap<java.lang.String, java.lang.String> android.transition.TransitionSet android.app.FragmentTransition$FragmentContainerTransition ), arrayMap, (TransitionSet)transitionSet, (FragmentContainerTransition)fragmentContainerTransition);
    }

    private static String findKeyForValue(ArrayMap<String, String> arrayMap, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("findKeyForValue", $$robo$$android_app_FragmentTransition$findKeyForValue(android.util.ArrayMap<java.lang.String, java.lang.String> java.lang.String ), arrayMap, (String)string2);
    }

    private static View getInEpicenterView(ArrayMap<String, View> arrayMap, FragmentContainerTransition fragmentContainerTransition, Transition transition2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getInEpicenterView", $$robo$$android_app_FragmentTransition$getInEpicenterView(android.util.ArrayMap<java.lang.String, android.view.View> android.app.FragmentTransition$FragmentContainerTransition android.transition.Transition boolean ), arrayMap, (FragmentContainerTransition)fragmentContainerTransition, (Transition)transition2, (boolean)bl);
    }

    private static void setOutEpicenter(TransitionSet transitionSet, Transition transition2, ArrayMap<String, View> arrayMap, boolean bl, BackStackRecord backStackRecord) {
        InvokeDynamicSupport.bootstrapStatic("setOutEpicenter", $$robo$$android_app_FragmentTransition$setOutEpicenter(android.transition.TransitionSet android.transition.Transition android.util.ArrayMap<java.lang.String, android.view.View> boolean android.app.BackStackRecord ), (TransitionSet)transitionSet, (Transition)transition2, arrayMap, (boolean)bl, (BackStackRecord)backStackRecord);
    }

    private static void setEpicenter(Transition transition2, View view) {
        InvokeDynamicSupport.bootstrapStatic("setEpicenter", $$robo$$android_app_FragmentTransition$setEpicenter(android.transition.Transition android.view.View ), (Transition)transition2, (View)view);
    }

    private static void retainValues(ArrayMap<String, String> arrayMap, ArrayMap<String, View> arrayMap2) {
        InvokeDynamicSupport.bootstrapStatic("retainValues", $$robo$$android_app_FragmentTransition$retainValues(android.util.ArrayMap<java.lang.String, java.lang.String> android.util.ArrayMap<java.lang.String, android.view.View> ), arrayMap, arrayMap2);
    }

    private static void callSharedElementStartEnd(Fragment fragment, Fragment fragment2, boolean bl, ArrayMap<String, View> arrayMap, boolean bl2) {
        InvokeDynamicSupport.bootstrapStatic("callSharedElementStartEnd", $$robo$$android_app_FragmentTransition$callSharedElementStartEnd(android.app.Fragment android.app.Fragment boolean android.util.ArrayMap<java.lang.String, android.view.View> boolean ), (Fragment)fragment, (Fragment)fragment2, (boolean)bl, arrayMap, (boolean)bl2);
    }

    private static void setSharedElementTargets(TransitionSet transitionSet, View view, ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("setSharedElementTargets", $$robo$$android_app_FragmentTransition$setSharedElementTargets(android.transition.TransitionSet android.view.View java.util.ArrayList<android.view.View> ), (TransitionSet)transitionSet, (View)view, arrayList);
    }

    private static void bfsAddViewChildren(List<View> list, View view) {
        InvokeDynamicSupport.bootstrapStatic("bfsAddViewChildren", $$robo$$android_app_FragmentTransition$bfsAddViewChildren(java.util.List<android.view.View> android.view.View ), list, (View)view);
    }

    private static boolean containedBeforeIndex(List<View> list, View view, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containedBeforeIndex", $$robo$$android_app_FragmentTransition$containedBeforeIndex(java.util.List<android.view.View> android.view.View int ), list, (View)view, (int)n);
    }

    private static void scheduleRemoveTargets(Transition transition2, Transition transition3, ArrayList<View> arrayList, Transition transition4, ArrayList<View> arrayList2, TransitionSet transitionSet, ArrayList<View> arrayList3) {
        InvokeDynamicSupport.bootstrapStatic("scheduleRemoveTargets", $$robo$$android_app_FragmentTransition$scheduleRemoveTargets(android.transition.Transition android.transition.Transition java.util.ArrayList<android.view.View> android.transition.Transition java.util.ArrayList<android.view.View> android.transition.TransitionSet java.util.ArrayList<android.view.View> ), (Transition)transition2, (Transition)transition3, arrayList, (Transition)transition4, arrayList2, (TransitionSet)transitionSet, arrayList3);
    }

    public static void replaceTargets(Transition transition2, ArrayList<View> arrayList, ArrayList<View> arrayList2) {
        InvokeDynamicSupport.bootstrapStatic("replaceTargets", $$robo$$android_app_FragmentTransition$replaceTargets(android.transition.Transition java.util.ArrayList<android.view.View> java.util.ArrayList<android.view.View> ), (Transition)transition2, arrayList, arrayList2);
    }

    public static void addTargets(Transition transition2, ArrayList<View> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("addTargets", $$robo$$android_app_FragmentTransition$addTargets(android.transition.Transition java.util.ArrayList<android.view.View> ), (Transition)transition2, arrayList);
    }

    private static boolean hasSimpleTarget(Transition transition2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasSimpleTarget", $$robo$$android_app_FragmentTransition$hasSimpleTarget(android.transition.Transition ), (Transition)transition2);
    }

    private static boolean isNullOrEmpty(List list) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNullOrEmpty", $$robo$$android_app_FragmentTransition$isNullOrEmpty(java.util.List ), (List)list);
    }

    private static ArrayList<View> configureEnteringExitingViews(Transition transition2, Fragment fragment, ArrayList<View> arrayList, View view) {
        return InvokeDynamicSupport.bootstrapStatic("configureEnteringExitingViews", $$robo$$android_app_FragmentTransition$configureEnteringExitingViews(android.transition.Transition android.app.Fragment java.util.ArrayList<android.view.View> android.view.View ), (Transition)transition2, (Fragment)fragment, arrayList, (View)view);
    }

    private static void setViewVisibility(ArrayList<View> arrayList, int n) {
        InvokeDynamicSupport.bootstrapStatic("setViewVisibility", $$robo$$android_app_FragmentTransition$setViewVisibility(java.util.ArrayList<android.view.View> int ), arrayList, (int)n);
    }

    private static Transition mergeTransitions(Transition transition2, Transition transition3, Transition transition4, Fragment fragment, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("mergeTransitions", $$robo$$android_app_FragmentTransition$mergeTransitions(android.transition.Transition android.transition.Transition android.transition.Transition android.app.Fragment boolean ), (Transition)transition2, (Transition)transition3, (Transition)transition4, (Fragment)fragment, (boolean)bl);
    }

    public static void calculateFragments(BackStackRecord backStackRecord, SparseArray<FragmentContainerTransition> sparseArray, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("calculateFragments", $$robo$$android_app_FragmentTransition$calculateFragments(android.app.BackStackRecord android.util.SparseArray<android.app.FragmentTransition$FragmentContainerTransition> boolean ), (BackStackRecord)backStackRecord, sparseArray, (boolean)bl);
    }

    public static void calculatePopFragments(BackStackRecord backStackRecord, SparseArray<FragmentContainerTransition> sparseArray, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("calculatePopFragments", $$robo$$android_app_FragmentTransition$calculatePopFragments(android.app.BackStackRecord android.util.SparseArray<android.app.FragmentTransition$FragmentContainerTransition> boolean ), (BackStackRecord)backStackRecord, sparseArray, (boolean)bl);
    }

    private static void addToFirstInLastOut(BackStackRecord backStackRecord, BackStackRecord.Op op, SparseArray<FragmentContainerTransition> sparseArray, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrapStatic("addToFirstInLastOut", $$robo$$android_app_FragmentTransition$addToFirstInLastOut(android.app.BackStackRecord android.app.BackStackRecord$Op android.util.SparseArray<android.app.FragmentTransition$FragmentContainerTransition> boolean boolean ), (BackStackRecord)backStackRecord, (BackStackRecord.Op)op, sparseArray, (boolean)bl, (boolean)bl2);
    }

    private static FragmentContainerTransition ensureContainer(FragmentContainerTransition fragmentContainerTransition, SparseArray<FragmentContainerTransition> sparseArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("ensureContainer", $$robo$$android_app_FragmentTransition$ensureContainer(android.app.FragmentTransition$FragmentContainerTransition android.util.SparseArray<android.app.FragmentTransition$FragmentContainerTransition> int ), (FragmentContainerTransition)fragmentContainerTransition, sparseArray, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(FragmentTransition.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FragmentTransition)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FragmentContainerTransition
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public Fragment lastIn;
        public boolean lastInIsPop;
        public BackStackRecord lastInTransaction;
        public Fragment firstOut;
        public boolean firstOutIsPop;
        public BackStackRecord firstOutTransaction;

        private void $$robo$$android_app_FragmentTransition_FragmentContainerTransition$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_app_FragmentTransition_FragmentContainerTransition$__constructor__();
        }

        public FragmentContainerTransition() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_FragmentTransition_FragmentContainerTransition$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FragmentContainerTransition)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

