/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.DialogFragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaRouter;
import android.util.AttributeSet;
import android.view.View;
import com.android.internal.R;
import com.android.internal.app.MediaRouteDialogPresenter;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaRouteButton
extends View
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private MediaRouter mRouter;
    private MediaRouterCallback mCallback;
    private int mRouteTypes;
    private boolean mAttachedToWindow;
    private Drawable mRemoteIndicator;
    private boolean mRemoteActive;
    private boolean mIsConnecting;
    private int mMinWidth;
    private int mMinHeight;
    private View.OnClickListener mExtendedSettingsClickListener;
    private static int[] CHECKED_STATE_SET;
    private static int[] ACTIVATED_STATE_SET;

    private void $$robo$$android_app_MediaRouteButton$__constructor__(Context context) {
    }

    private void $$robo$$android_app_MediaRouteButton$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_app_MediaRouteButton$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_app_MediaRouteButton$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mRouter = (MediaRouter)context.getSystemService("media_router");
        this.mCallback = new MediaRouterCallback(this, null);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MediaRouteButton, defStyleAttr, defStyleRes);
        this.setRemoteIndicatorDrawable(a.getDrawable(3));
        this.mMinWidth = a.getDimensionPixelSize(0, 0);
        this.mMinHeight = a.getDimensionPixelSize(1, 0);
        int routeTypes = a.getInteger(2, 1);
        a.recycle();
        this.setClickable(true);
        this.setRouteTypes(routeTypes);
    }

    private final int $$robo$$android_app_MediaRouteButton$getRouteTypes() {
        return this.mRouteTypes;
    }

    private final void $$robo$$android_app_MediaRouteButton$setRouteTypes(int types) {
        if (this.mRouteTypes != types) {
            if (this.mAttachedToWindow && this.mRouteTypes != 0) {
                this.mRouter.removeCallback(this.mCallback);
            }
            this.mRouteTypes = types;
            if (this.mAttachedToWindow && types != 0) {
                this.mRouter.addCallback(types, this.mCallback, 8);
            }
            this.refreshRoute();
        }
    }

    private final void $$robo$$android_app_MediaRouteButton$setExtendedSettingsClickListener(View.OnClickListener listener) {
        this.mExtendedSettingsClickListener = listener;
    }

    private final void $$robo$$android_app_MediaRouteButton$showDialog() {
        this.showDialogInternal();
    }

    private final boolean $$robo$$android_app_MediaRouteButton$showDialogInternal() {
        if (!this.mAttachedToWindow) {
            return false;
        }
        DialogFragment f = MediaRouteDialogPresenter.showDialogFragment(this.getActivity(), this.mRouteTypes, this.mExtendedSettingsClickListener);
        return f != null;
    }

    private final Activity $$robo$$android_app_MediaRouteButton$getActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        throw new IllegalStateException("The MediaRouteButton's Context is not an Activity.");
    }

    private final void $$robo$$android_app_MediaRouteButton$setContentDescription(CharSequence contentDescription) {
        super.setContentDescription(contentDescription);
        this.setTooltipText(contentDescription);
    }

    private final boolean $$robo$$android_app_MediaRouteButton$performClick() {
        boolean handled = super.performClick();
        if (!handled) {
            this.playSoundEffect(0);
        }
        return this.showDialogInternal() || handled;
    }

    private final int[] $$robo$$android_app_MediaRouteButton$onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.mIsConnecting) {
            MediaRouteButton.mergeDrawableStates(drawableState, CHECKED_STATE_SET);
        } else if (this.mRemoteActive) {
            MediaRouteButton.mergeDrawableStates(drawableState, ACTIVATED_STATE_SET);
        }
        return drawableState;
    }

    private final void $$robo$$android_app_MediaRouteButton$drawableStateChanged() {
        super.drawableStateChanged();
        Drawable remoteIndicator = this.mRemoteIndicator;
        if (remoteIndicator != null && remoteIndicator.isStateful() && remoteIndicator.setState(this.getDrawableState())) {
            this.invalidateDrawable(remoteIndicator);
        }
    }

    private final void $$robo$$android_app_MediaRouteButton$setRemoteIndicatorDrawable(Drawable d) {
        if (this.mRemoteIndicator != null) {
            this.mRemoteIndicator.setCallback(null);
            this.unscheduleDrawable(this.mRemoteIndicator);
        }
        this.mRemoteIndicator = d;
        if (d != null) {
            d.setCallback(this);
            d.setState(this.getDrawableState());
            d.setVisible(this.getVisibility() == 0, false);
        }
        this.refreshDrawableState();
    }

    private final boolean $$robo$$android_app_MediaRouteButton$verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mRemoteIndicator;
    }

    private final void $$robo$$android_app_MediaRouteButton$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mRemoteIndicator != null) {
            this.mRemoteIndicator.jumpToCurrentState();
        }
    }

    private final void $$robo$$android_app_MediaRouteButton$setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mRemoteIndicator != null) {
            this.mRemoteIndicator.setVisible(this.getVisibility() == 0, false);
        }
    }

    private final void $$robo$$android_app_MediaRouteButton$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        if (this.mRouteTypes != 0) {
            this.mRouter.addCallback(this.mRouteTypes, this.mCallback, 8);
        }
        this.refreshRoute();
    }

    private final void $$robo$$android_app_MediaRouteButton$onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        if (this.mRouteTypes != 0) {
            this.mRouter.removeCallback(this.mCallback);
        }
        super.onDetachedFromWindow();
    }

    private final void $$robo$$android_app_MediaRouteButton$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredHeight;
        int measuredWidth;
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int width = Math.max(this.mMinWidth, this.mRemoteIndicator != null ? this.mRemoteIndicator.getIntrinsicWidth() + this.getPaddingLeft() + this.getPaddingRight() : 0);
        int height = Math.max(this.mMinHeight, this.mRemoteIndicator != null ? this.mRemoteIndicator.getIntrinsicHeight() + this.getPaddingTop() + this.getPaddingBottom() : 0);
        switch (widthMode) {
            case 0x40000000: {
                measuredWidth = widthSize;
                break;
            }
            case -2147483648: {
                measuredWidth = Math.min(widthSize, width);
                break;
            }
            default: {
                measuredWidth = width;
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                measuredHeight = heightSize;
                break;
            }
            case -2147483648: {
                measuredHeight = Math.min(heightSize, height);
                break;
            }
            default: {
                measuredHeight = height;
            }
        }
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    private final void $$robo$$android_app_MediaRouteButton$onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mRemoteIndicator == null) {
            return;
        }
        int left = this.getPaddingLeft();
        int right = this.getWidth() - this.getPaddingRight();
        int top = this.getPaddingTop();
        int bottom = this.getHeight() - this.getPaddingBottom();
        int drawWidth = this.mRemoteIndicator.getIntrinsicWidth();
        int drawHeight = this.mRemoteIndicator.getIntrinsicHeight();
        int drawLeft = left + (right - left - drawWidth) / 2;
        int drawTop = top + (bottom - top - drawHeight) / 2;
        this.mRemoteIndicator.setBounds(drawLeft, drawTop, drawLeft + drawWidth, drawTop + drawHeight);
        this.mRemoteIndicator.draw(canvas);
    }

    private final void $$robo$$android_app_MediaRouteButton$refreshRoute() {
        MediaRouter.RouteInfo route = this.mRouter.getSelectedRoute();
        boolean isRemote = !route.isDefault() && route.matchesTypes(this.mRouteTypes);
        boolean isConnecting = isRemote && route.isConnecting();
        boolean needsRefresh = false;
        if (this.mRemoteActive != isRemote) {
            this.mRemoteActive = isRemote;
            needsRefresh = true;
        }
        if (this.mIsConnecting != isConnecting) {
            this.mIsConnecting = isConnecting;
            needsRefresh = true;
        }
        if (needsRefresh) {
            this.refreshDrawableState();
        }
        if (this.mAttachedToWindow) {
            this.setEnabled(this.mRouter.isRouteAvailable(this.mRouteTypes, 1));
        }
        if (this.mRemoteIndicator != null && this.mRemoteIndicator.getCurrent() instanceof AnimationDrawable) {
            AnimationDrawable curDrawable = (AnimationDrawable)this.mRemoteIndicator.getCurrent();
            if (this.mAttachedToWindow) {
                if ((needsRefresh || isConnecting) && !curDrawable.isRunning()) {
                    curDrawable.start();
                }
            } else if (isRemote && !isConnecting) {
                if (curDrawable.isRunning()) {
                    curDrawable.stop();
                }
                curDrawable.selectDrawable(curDrawable.getNumberOfFrames() - 1);
            }
        }
    }

    static void __staticInitializer__() {
        CHECKED_STATE_SET = new int[]{0x10100A0};
        ACTIVATED_STATE_SET = new int[]{16843518};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_app_MediaRouteButton$__constructor__(context);
    }

    public MediaRouteButton(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_MediaRouteButton$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_app_MediaRouteButton$__constructor__(context, attributeSet);
    }

    public MediaRouteButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843693);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_MediaRouteButton$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_app_MediaRouteButton$__constructor__(context, attributeSet, n);
    }

    public MediaRouteButton(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_MediaRouteButton$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_app_MediaRouteButton$__constructor__(context, attributeSet, n, n2);
    }

    public MediaRouteButton(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_MediaRouteButton$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    public int getRouteTypes() {
        return (int)InvokeDynamicSupport.bootstrap("getRouteTypes", $$robo$$android_app_MediaRouteButton$getRouteTypes(), this);
    }

    public void setRouteTypes(int n) {
        InvokeDynamicSupport.bootstrap("setRouteTypes", $$robo$$android_app_MediaRouteButton$setRouteTypes(int ), this, n);
    }

    public void setExtendedSettingsClickListener(View.OnClickListener onClickListener) {
        InvokeDynamicSupport.bootstrap("setExtendedSettingsClickListener", $$robo$$android_app_MediaRouteButton$setExtendedSettingsClickListener(android.view.View$OnClickListener ), this, onClickListener);
    }

    public void showDialog() {
        InvokeDynamicSupport.bootstrap("showDialog", $$robo$$android_app_MediaRouteButton$showDialog(), this);
    }

    boolean showDialogInternal() {
        return (boolean)InvokeDynamicSupport.bootstrap("showDialogInternal", $$robo$$android_app_MediaRouteButton$showDialogInternal(), this);
    }

    private Activity getActivity() {
        return InvokeDynamicSupport.bootstrap("getActivity", $$robo$$android_app_MediaRouteButton$getActivity(), this);
    }

    @Override
    public void setContentDescription(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setContentDescription", $$robo$$android_app_MediaRouteButton$setContentDescription(java.lang.CharSequence ), this, charSequence);
    }

    @Override
    public boolean performClick() {
        return (boolean)InvokeDynamicSupport.bootstrap("performClick", $$robo$$android_app_MediaRouteButton$performClick(), this);
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_app_MediaRouteButton$onCreateDrawableState(int ), this, n);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_app_MediaRouteButton$drawableStateChanged(), this);
    }

    private void setRemoteIndicatorDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setRemoteIndicatorDrawable", $$robo$$android_app_MediaRouteButton$setRemoteIndicatorDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_app_MediaRouteButton$verifyDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_app_MediaRouteButton$jumpDrawablesToCurrentState(), this);
    }

    @Override
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_app_MediaRouteButton$setVisibility(int ), this, n);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_app_MediaRouteButton$onAttachedToWindow(), this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_app_MediaRouteButton$onDetachedFromWindow(), this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_app_MediaRouteButton$onMeasure(int int ), this, n, n2);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_app_MediaRouteButton$onDraw(android.graphics.Canvas ), this, canvas);
    }

    private void refreshRoute() {
        InvokeDynamicSupport.bootstrap("refreshRoute", $$robo$$android_app_MediaRouteButton$refreshRoute(), this);
    }

    static {
        RobolectricInternals.classInitializing(MediaRouteButton.class);
    }

    public /* synthetic */ MediaRouteButton() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRouteButton)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MediaRouterCallback
    extends MediaRouter.SimpleCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaRouteButton this$0;

        private void $$robo$$android_app_MediaRouteButton_MediaRouterCallback$__constructor__(MediaRouteButton mediaRouteButton) {
            this.this$0 = mediaRouteButton;
        }

        private final void $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            this.this$0.refreshRoute();
        }

        private final void $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            this.this$0.refreshRoute();
        }

        private final void $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteChanged(MediaRouter router, MediaRouter.RouteInfo info) {
            this.this$0.refreshRoute();
        }

        private final void $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteSelected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            this.this$0.refreshRoute();
        }

        private final void $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteUnselected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            this.this$0.refreshRoute();
        }

        private final void $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteGrouped(MediaRouter router, MediaRouter.RouteInfo info, MediaRouter.RouteGroup group, int index) {
            this.this$0.refreshRoute();
        }

        private final void $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteUngrouped(MediaRouter router, MediaRouter.RouteInfo info, MediaRouter.RouteGroup group) {
            this.this$0.refreshRoute();
        }

        private /* synthetic */ void $$robo$$android_app_MediaRouteButton_MediaRouterCallback$__constructor__(MediaRouteButton x0, 1 x1) {
        }

        private void __constructor__(MediaRouteButton mediaRouteButton) {
            this.$$robo$$android_app_MediaRouteButton_MediaRouterCallback$__constructor__(mediaRouteButton);
        }

        public MediaRouterCallback(MediaRouteButton mediaRouteButton) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_MediaRouteButton_MediaRouterCallback$__constructor__(android.app.MediaRouteButton ), this, mediaRouteButton);
        }

        @Override
        public void onRouteAdded(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteAdded", $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteAdded(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteRemoved(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteRemoved", $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteRemoved(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteChanged", $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteChanged(android.media.MediaRouter android.media.MediaRouter$RouteInfo ), this, mediaRouter, routeInfo);
        }

        @Override
        public void onRouteSelected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteSelected", $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteSelected(android.media.MediaRouter int android.media.MediaRouter$RouteInfo ), this, mediaRouter, n, routeInfo);
        }

        @Override
        public void onRouteUnselected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            InvokeDynamicSupport.bootstrap("onRouteUnselected", $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteUnselected(android.media.MediaRouter int android.media.MediaRouter$RouteInfo ), this, mediaRouter, n, routeInfo);
        }

        @Override
        public void onRouteGrouped(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo, MediaRouter.RouteGroup routeGroup, int n) {
            InvokeDynamicSupport.bootstrap("onRouteGrouped", $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteGrouped(android.media.MediaRouter android.media.MediaRouter$RouteInfo android.media.MediaRouter$RouteGroup int ), this, mediaRouter, routeInfo, routeGroup, n);
        }

        @Override
        public void onRouteUngrouped(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo, MediaRouter.RouteGroup routeGroup) {
            InvokeDynamicSupport.bootstrap("onRouteUngrouped", $$robo$$android_app_MediaRouteButton_MediaRouterCallback$onRouteUngrouped(android.media.MediaRouter android.media.MediaRouter$RouteInfo android.media.MediaRouter$RouteGroup ), this, mediaRouter, routeInfo, routeGroup);
        }

        private /* synthetic */ void __constructor__(MediaRouteButton mediaRouteButton, 1 var2_2) {
            this.$$robo$$android_app_MediaRouteButton_MediaRouterCallback$__constructor__(mediaRouteButton, var2_2);
        }

        public /* synthetic */ MediaRouterCallback(MediaRouteButton mediaRouteButton, 1 var2_2) {
            this(mediaRouteButton);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_MediaRouteButton_MediaRouterCallback$__constructor__(android.app.MediaRouteButton android.app.MediaRouteButton$1 ), this, mediaRouteButton, var2_2);
        }

        public /* synthetic */ MediaRouterCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaRouterCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

