/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ApplicationPackageManager;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.content.res.CompatResources;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.ResourcesKey;
import android.hardware.display.DisplayManagerGlobal;
import android.os.IBinder;
import android.os.Trace;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.LruCache;
import android.util.Pair;
import android.util.Slog;
import android.view.Display;
import android.view.DisplayAdjustments;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResourcesManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "ResourcesManager";
    private static boolean DEBUG = false;
    private static ResourcesManager sResourcesManager;
    private static Predicate<WeakReference<Resources>> sEmptyReferencePredicate;
    private CompatibilityInfo mResCompatibilityInfo;
    private Configuration mResConfiguration;
    private ArrayMap<ResourcesKey, WeakReference<ResourcesImpl>> mResourceImpls;
    private ArrayList<WeakReference<Resources>> mResourceReferences;
    private LruCache<ApkKey, ApkAssets> mLoadedApkAssets;
    private ArrayMap<ApkKey, WeakReference<ApkAssets>> mCachedApkAssets;
    private WeakHashMap<IBinder, ActivityResources> mActivityResourceReferences;
    private ArrayMap<Pair<Integer, DisplayAdjustments>, WeakReference<Display>> mAdjustedDisplays;

    private void $$robo$$android_app_ResourcesManager$__constructor__() {
        this.mResConfiguration = new Configuration();
        this.mResourceImpls = new ArrayMap();
        this.mResourceReferences = new ArrayList();
        this.mLoadedApkAssets = new LruCache(3);
        this.mCachedApkAssets = new ArrayMap();
        this.mActivityResourceReferences = new WeakHashMap();
        this.mAdjustedDisplays = new ArrayMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ResourcesManager $$robo$$android_app_ResourcesManager$getInstance() {
        Class<ResourcesManager> clazz = ResourcesManager.class;
        synchronized (ResourcesManager.class) {
            if (sResourcesManager == null) {
                sResourcesManager = new ResourcesManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sResourcesManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ResourcesManager$invalidatePath(String path) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            int count = 0;
            int i = 0;
            while (i < this.mResourceImpls.size()) {
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                if (key.isPathReferenced(path)) {
                    this.cleanupResourceImpl(key);
                    ++count;
                    continue;
                }
                ++i;
            }
            Log.i("ResourcesManager", "Invalidated " + count + " asset managers that referenced " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Configuration $$robo$$android_app_ResourcesManager$getConfiguration() {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            return this.mResConfiguration;
        }
    }

    private final DisplayMetrics $$robo$$android_app_ResourcesManager$getDisplayMetrics() {
        return this.getDisplayMetrics(0, DisplayAdjustments.DEFAULT_DISPLAY_ADJUSTMENTS);
    }

    @VisibleForTesting
    private final DisplayMetrics $$robo$$android_app_ResourcesManager$getDisplayMetrics(int displayId, DisplayAdjustments da) {
        DisplayMetrics dm = new DisplayMetrics();
        Display display = this.getAdjustedDisplay(displayId, da);
        if (display != null) {
            display.getMetrics(dm);
        } else {
            dm.setToDefaults();
        }
        return dm;
    }

    private static final void $$robo$$android_app_ResourcesManager$applyNonDefaultDisplayMetricsToConfiguration(DisplayMetrics dm, Configuration config) {
        config.touchscreen = 1;
        config.densityDpi = dm.densityDpi;
        config.screenWidthDp = (int)((float)dm.widthPixels / dm.density);
        config.screenHeightDp = (int)((float)dm.heightPixels / dm.density);
        int sl = Configuration.resetScreenLayout(config.screenLayout);
        if (dm.widthPixels > dm.heightPixels) {
            config.orientation = 2;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenWidthDp, config.screenHeightDp);
        } else {
            config.orientation = 1;
            config.screenLayout = Configuration.reduceScreenLayout(sl, config.screenHeightDp, config.screenWidthDp);
        }
        config.smallestScreenWidthDp = config.screenWidthDp;
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        config.compatSmallestScreenWidthDp = config.smallestScreenWidthDp;
    }

    private final boolean $$robo$$android_app_ResourcesManager$applyCompatConfigurationLocked(int displayDensity, Configuration compatConfiguration) {
        if (this.mResCompatibilityInfo != null && !this.mResCompatibilityInfo.supportsScreen()) {
            this.mResCompatibilityInfo.applyToConfiguration(displayDensity, compatConfiguration);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Display $$robo$$android_app_ResourcesManager$getAdjustedDisplay(int displayId, DisplayAdjustments displayAdjustments) {
        DisplayAdjustments displayAdjustmentsCopy = displayAdjustments != null ? new DisplayAdjustments(displayAdjustments) : new DisplayAdjustments();
        Pair<Integer, DisplayAdjustments> key = Pair.create(displayId, displayAdjustmentsCopy);
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            Display display;
            WeakReference<Display> wd = this.mAdjustedDisplays.get(key);
            if (wd != null && (display = (Display)wd.get()) != null) {
                return display;
            }
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            if (dm == null) {
                return null;
            }
            Display display2 = dm.getCompatibleDisplay(displayId, (DisplayAdjustments)key.second);
            if (display2 != null) {
                this.mAdjustedDisplays.put(key, new WeakReference<Display>(display2));
            }
            return display2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Display $$robo$$android_app_ResourcesManager$getAdjustedDisplay(int displayId, Resources resources) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            if (dm == null) {
                return null;
            }
            return dm.getCompatibleDisplay(displayId, resources);
        }
    }

    private final void $$robo$$android_app_ResourcesManager$cleanupResourceImpl(ResourcesKey removedKey) {
        ResourcesImpl res = (ResourcesImpl)this.mResourceImpls.remove(removedKey).get();
        if (res != null) {
            res.flushLayoutCache();
        }
    }

    private static final String $$robo$$android_app_ResourcesManager$overlayPathToIdmapPath(String path) {
        return "/data/resource-cache/" + path.substring(1).replace('/', '@') + "@idmap";
    }

    private final ApkAssets $$robo$$android_app_ResourcesManager$loadApkAssets(String path, boolean sharedLib, boolean overlay) throws IOException {
        ApkKey newKey = new ApkKey(path, sharedLib, overlay);
        ApkAssets apkAssets = this.mLoadedApkAssets.get(newKey);
        if (apkAssets != null) {
            return apkAssets;
        }
        WeakReference<ApkAssets> apkAssetsRef = this.mCachedApkAssets.get(newKey);
        if (apkAssetsRef != null) {
            apkAssets = (ApkAssets)apkAssetsRef.get();
            if (apkAssets != null) {
                this.mLoadedApkAssets.put(newKey, apkAssets);
                return apkAssets;
            }
            this.mCachedApkAssets.remove(newKey);
        }
        apkAssets = overlay ? ApkAssets.loadOverlayFromPath(ResourcesManager.overlayPathToIdmapPath(path), false) : ApkAssets.loadFromPath(path, false, sharedLib);
        this.mLoadedApkAssets.put(newKey, apkAssets);
        this.mCachedApkAssets.put(newKey, new WeakReference<ApkAssets>(apkAssets));
        return apkAssets;
    }

    @VisibleForTesting
    private final AssetManager $$robo$$android_app_ResourcesManager$createAssetManager(ResourcesKey key) {
        AssetManager.Builder builder = new AssetManager.Builder();
        if (key.mResDir != null) {
            try {
                builder.addApkAssets(this.loadApkAssets(key.mResDir, false, false));
            }
            catch (IOException e) {
                Log.e("ResourcesManager", "failed to add asset path " + key.mResDir);
                return null;
            }
        }
        if (key.mSplitResDirs != null) {
            for (String splitResDir : key.mSplitResDirs) {
                try {
                    builder.addApkAssets(this.loadApkAssets(splitResDir, false, false));
                }
                catch (IOException e) {
                    Log.e("ResourcesManager", "failed to add split asset path " + splitResDir);
                    return null;
                }
            }
        }
        if (key.mOverlayDirs != null) {
            for (String idmapPath : key.mOverlayDirs) {
                try {
                    builder.addApkAssets(this.loadApkAssets(idmapPath, false, true));
                }
                catch (IOException e) {
                    Log.w("ResourcesManager", "failed to add overlay path " + idmapPath);
                }
            }
        }
        if (key.mLibDirs != null) {
            for (String libDir : key.mLibDirs) {
                if (!libDir.endsWith(".apk")) continue;
                try {
                    builder.addApkAssets(this.loadApkAssets(libDir, true, false));
                }
                catch (IOException e) {
                    Log.w("ResourcesManager", "Asset path '" + libDir + "' does not exist or contains no resources.");
                }
            }
        }
        return builder.build();
    }

    private static final <T> int $$robo$$android_app_ResourcesManager$countLiveReferences(Collection<WeakReference<T>> collection) {
        int count = 0;
        for (WeakReference<T> ref : collection) {
            Object value = ref != null ? ref.get() : null;
            if (value == null) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ResourcesManager$dump(String prefix, PrintWriter printWriter) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
            for (int i = 0; i < prefix.length() / 2; ++i) {
                pw.increaseIndent();
            }
            pw.println("ResourcesManager:");
            pw.increaseIndent();
            pw.print("cached apks: total=");
            pw.print(this.mLoadedApkAssets.size());
            pw.print(" created=");
            pw.print(this.mLoadedApkAssets.createCount());
            pw.print(" evicted=");
            pw.print(this.mLoadedApkAssets.evictionCount());
            pw.print(" hit=");
            pw.print(this.mLoadedApkAssets.hitCount());
            pw.print(" miss=");
            pw.print(this.mLoadedApkAssets.missCount());
            pw.print(" max=");
            pw.print(this.mLoadedApkAssets.maxSize());
            pw.println();
            pw.print("total apks: ");
            pw.println(ResourcesManager.countLiveReferences(this.mCachedApkAssets.values()));
            pw.print("resources: ");
            int references = ResourcesManager.countLiveReferences(this.mResourceReferences);
            for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
                references += ResourcesManager.countLiveReferences(activityResources.activityResources);
            }
            pw.println(references);
            pw.print("resource impls: ");
            pw.println(ResourcesManager.countLiveReferences(this.mResourceImpls.values()));
        }
    }

    private final Configuration $$robo$$android_app_ResourcesManager$generateConfig(ResourcesKey key, DisplayMetrics dm) {
        Configuration config;
        boolean isDefaultDisplay = key.mDisplayId == 0;
        boolean hasOverrideConfig = key.hasOverrideConfiguration();
        if (!isDefaultDisplay || hasOverrideConfig) {
            config = new Configuration(this.getConfiguration());
            if (!isDefaultDisplay) {
                ResourcesManager.applyNonDefaultDisplayMetricsToConfiguration(dm, config);
            }
            if (hasOverrideConfig) {
                config.updateFrom(key.mOverrideConfiguration);
            }
        } else {
            config = this.getConfiguration();
        }
        return config;
    }

    private final ResourcesImpl $$robo$$android_app_ResourcesManager$createResourcesImpl(ResourcesKey key) {
        DisplayAdjustments daj = new DisplayAdjustments(key.mOverrideConfiguration);
        daj.setCompatibilityInfo(key.mCompatInfo);
        AssetManager assets = this.createAssetManager(key);
        if (assets == null) {
            return null;
        }
        DisplayMetrics dm = this.getDisplayMetrics(key.mDisplayId, daj);
        Configuration config = this.generateConfig(key, dm);
        ResourcesImpl impl = new ResourcesImpl(assets, dm, config, daj);
        return impl;
    }

    private final ResourcesImpl $$robo$$android_app_ResourcesManager$findResourcesImplForKeyLocked(ResourcesKey key) {
        ResourcesImpl impl;
        WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.get(key);
        ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
        if (impl != null && impl.getAssets().isUpToDate()) {
            return impl;
        }
        return null;
    }

    private final ResourcesImpl $$robo$$android_app_ResourcesManager$findOrCreateResourcesImplForKeyLocked(ResourcesKey key) {
        ResourcesImpl impl = this.findResourcesImplForKeyLocked(key);
        if (impl == null && (impl = this.createResourcesImpl(key)) != null) {
            this.mResourceImpls.put(key, new WeakReference<ResourcesImpl>(impl));
        }
        return impl;
    }

    private final ResourcesKey $$robo$$android_app_ResourcesManager$findKeyForResourceImplLocked(ResourcesImpl resourceImpl) {
        int refCount = this.mResourceImpls.size();
        for (int i = 0; i < refCount; ++i) {
            ResourcesImpl impl;
            WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
            ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
            if (impl == null || resourceImpl != impl) continue;
            return this.mResourceImpls.keyAt(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_ResourcesManager$isSameResourcesOverrideConfig(IBinder activityToken, Configuration overrideConfig) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ActivityResources activityResources;
            ActivityResources activityResources2 = activityResources = activityToken != null ? this.mActivityResourceReferences.get(activityToken) : null;
            if (activityResources == null) {
                return overrideConfig == null;
            }
            return Objects.equals(activityResources.overrideConfig, overrideConfig) || overrideConfig != null && activityResources.overrideConfig != null && 0 == overrideConfig.diffPublicOnly(activityResources.overrideConfig);
        }
    }

    private final ActivityResources $$robo$$android_app_ResourcesManager$getOrCreateActivityResourcesStructLocked(IBinder activityToken) {
        ActivityResources activityResources = this.mActivityResourceReferences.get(activityToken);
        if (activityResources == null) {
            activityResources = new ActivityResources(null);
            this.mActivityResourceReferences.put(activityToken, activityResources);
        }
        return activityResources;
    }

    private final Resources $$robo$$android_app_ResourcesManager$getOrCreateResourcesForActivityLocked(IBinder activityToken, ClassLoader classLoader, ResourcesImpl impl, CompatibilityInfo compatInfo) {
        ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
        int refCount = activityResources.activityResources.size();
        for (int i = 0; i < refCount; ++i) {
            WeakReference<Resources> weakResourceRef = activityResources.activityResources.get(i);
            Resources resources = (Resources)weakResourceRef.get();
            if (resources == null || !Objects.equals(resources.getClassLoader(), classLoader) || resources.getImpl() != impl) continue;
            return resources;
        }
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        activityResources.activityResources.add(new WeakReference<Resources>(resources));
        return resources;
    }

    private final Resources $$robo$$android_app_ResourcesManager$getOrCreateResourcesLocked(ClassLoader classLoader, ResourcesImpl impl, CompatibilityInfo compatInfo) {
        int refCount = this.mResourceReferences.size();
        for (int i = 0; i < refCount; ++i) {
            WeakReference<Resources> weakResourceRef = this.mResourceReferences.get(i);
            Resources resources = (Resources)weakResourceRef.get();
            if (resources == null || !Objects.equals(resources.getClassLoader(), classLoader) || resources.getImpl() != impl) continue;
            return resources;
        }
        Resources resources = compatInfo.needsCompatResources() ? new CompatResources(classLoader) : new Resources(classLoader);
        resources.setImpl(impl);
        this.mResourceReferences.add(new WeakReference<Resources>(resources));
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Resources $$robo$$android_app_ResourcesManager$createBaseActivityResources(IBinder activityToken, String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#createBaseActivityResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, overlayDirs, libDirs, displayId, overrideConfig != null ? new Configuration(overrideConfig) : null, compatInfo);
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            Object object = this;
            synchronized (object) {
                this.getOrCreateActivityResourcesStructLocked(activityToken);
            }
            this.updateResourcesForActivity(activityToken, overrideConfig, displayId, false);
            object = this.getOrCreateResources(activityToken, key, classLoader);
            return object;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Resources $$robo$$android_app_ResourcesManager$getOrCreateResources(IBinder activityToken, ResourcesKey key, ClassLoader classLoader) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ResourcesImpl resourcesImpl;
            if (activityToken != null) {
                ResourcesImpl resourcesImpl2;
                ActivityResources activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
                ArrayUtils.unstableRemoveIf(activityResources.activityResources, sEmptyReferencePredicate);
                if (key.hasOverrideConfiguration() && !activityResources.overrideConfig.equals(Configuration.EMPTY)) {
                    Configuration temp = new Configuration(activityResources.overrideConfig);
                    temp.updateFrom(key.mOverrideConfiguration);
                    key.mOverrideConfiguration.setTo(temp);
                }
                if ((resourcesImpl2 = this.findResourcesImplForKeyLocked(key)) != null) {
                    return this.getOrCreateResourcesForActivityLocked(activityToken, classLoader, resourcesImpl2, key.mCompatInfo);
                }
            } else {
                ArrayUtils.unstableRemoveIf(this.mResourceReferences, sEmptyReferencePredicate);
                resourcesImpl = this.findResourcesImplForKeyLocked(key);
                if (resourcesImpl != null) {
                    return this.getOrCreateResourcesLocked(classLoader, resourcesImpl, key.mCompatInfo);
                }
            }
            if ((resourcesImpl = this.createResourcesImpl(key)) == null) {
                return null;
            }
            this.mResourceImpls.put(key, new WeakReference<ResourcesImpl>(resourcesImpl));
            Resources resources = activityToken != null ? this.getOrCreateResourcesForActivityLocked(activityToken, classLoader, resourcesImpl, key.mCompatInfo) : this.getOrCreateResourcesLocked(classLoader, resourcesImpl, key.mCompatInfo);
            return resources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Resources $$robo$$android_app_ResourcesManager$getResources(IBinder activityToken, String resDir, String[] splitResDirs, String[] overlayDirs, String[] libDirs, int displayId, Configuration overrideConfig, CompatibilityInfo compatInfo, ClassLoader classLoader) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#getResources");
            ResourcesKey key = new ResourcesKey(resDir, splitResDirs, overlayDirs, libDirs, displayId, overrideConfig != null ? new Configuration(overrideConfig) : null, compatInfo);
            classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            Resources resources = this.getOrCreateResources(activityToken, key, classLoader);
            return resources;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ResourcesManager$updateResourcesForActivity(IBinder activityToken, Configuration overrideConfig, int displayId, boolean movedToDifferentDisplay) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#updateResourcesForActivity");
            ResourcesManager resourcesManager = this;
            synchronized (resourcesManager) {
                ActivityResources activityResources;
                block15: {
                    activityResources = this.getOrCreateActivityResourcesStructLocked(activityToken);
                    if (!Objects.equals(activityResources.overrideConfig, overrideConfig) || movedToDifferentDisplay) break block15;
                    return;
                }
                Configuration oldConfig = new Configuration(activityResources.overrideConfig);
                if (overrideConfig != null) {
                    activityResources.overrideConfig.setTo(overrideConfig);
                } else {
                    activityResources.overrideConfig.unset();
                }
                boolean activityHasOverrideConfig = !activityResources.overrideConfig.equals(Configuration.EMPTY);
                int refCount = activityResources.activityResources.size();
                for (int i = 0; i < refCount; ++i) {
                    ResourcesKey newKey;
                    ResourcesImpl resourcesImpl;
                    WeakReference<Resources> weakResRef = activityResources.activityResources.get(i);
                    Resources resources = (Resources)weakResRef.get();
                    if (resources == null) continue;
                    ResourcesKey oldKey = this.findKeyForResourceImplLocked(resources.getImpl());
                    if (oldKey == null) {
                        Slog.e("ResourcesManager", "can't find ResourcesKey for resources impl=" + resources.getImpl());
                        continue;
                    }
                    Configuration rebasedOverrideConfig = new Configuration();
                    if (overrideConfig != null) {
                        rebasedOverrideConfig.setTo(overrideConfig);
                    }
                    if (activityHasOverrideConfig && oldKey.hasOverrideConfiguration()) {
                        Configuration overrideOverrideConfig = Configuration.generateDelta(oldConfig, oldKey.mOverrideConfiguration);
                        rebasedOverrideConfig.updateFrom(overrideOverrideConfig);
                    }
                    if ((resourcesImpl = this.findResourcesImplForKeyLocked(newKey = new ResourcesKey(oldKey.mResDir, oldKey.mSplitResDirs, oldKey.mOverlayDirs, oldKey.mLibDirs, displayId, rebasedOverrideConfig, oldKey.mCompatInfo))) == null && (resourcesImpl = this.createResourcesImpl(newKey)) != null) {
                        this.mResourceImpls.put(newKey, new WeakReference<ResourcesImpl>(resourcesImpl));
                    }
                    if (resourcesImpl == null || resourcesImpl == resources.getImpl()) continue;
                    resources.setImpl(resourcesImpl);
                }
            }
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_ResourcesManager$applyConfigurationToResourcesLocked(Configuration config, CompatibilityInfo compat) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#applyConfigurationToResourcesLocked");
            if (!this.mResConfiguration.isOtherSeqNewer(config) && compat == null) {
                boolean bl = false;
                return bl;
            }
            int changes = this.mResConfiguration.updateFrom(config);
            this.mAdjustedDisplays.clear();
            DisplayMetrics defaultDisplayMetrics = this.getDisplayMetrics();
            if (!(compat == null || this.mResCompatibilityInfo != null && this.mResCompatibilityInfo.equals(compat))) {
                this.mResCompatibilityInfo = compat;
                changes |= 0xD00;
            }
            Resources.updateSystemConfiguration(config, defaultDisplayMetrics, compat);
            ApplicationPackageManager.configurationChanged();
            Configuration tmpConfig = null;
            for (int i = this.mResourceImpls.size() - 1; i >= 0; --i) {
                ResourcesImpl r;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = r = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (r != null) {
                    int displayId = key.mDisplayId;
                    boolean isDefaultDisplay = displayId == 0;
                    DisplayMetrics dm = defaultDisplayMetrics;
                    boolean hasOverrideConfiguration = key.hasOverrideConfiguration();
                    if (!isDefaultDisplay || hasOverrideConfiguration) {
                        if (tmpConfig == null) {
                            tmpConfig = new Configuration();
                        }
                        tmpConfig.setTo(config);
                        DisplayAdjustments daj = r.getDisplayAdjustments();
                        if (compat != null) {
                            daj = new DisplayAdjustments(daj);
                            daj.setCompatibilityInfo(compat);
                        }
                        dm = this.getDisplayMetrics(displayId, daj);
                        if (!isDefaultDisplay) {
                            ResourcesManager.applyNonDefaultDisplayMetricsToConfiguration(dm, tmpConfig);
                        }
                        if (hasOverrideConfiguration) {
                            tmpConfig.updateFrom(key.mOverrideConfiguration);
                        }
                        r.updateConfiguration(tmpConfig, dm, compat);
                        continue;
                    }
                    r.updateConfiguration(config, dm, compat);
                    continue;
                }
                this.mResourceImpls.removeAt(i);
            }
            boolean bl = changes != 0;
            return bl;
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ResourcesManager$appendLibAssetForMainAssetPath(String assetPath, String libAsset) {
        ResourcesManager resourcesManager = this;
        synchronized (resourcesManager) {
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || !Objects.equals(key.mResDir, assetPath) || ArrayUtils.contains(key.mLibDirs, libAsset)) continue;
                int newLibAssetCount = 1 + (key.mLibDirs != null ? key.mLibDirs.length : 0);
                String[] newLibAssets = new String[newLibAssetCount];
                if (key.mLibDirs != null) {
                    InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)key.mLibDirs, (int)0, (Object)newLibAssets, (int)0, (int)key.mLibDirs.length);
                }
                newLibAssets[newLibAssetCount - 1] = libAsset;
                updatedResourceKeys.put(impl, new ResourcesKey(key.mResDir, key.mSplitResDirs, key.mOverlayDirs, newLibAssets, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_ResourcesManager$applyNewResourceDirsLocked(String baseCodePath, String[] newResourceDirs) {
        try {
            Trace.traceBegin(8192L, "ResourcesManager#applyNewResourceDirsLocked");
            ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys = new ArrayMap<ResourcesImpl, ResourcesKey>();
            int implCount = this.mResourceImpls.size();
            for (int i = 0; i < implCount; ++i) {
                ResourcesImpl impl;
                ResourcesKey key = this.mResourceImpls.keyAt(i);
                WeakReference<ResourcesImpl> weakImplRef = this.mResourceImpls.valueAt(i);
                ResourcesImpl resourcesImpl = impl = weakImplRef != null ? (ResourcesImpl)weakImplRef.get() : null;
                if (impl == null || key.mResDir != null && !key.mResDir.equals(baseCodePath)) continue;
                updatedResourceKeys.put(impl, new ResourcesKey(key.mResDir, key.mSplitResDirs, newResourceDirs, key.mLibDirs, key.mDisplayId, key.mOverrideConfiguration, key.mCompatInfo));
            }
            this.redirectResourcesToNewImplLocked(updatedResourceKeys);
        }
        finally {
            Trace.traceEnd(8192L);
        }
    }

    private final void $$robo$$android_app_ResourcesManager$redirectResourcesToNewImplLocked(ArrayMap<ResourcesImpl, ResourcesKey> updatedResourceKeys) {
        if (updatedResourceKeys.isEmpty()) {
            return;
        }
        int resourcesCount = this.mResourceReferences.size();
        for (int i = 0; i < resourcesCount; ++i) {
            ResourcesKey key;
            Resources r;
            WeakReference<Resources> ref = this.mResourceReferences.get(i);
            Resources resources = r = ref != null ? (Resources)ref.get() : null;
            if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
            ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
            if (impl == null) {
                throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
            }
            r.setImpl(impl);
        }
        for (ActivityResources activityResources : this.mActivityResourceReferences.values()) {
            int resCount = activityResources.activityResources.size();
            for (int i = 0; i < resCount; ++i) {
                ResourcesKey key;
                Resources r;
                WeakReference<Resources> ref = activityResources.activityResources.get(i);
                Resources resources = r = ref != null ? (Resources)ref.get() : null;
                if (r == null || (key = updatedResourceKeys.get(r.getImpl())) == null) continue;
                ResourcesImpl impl = this.findOrCreateResourcesImplForKeyLocked(key);
                if (impl == null) {
                    throw new Resources.NotFoundException("failed to redirect ResourcesImpl");
                }
                r.setImpl(impl);
            }
        }
    }

    static void __staticInitializer__() {
        sEmptyReferencePredicate = weakRef -> weakRef == null || weakRef.get() == null;
    }

    private void __constructor__() {
        this.$$robo$$android_app_ResourcesManager$__constructor__();
    }

    public ResourcesManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ResourcesManager$__constructor__(), this);
    }

    public static ResourcesManager getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_app_ResourcesManager$getInstance());
    }

    public void invalidatePath(String string2) {
        InvokeDynamicSupport.bootstrap("invalidatePath", $$robo$$android_app_ResourcesManager$invalidatePath(java.lang.String ), this, string2);
    }

    public Configuration getConfiguration() {
        return InvokeDynamicSupport.bootstrap("getConfiguration", $$robo$$android_app_ResourcesManager$getConfiguration(), this);
    }

    DisplayMetrics getDisplayMetrics() {
        return InvokeDynamicSupport.bootstrap("getDisplayMetrics", $$robo$$android_app_ResourcesManager$getDisplayMetrics(), this);
    }

    protected DisplayMetrics getDisplayMetrics(int n, DisplayAdjustments displayAdjustments) {
        return InvokeDynamicSupport.bootstrap("getDisplayMetrics", $$robo$$android_app_ResourcesManager$getDisplayMetrics(int android.view.DisplayAdjustments ), this, n, displayAdjustments);
    }

    private static void applyNonDefaultDisplayMetricsToConfiguration(DisplayMetrics displayMetrics, Configuration configuration) {
        InvokeDynamicSupport.bootstrapStatic("applyNonDefaultDisplayMetricsToConfiguration", $$robo$$android_app_ResourcesManager$applyNonDefaultDisplayMetricsToConfiguration(android.util.DisplayMetrics android.content.res.Configuration ), (DisplayMetrics)displayMetrics, (Configuration)configuration);
    }

    public boolean applyCompatConfigurationLocked(int n, Configuration configuration) {
        return (boolean)InvokeDynamicSupport.bootstrap("applyCompatConfigurationLocked", $$robo$$android_app_ResourcesManager$applyCompatConfigurationLocked(int android.content.res.Configuration ), this, n, configuration);
    }

    private Display getAdjustedDisplay(int n, DisplayAdjustments displayAdjustments) {
        return InvokeDynamicSupport.bootstrap("getAdjustedDisplay", $$robo$$android_app_ResourcesManager$getAdjustedDisplay(int android.view.DisplayAdjustments ), this, n, displayAdjustments);
    }

    public Display getAdjustedDisplay(int n, Resources resources) {
        return InvokeDynamicSupport.bootstrap("getAdjustedDisplay", $$robo$$android_app_ResourcesManager$getAdjustedDisplay(int android.content.res.Resources ), this, n, resources);
    }

    private void cleanupResourceImpl(ResourcesKey resourcesKey) {
        InvokeDynamicSupport.bootstrap("cleanupResourceImpl", $$robo$$android_app_ResourcesManager$cleanupResourceImpl(android.content.res.ResourcesKey ), this, resourcesKey);
    }

    private static String overlayPathToIdmapPath(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("overlayPathToIdmapPath", $$robo$$android_app_ResourcesManager$overlayPathToIdmapPath(java.lang.String ), (String)string2);
    }

    private ApkAssets loadApkAssets(String string2, boolean bl, boolean bl2) throws IOException {
        return InvokeDynamicSupport.bootstrap("loadApkAssets", $$robo$$android_app_ResourcesManager$loadApkAssets(java.lang.String boolean boolean ), this, string2, bl, bl2);
    }

    protected AssetManager createAssetManager(ResourcesKey resourcesKey) {
        return InvokeDynamicSupport.bootstrap("createAssetManager", $$robo$$android_app_ResourcesManager$createAssetManager(android.content.res.ResourcesKey ), this, resourcesKey);
    }

    private static <T> int countLiveReferences(Collection<WeakReference<T>> collection) {
        return (int)InvokeDynamicSupport.bootstrapStatic("countLiveReferences", $$robo$$android_app_ResourcesManager$countLiveReferences(java.util.Collection<java.lang.ref.WeakReference<T>> ), collection);
    }

    public void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_app_ResourcesManager$dump(java.lang.String java.io.PrintWriter ), this, string2, printWriter);
    }

    private Configuration generateConfig(ResourcesKey resourcesKey, DisplayMetrics displayMetrics) {
        return InvokeDynamicSupport.bootstrap("generateConfig", $$robo$$android_app_ResourcesManager$generateConfig(android.content.res.ResourcesKey android.util.DisplayMetrics ), this, resourcesKey, displayMetrics);
    }

    private ResourcesImpl createResourcesImpl(ResourcesKey resourcesKey) {
        return InvokeDynamicSupport.bootstrap("createResourcesImpl", $$robo$$android_app_ResourcesManager$createResourcesImpl(android.content.res.ResourcesKey ), this, resourcesKey);
    }

    private ResourcesImpl findResourcesImplForKeyLocked(ResourcesKey resourcesKey) {
        return InvokeDynamicSupport.bootstrap("findResourcesImplForKeyLocked", $$robo$$android_app_ResourcesManager$findResourcesImplForKeyLocked(android.content.res.ResourcesKey ), this, resourcesKey);
    }

    private ResourcesImpl findOrCreateResourcesImplForKeyLocked(ResourcesKey resourcesKey) {
        return InvokeDynamicSupport.bootstrap("findOrCreateResourcesImplForKeyLocked", $$robo$$android_app_ResourcesManager$findOrCreateResourcesImplForKeyLocked(android.content.res.ResourcesKey ), this, resourcesKey);
    }

    private ResourcesKey findKeyForResourceImplLocked(ResourcesImpl resourcesImpl) {
        return InvokeDynamicSupport.bootstrap("findKeyForResourceImplLocked", $$robo$$android_app_ResourcesManager$findKeyForResourceImplLocked(android.content.res.ResourcesImpl ), this, resourcesImpl);
    }

    boolean isSameResourcesOverrideConfig(IBinder iBinder, Configuration configuration) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSameResourcesOverrideConfig", $$robo$$android_app_ResourcesManager$isSameResourcesOverrideConfig(android.os.IBinder android.content.res.Configuration ), this, iBinder, configuration);
    }

    private ActivityResources getOrCreateActivityResourcesStructLocked(IBinder iBinder) {
        return InvokeDynamicSupport.bootstrap("getOrCreateActivityResourcesStructLocked", $$robo$$android_app_ResourcesManager$getOrCreateActivityResourcesStructLocked(android.os.IBinder ), this, iBinder);
    }

    private Resources getOrCreateResourcesForActivityLocked(IBinder iBinder, ClassLoader classLoader, ResourcesImpl resourcesImpl, CompatibilityInfo compatibilityInfo) {
        return InvokeDynamicSupport.bootstrap("getOrCreateResourcesForActivityLocked", $$robo$$android_app_ResourcesManager$getOrCreateResourcesForActivityLocked(android.os.IBinder java.lang.ClassLoader android.content.res.ResourcesImpl android.content.res.CompatibilityInfo ), this, iBinder, classLoader, resourcesImpl, compatibilityInfo);
    }

    private Resources getOrCreateResourcesLocked(ClassLoader classLoader, ResourcesImpl resourcesImpl, CompatibilityInfo compatibilityInfo) {
        return InvokeDynamicSupport.bootstrap("getOrCreateResourcesLocked", $$robo$$android_app_ResourcesManager$getOrCreateResourcesLocked(java.lang.ClassLoader android.content.res.ResourcesImpl android.content.res.CompatibilityInfo ), this, classLoader, resourcesImpl, compatibilityInfo);
    }

    public Resources createBaseActivityResources(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, Configuration configuration, CompatibilityInfo compatibilityInfo, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("createBaseActivityResources", $$robo$$android_app_ResourcesManager$createBaseActivityResources(android.os.IBinder java.lang.String java.lang.String[] java.lang.String[] java.lang.String[] int android.content.res.Configuration android.content.res.CompatibilityInfo java.lang.ClassLoader ), this, iBinder, string2, stringArray, stringArray2, stringArray3, n, configuration, compatibilityInfo, classLoader);
    }

    private Resources getOrCreateResources(IBinder iBinder, ResourcesKey resourcesKey, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("getOrCreateResources", $$robo$$android_app_ResourcesManager$getOrCreateResources(android.os.IBinder android.content.res.ResourcesKey java.lang.ClassLoader ), this, iBinder, resourcesKey, classLoader);
    }

    public Resources getResources(IBinder iBinder, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, int n, Configuration configuration, CompatibilityInfo compatibilityInfo, ClassLoader classLoader) {
        return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_app_ResourcesManager$getResources(android.os.IBinder java.lang.String java.lang.String[] java.lang.String[] java.lang.String[] int android.content.res.Configuration android.content.res.CompatibilityInfo java.lang.ClassLoader ), this, iBinder, string2, stringArray, stringArray2, stringArray3, n, configuration, compatibilityInfo, classLoader);
    }

    public void updateResourcesForActivity(IBinder iBinder, Configuration configuration, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateResourcesForActivity", $$robo$$android_app_ResourcesManager$updateResourcesForActivity(android.os.IBinder android.content.res.Configuration int boolean ), this, iBinder, configuration, n, bl);
    }

    public boolean applyConfigurationToResourcesLocked(Configuration configuration, CompatibilityInfo compatibilityInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("applyConfigurationToResourcesLocked", $$robo$$android_app_ResourcesManager$applyConfigurationToResourcesLocked(android.content.res.Configuration android.content.res.CompatibilityInfo ), this, configuration, compatibilityInfo);
    }

    public void appendLibAssetForMainAssetPath(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("appendLibAssetForMainAssetPath", $$robo$$android_app_ResourcesManager$appendLibAssetForMainAssetPath(java.lang.String java.lang.String ), this, string2, string3);
    }

    void applyNewResourceDirsLocked(String string2, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("applyNewResourceDirsLocked", $$robo$$android_app_ResourcesManager$applyNewResourceDirsLocked(java.lang.String java.lang.String[] ), this, string2, stringArray);
    }

    private void redirectResourcesToNewImplLocked(ArrayMap<ResourcesImpl, ResourcesKey> arrayMap) {
        InvokeDynamicSupport.bootstrap("redirectResourcesToNewImplLocked", $$robo$$android_app_ResourcesManager$redirectResourcesToNewImplLocked(android.util.ArrayMap<android.content.res.ResourcesImpl, android.content.res.ResourcesKey> ), this, arrayMap);
    }

    static {
        RobolectricInternals.classInitializing(ResourcesManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourcesManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ActivityResources
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public Configuration overrideConfig;
        public ArrayList<WeakReference<Resources>> activityResources;

        private void $$robo$$android_app_ResourcesManager_ActivityResources$__constructor__() {
            this.overrideConfig = new Configuration();
            this.activityResources = new ArrayList();
        }

        private /* synthetic */ void $$robo$$android_app_ResourcesManager_ActivityResources$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_app_ResourcesManager_ActivityResources$__constructor__();
        }

        public ActivityResources() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ResourcesManager_ActivityResources$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_app_ResourcesManager_ActivityResources$__constructor__(var1_1);
        }

        public /* synthetic */ ActivityResources(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ResourcesManager_ActivityResources$__constructor__(android.app.ResourcesManager$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityResources)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ApkKey
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String path;
        public boolean sharedLib;
        public boolean overlay;

        private void $$robo$$android_app_ResourcesManager_ApkKey$__constructor__(String path, boolean sharedLib, boolean overlay) {
            this.path = path;
            this.sharedLib = sharedLib;
            this.overlay = overlay;
        }

        private final int $$robo$$android_app_ResourcesManager_ApkKey$hashCode() {
            int result = 1;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + Boolean.hashCode(this.sharedLib);
            result = 31 * result + Boolean.hashCode(this.overlay);
            return result;
        }

        private final boolean $$robo$$android_app_ResourcesManager_ApkKey$equals(Object obj) {
            if (!(obj instanceof ApkKey)) {
                return false;
            }
            ApkKey other = (ApkKey)obj;
            return this.path.equals(other.path) && this.sharedLib == other.sharedLib && this.overlay == other.overlay;
        }

        private void __constructor__(String string2, boolean bl, boolean bl2) {
            this.$$robo$$android_app_ResourcesManager_ApkKey$__constructor__(string2, bl, bl2);
        }

        public ApkKey(String string2, boolean bl, boolean bl2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_ResourcesManager_ApkKey$__constructor__(java.lang.String boolean boolean ), this, string2, bl, bl2);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_app_ResourcesManager_ApkKey$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_app_ResourcesManager_ApkKey$equals(java.lang.Object ), this, object);
        }

        public /* synthetic */ ApkKey() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApkKey)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

