/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.ActivityManager;
import android.app.IUiAutomationConnection;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import android.view.Display;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import com.android.internal.util.function.pooled.PooledLambda;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UiAutomation
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;
    private static boolean DEBUG = false;
    private static int CONNECTION_ID_UNDEFINED = -1;
    private static long CONNECT_TIMEOUT_MILLIS = 5000L;
    public static int ROTATION_UNFREEZE = -2;
    public static int ROTATION_FREEZE_CURRENT = -1;
    public static int ROTATION_FREEZE_0 = 0;
    public static int ROTATION_FREEZE_90 = 1;
    public static int ROTATION_FREEZE_180 = 2;
    public static int ROTATION_FREEZE_270 = 3;
    public static int FLAG_DONT_SUPPRESS_ACCESSIBILITY_SERVICES = 1;
    private Object mLock;
    private ArrayList<AccessibilityEvent> mEventQueue;
    private Handler mLocalCallbackHandler;
    private IUiAutomationConnection mUiAutomationConnection;
    private HandlerThread mRemoteCallbackThread;
    private IAccessibilityServiceClient mClient;
    private int mConnectionId;
    private OnAccessibilityEventListener mOnAccessibilityEventListener;
    private boolean mWaitingForEventDelivery;
    private long mLastEventTimeMillis;
    private boolean mIsConnecting;
    private boolean mIsDestroyed;
    private int mFlags;

    private void $$robo$$android_app_UiAutomation$__constructor__(Looper looper, IUiAutomationConnection connection) {
        this.mLock = new Object();
        this.mEventQueue = new ArrayList();
        this.mConnectionId = -1;
        if (looper == null) {
            throw new IllegalArgumentException("Looper cannot be null!");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null!");
        }
        this.mLocalCallbackHandler = new Handler(looper);
        this.mUiAutomationConnection = connection;
    }

    private final void $$robo$$android_app_UiAutomation$connect() {
        this.connect(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomation$connect(int flags) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfConnectedLocked();
            if (this.mIsConnecting) {
                return;
            }
            this.mIsConnecting = true;
            this.mRemoteCallbackThread = new HandlerThread("UiAutomation");
            this.mRemoteCallbackThread.start();
            this.mClient = new IAccessibilityServiceClientImpl(this, this.mRemoteCallbackThread.getLooper());
        }
        try {
            this.mUiAutomationConnection.connect(this.mClient, flags);
            this.mFlags = flags;
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while connecting UiAutomation", re);
        }
        object = this.mLock;
        synchronized (object) {
            block18: {
                long startTimeMillis = SystemClock.uptimeMillis();
                block13: while (true) {
                    while (true) {
                        if (this.isConnectedLocked()) {
                            break block18;
                        }
                        long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                        long remainingTimeMillis = 5000L - elapsedTimeMillis;
                        if (remainingTimeMillis <= 0L) {
                            throw new RuntimeException("Error while connecting UiAutomation");
                        }
                        try {
                            this.mLock.wait(remainingTimeMillis);
                            continue block13;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    this.mIsConnecting = false;
                }
            }
        }
    }

    private final int $$robo$$android_app_UiAutomation$getFlags() {
        return this.mFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomation$disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsConnecting) {
                throw new IllegalStateException("Cannot call disconnect() while connecting!");
            }
            this.throwIfNotConnectedLocked();
            this.mConnectionId = -1;
        }
        try {
            this.mUiAutomationConnection.disconnect();
        }
        catch (RemoteException re) {
            throw new RuntimeException("Error while disconnecting UiAutomation", re);
        }
        finally {
            this.mRemoteCallbackThread.quit();
            this.mRemoteCallbackThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_app_UiAutomation$getConnectionId() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            return this.mConnectionId;
        }
    }

    private final boolean $$robo$$android_app_UiAutomation$isDestroyed() {
        return this.mIsDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomation$setOnAccessibilityEventListener(OnAccessibilityEventListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mOnAccessibilityEventListener = listener;
        }
    }

    private final void $$robo$$android_app_UiAutomation$destroy() {
        this.disconnect();
        this.mIsDestroyed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomation$performGlobalAction(int action) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.performGlobalAction(action);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while calling performGlobalAction", re);
            }
        }
        return false;
    }

    private final AccessibilityNodeInfo $$robo$$android_app_UiAutomation$findFocus(int focus) {
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, -2, AccessibilityNodeInfo.ROOT_NODE_ID, focus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AccessibilityServiceInfo $$robo$$android_app_UiAutomation$getServiceInfo() {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                return connection.getServiceInfo();
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while getting AccessibilityServiceInfo", re);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomation$setServiceInfo(AccessibilityServiceInfo info) {
        IAccessibilityServiceConnection connection;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            AccessibilityInteractionClient.getInstance().clearCache();
            AccessibilityInteractionClient.getInstance();
            connection = AccessibilityInteractionClient.getConnection(this.mConnectionId);
        }
        if (connection != null) {
            try {
                connection.setServiceInfo(info);
            }
            catch (RemoteException re) {
                Log.w(LOG_TAG, "Error while setting AccessibilityServiceInfo", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AccessibilityWindowInfo> $$robo$$android_app_UiAutomation$getWindows() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getWindows(connectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AccessibilityNodeInfo $$robo$$android_app_UiAutomation$getRootInActiveWindow() {
        int connectionId;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            connectionId = this.mConnectionId;
        }
        return AccessibilityInteractionClient.getInstance().getRootInActiveWindow(connectionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomation$injectInputEvent(InputEvent event, boolean sync) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.injectInputEvent(event, sync);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while injecting input event!", re);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomation$setRotation(int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        switch (rotation) {
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                try {
                    this.mUiAutomationConnection.setRotation(rotation);
                    return true;
                }
                catch (RemoteException re) {
                    Log.e(LOG_TAG, "Error while setting rotation!", re);
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid rotation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final AccessibilityEvent $$robo$$android_app_UiAutomation$executeAndWaitForEvent(Runnable command, AccessibilityEventFilter filter, long timeoutMillis) throws TimeoutException {
        block24: {
            var5_4 = this.mLock;
            synchronized (var5_4) {
                this.throwIfNotConnectedLocked();
                this.mEventQueue.clear();
                this.mWaitingForEventDelivery = true;
            }
            executionStartTimeMillis = SystemClock.uptimeMillis();
            command.run();
            receivedEvents = new ArrayList<AccessibilityEvent>();
            try {
                startTimeMillis = SystemClock.uptimeMillis();
lbl11:
                // 2 sources

                while (true) {
                    localEvents = new ArrayList<AccessibilityEvent>();
                    var11_11 = this.mLock;
                    synchronized (var11_11) {
                        localEvents.addAll(this.mEventQueue);
                        this.mEventQueue.clear();
                    }
lbl18:
                    // 3 sources

                    while (!localEvents.isEmpty()) {
                        event = (AccessibilityEvent)localEvents.remove(0);
                        if (event.getEventTime() < executionStartTimeMillis) continue;
                        if (filter.accept(event)) {
                            var12_15 = event;
                            size = receivedEvents.size();
                            i = 0;
                            break block24;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl57
                    break;
                }
            }
            catch (Throwable var18_18) {
                size = receivedEvents.size();
                i = 0;
                while (true) {
                    if (i >= size) {
                        var20_21 = this.mLock;
                        synchronized (var20_21) {
                            this.mWaitingForEventDelivery = false;
                            this.mEventQueue.clear();
                            this.mLock.notifyAll();
                            throw var18_18;
                        }
                    }
                    ((AccessibilityEvent)receivedEvents.get(i)).recycle();
                    ++i;
                }
            }
        }
        while (true) {
            if (i >= size) {
                var14_17 = this.mLock;
                synchronized (var14_17) {
                    this.mWaitingForEventDelivery = false;
                    this.mEventQueue.clear();
                    this.mLock.notifyAll();
                    return var12_15;
                }
            }
            ((AccessibilityEvent)receivedEvents.get(i)).recycle();
            ++i;
        }
lbl-1000:
        // 1 sources

        {
            receivedEvents.add(event);
            ** GOTO lbl18
lbl57:
            // 1 sources

            elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
            remainingTimeMillis = timeoutMillis - elapsedTimeMillis;
            if (remainingTimeMillis <= 0L) {
                throw new TimeoutException("Expected event not received within: " + timeoutMillis + " ms among: " + receivedEvents);
            }
            var15_14 = this.mLock;
            synchronized (var15_14) {
                if (this.mEventQueue.isEmpty()) {
                    try {
                        this.mLock.wait(remainingTimeMillis);
                    }
                    catch (InterruptedException var16_8) {
                        // empty catch block
                    }
                }
            }
            ** continue;
        }
    }

    private final void $$robo$$android_app_UiAutomation$waitForIdle(long idleTimeoutMillis, long globalTimeoutMillis) throws TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
            long startTimeMillis = SystemClock.uptimeMillis();
            if (this.mLastEventTimeMillis <= 0L) {
                this.mLastEventTimeMillis = startTimeMillis;
            }
            while (true) {
                long currentTimeMillis;
                long elapsedGlobalTimeMillis;
                long remainingGlobalTimeMillis;
                if ((remainingGlobalTimeMillis = globalTimeoutMillis - (elapsedGlobalTimeMillis = (currentTimeMillis = SystemClock.uptimeMillis()) - startTimeMillis)) <= 0L) {
                    throw new TimeoutException("No idle state with idle timeout: " + idleTimeoutMillis + " within global timeout: " + globalTimeoutMillis);
                }
                long elapsedIdleTimeMillis = currentTimeMillis - this.mLastEventTimeMillis;
                long remainingIdleTimeMillis = idleTimeoutMillis - elapsedIdleTimeMillis;
                if (remainingIdleTimeMillis <= 0L) {
                    return;
                }
                try {
                    this.mLock.wait(remainingIdleTimeMillis);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap $$robo$$android_app_UiAutomation$takeScreenshot() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        Display display = DisplayManagerGlobal.getInstance().getRealDisplay(0);
        Point displaySize = new Point();
        display.getRealSize(displaySize);
        int rotation = display.getRotation();
        Bitmap screenShot = null;
        try {
            screenShot = this.mUiAutomationConnection.takeScreenshot(new Rect(0, 0, displaySize.x, displaySize.y), rotation);
            if (screenShot == null) {
                return null;
            }
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while taking screnshot!", re);
            return null;
        }
        screenShot.setHasAlpha(false);
        return screenShot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomation$setRunAsMonkey(boolean enable) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            ActivityManager.getService().setUserIsMonkey(enable);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error while setting run as monkey!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomation$clearWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.clearWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window content frame stats!", re);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WindowContentFrameStats $$robo$$android_app_UiAutomation$getWindowContentFrameStats(int windowId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowContentFrameStats(windowId);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window content frame stats!", re);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomation$clearWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.clearWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error clearing window animation frame stats!", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WindowAnimationFrameStats $$robo$$android_app_UiAutomation$getWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            return this.mUiAutomationConnection.getWindowAnimationFrameStats();
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error getting window animation frame stats!", re);
            return null;
        }
    }

    private final void $$robo$$android_app_UiAutomation$grantRuntimePermission(String packageName, String permission2) {
        this.grantRuntimePermissionAsUser(packageName, permission2, Process.myUserHandle());
    }

    @Deprecated
    private final boolean $$robo$$android_app_UiAutomation$grantRuntimePermission(String packageName, String permission2, UserHandle userHandle) {
        this.grantRuntimePermissionAsUser(packageName, permission2, userHandle);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomation$grantRuntimePermissionAsUser(String packageName, String permission2, UserHandle userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.grantRuntimePermission(packageName, permission2, userHandle.getIdentifier());
        }
        catch (Exception e) {
            throw new SecurityException("Error granting runtime permission", e);
        }
    }

    private final void $$robo$$android_app_UiAutomation$revokeRuntimePermission(String packageName, String permission2) {
        this.revokeRuntimePermissionAsUser(packageName, permission2, Process.myUserHandle());
    }

    @Deprecated
    private final boolean $$robo$$android_app_UiAutomation$revokeRuntimePermission(String packageName, String permission2, UserHandle userHandle) {
        this.revokeRuntimePermissionAsUser(packageName, permission2, userHandle);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomation$revokeRuntimePermissionAsUser(String packageName, String permission2, UserHandle userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        try {
            this.mUiAutomationConnection.revokeRuntimePermission(packageName, permission2, userHandle.getIdentifier());
        }
        catch (Exception e) {
            throw new SecurityException("Error granting runtime permission", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final ParcelFileDescriptor $$robo$$android_app_UiAutomation$executeShellCommand(String command) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        this.warnIfBetterCommand(command);
        ParcelFileDescriptor source = null;
        ParcelFileDescriptor sink = null;
        try {
            ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
            source = pipe[0];
            sink = pipe[1];
            this.mUiAutomationConnection.executeShellCommand(command, sink, null);
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Error executing shell command!", ioe);
            IoUtils.closeQuietly(sink);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing shell command!", re);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(sink);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(sink);
        }
        IoUtils.closeQuietly(sink);
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final ParcelFileDescriptor[] $$robo$$android_app_UiAutomation$executeShellCommandRw(String command) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotConnectedLocked();
        }
        this.warnIfBetterCommand(command);
        ParcelFileDescriptor source_read = null;
        ParcelFileDescriptor sink_read = null;
        ParcelFileDescriptor source_write = null;
        ParcelFileDescriptor sink_write = null;
        try {
            ParcelFileDescriptor[] pipe_read = ParcelFileDescriptor.createPipe();
            source_read = pipe_read[0];
            sink_read = pipe_read[1];
            ParcelFileDescriptor[] pipe_write = ParcelFileDescriptor.createPipe();
            source_write = pipe_write[0];
            sink_write = pipe_write[1];
            this.mUiAutomationConnection.executeShellCommand(command, sink_read, source_write);
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Error executing shell command!", ioe);
            IoUtils.closeQuietly(sink_read);
            IoUtils.closeQuietly(source_write);
        }
        catch (RemoteException re) {
            Log.e(LOG_TAG, "Error executing shell command!", re);
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(sink_read);
                    IoUtils.closeQuietly(source_write);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(sink_read);
            IoUtils.closeQuietly(source_write);
        }
        IoUtils.closeQuietly(sink_read);
        IoUtils.closeQuietly(source_write);
        ParcelFileDescriptor[] result = new ParcelFileDescriptor[]{source_read, sink_write};
        return result;
    }

    private static final float $$robo$$android_app_UiAutomation$getDegreesForRotation(int value) {
        switch (value) {
            case 1: {
                return 270.0f;
            }
            case 2: {
                return 180.0f;
            }
            case 3: {
                return 90.0f;
            }
        }
        return 0.0f;
    }

    private final boolean $$robo$$android_app_UiAutomation$isConnectedLocked() {
        return this.mConnectionId != -1;
    }

    private final void $$robo$$android_app_UiAutomation$throwIfConnectedLocked() {
        if (this.mConnectionId != -1) {
            throw new IllegalStateException("UiAutomation not connected!");
        }
    }

    private final void $$robo$$android_app_UiAutomation$throwIfNotConnectedLocked() {
        if (!this.isConnectedLocked()) {
            throw new IllegalStateException("UiAutomation not connected!");
        }
    }

    private final void $$robo$$android_app_UiAutomation$warnIfBetterCommand(String cmd) {
        if (cmd.startsWith("pm grant ")) {
            Log.w(LOG_TAG, "UiAutomation.grantRuntimePermission() is more robust and should be used instead of 'pm grant'");
        } else if (cmd.startsWith("pm revoke ")) {
            Log.w(LOG_TAG, "UiAutomation.revokeRuntimePermission() is more robust and should be used instead of 'pm revoke'");
        }
    }

    static void __staticInitializer__() {
        LOG_TAG = UiAutomation.class.getSimpleName();
    }

    private void __constructor__(Looper looper, IUiAutomationConnection iUiAutomationConnection) {
        this.$$robo$$android_app_UiAutomation$__constructor__(looper, iUiAutomationConnection);
    }

    public UiAutomation(Looper looper, IUiAutomationConnection iUiAutomationConnection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_UiAutomation$__constructor__(android.os.Looper android.app.IUiAutomationConnection ), this, looper, iUiAutomationConnection);
    }

    public void connect() {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_app_UiAutomation$connect(), this);
    }

    public void connect(int n) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_app_UiAutomation$connect(int ), this, n);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_app_UiAutomation$getFlags(), this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_app_UiAutomation$disconnect(), this);
    }

    public int getConnectionId() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionId", $$robo$$android_app_UiAutomation$getConnectionId(), this);
    }

    public boolean isDestroyed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDestroyed", $$robo$$android_app_UiAutomation$isDestroyed(), this);
    }

    public void setOnAccessibilityEventListener(OnAccessibilityEventListener onAccessibilityEventListener) {
        InvokeDynamicSupport.bootstrap("setOnAccessibilityEventListener", $$robo$$android_app_UiAutomation$setOnAccessibilityEventListener(android.app.UiAutomation$OnAccessibilityEventListener ), this, onAccessibilityEventListener);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_app_UiAutomation$destroy(), this);
    }

    public boolean performGlobalAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performGlobalAction", $$robo$$android_app_UiAutomation$performGlobalAction(int ), this, n);
    }

    public AccessibilityNodeInfo findFocus(int n) {
        return InvokeDynamicSupport.bootstrap("findFocus", $$robo$$android_app_UiAutomation$findFocus(int ), this, n);
    }

    public AccessibilityServiceInfo getServiceInfo() {
        return InvokeDynamicSupport.bootstrap("getServiceInfo", $$robo$$android_app_UiAutomation$getServiceInfo(), this);
    }

    public void setServiceInfo(AccessibilityServiceInfo accessibilityServiceInfo) {
        InvokeDynamicSupport.bootstrap("setServiceInfo", $$robo$$android_app_UiAutomation$setServiceInfo(android.accessibilityservice.AccessibilityServiceInfo ), this, accessibilityServiceInfo);
    }

    public List<AccessibilityWindowInfo> getWindows() {
        return InvokeDynamicSupport.bootstrap("getWindows", $$robo$$android_app_UiAutomation$getWindows(), this);
    }

    public AccessibilityNodeInfo getRootInActiveWindow() {
        return InvokeDynamicSupport.bootstrap("getRootInActiveWindow", $$robo$$android_app_UiAutomation$getRootInActiveWindow(), this);
    }

    public boolean injectInputEvent(InputEvent inputEvent, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$android_app_UiAutomation$injectInputEvent(android.view.InputEvent boolean ), this, inputEvent, bl);
    }

    public boolean setRotation(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRotation", $$robo$$android_app_UiAutomation$setRotation(int ), this, n);
    }

    public AccessibilityEvent executeAndWaitForEvent(Runnable runnable, AccessibilityEventFilter accessibilityEventFilter, long l) throws TimeoutException {
        return InvokeDynamicSupport.bootstrap("executeAndWaitForEvent", $$robo$$android_app_UiAutomation$executeAndWaitForEvent(java.lang.Runnable android.app.UiAutomation$AccessibilityEventFilter long ), this, runnable, accessibilityEventFilter, l);
    }

    public void waitForIdle(long l, long l2) throws TimeoutException {
        InvokeDynamicSupport.bootstrap("waitForIdle", $$robo$$android_app_UiAutomation$waitForIdle(long long ), this, l, l2);
    }

    public Bitmap takeScreenshot() {
        return InvokeDynamicSupport.bootstrap("takeScreenshot", $$robo$$android_app_UiAutomation$takeScreenshot(), this);
    }

    public void setRunAsMonkey(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRunAsMonkey", $$robo$$android_app_UiAutomation$setRunAsMonkey(boolean ), this, bl);
    }

    public boolean clearWindowContentFrameStats(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearWindowContentFrameStats", $$robo$$android_app_UiAutomation$clearWindowContentFrameStats(int ), this, n);
    }

    public WindowContentFrameStats getWindowContentFrameStats(int n) {
        return InvokeDynamicSupport.bootstrap("getWindowContentFrameStats", $$robo$$android_app_UiAutomation$getWindowContentFrameStats(int ), this, n);
    }

    public void clearWindowAnimationFrameStats() {
        InvokeDynamicSupport.bootstrap("clearWindowAnimationFrameStats", $$robo$$android_app_UiAutomation$clearWindowAnimationFrameStats(), this);
    }

    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        return InvokeDynamicSupport.bootstrap("getWindowAnimationFrameStats", $$robo$$android_app_UiAutomation$getWindowAnimationFrameStats(), this);
    }

    public void grantRuntimePermission(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("grantRuntimePermission", $$robo$$android_app_UiAutomation$grantRuntimePermission(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Deprecated
    public boolean grantRuntimePermission(String string2, String string3, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("grantRuntimePermission", $$robo$$android_app_UiAutomation$grantRuntimePermission(java.lang.String java.lang.String android.os.UserHandle ), this, string2, string3, userHandle);
    }

    public void grantRuntimePermissionAsUser(String string2, String string3, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("grantRuntimePermissionAsUser", $$robo$$android_app_UiAutomation$grantRuntimePermissionAsUser(java.lang.String java.lang.String android.os.UserHandle ), this, string2, string3, userHandle);
    }

    public void revokeRuntimePermission(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("revokeRuntimePermission", $$robo$$android_app_UiAutomation$revokeRuntimePermission(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Deprecated
    public boolean revokeRuntimePermission(String string2, String string3, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("revokeRuntimePermission", $$robo$$android_app_UiAutomation$revokeRuntimePermission(java.lang.String java.lang.String android.os.UserHandle ), this, string2, string3, userHandle);
    }

    public void revokeRuntimePermissionAsUser(String string2, String string3, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("revokeRuntimePermissionAsUser", $$robo$$android_app_UiAutomation$revokeRuntimePermissionAsUser(java.lang.String java.lang.String android.os.UserHandle ), this, string2, string3, userHandle);
    }

    public ParcelFileDescriptor executeShellCommand(String string2) {
        return InvokeDynamicSupport.bootstrap("executeShellCommand", $$robo$$android_app_UiAutomation$executeShellCommand(java.lang.String ), this, string2);
    }

    public ParcelFileDescriptor[] executeShellCommandRw(String string2) {
        return InvokeDynamicSupport.bootstrap("executeShellCommandRw", $$robo$$android_app_UiAutomation$executeShellCommandRw(java.lang.String ), this, string2);
    }

    private static float getDegreesForRotation(int n) {
        return (float)InvokeDynamicSupport.bootstrapStatic("getDegreesForRotation", $$robo$$android_app_UiAutomation$getDegreesForRotation(int ), (int)n);
    }

    private boolean isConnectedLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectedLocked", $$robo$$android_app_UiAutomation$isConnectedLocked(), this);
    }

    private void throwIfConnectedLocked() {
        InvokeDynamicSupport.bootstrap("throwIfConnectedLocked", $$robo$$android_app_UiAutomation$throwIfConnectedLocked(), this);
    }

    private void throwIfNotConnectedLocked() {
        InvokeDynamicSupport.bootstrap("throwIfNotConnectedLocked", $$robo$$android_app_UiAutomation$throwIfNotConnectedLocked(), this);
    }

    private void warnIfBetterCommand(String string2) {
        InvokeDynamicSupport.bootstrap("warnIfBetterCommand", $$robo$$android_app_UiAutomation$warnIfBetterCommand(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(UiAutomation.class);
    }

    public /* synthetic */ UiAutomation() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiAutomation)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class IAccessibilityServiceClientImpl
    extends AccessibilityService.IAccessibilityServiceClientWrapper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ UiAutomation this$0;

        private void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl$__constructor__(UiAutomation uiAutomation, Looper looper) {
            this.this$0 = uiAutomation;
        }

        private void __constructor__(UiAutomation uiAutomation, Looper looper) {
            this.$$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl$__constructor__(uiAutomation, looper);
        }

        public IAccessibilityServiceClientImpl(UiAutomation uiAutomation, Looper looper) {
            super(null, looper, new AccessibilityService.Callbacks(uiAutomation){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ UiAutomation val$this$0;

                private void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$__constructor__(UiAutomation uiAutomation) {
                    this.val$this$0 = uiAutomation;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$init(int connectionId, IBinder windowToken) {
                    Object object = this.val$this$0.mLock;
                    synchronized (object) {
                        this.val$this$0.mConnectionId = connectionId;
                        this.val$this$0.mLock.notifyAll();
                    }
                }

                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onServiceConnected() {
                }

                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onInterrupt() {
                }

                private final boolean $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onGesture(int gestureId) {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onAccessibilityEvent(AccessibilityEvent event) {
                    OnAccessibilityEventListener listener;
                    Object object = this.val$this$0.mLock;
                    synchronized (object) {
                        this.val$this$0.mLastEventTimeMillis = event.getEventTime();
                        if (this.val$this$0.mWaitingForEventDelivery) {
                            this.val$this$0.mEventQueue.add(AccessibilityEvent.obtain(event));
                        }
                        this.val$this$0.mLock.notifyAll();
                        listener = this.val$this$0.mOnAccessibilityEventListener;
                    }
                    if (listener != null) {
                        this.val$this$0.mLocalCallbackHandler.post(PooledLambda.obtainRunnable(OnAccessibilityEventListener::onAccessibilityEvent, listener, AccessibilityEvent.obtain(event)).recycleOnUse());
                    }
                }

                private final boolean $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onKeyEvent(KeyEvent event) {
                    return false;
                }

                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onMagnificationChanged(Region region, float scale, float centerX, float centerY) {
                }

                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onSoftKeyboardShowModeChanged(int showMode) {
                }

                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onPerformGestureResult(int sequence, boolean completedSuccessfully) {
                }

                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onFingerprintCapturingGesturesChanged(boolean active) {
                }

                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onFingerprintGesture(int gesture) {
                }

                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onAccessibilityButtonClicked() {
                }

                private final void $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onAccessibilityButtonAvailabilityChanged(boolean available) {
                }

                private void __constructor__(UiAutomation uiAutomation) {
                    this.$$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$__constructor__(uiAutomation);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$__constructor__(android.app.UiAutomation ), this, uiAutomation);
                }

                @Override
                public void init(int n, IBinder iBinder) {
                    InvokeDynamicSupport.bootstrap("init", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$init(int android.os.IBinder ), this, n, iBinder);
                }

                @Override
                public void onServiceConnected() {
                    InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onServiceConnected(), this);
                }

                @Override
                public void onInterrupt() {
                    InvokeDynamicSupport.bootstrap("onInterrupt", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onInterrupt(), this);
                }

                @Override
                public boolean onGesture(int n) {
                    return (boolean)InvokeDynamicSupport.bootstrap("onGesture", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onGesture(int ), this, n);
                }

                @Override
                public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
                    InvokeDynamicSupport.bootstrap("onAccessibilityEvent", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
                }

                @Override
                public boolean onKeyEvent(KeyEvent keyEvent) {
                    return (boolean)InvokeDynamicSupport.bootstrap("onKeyEvent", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onKeyEvent(android.view.KeyEvent ), this, keyEvent);
                }

                @Override
                public void onMagnificationChanged(Region region, float f, float f2, float f3) {
                    InvokeDynamicSupport.bootstrap("onMagnificationChanged", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onMagnificationChanged(android.graphics.Region float float float ), this, region, f, f2, f3);
                }

                @Override
                public void onSoftKeyboardShowModeChanged(int n) {
                    InvokeDynamicSupport.bootstrap("onSoftKeyboardShowModeChanged", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onSoftKeyboardShowModeChanged(int ), this, n);
                }

                @Override
                public void onPerformGestureResult(int n, boolean bl) {
                    InvokeDynamicSupport.bootstrap("onPerformGestureResult", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onPerformGestureResult(int boolean ), this, n, bl);
                }

                @Override
                public void onFingerprintCapturingGesturesChanged(boolean bl) {
                    InvokeDynamicSupport.bootstrap("onFingerprintCapturingGesturesChanged", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onFingerprintCapturingGesturesChanged(boolean ), this, bl);
                }

                @Override
                public void onFingerprintGesture(int n) {
                    InvokeDynamicSupport.bootstrap("onFingerprintGesture", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onFingerprintGesture(int ), this, n);
                }

                @Override
                public void onAccessibilityButtonClicked() {
                    InvokeDynamicSupport.bootstrap("onAccessibilityButtonClicked", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onAccessibilityButtonClicked(), this);
                }

                @Override
                public void onAccessibilityButtonAvailabilityChanged(boolean bl) {
                    InvokeDynamicSupport.bootstrap("onAccessibilityButtonAvailabilityChanged", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl_1$onAccessibilityButtonAvailabilityChanged(boolean ), this, bl);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_UiAutomation_IAccessibilityServiceClientImpl$__constructor__(android.app.UiAutomation android.os.Looper ), this, uiAutomation, looper);
        }

        public /* synthetic */ IAccessibilityServiceClientImpl() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IAccessibilityServiceClientImpl)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface AccessibilityEventFilter {
        public boolean accept(AccessibilityEvent var1);
    }

    public static interface OnAccessibilityEventListener {
        public void onAccessibilityEvent(AccessibilityEvent var1);
    }
}

