/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.app.IUiAutomationConnection;
import android.content.pm.IPackageManager;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.hardware.input.InputManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.Log;
import android.view.IWindowManager;
import android.view.InputEvent;
import android.view.SurfaceControl;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.IAccessibilityManager;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UiAutomationConnection
extends IUiAutomationConnection.Stub
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "UiAutomationConnection";
    private static int INITIAL_FROZEN_ROTATION_UNSPECIFIED = -1;
    private IWindowManager mWindowManager;
    private IAccessibilityManager mAccessibilityManager;
    private IPackageManager mPackageManager;
    private Object mLock;
    private Binder mToken;
    private int mInitialFrozenRotation;
    private IAccessibilityServiceClient mClient;
    private boolean mIsShutdown;
    private int mOwningUid;

    private void $$robo$$android_app_UiAutomationConnection$__constructor__() {
        this.mWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mAccessibilityManager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        this.mLock = new Object();
        this.mToken = new Binder();
        this.mInitialFrozenRotation = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$connect(IAccessibilityServiceClient client, int flags) {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null!");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfShutdownLocked();
            if (this.isConnectedLocked()) {
                throw new IllegalStateException("Already connected.");
            }
            this.mOwningUid = Binder.getCallingUid();
            this.registerUiTestAutomationServiceLocked(client, flags);
            this.storeRotationStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            if (!this.isConnectedLocked()) {
                throw new IllegalStateException("Already disconnected.");
            }
            this.mOwningUid = -1;
            this.unregisterUiTestAutomationServiceLocked();
            this.restoreRotationStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomationConnection$injectInputEvent(InputEvent event, boolean sync) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int mode = sync ? 2 : 0;
        long identity = Binder.clearCallingIdentity();
        try {
            boolean bl = InputManager.getInstance().injectInputEvent(event, mode);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomationConnection$setRotation(int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (rotation == -2) {
                this.mWindowManager.thawRotation();
            } else {
                this.mWindowManager.freezeRotation(rotation);
            }
            boolean bl = true;
            return bl;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap $$robo$$android_app_UiAutomationConnection$takeScreenshot(Rect crop, int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            int width = crop.width();
            int height = crop.height();
            Bitmap bitmap = SurfaceControl.screenshot(crop, width, height, rotation);
            return bitmap;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_app_UiAutomationConnection$clearWindowContentFrameStats(int windowId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int callingUserId = UserHandle.getCallingUserId();
        long identity = Binder.clearCallingIdentity();
        try {
            IBinder token = this.mAccessibilityManager.getWindowToken(windowId, callingUserId);
            if (token == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mWindowManager.clearWindowContentFrameStats(token);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WindowContentFrameStats $$robo$$android_app_UiAutomationConnection$getWindowContentFrameStats(int windowId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int callingUserId = UserHandle.getCallingUserId();
        long identity = Binder.clearCallingIdentity();
        try {
            IBinder token = this.mAccessibilityManager.getWindowToken(windowId, callingUserId);
            if (token == null) {
                WindowContentFrameStats windowContentFrameStats = null;
                return windowContentFrameStats;
            }
            WindowContentFrameStats windowContentFrameStats = this.mWindowManager.getWindowContentFrameStats(token);
            return windowContentFrameStats;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$clearWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            SurfaceControl.clearAnimationFrameStats();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WindowAnimationFrameStats $$robo$$android_app_UiAutomationConnection$getWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            WindowAnimationFrameStats stats = new WindowAnimationFrameStats();
            SurfaceControl.getAnimationFrameStats(stats);
            WindowAnimationFrameStats windowAnimationFrameStats = stats;
            return windowAnimationFrameStats;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$grantRuntimePermission(String packageName, String permission2, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.mPackageManager.grantRuntimePermission(packageName, permission2, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$revokeRuntimePermission(String packageName, String permission2, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.mPackageManager.revokeRuntimePermission(packageName, permission2, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$executeShellCommand(String command, ParcelFileDescriptor sink, ParcelFileDescriptor source) throws RemoteException {
        Thread writeToProcess;
        Thread readFromProcess;
        Process process;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        try {
            process = Runtime.getRuntime().exec(command);
        }
        catch (IOException exc) {
            throw new RuntimeException("Error running shell command '" + command + "'", exc);
        }
        if (sink != null) {
            InputStream sink_in = process.getInputStream();
            FileOutputStream sink_out = new FileOutputStream(sink.getFileDescriptor());
            readFromProcess = new Thread(new Repeater(this, sink_in, sink_out));
            readFromProcess.start();
        } else {
            readFromProcess = null;
        }
        if (source != null) {
            OutputStream source_out = process.getOutputStream();
            FileInputStream source_in = new FileInputStream(source.getFileDescriptor());
            writeToProcess = new Thread(new Repeater(this, source_in, source_out));
            writeToProcess.start();
        } else {
            writeToProcess = null;
        }
        Thread cleanup = new Thread(new Runnable(this, writeToProcess, readFromProcess, sink, source, process){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Thread val$writeToProcess;
            /* synthetic */ Thread val$readFromProcess;
            /* synthetic */ ParcelFileDescriptor val$sink;
            /* synthetic */ ParcelFileDescriptor val$source;
            /* synthetic */ Process val$process;
            /* synthetic */ UiAutomationConnection this$0;

            private void $$robo$$android_app_UiAutomationConnection_1$__constructor__(UiAutomationConnection this$0, Thread thread, Thread thread2, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, Process process) {
                this.this$0 = this$0;
                this.val$writeToProcess = thread;
                this.val$readFromProcess = thread2;
                this.val$sink = parcelFileDescriptor;
                this.val$source = parcelFileDescriptor2;
                this.val$process = process;
            }

            private final void $$robo$$android_app_UiAutomationConnection_1$run() {
                try {
                    if (this.val$writeToProcess != null) {
                        this.val$writeToProcess.join();
                    }
                    if (this.val$readFromProcess != null) {
                        this.val$readFromProcess.join();
                    }
                }
                catch (InterruptedException exc) {
                    Log.e("UiAutomationConnection", "At least one of the threads was interrupted");
                }
                IoUtils.closeQuietly(this.val$sink);
                IoUtils.closeQuietly(this.val$source);
                this.val$process.destroy();
            }

            private void __constructor__(UiAutomationConnection uiAutomationConnection, Thread thread, Thread thread2, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2, Process process) {
                this.$$robo$$android_app_UiAutomationConnection_1$__constructor__(uiAutomationConnection, thread, thread2, parcelFileDescriptor, parcelFileDescriptor2, process);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_UiAutomationConnection_1$__constructor__(android.app.UiAutomationConnection java.lang.Thread java.lang.Thread android.os.ParcelFileDescriptor android.os.ParcelFileDescriptor java.lang.Process ), this, uiAutomationConnection, thread, thread2, parcelFileDescriptor, parcelFileDescriptor2, process);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_UiAutomationConnection_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        cleanup.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_app_UiAutomationConnection$shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isConnectedLocked()) {
                this.throwIfCalledByNotTrustedUidLocked();
            }
            this.throwIfShutdownLocked();
            this.mIsShutdown = true;
            if (this.isConnectedLocked()) {
                this.disconnect();
            }
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$registerUiTestAutomationServiceLocked(IAccessibilityServiceClient client, int flags) {
        IAccessibilityManager manager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        AccessibilityServiceInfo info = new AccessibilityServiceInfo();
        info.eventTypes = -1;
        info.feedbackType = 16;
        info.flags |= 0x10012;
        info.setCapabilities(15);
        try {
            manager.registerUiTestAutomationService(this.mToken, client, info, flags);
            this.mClient = client;
        }
        catch (RemoteException re) {
            throw new IllegalStateException("Error while registering UiTestAutomationService.", re);
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$unregisterUiTestAutomationServiceLocked() {
        IAccessibilityManager manager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        try {
            manager.unregisterUiTestAutomationService(this.mClient);
            this.mClient = null;
        }
        catch (RemoteException re) {
            throw new IllegalStateException("Error while unregistering UiTestAutomationService", re);
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$storeRotationStateLocked() {
        try {
            if (this.mWindowManager.isRotationFrozen()) {
                this.mInitialFrozenRotation = this.mWindowManager.getDefaultDisplayRotation();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$restoreRotationStateLocked() {
        try {
            if (this.mInitialFrozenRotation != -1) {
                this.mWindowManager.freezeRotation(this.mInitialFrozenRotation);
            } else {
                this.mWindowManager.thawRotation();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_app_UiAutomationConnection$isConnectedLocked() {
        return this.mClient != null;
    }

    private final void $$robo$$android_app_UiAutomationConnection$throwIfShutdownLocked() {
        if (this.mIsShutdown) {
            throw new IllegalStateException("Connection shutdown!");
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$throwIfNotConnectedLocked() {
        if (!this.isConnectedLocked()) {
            throw new IllegalStateException("Not connected!");
        }
    }

    private final void $$robo$$android_app_UiAutomationConnection$throwIfCalledByNotTrustedUidLocked() {
        int callingUid = Binder.getCallingUid();
        if (callingUid != this.mOwningUid && this.mOwningUid != 1000 && callingUid != 0) {
            throw new SecurityException("Calling from not trusted UID!");
        }
    }

    private void __constructor__() {
        this.$$robo$$android_app_UiAutomationConnection$__constructor__();
    }

    public UiAutomationConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_UiAutomationConnection$__constructor__(), this);
    }

    @Override
    public void connect(IAccessibilityServiceClient iAccessibilityServiceClient, int n) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_app_UiAutomationConnection$connect(android.accessibilityservice.IAccessibilityServiceClient int ), this, iAccessibilityServiceClient, n);
    }

    @Override
    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_app_UiAutomationConnection$disconnect(), this);
    }

    @Override
    public boolean injectInputEvent(InputEvent inputEvent, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("injectInputEvent", $$robo$$android_app_UiAutomationConnection$injectInputEvent(android.view.InputEvent boolean ), this, inputEvent, bl);
    }

    @Override
    public boolean setRotation(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRotation", $$robo$$android_app_UiAutomationConnection$setRotation(int ), this, n);
    }

    @Override
    public Bitmap takeScreenshot(Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("takeScreenshot", $$robo$$android_app_UiAutomationConnection$takeScreenshot(android.graphics.Rect int ), this, rect, n);
    }

    @Override
    public boolean clearWindowContentFrameStats(int n) throws RemoteException {
        return (boolean)InvokeDynamicSupport.bootstrap("clearWindowContentFrameStats", $$robo$$android_app_UiAutomationConnection$clearWindowContentFrameStats(int ), this, n);
    }

    @Override
    public WindowContentFrameStats getWindowContentFrameStats(int n) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getWindowContentFrameStats", $$robo$$android_app_UiAutomationConnection$getWindowContentFrameStats(int ), this, n);
    }

    @Override
    public void clearWindowAnimationFrameStats() {
        InvokeDynamicSupport.bootstrap("clearWindowAnimationFrameStats", $$robo$$android_app_UiAutomationConnection$clearWindowAnimationFrameStats(), this);
    }

    @Override
    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        return InvokeDynamicSupport.bootstrap("getWindowAnimationFrameStats", $$robo$$android_app_UiAutomationConnection$getWindowAnimationFrameStats(), this);
    }

    @Override
    public void grantRuntimePermission(String string2, String string3, int n) throws RemoteException {
        InvokeDynamicSupport.bootstrap("grantRuntimePermission", $$robo$$android_app_UiAutomationConnection$grantRuntimePermission(java.lang.String java.lang.String int ), this, string2, string3, n);
    }

    @Override
    public void revokeRuntimePermission(String string2, String string3, int n) throws RemoteException {
        InvokeDynamicSupport.bootstrap("revokeRuntimePermission", $$robo$$android_app_UiAutomationConnection$revokeRuntimePermission(java.lang.String java.lang.String int ), this, string2, string3, n);
    }

    @Override
    public void executeShellCommand(String string2, ParcelFileDescriptor parcelFileDescriptor, ParcelFileDescriptor parcelFileDescriptor2) throws RemoteException {
        InvokeDynamicSupport.bootstrap("executeShellCommand", $$robo$$android_app_UiAutomationConnection$executeShellCommand(java.lang.String android.os.ParcelFileDescriptor android.os.ParcelFileDescriptor ), this, string2, parcelFileDescriptor, parcelFileDescriptor2);
    }

    @Override
    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_app_UiAutomationConnection$shutdown(), this);
    }

    private void registerUiTestAutomationServiceLocked(IAccessibilityServiceClient iAccessibilityServiceClient, int n) {
        InvokeDynamicSupport.bootstrap("registerUiTestAutomationServiceLocked", $$robo$$android_app_UiAutomationConnection$registerUiTestAutomationServiceLocked(android.accessibilityservice.IAccessibilityServiceClient int ), this, iAccessibilityServiceClient, n);
    }

    private void unregisterUiTestAutomationServiceLocked() {
        InvokeDynamicSupport.bootstrap("unregisterUiTestAutomationServiceLocked", $$robo$$android_app_UiAutomationConnection$unregisterUiTestAutomationServiceLocked(), this);
    }

    private void storeRotationStateLocked() {
        InvokeDynamicSupport.bootstrap("storeRotationStateLocked", $$robo$$android_app_UiAutomationConnection$storeRotationStateLocked(), this);
    }

    private void restoreRotationStateLocked() {
        InvokeDynamicSupport.bootstrap("restoreRotationStateLocked", $$robo$$android_app_UiAutomationConnection$restoreRotationStateLocked(), this);
    }

    private boolean isConnectedLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnectedLocked", $$robo$$android_app_UiAutomationConnection$isConnectedLocked(), this);
    }

    private void throwIfShutdownLocked() {
        InvokeDynamicSupport.bootstrap("throwIfShutdownLocked", $$robo$$android_app_UiAutomationConnection$throwIfShutdownLocked(), this);
    }

    private void throwIfNotConnectedLocked() {
        InvokeDynamicSupport.bootstrap("throwIfNotConnectedLocked", $$robo$$android_app_UiAutomationConnection$throwIfNotConnectedLocked(), this);
    }

    private void throwIfCalledByNotTrustedUidLocked() {
        InvokeDynamicSupport.bootstrap("throwIfCalledByNotTrustedUidLocked", $$robo$$android_app_UiAutomationConnection$throwIfCalledByNotTrustedUidLocked(), this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UiAutomationConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Repeater
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private InputStream readFrom;
        private OutputStream writeTo;
        /* synthetic */ UiAutomationConnection this$0;

        private void $$robo$$android_app_UiAutomationConnection_Repeater$__constructor__(UiAutomationConnection this$0, InputStream readFrom, OutputStream writeTo) {
            this.this$0 = this$0;
            this.readFrom = readFrom;
            this.writeTo = writeTo;
        }

        private final void $$robo$$android_app_UiAutomationConnection_Repeater$run() {
            try {
                int readByteCount;
                byte[] buffer = new byte[8192];
                while ((readByteCount = this.readFrom.read(buffer)) >= 0) {
                    this.writeTo.write(buffer, 0, readByteCount);
                    this.writeTo.flush();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error while reading/writing ", ioe);
            }
            finally {
                IoUtils.closeQuietly(this.readFrom);
                IoUtils.closeQuietly(this.writeTo);
            }
        }

        private void __constructor__(UiAutomationConnection uiAutomationConnection, InputStream inputStream, OutputStream outputStream) {
            this.$$robo$$android_app_UiAutomationConnection_Repeater$__constructor__(uiAutomationConnection, inputStream, outputStream);
        }

        public Repeater(UiAutomationConnection uiAutomationConnection, InputStream inputStream, OutputStream outputStream) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_UiAutomationConnection_Repeater$__constructor__(android.app.UiAutomationConnection java.io.InputStream java.io.OutputStream ), this, uiAutomationConnection, inputStream, outputStream);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_app_UiAutomationConnection_Repeater$run(), this);
        }

        public /* synthetic */ Repeater() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Repeater)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

