/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class WindowConfiguration
implements Parcelable,
Comparable<WindowConfiguration> {
    public /* synthetic */ Object __robo_data__;
    private Rect mBounds;
    private Rect mAppBounds;
    @WindowingMode
    private int mWindowingMode;
    public static int WINDOWING_MODE_UNDEFINED = 0;
    public static int WINDOWING_MODE_FULLSCREEN = 1;
    public static int WINDOWING_MODE_PINNED = 2;
    public static int WINDOWING_MODE_SPLIT_SCREEN_PRIMARY = 3;
    public static int WINDOWING_MODE_SPLIT_SCREEN_SECONDARY = 4;
    public static int WINDOWING_MODE_FULLSCREEN_OR_SPLIT_SCREEN_SECONDARY = 4;
    public static int WINDOWING_MODE_FREEFORM = 5;
    @ActivityType
    private int mActivityType;
    public static int ACTIVITY_TYPE_UNDEFINED = 0;
    public static int ACTIVITY_TYPE_STANDARD = 1;
    public static int ACTIVITY_TYPE_HOME = 2;
    public static int ACTIVITY_TYPE_RECENTS = 3;
    public static int ACTIVITY_TYPE_ASSISTANT = 4;
    public static int WINDOW_CONFIG_BOUNDS = 1;
    public static int WINDOW_CONFIG_APP_BOUNDS = 2;
    public static int WINDOW_CONFIG_WINDOWING_MODE = 4;
    public static int WINDOW_CONFIG_ACTIVITY_TYPE = 8;
    public static int PINNED_WINDOWING_MODE_ELEVATION_IN_DIP = 5;
    public static Parcelable.Creator<WindowConfiguration> CREATOR;

    private void $$robo$$android_app_WindowConfiguration$__constructor__() {
        this.mBounds = new Rect();
        this.unset();
    }

    private void $$robo$$android_app_WindowConfiguration$__constructor__(WindowConfiguration configuration) {
        this.mBounds = new Rect();
        this.setTo(configuration);
    }

    private void $$robo$$android_app_WindowConfiguration$__constructor__(Parcel in) {
        this.mBounds = new Rect();
        this.readFromParcel(in);
    }

    private final void $$robo$$android_app_WindowConfiguration$writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mBounds, flags);
        dest.writeParcelable(this.mAppBounds, flags);
        dest.writeInt(this.mWindowingMode);
        dest.writeInt(this.mActivityType);
    }

    private final void $$robo$$android_app_WindowConfiguration$readFromParcel(Parcel source) {
        this.mBounds = (Rect)source.readParcelable(Rect.class.getClassLoader());
        this.mAppBounds = (Rect)source.readParcelable(Rect.class.getClassLoader());
        this.mWindowingMode = source.readInt();
        this.mActivityType = source.readInt();
    }

    private final int $$robo$$android_app_WindowConfiguration$describeContents() {
        return 0;
    }

    private final void $$robo$$android_app_WindowConfiguration$setBounds(Rect rect) {
        if (rect == null) {
            this.mBounds.setEmpty();
            return;
        }
        this.mBounds.set(rect);
    }

    private final void $$robo$$android_app_WindowConfiguration$setAppBounds(Rect rect) {
        if (rect == null) {
            this.mAppBounds = null;
            return;
        }
        this.setAppBounds(rect.left, rect.top, rect.right, rect.bottom);
    }

    private final void $$robo$$android_app_WindowConfiguration$setAppBounds(int left, int top, int right, int bottom) {
        if (this.mAppBounds == null) {
            this.mAppBounds = new Rect();
        }
        this.mAppBounds.set(left, top, right, bottom);
    }

    private final Rect $$robo$$android_app_WindowConfiguration$getAppBounds() {
        return this.mAppBounds;
    }

    private final Rect $$robo$$android_app_WindowConfiguration$getBounds() {
        return this.mBounds;
    }

    private final void $$robo$$android_app_WindowConfiguration$setWindowingMode(@WindowingMode int windowingMode) {
        this.mWindowingMode = windowingMode;
    }

    @WindowingMode
    private final int $$robo$$android_app_WindowConfiguration$getWindowingMode() {
        return this.mWindowingMode;
    }

    private final void $$robo$$android_app_WindowConfiguration$setActivityType(@ActivityType int activityType) {
        if (this.mActivityType == activityType) {
            return;
        }
        if (ActivityThread.isSystem() && this.mActivityType != 0 && activityType != 0) {
            throw new IllegalStateException("Can't change activity type once set: " + this + " activityType=" + WindowConfiguration.activityTypeToString(activityType));
        }
        this.mActivityType = activityType;
    }

    @ActivityType
    private final int $$robo$$android_app_WindowConfiguration$getActivityType() {
        return this.mActivityType;
    }

    private final void $$robo$$android_app_WindowConfiguration$setTo(WindowConfiguration other) {
        this.setBounds(other.mBounds);
        this.setAppBounds(other.mAppBounds);
        this.setWindowingMode(other.mWindowingMode);
        this.setActivityType(other.mActivityType);
    }

    private final void $$robo$$android_app_WindowConfiguration$unset() {
        this.setToDefaults();
    }

    private final void $$robo$$android_app_WindowConfiguration$setToDefaults() {
        this.setAppBounds(null);
        this.setBounds(null);
        this.setWindowingMode(0);
        this.setActivityType(0);
    }

    @WindowConfig
    private final int $$robo$$android_app_WindowConfiguration$updateFrom(WindowConfiguration delta) {
        int changed = 0;
        if (!delta.mBounds.isEmpty() && !delta.mBounds.equals(this.mBounds)) {
            changed |= 1;
            this.setBounds(delta.mBounds);
        }
        if (delta.mAppBounds != null && !delta.mAppBounds.equals(this.mAppBounds)) {
            changed |= 2;
            this.setAppBounds(delta.mAppBounds);
        }
        if (delta.mWindowingMode != 0 && this.mWindowingMode != delta.mWindowingMode) {
            changed |= 4;
            this.setWindowingMode(delta.mWindowingMode);
        }
        if (delta.mActivityType != 0 && this.mActivityType != delta.mActivityType) {
            changed |= 8;
            this.setActivityType(delta.mActivityType);
        }
        return changed;
    }

    @WindowConfig
    private final long $$robo$$android_app_WindowConfiguration$diff(WindowConfiguration other, boolean compareUndefined) {
        long changes = 0L;
        if (!this.mBounds.equals(other.mBounds)) {
            changes |= 1L;
        }
        if (!(!compareUndefined && other.mAppBounds == null || this.mAppBounds == other.mAppBounds || this.mAppBounds != null && this.mAppBounds.equals(other.mAppBounds))) {
            changes |= 2L;
        }
        if ((compareUndefined || other.mWindowingMode != 0) && this.mWindowingMode != other.mWindowingMode) {
            changes |= 4L;
        }
        if ((compareUndefined || other.mActivityType != 0) && this.mActivityType != other.mActivityType) {
            changes |= 8L;
        }
        return changes;
    }

    private final int $$robo$$android_app_WindowConfiguration$compareTo(WindowConfiguration that) {
        int n = 0;
        if (this.mAppBounds == null && that.mAppBounds != null) {
            return 1;
        }
        if (this.mAppBounds != null && that.mAppBounds == null) {
            return -1;
        }
        if (this.mAppBounds != null && that.mAppBounds != null) {
            n = this.mAppBounds.left - that.mAppBounds.left;
            if (n != 0) {
                return n;
            }
            n = this.mAppBounds.top - that.mAppBounds.top;
            if (n != 0) {
                return n;
            }
            n = this.mAppBounds.right - that.mAppBounds.right;
            if (n != 0) {
                return n;
            }
            n = this.mAppBounds.bottom - that.mAppBounds.bottom;
            if (n != 0) {
                return n;
            }
        }
        if ((n = this.mBounds.left - that.mBounds.left) != 0) {
            return n;
        }
        n = this.mBounds.top - that.mBounds.top;
        if (n != 0) {
            return n;
        }
        n = this.mBounds.right - that.mBounds.right;
        if (n != 0) {
            return n;
        }
        n = this.mBounds.bottom - that.mBounds.bottom;
        if (n != 0) {
            return n;
        }
        n = this.mWindowingMode - that.mWindowingMode;
        if (n != 0) {
            return n;
        }
        n = this.mActivityType - that.mActivityType;
        if (n != 0) {
            return n;
        }
        return n;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        if (!(that instanceof WindowConfiguration)) {
            return false;
        }
        return this.compareTo((WindowConfiguration)that) == 0;
    }

    private final int $$robo$$android_app_WindowConfiguration$hashCode() {
        int result = 0;
        if (this.mAppBounds != null) {
            result = 31 * result + this.mAppBounds.hashCode();
        }
        result = 31 * result + this.mBounds.hashCode();
        result = 31 * result + this.mWindowingMode;
        result = 31 * result + this.mActivityType;
        return result;
    }

    private final String $$robo$$android_app_WindowConfiguration$toString() {
        return "{ mBounds=" + this.mBounds + " mAppBounds=" + this.mAppBounds + " mWindowingMode=" + WindowConfiguration.windowingModeToString(this.mWindowingMode) + " mActivityType=" + WindowConfiguration.activityTypeToString(this.mActivityType) + "}";
    }

    private final void $$robo$$android_app_WindowConfiguration$writeToProto(ProtoOutputStream protoOutputStream, long fieldId) {
        long token = protoOutputStream.start(fieldId);
        if (this.mAppBounds != null) {
            this.mAppBounds.writeToProto(protoOutputStream, 0x10B00000001L);
        }
        protoOutputStream.write(1120986464258L, this.mWindowingMode);
        protoOutputStream.write(1120986464259L, this.mActivityType);
        protoOutputStream.end(token);
    }

    private final boolean $$robo$$android_app_WindowConfiguration$hasWindowShadow() {
        return this.tasksAreFloating();
    }

    private final boolean $$robo$$android_app_WindowConfiguration$hasWindowDecorCaption() {
        return this.mWindowingMode == 5;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$canResizeTask() {
        return this.mWindowingMode == 5;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$persistTaskBounds() {
        return this.mWindowingMode == 5;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$tasksAreFloating() {
        return WindowConfiguration.isFloating(this.mWindowingMode);
    }

    private static final boolean $$robo$$android_app_WindowConfiguration$isFloating(int windowingMode) {
        return windowingMode == 5 || windowingMode == 2;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$canReceiveKeys() {
        return this.mWindowingMode != 2;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$isAlwaysOnTop() {
        return this.mWindowingMode == 2;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$keepVisibleDeadAppWindowOnScreen() {
        return this.mWindowingMode != 2;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$useWindowFrameForBackdrop() {
        return this.mWindowingMode == 5 || this.mWindowingMode == 2;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$windowsAreScaleable() {
        return this.mWindowingMode == 2;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$hasMovementAnimations() {
        return this.mWindowingMode != 2;
    }

    private final boolean $$robo$$android_app_WindowConfiguration$supportSplitScreenWindowingMode() {
        return WindowConfiguration.supportSplitScreenWindowingMode(this.mActivityType);
    }

    private static final boolean $$robo$$android_app_WindowConfiguration$supportSplitScreenWindowingMode(int activityType) {
        return activityType != 4;
    }

    private static final String $$robo$$android_app_WindowConfiguration$windowingModeToString(@WindowingMode int windowingMode) {
        switch (windowingMode) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "fullscreen";
            }
            case 2: {
                return "pinned";
            }
            case 3: {
                return "split-screen-primary";
            }
            case 4: {
                return "split-screen-secondary";
            }
            case 5: {
                return "freeform";
            }
        }
        return String.valueOf(windowingMode);
    }

    private static final String $$robo$$android_app_WindowConfiguration$activityTypeToString(@ActivityType int applicationType) {
        switch (applicationType) {
            case 0: {
                return "undefined";
            }
            case 1: {
                return "standard";
            }
            case 2: {
                return "home";
            }
            case 3: {
                return "recents";
            }
            case 4: {
                return "assistant";
            }
        }
        return String.valueOf(applicationType);
    }

    private /* synthetic */ void $$robo$$android_app_WindowConfiguration$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WindowConfiguration>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_WindowConfiguration_1$__constructor__() {
            }

            private final WindowConfiguration $$robo$$android_app_WindowConfiguration_1$createFromParcel(Parcel in) {
                return new WindowConfiguration(in, null);
            }

            private final WindowConfiguration[] $$robo$$android_app_WindowConfiguration_1$newArray(int size) {
                return new WindowConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_WindowConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WindowConfiguration_1$__constructor__(), this);
            }

            @Override
            public WindowConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_WindowConfiguration_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public WindowConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_WindowConfiguration_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_app_WindowConfiguration$__constructor__();
    }

    public WindowConfiguration() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WindowConfiguration$__constructor__(), this);
    }

    private void __constructor__(WindowConfiguration windowConfiguration) {
        this.$$robo$$android_app_WindowConfiguration$__constructor__(windowConfiguration);
    }

    public WindowConfiguration(WindowConfiguration windowConfiguration) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WindowConfiguration$__constructor__(android.app.WindowConfiguration ), this, windowConfiguration);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_WindowConfiguration$__constructor__(parcel);
    }

    public WindowConfiguration(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WindowConfiguration$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_WindowConfiguration$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_app_WindowConfiguration$readFromParcel(android.os.Parcel ), this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_WindowConfiguration$describeContents(), this);
    }

    public void setBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("setBounds", $$robo$$android_app_WindowConfiguration$setBounds(android.graphics.Rect ), this, rect);
    }

    public void setAppBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("setAppBounds", $$robo$$android_app_WindowConfiguration$setAppBounds(android.graphics.Rect ), this, rect);
    }

    public void setAppBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setAppBounds", $$robo$$android_app_WindowConfiguration$setAppBounds(int int int int ), this, n, n2, n3, n4);
    }

    public Rect getAppBounds() {
        return InvokeDynamicSupport.bootstrap("getAppBounds", $$robo$$android_app_WindowConfiguration$getAppBounds(), this);
    }

    public Rect getBounds() {
        return InvokeDynamicSupport.bootstrap("getBounds", $$robo$$android_app_WindowConfiguration$getBounds(), this);
    }

    public void setWindowingMode(int n) {
        InvokeDynamicSupport.bootstrap("setWindowingMode", $$robo$$android_app_WindowConfiguration$setWindowingMode(int ), this, n);
    }

    public int getWindowingMode() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowingMode", $$robo$$android_app_WindowConfiguration$getWindowingMode(), this);
    }

    public void setActivityType(int n) {
        InvokeDynamicSupport.bootstrap("setActivityType", $$robo$$android_app_WindowConfiguration$setActivityType(int ), this, n);
    }

    public int getActivityType() {
        return (int)InvokeDynamicSupport.bootstrap("getActivityType", $$robo$$android_app_WindowConfiguration$getActivityType(), this);
    }

    public void setTo(WindowConfiguration windowConfiguration) {
        InvokeDynamicSupport.bootstrap("setTo", $$robo$$android_app_WindowConfiguration$setTo(android.app.WindowConfiguration ), this, windowConfiguration);
    }

    public void unset() {
        InvokeDynamicSupport.bootstrap("unset", $$robo$$android_app_WindowConfiguration$unset(), this);
    }

    public void setToDefaults() {
        InvokeDynamicSupport.bootstrap("setToDefaults", $$robo$$android_app_WindowConfiguration$setToDefaults(), this);
    }

    public int updateFrom(WindowConfiguration windowConfiguration) {
        return (int)InvokeDynamicSupport.bootstrap("updateFrom", $$robo$$android_app_WindowConfiguration$updateFrom(android.app.WindowConfiguration ), this, windowConfiguration);
    }

    public long diff(WindowConfiguration windowConfiguration, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("diff", $$robo$$android_app_WindowConfiguration$diff(android.app.WindowConfiguration boolean ), this, windowConfiguration, bl);
    }

    @Override
    public int compareTo(WindowConfiguration windowConfiguration) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_app_WindowConfiguration$compareTo(android.app.WindowConfiguration ), this, windowConfiguration);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_app_WindowConfiguration$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_app_WindowConfiguration$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_WindowConfiguration$toString(), this);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_app_WindowConfiguration$writeToProto(android.util.proto.ProtoOutputStream long ), this, protoOutputStream, l);
    }

    public boolean hasWindowShadow() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasWindowShadow", $$robo$$android_app_WindowConfiguration$hasWindowShadow(), this);
    }

    public boolean hasWindowDecorCaption() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasWindowDecorCaption", $$robo$$android_app_WindowConfiguration$hasWindowDecorCaption(), this);
    }

    public boolean canResizeTask() {
        return (boolean)InvokeDynamicSupport.bootstrap("canResizeTask", $$robo$$android_app_WindowConfiguration$canResizeTask(), this);
    }

    public boolean persistTaskBounds() {
        return (boolean)InvokeDynamicSupport.bootstrap("persistTaskBounds", $$robo$$android_app_WindowConfiguration$persistTaskBounds(), this);
    }

    public boolean tasksAreFloating() {
        return (boolean)InvokeDynamicSupport.bootstrap("tasksAreFloating", $$robo$$android_app_WindowConfiguration$tasksAreFloating(), this);
    }

    public static boolean isFloating(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isFloating", $$robo$$android_app_WindowConfiguration$isFloating(int ), (int)n);
    }

    public boolean canReceiveKeys() {
        return (boolean)InvokeDynamicSupport.bootstrap("canReceiveKeys", $$robo$$android_app_WindowConfiguration$canReceiveKeys(), this);
    }

    public boolean isAlwaysOnTop() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlwaysOnTop", $$robo$$android_app_WindowConfiguration$isAlwaysOnTop(), this);
    }

    public boolean keepVisibleDeadAppWindowOnScreen() {
        return (boolean)InvokeDynamicSupport.bootstrap("keepVisibleDeadAppWindowOnScreen", $$robo$$android_app_WindowConfiguration$keepVisibleDeadAppWindowOnScreen(), this);
    }

    public boolean useWindowFrameForBackdrop() {
        return (boolean)InvokeDynamicSupport.bootstrap("useWindowFrameForBackdrop", $$robo$$android_app_WindowConfiguration$useWindowFrameForBackdrop(), this);
    }

    public boolean windowsAreScaleable() {
        return (boolean)InvokeDynamicSupport.bootstrap("windowsAreScaleable", $$robo$$android_app_WindowConfiguration$windowsAreScaleable(), this);
    }

    public boolean hasMovementAnimations() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMovementAnimations", $$robo$$android_app_WindowConfiguration$hasMovementAnimations(), this);
    }

    public boolean supportSplitScreenWindowingMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("supportSplitScreenWindowingMode", $$robo$$android_app_WindowConfiguration$supportSplitScreenWindowingMode(), this);
    }

    public static boolean supportSplitScreenWindowingMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("supportSplitScreenWindowingMode", $$robo$$android_app_WindowConfiguration$supportSplitScreenWindowingMode(int ), (int)n);
    }

    public static String windowingModeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("windowingModeToString", $$robo$$android_app_WindowConfiguration$windowingModeToString(int ), (int)n);
    }

    public static String activityTypeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("activityTypeToString", $$robo$$android_app_WindowConfiguration$activityTypeToString(int ), (int)n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_app_WindowConfiguration$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ WindowConfiguration(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_WindowConfiguration$__constructor__(android.os.Parcel android.app.WindowConfiguration$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(WindowConfiguration.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WindowConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static @interface WindowConfig {
    }

    public static @interface ActivityType {
    }

    public static @interface WindowingMode {
    }
}

