/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.content.ClipData;
import android.content.ComponentName;
import android.net.NetworkRequest;
import android.net.Uri;
import android.os.BaseBundle;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.util.Log;
import android.util.TimeUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class JobInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static int NETWORK_TYPE_NONE = 0;
    public static int NETWORK_TYPE_ANY = 1;
    public static int NETWORK_TYPE_UNMETERED = 2;
    public static int NETWORK_TYPE_NOT_ROAMING = 3;
    public static int NETWORK_TYPE_CELLULAR = 4;
    @Deprecated
    public static int NETWORK_TYPE_METERED = 4;
    public static int NETWORK_BYTES_UNKNOWN = -1;
    public static long DEFAULT_INITIAL_BACKOFF_MILLIS = 30000L;
    public static long MAX_BACKOFF_DELAY_MILLIS = 18000000L;
    public static int BACKOFF_POLICY_LINEAR = 0;
    public static int BACKOFF_POLICY_EXPONENTIAL = 1;
    private static long MIN_PERIOD_MILLIS = 900000L;
    private static long MIN_FLEX_MILLIS = 300000L;
    public static long MIN_BACKOFF_MILLIS = 10000L;
    public static int DEFAULT_BACKOFF_POLICY = 1;
    public static int PRIORITY_DEFAULT = 0;
    public static int PRIORITY_SYNC_EXPEDITED = 10;
    public static int PRIORITY_SYNC_INITIALIZATION = 20;
    public static int PRIORITY_FOREGROUND_APP = 30;
    public static int PRIORITY_TOP_APP = 40;
    public static int PRIORITY_ADJ_OFTEN_RUNNING = -40;
    public static int PRIORITY_ADJ_ALWAYS_RUNNING = -80;
    public static int FLAG_WILL_BE_FOREGROUND = 1;
    public static int FLAG_IMPORTANT_WHILE_FOREGROUND = 2;
    public static int FLAG_PREFETCH = 4;
    public static int FLAG_EXEMPT_FROM_APP_STANDBY = 8;
    public static int CONSTRAINT_FLAG_CHARGING = 1;
    public static int CONSTRAINT_FLAG_BATTERY_NOT_LOW = 2;
    public static int CONSTRAINT_FLAG_DEVICE_IDLE = 4;
    public static int CONSTRAINT_FLAG_STORAGE_NOT_LOW = 8;
    private int jobId;
    private PersistableBundle extras;
    private Bundle transientExtras;
    private ClipData clipData;
    private int clipGrantFlags;
    private ComponentName service;
    private int constraintFlags;
    private TriggerContentUri[] triggerContentUris;
    private long triggerContentUpdateDelay;
    private long triggerContentMaxDelay;
    private boolean hasEarlyConstraint;
    private boolean hasLateConstraint;
    private NetworkRequest networkRequest;
    private long networkDownloadBytes;
    private long networkUploadBytes;
    private long minLatencyMillis;
    private long maxExecutionDelayMillis;
    private boolean isPeriodic;
    private boolean isPersisted;
    private long intervalMillis;
    private long flexMillis;
    private long initialBackoffMillis;
    private int backoffPolicy;
    private int priority;
    private int flags;
    public static Parcelable.Creator<JobInfo> CREATOR;

    private static final long $$robo$$android_app_job_JobInfo$getMinPeriodMillis() {
        return 900000L;
    }

    private static final long $$robo$$android_app_job_JobInfo$getMinFlexMillis() {
        return 300000L;
    }

    private static final long $$robo$$android_app_job_JobInfo$getMinBackoffMillis() {
        return 10000L;
    }

    private final int $$robo$$android_app_job_JobInfo$getId() {
        return this.jobId;
    }

    private final PersistableBundle $$robo$$android_app_job_JobInfo$getExtras() {
        return this.extras;
    }

    private final Bundle $$robo$$android_app_job_JobInfo$getTransientExtras() {
        return this.transientExtras;
    }

    private final ClipData $$robo$$android_app_job_JobInfo$getClipData() {
        return this.clipData;
    }

    private final int $$robo$$android_app_job_JobInfo$getClipGrantFlags() {
        return this.clipGrantFlags;
    }

    private final ComponentName $$robo$$android_app_job_JobInfo$getService() {
        return this.service;
    }

    private final int $$robo$$android_app_job_JobInfo$getPriority() {
        return this.priority;
    }

    private final int $$robo$$android_app_job_JobInfo$getFlags() {
        return this.flags;
    }

    private final boolean $$robo$$android_app_job_JobInfo$isExemptedFromAppStandby() {
        return (this.flags & 8) != 0 && !this.isPeriodic();
    }

    private final boolean $$robo$$android_app_job_JobInfo$isRequireCharging() {
        return (this.constraintFlags & 1) != 0;
    }

    private final boolean $$robo$$android_app_job_JobInfo$isRequireBatteryNotLow() {
        return (this.constraintFlags & 2) != 0;
    }

    private final boolean $$robo$$android_app_job_JobInfo$isRequireDeviceIdle() {
        return (this.constraintFlags & 4) != 0;
    }

    private final boolean $$robo$$android_app_job_JobInfo$isRequireStorageNotLow() {
        return (this.constraintFlags & 8) != 0;
    }

    private final int $$robo$$android_app_job_JobInfo$getConstraintFlags() {
        return this.constraintFlags;
    }

    private final TriggerContentUri[] $$robo$$android_app_job_JobInfo$getTriggerContentUris() {
        return this.triggerContentUris;
    }

    private final long $$robo$$android_app_job_JobInfo$getTriggerContentUpdateDelay() {
        return this.triggerContentUpdateDelay;
    }

    private final long $$robo$$android_app_job_JobInfo$getTriggerContentMaxDelay() {
        return this.triggerContentMaxDelay;
    }

    @Deprecated
    private final int $$robo$$android_app_job_JobInfo$getNetworkType() {
        if (this.networkRequest == null) {
            return 0;
        }
        if (this.networkRequest.networkCapabilities.hasCapability(11)) {
            return 2;
        }
        if (this.networkRequest.networkCapabilities.hasCapability(18)) {
            return 3;
        }
        if (this.networkRequest.networkCapabilities.hasTransport(0)) {
            return 4;
        }
        return 1;
    }

    private final NetworkRequest $$robo$$android_app_job_JobInfo$getRequiredNetwork() {
        return this.networkRequest;
    }

    @Deprecated
    private final long $$robo$$android_app_job_JobInfo$getEstimatedNetworkBytes() {
        if (this.networkDownloadBytes == -1L && this.networkUploadBytes == -1L) {
            return -1L;
        }
        if (this.networkDownloadBytes == -1L) {
            return this.networkUploadBytes;
        }
        if (this.networkUploadBytes == -1L) {
            return this.networkDownloadBytes;
        }
        return this.networkDownloadBytes + this.networkUploadBytes;
    }

    private final long $$robo$$android_app_job_JobInfo$getEstimatedNetworkDownloadBytes() {
        return this.networkDownloadBytes;
    }

    private final long $$robo$$android_app_job_JobInfo$getEstimatedNetworkUploadBytes() {
        return this.networkUploadBytes;
    }

    private final long $$robo$$android_app_job_JobInfo$getMinLatencyMillis() {
        return this.minLatencyMillis;
    }

    private final long $$robo$$android_app_job_JobInfo$getMaxExecutionDelayMillis() {
        return this.maxExecutionDelayMillis;
    }

    private final boolean $$robo$$android_app_job_JobInfo$isPeriodic() {
        return this.isPeriodic;
    }

    private final boolean $$robo$$android_app_job_JobInfo$isPersisted() {
        return this.isPersisted;
    }

    private final long $$robo$$android_app_job_JobInfo$getIntervalMillis() {
        return this.intervalMillis;
    }

    private final long $$robo$$android_app_job_JobInfo$getFlexMillis() {
        return this.flexMillis;
    }

    private final long $$robo$$android_app_job_JobInfo$getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    private final int $$robo$$android_app_job_JobInfo$getBackoffPolicy() {
        return this.backoffPolicy;
    }

    private final boolean $$robo$$android_app_job_JobInfo$isImportantWhileForeground() {
        return (this.flags & 2) != 0;
    }

    private final boolean $$robo$$android_app_job_JobInfo$isPrefetch() {
        return (this.flags & 4) != 0;
    }

    private final boolean $$robo$$android_app_job_JobInfo$hasEarlyConstraint() {
        return this.hasEarlyConstraint;
    }

    private final boolean $$robo$$android_app_job_JobInfo$hasLateConstraint() {
        return this.hasLateConstraint;
    }

    private static final boolean $$robo$$android_app_job_JobInfo$kindofEqualsBundle(BaseBundle a, BaseBundle b) {
        return a == b || a != null && a.kindofEquals(b);
    }

    private final boolean $$robo$$android_app_job_JobInfo$equals(Object o) {
        if (!(o instanceof JobInfo)) {
            return false;
        }
        JobInfo j = (JobInfo)o;
        if (this.jobId != j.jobId) {
            return false;
        }
        if (!JobInfo.kindofEqualsBundle(this.extras, j.extras)) {
            return false;
        }
        if (!JobInfo.kindofEqualsBundle(this.transientExtras, j.transientExtras)) {
            return false;
        }
        if (this.clipData != j.clipData) {
            return false;
        }
        if (this.clipGrantFlags != j.clipGrantFlags) {
            return false;
        }
        if (!Objects.equals(this.service, j.service)) {
            return false;
        }
        if (this.constraintFlags != j.constraintFlags) {
            return false;
        }
        if (!Arrays.equals(this.triggerContentUris, j.triggerContentUris)) {
            return false;
        }
        if (this.triggerContentUpdateDelay != j.triggerContentUpdateDelay) {
            return false;
        }
        if (this.triggerContentMaxDelay != j.triggerContentMaxDelay) {
            return false;
        }
        if (this.hasEarlyConstraint != j.hasEarlyConstraint) {
            return false;
        }
        if (this.hasLateConstraint != j.hasLateConstraint) {
            return false;
        }
        if (!Objects.equals(this.networkRequest, j.networkRequest)) {
            return false;
        }
        if (this.networkDownloadBytes != j.networkDownloadBytes) {
            return false;
        }
        if (this.networkUploadBytes != j.networkUploadBytes) {
            return false;
        }
        if (this.minLatencyMillis != j.minLatencyMillis) {
            return false;
        }
        if (this.maxExecutionDelayMillis != j.maxExecutionDelayMillis) {
            return false;
        }
        if (this.isPeriodic != j.isPeriodic) {
            return false;
        }
        if (this.isPersisted != j.isPersisted) {
            return false;
        }
        if (this.intervalMillis != j.intervalMillis) {
            return false;
        }
        if (this.flexMillis != j.flexMillis) {
            return false;
        }
        if (this.initialBackoffMillis != j.initialBackoffMillis) {
            return false;
        }
        if (this.backoffPolicy != j.backoffPolicy) {
            return false;
        }
        if (this.priority != j.priority) {
            return false;
        }
        return this.flags == j.flags;
    }

    private final int $$robo$$android_app_job_JobInfo$hashCode() {
        int hashCode = this.jobId;
        if (this.extras != null) {
            hashCode = 31 * hashCode + this.extras.hashCode();
        }
        if (this.transientExtras != null) {
            hashCode = 31 * hashCode + this.transientExtras.hashCode();
        }
        if (this.clipData != null) {
            hashCode = 31 * hashCode + this.clipData.hashCode();
        }
        hashCode = 31 * hashCode + this.clipGrantFlags;
        if (this.service != null) {
            hashCode = 31 * hashCode + this.service.hashCode();
        }
        hashCode = 31 * hashCode + this.constraintFlags;
        if (this.triggerContentUris != null) {
            hashCode = 31 * hashCode + Arrays.hashCode(this.triggerContentUris);
        }
        hashCode = 31 * hashCode + Long.hashCode(this.triggerContentUpdateDelay);
        hashCode = 31 * hashCode + Long.hashCode(this.triggerContentMaxDelay);
        hashCode = 31 * hashCode + Boolean.hashCode(this.hasEarlyConstraint);
        hashCode = 31 * hashCode + Boolean.hashCode(this.hasLateConstraint);
        if (this.networkRequest != null) {
            hashCode = 31 * hashCode + this.networkRequest.hashCode();
        }
        hashCode = 31 * hashCode + Long.hashCode(this.networkDownloadBytes);
        hashCode = 31 * hashCode + Long.hashCode(this.networkUploadBytes);
        hashCode = 31 * hashCode + Long.hashCode(this.minLatencyMillis);
        hashCode = 31 * hashCode + Long.hashCode(this.maxExecutionDelayMillis);
        hashCode = 31 * hashCode + Boolean.hashCode(this.isPeriodic);
        hashCode = 31 * hashCode + Boolean.hashCode(this.isPersisted);
        hashCode = 31 * hashCode + Long.hashCode(this.intervalMillis);
        hashCode = 31 * hashCode + Long.hashCode(this.flexMillis);
        hashCode = 31 * hashCode + Long.hashCode(this.initialBackoffMillis);
        hashCode = 31 * hashCode + this.backoffPolicy;
        hashCode = 31 * hashCode + this.priority;
        hashCode = 31 * hashCode + this.flags;
        return hashCode;
    }

    private void $$robo$$android_app_job_JobInfo$__constructor__(Parcel in) {
        this.jobId = in.readInt();
        this.extras = in.readPersistableBundle();
        this.transientExtras = in.readBundle();
        if (in.readInt() != 0) {
            this.clipData = ClipData.CREATOR.createFromParcel(in);
            this.clipGrantFlags = in.readInt();
        } else {
            this.clipData = null;
            this.clipGrantFlags = 0;
        }
        this.service = (ComponentName)in.readParcelable(null);
        this.constraintFlags = in.readInt();
        this.triggerContentUris = in.createTypedArray(TriggerContentUri.CREATOR);
        this.triggerContentUpdateDelay = in.readLong();
        this.triggerContentMaxDelay = in.readLong();
        this.networkRequest = in.readInt() != 0 ? NetworkRequest.CREATOR.createFromParcel(in) : null;
        this.networkDownloadBytes = in.readLong();
        this.networkUploadBytes = in.readLong();
        this.minLatencyMillis = in.readLong();
        this.maxExecutionDelayMillis = in.readLong();
        this.isPeriodic = in.readInt() == 1;
        this.isPersisted = in.readInt() == 1;
        this.intervalMillis = in.readLong();
        this.flexMillis = in.readLong();
        this.initialBackoffMillis = in.readLong();
        this.backoffPolicy = in.readInt();
        this.hasEarlyConstraint = in.readInt() == 1;
        this.hasLateConstraint = in.readInt() == 1;
        this.priority = in.readInt();
        this.flags = in.readInt();
    }

    private void $$robo$$android_app_job_JobInfo$__constructor__(Builder b) {
        this.jobId = b.mJobId;
        this.extras = b.mExtras.deepCopy();
        this.transientExtras = b.mTransientExtras.deepCopy();
        this.clipData = b.mClipData;
        this.clipGrantFlags = b.mClipGrantFlags;
        this.service = b.mJobService;
        this.constraintFlags = b.mConstraintFlags;
        this.triggerContentUris = b.mTriggerContentUris != null ? b.mTriggerContentUris.toArray(new TriggerContentUri[b.mTriggerContentUris.size()]) : null;
        this.triggerContentUpdateDelay = b.mTriggerContentUpdateDelay;
        this.triggerContentMaxDelay = b.mTriggerContentMaxDelay;
        this.networkRequest = b.mNetworkRequest;
        this.networkDownloadBytes = b.mNetworkDownloadBytes;
        this.networkUploadBytes = b.mNetworkUploadBytes;
        this.minLatencyMillis = b.mMinLatencyMillis;
        this.maxExecutionDelayMillis = b.mMaxExecutionDelayMillis;
        this.isPeriodic = b.mIsPeriodic;
        this.isPersisted = b.mIsPersisted;
        this.intervalMillis = b.mIntervalMillis;
        this.flexMillis = b.mFlexMillis;
        this.initialBackoffMillis = b.mInitialBackoffMillis;
        this.backoffPolicy = b.mBackoffPolicy;
        this.hasEarlyConstraint = b.mHasEarlyConstraint;
        this.hasLateConstraint = b.mHasLateConstraint;
        this.priority = b.mPriority;
        this.flags = b.mFlags;
    }

    private final int $$robo$$android_app_job_JobInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_app_job_JobInfo$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.jobId);
        out.writePersistableBundle(this.extras);
        out.writeBundle(this.transientExtras);
        if (this.clipData != null) {
            out.writeInt(1);
            this.clipData.writeToParcel(out, flags);
            out.writeInt(this.clipGrantFlags);
        } else {
            out.writeInt(0);
        }
        out.writeParcelable(this.service, flags);
        out.writeInt(this.constraintFlags);
        out.writeTypedArray(this.triggerContentUris, flags);
        out.writeLong(this.triggerContentUpdateDelay);
        out.writeLong(this.triggerContentMaxDelay);
        if (this.networkRequest != null) {
            out.writeInt(1);
            this.networkRequest.writeToParcel(out, flags);
        } else {
            out.writeInt(0);
        }
        out.writeLong(this.networkDownloadBytes);
        out.writeLong(this.networkUploadBytes);
        out.writeLong(this.minLatencyMillis);
        out.writeLong(this.maxExecutionDelayMillis);
        out.writeInt(this.isPeriodic ? 1 : 0);
        out.writeInt(this.isPersisted ? 1 : 0);
        out.writeLong(this.intervalMillis);
        out.writeLong(this.flexMillis);
        out.writeLong(this.initialBackoffMillis);
        out.writeInt(this.backoffPolicy);
        out.writeInt(this.hasEarlyConstraint ? 1 : 0);
        out.writeInt(this.hasLateConstraint ? 1 : 0);
        out.writeInt(this.priority);
        out.writeInt(this.flags);
    }

    private final String $$robo$$android_app_job_JobInfo$toString() {
        return "(job:" + this.jobId + "/" + this.service.flattenToShortString() + ")";
    }

    private /* synthetic */ void $$robo$$android_app_job_JobInfo$__constructor__(Parcel x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_app_job_JobInfo$__constructor__(Builder x0, 1 x1) {
    }

    static void __staticInitializer__() {
        TAG = "JobInfo";
        CREATOR = new Parcelable.Creator<JobInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_app_job_JobInfo_1$__constructor__() {
            }

            private final JobInfo $$robo$$android_app_job_JobInfo_1$createFromParcel(Parcel in) {
                return new JobInfo(in, null);
            }

            private final JobInfo[] $$robo$$android_app_job_JobInfo_1$newArray(int size) {
                return new JobInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_app_job_JobInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo_1$__constructor__(), this);
            }

            @Override
            public JobInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_job_JobInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public JobInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_job_JobInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static long getMinPeriodMillis() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getMinPeriodMillis", $$robo$$android_app_job_JobInfo$getMinPeriodMillis());
    }

    public static long getMinFlexMillis() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getMinFlexMillis", $$robo$$android_app_job_JobInfo$getMinFlexMillis());
    }

    public static long getMinBackoffMillis() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getMinBackoffMillis", $$robo$$android_app_job_JobInfo$getMinBackoffMillis());
    }

    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_app_job_JobInfo$getId(), this);
    }

    public PersistableBundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_app_job_JobInfo$getExtras(), this);
    }

    public Bundle getTransientExtras() {
        return InvokeDynamicSupport.bootstrap("getTransientExtras", $$robo$$android_app_job_JobInfo$getTransientExtras(), this);
    }

    public ClipData getClipData() {
        return InvokeDynamicSupport.bootstrap("getClipData", $$robo$$android_app_job_JobInfo$getClipData(), this);
    }

    public int getClipGrantFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getClipGrantFlags", $$robo$$android_app_job_JobInfo$getClipGrantFlags(), this);
    }

    public ComponentName getService() {
        return InvokeDynamicSupport.bootstrap("getService", $$robo$$android_app_job_JobInfo$getService(), this);
    }

    public int getPriority() {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_app_job_JobInfo$getPriority(), this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_app_job_JobInfo$getFlags(), this);
    }

    public boolean isExemptedFromAppStandby() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExemptedFromAppStandby", $$robo$$android_app_job_JobInfo$isExemptedFromAppStandby(), this);
    }

    public boolean isRequireCharging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRequireCharging", $$robo$$android_app_job_JobInfo$isRequireCharging(), this);
    }

    public boolean isRequireBatteryNotLow() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRequireBatteryNotLow", $$robo$$android_app_job_JobInfo$isRequireBatteryNotLow(), this);
    }

    public boolean isRequireDeviceIdle() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRequireDeviceIdle", $$robo$$android_app_job_JobInfo$isRequireDeviceIdle(), this);
    }

    public boolean isRequireStorageNotLow() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRequireStorageNotLow", $$robo$$android_app_job_JobInfo$isRequireStorageNotLow(), this);
    }

    public int getConstraintFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getConstraintFlags", $$robo$$android_app_job_JobInfo$getConstraintFlags(), this);
    }

    public TriggerContentUri[] getTriggerContentUris() {
        return InvokeDynamicSupport.bootstrap("getTriggerContentUris", $$robo$$android_app_job_JobInfo$getTriggerContentUris(), this);
    }

    public long getTriggerContentUpdateDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getTriggerContentUpdateDelay", $$robo$$android_app_job_JobInfo$getTriggerContentUpdateDelay(), this);
    }

    public long getTriggerContentMaxDelay() {
        return (long)InvokeDynamicSupport.bootstrap("getTriggerContentMaxDelay", $$robo$$android_app_job_JobInfo$getTriggerContentMaxDelay(), this);
    }

    @Deprecated
    public int getNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkType", $$robo$$android_app_job_JobInfo$getNetworkType(), this);
    }

    public NetworkRequest getRequiredNetwork() {
        return InvokeDynamicSupport.bootstrap("getRequiredNetwork", $$robo$$android_app_job_JobInfo$getRequiredNetwork(), this);
    }

    @Deprecated
    public long getEstimatedNetworkBytes() {
        return (long)InvokeDynamicSupport.bootstrap("getEstimatedNetworkBytes", $$robo$$android_app_job_JobInfo$getEstimatedNetworkBytes(), this);
    }

    public long getEstimatedNetworkDownloadBytes() {
        return (long)InvokeDynamicSupport.bootstrap("getEstimatedNetworkDownloadBytes", $$robo$$android_app_job_JobInfo$getEstimatedNetworkDownloadBytes(), this);
    }

    public long getEstimatedNetworkUploadBytes() {
        return (long)InvokeDynamicSupport.bootstrap("getEstimatedNetworkUploadBytes", $$robo$$android_app_job_JobInfo$getEstimatedNetworkUploadBytes(), this);
    }

    public long getMinLatencyMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getMinLatencyMillis", $$robo$$android_app_job_JobInfo$getMinLatencyMillis(), this);
    }

    public long getMaxExecutionDelayMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getMaxExecutionDelayMillis", $$robo$$android_app_job_JobInfo$getMaxExecutionDelayMillis(), this);
    }

    public boolean isPeriodic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPeriodic", $$robo$$android_app_job_JobInfo$isPeriodic(), this);
    }

    public boolean isPersisted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPersisted", $$robo$$android_app_job_JobInfo$isPersisted(), this);
    }

    public long getIntervalMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getIntervalMillis", $$robo$$android_app_job_JobInfo$getIntervalMillis(), this);
    }

    public long getFlexMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getFlexMillis", $$robo$$android_app_job_JobInfo$getFlexMillis(), this);
    }

    public long getInitialBackoffMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getInitialBackoffMillis", $$robo$$android_app_job_JobInfo$getInitialBackoffMillis(), this);
    }

    public int getBackoffPolicy() {
        return (int)InvokeDynamicSupport.bootstrap("getBackoffPolicy", $$robo$$android_app_job_JobInfo$getBackoffPolicy(), this);
    }

    public boolean isImportantWhileForeground() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImportantWhileForeground", $$robo$$android_app_job_JobInfo$isImportantWhileForeground(), this);
    }

    public boolean isPrefetch() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrefetch", $$robo$$android_app_job_JobInfo$isPrefetch(), this);
    }

    public boolean hasEarlyConstraint() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasEarlyConstraint", $$robo$$android_app_job_JobInfo$hasEarlyConstraint(), this);
    }

    public boolean hasLateConstraint() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasLateConstraint", $$robo$$android_app_job_JobInfo$hasLateConstraint(), this);
    }

    private static boolean kindofEqualsBundle(BaseBundle baseBundle, BaseBundle baseBundle2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("kindofEqualsBundle", $$robo$$android_app_job_JobInfo$kindofEqualsBundle(android.os.BaseBundle android.os.BaseBundle ), (BaseBundle)baseBundle, (BaseBundle)baseBundle2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_app_job_JobInfo$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_app_job_JobInfo$hashCode(), this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_app_job_JobInfo$__constructor__(parcel);
    }

    public JobInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_app_job_JobInfo$__constructor__(builder);
    }

    public JobInfo(Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo$__constructor__(android.app.job.JobInfo$Builder ), this, builder);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_job_JobInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_job_JobInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_app_job_JobInfo$toString(), this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_app_job_JobInfo$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ JobInfo(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo$__constructor__(android.os.Parcel android.app.job.JobInfo$1 ), this, parcel, var2_2);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_app_job_JobInfo$__constructor__(builder, var2_2);
    }

    public /* synthetic */ JobInfo(Builder builder, 1 var2_2) {
        this(builder);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo$__constructor__(android.app.job.JobInfo$Builder android.app.job.JobInfo$1 ), this, builder, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(JobInfo.class);
    }

    public /* synthetic */ JobInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JobInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mJobId;
        private ComponentName mJobService;
        private PersistableBundle mExtras;
        private Bundle mTransientExtras;
        private ClipData mClipData;
        private int mClipGrantFlags;
        private int mPriority;
        private int mFlags;
        private int mConstraintFlags;
        private NetworkRequest mNetworkRequest;
        private long mNetworkDownloadBytes;
        private long mNetworkUploadBytes;
        private ArrayList<TriggerContentUri> mTriggerContentUris;
        private long mTriggerContentUpdateDelay;
        private long mTriggerContentMaxDelay;
        private boolean mIsPersisted;
        private long mMinLatencyMillis;
        private long mMaxExecutionDelayMillis;
        private boolean mIsPeriodic;
        private boolean mHasEarlyConstraint;
        private boolean mHasLateConstraint;
        private long mIntervalMillis;
        private long mFlexMillis;
        private long mInitialBackoffMillis;
        private int mBackoffPolicy;
        private boolean mBackoffPolicySet;

        private void $$robo$$android_app_job_JobInfo_Builder$__constructor__(int jobId, ComponentName jobService) {
            this.mExtras = PersistableBundle.EMPTY;
            this.mTransientExtras = Bundle.EMPTY;
            this.mPriority = 0;
            this.mNetworkDownloadBytes = -1L;
            this.mNetworkUploadBytes = -1L;
            this.mTriggerContentUpdateDelay = -1L;
            this.mTriggerContentMaxDelay = -1L;
            this.mInitialBackoffMillis = 30000L;
            this.mBackoffPolicy = 1;
            this.mBackoffPolicySet = false;
            this.mJobService = jobService;
            this.mJobId = jobId;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setPriority(int priority) {
            this.mPriority = priority;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setExtras(PersistableBundle extras) {
            this.mExtras = extras;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setTransientExtras(Bundle extras) {
            this.mTransientExtras = extras;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setClipData(ClipData clip, int grantFlags) {
            this.mClipData = clip;
            this.mClipGrantFlags = grantFlags;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setRequiredNetworkType(int networkType) {
            if (networkType == 0) {
                return this.setRequiredNetwork(null);
            }
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            builder.addCapability(12);
            builder.addCapability(16);
            builder.removeCapability(15);
            if (networkType != 1) {
                if (networkType == 2) {
                    builder.addCapability(11);
                } else if (networkType == 3) {
                    builder.addCapability(18);
                } else if (networkType == 4) {
                    builder.addTransportType(0);
                }
            }
            return this.setRequiredNetwork(builder.build());
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setRequiredNetwork(NetworkRequest networkRequest) {
            this.mNetworkRequest = networkRequest;
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_app_job_JobInfo_Builder$setEstimatedNetworkBytes(long networkBytes) {
            return this.setEstimatedNetworkBytes(networkBytes, -1L);
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setEstimatedNetworkBytes(long downloadBytes, long uploadBytes) {
            this.mNetworkDownloadBytes = downloadBytes;
            this.mNetworkUploadBytes = uploadBytes;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setRequiresCharging(boolean requiresCharging) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFFE | (requiresCharging ? 1 : 0);
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setRequiresBatteryNotLow(boolean batteryNotLow) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFFD | (batteryNotLow ? 2 : 0);
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setRequiresDeviceIdle(boolean requiresDeviceIdle) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFFB | (requiresDeviceIdle ? 4 : 0);
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setRequiresStorageNotLow(boolean storageNotLow) {
            this.mConstraintFlags = this.mConstraintFlags & 0xFFFFFFF7 | (storageNotLow ? 8 : 0);
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$addTriggerContentUri(TriggerContentUri uri) {
            if (this.mTriggerContentUris == null) {
                this.mTriggerContentUris = new ArrayList();
            }
            this.mTriggerContentUris.add(uri);
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setTriggerContentUpdateDelay(long durationMs) {
            this.mTriggerContentUpdateDelay = durationMs;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setTriggerContentMaxDelay(long durationMs) {
            this.mTriggerContentMaxDelay = durationMs;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setPeriodic(long intervalMillis) {
            return this.setPeriodic(intervalMillis, intervalMillis);
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setPeriodic(long intervalMillis, long flexMillis) {
            long percentClamp;
            long minFlex;
            long minPeriod = JobInfo.getMinPeriodMillis();
            if (intervalMillis < minPeriod) {
                Log.w(TAG, "Requested interval " + TimeUtils.formatDuration(intervalMillis) + " for job " + this.mJobId + " is too small; raising to " + TimeUtils.formatDuration(minPeriod));
                intervalMillis = minPeriod;
            }
            if (flexMillis < (minFlex = Math.max(percentClamp = 5L * intervalMillis / 100L, JobInfo.getMinFlexMillis()))) {
                Log.w(TAG, "Requested flex " + TimeUtils.formatDuration(flexMillis) + " for job " + this.mJobId + " is too small; raising to " + TimeUtils.formatDuration(minFlex));
                flexMillis = minFlex;
            }
            this.mIsPeriodic = true;
            this.mIntervalMillis = intervalMillis;
            this.mFlexMillis = flexMillis;
            this.mHasLateConstraint = true;
            this.mHasEarlyConstraint = true;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setMinimumLatency(long minLatencyMillis) {
            this.mMinLatencyMillis = minLatencyMillis;
            this.mHasEarlyConstraint = true;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setOverrideDeadline(long maxExecutionDelayMillis) {
            this.mMaxExecutionDelayMillis = maxExecutionDelayMillis;
            this.mHasLateConstraint = true;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setBackoffCriteria(long initialBackoffMillis, int backoffPolicy) {
            long minBackoff = JobInfo.getMinBackoffMillis();
            if (initialBackoffMillis < minBackoff) {
                Log.w(TAG, "Requested backoff " + TimeUtils.formatDuration(initialBackoffMillis) + " for job " + this.mJobId + " is too small; raising to " + TimeUtils.formatDuration(minBackoff));
                initialBackoffMillis = minBackoff;
            }
            this.mBackoffPolicySet = true;
            this.mInitialBackoffMillis = initialBackoffMillis;
            this.mBackoffPolicy = backoffPolicy;
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setImportantWhileForeground(boolean importantWhileForeground) {
            this.mFlags = importantWhileForeground ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_app_job_JobInfo_Builder$setIsPrefetch(boolean isPrefetch) {
            return this.setPrefetch(isPrefetch);
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setPrefetch(boolean prefetch) {
            this.mFlags = prefetch ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
            return this;
        }

        private final Builder $$robo$$android_app_job_JobInfo_Builder$setPersisted(boolean isPersisted) {
            this.mIsPersisted = isPersisted;
            return this;
        }

        private final JobInfo $$robo$$android_app_job_JobInfo_Builder$build() {
            if (!this.mHasEarlyConstraint && !this.mHasLateConstraint && this.mConstraintFlags == 0 && this.mNetworkRequest == null && this.mTriggerContentUris == null) {
                throw new IllegalArgumentException("You're trying to build a job with no constraints, this is not allowed.");
            }
            if ((this.mNetworkDownloadBytes > 0L || this.mNetworkUploadBytes > 0L) && this.mNetworkRequest == null) {
                throw new IllegalArgumentException("Can't provide estimated network usage without requiring a network");
            }
            if (this.mIsPersisted && this.mNetworkRequest != null && this.mNetworkRequest.networkCapabilities.getNetworkSpecifier() != null) {
                throw new IllegalArgumentException("Network specifiers aren't supported for persistent jobs");
            }
            if (this.mIsPeriodic) {
                if (this.mMaxExecutionDelayMillis != 0L) {
                    throw new IllegalArgumentException("Can't call setOverrideDeadline() on a periodic job.");
                }
                if (this.mMinLatencyMillis != 0L) {
                    throw new IllegalArgumentException("Can't call setMinimumLatency() on a periodic job");
                }
                if (this.mTriggerContentUris != null) {
                    throw new IllegalArgumentException("Can't call addTriggerContentUri() on a periodic job");
                }
            }
            if (this.mIsPersisted) {
                if (this.mTriggerContentUris != null) {
                    throw new IllegalArgumentException("Can't call addTriggerContentUri() on a persisted job");
                }
                if (!this.mTransientExtras.isEmpty()) {
                    throw new IllegalArgumentException("Can't call setTransientExtras() on a persisted job");
                }
                if (this.mClipData != null) {
                    throw new IllegalArgumentException("Can't call setClipData() on a persisted job");
                }
            }
            if ((this.mFlags & 2) != 0 && this.mHasEarlyConstraint) {
                throw new IllegalArgumentException("An important while foreground job cannot have a time delay");
            }
            if (this.mBackoffPolicySet && (this.mConstraintFlags & 4) != 0) {
                throw new IllegalArgumentException("An idle mode job will not respect any back-off policy, so calling setBackoffCriteria with setRequiresDeviceIdle is an error.");
            }
            return new JobInfo(this, null);
        }

        private void __constructor__(int n, ComponentName componentName) {
            this.$$robo$$android_app_job_JobInfo_Builder$__constructor__(n, componentName);
        }

        public Builder(int n, ComponentName componentName) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo_Builder$__constructor__(int android.content.ComponentName ), this, n, componentName);
        }

        public Builder setPriority(int n) {
            return InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_app_job_JobInfo_Builder$setPriority(int ), this, n);
        }

        public Builder setFlags(int n) {
            return InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_app_job_JobInfo_Builder$setFlags(int ), this, n);
        }

        public Builder setExtras(PersistableBundle persistableBundle) {
            return InvokeDynamicSupport.bootstrap("setExtras", $$robo$$android_app_job_JobInfo_Builder$setExtras(android.os.PersistableBundle ), this, persistableBundle);
        }

        public Builder setTransientExtras(Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("setTransientExtras", $$robo$$android_app_job_JobInfo_Builder$setTransientExtras(android.os.Bundle ), this, bundle);
        }

        public Builder setClipData(ClipData clipData, int n) {
            return InvokeDynamicSupport.bootstrap("setClipData", $$robo$$android_app_job_JobInfo_Builder$setClipData(android.content.ClipData int ), this, clipData, n);
        }

        public Builder setRequiredNetworkType(int n) {
            return InvokeDynamicSupport.bootstrap("setRequiredNetworkType", $$robo$$android_app_job_JobInfo_Builder$setRequiredNetworkType(int ), this, n);
        }

        public Builder setRequiredNetwork(NetworkRequest networkRequest) {
            return InvokeDynamicSupport.bootstrap("setRequiredNetwork", $$robo$$android_app_job_JobInfo_Builder$setRequiredNetwork(android.net.NetworkRequest ), this, networkRequest);
        }

        @Deprecated
        public Builder setEstimatedNetworkBytes(long l) {
            return InvokeDynamicSupport.bootstrap("setEstimatedNetworkBytes", $$robo$$android_app_job_JobInfo_Builder$setEstimatedNetworkBytes(long ), this, l);
        }

        public Builder setEstimatedNetworkBytes(long l, long l2) {
            return InvokeDynamicSupport.bootstrap("setEstimatedNetworkBytes", $$robo$$android_app_job_JobInfo_Builder$setEstimatedNetworkBytes(long long ), this, l, l2);
        }

        public Builder setRequiresCharging(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setRequiresCharging", $$robo$$android_app_job_JobInfo_Builder$setRequiresCharging(boolean ), this, bl);
        }

        public Builder setRequiresBatteryNotLow(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setRequiresBatteryNotLow", $$robo$$android_app_job_JobInfo_Builder$setRequiresBatteryNotLow(boolean ), this, bl);
        }

        public Builder setRequiresDeviceIdle(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setRequiresDeviceIdle", $$robo$$android_app_job_JobInfo_Builder$setRequiresDeviceIdle(boolean ), this, bl);
        }

        public Builder setRequiresStorageNotLow(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setRequiresStorageNotLow", $$robo$$android_app_job_JobInfo_Builder$setRequiresStorageNotLow(boolean ), this, bl);
        }

        public Builder addTriggerContentUri(TriggerContentUri triggerContentUri) {
            return InvokeDynamicSupport.bootstrap("addTriggerContentUri", $$robo$$android_app_job_JobInfo_Builder$addTriggerContentUri(android.app.job.JobInfo$TriggerContentUri ), this, triggerContentUri);
        }

        public Builder setTriggerContentUpdateDelay(long l) {
            return InvokeDynamicSupport.bootstrap("setTriggerContentUpdateDelay", $$robo$$android_app_job_JobInfo_Builder$setTriggerContentUpdateDelay(long ), this, l);
        }

        public Builder setTriggerContentMaxDelay(long l) {
            return InvokeDynamicSupport.bootstrap("setTriggerContentMaxDelay", $$robo$$android_app_job_JobInfo_Builder$setTriggerContentMaxDelay(long ), this, l);
        }

        public Builder setPeriodic(long l) {
            return InvokeDynamicSupport.bootstrap("setPeriodic", $$robo$$android_app_job_JobInfo_Builder$setPeriodic(long ), this, l);
        }

        public Builder setPeriodic(long l, long l2) {
            return InvokeDynamicSupport.bootstrap("setPeriodic", $$robo$$android_app_job_JobInfo_Builder$setPeriodic(long long ), this, l, l2);
        }

        public Builder setMinimumLatency(long l) {
            return InvokeDynamicSupport.bootstrap("setMinimumLatency", $$robo$$android_app_job_JobInfo_Builder$setMinimumLatency(long ), this, l);
        }

        public Builder setOverrideDeadline(long l) {
            return InvokeDynamicSupport.bootstrap("setOverrideDeadline", $$robo$$android_app_job_JobInfo_Builder$setOverrideDeadline(long ), this, l);
        }

        public Builder setBackoffCriteria(long l, int n) {
            return InvokeDynamicSupport.bootstrap("setBackoffCriteria", $$robo$$android_app_job_JobInfo_Builder$setBackoffCriteria(long int ), this, l, n);
        }

        public Builder setImportantWhileForeground(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setImportantWhileForeground", $$robo$$android_app_job_JobInfo_Builder$setImportantWhileForeground(boolean ), this, bl);
        }

        @Deprecated
        public Builder setIsPrefetch(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setIsPrefetch", $$robo$$android_app_job_JobInfo_Builder$setIsPrefetch(boolean ), this, bl);
        }

        public Builder setPrefetch(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setPrefetch", $$robo$$android_app_job_JobInfo_Builder$setPrefetch(boolean ), this, bl);
        }

        public Builder setPersisted(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setPersisted", $$robo$$android_app_job_JobInfo_Builder$setPersisted(boolean ), this, bl);
        }

        public JobInfo build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_app_job_JobInfo_Builder$build(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TriggerContentUri
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Uri mUri;
        private int mFlags;
        public static int FLAG_NOTIFY_FOR_DESCENDANTS = 1;
        public static Parcelable.Creator<TriggerContentUri> CREATOR;

        private void $$robo$$android_app_job_JobInfo_TriggerContentUri$__constructor__(Uri uri, int flags) {
            this.mUri = uri;
            this.mFlags = flags;
        }

        private final Uri $$robo$$android_app_job_JobInfo_TriggerContentUri$getUri() {
            return this.mUri;
        }

        private final int $$robo$$android_app_job_JobInfo_TriggerContentUri$getFlags() {
            return this.mFlags;
        }

        private final boolean $$robo$$android_app_job_JobInfo_TriggerContentUri$equals(Object o) {
            if (!(o instanceof TriggerContentUri)) {
                return false;
            }
            TriggerContentUri t = (TriggerContentUri)o;
            return Objects.equals(t.mUri, this.mUri) && t.mFlags == this.mFlags;
        }

        private final int $$robo$$android_app_job_JobInfo_TriggerContentUri$hashCode() {
            return (this.mUri == null ? 0 : this.mUri.hashCode()) ^ this.mFlags;
        }

        private void $$robo$$android_app_job_JobInfo_TriggerContentUri$__constructor__(Parcel in) {
            this.mUri = Uri.CREATOR.createFromParcel(in);
            this.mFlags = in.readInt();
        }

        private final int $$robo$$android_app_job_JobInfo_TriggerContentUri$describeContents() {
            return 0;
        }

        private final void $$robo$$android_app_job_JobInfo_TriggerContentUri$writeToParcel(Parcel out, int flags) {
            this.mUri.writeToParcel(out, flags);
            out.writeInt(this.mFlags);
        }

        private /* synthetic */ void $$robo$$android_app_job_JobInfo_TriggerContentUri$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<TriggerContentUri>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_app_job_JobInfo_TriggerContentUri_1$__constructor__() {
                }

                private final TriggerContentUri $$robo$$android_app_job_JobInfo_TriggerContentUri_1$createFromParcel(Parcel in) {
                    return new TriggerContentUri(in, null);
                }

                private final TriggerContentUri[] $$robo$$android_app_job_JobInfo_TriggerContentUri_1$newArray(int size) {
                    return new TriggerContentUri[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_app_job_JobInfo_TriggerContentUri_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo_TriggerContentUri_1$__constructor__(), this);
                }

                @Override
                public TriggerContentUri createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_app_job_JobInfo_TriggerContentUri_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public TriggerContentUri[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_app_job_JobInfo_TriggerContentUri_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Uri uri, int n) {
            this.$$robo$$android_app_job_JobInfo_TriggerContentUri$__constructor__(uri, n);
        }

        public TriggerContentUri(Uri uri, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo_TriggerContentUri$__constructor__(android.net.Uri int ), this, uri, n);
        }

        public Uri getUri() {
            return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_app_job_JobInfo_TriggerContentUri$getUri(), this);
        }

        public int getFlags() {
            return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_app_job_JobInfo_TriggerContentUri$getFlags(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_app_job_JobInfo_TriggerContentUri$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_app_job_JobInfo_TriggerContentUri$hashCode(), this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_app_job_JobInfo_TriggerContentUri$__constructor__(parcel);
        }

        public TriggerContentUri(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo_TriggerContentUri$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_app_job_JobInfo_TriggerContentUri$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_app_job_JobInfo_TriggerContentUri$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_app_job_JobInfo_TriggerContentUri$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ TriggerContentUri(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_job_JobInfo_TriggerContentUri$__constructor__(android.os.Parcel android.app.job.JobInfo$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(TriggerContentUri.class);
        }

        public /* synthetic */ TriggerContentUri() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TriggerContentUri)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flags {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BackoffPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetworkType {
    }
}

