/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.app.usage.NetworkStats;
import android.content.Context;
import android.net.DataUsageRequest;
import android.net.INetworkStatsService;
import android.net.NetworkIdentity;
import android.net.NetworkTemplate;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.DataUnit;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkStatsManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkStatsManager";
    private static boolean DBG = false;
    public static int CALLBACK_LIMIT_REACHED = 0;
    public static int CALLBACK_RELEASED = 1;
    public static long MIN_THRESHOLD_BYTES;
    private Context mContext;
    private INetworkStatsService mService;
    public static int FLAG_POLL_ON_OPEN = 1;
    public static int FLAG_POLL_FORCE = 2;
    public static int FLAG_AUGMENT_WITH_SUBSCRIPTION_PLAN = 4;
    private int mFlags;

    private void $$robo$$android_app_usage_NetworkStatsManager$__constructor__(Context context) throws ServiceManager.ServiceNotFoundException {
    }

    @VisibleForTesting
    private void $$robo$$android_app_usage_NetworkStatsManager$__constructor__(Context context, INetworkStatsService service) {
        this.mContext = context;
        this.mService = service;
        this.setPollOnOpen(true);
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$setPollOnOpen(boolean pollOnOpen) {
        this.mFlags = pollOnOpen ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$setPollForce(boolean pollForce) {
        this.mFlags = pollForce ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$setAugmentWithSubscriptionPlan(boolean augmentWithSubscriptionPlan) {
        this.mFlags = augmentWithSubscriptionPlan ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
    }

    private final NetworkStats.Bucket $$robo$$android_app_usage_NetworkStatsManager$querySummaryForDevice(NetworkTemplate template, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkStats.Bucket bucket = null;
        NetworkStats stats = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        bucket = stats.getDeviceSummaryForNetwork();
        stats.close();
        return bucket;
    }

    private final NetworkStats.Bucket $$robo$$android_app_usage_NetworkStatsManager$querySummaryForDevice(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.querySummaryForDevice(template, startTime, endTime);
    }

    private final NetworkStats.Bucket $$robo$$android_app_usage_NetworkStatsManager$querySummaryForUser(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats stats = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        stats.startSummaryEnumeration();
        stats.close();
        return stats.getSummaryAggregate();
    }

    private final NetworkStats $$robo$$android_app_usage_NetworkStatsManager$querySummary(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        result.startSummaryEnumeration();
        return result;
    }

    private final NetworkStats $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUid(int networkType, String subscriberId, long startTime, long endTime, int uid) throws SecurityException {
        return this.queryDetailsForUidTagState(networkType, subscriberId, startTime, endTime, uid, 0, -1);
    }

    private final NetworkStats $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUidTag(int networkType, String subscriberId, long startTime, long endTime, int uid, int tag) throws SecurityException {
        return this.queryDetailsForUidTagState(networkType, subscriberId, startTime, endTime, uid, tag, -1);
    }

    private final NetworkStats $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUidTagState(int networkType, String subscriberId, long startTime, long endTime, int uid, int tag, int state) throws SecurityException {
        NetworkStats result;
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        try {
            result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
            result.startHistoryEnumeration(uid, tag, state);
        }
        catch (RemoteException e) {
            Log.e("NetworkStatsManager", "Error while querying stats for uid=" + uid + " tag=" + tag + " state=" + state, e);
            return null;
        }
        return result;
    }

    private final NetworkStats $$robo$$android_app_usage_NetworkStatsManager$queryDetails(int networkType, String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        result.startUserUidEnumeration();
        return result;
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(NetworkTemplate template, int networkType, long thresholdBytes, UsageCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback, "UsageCallback cannot be null");
        Looper looper = handler == null ? Looper.myLooper() : handler.getLooper();
        DataUsageRequest request = new DataUsageRequest(0, template, thresholdBytes);
        try {
            CallbackHandler callbackHandler = new CallbackHandler(looper, networkType, template.getSubscriberId(), callback);
            callback.request = this.mService.registerUsageCallback(this.mContext.getOpPackageName(), request, new Messenger(callbackHandler), new Binder());
            if (callback.request == null) {
                Log.e("NetworkStatsManager", "Request from callback is null; should not happen");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(int networkType, String subscriberId, long thresholdBytes, UsageCallback callback) {
        this.registerUsageCallback(networkType, subscriberId, thresholdBytes, callback, null);
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(int networkType, String subscriberId, long thresholdBytes, UsageCallback callback, Handler handler) {
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        this.registerUsageCallback(template, networkType, thresholdBytes, callback, handler);
    }

    private final void $$robo$$android_app_usage_NetworkStatsManager$unregisterUsageCallback(UsageCallback callback) {
        if (callback == null || callback.request == null || ((UsageCallback)callback).request.requestId == 0) {
            throw new IllegalArgumentException("Invalid UsageCallback");
        }
        try {
            this.mService.unregisterUsageRequest(callback.request);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final NetworkTemplate $$robo$$android_app_usage_NetworkStatsManager$createTemplate(int networkType, String subscriberId) {
        NetworkTemplate template;
        switch (networkType) {
            case 0: {
                template = subscriberId == null ? NetworkTemplate.buildTemplateMobileWildcard() : NetworkTemplate.buildTemplateMobileAll(subscriberId);
                break;
            }
            case 1: {
                template = NetworkTemplate.buildTemplateWifiWildcard();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create template for network type " + networkType + ", subscriberId '" + NetworkIdentity.scrubSubscriberId(subscriberId) + "'.");
            }
        }
        return template;
    }

    static void __staticInitializer__() {
        MIN_THRESHOLD_BYTES = DataUnit.MEBIBYTES.toBytes(2L);
    }

    private void __constructor__(Context context) throws ServiceManager.ServiceNotFoundException {
        this.$$robo$$android_app_usage_NetworkStatsManager$__constructor__(context);
    }

    public NetworkStatsManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this(context, INetworkStatsService.Stub.asInterface(ServiceManager.getServiceOrThrow("netstats")));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_NetworkStatsManager$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, INetworkStatsService iNetworkStatsService) {
        this.$$robo$$android_app_usage_NetworkStatsManager$__constructor__(context, iNetworkStatsService);
    }

    public NetworkStatsManager(Context context, INetworkStatsService iNetworkStatsService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_NetworkStatsManager$__constructor__(android.content.Context android.net.INetworkStatsService ), this, context, iNetworkStatsService);
    }

    public void setPollOnOpen(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPollOnOpen", $$robo$$android_app_usage_NetworkStatsManager$setPollOnOpen(boolean ), this, bl);
    }

    public void setPollForce(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPollForce", $$robo$$android_app_usage_NetworkStatsManager$setPollForce(boolean ), this, bl);
    }

    public void setAugmentWithSubscriptionPlan(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAugmentWithSubscriptionPlan", $$robo$$android_app_usage_NetworkStatsManager$setAugmentWithSubscriptionPlan(boolean ), this, bl);
    }

    public NetworkStats.Bucket querySummaryForDevice(NetworkTemplate networkTemplate, long l, long l2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("querySummaryForDevice", $$robo$$android_app_usage_NetworkStatsManager$querySummaryForDevice(android.net.NetworkTemplate long long ), this, networkTemplate, l, l2);
    }

    public NetworkStats.Bucket querySummaryForDevice(int n, String string2, long l, long l2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("querySummaryForDevice", $$robo$$android_app_usage_NetworkStatsManager$querySummaryForDevice(int java.lang.String long long ), this, n, string2, l, l2);
    }

    public NetworkStats.Bucket querySummaryForUser(int n, String string2, long l, long l2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("querySummaryForUser", $$robo$$android_app_usage_NetworkStatsManager$querySummaryForUser(int java.lang.String long long ), this, n, string2, l, l2);
    }

    public NetworkStats querySummary(int n, String string2, long l, long l2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("querySummary", $$robo$$android_app_usage_NetworkStatsManager$querySummary(int java.lang.String long long ), this, n, string2, l, l2);
    }

    public NetworkStats queryDetailsForUid(int n, String string2, long l, long l2, int n2) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("queryDetailsForUid", $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUid(int java.lang.String long long int ), this, n, string2, l, l2, n2);
    }

    public NetworkStats queryDetailsForUidTag(int n, String string2, long l, long l2, int n2, int n3) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("queryDetailsForUidTag", $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUidTag(int java.lang.String long long int int ), this, n, string2, l, l2, n2, n3);
    }

    public NetworkStats queryDetailsForUidTagState(int n, String string2, long l, long l2, int n2, int n3, int n4) throws SecurityException {
        return InvokeDynamicSupport.bootstrap("queryDetailsForUidTagState", $$robo$$android_app_usage_NetworkStatsManager$queryDetailsForUidTagState(int java.lang.String long long int int int ), this, n, string2, l, l2, n2, n3, n4);
    }

    public NetworkStats queryDetails(int n, String string2, long l, long l2) throws SecurityException, RemoteException {
        return InvokeDynamicSupport.bootstrap("queryDetails", $$robo$$android_app_usage_NetworkStatsManager$queryDetails(int java.lang.String long long ), this, n, string2, l, l2);
    }

    public void registerUsageCallback(NetworkTemplate networkTemplate, int n, long l, UsageCallback usageCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerUsageCallback", $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(android.net.NetworkTemplate int long android.app.usage.NetworkStatsManager$UsageCallback android.os.Handler ), this, networkTemplate, n, l, usageCallback, handler);
    }

    public void registerUsageCallback(int n, String string2, long l, UsageCallback usageCallback) {
        InvokeDynamicSupport.bootstrap("registerUsageCallback", $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(int java.lang.String long android.app.usage.NetworkStatsManager$UsageCallback ), this, n, string2, l, usageCallback);
    }

    public void registerUsageCallback(int n, String string2, long l, UsageCallback usageCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerUsageCallback", $$robo$$android_app_usage_NetworkStatsManager$registerUsageCallback(int java.lang.String long android.app.usage.NetworkStatsManager$UsageCallback android.os.Handler ), this, n, string2, l, usageCallback, handler);
    }

    public void unregisterUsageCallback(UsageCallback usageCallback) {
        InvokeDynamicSupport.bootstrap("unregisterUsageCallback", $$robo$$android_app_usage_NetworkStatsManager$unregisterUsageCallback(android.app.usage.NetworkStatsManager$UsageCallback ), this, usageCallback);
    }

    private static NetworkTemplate createTemplate(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createTemplate", $$robo$$android_app_usage_NetworkStatsManager$createTemplate(int java.lang.String ), (int)n, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(NetworkStatsManager.class);
    }

    public /* synthetic */ NetworkStatsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkStatsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CallbackHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mNetworkType;
        private String mSubscriberId;
        private UsageCallback mCallback;

        private void $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$__constructor__(Looper looper, int networkType, String subscriberId, UsageCallback callback) {
            this.mNetworkType = networkType;
            this.mSubscriberId = subscriberId;
            this.mCallback = callback;
        }

        private final void $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$handleMessage(Message message) {
            DataUsageRequest request = (DataUsageRequest)CallbackHandler.getObject(message, "DataUsageRequest");
            switch (message.what) {
                case 0: {
                    if (this.mCallback != null) {
                        this.mCallback.onThresholdReached(this.mNetworkType, this.mSubscriberId);
                        break;
                    }
                    Log.e("NetworkStatsManager", "limit reached with released callback for " + request);
                    break;
                }
                case 1: {
                    this.mCallback = null;
                }
            }
        }

        private static final Object $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$getObject(Message msg, String key) {
            return msg.getData().getParcelable(key);
        }

        private void __constructor__(Looper looper, int n, String string2, UsageCallback usageCallback) {
            this.$$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$__constructor__(looper, n, string2, usageCallback);
        }

        public CallbackHandler(Looper looper, int n, String string2, UsageCallback usageCallback) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$__constructor__(android.os.Looper int java.lang.String android.app.usage.NetworkStatsManager$UsageCallback ), this, looper, n, string2, usageCallback);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$handleMessage(android.os.Message ), this, message);
        }

        private static Object getObject(Message message, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getObject", $$robo$$android_app_usage_NetworkStatsManager_CallbackHandler$getObject(android.os.Message java.lang.String ), (Message)message, (String)string2);
        }

        public /* synthetic */ CallbackHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class UsageCallback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private DataUsageRequest request;

        private void $$robo$$android_app_usage_NetworkStatsManager_UsageCallback$__constructor__() {
        }

        public abstract void onThresholdReached(int var1, String var2);

        private void __constructor__() {
            this.$$robo$$android_app_usage_NetworkStatsManager_UsageCallback$__constructor__();
        }

        public UsageCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_NetworkStatsManager_UsageCallback$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsageCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

