/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.app.usage.AppStandbyInfo;
import android.app.usage.ConfigurationStats;
import android.app.usage.EventStats;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class UsageStatsManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int INTERVAL_DAILY = 0;
    public static int INTERVAL_WEEKLY = 1;
    public static int INTERVAL_MONTHLY = 2;
    public static int INTERVAL_YEARLY = 3;
    public static int INTERVAL_BEST = 4;
    public static int INTERVAL_COUNT = 4;
    @SystemApi
    public static int STANDBY_BUCKET_EXEMPTED = 5;
    public static int STANDBY_BUCKET_ACTIVE = 10;
    public static int STANDBY_BUCKET_WORKING_SET = 20;
    public static int STANDBY_BUCKET_FREQUENT = 30;
    public static int STANDBY_BUCKET_RARE = 40;
    @SystemApi
    public static int STANDBY_BUCKET_NEVER = 50;
    public static int REASON_MAIN_MASK = 65280;
    public static int REASON_MAIN_DEFAULT = 256;
    public static int REASON_MAIN_TIMEOUT = 512;
    public static int REASON_MAIN_USAGE = 768;
    public static int REASON_MAIN_FORCED = 1024;
    public static int REASON_MAIN_PREDICTED = 1280;
    public static int REASON_SUB_MASK = 255;
    public static int REASON_SUB_USAGE_SYSTEM_INTERACTION = 1;
    public static int REASON_SUB_USAGE_NOTIFICATION_SEEN = 2;
    public static int REASON_SUB_USAGE_USER_INTERACTION = 3;
    public static int REASON_SUB_USAGE_MOVE_TO_FOREGROUND = 4;
    public static int REASON_SUB_USAGE_MOVE_TO_BACKGROUND = 5;
    public static int REASON_SUB_USAGE_SYSTEM_UPDATE = 6;
    public static int REASON_SUB_USAGE_ACTIVE_TIMEOUT = 7;
    public static int REASON_SUB_USAGE_SYNC_ADAPTER = 8;
    public static int REASON_SUB_USAGE_SLICE_PINNED = 9;
    public static int REASON_SUB_USAGE_SLICE_PINNED_PRIV = 10;
    public static int REASON_SUB_USAGE_EXEMPTED_SYNC_SCHEDULED_NON_DOZE = 11;
    public static int REASON_SUB_USAGE_EXEMPTED_SYNC_SCHEDULED_DOZE = 12;
    public static int REASON_SUB_USAGE_EXEMPTED_SYNC_START = 13;
    public static int REASON_SUB_PREDICTED_RESTORED = 1;
    @SystemApi
    public static String EXTRA_OBSERVER_ID = "android.app.usage.extra.OBSERVER_ID";
    @SystemApi
    public static String EXTRA_TIME_LIMIT = "android.app.usage.extra.TIME_LIMIT";
    @SystemApi
    public static String EXTRA_TIME_USED = "android.app.usage.extra.TIME_USED";
    private static UsageEvents sEmptyResults;
    private Context mContext;
    private IUsageStatsManager mService;

    private void $$robo$$android_app_usage_UsageStatsManager$__constructor__(Context context, IUsageStatsManager service) {
        this.mContext = context;
        this.mService = service;
    }

    private final List<UsageStats> $$robo$$android_app_usage_UsageStatsManager$queryUsageStats(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryUsageStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private final List<ConfigurationStats> $$robo$$android_app_usage_UsageStatsManager$queryConfigurations(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryConfigurationStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private final List<EventStats> $$robo$$android_app_usage_UsageStatsManager$queryEventStats(int intervalType, long beginTime, long endTime) {
        try {
            ParceledListSlice slice = this.mService.queryEventStats(intervalType, beginTime, endTime, this.mContext.getOpPackageName());
            if (slice != null) {
                return slice.getList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private final UsageEvents $$robo$$android_app_usage_UsageStatsManager$queryEvents(long beginTime, long endTime) {
        try {
            UsageEvents iter = this.mService.queryEvents(beginTime, endTime, this.mContext.getOpPackageName());
            if (iter != null) {
                return iter;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sEmptyResults;
    }

    private final UsageEvents $$robo$$android_app_usage_UsageStatsManager$queryEventsForSelf(long beginTime, long endTime) {
        try {
            UsageEvents events = this.mService.queryEventsForPackage(beginTime, endTime, this.mContext.getOpPackageName());
            if (events != null) {
                return events;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sEmptyResults;
    }

    private final Map<String, UsageStats> $$robo$$android_app_usage_UsageStatsManager$queryAndAggregateUsageStats(long beginTime, long endTime) {
        List<UsageStats> stats = this.queryUsageStats(4, beginTime, endTime);
        if (stats.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayMap<String, UsageStats> aggregatedStats = new ArrayMap<String, UsageStats>();
        int statCount = stats.size();
        for (int i = 0; i < statCount; ++i) {
            UsageStats newStat = stats.get(i);
            UsageStats existingStat = aggregatedStats.get(newStat.getPackageName());
            if (existingStat == null) {
                aggregatedStats.put(newStat.mPackageName, newStat);
                continue;
            }
            existingStat.add(newStat);
        }
        return aggregatedStats;
    }

    private final boolean $$robo$$android_app_usage_UsageStatsManager$isAppInactive(String packageName) {
        try {
            return this.mService.isAppInactive(packageName, this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final void $$robo$$android_app_usage_UsageStatsManager$setAppInactive(String packageName, boolean inactive) {
        try {
            this.mService.setAppInactive(packageName, inactive, this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final int $$robo$$android_app_usage_UsageStatsManager$getAppStandbyBucket() {
        try {
            return this.mService.getAppStandbyBucket(this.mContext.getOpPackageName(), this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            return 10;
        }
    }

    @SystemApi
    private final int $$robo$$android_app_usage_UsageStatsManager$getAppStandbyBucket(String packageName) {
        try {
            return this.mService.getAppStandbyBucket(packageName, this.mContext.getOpPackageName(), this.mContext.getUserId());
        }
        catch (RemoteException remoteException) {
            return 10;
        }
    }

    @SystemApi
    private final void $$robo$$android_app_usage_UsageStatsManager$setAppStandbyBucket(String packageName, int bucket) {
        try {
            this.mService.setAppStandbyBucket(packageName, bucket, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final Map<String, Integer> $$robo$$android_app_usage_UsageStatsManager$getAppStandbyBuckets() {
        try {
            ParceledListSlice slice = this.mService.getAppStandbyBuckets(this.mContext.getOpPackageName(), this.mContext.getUserId());
            List bucketList = slice.getList();
            ArrayMap<String, Integer> bucketMap = new ArrayMap<String, Integer>();
            int n = bucketList.size();
            for (int i = 0; i < n; ++i) {
                AppStandbyInfo bucketInfo = (AppStandbyInfo)bucketList.get(i);
                bucketMap.put(bucketInfo.mPackageName, bucketInfo.mStandbyBucket);
            }
            return bucketMap;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_app_usage_UsageStatsManager$setAppStandbyBuckets(Map<String, Integer> appBuckets) {
        if (appBuckets == null) {
            return;
        }
        ArrayList<AppStandbyInfo> bucketInfoList = new ArrayList<AppStandbyInfo>(appBuckets.size());
        for (Map.Entry<String, Integer> bucketEntry : appBuckets.entrySet()) {
            bucketInfoList.add(new AppStandbyInfo(bucketEntry.getKey(), bucketEntry.getValue()));
        }
        ParceledListSlice slice = new ParceledListSlice(bucketInfoList);
        try {
            this.mService.setAppStandbyBuckets(slice, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_app_usage_UsageStatsManager$registerAppUsageObserver(int observerId, String[] packages, long timeLimit, TimeUnit timeUnit, PendingIntent callbackIntent) {
        try {
            this.mService.registerAppUsageObserver(observerId, packages, timeUnit.toMillis(timeLimit), callbackIntent, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_app_usage_UsageStatsManager$unregisterAppUsageObserver(int observerId) {
        try {
            this.mService.unregisterAppUsageObserver(observerId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final String $$robo$$android_app_usage_UsageStatsManager$reasonToString(int standbyReason) {
        StringBuilder sb = new StringBuilder();
        block0 : switch (standbyReason & 0xFF00) {
            case 256: {
                sb.append("d");
                break;
            }
            case 1024: {
                sb.append("f");
                break;
            }
            case 1280: {
                sb.append("p");
                switch (standbyReason & 0xFF) {
                    case 1: {
                        sb.append("-r");
                    }
                }
                break;
            }
            case 512: {
                sb.append("t");
                break;
            }
            case 768: {
                sb.append("u");
                switch (standbyReason & 0xFF) {
                    case 1: {
                        sb.append("-si");
                        break block0;
                    }
                    case 2: {
                        sb.append("-ns");
                        break block0;
                    }
                    case 3: {
                        sb.append("-ui");
                        break block0;
                    }
                    case 4: {
                        sb.append("-mf");
                        break block0;
                    }
                    case 5: {
                        sb.append("-mb");
                        break block0;
                    }
                    case 6: {
                        sb.append("-su");
                        break block0;
                    }
                    case 7: {
                        sb.append("-at");
                        break block0;
                    }
                    case 8: {
                        sb.append("-sa");
                        break block0;
                    }
                    case 9: {
                        sb.append("-lp");
                        break block0;
                    }
                    case 10: {
                        sb.append("-lv");
                        break block0;
                    }
                    case 11: {
                        sb.append("-en");
                        break block0;
                    }
                    case 12: {
                        sb.append("-ed");
                        break block0;
                    }
                    case 13: {
                        sb.append("-es");
                    }
                }
            }
        }
        return sb.toString();
    }

    @SystemApi
    private final void $$robo$$android_app_usage_UsageStatsManager$whitelistAppTemporarily(String packageName, long duration, UserHandle user) {
        try {
            this.mService.whitelistAppTemporarily(packageName, duration, user.getIdentifier());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_usage_UsageStatsManager$onCarrierPrivilegedAppsChanged() {
        try {
            this.mService.onCarrierPrivilegedAppsChanged();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_app_usage_UsageStatsManager$reportChooserSelection(String packageName, int userId, String contentType, String[] annotations, String action) {
        try {
            this.mService.reportChooserSelection(packageName, userId, contentType, annotations, action);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    static void __staticInitializer__() {
        sEmptyResults = new UsageEvents();
    }

    private void __constructor__(Context context, IUsageStatsManager iUsageStatsManager) {
        this.$$robo$$android_app_usage_UsageStatsManager$__constructor__(context, iUsageStatsManager);
    }

    public UsageStatsManager(Context context, IUsageStatsManager iUsageStatsManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_app_usage_UsageStatsManager$__constructor__(android.content.Context android.app.usage.IUsageStatsManager ), this, context, iUsageStatsManager);
    }

    public List<UsageStats> queryUsageStats(int n, long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryUsageStats", $$robo$$android_app_usage_UsageStatsManager$queryUsageStats(int long long ), this, n, l, l2);
    }

    public List<ConfigurationStats> queryConfigurations(int n, long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryConfigurations", $$robo$$android_app_usage_UsageStatsManager$queryConfigurations(int long long ), this, n, l, l2);
    }

    public List<EventStats> queryEventStats(int n, long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryEventStats", $$robo$$android_app_usage_UsageStatsManager$queryEventStats(int long long ), this, n, l, l2);
    }

    public UsageEvents queryEvents(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryEvents", $$robo$$android_app_usage_UsageStatsManager$queryEvents(long long ), this, l, l2);
    }

    public UsageEvents queryEventsForSelf(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryEventsForSelf", $$robo$$android_app_usage_UsageStatsManager$queryEventsForSelf(long long ), this, l, l2);
    }

    public Map<String, UsageStats> queryAndAggregateUsageStats(long l, long l2) {
        return InvokeDynamicSupport.bootstrap("queryAndAggregateUsageStats", $$robo$$android_app_usage_UsageStatsManager$queryAndAggregateUsageStats(long long ), this, l, l2);
    }

    public boolean isAppInactive(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAppInactive", $$robo$$android_app_usage_UsageStatsManager$isAppInactive(java.lang.String ), this, string2);
    }

    public void setAppInactive(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setAppInactive", $$robo$$android_app_usage_UsageStatsManager$setAppInactive(java.lang.String boolean ), this, string2, bl);
    }

    public int getAppStandbyBucket() {
        return (int)InvokeDynamicSupport.bootstrap("getAppStandbyBucket", $$robo$$android_app_usage_UsageStatsManager$getAppStandbyBucket(), this);
    }

    @SystemApi
    public int getAppStandbyBucket(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getAppStandbyBucket", $$robo$$android_app_usage_UsageStatsManager$getAppStandbyBucket(java.lang.String ), this, string2);
    }

    @SystemApi
    public void setAppStandbyBucket(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setAppStandbyBucket", $$robo$$android_app_usage_UsageStatsManager$setAppStandbyBucket(java.lang.String int ), this, string2, n);
    }

    @SystemApi
    public Map<String, Integer> getAppStandbyBuckets() {
        return InvokeDynamicSupport.bootstrap("getAppStandbyBuckets", $$robo$$android_app_usage_UsageStatsManager$getAppStandbyBuckets(), this);
    }

    @SystemApi
    public void setAppStandbyBuckets(Map<String, Integer> map) {
        InvokeDynamicSupport.bootstrap("setAppStandbyBuckets", $$robo$$android_app_usage_UsageStatsManager$setAppStandbyBuckets(java.util.Map<java.lang.String, java.lang.Integer> ), this, map);
    }

    @SystemApi
    public void registerAppUsageObserver(int n, String[] stringArray, long l, TimeUnit timeUnit, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("registerAppUsageObserver", $$robo$$android_app_usage_UsageStatsManager$registerAppUsageObserver(int java.lang.String[] long java.util.concurrent.TimeUnit android.app.PendingIntent ), this, n, stringArray, l, timeUnit, pendingIntent);
    }

    @SystemApi
    public void unregisterAppUsageObserver(int n) {
        InvokeDynamicSupport.bootstrap("unregisterAppUsageObserver", $$robo$$android_app_usage_UsageStatsManager$unregisterAppUsageObserver(int ), this, n);
    }

    public static String reasonToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("reasonToString", $$robo$$android_app_usage_UsageStatsManager$reasonToString(int ), (int)n);
    }

    @SystemApi
    public void whitelistAppTemporarily(String string2, long l, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("whitelistAppTemporarily", $$robo$$android_app_usage_UsageStatsManager$whitelistAppTemporarily(java.lang.String long android.os.UserHandle ), this, string2, l, userHandle);
    }

    public void onCarrierPrivilegedAppsChanged() {
        InvokeDynamicSupport.bootstrap("onCarrierPrivilegedAppsChanged", $$robo$$android_app_usage_UsageStatsManager$onCarrierPrivilegedAppsChanged(), this);
    }

    public void reportChooserSelection(String string2, int n, String string3, String[] stringArray, String string4) {
        InvokeDynamicSupport.bootstrap("reportChooserSelection", $$robo$$android_app_usage_UsageStatsManager$reportChooserSelection(java.lang.String int java.lang.String java.lang.String[] java.lang.String ), this, string2, n, string3, stringArray, string4);
    }

    static {
        RobolectricInternals.classInitializing(UsageStatsManager.class);
    }

    public /* synthetic */ UsageStatsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UsageStatsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StandbyBuckets {
    }
}

