/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHearingAid;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothHearingAid
implements BluetoothProfile,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothHearingAid";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.hearingaid.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.hearingaid.profile.action.PLAYING_STATE_CHANGED";
    public static String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.hearingaid.profile.action.ACTIVE_DEVICE_CHANGED";
    public static int STATE_PLAYING = 10;
    public static int STATE_NOT_PLAYING = 11;
    public static int SIDE_LEFT = 0;
    public static int SIDE_RIGHT = 1;
    public static int MODE_MONAURAL = 0;
    public static int MODE_BINAURAL = 1;
    public static long HI_SYNC_ID_INVALID = 0L;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private ReentrantReadWriteLock mServiceLock;
    @GuardedBy(value="mServiceLock")
    private IBluetoothHearingAid mService;
    private BluetoothAdapter mAdapter;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothHearingAid$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mServiceLock = new ReentrantReadWriteLock();
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHearingAid this$0;

            private void $$robo$$android_bluetooth_BluetoothHearingAid_1$__constructor__(BluetoothHearingAid this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothHearingAid_1$onBluetoothStateChange(boolean up) {
                if (!up) {
                    try {
                        this.this$0.mServiceLock.writeLock().lock();
                        this.this$0.mService = null;
                        this.this$0.mContext.unbindService(this.this$0.mConnection);
                    }
                    catch (Exception re) {
                        Log.e("BluetoothHearingAid", "", re);
                    }
                    finally {
                        this.this$0.mServiceLock.writeLock().unlock();
                    }
                } else {
                    try {
                        this.this$0.mServiceLock.readLock().lock();
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothHearingAid", "", re);
                    }
                    finally {
                        this.this$0.mServiceLock.readLock().unlock();
                    }
                }
            }

            private void __constructor__(BluetoothHearingAid bluetoothHearingAid) {
                this.$$robo$$android_bluetooth_BluetoothHearingAid_1$__constructor__(bluetoothHearingAid);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHearingAid_1$__constructor__(android.bluetooth.BluetoothHearingAid ), this, bluetoothHearingAid);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothHearingAid_1$onBluetoothStateChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHearingAid this$0;

            private void $$robo$$android_bluetooth_BluetoothHearingAid_2$__constructor__(BluetoothHearingAid this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_bluetooth_BluetoothHearingAid_2$onServiceConnected(ComponentName className, IBinder service) {
                try {
                    this.this$0.mServiceLock.writeLock().lock();
                    this.this$0.mService = IBluetoothHearingAid.Stub.asInterface(Binder.allowBlocking(service));
                }
                finally {
                    this.this$0.mServiceLock.writeLock().unlock();
                }
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(21, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothHearingAid_2$onServiceDisconnected(ComponentName className) {
                try {
                    this.this$0.mServiceLock.writeLock().lock();
                    this.this$0.mService = null;
                }
                finally {
                    this.this$0.mServiceLock.writeLock().unlock();
                }
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(21);
                }
            }

            private void __constructor__(BluetoothHearingAid bluetoothHearingAid) {
                this.$$robo$$android_bluetooth_BluetoothHearingAid_2$__constructor__(bluetoothHearingAid);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHearingAid_2$__constructor__(android.bluetooth.BluetoothHearingAid ), this, bluetoothHearingAid);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothHearingAid_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothHearingAid_2$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHearingAid", "", e);
            }
        }
        this.doBind();
    }

    private final void $$robo$$android_bluetooth_BluetoothHearingAid$doBind() {
        Intent intent = new Intent(IBluetoothHearingAid.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e("BluetoothHearingAid", "Could not bind to Bluetooth Hearing Aid Service with " + intent);
            return;
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothHearingAid$close() {
        this.mServiceListener = null;
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothHearingAid", "", e);
            }
        }
        try {
            this.mServiceLock.writeLock().lock();
            if (this.mService != null) {
                this.mService = null;
                this.mContext.unbindService(this.mConnection);
            }
        }
        catch (Exception re) {
            Log.e("BluetoothHearingAid", "", re);
        }
        finally {
            this.mServiceLock.writeLock().unlock();
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothHearingAid$finalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothHearingAid$connect(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.connect(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothHearingAid$disconnect(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                boolean bl = this.mService.disconnect(device);
                return bl;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHearingAid$getConnectedDevices() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHearingAid$getDevicesMatchingConnectionStates(int[] states) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(states);
                return list;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothHearingAid$getConnectionState(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getConnectionState(device);
                return n;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothHearingAid$setActiveDevice(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && (device == null || this.isValidDevice(device))) {
                this.mService.setActiveDevice(device);
                boolean bl = true;
                return bl;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHearingAid$getActiveDevices() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                List<BluetoothDevice> list = this.mService.getActiveDevices();
                return list;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            return arrayList;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_bluetooth_BluetoothHearingAid$setPriority(BluetoothDevice device, int priority) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                if (priority != 0 && priority != 100) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.mService.setPriority(device, priority);
                return bl;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            boolean bl = false;
            return bl;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothHearingAid$getPriority(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getPriority(device);
                return n;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private static final String $$robo$$android_bluetooth_BluetoothHearingAid$stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 10: {
                return "playing";
            }
            case 11: {
                return "not playing";
            }
        }
        return "<unknown state " + state + ">";
    }

    private final int $$robo$$android_bluetooth_BluetoothHearingAid$getVolume() {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled()) {
                int n = this.mService.getVolume();
                return n;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothHearingAid$adjustVolume(int direction) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            this.mService.adjustVolume(direction);
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final void $$robo$$android_bluetooth_BluetoothHearingAid$setVolume(int volume) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
                return;
            }
            if (!this.isEnabled()) {
                return;
            }
            this.mService.setVolume(volume);
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_bluetooth_BluetoothHearingAid$getHiSyncId(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
                long l = 0L;
                return l;
            }
            if (!this.isEnabled() || !this.isValidDevice(device)) {
                long l = 0L;
                return l;
            }
            long l = this.mService.getHiSyncId(device);
            return l;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            long l = 0L;
            return l;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothHearingAid$getDeviceSide(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getDeviceSide(device);
                return n;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_bluetooth_BluetoothHearingAid$getDeviceMode(BluetoothDevice device) {
        try {
            this.mServiceLock.readLock().lock();
            if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
                int n = this.mService.getDeviceMode(device);
                return n;
            }
            if (this.mService == null) {
                Log.w("BluetoothHearingAid", "Proxy not attached to service");
            }
            int n = 0;
            return n;
        }
        catch (RemoteException e) {
            Log.e("BluetoothHearingAid", "Stack:" + Log.getStackTraceString(new Throwable()));
            int n = 0;
            return n;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHearingAid$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHearingAid$isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static final void $$robo$$android_bluetooth_BluetoothHearingAid$log(String msg) {
        Log.d("BluetoothHearingAid", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothHearingAid$__constructor__(context, serviceListener);
    }

    public BluetoothHearingAid(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHearingAid$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), this, context, serviceListener);
    }

    void doBind() {
        InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothHearingAid$doBind(), this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothHearingAid$close(), this);
    }

    public void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothHearingAid$finalize(), this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothHearingAid$connect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothHearingAid$disconnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothHearingAid$getConnectedDevices(), this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothHearingAid$getDevicesMatchingConnectionStates(int[] ), this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothHearingAid$getConnectionState(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean setActiveDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("setActiveDevice", $$robo$$android_bluetooth_BluetoothHearingAid$setActiveDevice(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public List<BluetoothDevice> getActiveDevices() {
        return InvokeDynamicSupport.bootstrap("getActiveDevices", $$robo$$android_bluetooth_BluetoothHearingAid$getActiveDevices(), this);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothHearingAid$setPriority(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothHearingAid$getPriority(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public static String stateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_bluetooth_BluetoothHearingAid$stateToString(int ), (int)n);
    }

    public int getVolume() {
        return (int)InvokeDynamicSupport.bootstrap("getVolume", $$robo$$android_bluetooth_BluetoothHearingAid$getVolume(), this);
    }

    public void adjustVolume(int n) {
        InvokeDynamicSupport.bootstrap("adjustVolume", $$robo$$android_bluetooth_BluetoothHearingAid$adjustVolume(int ), this, n);
    }

    public void setVolume(int n) {
        InvokeDynamicSupport.bootstrap("setVolume", $$robo$$android_bluetooth_BluetoothHearingAid$setVolume(int ), this, n);
    }

    public long getHiSyncId(BluetoothDevice bluetoothDevice) {
        return (long)InvokeDynamicSupport.bootstrap("getHiSyncId", $$robo$$android_bluetooth_BluetoothHearingAid$getHiSyncId(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public int getDeviceSide(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceSide", $$robo$$android_bluetooth_BluetoothHearingAid$getDeviceSide(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public int getDeviceMode(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getDeviceMode", $$robo$$android_bluetooth_BluetoothHearingAid$getDeviceMode(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothHearingAid$isEnabled(), this);
    }

    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidDevice", $$robo$$android_bluetooth_BluetoothHearingAid$isValidDevice(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothHearingAid$log(java.lang.String ), (String)string2);
    }

    public /* synthetic */ BluetoothHearingAid() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothHearingAid)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

