/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothHidHost;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothHidHost
implements BluetoothProfile,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothHidHost";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.input.profile.action.CONNECTION_STATE_CHANGED";
    public static String ACTION_PROTOCOL_MODE_CHANGED = "android.bluetooth.input.profile.action.PROTOCOL_MODE_CHANGED";
    public static String ACTION_HANDSHAKE = "android.bluetooth.input.profile.action.HANDSHAKE";
    public static String ACTION_REPORT = "android.bluetooth.input.profile.action.REPORT";
    public static String ACTION_VIRTUAL_UNPLUG_STATUS = "android.bluetooth.input.profile.action.VIRTUAL_UNPLUG_STATUS";
    public static String ACTION_IDLE_TIME_CHANGED = "android.bluetooth.input.profile.action.IDLE_TIME_CHANGED";
    public static int INPUT_DISCONNECT_FAILED_NOT_CONNECTED = 5000;
    public static int INPUT_CONNECT_FAILED_ALREADY_CONNECTED = 5001;
    public static int INPUT_CONNECT_FAILED_ATTEMPT_FAILED = 5002;
    public static int INPUT_OPERATION_GENERIC_FAILURE = 5003;
    public static int INPUT_OPERATION_SUCCESS = 5004;
    public static int PROTOCOL_REPORT_MODE = 0;
    public static int PROTOCOL_BOOT_MODE = 1;
    public static int PROTOCOL_UNSUPPORTED_MODE = 255;
    public static byte REPORT_TYPE_INPUT = 1;
    public static byte REPORT_TYPE_OUTPUT = 2;
    public static byte REPORT_TYPE_FEATURE = 3;
    public static int VIRTUAL_UNPLUG_STATUS_SUCCESS = 0;
    public static int VIRTUAL_UNPLUG_STATUS_FAIL = 1;
    public static String EXTRA_PROTOCOL_MODE = "android.bluetooth.BluetoothHidHost.extra.PROTOCOL_MODE";
    public static String EXTRA_REPORT_TYPE = "android.bluetooth.BluetoothHidHost.extra.REPORT_TYPE";
    public static String EXTRA_REPORT_ID = "android.bluetooth.BluetoothHidHost.extra.REPORT_ID";
    public static String EXTRA_REPORT_BUFFER_SIZE = "android.bluetooth.BluetoothHidHost.extra.REPORT_BUFFER_SIZE";
    public static String EXTRA_REPORT = "android.bluetooth.BluetoothHidHost.extra.REPORT";
    public static String EXTRA_STATUS = "android.bluetooth.BluetoothHidHost.extra.STATUS";
    public static String EXTRA_VIRTUAL_UNPLUG_STATUS = "android.bluetooth.BluetoothHidHost.extra.VIRTUAL_UNPLUG_STATUS";
    public static String EXTRA_IDLE_TIME = "android.bluetooth.BluetoothHidHost.extra.IDLE_TIME";
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    private volatile IBluetoothHidHost mService;
    private IBluetoothStateChangeCallback mBluetoothStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothHidHost$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mBluetoothStateChangeCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHidHost this$0;

            private void $$robo$$android_bluetooth_BluetoothHidHost_1$__constructor__(BluetoothHidHost this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothHidHost_1$onBluetoothStateChange(boolean up) {
                Log.d("BluetoothHidHost", "onBluetoothStateChange: up=" + up);
                if (!up) {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothHidHost", "", re);
                        }
                    }
                }
                ServiceConnection serviceConnection = this.this$0.mConnection;
                synchronized (serviceConnection) {
                    try {
                        if (this.this$0.mService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (Exception re) {
                        Log.e("BluetoothHidHost", "", re);
                    }
                }
            }

            private void __constructor__(BluetoothHidHost bluetoothHidHost) {
                this.$$robo$$android_bluetooth_BluetoothHidHost_1$__constructor__(bluetoothHidHost);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHidHost_1$__constructor__(android.bluetooth.BluetoothHidHost ), this, bluetoothHidHost);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothHidHost_1$onBluetoothStateChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothHidHost this$0;

            private void $$robo$$android_bluetooth_BluetoothHidHost_2$__constructor__(BluetoothHidHost this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_bluetooth_BluetoothHidHost_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d("BluetoothHidHost", "Proxy object connected");
                this.this$0.mService = IBluetoothHidHost.Stub.asInterface(Binder.allowBlocking(service));
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(4, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothHidHost_2$onServiceDisconnected(ComponentName className) {
                Log.d("BluetoothHidHost", "Proxy object disconnected");
                this.this$0.mService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(4);
                }
            }

            private void __constructor__(BluetoothHidHost bluetoothHidHost) {
                this.$$robo$$android_bluetooth_BluetoothHidHost_2$__constructor__(bluetoothHidHost);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHidHost_2$__constructor__(android.bluetooth.BluetoothHidHost ), this, bluetoothHidHost);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothHidHost_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothHidHost_2$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "", e);
            }
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$doBind() {
        Intent intent = new Intent(IBluetoothHidHost.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, this.mContext.getUser())) {
            Log.e("BluetoothHidHost", "Could not bind to Bluetooth HID Service with " + intent);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothHidHost$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e("BluetoothHidHost", "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothHidHost", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$connect(BluetoothDevice device) {
        BluetoothHidHost.log("connect(" + device + ")");
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.connect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$disconnect(BluetoothDevice device) {
        BluetoothHidHost.log("disconnect(" + device + ")");
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHidHost$getConnectedDevices() {
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothHidHost$getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothHidHost$getConnectionState(BluetoothDevice device) {
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$setPriority(BluetoothDevice device, int priority) {
        BluetoothHidHost.log("setPriority(" + device + ", " + priority + ")");
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return service.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final int $$robo$$android_bluetooth_BluetoothHidHost$getPriority(BluetoothDevice device) {
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return 0;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothHidHost$isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$virtualUnplug(BluetoothDevice device) {
        BluetoothHidHost.log("virtualUnplug(" + device + ")");
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.virtualUnplug(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$getProtocolMode(BluetoothDevice device) {
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.getProtocolMode(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$setProtocolMode(BluetoothDevice device, int protocolMode) {
        BluetoothHidHost.log("setProtocolMode(" + device + ")");
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.setProtocolMode(device, protocolMode);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$getReport(BluetoothDevice device, byte reportType, byte reportId, int bufferSize) {
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.getReport(device, reportType, reportId, bufferSize);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$setReport(BluetoothDevice device, byte reportType, String report) {
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.setReport(device, reportType, report);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$sendData(BluetoothDevice device, String report) {
        BluetoothHidHost.log("sendData(" + device + "), report=" + report);
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.sendData(device, report);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$getIdleTime(BluetoothDevice device) {
        BluetoothHidHost.log("getIdletime(" + device + ")");
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.getIdleTime(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothHidHost$setIdleTime(BluetoothDevice device, byte idleTime) {
        BluetoothHidHost.log("setIdletime(" + device + "), idleTime=" + idleTime);
        IBluetoothHidHost service = this.mService;
        if (service != null && this.isEnabled() && BluetoothHidHost.isValidDevice(device)) {
            try {
                return service.setIdleTime(device, idleTime);
            }
            catch (RemoteException e) {
                Log.e("BluetoothHidHost", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothHidHost", "Proxy not attached to service");
        }
        return false;
    }

    private static final void $$robo$$android_bluetooth_BluetoothHidHost$log(String msg) {
        Log.d("BluetoothHidHost", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothHidHost$__constructor__(context, serviceListener);
    }

    public BluetoothHidHost(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothHidHost$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothHidHost$doBind(), this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothHidHost$close(), this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothHidHost$connect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothHidHost$disconnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothHidHost$getConnectedDevices(), this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothHidHost$getDevicesMatchingConnectionStates(int[] ), this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothHidHost$getConnectionState(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPriority", $$robo$$android_bluetooth_BluetoothHidHost$setPriority(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
    }

    public int getPriority(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getPriority", $$robo$$android_bluetooth_BluetoothHidHost$getPriority(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothHidHost$isEnabled(), this);
    }

    private static boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDevice", $$robo$$android_bluetooth_BluetoothHidHost$isValidDevice(android.bluetooth.BluetoothDevice ), (BluetoothDevice)bluetoothDevice);
    }

    public boolean virtualUnplug(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("virtualUnplug", $$robo$$android_bluetooth_BluetoothHidHost$virtualUnplug(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean getProtocolMode(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("getProtocolMode", $$robo$$android_bluetooth_BluetoothHidHost$getProtocolMode(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean setProtocolMode(BluetoothDevice bluetoothDevice, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setProtocolMode", $$robo$$android_bluetooth_BluetoothHidHost$setProtocolMode(android.bluetooth.BluetoothDevice int ), this, bluetoothDevice, n);
    }

    public boolean getReport(BluetoothDevice bluetoothDevice, byte by, byte by2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getReport", $$robo$$android_bluetooth_BluetoothHidHost$getReport(android.bluetooth.BluetoothDevice byte byte int ), this, bluetoothDevice, by, by2, n);
    }

    public boolean setReport(BluetoothDevice bluetoothDevice, byte by, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setReport", $$robo$$android_bluetooth_BluetoothHidHost$setReport(android.bluetooth.BluetoothDevice byte java.lang.String ), this, bluetoothDevice, by, string2);
    }

    public boolean sendData(BluetoothDevice bluetoothDevice, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendData", $$robo$$android_bluetooth_BluetoothHidHost$sendData(android.bluetooth.BluetoothDevice java.lang.String ), this, bluetoothDevice, string2);
    }

    public boolean getIdleTime(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("getIdleTime", $$robo$$android_bluetooth_BluetoothHidHost$getIdleTime(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean setIdleTime(BluetoothDevice bluetoothDevice, byte by) {
        return (boolean)InvokeDynamicSupport.bootstrap("setIdleTime", $$robo$$android_bluetooth_BluetoothHidHost$setIdleTime(android.bluetooth.BluetoothDevice byte ), this, bluetoothDevice, by);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothHidHost$log(java.lang.String ), (String)string2);
    }

    public /* synthetic */ BluetoothHidHost() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothHidHost)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

