/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothPan;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothPan
implements BluetoothProfile,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothPan";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.pan.profile.action.CONNECTION_STATE_CHANGED";
    public static String EXTRA_LOCAL_ROLE = "android.bluetooth.pan.extra.LOCAL_ROLE";
    public static int PAN_ROLE_NONE = 0;
    public static int LOCAL_NAP_ROLE = 1;
    public static int REMOTE_NAP_ROLE = 1;
    public static int LOCAL_PANU_ROLE = 2;
    public static int REMOTE_PANU_ROLE = 2;
    public static int PAN_DISCONNECT_FAILED_NOT_CONNECTED = 1000;
    public static int PAN_CONNECT_FAILED_ALREADY_CONNECTED = 1001;
    public static int PAN_CONNECT_FAILED_ATTEMPT_FAILED = 1002;
    public static int PAN_OPERATION_GENERIC_FAILURE = 1003;
    public static int PAN_OPERATION_SUCCESS = 1004;
    private Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    private volatile IBluetoothPan mPanService;
    private IBluetoothStateChangeCallback mStateChangeCallback;
    private ServiceConnection mConnection;

    private void $$robo$$android_bluetooth_BluetoothPan$__constructor__(Context context, BluetoothProfile.ServiceListener l) {
        this.mStateChangeCallback = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothPan this$0;

            private void $$robo$$android_bluetooth_BluetoothPan_1$__constructor__(BluetoothPan this$0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_bluetooth_BluetoothPan_1$onBluetoothStateChange(boolean on) {
                Log.d("BluetoothPan", "onBluetoothStateChange on: " + on);
                if (on) {
                    try {
                        if (this.this$0.mPanService == null) {
                            this.this$0.doBind();
                        }
                    }
                    catch (IllegalStateException e) {
                        Log.e("BluetoothPan", "onBluetoothStateChange: could not bind to PAN service: ", e);
                    }
                    catch (SecurityException e) {
                        Log.e("BluetoothPan", "onBluetoothStateChange: could not bind to PAN service: ", e);
                    }
                } else {
                    ServiceConnection serviceConnection = this.this$0.mConnection;
                    synchronized (serviceConnection) {
                        try {
                            this.this$0.mPanService = null;
                            this.this$0.mContext.unbindService(this.this$0.mConnection);
                        }
                        catch (Exception re) {
                            Log.e("BluetoothPan", "", re);
                        }
                    }
                }
            }

            private void __constructor__(BluetoothPan bluetoothPan) {
                this.$$robo$$android_bluetooth_BluetoothPan_1$__constructor__(bluetoothPan);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPan_1$__constructor__(android.bluetooth.BluetoothPan ), this, bluetoothPan);
            }

            @Override
            public void onBluetoothStateChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onBluetoothStateChange", $$robo$$android_bluetooth_BluetoothPan_1$onBluetoothStateChange(boolean ), this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnection = new ServiceConnection(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BluetoothPan this$0;

            private void $$robo$$android_bluetooth_BluetoothPan_2$__constructor__(BluetoothPan this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_bluetooth_BluetoothPan_2$onServiceConnected(ComponentName className, IBinder service) {
                Log.d("BluetoothPan", "BluetoothPAN Proxy object connected");
                this.this$0.mPanService = IBluetoothPan.Stub.asInterface(Binder.allowBlocking(service));
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceConnected(5, this.this$0);
                }
            }

            private final void $$robo$$android_bluetooth_BluetoothPan_2$onServiceDisconnected(ComponentName className) {
                Log.d("BluetoothPan", "BluetoothPAN Proxy object disconnected");
                this.this$0.mPanService = null;
                if (this.this$0.mServiceListener != null) {
                    this.this$0.mServiceListener.onServiceDisconnected(5);
                }
            }

            private void __constructor__(BluetoothPan bluetoothPan) {
                this.$$robo$$android_bluetooth_BluetoothPan_2$__constructor__(bluetoothPan);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPan_2$__constructor__(android.bluetooth.BluetoothPan ), this, bluetoothPan);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_bluetooth_BluetoothPan_2$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_bluetooth_BluetoothPan_2$onServiceDisconnected(android.content.ComponentName ), this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        try {
            this.mAdapter.getBluetoothManager().registerStateChangeCallback(this.mStateChangeCallback);
        }
        catch (RemoteException re) {
            Log.w("BluetoothPan", "Unable to register BluetoothStateChangeCallback", re);
        }
        this.doBind();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPan$doBind() {
        Intent intent = new Intent(IBluetoothPan.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, this.mContext.getUser())) {
            Log.e("BluetoothPan", "Could not bind to Bluetooth Pan Service with " + intent);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_BluetoothPan$close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mStateChangeCallback);
            }
            catch (RemoteException re) {
                Log.w("BluetoothPan", "Unable to unregister BluetoothStateChangeCallback", re);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mPanService != null) {
                try {
                    this.mPanService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e("BluetoothPan", "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    private final void $$robo$$android_bluetooth_BluetoothPan$finalize() {
        this.close();
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPan$connect(BluetoothDevice device) {
        BluetoothPan.log("connect(" + device + ")");
        IBluetoothPan service = this.mPanService;
        if (service != null && this.isEnabled() && BluetoothPan.isValidDevice(device)) {
            try {
                return service.connect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPan", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothPan", "Proxy not attached to service");
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPan$disconnect(BluetoothDevice device) {
        BluetoothPan.log("disconnect(" + device + ")");
        IBluetoothPan service = this.mPanService;
        if (service != null && this.isEnabled() && BluetoothPan.isValidDevice(device)) {
            try {
                return service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPan", "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w("BluetoothPan", "Proxy not attached to service");
        }
        return false;
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothPan$getConnectedDevices() {
        IBluetoothPan service = this.mPanService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e("BluetoothPan", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothPan", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final List<BluetoothDevice> $$robo$$android_bluetooth_BluetoothPan$getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothPan service = this.mPanService;
        if (service != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPan", "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w("BluetoothPan", "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    private final int $$robo$$android_bluetooth_BluetoothPan$getConnectionState(BluetoothDevice device) {
        IBluetoothPan service = this.mPanService;
        if (service != null && this.isEnabled() && BluetoothPan.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPan", "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w("BluetoothPan", "Proxy not attached to service");
        }
        return 0;
    }

    private final void $$robo$$android_bluetooth_BluetoothPan$setBluetoothTethering(boolean value) {
        BluetoothPan.log("setBluetoothTethering(" + value + ")");
        IBluetoothPan service = this.mPanService;
        if (service != null && this.isEnabled()) {
            try {
                service.setBluetoothTethering(value);
            }
            catch (RemoteException e) {
                Log.e("BluetoothPan", "Stack:" + Log.getStackTraceString(new Throwable()));
            }
        }
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPan$isTetheringOn() {
        IBluetoothPan service = this.mPanService;
        if (service != null && this.isEnabled()) {
            try {
                return service.isTetheringOn();
            }
            catch (RemoteException e) {
                Log.e("BluetoothPan", "Stack:" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    private final boolean $$robo$$android_bluetooth_BluetoothPan$isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    private static final boolean $$robo$$android_bluetooth_BluetoothPan$isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    private static final void $$robo$$android_bluetooth_BluetoothPan$log(String msg) {
        Log.d("BluetoothPan", msg);
    }

    private void __constructor__(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$$android_bluetooth_BluetoothPan$__constructor__(context, serviceListener);
    }

    public BluetoothPan(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_BluetoothPan$__constructor__(android.content.Context android.bluetooth.BluetoothProfile$ServiceListener ), this, context, serviceListener);
    }

    boolean doBind() {
        return (boolean)InvokeDynamicSupport.bootstrap("doBind", $$robo$$android_bluetooth_BluetoothPan$doBind(), this);
    }

    void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_bluetooth_BluetoothPan$close(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_bluetooth_BluetoothPan$finalize(), this);
    }

    public boolean connect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$android_bluetooth_BluetoothPan$connect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_bluetooth_BluetoothPan$disconnect(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        return InvokeDynamicSupport.bootstrap("getConnectedDevices", $$robo$$android_bluetooth_BluetoothPan$getConnectedDevices(), this);
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("getDevicesMatchingConnectionStates", $$robo$$android_bluetooth_BluetoothPan$getDevicesMatchingConnectionStates(int[] ), this, nArray);
    }

    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionState", $$robo$$android_bluetooth_BluetoothPan$getConnectionState(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    public void setBluetoothTethering(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBluetoothTethering", $$robo$$android_bluetooth_BluetoothPan$setBluetoothTethering(boolean ), this, bl);
    }

    public boolean isTetheringOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTetheringOn", $$robo$$android_bluetooth_BluetoothPan$isTetheringOn(), this);
    }

    private boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_bluetooth_BluetoothPan$isEnabled(), this);
    }

    private static boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDevice", $$robo$$android_bluetooth_BluetoothPan$isValidDevice(android.bluetooth.BluetoothDevice ), (BluetoothDevice)bluetoothDevice);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_bluetooth_BluetoothPan$log(java.lang.String ), (String)string2);
    }

    public /* synthetic */ BluetoothPan() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothPan)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

