/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.le.BluetoothLeUtils;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.SparseArray;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AdvertiseData
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private List<ParcelUuid> mServiceUuids;
    private SparseArray<byte[]> mManufacturerSpecificData;
    private Map<ParcelUuid, byte[]> mServiceData;
    private boolean mIncludeTxPowerLevel;
    private boolean mIncludeDeviceName;
    public static Parcelable.Creator<AdvertiseData> CREATOR;

    private void $$robo$$android_bluetooth_le_AdvertiseData$__constructor__(List<ParcelUuid> serviceUuids, SparseArray<byte[]> manufacturerData, Map<ParcelUuid, byte[]> serviceData, boolean includeTxPowerLevel, boolean includeDeviceName) {
        this.mServiceUuids = serviceUuids;
        this.mManufacturerSpecificData = manufacturerData;
        this.mServiceData = serviceData;
        this.mIncludeTxPowerLevel = includeTxPowerLevel;
        this.mIncludeDeviceName = includeDeviceName;
    }

    private final List<ParcelUuid> $$robo$$android_bluetooth_le_AdvertiseData$getServiceUuids() {
        return this.mServiceUuids;
    }

    private final SparseArray<byte[]> $$robo$$android_bluetooth_le_AdvertiseData$getManufacturerSpecificData() {
        return this.mManufacturerSpecificData;
    }

    private final Map<ParcelUuid, byte[]> $$robo$$android_bluetooth_le_AdvertiseData$getServiceData() {
        return this.mServiceData;
    }

    private final boolean $$robo$$android_bluetooth_le_AdvertiseData$getIncludeTxPowerLevel() {
        return this.mIncludeTxPowerLevel;
    }

    private final boolean $$robo$$android_bluetooth_le_AdvertiseData$getIncludeDeviceName() {
        return this.mIncludeDeviceName;
    }

    private final int $$robo$$android_bluetooth_le_AdvertiseData$hashCode() {
        return Objects.hash(this.mServiceUuids, this.mManufacturerSpecificData, this.mServiceData, this.mIncludeDeviceName, this.mIncludeTxPowerLevel);
    }

    private final boolean $$robo$$android_bluetooth_le_AdvertiseData$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AdvertiseData other = (AdvertiseData)obj;
        return Objects.equals(this.mServiceUuids, other.mServiceUuids) && BluetoothLeUtils.equals(this.mManufacturerSpecificData, other.mManufacturerSpecificData) && BluetoothLeUtils.equals(this.mServiceData, other.mServiceData) && this.mIncludeDeviceName == other.mIncludeDeviceName && this.mIncludeTxPowerLevel == other.mIncludeTxPowerLevel;
    }

    private final String $$robo$$android_bluetooth_le_AdvertiseData$toString() {
        return "AdvertiseData [mServiceUuids=" + this.mServiceUuids + ", mManufacturerSpecificData=" + BluetoothLeUtils.toString(this.mManufacturerSpecificData) + ", mServiceData=" + BluetoothLeUtils.toString(this.mServiceData) + ", mIncludeTxPowerLevel=" + this.mIncludeTxPowerLevel + ", mIncludeDeviceName=" + this.mIncludeDeviceName + "]";
    }

    private final int $$robo$$android_bluetooth_le_AdvertiseData$describeContents() {
        return 0;
    }

    private final void $$robo$$android_bluetooth_le_AdvertiseData$writeToParcel(Parcel dest, int flags) {
        dest.writeTypedArray(this.mServiceUuids.toArray(new ParcelUuid[this.mServiceUuids.size()]), flags);
        dest.writeInt(this.mManufacturerSpecificData.size());
        for (int i = 0; i < this.mManufacturerSpecificData.size(); ++i) {
            dest.writeInt(this.mManufacturerSpecificData.keyAt(i));
            dest.writeByteArray(this.mManufacturerSpecificData.valueAt(i));
        }
        dest.writeInt(this.mServiceData.size());
        for (ParcelUuid uuid : this.mServiceData.keySet()) {
            dest.writeTypedObject(uuid, flags);
            dest.writeByteArray(this.mServiceData.get(uuid));
        }
        dest.writeByte((byte)(this.getIncludeTxPowerLevel() ? 1 : 0));
        dest.writeByte((byte)(this.getIncludeDeviceName() ? 1 : 0));
    }

    private /* synthetic */ void $$robo$$android_bluetooth_le_AdvertiseData$__constructor__(List x0, SparseArray x1, Map x2, boolean x3, boolean x4, 1 x5) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AdvertiseData>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_bluetooth_le_AdvertiseData_1$__constructor__() {
            }

            private final AdvertiseData[] $$robo$$android_bluetooth_le_AdvertiseData_1$newArray(int size) {
                return new AdvertiseData[size];
            }

            private final AdvertiseData $$robo$$android_bluetooth_le_AdvertiseData_1$createFromParcel(Parcel in) {
                Builder builder = new Builder();
                ArrayList<ParcelUuid> uuids = in.createTypedArrayList(ParcelUuid.CREATOR);
                for (ParcelUuid uuid : uuids) {
                    builder.addServiceUuid(uuid);
                }
                int manufacturerSize = in.readInt();
                for (int i = 0; i < manufacturerSize; ++i) {
                    int manufacturerId = in.readInt();
                    byte[] manufacturerData = in.createByteArray();
                    builder.addManufacturerData(manufacturerId, manufacturerData);
                }
                int serviceDataSize = in.readInt();
                for (int i = 0; i < serviceDataSize; ++i) {
                    ParcelUuid serviceDataUuid = in.readTypedObject(ParcelUuid.CREATOR);
                    byte[] serviceData = in.createByteArray();
                    builder.addServiceData(serviceDataUuid, serviceData);
                }
                builder.setIncludeTxPowerLevel(in.readByte() == 1);
                builder.setIncludeDeviceName(in.readByte() == 1);
                return builder.build();
            }

            private void __constructor__() {
                this.$$robo$$android_bluetooth_le_AdvertiseData_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_AdvertiseData_1$__constructor__(), this);
            }

            public AdvertiseData[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_bluetooth_le_AdvertiseData_1$newArray(int ), this, n);
            }

            @Override
            public AdvertiseData createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_bluetooth_le_AdvertiseData_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(List<ParcelUuid> list, SparseArray<byte[]> sparseArray, Map<ParcelUuid, byte[]> map, boolean bl, boolean bl2) {
        this.$$robo$$android_bluetooth_le_AdvertiseData$__constructor__(list, sparseArray, map, bl, bl2);
    }

    public AdvertiseData(List<ParcelUuid> list, SparseArray<byte[]> sparseArray, Map<ParcelUuid, byte[]> map, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_AdvertiseData$__constructor__(java.util.List<android.os.ParcelUuid> android.util.SparseArray<byte[]> java.util.Map<android.os.ParcelUuid, byte[]> boolean boolean ), this, list, sparseArray, map, bl, bl2);
    }

    public List<ParcelUuid> getServiceUuids() {
        return InvokeDynamicSupport.bootstrap("getServiceUuids", $$robo$$android_bluetooth_le_AdvertiseData$getServiceUuids(), this);
    }

    public SparseArray<byte[]> getManufacturerSpecificData() {
        return InvokeDynamicSupport.bootstrap("getManufacturerSpecificData", $$robo$$android_bluetooth_le_AdvertiseData$getManufacturerSpecificData(), this);
    }

    public Map<ParcelUuid, byte[]> getServiceData() {
        return InvokeDynamicSupport.bootstrap("getServiceData", $$robo$$android_bluetooth_le_AdvertiseData$getServiceData(), this);
    }

    public boolean getIncludeTxPowerLevel() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIncludeTxPowerLevel", $$robo$$android_bluetooth_le_AdvertiseData$getIncludeTxPowerLevel(), this);
    }

    public boolean getIncludeDeviceName() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIncludeDeviceName", $$robo$$android_bluetooth_le_AdvertiseData$getIncludeDeviceName(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_bluetooth_le_AdvertiseData$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_bluetooth_le_AdvertiseData$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_bluetooth_le_AdvertiseData$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_bluetooth_le_AdvertiseData$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_bluetooth_le_AdvertiseData$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private /* synthetic */ void __constructor__(List list, SparseArray sparseArray, Map map, boolean bl, boolean bl2, 1 var6_6) {
        this.$$robo$$android_bluetooth_le_AdvertiseData$__constructor__(list, sparseArray, map, bl, bl2, var6_6);
    }

    public /* synthetic */ AdvertiseData(List list, SparseArray sparseArray, Map map, boolean bl, boolean bl2, 1 var6_6) {
        this(list, sparseArray, map, bl, bl2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_AdvertiseData$__constructor__(java.util.List android.util.SparseArray java.util.Map boolean boolean android.bluetooth.le.AdvertiseData$1 ), this, list, sparseArray, map, bl, bl2, var6_6);
    }

    static {
        RobolectricInternals.classInitializing(AdvertiseData.class);
    }

    public /* synthetic */ AdvertiseData() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdvertiseData)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private List<ParcelUuid> mServiceUuids;
        private SparseArray<byte[]> mManufacturerSpecificData;
        private Map<ParcelUuid, byte[]> mServiceData;
        private boolean mIncludeTxPowerLevel;
        private boolean mIncludeDeviceName;

        private void $$robo$$android_bluetooth_le_AdvertiseData_Builder$__constructor__() {
            this.mServiceUuids = new ArrayList<ParcelUuid>();
            this.mManufacturerSpecificData = new SparseArray();
            this.mServiceData = new ArrayMap<ParcelUuid, byte[]>();
        }

        private final Builder $$robo$$android_bluetooth_le_AdvertiseData_Builder$addServiceUuid(ParcelUuid serviceUuid) {
            if (serviceUuid == null) {
                throw new IllegalArgumentException("serivceUuids are null");
            }
            this.mServiceUuids.add(serviceUuid);
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_AdvertiseData_Builder$addServiceData(ParcelUuid serviceDataUuid, byte[] serviceData) {
            if (serviceDataUuid == null || serviceData == null) {
                throw new IllegalArgumentException("serviceDataUuid or serviceDataUuid is null");
            }
            this.mServiceData.put(serviceDataUuid, serviceData);
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_AdvertiseData_Builder$addManufacturerData(int manufacturerId, byte[] manufacturerSpecificData) {
            if (manufacturerId < 0) {
                throw new IllegalArgumentException("invalid manufacturerId - " + manufacturerId);
            }
            if (manufacturerSpecificData == null) {
                throw new IllegalArgumentException("manufacturerSpecificData is null");
            }
            this.mManufacturerSpecificData.put(manufacturerId, manufacturerSpecificData);
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_AdvertiseData_Builder$setIncludeTxPowerLevel(boolean includeTxPowerLevel) {
            this.mIncludeTxPowerLevel = includeTxPowerLevel;
            return this;
        }

        private final Builder $$robo$$android_bluetooth_le_AdvertiseData_Builder$setIncludeDeviceName(boolean includeDeviceName) {
            this.mIncludeDeviceName = includeDeviceName;
            return this;
        }

        private final AdvertiseData $$robo$$android_bluetooth_le_AdvertiseData_Builder$build() {
            return new AdvertiseData(this.mServiceUuids, this.mManufacturerSpecificData, this.mServiceData, this.mIncludeTxPowerLevel, this.mIncludeDeviceName, null);
        }

        private void __constructor__() {
            this.$$robo$$android_bluetooth_le_AdvertiseData_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_AdvertiseData_Builder$__constructor__(), this);
        }

        public Builder addServiceUuid(ParcelUuid parcelUuid) {
            return InvokeDynamicSupport.bootstrap("addServiceUuid", $$robo$$android_bluetooth_le_AdvertiseData_Builder$addServiceUuid(android.os.ParcelUuid ), this, parcelUuid);
        }

        public Builder addServiceData(ParcelUuid parcelUuid, byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("addServiceData", $$robo$$android_bluetooth_le_AdvertiseData_Builder$addServiceData(android.os.ParcelUuid byte[] ), this, parcelUuid, byArray);
        }

        public Builder addManufacturerData(int n, byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("addManufacturerData", $$robo$$android_bluetooth_le_AdvertiseData_Builder$addManufacturerData(int byte[] ), this, n, byArray);
        }

        public Builder setIncludeTxPowerLevel(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setIncludeTxPowerLevel", $$robo$$android_bluetooth_le_AdvertiseData_Builder$setIncludeTxPowerLevel(boolean ), this, bl);
        }

        public Builder setIncludeDeviceName(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setIncludeDeviceName", $$robo$$android_bluetooth_le_AdvertiseData_Builder$setIncludeDeviceName(boolean ), this, bl);
        }

        public AdvertiseData build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_bluetooth_le_AdvertiseData_Builder$build(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

