/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.AdvertisingSet;
import android.bluetooth.le.AdvertisingSetCallback;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.BluetoothLeUtils;
import android.bluetooth.le.IAdvertisingSetCallback;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BluetoothLeAdvertiser
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "BluetoothLeAdvertiser";
    private static int MAX_ADVERTISING_DATA_BYTES = 1650;
    private static int MAX_LEGACY_ADVERTISING_DATA_BYTES = 31;
    private static int OVERHEAD_BYTES_PER_FIELD = 2;
    private static int FLAGS_FIELD_BYTES = 3;
    private static int MANUFACTURER_SPECIFIC_DATA_LENGTH = 2;
    private IBluetoothManager mBluetoothManager;
    private Handler mHandler;
    private BluetoothAdapter mBluetoothAdapter;
    private Map<AdvertiseCallback, AdvertisingSetCallback> mLegacyAdvertisers;
    private Map<AdvertisingSetCallback, IAdvertisingSetCallback> mCallbackWrappers;
    private Map<Integer, AdvertisingSet> mAdvertisingSets;

    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$__constructor__(IBluetoothManager bluetoothManager) {
        this.mLegacyAdvertisers = new HashMap<AdvertiseCallback, AdvertisingSetCallback>();
        this.mCallbackWrappers = Collections.synchronizedMap(new HashMap());
        this.mAdvertisingSets = Collections.synchronizedMap(new HashMap());
        this.mBluetoothManager = bluetoothManager;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseCallback callback) {
        this.startAdvertising(settings, advertiseData, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertising(AdvertiseSettings settings, AdvertiseData advertiseData, AdvertiseData scanResponse, AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertisingSetCallback> map = this.mLegacyAdvertisers;
        synchronized (map) {
            BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            boolean isConnectable = settings.isConnectable();
            if (this.totalBytes(advertiseData, isConnectable) > 31 || this.totalBytes(scanResponse, false) > 31) {
                this.postStartFailure(callback, 1);
                return;
            }
            if (this.mLegacyAdvertisers.containsKey(callback)) {
                this.postStartFailure(callback, 3);
                return;
            }
            AdvertisingSetParameters.Builder parameters = new AdvertisingSetParameters.Builder();
            parameters.setLegacyMode(true);
            parameters.setConnectable(isConnectable);
            parameters.setScannable(true);
            if (settings.getMode() == 0) {
                parameters.setInterval(1600);
            } else if (settings.getMode() == 1) {
                parameters.setInterval(400);
            } else if (settings.getMode() == 2) {
                parameters.setInterval(160);
            }
            if (settings.getTxPowerLevel() == 0) {
                parameters.setTxPowerLevel(-21);
            } else if (settings.getTxPowerLevel() == 1) {
                parameters.setTxPowerLevel(-15);
            } else if (settings.getTxPowerLevel() == 2) {
                parameters.setTxPowerLevel(-7);
            } else if (settings.getTxPowerLevel() == 3) {
                parameters.setTxPowerLevel(1);
            }
            int duration = 0;
            int timeoutMillis = settings.getTimeout();
            if (timeoutMillis > 0) {
                duration = timeoutMillis < 10 ? 1 : timeoutMillis / 10;
            }
            AdvertisingSetCallback wrapped = this.wrapOldCallback(callback, settings);
            this.mLegacyAdvertisers.put(callback, wrapped);
            this.startAdvertisingSet(parameters.build(), advertiseData, scanResponse, null, null, duration, 0, wrapped);
        }
    }

    private final AdvertisingSetCallback $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$wrapOldCallback(AdvertiseCallback callback, AdvertiseSettings settings) {
        return new ShadowedObject(this, callback, settings){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AdvertiseCallback val$callback;
            /* synthetic */ AdvertiseSettings val$settings;
            /* synthetic */ BluetoothLeAdvertiser this$0;

            private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$__constructor__(BluetoothLeAdvertiser this$0, AdvertiseCallback advertiseCallback, AdvertiseSettings advertiseSettings) {
                this.this$0 = this$0;
                this.val$callback = advertiseCallback;
                this.val$settings = advertiseSettings;
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$onAdvertisingSetStarted(AdvertisingSet advertisingSet, int txPower, int status) {
                if (status != 0) {
                    this.this$0.postStartFailure(this.val$callback, status);
                    return;
                }
                this.this$0.postStartSuccess(this.val$callback, this.val$settings);
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$onAdvertisingEnabled(AdvertisingSet advertisingSet, boolean enabled, int status) {
                if (enabled) {
                    Log.e("BluetoothLeAdvertiser", "Legacy advertiser should be only disabled on timeout, but was enabled!");
                    return;
                }
                this.this$0.stopAdvertising(this.val$callback);
            }

            private void __constructor__(BluetoothLeAdvertiser bluetoothLeAdvertiser, AdvertiseCallback advertiseCallback, AdvertiseSettings advertiseSettings) {
                this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$__constructor__(bluetoothLeAdvertiser, advertiseCallback, advertiseSettings);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser android.bluetooth.le.AdvertiseCallback android.bluetooth.le.AdvertiseSettings ), this, bluetoothLeAdvertiser, advertiseCallback, advertiseSettings);
            }

            @Override
            public void onAdvertisingSetStarted(AdvertisingSet advertisingSet, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onAdvertisingSetStarted", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$onAdvertisingSetStarted(android.bluetooth.le.AdvertisingSet int int ), this, advertisingSet, n, n2);
            }

            @Override
            public void onAdvertisingEnabled(AdvertisingSet advertisingSet, boolean bl, int n) {
                InvokeDynamicSupport.bootstrap("onAdvertisingEnabled", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_1$onAdvertisingEnabled(android.bluetooth.le.AdvertisingSet boolean int ), this, advertisingSet, bl, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$stopAdvertising(AdvertiseCallback callback) {
        Map<AdvertiseCallback, AdvertisingSetCallback> map = this.mLegacyAdvertisers;
        synchronized (map) {
            if (callback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            AdvertisingSetCallback wrapper = this.mLegacyAdvertisers.get(callback);
            if (wrapper == null) {
                return;
            }
            this.stopAdvertisingSet(wrapper);
            this.mLegacyAdvertisers.remove(callback);
        }
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, AdvertisingSetCallback callback) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, 0, 0, callback, new Handler(Looper.getMainLooper()));
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, AdvertisingSetCallback callback, Handler handler) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, 0, 0, callback, handler);
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtendedAdvertisingEvents, AdvertisingSetCallback callback) {
        this.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, duration, maxExtendedAdvertisingEvents, callback, new Handler(Looper.getMainLooper()));
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtendedAdvertisingEvents, AdvertisingSetCallback callback, Handler handler) {
        IBluetoothGatt gatt;
        BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        boolean isConnectable = parameters.isConnectable();
        if (parameters.isLegacy()) {
            if (this.totalBytes(advertiseData, isConnectable) > 31) {
                throw new IllegalArgumentException("Legacy advertising data too big");
            }
            if (this.totalBytes(scanResponse, false) > 31) {
                throw new IllegalArgumentException("Legacy scan response data too big");
            }
        } else {
            boolean supportCodedPhy = this.mBluetoothAdapter.isLeCodedPhySupported();
            boolean support2MPhy = this.mBluetoothAdapter.isLe2MPhySupported();
            int pphy = parameters.getPrimaryPhy();
            int sphy = parameters.getSecondaryPhy();
            if (pphy == 3 && !supportCodedPhy) {
                throw new IllegalArgumentException("Unsupported primary PHY selected");
            }
            if (sphy == 3 && !supportCodedPhy || sphy == 2 && !support2MPhy) {
                throw new IllegalArgumentException("Unsupported secondary PHY selected");
            }
            int maxData = this.mBluetoothAdapter.getLeMaximumAdvertisingDataLength();
            if (this.totalBytes(advertiseData, isConnectable) > maxData) {
                throw new IllegalArgumentException("Advertising data too big");
            }
            if (this.totalBytes(scanResponse, false) > maxData) {
                throw new IllegalArgumentException("Scan response data too big");
            }
            if (this.totalBytes(periodicData, false) > maxData) {
                throw new IllegalArgumentException("Periodic advertising data too big");
            }
            boolean supportPeriodic = this.mBluetoothAdapter.isLePeriodicAdvertisingSupported();
            if (periodicParameters != null && !supportPeriodic) {
                throw new IllegalArgumentException("Controller does not support LE Periodic Advertising");
            }
        }
        if (maxExtendedAdvertisingEvents < 0 || maxExtendedAdvertisingEvents > 255) {
            throw new IllegalArgumentException("maxExtendedAdvertisingEvents out of range: " + maxExtendedAdvertisingEvents);
        }
        if (maxExtendedAdvertisingEvents != 0 && !this.mBluetoothAdapter.isLePeriodicAdvertisingSupported()) {
            throw new IllegalArgumentException("Can't use maxExtendedAdvertisingEvents with controller that don't support LE Extended Advertising");
        }
        if (duration < 0 || duration > 65535) {
            throw new IllegalArgumentException("duration out of range: " + duration);
        }
        try {
            gatt = this.mBluetoothManager.getBluetoothGatt();
        }
        catch (RemoteException e) {
            Log.e("BluetoothLeAdvertiser", "Failed to get Bluetooth gatt - ", e);
            this.postStartSetFailure(handler, callback, 4);
            return;
        }
        IAdvertisingSetCallback wrapped = this.wrap(callback, handler);
        if (this.mCallbackWrappers.putIfAbsent(callback, wrapped) != null) {
            throw new IllegalArgumentException("callback instance already associated with advertising");
        }
        try {
            gatt.startAdvertisingSet(parameters, advertiseData, scanResponse, periodicParameters, periodicData, duration, maxExtendedAdvertisingEvents, wrapped);
        }
        catch (RemoteException e) {
            Log.e("BluetoothLeAdvertiser", "Failed to start advertising set - ", e);
            this.postStartSetFailure(handler, callback, 4);
            return;
        }
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$stopAdvertisingSet(AdvertisingSetCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        IAdvertisingSetCallback wrapped = this.mCallbackWrappers.remove(callback);
        if (wrapped == null) {
            return;
        }
        try {
            IBluetoothGatt gatt = this.mBluetoothManager.getBluetoothGatt();
            gatt.stopAdvertisingSet(wrapped);
        }
        catch (RemoteException e) {
            Log.e("BluetoothLeAdvertiser", "Failed to stop advertising - ", e);
        }
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$cleanup() {
        this.mLegacyAdvertisers.clear();
        this.mCallbackWrappers.clear();
        this.mAdvertisingSets.clear();
    }

    private final int $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$totalBytes(AdvertiseData data, boolean isFlagsIncluded) {
        int size;
        if (data == null) {
            return 0;
        }
        int n = size = isFlagsIncluded ? 3 : 0;
        if (data.getServiceUuids() != null) {
            int num16BitUuids = 0;
            int num32BitUuids = 0;
            int num128BitUuids = 0;
            for (ParcelUuid uuid : data.getServiceUuids()) {
                if (BluetoothUuid.is16BitUuid(uuid)) {
                    ++num16BitUuids;
                    continue;
                }
                if (BluetoothUuid.is32BitUuid(uuid)) {
                    ++num32BitUuids;
                    continue;
                }
                ++num128BitUuids;
            }
            if (num16BitUuids != 0) {
                size += 2 + num16BitUuids * 2;
            }
            if (num32BitUuids != 0) {
                size += 2 + num32BitUuids * 4;
            }
            if (num128BitUuids != 0) {
                size += 2 + num128BitUuids * 16;
            }
        }
        for (ParcelUuid uuid : data.getServiceData().keySet()) {
            int uuidLen = BluetoothUuid.uuidToBytes(uuid).length;
            size += 2 + uuidLen + this.byteLength(data.getServiceData().get(uuid));
        }
        for (int i = 0; i < data.getManufacturerSpecificData().size(); ++i) {
            size += 4 + this.byteLength(data.getManufacturerSpecificData().valueAt(i));
        }
        if (data.getIncludeTxPowerLevel()) {
            size += 3;
        }
        if (data.getIncludeDeviceName() && this.mBluetoothAdapter.getName() != null) {
            size += 2 + this.mBluetoothAdapter.getName().length();
        }
        return size;
    }

    private final int $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$byteLength(byte[] array2) {
        return array2 == null ? 0 : array2.length;
    }

    private final IAdvertisingSetCallback $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$wrap(AdvertisingSetCallback callback, Handler handler) {
        return new ShadowedObject(this, handler, callback){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Handler val$handler;
            /* synthetic */ AdvertisingSetCallback val$callback;
            /* synthetic */ BluetoothLeAdvertiser this$0;

            private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$__constructor__(BluetoothLeAdvertiser this$0, Handler handler, AdvertisingSetCallback advertisingSetCallback) {
                this.this$0 = this$0;
                this.val$handler = handler;
                this.val$callback = advertisingSetCallback;
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingSetStarted(int advertiserId, int txPower, int status) {
                this.val$handler.post(new Runnable(this, status, advertiserId, txPower){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$status;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ int val$txPower;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_1$__constructor__(2 this$1, int n, int n2, int n3) {
                        this.this$1 = this$1;
                        this.val$status = n;
                        this.val$advertiserId = n2;
                        this.val$txPower = n3;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_1$run() {
                        if (this.val$status != 0) {
                            this.this$1.val$callback.onAdvertisingSetStarted(null, 0, this.val$status);
                            this.this$1.this$0.mCallbackWrappers.remove(this.this$1.val$callback);
                            return;
                        }
                        AdvertisingSet advertisingSet = new AdvertisingSet(this.val$advertiserId, this.this$1.this$0.mBluetoothManager);
                        this.this$1.this$0.mAdvertisingSets.put(this.val$advertiserId, advertisingSet);
                        this.this$1.val$callback.onAdvertisingSetStarted(advertisingSet, this.val$txPower, this.val$status);
                    }

                    private void __constructor__(2 var1_1, int n, int n2, int n3) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_1$__constructor__(var1_1, n, n2, n3);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_1$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int int int ), this, var1_1, n, n2, n3);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_1$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onOwnAddressRead(int advertiserId, int addressType, String address) {
                this.val$handler.post(new Runnable(this, advertiserId, addressType, address){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ int val$addressType;
                    /* synthetic */ String val$address;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_2$__constructor__(2 this$1, int n, int n2, String string2) {
                        this.this$1 = this$1;
                        this.val$advertiserId = n;
                        this.val$addressType = n2;
                        this.val$address = string2;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_2$run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)this.this$1.this$0.mAdvertisingSets.get(this.val$advertiserId);
                        this.this$1.val$callback.onOwnAddressRead(advertisingSet, this.val$addressType, this.val$address);
                    }

                    private void __constructor__(2 var1_1, int n, int n2, String string2) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_2$__constructor__(var1_1, n, n2, string2);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_2$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int int java.lang.String ), this, var1_1, n, n2, string2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_2$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingSetStopped(int advertiserId) {
                this.val$handler.post(new Runnable(this, advertiserId){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_3$__constructor__(2 this$1, int n) {
                        this.this$1 = this$1;
                        this.val$advertiserId = n;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_3$run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)this.this$1.this$0.mAdvertisingSets.get(this.val$advertiserId);
                        this.this$1.val$callback.onAdvertisingSetStopped(advertisingSet);
                        this.this$1.this$0.mAdvertisingSets.remove(this.val$advertiserId);
                        this.this$1.this$0.mCallbackWrappers.remove(this.this$1.val$callback);
                    }

                    private void __constructor__(2 var1_1, int n) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_3$__constructor__(var1_1, n);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_3$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int ), this, var1_1, n);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_3$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingEnabled(int advertiserId, boolean enabled, int status) {
                this.val$handler.post(new Runnable(this, advertiserId, enabled, status){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ boolean val$enabled;
                    /* synthetic */ int val$status;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_4$__constructor__(2 this$1, int n, boolean bl, int n2) {
                        this.this$1 = this$1;
                        this.val$advertiserId = n;
                        this.val$enabled = bl;
                        this.val$status = n2;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_4$run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)this.this$1.this$0.mAdvertisingSets.get(this.val$advertiserId);
                        this.this$1.val$callback.onAdvertisingEnabled(advertisingSet, this.val$enabled, this.val$status);
                    }

                    private void __constructor__(2 var1_1, int n, boolean bl, int n2) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_4$__constructor__(var1_1, n, bl, n2);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_4$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int boolean int ), this, var1_1, n, bl, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_4$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingDataSet(int advertiserId, int status) {
                this.val$handler.post(new Runnable(this, advertiserId, status){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ int val$status;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_5$__constructor__(2 this$1, int n, int n2) {
                        this.this$1 = this$1;
                        this.val$advertiserId = n;
                        this.val$status = n2;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_5$run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)this.this$1.this$0.mAdvertisingSets.get(this.val$advertiserId);
                        this.this$1.val$callback.onAdvertisingDataSet(advertisingSet, this.val$status);
                    }

                    private void __constructor__(2 var1_1, int n, int n2) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_5$__constructor__(var1_1, n, n2);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_5$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int int ), this, var1_1, n, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_5$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onScanResponseDataSet(int advertiserId, int status) {
                this.val$handler.post(new Runnable(this, advertiserId, status){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ int val$status;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_6$__constructor__(2 this$1, int n, int n2) {
                        this.this$1 = this$1;
                        this.val$advertiserId = n;
                        this.val$status = n2;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_6$run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)this.this$1.this$0.mAdvertisingSets.get(this.val$advertiserId);
                        this.this$1.val$callback.onScanResponseDataSet(advertisingSet, this.val$status);
                    }

                    private void __constructor__(2 var1_1, int n, int n2) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_6$__constructor__(var1_1, n, n2);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_6$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int int ), this, var1_1, n, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_6$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingParametersUpdated(int advertiserId, int txPower, int status) {
                this.val$handler.post(new Runnable(this, advertiserId, txPower, status){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ int val$txPower;
                    /* synthetic */ int val$status;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_7$__constructor__(2 this$1, int n, int n2, int n3) {
                        this.this$1 = this$1;
                        this.val$advertiserId = n;
                        this.val$txPower = n2;
                        this.val$status = n3;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_7$run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)this.this$1.this$0.mAdvertisingSets.get(this.val$advertiserId);
                        this.this$1.val$callback.onAdvertisingParametersUpdated(advertisingSet, this.val$txPower, this.val$status);
                    }

                    private void __constructor__(2 var1_1, int n, int n2, int n3) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_7$__constructor__(var1_1, n, n2, n3);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_7$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int int int ), this, var1_1, n, n2, n3);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_7$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onPeriodicAdvertisingParametersUpdated(int advertiserId, int status) {
                this.val$handler.post(new Runnable(this, advertiserId, status){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ int val$status;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_8$__constructor__(2 this$1, int n, int n2) {
                        this.this$1 = this$1;
                        this.val$advertiserId = n;
                        this.val$status = n2;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_8$run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)this.this$1.this$0.mAdvertisingSets.get(this.val$advertiserId);
                        this.this$1.val$callback.onPeriodicAdvertisingParametersUpdated(advertisingSet, this.val$status);
                    }

                    private void __constructor__(2 var1_1, int n, int n2) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_8$__constructor__(var1_1, n, n2);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_8$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int int ), this, var1_1, n, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_8$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onPeriodicAdvertisingDataSet(int advertiserId, int status) {
                this.val$handler.post(new Runnable(this, advertiserId, status){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ int val$status;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_9$__constructor__(2 this$1, int n, int n2) {
                        this.this$1 = this$1;
                        this.val$advertiserId = n;
                        this.val$status = n2;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_9$run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)this.this$1.this$0.mAdvertisingSets.get(this.val$advertiserId);
                        this.this$1.val$callback.onPeriodicAdvertisingDataSet(advertisingSet, this.val$status);
                    }

                    private void __constructor__(2 var1_1, int n, int n2) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_9$__constructor__(var1_1, n, n2);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_9$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int int ), this, var1_1, n, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_9$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onPeriodicAdvertisingEnabled(int advertiserId, boolean enable, int status) {
                this.val$handler.post(new Runnable(this, advertiserId, enable, status){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$advertiserId;
                    /* synthetic */ boolean val$enable;
                    /* synthetic */ int val$status;
                    /* synthetic */ 2 this$1;

                    private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_10$__constructor__(2 this$1, int n, boolean bl, int n2) {
                        this.this$1 = this$1;
                        this.val$advertiserId = n;
                        this.val$enable = bl;
                        this.val$status = n2;
                    }

                    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_10$run() {
                        AdvertisingSet advertisingSet = (AdvertisingSet)this.this$1.this$0.mAdvertisingSets.get(this.val$advertiserId);
                        this.this$1.val$callback.onPeriodicAdvertisingEnabled(advertisingSet, this.val$enable, this.val$status);
                    }

                    private void __constructor__(2 var1_1, int n, boolean bl, int n2) {
                        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_10$__constructor__(var1_1, n, bl, n2);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_10$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser$2 int boolean int ), this, var1_1, n, bl, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2_10$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private void __constructor__(BluetoothLeAdvertiser bluetoothLeAdvertiser, Handler handler, AdvertisingSetCallback advertisingSetCallback) {
                this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$__constructor__(bluetoothLeAdvertiser, handler, advertisingSetCallback);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser android.os.Handler android.bluetooth.le.AdvertisingSetCallback ), this, bluetoothLeAdvertiser, handler, advertisingSetCallback);
            }

            @Override
            public void onAdvertisingSetStarted(int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onAdvertisingSetStarted", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingSetStarted(int int int ), this, n, n2, n3);
            }

            @Override
            public void onOwnAddressRead(int n, int n2, String string2) {
                InvokeDynamicSupport.bootstrap("onOwnAddressRead", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onOwnAddressRead(int int java.lang.String ), this, n, n2, string2);
            }

            @Override
            public void onAdvertisingSetStopped(int n) {
                InvokeDynamicSupport.bootstrap("onAdvertisingSetStopped", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingSetStopped(int ), this, n);
            }

            @Override
            public void onAdvertisingEnabled(int n, boolean bl, int n2) {
                InvokeDynamicSupport.bootstrap("onAdvertisingEnabled", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingEnabled(int boolean int ), this, n, bl, n2);
            }

            @Override
            public void onAdvertisingDataSet(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onAdvertisingDataSet", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingDataSet(int int ), this, n, n2);
            }

            @Override
            public void onScanResponseDataSet(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onScanResponseDataSet", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onScanResponseDataSet(int int ), this, n, n2);
            }

            @Override
            public void onAdvertisingParametersUpdated(int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onAdvertisingParametersUpdated", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onAdvertisingParametersUpdated(int int int ), this, n, n2, n3);
            }

            @Override
            public void onPeriodicAdvertisingParametersUpdated(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onPeriodicAdvertisingParametersUpdated", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onPeriodicAdvertisingParametersUpdated(int int ), this, n, n2);
            }

            @Override
            public void onPeriodicAdvertisingDataSet(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onPeriodicAdvertisingDataSet", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onPeriodicAdvertisingDataSet(int int ), this, n, n2);
            }

            @Override
            public void onPeriodicAdvertisingEnabled(int n, boolean bl, int n2) {
                InvokeDynamicSupport.bootstrap("onPeriodicAdvertisingEnabled", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_2$onPeriodicAdvertisingEnabled(int boolean int ), this, n, bl, n2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartSetFailure(Handler handler, AdvertisingSetCallback callback, int error) {
        handler.post(new Runnable(this, callback, error){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AdvertisingSetCallback val$callback;
            /* synthetic */ int val$error;
            /* synthetic */ BluetoothLeAdvertiser this$0;

            private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_3$__constructor__(BluetoothLeAdvertiser this$0, AdvertisingSetCallback advertisingSetCallback, int n) {
                this.this$0 = this$0;
                this.val$callback = advertisingSetCallback;
                this.val$error = n;
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_3$run() {
                this.val$callback.onAdvertisingSetStarted(null, 0, this.val$error);
            }

            private void __constructor__(BluetoothLeAdvertiser bluetoothLeAdvertiser, AdvertisingSetCallback advertisingSetCallback, int n) {
                this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_3$__constructor__(bluetoothLeAdvertiser, advertisingSetCallback, n);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_3$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser android.bluetooth.le.AdvertisingSetCallback int ), this, bluetoothLeAdvertiser, advertisingSetCallback, n);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_3$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartFailure(AdvertiseCallback callback, int error) {
        this.mHandler.post(new Runnable(this, callback, error){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AdvertiseCallback val$callback;
            /* synthetic */ int val$error;
            /* synthetic */ BluetoothLeAdvertiser this$0;

            private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_4$__constructor__(BluetoothLeAdvertiser this$0, AdvertiseCallback advertiseCallback, int n) {
                this.this$0 = this$0;
                this.val$callback = advertiseCallback;
                this.val$error = n;
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_4$run() {
                this.val$callback.onStartFailure(this.val$error);
            }

            private void __constructor__(BluetoothLeAdvertiser bluetoothLeAdvertiser, AdvertiseCallback advertiseCallback, int n) {
                this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_4$__constructor__(bluetoothLeAdvertiser, advertiseCallback, n);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_4$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser android.bluetooth.le.AdvertiseCallback int ), this, bluetoothLeAdvertiser, advertiseCallback, n);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_4$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartSuccess(AdvertiseCallback callback, AdvertiseSettings settings) {
        this.mHandler.post(new Runnable(this, callback, settings){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AdvertiseCallback val$callback;
            /* synthetic */ AdvertiseSettings val$settings;
            /* synthetic */ BluetoothLeAdvertiser this$0;

            private void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_5$__constructor__(BluetoothLeAdvertiser this$0, AdvertiseCallback advertiseCallback, AdvertiseSettings advertiseSettings) {
                this.this$0 = this$0;
                this.val$callback = advertiseCallback;
                this.val$settings = advertiseSettings;
            }

            private final void $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_5$run() {
                this.val$callback.onStartSuccess(this.val$settings);
            }

            private void __constructor__(BluetoothLeAdvertiser bluetoothLeAdvertiser, AdvertiseCallback advertiseCallback, AdvertiseSettings advertiseSettings) {
                this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser_5$__constructor__(bluetoothLeAdvertiser, advertiseCallback, advertiseSettings);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_5$__constructor__(android.bluetooth.le.BluetoothLeAdvertiser android.bluetooth.le.AdvertiseCallback android.bluetooth.le.AdvertiseSettings ), this, bluetoothLeAdvertiser, advertiseCallback, advertiseSettings);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser_5$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private void __constructor__(IBluetoothManager iBluetoothManager) {
        this.$$robo$$android_bluetooth_le_BluetoothLeAdvertiser$__constructor__(iBluetoothManager);
    }

    public BluetoothLeAdvertiser(IBluetoothManager iBluetoothManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$__constructor__(android.bluetooth.IBluetoothManager ), this, iBluetoothManager);
    }

    public void startAdvertising(AdvertiseSettings advertiseSettings, AdvertiseData advertiseData, AdvertiseCallback advertiseCallback) {
        InvokeDynamicSupport.bootstrap("startAdvertising", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertising(android.bluetooth.le.AdvertiseSettings android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseCallback ), this, advertiseSettings, advertiseData, advertiseCallback);
    }

    public void startAdvertising(AdvertiseSettings advertiseSettings, AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseCallback advertiseCallback) {
        InvokeDynamicSupport.bootstrap("startAdvertising", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertising(android.bluetooth.le.AdvertiseSettings android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseCallback ), this, advertiseSettings, advertiseData, advertiseData2, advertiseCallback);
    }

    AdvertisingSetCallback wrapOldCallback(AdvertiseCallback advertiseCallback, AdvertiseSettings advertiseSettings) {
        return InvokeDynamicSupport.bootstrap("wrapOldCallback", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$wrapOldCallback(android.bluetooth.le.AdvertiseCallback android.bluetooth.le.AdvertiseSettings ), this, advertiseCallback, advertiseSettings);
    }

    public void stopAdvertising(AdvertiseCallback advertiseCallback) {
        InvokeDynamicSupport.bootstrap("stopAdvertising", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$stopAdvertising(android.bluetooth.le.AdvertiseCallback ), this, advertiseCallback);
    }

    public void startAdvertisingSet(AdvertisingSetParameters advertisingSetParameters, AdvertiseData advertiseData, AdvertiseData advertiseData2, PeriodicAdvertisingParameters periodicAdvertisingParameters, AdvertiseData advertiseData3, AdvertisingSetCallback advertisingSetCallback) {
        InvokeDynamicSupport.bootstrap("startAdvertisingSet", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertisingSet(android.bluetooth.le.AdvertisingSetParameters android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseData android.bluetooth.le.PeriodicAdvertisingParameters android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertisingSetCallback ), this, advertisingSetParameters, advertiseData, advertiseData2, periodicAdvertisingParameters, advertiseData3, advertisingSetCallback);
    }

    public void startAdvertisingSet(AdvertisingSetParameters advertisingSetParameters, AdvertiseData advertiseData, AdvertiseData advertiseData2, PeriodicAdvertisingParameters periodicAdvertisingParameters, AdvertiseData advertiseData3, AdvertisingSetCallback advertisingSetCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("startAdvertisingSet", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertisingSet(android.bluetooth.le.AdvertisingSetParameters android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseData android.bluetooth.le.PeriodicAdvertisingParameters android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertisingSetCallback android.os.Handler ), this, advertisingSetParameters, advertiseData, advertiseData2, periodicAdvertisingParameters, advertiseData3, advertisingSetCallback, handler);
    }

    public void startAdvertisingSet(AdvertisingSetParameters advertisingSetParameters, AdvertiseData advertiseData, AdvertiseData advertiseData2, PeriodicAdvertisingParameters periodicAdvertisingParameters, AdvertiseData advertiseData3, int n, int n2, AdvertisingSetCallback advertisingSetCallback) {
        InvokeDynamicSupport.bootstrap("startAdvertisingSet", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertisingSet(android.bluetooth.le.AdvertisingSetParameters android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseData android.bluetooth.le.PeriodicAdvertisingParameters android.bluetooth.le.AdvertiseData int int android.bluetooth.le.AdvertisingSetCallback ), this, advertisingSetParameters, advertiseData, advertiseData2, periodicAdvertisingParameters, advertiseData3, n, n2, advertisingSetCallback);
    }

    public void startAdvertisingSet(AdvertisingSetParameters advertisingSetParameters, AdvertiseData advertiseData, AdvertiseData advertiseData2, PeriodicAdvertisingParameters periodicAdvertisingParameters, AdvertiseData advertiseData3, int n, int n2, AdvertisingSetCallback advertisingSetCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("startAdvertisingSet", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$startAdvertisingSet(android.bluetooth.le.AdvertisingSetParameters android.bluetooth.le.AdvertiseData android.bluetooth.le.AdvertiseData android.bluetooth.le.PeriodicAdvertisingParameters android.bluetooth.le.AdvertiseData int int android.bluetooth.le.AdvertisingSetCallback android.os.Handler ), this, advertisingSetParameters, advertiseData, advertiseData2, periodicAdvertisingParameters, advertiseData3, n, n2, advertisingSetCallback, handler);
    }

    public void stopAdvertisingSet(AdvertisingSetCallback advertisingSetCallback) {
        InvokeDynamicSupport.bootstrap("stopAdvertisingSet", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$stopAdvertisingSet(android.bluetooth.le.AdvertisingSetCallback ), this, advertisingSetCallback);
    }

    public void cleanup() {
        InvokeDynamicSupport.bootstrap("cleanup", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$cleanup(), this);
    }

    private int totalBytes(AdvertiseData advertiseData, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("totalBytes", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$totalBytes(android.bluetooth.le.AdvertiseData boolean ), this, advertiseData, bl);
    }

    private int byteLength(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrap("byteLength", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$byteLength(byte[] ), this, byArray);
    }

    IAdvertisingSetCallback wrap(AdvertisingSetCallback advertisingSetCallback, Handler handler) {
        return InvokeDynamicSupport.bootstrap("wrap", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$wrap(android.bluetooth.le.AdvertisingSetCallback android.os.Handler ), this, advertisingSetCallback, handler);
    }

    private void postStartSetFailure(Handler handler, AdvertisingSetCallback advertisingSetCallback, int n) {
        InvokeDynamicSupport.bootstrap("postStartSetFailure", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartSetFailure(android.os.Handler android.bluetooth.le.AdvertisingSetCallback int ), this, handler, advertisingSetCallback, n);
    }

    private void postStartFailure(AdvertiseCallback advertiseCallback, int n) {
        InvokeDynamicSupport.bootstrap("postStartFailure", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartFailure(android.bluetooth.le.AdvertiseCallback int ), this, advertiseCallback, n);
    }

    private void postStartSuccess(AdvertiseCallback advertiseCallback, AdvertiseSettings advertiseSettings) {
        InvokeDynamicSupport.bootstrap("postStartSuccess", $$robo$$android_bluetooth_le_BluetoothLeAdvertiser$postStartSuccess(android.bluetooth.le.AdvertiseCallback android.bluetooth.le.AdvertiseSettings ), this, advertiseCallback, advertiseSettings);
    }

    public /* synthetic */ BluetoothLeAdvertiser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BluetoothLeAdvertiser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

