/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothUuid;
import android.bluetooth.le.BluetoothLeUtils;
import android.os.ParcelUuid;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ScanRecord
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ScanRecord";
    private static int DATA_TYPE_FLAGS = 1;
    private static int DATA_TYPE_SERVICE_UUIDS_16_BIT_PARTIAL = 2;
    private static int DATA_TYPE_SERVICE_UUIDS_16_BIT_COMPLETE = 3;
    private static int DATA_TYPE_SERVICE_UUIDS_32_BIT_PARTIAL = 4;
    private static int DATA_TYPE_SERVICE_UUIDS_32_BIT_COMPLETE = 5;
    private static int DATA_TYPE_SERVICE_UUIDS_128_BIT_PARTIAL = 6;
    private static int DATA_TYPE_SERVICE_UUIDS_128_BIT_COMPLETE = 7;
    private static int DATA_TYPE_LOCAL_NAME_SHORT = 8;
    private static int DATA_TYPE_LOCAL_NAME_COMPLETE = 9;
    private static int DATA_TYPE_TX_POWER_LEVEL = 10;
    private static int DATA_TYPE_SERVICE_DATA_16_BIT = 22;
    private static int DATA_TYPE_SERVICE_DATA_32_BIT = 32;
    private static int DATA_TYPE_SERVICE_DATA_128_BIT = 33;
    private static int DATA_TYPE_MANUFACTURER_SPECIFIC_DATA = 255;
    private int mAdvertiseFlags;
    private List<ParcelUuid> mServiceUuids;
    private SparseArray<byte[]> mManufacturerSpecificData;
    private Map<ParcelUuid, byte[]> mServiceData;
    private int mTxPowerLevel;
    private String mDeviceName;
    private byte[] mBytes;

    private final int $$robo$$android_bluetooth_le_ScanRecord$getAdvertiseFlags() {
        return this.mAdvertiseFlags;
    }

    private final List<ParcelUuid> $$robo$$android_bluetooth_le_ScanRecord$getServiceUuids() {
        return this.mServiceUuids;
    }

    private final SparseArray<byte[]> $$robo$$android_bluetooth_le_ScanRecord$getManufacturerSpecificData() {
        return this.mManufacturerSpecificData;
    }

    private final byte[] $$robo$$android_bluetooth_le_ScanRecord$getManufacturerSpecificData(int manufacturerId) {
        return this.mManufacturerSpecificData.get(manufacturerId);
    }

    private final Map<ParcelUuid, byte[]> $$robo$$android_bluetooth_le_ScanRecord$getServiceData() {
        return this.mServiceData;
    }

    private final byte[] $$robo$$android_bluetooth_le_ScanRecord$getServiceData(ParcelUuid serviceDataUuid) {
        if (serviceDataUuid == null) {
            return null;
        }
        return this.mServiceData.get(serviceDataUuid);
    }

    private final int $$robo$$android_bluetooth_le_ScanRecord$getTxPowerLevel() {
        return this.mTxPowerLevel;
    }

    private final String $$robo$$android_bluetooth_le_ScanRecord$getDeviceName() {
        return this.mDeviceName;
    }

    private final byte[] $$robo$$android_bluetooth_le_ScanRecord$getBytes() {
        return this.mBytes;
    }

    private void $$robo$$android_bluetooth_le_ScanRecord$__constructor__(List<ParcelUuid> serviceUuids, SparseArray<byte[]> manufacturerData, Map<ParcelUuid, byte[]> serviceData, int advertiseFlags, int txPowerLevel, String localName, byte[] bytes) {
        this.mServiceUuids = serviceUuids;
        this.mManufacturerSpecificData = manufacturerData;
        this.mServiceData = serviceData;
        this.mDeviceName = localName;
        this.mAdvertiseFlags = advertiseFlags;
        this.mTxPowerLevel = txPowerLevel;
        this.mBytes = bytes;
    }

    private static final ScanRecord $$robo$$android_bluetooth_le_ScanRecord$parseFromBytes(byte[] scanRecord) {
        if (scanRecord == null) {
            return null;
        }
        int advertiseFlag = -1;
        ArrayList<ParcelUuid> serviceUuids = new ArrayList<ParcelUuid>();
        String localName = null;
        int txPowerLevel = Integer.MIN_VALUE;
        SparseArray<byte[]> manufacturerData = new SparseArray<byte[]>();
        ArrayMap<ParcelUuid, byte[]> serviceData = new ArrayMap<ParcelUuid, byte[]>();
        try {
            int length;
            int dataLength;
            block12: for (int currentPos = 0; currentPos < scanRecord.length && (length = scanRecord[currentPos++] & 0xFF) != 0; currentPos += dataLength) {
                dataLength = length - 1;
                int fieldType = scanRecord[currentPos++] & 0xFF;
                switch (fieldType) {
                    case 1: {
                        advertiseFlag = scanRecord[currentPos] & 0xFF;
                        continue block12;
                    }
                    case 2: 
                    case 3: {
                        ScanRecord.parseServiceUuid(scanRecord, currentPos, dataLength, 2, serviceUuids);
                        continue block12;
                    }
                    case 4: 
                    case 5: {
                        ScanRecord.parseServiceUuid(scanRecord, currentPos, dataLength, 4, serviceUuids);
                        continue block12;
                    }
                    case 6: 
                    case 7: {
                        ScanRecord.parseServiceUuid(scanRecord, currentPos, dataLength, 16, serviceUuids);
                        continue block12;
                    }
                    case 8: 
                    case 9: {
                        localName = new String(ScanRecord.extractBytes(scanRecord, currentPos, dataLength));
                        continue block12;
                    }
                    case 10: {
                        txPowerLevel = scanRecord[currentPos];
                        continue block12;
                    }
                    case 22: 
                    case 32: 
                    case 33: {
                        int serviceUuidLength = 2;
                        if (fieldType == 32) {
                            serviceUuidLength = 4;
                        } else if (fieldType == 33) {
                            serviceUuidLength = 16;
                        }
                        byte[] serviceDataUuidBytes = ScanRecord.extractBytes(scanRecord, currentPos, serviceUuidLength);
                        ParcelUuid serviceDataUuid = BluetoothUuid.parseUuidFrom(serviceDataUuidBytes);
                        byte[] serviceDataArray = ScanRecord.extractBytes(scanRecord, currentPos + serviceUuidLength, dataLength - serviceUuidLength);
                        serviceData.put(serviceDataUuid, serviceDataArray);
                        continue block12;
                    }
                    case 255: {
                        int manufacturerId = ((scanRecord[currentPos + 1] & 0xFF) << 8) + (scanRecord[currentPos] & 0xFF);
                        byte[] manufacturerDataBytes = ScanRecord.extractBytes(scanRecord, currentPos + 2, dataLength - 2);
                        manufacturerData.put(manufacturerId, manufacturerDataBytes);
                        continue block12;
                    }
                }
            }
            if (serviceUuids.isEmpty()) {
                serviceUuids = null;
            }
            return new ScanRecord(serviceUuids, manufacturerData, serviceData, advertiseFlag, txPowerLevel, localName, scanRecord);
        }
        catch (Exception e) {
            Log.e("ScanRecord", "unable to parse scan record: " + Arrays.toString(scanRecord));
            return new ScanRecord(null, null, null, -1, Integer.MIN_VALUE, null, scanRecord);
        }
    }

    private final String $$robo$$android_bluetooth_le_ScanRecord$toString() {
        return "ScanRecord [mAdvertiseFlags=" + this.mAdvertiseFlags + ", mServiceUuids=" + this.mServiceUuids + ", mManufacturerSpecificData=" + BluetoothLeUtils.toString(this.mManufacturerSpecificData) + ", mServiceData=" + BluetoothLeUtils.toString(this.mServiceData) + ", mTxPowerLevel=" + this.mTxPowerLevel + ", mDeviceName=" + this.mDeviceName + "]";
    }

    private static final int $$robo$$android_bluetooth_le_ScanRecord$parseServiceUuid(byte[] scanRecord, int currentPos, int dataLength, int uuidLength, List<ParcelUuid> serviceUuids) {
        while (dataLength > 0) {
            byte[] uuidBytes = ScanRecord.extractBytes(scanRecord, currentPos, uuidLength);
            serviceUuids.add(BluetoothUuid.parseUuidFrom(uuidBytes));
            dataLength -= uuidLength;
            currentPos += uuidLength;
        }
        return currentPos;
    }

    private static final byte[] $$robo$$android_bluetooth_le_ScanRecord$extractBytes(byte[] scanRecord, int start, int length) {
        byte[] bytes = new byte[length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])scanRecord, (int)start, (byte[])bytes, (int)0, (int)length);
        return bytes;
    }

    public int getAdvertiseFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getAdvertiseFlags", $$robo$$android_bluetooth_le_ScanRecord$getAdvertiseFlags(), this);
    }

    public List<ParcelUuid> getServiceUuids() {
        return InvokeDynamicSupport.bootstrap("getServiceUuids", $$robo$$android_bluetooth_le_ScanRecord$getServiceUuids(), this);
    }

    public SparseArray<byte[]> getManufacturerSpecificData() {
        return InvokeDynamicSupport.bootstrap("getManufacturerSpecificData", $$robo$$android_bluetooth_le_ScanRecord$getManufacturerSpecificData(), this);
    }

    public byte[] getManufacturerSpecificData(int n) {
        return InvokeDynamicSupport.bootstrap("getManufacturerSpecificData", $$robo$$android_bluetooth_le_ScanRecord$getManufacturerSpecificData(int ), this, n);
    }

    public Map<ParcelUuid, byte[]> getServiceData() {
        return InvokeDynamicSupport.bootstrap("getServiceData", $$robo$$android_bluetooth_le_ScanRecord$getServiceData(), this);
    }

    public byte[] getServiceData(ParcelUuid parcelUuid) {
        return InvokeDynamicSupport.bootstrap("getServiceData", $$robo$$android_bluetooth_le_ScanRecord$getServiceData(android.os.ParcelUuid ), this, parcelUuid);
    }

    public int getTxPowerLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getTxPowerLevel", $$robo$$android_bluetooth_le_ScanRecord$getTxPowerLevel(), this);
    }

    public String getDeviceName() {
        return InvokeDynamicSupport.bootstrap("getDeviceName", $$robo$$android_bluetooth_le_ScanRecord$getDeviceName(), this);
    }

    public byte[] getBytes() {
        return InvokeDynamicSupport.bootstrap("getBytes", $$robo$$android_bluetooth_le_ScanRecord$getBytes(), this);
    }

    private void __constructor__(List<ParcelUuid> list, SparseArray<byte[]> sparseArray, Map<ParcelUuid, byte[]> map, int n, int n2, String string2, byte[] byArray) {
        this.$$robo$$android_bluetooth_le_ScanRecord$__constructor__(list, sparseArray, map, n, n2, string2, byArray);
    }

    public ScanRecord(List<ParcelUuid> list, SparseArray<byte[]> sparseArray, Map<ParcelUuid, byte[]> map, int n, int n2, String string2, byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_bluetooth_le_ScanRecord$__constructor__(java.util.List<android.os.ParcelUuid> android.util.SparseArray<byte[]> java.util.Map<android.os.ParcelUuid, byte[]> int int java.lang.String byte[] ), this, list, sparseArray, map, n, n2, string2, byArray);
    }

    public static ScanRecord parseFromBytes(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("parseFromBytes", $$robo$$android_bluetooth_le_ScanRecord$parseFromBytes(byte[] ), (byte[])byArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_bluetooth_le_ScanRecord$toString(), this);
    }

    private static int parseServiceUuid(byte[] byArray, int n, int n2, int n3, List<ParcelUuid> list) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parseServiceUuid", $$robo$$android_bluetooth_le_ScanRecord$parseServiceUuid(byte[] int int int java.util.List<android.os.ParcelUuid> ), (byte[])byArray, (int)n, (int)n2, (int)n3, list);
    }

    private static byte[] extractBytes(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("extractBytes", $$robo$$android_bluetooth_le_ScanRecord$extractBytes(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    public /* synthetic */ ScanRecord() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScanRecord)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

