/*
 * Decompiled with CFR 0.152.
 */
package android.companion;

import android.app.Activity;
import android.app.Application;
import android.app.PendingIntent;
import android.companion.AssociationRequest;
import android.companion.ICompanionDeviceManager;
import android.companion.IFindDeviceCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CompanionDeviceManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String LOG_TAG = "CompanionDeviceManager";
    public static String EXTRA_DEVICE = "android.companion.extra.DEVICE";
    public static String COMPANION_DEVICE_DISCOVERY_PACKAGE_NAME = "com.android.companiondevicemanager";
    private ICompanionDeviceManager mService;
    private Context mContext;

    private void $$robo$$android_companion_CompanionDeviceManager$__constructor__(ICompanionDeviceManager service, Context context) {
        this.mService = service;
        this.mContext = context;
    }

    private final void $$robo$$android_companion_CompanionDeviceManager$associate(AssociationRequest request, Callback callback, Handler handler) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        Preconditions.checkNotNull(request, "Request cannot be null");
        Preconditions.checkNotNull(callback, "Callback cannot be null");
        try {
            this.mService.associate(request, new CallbackProxy(this, request, callback, Handler.mainIfNull(handler), null), this.getCallingPackage());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<String> $$robo$$android_companion_CompanionDeviceManager$getAssociations() {
        if (!this.checkFeaturePresent()) {
            return Collections.emptyList();
        }
        try {
            return this.mService.getAssociations(this.getCallingPackage(), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_companion_CompanionDeviceManager$disassociate(String deviceMacAddress) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            this.mService.disassociate(deviceMacAddress, this.getCallingPackage());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_companion_CompanionDeviceManager$requestNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return;
        }
        try {
            IntentSender intentSender = this.mService.requestNotificationAccess(component).getIntentSender();
            this.mContext.startIntentSender(intentSender, null, 0, 0, 0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (IntentSender.SendIntentException e) {
            throw new RuntimeException(e);
        }
    }

    private final boolean $$robo$$android_companion_CompanionDeviceManager$hasNotificationAccess(ComponentName component) {
        if (!this.checkFeaturePresent()) {
            return false;
        }
        try {
            return this.mService.hasNotificationAccess(component);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_companion_CompanionDeviceManager$checkFeaturePresent() {
        boolean featurePresent;
        boolean bl = featurePresent = this.mService != null;
        if (!featurePresent) {
            // empty if block
        }
        return featurePresent;
    }

    private final Activity $$robo$$android_companion_CompanionDeviceManager$getActivity() {
        return (Activity)this.mContext;
    }

    private final String $$robo$$android_companion_CompanionDeviceManager$getCallingPackage() {
        return this.mContext.getPackageName();
    }

    private void __constructor__(ICompanionDeviceManager iCompanionDeviceManager, Context context) {
        this.$$robo$$android_companion_CompanionDeviceManager$__constructor__(iCompanionDeviceManager, context);
    }

    public CompanionDeviceManager(ICompanionDeviceManager iCompanionDeviceManager, Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_CompanionDeviceManager$__constructor__(android.companion.ICompanionDeviceManager android.content.Context ), this, iCompanionDeviceManager, context);
    }

    public void associate(AssociationRequest associationRequest, Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("associate", $$robo$$android_companion_CompanionDeviceManager$associate(android.companion.AssociationRequest android.companion.CompanionDeviceManager$Callback android.os.Handler ), this, associationRequest, callback, handler);
    }

    public List<String> getAssociations() {
        return InvokeDynamicSupport.bootstrap("getAssociations", $$robo$$android_companion_CompanionDeviceManager$getAssociations(), this);
    }

    public void disassociate(String string2) {
        InvokeDynamicSupport.bootstrap("disassociate", $$robo$$android_companion_CompanionDeviceManager$disassociate(java.lang.String ), this, string2);
    }

    public void requestNotificationAccess(ComponentName componentName) {
        InvokeDynamicSupport.bootstrap("requestNotificationAccess", $$robo$$android_companion_CompanionDeviceManager$requestNotificationAccess(android.content.ComponentName ), this, componentName);
    }

    public boolean hasNotificationAccess(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNotificationAccess", $$robo$$android_companion_CompanionDeviceManager$hasNotificationAccess(android.content.ComponentName ), this, componentName);
    }

    private boolean checkFeaturePresent() {
        return (boolean)InvokeDynamicSupport.bootstrap("checkFeaturePresent", $$robo$$android_companion_CompanionDeviceManager$checkFeaturePresent(), this);
    }

    private Activity getActivity() {
        return InvokeDynamicSupport.bootstrap("getActivity", $$robo$$android_companion_CompanionDeviceManager$getActivity(), this);
    }

    private String getCallingPackage() {
        return InvokeDynamicSupport.bootstrap("getCallingPackage", $$robo$$android_companion_CompanionDeviceManager$getCallingPackage(), this);
    }

    public /* synthetic */ CompanionDeviceManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CompanionDeviceManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CallbackProxy
    extends IFindDeviceCallback.Stub
    implements Application.ActivityLifecycleCallbacks,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Callback mCallback;
        private Handler mHandler;
        private AssociationRequest mRequest;
        Object mLock;
        /* synthetic */ CompanionDeviceManager this$0;

        private void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$__constructor__(CompanionDeviceManager companionDeviceManager, AssociationRequest request, Callback callback, Handler handler) {
            this.this$0 = companionDeviceManager;
            this.mLock = new Object();
            this.mCallback = callback;
            this.mHandler = handler;
            this.mRequest = request;
            companionDeviceManager.getActivity().getApplication().registerActivityLifecycleCallbacks(this);
        }

        private final void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onSuccess(PendingIntent launcher) {
            this.lockAndPost(Callback::onDeviceFound, launcher.getIntentSender());
        }

        private final void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onFailure(CharSequence reason) {
            this.lockAndPost(Callback::onFailure, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$lockAndPost(BiConsumer<Callback, T> action, T payload) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHandler != null) {
                    this.mHandler.post(() -> {
                        Callback callback = null;
                        Object object = this.mLock;
                        synchronized (object) {
                            callback = this.mCallback;
                        }
                        if (callback != null) {
                            action.accept(callback, payload);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityDestroyed(Activity activity) {
            Object object = this.mLock;
            synchronized (object) {
                if (activity != this.this$0.getActivity()) {
                    return;
                }
                try {
                    this.this$0.mService.stopScan(this.mRequest, this, this.this$0.getCallingPackage());
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
                this.this$0.getActivity().getApplication().unregisterActivityLifecycleCallbacks(this);
                this.mCallback = null;
                this.mHandler = null;
                this.mRequest = null;
            }
        }

        private final void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        private final void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityStarted(Activity activity) {
        }

        private final void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityResumed(Activity activity) {
        }

        private final void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityPaused(Activity activity) {
        }

        private final void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityStopped(Activity activity) {
        }

        private final void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        private /* synthetic */ void $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$__constructor__(CompanionDeviceManager x0, AssociationRequest x1, Callback x2, Handler x3, 1 x4) {
        }

        private void __constructor__(CompanionDeviceManager companionDeviceManager, AssociationRequest associationRequest, Callback callback, Handler handler) {
            this.$$robo$$android_companion_CompanionDeviceManager_CallbackProxy$__constructor__(companionDeviceManager, associationRequest, callback, handler);
        }

        public CallbackProxy(CompanionDeviceManager companionDeviceManager, AssociationRequest associationRequest, Callback callback, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$__constructor__(android.companion.CompanionDeviceManager android.companion.AssociationRequest android.companion.CompanionDeviceManager$Callback android.os.Handler ), this, companionDeviceManager, associationRequest, callback, handler);
        }

        @Override
        public void onSuccess(PendingIntent pendingIntent) {
            InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onSuccess(android.app.PendingIntent ), this, pendingIntent);
        }

        @Override
        public void onFailure(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onFailure", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onFailure(java.lang.CharSequence ), this, charSequence);
        }

        <T> void lockAndPost(BiConsumer<Callback, T> biConsumer, T t) {
            InvokeDynamicSupport.bootstrap("lockAndPost", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$lockAndPost(java.util.function.BiConsumer<android.companion.CompanionDeviceManager$Callback, T> T ), this, biConsumer, t);
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityDestroyed", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityDestroyed(android.app.Activity ), this, activity);
        }

        @Override
        public void onActivityCreated(Activity activity, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onActivityCreated", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityCreated(android.app.Activity android.os.Bundle ), this, activity, bundle);
        }

        @Override
        public void onActivityStarted(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityStarted", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityStarted(android.app.Activity ), this, activity);
        }

        @Override
        public void onActivityResumed(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityResumed", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityResumed(android.app.Activity ), this, activity);
        }

        @Override
        public void onActivityPaused(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityPaused", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityPaused(android.app.Activity ), this, activity);
        }

        @Override
        public void onActivityStopped(Activity activity) {
            InvokeDynamicSupport.bootstrap("onActivityStopped", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivityStopped(android.app.Activity ), this, activity);
        }

        @Override
        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onActivitySaveInstanceState", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$onActivitySaveInstanceState(android.app.Activity android.os.Bundle ), this, activity, bundle);
        }

        private /* synthetic */ void __constructor__(CompanionDeviceManager companionDeviceManager, AssociationRequest associationRequest, Callback callback, Handler handler, 1 var5_5) {
            this.$$robo$$android_companion_CompanionDeviceManager_CallbackProxy$__constructor__(companionDeviceManager, associationRequest, callback, handler, var5_5);
        }

        public /* synthetic */ CallbackProxy(CompanionDeviceManager companionDeviceManager, AssociationRequest associationRequest, Callback callback, Handler handler, 1 var5_5) {
            this(companionDeviceManager, associationRequest, callback, handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_CompanionDeviceManager_CallbackProxy$__constructor__(android.companion.CompanionDeviceManager android.companion.AssociationRequest android.companion.CompanionDeviceManager$Callback android.os.Handler android.companion.CompanionDeviceManager$1 ), this, companionDeviceManager, associationRequest, callback, handler, var5_5);
        }

        public /* synthetic */ CallbackProxy() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackProxy)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_companion_CompanionDeviceManager_Callback$__constructor__() {
        }

        public abstract void onDeviceFound(IntentSender var1);

        public abstract void onFailure(CharSequence var1);

        private void __constructor__() {
            this.$$robo$$android_companion_CompanionDeviceManager_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_companion_CompanionDeviceManager_Callback$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

