/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.Context;
import android.content.SyncAdapterType;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.SparseArray;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class SyncAdaptersCache
extends RegisteredServicesCache<SyncAdapterType> {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Account";
    private static String SERVICE_INTERFACE = "android.content.SyncAdapter";
    private static String SERVICE_META_DATA = "android.content.SyncAdapter";
    private static String ATTRIBUTES_NAME = "sync-adapter";
    private static MySerializer sSerializer;
    @GuardedBy(value="mServicesLock")
    private SparseArray<ArrayMap<String, String[]>> mAuthorityToSyncAdapters;

    private void $$robo$$android_content_SyncAdaptersCache$__constructor__(Context context) {
        this.mAuthorityToSyncAdapters = new SparseArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SyncAdapterType $$robo$$android_content_SyncAdaptersCache$parseServiceAttributes(Resources res, String packageName, AttributeSet attrs) {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.SyncAdapter);
        try {
            String authority = sa.getString(2);
            String accountType = sa.getString(1);
            if (TextUtils.isEmpty(authority) || TextUtils.isEmpty(accountType)) {
                SyncAdapterType syncAdapterType = null;
                return syncAdapterType;
            }
            boolean userVisible = sa.getBoolean(3, true);
            boolean supportsUploading = sa.getBoolean(4, true);
            boolean isAlwaysSyncable = sa.getBoolean(6, false);
            boolean allowParallelSyncs = sa.getBoolean(5, false);
            String settingsActivity = sa.getString(0);
            SyncAdapterType syncAdapterType = new SyncAdapterType(authority, accountType, userVisible, supportsUploading, isAlwaysSyncable, allowParallelSyncs, settingsActivity, packageName);
            return syncAdapterType;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_SyncAdaptersCache$onServicesChangedLocked(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            ArrayMap<String, String[]> adapterMap = this.mAuthorityToSyncAdapters.get(userId);
            if (adapterMap != null) {
                adapterMap.clear();
            }
        }
        super.onServicesChangedLocked(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$android_content_SyncAdaptersCache$getSyncAdapterPackagesForAuthority(String authority, int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            ArrayMap<String, Object> adapterMap = this.mAuthorityToSyncAdapters.get(userId);
            if (adapterMap == null) {
                adapterMap = new ArrayMap();
                this.mAuthorityToSyncAdapters.put(userId, adapterMap);
            }
            if (adapterMap.containsKey(authority)) {
                return (String[])adapterMap.get(authority);
            }
            Collection serviceInfos = this.getAllServices(userId);
            ArrayList<String> packages = new ArrayList<String>();
            for (RegisteredServicesCache.ServiceInfo serviceInfo : serviceInfos) {
                if (!authority.equals(((SyncAdapterType)serviceInfo.type).authority) || serviceInfo.componentName == null) continue;
                packages.add(serviceInfo.componentName.getPackageName());
            }
            String[] syncAdapterPackages = new String[packages.size()];
            packages.toArray(syncAdapterPackages);
            adapterMap.put(authority, syncAdapterPackages);
            return syncAdapterPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_SyncAdaptersCache$onUserRemoved(int userId) {
        Object object = this.mServicesLock;
        synchronized (object) {
            this.mAuthorityToSyncAdapters.remove(userId);
        }
        super.onUserRemoved(userId);
    }

    static void __staticInitializer__() {
        sSerializer = new MySerializer();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_content_SyncAdaptersCache$__constructor__(context);
    }

    public SyncAdaptersCache(Context context) {
        super(context, "android.content.SyncAdapter", "android.content.SyncAdapter", "sync-adapter", sSerializer);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncAdaptersCache$__constructor__(android.content.Context ), this, context);
    }

    @Override
    public SyncAdapterType parseServiceAttributes(Resources resources, String string2, AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("parseServiceAttributes", $$robo$$android_content_SyncAdaptersCache$parseServiceAttributes(android.content.res.Resources java.lang.String android.util.AttributeSet ), this, resources, string2, attributeSet);
    }

    @Override
    protected void onServicesChangedLocked(int n) {
        InvokeDynamicSupport.bootstrap("onServicesChangedLocked", $$robo$$android_content_SyncAdaptersCache$onServicesChangedLocked(int ), this, n);
    }

    public String[] getSyncAdapterPackagesForAuthority(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getSyncAdapterPackagesForAuthority", $$robo$$android_content_SyncAdaptersCache$getSyncAdapterPackagesForAuthority(java.lang.String int ), this, string2, n);
    }

    @Override
    protected void onUserRemoved(int n) {
        InvokeDynamicSupport.bootstrap("onUserRemoved", $$robo$$android_content_SyncAdaptersCache$onUserRemoved(int ), this, n);
    }

    static {
        RobolectricInternals.classInitializing(SyncAdaptersCache.class);
    }

    public /* synthetic */ SyncAdaptersCache() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncAdaptersCache)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MySerializer
    implements XmlSerializerAndParser<SyncAdapterType> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_SyncAdaptersCache_MySerializer$__constructor__() {
        }

        private final void $$robo$$android_content_SyncAdaptersCache_MySerializer$writeAsXml(SyncAdapterType item, XmlSerializer out) throws IOException {
            out.attribute(null, "authority", item.authority);
            out.attribute(null, "accountType", item.accountType);
        }

        private final SyncAdapterType $$robo$$android_content_SyncAdaptersCache_MySerializer$createFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
            String authority = parser.getAttributeValue(null, "authority");
            String accountType = parser.getAttributeValue(null, "accountType");
            return SyncAdapterType.newKey(authority, accountType);
        }

        private void __constructor__() {
            this.$$robo$$android_content_SyncAdaptersCache_MySerializer$__constructor__();
        }

        public MySerializer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncAdaptersCache_MySerializer$__constructor__(), this);
        }

        @Override
        public void writeAsXml(SyncAdapterType syncAdapterType, XmlSerializer xmlSerializer) throws IOException {
            InvokeDynamicSupport.bootstrap("writeAsXml", $$robo$$android_content_SyncAdaptersCache_MySerializer$writeAsXml(android.content.SyncAdapterType org.xmlpull.v1.XmlSerializer ), this, syncAdapterType, xmlSerializer);
        }

        @Override
        public SyncAdapterType createFromXml(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
            return InvokeDynamicSupport.bootstrap("createFromXml", $$robo$$android_content_SyncAdaptersCache_MySerializer$createFromXml(org.xmlpull.v1.XmlPullParser ), this, xmlPullParser);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MySerializer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

