/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentResolver;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SyncStatusInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Sync";
    static int VERSION = 6;
    private static int MAX_EVENT_COUNT = 10;
    private static int SOURCE_COUNT = 6;
    public int authorityId;
    public long lastTodayResetTime;
    public Stats totalStats;
    public Stats todayStats;
    public Stats yesterdayStats;
    public long lastSuccessTime;
    public int lastSuccessSource;
    public long lastFailureTime;
    public int lastFailureSource;
    public String lastFailureMesg;
    public long initialFailureTime;
    public boolean pending;
    public boolean initialize;
    public long[] perSourceLastSuccessTimes;
    public long[] perSourceLastFailureTimes;
    private ArrayList<Long> periodicSyncTimes;
    private ArrayList<Long> mLastEventTimes;
    private ArrayList<String> mLastEvents;
    public static Parcelable.Creator<SyncStatusInfo> CREATOR;

    private void $$robo$$android_content_SyncStatusInfo$__constructor__(int authorityId) {
        this.totalStats = new Stats();
        this.todayStats = new Stats();
        this.yesterdayStats = new Stats();
        this.perSourceLastSuccessTimes = new long[6];
        this.perSourceLastFailureTimes = new long[6];
        this.mLastEventTimes = new ArrayList();
        this.mLastEvents = new ArrayList();
        this.authorityId = authorityId;
    }

    private final int $$robo$$android_content_SyncStatusInfo$getLastFailureMesgAsInt(int def) {
        int i = ContentResolver.syncErrorStringToInt(this.lastFailureMesg);
        if (i > 0) {
            return i;
        }
        Log.d("Sync", "Unknown lastFailureMesg:" + this.lastFailureMesg);
        return def;
    }

    private final int $$robo$$android_content_SyncStatusInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_content_SyncStatusInfo$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(6);
        parcel.writeInt(this.authorityId);
        parcel.writeLong(this.totalStats.totalElapsedTime);
        parcel.writeInt(this.totalStats.numSyncs);
        parcel.writeInt(this.totalStats.numSourcePoll);
        parcel.writeInt(this.totalStats.numSourceOther);
        parcel.writeInt(this.totalStats.numSourceLocal);
        parcel.writeInt(this.totalStats.numSourceUser);
        parcel.writeLong(this.lastSuccessTime);
        parcel.writeInt(this.lastSuccessSource);
        parcel.writeLong(this.lastFailureTime);
        parcel.writeInt(this.lastFailureSource);
        parcel.writeString(this.lastFailureMesg);
        parcel.writeLong(this.initialFailureTime);
        parcel.writeInt(this.pending ? 1 : 0);
        parcel.writeInt(this.initialize ? 1 : 0);
        if (this.periodicSyncTimes != null) {
            parcel.writeInt(this.periodicSyncTimes.size());
            for (long periodicSyncTime : this.periodicSyncTimes) {
                parcel.writeLong(periodicSyncTime);
            }
        } else {
            parcel.writeInt(-1);
        }
        parcel.writeInt(this.mLastEventTimes.size());
        for (int i = 0; i < this.mLastEventTimes.size(); ++i) {
            parcel.writeLong(this.mLastEventTimes.get(i));
            parcel.writeString(this.mLastEvents.get(i));
        }
        parcel.writeInt(this.totalStats.numSourcePeriodic);
        parcel.writeInt(this.totalStats.numSourceFeed);
        parcel.writeInt(this.totalStats.numFailures);
        parcel.writeInt(this.totalStats.numCancels);
        parcel.writeLong(this.lastTodayResetTime);
        this.todayStats.writeToParcel(parcel);
        this.yesterdayStats.writeToParcel(parcel);
        parcel.writeLongArray(this.perSourceLastSuccessTimes);
        parcel.writeLongArray(this.perSourceLastFailureTimes);
    }

    private void $$robo$$android_content_SyncStatusInfo$__constructor__(Parcel parcel) {
        this.totalStats = new Stats();
        this.todayStats = new Stats();
        this.yesterdayStats = new Stats();
        this.perSourceLastSuccessTimes = new long[6];
        this.perSourceLastFailureTimes = new long[6];
        this.mLastEventTimes = new ArrayList();
        this.mLastEvents = new ArrayList();
        int version = parcel.readInt();
        if (version != 6 && version != 1) {
            Log.w("SyncStatusInfo", "Unknown version: " + version);
        }
        this.authorityId = parcel.readInt();
        this.totalStats.totalElapsedTime = parcel.readLong();
        this.totalStats.numSyncs = parcel.readInt();
        this.totalStats.numSourcePoll = parcel.readInt();
        this.totalStats.numSourceOther = parcel.readInt();
        this.totalStats.numSourceLocal = parcel.readInt();
        this.totalStats.numSourceUser = parcel.readInt();
        this.lastSuccessTime = parcel.readLong();
        this.lastSuccessSource = parcel.readInt();
        this.lastFailureTime = parcel.readLong();
        this.lastFailureSource = parcel.readInt();
        this.lastFailureMesg = parcel.readString();
        this.initialFailureTime = parcel.readLong();
        this.pending = parcel.readInt() != 0;
        boolean bl = this.initialize = parcel.readInt() != 0;
        if (version == 1) {
            this.periodicSyncTimes = null;
        } else {
            int count = parcel.readInt();
            if (count < 0) {
                this.periodicSyncTimes = null;
            } else {
                this.periodicSyncTimes = new ArrayList();
                for (int i = 0; i < count; ++i) {
                    this.periodicSyncTimes.add(parcel.readLong());
                }
            }
            if (version >= 3) {
                this.mLastEventTimes.clear();
                this.mLastEvents.clear();
                int nEvents = parcel.readInt();
                for (int i = 0; i < nEvents; ++i) {
                    this.mLastEventTimes.add(parcel.readLong());
                    this.mLastEvents.add(parcel.readString());
                }
            }
        }
        if (version < 4) {
            this.totalStats.numSourcePeriodic = this.totalStats.numSyncs - this.totalStats.numSourceLocal - this.totalStats.numSourcePoll - this.totalStats.numSourceOther - this.totalStats.numSourceUser;
            if (this.totalStats.numSourcePeriodic < 0) {
                this.totalStats.numSourcePeriodic = 0;
            }
        } else {
            this.totalStats.numSourcePeriodic = parcel.readInt();
        }
        if (version >= 5) {
            this.totalStats.numSourceFeed = parcel.readInt();
            this.totalStats.numFailures = parcel.readInt();
            this.totalStats.numCancels = parcel.readInt();
            this.lastTodayResetTime = parcel.readLong();
            this.todayStats.readFromParcel(parcel);
            this.yesterdayStats.readFromParcel(parcel);
        }
        if (version >= 6) {
            parcel.readLongArray(this.perSourceLastSuccessTimes);
            parcel.readLongArray(this.perSourceLastFailureTimes);
        }
    }

    private void $$robo$$android_content_SyncStatusInfo$__constructor__(SyncStatusInfo other) {
        this.totalStats = new Stats();
        this.todayStats = new Stats();
        this.yesterdayStats = new Stats();
        this.perSourceLastSuccessTimes = new long[6];
        this.perSourceLastFailureTimes = new long[6];
        this.mLastEventTimes = new ArrayList();
        this.mLastEvents = new ArrayList();
        this.authorityId = other.authorityId;
        other.totalStats.copyTo(this.totalStats);
        other.todayStats.copyTo(this.todayStats);
        other.yesterdayStats.copyTo(this.yesterdayStats);
        this.lastTodayResetTime = other.lastTodayResetTime;
        this.lastSuccessTime = other.lastSuccessTime;
        this.lastSuccessSource = other.lastSuccessSource;
        this.lastFailureTime = other.lastFailureTime;
        this.lastFailureSource = other.lastFailureSource;
        this.lastFailureMesg = other.lastFailureMesg;
        this.initialFailureTime = other.initialFailureTime;
        this.pending = other.pending;
        this.initialize = other.initialize;
        if (other.periodicSyncTimes != null) {
            this.periodicSyncTimes = new ArrayList<Long>(other.periodicSyncTimes);
        }
        this.mLastEventTimes.addAll(other.mLastEventTimes);
        this.mLastEvents.addAll(other.mLastEvents);
        SyncStatusInfo.copy(this.perSourceLastSuccessTimes, other.perSourceLastSuccessTimes);
        SyncStatusInfo.copy(this.perSourceLastFailureTimes, other.perSourceLastFailureTimes);
    }

    private static final void $$robo$$android_content_SyncStatusInfo$copy(long[] to, long[] from) {
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)from, (int)0, (Object)to, (int)0, (int)to.length);
    }

    private final void $$robo$$android_content_SyncStatusInfo$setPeriodicSyncTime(int index, long when) {
        this.ensurePeriodicSyncTimeSize(index);
        this.periodicSyncTimes.set(index, when);
    }

    private final long $$robo$$android_content_SyncStatusInfo$getPeriodicSyncTime(int index) {
        if (this.periodicSyncTimes != null && index < this.periodicSyncTimes.size()) {
            return this.periodicSyncTimes.get(index);
        }
        return 0L;
    }

    private final void $$robo$$android_content_SyncStatusInfo$removePeriodicSyncTime(int index) {
        if (this.periodicSyncTimes != null && index < this.periodicSyncTimes.size()) {
            this.periodicSyncTimes.remove(index);
        }
    }

    private final void $$robo$$android_content_SyncStatusInfo$addEvent(String message) {
        if (this.mLastEventTimes.size() >= 10) {
            this.mLastEventTimes.remove(9);
            this.mLastEvents.remove(9);
        }
        this.mLastEventTimes.add(0, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        this.mLastEvents.add(0, message);
    }

    private final int $$robo$$android_content_SyncStatusInfo$getEventCount() {
        return this.mLastEventTimes.size();
    }

    private final long $$robo$$android_content_SyncStatusInfo$getEventTime(int i) {
        return this.mLastEventTimes.get(i);
    }

    private final String $$robo$$android_content_SyncStatusInfo$getEvent(int i) {
        return this.mLastEvents.get(i);
    }

    private final void $$robo$$android_content_SyncStatusInfo$setLastSuccess(int source, long lastSyncTime) {
        this.lastSuccessTime = lastSyncTime;
        this.lastSuccessSource = source;
        this.lastFailureTime = 0L;
        this.lastFailureSource = -1;
        this.lastFailureMesg = null;
        this.initialFailureTime = 0L;
        if (0 <= source && source < this.perSourceLastSuccessTimes.length) {
            this.perSourceLastSuccessTimes[source] = lastSyncTime;
        }
    }

    private final void $$robo$$android_content_SyncStatusInfo$setLastFailure(int source, long lastSyncTime, String failureMessage) {
        this.lastFailureTime = lastSyncTime;
        this.lastFailureSource = source;
        this.lastFailureMesg = failureMessage;
        if (this.initialFailureTime == 0L) {
            this.initialFailureTime = lastSyncTime;
        }
        if (0 <= source && source < this.perSourceLastFailureTimes.length) {
            this.perSourceLastFailureTimes[source] = lastSyncTime;
        }
    }

    private final void $$robo$$android_content_SyncStatusInfo$ensurePeriodicSyncTimeSize(int index) {
        if (this.periodicSyncTimes == null) {
            this.periodicSyncTimes = new ArrayList(0);
        }
        int requiredSize = index + 1;
        if (this.periodicSyncTimes.size() < requiredSize) {
            for (int i = this.periodicSyncTimes.size(); i < requiredSize; ++i) {
                this.periodicSyncTimes.add(0L);
            }
        }
    }

    private final void $$robo$$android_content_SyncStatusInfo$maybeResetTodayStats(boolean clockValid, boolean force) {
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (!force) {
            if (SyncStatusInfo.areSameDates((long)now, this.lastTodayResetTime)) {
                return;
            }
            if (now < this.lastTodayResetTime && !clockValid) {
                return;
            }
        }
        this.lastTodayResetTime = (long)now;
        this.todayStats.copyTo(this.yesterdayStats);
        this.todayStats.clear();
    }

    private static final boolean $$robo$$android_content_SyncStatusInfo$areSameDates(long time1, long time2) {
        GregorianCalendar c1 = new GregorianCalendar();
        GregorianCalendar c2 = new GregorianCalendar();
        c1.setTimeInMillis(time1);
        c2.setTimeInMillis(time2);
        return c1.get(1) == c2.get(1) && c1.get(6) == c2.get(6);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<SyncStatusInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_content_SyncStatusInfo_1$__constructor__() {
            }

            private final SyncStatusInfo $$robo$$android_content_SyncStatusInfo_1$createFromParcel(Parcel in) {
                return new SyncStatusInfo(in);
            }

            private final SyncStatusInfo[] $$robo$$android_content_SyncStatusInfo_1$newArray(int size) {
                return new SyncStatusInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_content_SyncStatusInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncStatusInfo_1$__constructor__(), this);
            }

            @Override
            public SyncStatusInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_content_SyncStatusInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public SyncStatusInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_content_SyncStatusInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n) {
        this.$$robo$$android_content_SyncStatusInfo$__constructor__(n);
    }

    public SyncStatusInfo(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncStatusInfo$__constructor__(int ), this, n);
    }

    public int getLastFailureMesgAsInt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLastFailureMesgAsInt", $$robo$$android_content_SyncStatusInfo$getLastFailureMesgAsInt(int ), this, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_content_SyncStatusInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_SyncStatusInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_content_SyncStatusInfo$__constructor__(parcel);
    }

    public SyncStatusInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncStatusInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    private void __constructor__(SyncStatusInfo syncStatusInfo) {
        this.$$robo$$android_content_SyncStatusInfo$__constructor__(syncStatusInfo);
    }

    public SyncStatusInfo(SyncStatusInfo syncStatusInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncStatusInfo$__constructor__(android.content.SyncStatusInfo ), this, syncStatusInfo);
    }

    private static void copy(long[] lArray, long[] lArray2) {
        InvokeDynamicSupport.bootstrapStatic("copy", $$robo$$android_content_SyncStatusInfo$copy(long[] long[] ), (long[])lArray, (long[])lArray2);
    }

    public void setPeriodicSyncTime(int n, long l) {
        InvokeDynamicSupport.bootstrap("setPeriodicSyncTime", $$robo$$android_content_SyncStatusInfo$setPeriodicSyncTime(int long ), this, n, l);
    }

    public long getPeriodicSyncTime(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getPeriodicSyncTime", $$robo$$android_content_SyncStatusInfo$getPeriodicSyncTime(int ), this, n);
    }

    public void removePeriodicSyncTime(int n) {
        InvokeDynamicSupport.bootstrap("removePeriodicSyncTime", $$robo$$android_content_SyncStatusInfo$removePeriodicSyncTime(int ), this, n);
    }

    public void addEvent(String string2) {
        InvokeDynamicSupport.bootstrap("addEvent", $$robo$$android_content_SyncStatusInfo$addEvent(java.lang.String ), this, string2);
    }

    public int getEventCount() {
        return (int)InvokeDynamicSupport.bootstrap("getEventCount", $$robo$$android_content_SyncStatusInfo$getEventCount(), this);
    }

    public long getEventTime(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getEventTime", $$robo$$android_content_SyncStatusInfo$getEventTime(int ), this, n);
    }

    public String getEvent(int n) {
        return InvokeDynamicSupport.bootstrap("getEvent", $$robo$$android_content_SyncStatusInfo$getEvent(int ), this, n);
    }

    public void setLastSuccess(int n, long l) {
        InvokeDynamicSupport.bootstrap("setLastSuccess", $$robo$$android_content_SyncStatusInfo$setLastSuccess(int long ), this, n, l);
    }

    public void setLastFailure(int n, long l, String string2) {
        InvokeDynamicSupport.bootstrap("setLastFailure", $$robo$$android_content_SyncStatusInfo$setLastFailure(int long java.lang.String ), this, n, l, string2);
    }

    private void ensurePeriodicSyncTimeSize(int n) {
        InvokeDynamicSupport.bootstrap("ensurePeriodicSyncTimeSize", $$robo$$android_content_SyncStatusInfo$ensurePeriodicSyncTimeSize(int ), this, n);
    }

    public void maybeResetTodayStats(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("maybeResetTodayStats", $$robo$$android_content_SyncStatusInfo$maybeResetTodayStats(boolean boolean ), this, bl, bl2);
    }

    private static boolean areSameDates(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areSameDates", $$robo$$android_content_SyncStatusInfo$areSameDates(long long ), (long)l, (long)l2);
    }

    static {
        RobolectricInternals.classInitializing(SyncStatusInfo.class);
    }

    public /* synthetic */ SyncStatusInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncStatusInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Stats
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public long totalElapsedTime;
        public int numSyncs;
        public int numSourcePoll;
        public int numSourceOther;
        public int numSourceLocal;
        public int numSourceUser;
        public int numSourcePeriodic;
        public int numSourceFeed;
        public int numFailures;
        public int numCancels;

        private void $$robo$$android_content_SyncStatusInfo_Stats$__constructor__() {
        }

        private final void $$robo$$android_content_SyncStatusInfo_Stats$copyTo(Stats to) {
            to.totalElapsedTime = this.totalElapsedTime;
            to.numSyncs = this.numSyncs;
            to.numSourcePoll = this.numSourcePoll;
            to.numSourceOther = this.numSourceOther;
            to.numSourceLocal = this.numSourceLocal;
            to.numSourceUser = this.numSourceUser;
            to.numSourcePeriodic = this.numSourcePeriodic;
            to.numSourceFeed = this.numSourceFeed;
            to.numFailures = this.numFailures;
            to.numCancels = this.numCancels;
        }

        private final void $$robo$$android_content_SyncStatusInfo_Stats$clear() {
            this.totalElapsedTime = 0L;
            this.numSyncs = 0;
            this.numSourcePoll = 0;
            this.numSourceOther = 0;
            this.numSourceLocal = 0;
            this.numSourceUser = 0;
            this.numSourcePeriodic = 0;
            this.numSourceFeed = 0;
            this.numFailures = 0;
            this.numCancels = 0;
        }

        private final void $$robo$$android_content_SyncStatusInfo_Stats$writeToParcel(Parcel parcel) {
            parcel.writeLong(this.totalElapsedTime);
            parcel.writeInt(this.numSyncs);
            parcel.writeInt(this.numSourcePoll);
            parcel.writeInt(this.numSourceOther);
            parcel.writeInt(this.numSourceLocal);
            parcel.writeInt(this.numSourceUser);
            parcel.writeInt(this.numSourcePeriodic);
            parcel.writeInt(this.numSourceFeed);
            parcel.writeInt(this.numFailures);
            parcel.writeInt(this.numCancels);
        }

        private final void $$robo$$android_content_SyncStatusInfo_Stats$readFromParcel(Parcel parcel) {
            this.totalElapsedTime = parcel.readLong();
            this.numSyncs = parcel.readInt();
            this.numSourcePoll = parcel.readInt();
            this.numSourceOther = parcel.readInt();
            this.numSourceLocal = parcel.readInt();
            this.numSourceUser = parcel.readInt();
            this.numSourcePeriodic = parcel.readInt();
            this.numSourceFeed = parcel.readInt();
            this.numFailures = parcel.readInt();
            this.numCancels = parcel.readInt();
        }

        private void __constructor__() {
            this.$$robo$$android_content_SyncStatusInfo_Stats$__constructor__();
        }

        public Stats() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_SyncStatusInfo_Stats$__constructor__(), this);
        }

        public void copyTo(Stats stats) {
            InvokeDynamicSupport.bootstrap("copyTo", $$robo$$android_content_SyncStatusInfo_Stats$copyTo(android.content.SyncStatusInfo$Stats ), this, stats);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_content_SyncStatusInfo_Stats$clear(), this);
        }

        public void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_SyncStatusInfo_Stats$writeToParcel(android.os.Parcel ), this, parcel);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_content_SyncStatusInfo_Stats$readFromParcel(android.os.Parcel ), this, parcel);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stats)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

