/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BaseParceledListSlice<T>
implements Parcelable {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DEBUG;
    private static int MAX_IPC_SIZE = 65536;
    private List<T> mList;
    private int mInlineCountLimit;

    private void $$robo$$android_content_pm_BaseParceledListSlice$__constructor__(List<T> list) {
        this.mInlineCountLimit = Integer.MAX_VALUE;
        this.mList = list;
    }

    private void $$robo$$android_content_pm_BaseParceledListSlice$__constructor__(Parcel p, ClassLoader loader) {
        int i;
        this.mInlineCountLimit = Integer.MAX_VALUE;
        int N = p.readInt();
        this.mList = new ArrayList<T>(N);
        if (DEBUG) {
            Log.d(TAG, "Retrieving " + N + " items");
        }
        if (N <= 0) {
            return;
        }
        Parcelable.Creator<?> creator = this.readParcelableCreator(p, loader);
        Class<?> listElementClass = null;
        for (i = 0; i < N && p.readInt() != 0; ++i) {
            T parcelable = this.readCreator(creator, p, loader);
            if (listElementClass == null) {
                listElementClass = parcelable.getClass();
            } else {
                BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
            }
            this.mList.add(parcelable);
            if (!DEBUG) continue;
            Log.d(TAG, "Read inline #" + i + ": " + this.mList.get(this.mList.size() - 1));
        }
        if (i >= N) {
            return;
        }
        IBinder retriever = p.readStrongBinder();
        while (i < N) {
            if (DEBUG) {
                Log.d(TAG, "Reading more @" + i + " of " + N + ": retriever=" + retriever);
            }
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            data.writeInt(i);
            try {
                retriever.transact(1, data, reply, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failure retrieving array; only received " + i + " of " + N, e);
                return;
            }
            while (i < N && reply.readInt() != 0) {
                T parcelable = this.readCreator(creator, reply, loader);
                BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                this.mList.add(parcelable);
                if (DEBUG) {
                    Log.d(TAG, "Read extra #" + i + ": " + this.mList.get(this.mList.size() - 1));
                }
                ++i;
            }
            reply.recycle();
            data.recycle();
        }
    }

    private final T $$robo$$android_content_pm_BaseParceledListSlice$readCreator(Parcelable.Creator<?> creator, Parcel p, ClassLoader loader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return classLoaderCreator.createFromParcel(p, loader);
        }
        return (T)creator.createFromParcel(p);
    }

    private static final void $$robo$$android_content_pm_BaseParceledListSlice$verifySameType(Class<?> expected, Class<?> actual) {
        if (!actual.equals(expected)) {
            throw new IllegalArgumentException("Can't unparcel type " + actual.getName() + " in list of type " + expected.getName());
        }
    }

    private final List<T> $$robo$$android_content_pm_BaseParceledListSlice$getList() {
        return this.mList;
    }

    private final void $$robo$$android_content_pm_BaseParceledListSlice$setInlineCountLimit(int maxCount) {
        this.mInlineCountLimit = maxCount;
    }

    private final void $$robo$$android_content_pm_BaseParceledListSlice$writeToParcel(Parcel dest, int flags) {
        int N = this.mList.size();
        int callFlags = flags;
        dest.writeInt(N);
        if (DEBUG) {
            Log.d(TAG, "Writing " + N + " items");
        }
        if (N > 0) {
            int i;
            Class<?> listElementClass = this.mList.get(0).getClass();
            this.writeParcelableCreator(this.mList.get(0), dest);
            for (i = 0; i < N && i < this.mInlineCountLimit && dest.dataSize() < 65536; ++i) {
                dest.writeInt(1);
                T parcelable = this.mList.get(i);
                BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                this.writeElement(parcelable, dest, callFlags);
                if (!DEBUG) continue;
                Log.d(TAG, "Wrote inline #" + i + ": " + this.mList.get(i));
            }
            if (i < N) {
                dest.writeInt(0);
                ShadowedObject retriever = new ShadowedObject(this, N, listElementClass, callFlags){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$N;
                    /* synthetic */ Class val$listElementClass;
                    /* synthetic */ int val$callFlags;
                    /* synthetic */ BaseParceledListSlice this$0;

                    private void $$robo$$android_content_pm_BaseParceledListSlice_1$__constructor__(BaseParceledListSlice this$0, int n, Class clazz, int n2) {
                        this.this$0 = this$0;
                        this.val$N = n;
                        this.val$listElementClass = clazz;
                        this.val$callFlags = n2;
                    }

                    private final boolean $$robo$$android_content_pm_BaseParceledListSlice_1$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                        if (code != 1) {
                            return super.onTransact(code, data, reply, flags);
                        }
                        int i = data.readInt();
                        if (DEBUG) {
                            Log.d(TAG, "Writing more @" + i + " of " + this.val$N);
                        }
                        while (i < this.val$N && reply.dataSize() < 65536) {
                            reply.writeInt(1);
                            Object parcelable = this.this$0.mList.get(i);
                            BaseParceledListSlice.verifySameType(this.val$listElementClass, parcelable.getClass());
                            this.this$0.writeElement(parcelable, reply, this.val$callFlags);
                            if (DEBUG) {
                                Log.d(TAG, "Wrote extra #" + i + ": " + this.this$0.mList.get(i));
                            }
                            ++i;
                        }
                        if (i < this.val$N) {
                            if (DEBUG) {
                                Log.d(TAG, "Breaking @" + i + " of " + this.val$N);
                            }
                            reply.writeInt(0);
                        }
                        return true;
                    }

                    private void __constructor__(BaseParceledListSlice baseParceledListSlice, int n, Class clazz, int n2) {
                        this.$$robo$$android_content_pm_BaseParceledListSlice_1$__constructor__(baseParceledListSlice, n, clazz, n2);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_BaseParceledListSlice_1$__constructor__(android.content.pm.BaseParceledListSlice int java.lang.Class int ), this, baseParceledListSlice, n, clazz, n2);
                    }

                    @Override
                    protected boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
                        return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_content_pm_BaseParceledListSlice_1$onTransact(int android.os.Parcel android.os.Parcel int ), this, n, parcel, parcel2, n2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                if (DEBUG) {
                    Log.d(TAG, "Breaking @" + i + " of " + N + ": retriever=" + retriever);
                }
                dest.writeStrongBinder((IBinder)retriever);
            }
        }
    }

    protected abstract void writeElement(T var1, Parcel var2, int var3);

    protected abstract void writeParcelableCreator(T var1, Parcel var2);

    protected abstract Parcelable.Creator<?> readParcelableCreator(Parcel var1, ClassLoader var2);

    static void __staticInitializer__() {
        TAG = "ParceledListSlice";
        DEBUG = false;
    }

    private void __constructor__(List<T> list) {
        this.$$robo$$android_content_pm_BaseParceledListSlice$__constructor__(list);
    }

    public BaseParceledListSlice(List<T> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_BaseParceledListSlice$__constructor__(java.util.List<T> ), this, list);
    }

    private void __constructor__(Parcel parcel, ClassLoader classLoader) {
        this.$$robo$$android_content_pm_BaseParceledListSlice$__constructor__(parcel, classLoader);
    }

    public BaseParceledListSlice(Parcel parcel, ClassLoader classLoader) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_BaseParceledListSlice$__constructor__(android.os.Parcel java.lang.ClassLoader ), this, parcel, classLoader);
    }

    private T readCreator(Parcelable.Creator<?> creator, Parcel parcel, ClassLoader classLoader) {
        return (T)InvokeDynamicSupport.bootstrap("readCreator", $$robo$$android_content_pm_BaseParceledListSlice$readCreator(android.os.Parcelable$Creator<?> android.os.Parcel java.lang.ClassLoader ), this, creator, parcel, classLoader);
    }

    private static void verifySameType(Class<?> clazz, Class<?> clazz2) {
        InvokeDynamicSupport.bootstrapStatic("verifySameType", $$robo$$android_content_pm_BaseParceledListSlice$verifySameType(java.lang.Class<?> java.lang.Class<?> ), clazz, clazz2);
    }

    public List<T> getList() {
        return InvokeDynamicSupport.bootstrap("getList", $$robo$$android_content_pm_BaseParceledListSlice$getList(), this);
    }

    public void setInlineCountLimit(int n) {
        InvokeDynamicSupport.bootstrap("setInlineCountLimit", $$robo$$android_content_pm_BaseParceledListSlice$setInlineCountLimit(int ), this, n);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_content_pm_BaseParceledListSlice$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(BaseParceledListSlice.class);
    }

    public /* synthetic */ BaseParceledListSlice() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseParceledListSlice)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

