/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.dex;

import android.content.pm.PackageParser;
import android.util.ArrayMap;
import android.util.jar.StrictJarFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DexMetadataHelper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String DEX_METADATA_FILE_EXTENSION = ".dm";

    private void $$robo$$android_content_pm_dex_DexMetadataHelper$__constructor__() {
    }

    private static final boolean $$robo$$android_content_pm_dex_DexMetadataHelper$isDexMetadataFile(File file) {
        return DexMetadataHelper.isDexMetadataPath(file.getName());
    }

    private static final boolean $$robo$$android_content_pm_dex_DexMetadataHelper$isDexMetadataPath(String path) {
        return path.endsWith(".dm");
    }

    private static final long $$robo$$android_content_pm_dex_DexMetadataHelper$getPackageDexMetadataSize(PackageParser.PackageLite pkg) {
        long sizeBytes = 0L;
        Collection<String> dexMetadataList = DexMetadataHelper.getPackageDexMetadata(pkg).values();
        for (String dexMetadata : dexMetadataList) {
            sizeBytes += new File(dexMetadata).length();
        }
        return sizeBytes;
    }

    private static final File $$robo$$android_content_pm_dex_DexMetadataHelper$findDexMetadataForFile(File targetFile) {
        String dexMetadataPath = DexMetadataHelper.buildDexMetadataPathForFile(targetFile);
        File dexMetadataFile = new File(dexMetadataPath);
        return dexMetadataFile.exists() ? dexMetadataFile : null;
    }

    private static final Map<String, String> $$robo$$android_content_pm_dex_DexMetadataHelper$getPackageDexMetadata(PackageParser.Package pkg) {
        return DexMetadataHelper.buildPackageApkToDexMetadataMap(pkg.getAllCodePaths());
    }

    private static final Map<String, String> $$robo$$android_content_pm_dex_DexMetadataHelper$getPackageDexMetadata(PackageParser.PackageLite pkg) {
        return DexMetadataHelper.buildPackageApkToDexMetadataMap(pkg.getAllCodePaths());
    }

    private static final Map<String, String> $$robo$$android_content_pm_dex_DexMetadataHelper$buildPackageApkToDexMetadataMap(List<String> codePaths) {
        ArrayMap<String, String> result = new ArrayMap<String, String>();
        for (int i = codePaths.size() - 1; i >= 0; --i) {
            String codePath = codePaths.get(i);
            String dexMetadataPath = DexMetadataHelper.buildDexMetadataPathForFile(new File(codePath));
            if (!Files.exists(Paths.get(dexMetadataPath, new String[0]), new LinkOption[0])) continue;
            result.put(codePath, dexMetadataPath);
        }
        return result;
    }

    private static final String $$robo$$android_content_pm_dex_DexMetadataHelper$buildDexMetadataPathForApk(String codePath) {
        if (!PackageParser.isApkPath(codePath)) {
            throw new IllegalStateException("Corrupted package. Code path is not an apk " + codePath);
        }
        return codePath.substring(0, codePath.length() - ".apk".length()) + ".dm";
    }

    private static final String $$robo$$android_content_pm_dex_DexMetadataHelper$buildDexMetadataPathForFile(File targetFile) {
        return PackageParser.isApkFile(targetFile) ? DexMetadataHelper.buildDexMetadataPathForApk(targetFile.getPath()) : targetFile.getPath() + ".dm";
    }

    private static final void $$robo$$android_content_pm_dex_DexMetadataHelper$validatePackageDexMetadata(PackageParser.Package pkg) throws PackageParser.PackageParserException {
        Collection<String> apkToDexMetadataList = DexMetadataHelper.getPackageDexMetadata(pkg).values();
        for (String dexMetadata : apkToDexMetadataList) {
            DexMetadataHelper.validateDexMetadataFile(dexMetadata);
        }
    }

    private static final void $$robo$$android_content_pm_dex_DexMetadataHelper$validateDexMetadataFile(String dmaPath) throws PackageParser.PackageParserException {
        StrictJarFile jarFile = null;
        try {
            jarFile = new StrictJarFile(dmaPath, false, false);
        }
        catch (IOException e) {
            throw new PackageParser.PackageParserException(-117, "Error opening " + dmaPath, e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final void $$robo$$android_content_pm_dex_DexMetadataHelper$validateDexPaths(String[] paths) {
        ArrayList<String> apks = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            if (!PackageParser.isApkPath(paths[i])) continue;
            apks.add(paths[i]);
        }
        ArrayList<String> unmatchedDmFiles = new ArrayList<String>();
        for (int i = 0; i < paths.length; ++i) {
            String dmPath = paths[i];
            if (!DexMetadataHelper.isDexMetadataPath(dmPath)) continue;
            boolean valid = false;
            for (int j = apks.size() - 1; j >= 0; --j) {
                if (!dmPath.equals(DexMetadataHelper.buildDexMetadataPathForFile(new File((String)apks.get(j))))) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            unmatchedDmFiles.add(dmPath);
        }
        if (!unmatchedDmFiles.isEmpty()) {
            throw new IllegalStateException("Unmatched .dm files: " + unmatchedDmFiles);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_content_pm_dex_DexMetadataHelper$__constructor__();
    }

    public DexMetadataHelper() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_dex_DexMetadataHelper$__constructor__(), this);
    }

    public static boolean isDexMetadataFile(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDexMetadataFile", $$robo$$android_content_pm_dex_DexMetadataHelper$isDexMetadataFile(java.io.File ), (File)file);
    }

    private static boolean isDexMetadataPath(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDexMetadataPath", $$robo$$android_content_pm_dex_DexMetadataHelper$isDexMetadataPath(java.lang.String ), (String)string2);
    }

    public static long getPackageDexMetadataSize(PackageParser.PackageLite packageLite) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getPackageDexMetadataSize", $$robo$$android_content_pm_dex_DexMetadataHelper$getPackageDexMetadataSize(android.content.pm.PackageParser$PackageLite ), (PackageParser.PackageLite)packageLite);
    }

    public static File findDexMetadataForFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("findDexMetadataForFile", $$robo$$android_content_pm_dex_DexMetadataHelper$findDexMetadataForFile(java.io.File ), (File)file);
    }

    public static Map<String, String> getPackageDexMetadata(PackageParser.Package package_) {
        return InvokeDynamicSupport.bootstrapStatic("getPackageDexMetadata", $$robo$$android_content_pm_dex_DexMetadataHelper$getPackageDexMetadata(android.content.pm.PackageParser$Package ), (PackageParser.Package)package_);
    }

    private static Map<String, String> getPackageDexMetadata(PackageParser.PackageLite packageLite) {
        return InvokeDynamicSupport.bootstrapStatic("getPackageDexMetadata", $$robo$$android_content_pm_dex_DexMetadataHelper$getPackageDexMetadata(android.content.pm.PackageParser$PackageLite ), (PackageParser.PackageLite)packageLite);
    }

    private static Map<String, String> buildPackageApkToDexMetadataMap(List<String> list) {
        return InvokeDynamicSupport.bootstrapStatic("buildPackageApkToDexMetadataMap", $$robo$$android_content_pm_dex_DexMetadataHelper$buildPackageApkToDexMetadataMap(java.util.List<java.lang.String> ), list);
    }

    public static String buildDexMetadataPathForApk(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildDexMetadataPathForApk", $$robo$$android_content_pm_dex_DexMetadataHelper$buildDexMetadataPathForApk(java.lang.String ), (String)string2);
    }

    private static String buildDexMetadataPathForFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("buildDexMetadataPathForFile", $$robo$$android_content_pm_dex_DexMetadataHelper$buildDexMetadataPathForFile(java.io.File ), (File)file);
    }

    public static void validatePackageDexMetadata(PackageParser.Package package_) throws PackageParser.PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("validatePackageDexMetadata", $$robo$$android_content_pm_dex_DexMetadataHelper$validatePackageDexMetadata(android.content.pm.PackageParser$Package ), (PackageParser.Package)package_);
    }

    private static void validateDexMetadataFile(String string2) throws PackageParser.PackageParserException {
        InvokeDynamicSupport.bootstrapStatic("validateDexMetadataFile", $$robo$$android_content_pm_dex_DexMetadataHelper$validateDexMetadataFile(java.lang.String ), (String)string2);
    }

    public static void validateDexPaths(String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("validateDexPaths", $$robo$$android_content_pm_dex_DexMetadataHelper$validateDexPaths(java.lang.String[] ), (String[])stringArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DexMetadataHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

