/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.split;

import android.content.pm.PackageParser;
import android.util.IntArray;
import android.util.SparseArray;
import java.util.Arrays;
import java.util.BitSet;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class SplitDependencyLoader<E extends Exception> {
    public /* synthetic */ Object __robo_data__;
    private SparseArray<int[]> mDependencies;

    private void $$robo$$android_content_pm_split_SplitDependencyLoader$__constructor__(SparseArray<int[]> dependencies) {
        this.mDependencies = dependencies;
    }

    private final void $$robo$$android_content_pm_split_SplitDependencyLoader$loadDependenciesForSplit(int splitIdx) throws E {
        int[] deps;
        if (this.isSplitCached(splitIdx)) {
            return;
        }
        if (splitIdx == 0) {
            int[] configSplitIndices = this.collectConfigSplitIndices(0);
            this.constructSplit(0, configSplitIndices, -1);
            return;
        }
        IntArray linearDependencies = new IntArray();
        linearDependencies.add(splitIdx);
        while ((splitIdx = (deps = this.mDependencies.get(splitIdx)) != null && deps.length > 0 ? deps[0] : -1) >= 0 && !this.isSplitCached(splitIdx)) {
            linearDependencies.add(splitIdx);
        }
        int parentIdx = splitIdx;
        for (int i = linearDependencies.size() - 1; i >= 0; --i) {
            int idx = linearDependencies.get(i);
            int[] configSplitIndices = this.collectConfigSplitIndices(idx);
            this.constructSplit(idx, configSplitIndices, parentIdx);
            parentIdx = idx;
        }
    }

    private final int[] $$robo$$android_content_pm_split_SplitDependencyLoader$collectConfigSplitIndices(int splitIdx) {
        int[] deps = this.mDependencies.get(splitIdx);
        if (deps == null || deps.length <= 1) {
            return EmptyArray.INT;
        }
        return Arrays.copyOfRange(deps, 1, deps.length);
    }

    protected abstract boolean isSplitCached(int var1);

    protected abstract void constructSplit(int var1, int[] var2, int var3) throws E;

    private static final int[] $$robo$$android_content_pm_split_SplitDependencyLoader$append(int[] src, int elem) {
        if (src == null) {
            return new int[]{elem};
        }
        int[] dst = Arrays.copyOf(src, src.length + 1);
        dst[src.length] = elem;
        return dst;
    }

    private static final SparseArray<int[]> $$robo$$android_content_pm_split_SplitDependencyLoader$createDependenciesFromPackage(PackageParser.PackageLite pkg) throws IllegalDependencyException {
        int depIdx;
        int splitIdx;
        SparseArray<int[]> splitDependencies = new SparseArray<int[]>();
        splitDependencies.put(0, new int[]{-1});
        for (splitIdx = 0; splitIdx < pkg.splitNames.length; ++splitIdx) {
            int targetIdx;
            if (!pkg.isFeatureSplits[splitIdx]) continue;
            String splitDependency = pkg.usesSplitNames[splitIdx];
            if (splitDependency != null) {
                depIdx = Arrays.binarySearch(pkg.splitNames, splitDependency);
                if (depIdx < 0) {
                    throw new IllegalDependencyException("Split '" + pkg.splitNames[splitIdx] + "' requires split '" + splitDependency + "', which is missing.", null);
                }
                targetIdx = depIdx + 1;
            } else {
                targetIdx = 0;
            }
            splitDependencies.put(splitIdx + 1, new int[]{targetIdx});
        }
        for (splitIdx = 0; splitIdx < pkg.splitNames.length; ++splitIdx) {
            int targetSplitIdx;
            if (pkg.isFeatureSplits[splitIdx]) continue;
            String configForSplit = pkg.configForSplit[splitIdx];
            if (configForSplit != null) {
                depIdx = Arrays.binarySearch(pkg.splitNames, configForSplit);
                if (depIdx < 0) {
                    throw new IllegalDependencyException("Split '" + pkg.splitNames[splitIdx] + "' targets split '" + configForSplit + "', which is missing.", null);
                }
                if (!pkg.isFeatureSplits[depIdx]) {
                    throw new IllegalDependencyException("Split '" + pkg.splitNames[splitIdx] + "' declares itself as configuration split for a non-feature split '" + pkg.splitNames[depIdx] + "'", null);
                }
                targetSplitIdx = depIdx + 1;
            } else {
                targetSplitIdx = 0;
            }
            splitDependencies.put(targetSplitIdx, SplitDependencyLoader.append(splitDependencies.get(targetSplitIdx), splitIdx + 1));
        }
        BitSet bitset = new BitSet();
        int size = splitDependencies.size();
        for (int i = 0; i < size; ++i) {
            int splitIdx2 = splitDependencies.keyAt(i);
            bitset.clear();
            while (splitIdx2 != -1) {
                if (bitset.get(splitIdx2)) {
                    throw new IllegalDependencyException("Cycle detected in split dependencies.", null);
                }
                bitset.set(splitIdx2);
                int[] deps = splitDependencies.get(splitIdx2);
                splitIdx2 = deps != null ? deps[0] : -1;
            }
        }
        return splitDependencies;
    }

    private void __constructor__(SparseArray<int[]> sparseArray) {
        this.$$robo$$android_content_pm_split_SplitDependencyLoader$__constructor__(sparseArray);
    }

    public SplitDependencyLoader(SparseArray<int[]> sparseArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_split_SplitDependencyLoader$__constructor__(android.util.SparseArray<int[]> ), this, sparseArray);
    }

    protected void loadDependenciesForSplit(int n) throws E {
        InvokeDynamicSupport.bootstrap("loadDependenciesForSplit", $$robo$$android_content_pm_split_SplitDependencyLoader$loadDependenciesForSplit(int ), this, n);
    }

    private int[] collectConfigSplitIndices(int n) {
        return InvokeDynamicSupport.bootstrap("collectConfigSplitIndices", $$robo$$android_content_pm_split_SplitDependencyLoader$collectConfigSplitIndices(int ), this, n);
    }

    private static int[] append(int[] nArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("append", $$robo$$android_content_pm_split_SplitDependencyLoader$append(int[] int ), (int[])nArray, (int)n);
    }

    public static SparseArray<int[]> createDependenciesFromPackage(PackageParser.PackageLite packageLite) throws IllegalDependencyException {
        return InvokeDynamicSupport.bootstrapStatic("createDependenciesFromPackage", $$robo$$android_content_pm_split_SplitDependencyLoader$createDependenciesFromPackage(android.content.pm.PackageParser$PackageLite ), (PackageParser.PackageLite)packageLite);
    }

    public /* synthetic */ SplitDependencyLoader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SplitDependencyLoader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class IllegalDependencyException
    extends Exception
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_content_pm_split_SplitDependencyLoader_IllegalDependencyException$__constructor__(String message) {
        }

        private /* synthetic */ void $$robo$$android_content_pm_split_SplitDependencyLoader_IllegalDependencyException$__constructor__(String x0, 1 x1) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_content_pm_split_SplitDependencyLoader_IllegalDependencyException$__constructor__(string2);
        }

        public IllegalDependencyException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_split_SplitDependencyLoader_IllegalDependencyException$__constructor__(java.lang.String ), this, string2);
        }

        private /* synthetic */ void __constructor__(String string2, 1 var2_2) {
            this.$$robo$$android_content_pm_split_SplitDependencyLoader_IllegalDependencyException$__constructor__(string2, var2_2);
        }

        public /* synthetic */ IllegalDependencyException(String string2, 1 var2_2) {
            this(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_pm_split_SplitDependencyLoader_IllegalDependencyException$__constructor__(java.lang.String android.content.pm.split.SplitDependencyLoader$1 ), this, string2, var2_2);
        }

        public /* synthetic */ IllegalDependencyException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IllegalDependencyException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

