/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ActivityInfo;
import android.content.res.ApkAssets;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AssetManager
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "AssetManager";
    private static boolean DEBUG_REFS = false;
    private static String FRAMEWORK_APK_PATH = "/system/framework/framework-res.apk";
    private static Object sSync;
    private static ApkAssets[] sEmptyApkAssets;
    @GuardedBy(value="sSync")
    static AssetManager sSystem;
    @GuardedBy(value="sSync")
    private static ApkAssets[] sSystemApkAssets;
    @GuardedBy(value="sSync")
    private static ArraySet<ApkAssets> sSystemApkAssetsSet;
    public static int ACCESS_UNKNOWN = 0;
    public static int ACCESS_RANDOM = 1;
    public static int ACCESS_STREAMING = 2;
    public static int ACCESS_BUFFER = 3;
    @GuardedBy(value="this")
    private TypedValue mValue;
    @GuardedBy(value="this")
    private long[] mOffsets;
    @GuardedBy(value="this")
    private long mObject;
    @GuardedBy(value="this")
    private ApkAssets[] mApkAssets;
    @GuardedBy(value="this")
    private boolean mOpen;
    @GuardedBy(value="this")
    private int mNumRefs;
    @GuardedBy(value="this")
    private HashMap<Long, RuntimeException> mRefStacks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_content_res_AssetManager$__constructor__() {
        ApkAssets[] assets;
        this.mValue = new TypedValue();
        this.mOffsets = new long[2];
        this.mOpen = true;
        this.mNumRefs = 1;
        Object object = sSync;
        synchronized (object) {
            AssetManager.createSystemAssetsInZygoteLocked();
            assets = sSystemApkAssets;
        }
        this.mObject = AssetManager.nativeCreate();
        this.setApkAssets(assets, false);
    }

    private void $$robo$$android_content_res_AssetManager$__constructor__(boolean sentinel) {
        this.mValue = new TypedValue();
        this.mOffsets = new long[2];
        this.mOpen = true;
        this.mNumRefs = 1;
        this.mObject = AssetManager.nativeCreate();
    }

    @GuardedBy(value="sSync")
    private static final void $$robo$$android_content_res_AssetManager$createSystemAssetsInZygoteLocked() {
        if (sSystem != null) {
            return;
        }
        AssetManager.nativeVerifySystemIdmaps();
        try {
            ArrayList<ApkAssets> apkAssets = new ArrayList<ApkAssets>();
            apkAssets.add(ApkAssets.loadFromPath("/system/framework/framework-res.apk", true));
            AssetManager.loadStaticRuntimeOverlays(apkAssets);
            sSystemApkAssetsSet = new ArraySet<ApkAssets>(apkAssets);
            sSystemApkAssets = apkAssets.toArray(new ApkAssets[apkAssets.size()]);
            sSystem = new AssetManager(true);
            sSystem.setApkAssets(sSystemApkAssets, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create system AssetManager", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_content_res_AssetManager$loadStaticRuntimeOverlays(ArrayList<ApkAssets> outApkAssets) throws IOException {
        FileInputStream fis;
        try {
            fis = new FileInputStream("/data/resource-cache/overlays.list");
        }
        catch (FileNotFoundException e) {
            Log.i("AssetManager", "no overlays.list file found");
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(fis));
             FileLock flock = fis.getChannel().lock(0L, Long.MAX_VALUE, true);){
            String line;
            while ((line = br.readLine()) != null) {
                String idmapPath = line.split(" ")[1];
                outApkAssets.add(ApkAssets.loadOverlayFromPath(idmapPath, true));
            }
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final AssetManager $$robo$$android_content_res_AssetManager$getSystem() {
        Object object = sSync;
        synchronized (object) {
            AssetManager.createSystemAssetsInZygoteLocked();
            return sSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$close() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (!this.mOpen) {
                return;
            }
            this.mOpen = false;
            this.decRefsLocked(this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$setApkAssets(ApkAssets[] apkAssets, boolean invalidateCaches) {
        Preconditions.checkNotNull(apkAssets, "apkAssets");
        ApkAssets[] newApkAssets = new ApkAssets[sSystemApkAssets.length + apkAssets.length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)sSystemApkAssets, (int)0, (Object)newApkAssets, (int)0, (int)sSystemApkAssets.length);
        int newLength = sSystemApkAssets.length;
        for (ApkAssets apkAsset : apkAssets) {
            if (sSystemApkAssetsSet.contains(apkAsset)) continue;
            newApkAssets[newLength++] = apkAsset;
        }
        if (newLength != newApkAssets.length) {
            newApkAssets = Arrays.copyOf(newApkAssets, newLength);
        }
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            this.mApkAssets = newApkAssets;
            AssetManager.nativeSetApkAssets(this.mObject, this.mApkAssets, invalidateCaches);
            if (invalidateCaches) {
                this.invalidateCachesLocked(-1);
            }
        }
    }

    private final void $$robo$$android_content_res_AssetManager$invalidateCachesLocked(int diff) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ApkAssets[] $$robo$$android_content_res_AssetManager$getApkAssets() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            if (this.mOpen) {
                return this.mApkAssets;
            }
        }
        return sEmptyApkAssets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_res_AssetManager$findCookieForPath(String path) {
        Preconditions.checkNotNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int count = this.mApkAssets.length;
            for (int i = 0; i < count; ++i) {
                if (!path.equals(this.mApkAssets[i].getAssetPath())) continue;
                return i + 1;
            }
        }
        return 0;
    }

    @Deprecated
    private final int $$robo$$android_content_res_AssetManager$addAssetPath(String path) {
        return this.addAssetPathInternal(path, false, false);
    }

    @Deprecated
    private final int $$robo$$android_content_res_AssetManager$addAssetPathAsSharedLibrary(String path) {
        return this.addAssetPathInternal(path, false, true);
    }

    @Deprecated
    private final int $$robo$$android_content_res_AssetManager$addOverlayPath(String path) {
        return this.addAssetPathInternal(path, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_res_AssetManager$addAssetPathInternal(String path, boolean overlay, boolean appAsLib) {
        Preconditions.checkNotNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            ApkAssets assets;
            this.ensureOpenLocked();
            int count = this.mApkAssets.length;
            for (int i = 0; i < count; ++i) {
                if (!this.mApkAssets[i].getAssetPath().equals(path)) continue;
                return i + 1;
            }
            try {
                if (overlay) {
                    String idmapPath = "/data/resource-cache/" + path.substring(1).replace('/', '@') + "@idmap";
                    assets = ApkAssets.loadOverlayFromPath(idmapPath, false);
                } else {
                    assets = ApkAssets.loadFromPath(path, false, appAsLib);
                }
            }
            catch (IOException e) {
                return 0;
            }
            this.mApkAssets = Arrays.copyOf(this.mApkAssets, count + 1);
            this.mApkAssets[count] = assets;
            AssetManager.nativeSetApkAssets(this.mObject, this.mApkAssets, true);
            this.invalidateCachesLocked(-1);
            return count + 1;
        }
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_content_res_AssetManager$ensureValidLocked() {
        if (this.mObject == 0L) {
            throw new RuntimeException("AssetManager has been destroyed");
        }
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_content_res_AssetManager$ensureOpenLocked() {
        if (!this.mOpen) {
            throw new RuntimeException("AssetManager has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_content_res_AssetManager$getResourceValue(int resId, int densityDpi, TypedValue outValue, boolean resolveRefs) {
        Preconditions.checkNotNull(outValue, "outValue");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int cookie = AssetManager.nativeGetResourceValue(this.mObject, resId, (short)densityDpi, outValue, resolveRefs);
            if (cookie <= 0) {
                return false;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                outValue.string = this.mApkAssets[cookie - 1].getStringFromPool(outValue.data);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence $$robo$$android_content_res_AssetManager$getResourceText(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            TypedValue outValue = this.mValue;
            if (this.getResourceValue(resId, 0, outValue, true)) {
                return outValue.coerceToString();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence $$robo$$android_content_res_AssetManager$getResourceBagText(int resId, int bagEntryId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            TypedValue outValue = this.mValue;
            int cookie = AssetManager.nativeGetResourceBagValue(this.mObject, resId, bagEntryId, outValue);
            if (cookie <= 0) {
                return null;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                return this.mApkAssets[cookie - 1].getStringFromPool(outValue.data);
            }
            return outValue.coerceToString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_res_AssetManager$getResourceArraySize(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceArraySize(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_res_AssetManager$getResourceArray(int resId, int[] outData) {
        Preconditions.checkNotNull(outData, "outData");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceArray(this.mObject, resId, outData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$android_content_res_AssetManager$getResourceStringArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceStringArray(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CharSequence[] $$robo$$android_content_res_AssetManager$getResourceTextArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int[] rawInfoArray = AssetManager.nativeGetResourceStringArrayInfo(this.mObject, resId);
            if (rawInfoArray == null) {
                return null;
            }
            int rawInfoArrayLen = rawInfoArray.length;
            int infoArrayLen = rawInfoArrayLen / 2;
            CharSequence[] retArray = new CharSequence[infoArrayLen];
            int i = 0;
            int j = 0;
            while (i < rawInfoArrayLen) {
                int cookie = rawInfoArray[i];
                int index = rawInfoArray[i + 1];
                retArray[j] = index >= 0 && cookie > 0 ? this.mApkAssets[cookie - 1].getStringFromPool(index) : null;
                i += 2;
                ++j;
            }
            return retArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_content_res_AssetManager$getResourceIntArray(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceIntArray(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_content_res_AssetManager$getStyleAttributes(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetStyleAttributes(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_content_res_AssetManager$getThemeValue(long theme, int resId, TypedValue outValue, boolean resolveRefs) {
        Preconditions.checkNotNull(outValue, "outValue");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            int cookie = AssetManager.nativeThemeGetAttributeValue(this.mObject, theme, resId, outValue, resolveRefs);
            if (cookie <= 0) {
                return false;
            }
            outValue.changingConfigurations = ActivityInfo.activityInfoConfigNativeToJava(outValue.changingConfigurations);
            if (outValue.type == 3) {
                outValue.string = this.mApkAssets[cookie - 1].getStringFromPool(outValue.data);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$dumpTheme(long theme, int priority, String tag, String prefix) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeThemeDump(this.mObject, theme, priority, tag, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_content_res_AssetManager$getResourceName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_content_res_AssetManager$getResourcePackageName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourcePackageName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_content_res_AssetManager$getResourceTypeName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceTypeName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_content_res_AssetManager$getResourceEntryName(int resId) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceEntryName(this.mObject, resId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_content_res_AssetManager$getResourceIdentifier(String name, String defType, String defPackage) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetResourceIdentifier(this.mObject, name, defType, defPackage);
        }
    }

    private final CharSequence $$robo$$android_content_res_AssetManager$getPooledStringForCookie(int cookie, int id2) {
        return this.getApkAssets()[cookie - 1].getStringFromPool(id2);
    }

    private final InputStream $$robo$$android_content_res_AssetManager$open(String fileName) throws IOException {
        return this.open(fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream $$robo$$android_content_res_AssetManager$open(String fileName, int accessMode) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long asset = AssetManager.nativeOpenAsset(this.mObject, fileName, accessMode);
            if (asset == 0L) {
                throw new FileNotFoundException("Asset file: " + fileName);
            }
            AssetInputStream assetInputStream = new AssetInputStream(this, asset, null);
            this.incRefsLocked(assetInputStream.hashCode());
            return assetInputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AssetFileDescriptor $$robo$$android_content_res_AssetManager$openFd(String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            ParcelFileDescriptor pfd = AssetManager.nativeOpenAssetFd(this.mObject, fileName, this.mOffsets);
            if (pfd == null) {
                throw new FileNotFoundException("Asset file: " + fileName);
            }
            return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$android_content_res_AssetManager$list(String path) throws IOException {
        Preconditions.checkNotNull(path, "path");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeList(this.mObject, path);
        }
    }

    private final InputStream $$robo$$android_content_res_AssetManager$openNonAsset(String fileName) throws IOException {
        return this.openNonAsset(0, fileName, 2);
    }

    private final InputStream $$robo$$android_content_res_AssetManager$openNonAsset(String fileName, int accessMode) throws IOException {
        return this.openNonAsset(0, fileName, accessMode);
    }

    private final InputStream $$robo$$android_content_res_AssetManager$openNonAsset(int cookie, String fileName) throws IOException {
        return this.openNonAsset(cookie, fileName, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InputStream $$robo$$android_content_res_AssetManager$openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long asset = AssetManager.nativeOpenNonAsset(this.mObject, cookie, fileName, accessMode);
            if (asset == 0L) {
                throw new FileNotFoundException("Asset absolute file: " + fileName);
            }
            AssetInputStream assetInputStream = new AssetInputStream(this, asset, null);
            this.incRefsLocked(assetInputStream.hashCode());
            return assetInputStream;
        }
    }

    private final AssetFileDescriptor $$robo$$android_content_res_AssetManager$openNonAssetFd(String fileName) throws IOException {
        return this.openNonAssetFd(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AssetFileDescriptor $$robo$$android_content_res_AssetManager$openNonAssetFd(int cookie, String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            ParcelFileDescriptor pfd = AssetManager.nativeOpenNonAssetFd(this.mObject, cookie, fileName, this.mOffsets);
            if (pfd == null) {
                throw new FileNotFoundException("Asset absolute file: " + fileName);
            }
            return new AssetFileDescriptor(pfd, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    private final XmlResourceParser $$robo$$android_content_res_AssetManager$openXmlResourceParser(String fileName) throws IOException {
        return this.openXmlResourceParser(0, fileName);
    }

    private final XmlResourceParser $$robo$$android_content_res_AssetManager$openXmlResourceParser(int cookie, String fileName) throws IOException {
        try (XmlBlock block = this.openXmlBlockAsset(cookie, fileName);){
            XmlResourceParser parser = block.newParser();
            if (parser == null) {
                throw new AssertionError((Object)"block.newParser() returned a null parser");
            }
            XmlResourceParser xmlResourceParser = parser;
            return xmlResourceParser;
        }
    }

    private final XmlBlock $$robo$$android_content_res_AssetManager$openXmlBlockAsset(String fileName) throws IOException {
        return this.openXmlBlockAsset(0, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XmlBlock $$robo$$android_content_res_AssetManager$openXmlBlockAsset(int cookie, String fileName) throws IOException {
        Preconditions.checkNotNull(fileName, "fileName");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureOpenLocked();
            long xmlBlock = AssetManager.nativeOpenXmlAsset(this.mObject, cookie, fileName);
            if (xmlBlock == 0L) {
                throw new FileNotFoundException("Asset XML file: " + fileName);
            }
            XmlBlock block = new XmlBlock(this, xmlBlock);
            this.incRefsLocked(block.hashCode());
            return block;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$xmlBlockGone(int id2) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.decRefsLocked(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$applyStyle(long themePtr, int defStyleAttr, int defStyleRes, XmlBlock.Parser parser, int[] inAttrs, long outValuesAddress, long outIndicesAddress) {
        Preconditions.checkNotNull(inAttrs, "inAttrs");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeApplyStyle(this.mObject, themePtr, defStyleAttr, defStyleRes, parser != null ? parser.mParseState : 0L, inAttrs, outValuesAddress, outIndicesAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_content_res_AssetManager$resolveAttrs(long themePtr, int defStyleAttr, int defStyleRes, int[] inValues, int[] inAttrs, int[] outValues, int[] outIndices) {
        Preconditions.checkNotNull(inAttrs, "inAttrs");
        Preconditions.checkNotNull(outValues, "outValues");
        Preconditions.checkNotNull(outIndices, "outIndices");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeResolveAttrs(this.mObject, themePtr, defStyleAttr, defStyleRes, inValues, inAttrs, outValues, outIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_content_res_AssetManager$retrieveAttributes(XmlBlock.Parser parser, int[] inAttrs, int[] outValues, int[] outIndices) {
        Preconditions.checkNotNull(parser, "parser");
        Preconditions.checkNotNull(inAttrs, "inAttrs");
        Preconditions.checkNotNull(outValues, "outValues");
        Preconditions.checkNotNull(outIndices, "outIndices");
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeRetrieveAttributes(this.mObject, parser.mParseState, inAttrs, outValues, outIndices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_content_res_AssetManager$createTheme() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            long themePtr = AssetManager.nativeThemeCreate(this.mObject);
            this.incRefsLocked(themePtr);
            return themePtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$releaseTheme(long themePtr) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            AssetManager.nativeThemeDestroy(themePtr);
            this.decRefsLocked(themePtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$applyStyleToTheme(long themePtr, int resId, boolean force) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeThemeApplyStyle(this.mObject, themePtr, resId, force);
        }
    }

    private final void $$robo$$android_content_res_AssetManager$finalize() throws Throwable {
        if (this.mObject != 0L) {
            AssetManager.nativeDestroy(this.mObject);
        }
    }

    private final boolean $$robo$$android_content_res_AssetManager$isUpToDate() {
        for (ApkAssets apkAssets : this.getApkAssets()) {
            if (apkAssets.isUpToDate()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$android_content_res_AssetManager$getLocales() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLocales(this.mObject, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$android_content_res_AssetManager$getNonSystemLocales() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetLocales(this.mObject, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Configuration[] $$robo$$android_content_res_AssetManager$getSizeConfigurations() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetSizeConfigurations(this.mObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_content_res_AssetManager$setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int colorMode, int majorVersion) {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            AssetManager.nativeSetConfiguration(this.mObject, mcc, mnc, locale, orientation, touchscreen, density, keyboard, keyboardHidden, navigation, screenWidth, screenHeight, smallestScreenWidthDp, screenWidthDp, screenHeightDp, screenLayout, uiMode, colorMode, majorVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SparseArray<String> $$robo$$android_content_res_AssetManager$getAssignedPackageIdentifiers() {
        AssetManager assetManager = this;
        synchronized (assetManager) {
            this.ensureValidLocked();
            return AssetManager.nativeGetAssignedPackageIdentifiers(this.mObject);
        }
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_content_res_AssetManager$incRefsLocked(long id2) {
        ++this.mNumRefs;
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_content_res_AssetManager$decRefsLocked(long id2) {
        --this.mNumRefs;
        if (this.mNumRefs == 0 && this.mObject != 0L) {
            AssetManager.nativeDestroy(this.mObject);
            this.mObject = 0L;
            this.mApkAssets = sEmptyApkAssets;
        }
    }

    private static final long $$robo$$android_content_res_AssetManager$nativeCreate() {
        return 0L;
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeDestroy(long l) {
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeSetApkAssets(long l, ApkAssets[] apkAssetsArray, boolean bl) {
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeSetConfiguration(long l, int n, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
    }

    private static final SparseArray<String> $$robo$$android_content_res_AssetManager$nativeGetAssignedPackageIdentifiers(long l) {
        return null;
    }

    private static final String[] $$robo$$android_content_res_AssetManager$nativeList(long l, String string2) throws IOException {
        return null;
    }

    private static final long $$robo$$android_content_res_AssetManager$nativeOpenAsset(long l, String string2, int n) {
        return 0L;
    }

    private static final ParcelFileDescriptor $$robo$$android_content_res_AssetManager$nativeOpenAssetFd(long l, String string2, long[] lArray) throws IOException {
        return null;
    }

    private static final long $$robo$$android_content_res_AssetManager$nativeOpenNonAsset(long l, int n, String string2, int n2) {
        return 0L;
    }

    private static final ParcelFileDescriptor $$robo$$android_content_res_AssetManager$nativeOpenNonAssetFd(long l, int n, String string2, long[] lArray) throws IOException {
        return null;
    }

    private static final long $$robo$$android_content_res_AssetManager$nativeOpenXmlAsset(long l, int n, String string2) {
        return 0L;
    }

    private static final int $$robo$$android_content_res_AssetManager$nativeGetResourceValue(long l, int n, short s, TypedValue typedValue, boolean bl) {
        return 0;
    }

    private static final int $$robo$$android_content_res_AssetManager$nativeGetResourceBagValue(long l, int n, int n2, TypedValue typedValue) {
        return 0;
    }

    private static final int[] $$robo$$android_content_res_AssetManager$nativeGetStyleAttributes(long l, int n) {
        return null;
    }

    private static final String[] $$robo$$android_content_res_AssetManager$nativeGetResourceStringArray(long l, int n) {
        return null;
    }

    private static final int[] $$robo$$android_content_res_AssetManager$nativeGetResourceStringArrayInfo(long l, int n) {
        return null;
    }

    private static final int[] $$robo$$android_content_res_AssetManager$nativeGetResourceIntArray(long l, int n) {
        return null;
    }

    private static final int $$robo$$android_content_res_AssetManager$nativeGetResourceArraySize(long l, int n) {
        return 0;
    }

    private static final int $$robo$$android_content_res_AssetManager$nativeGetResourceArray(long l, int n, int[] nArray) {
        return 0;
    }

    private static final int $$robo$$android_content_res_AssetManager$nativeGetResourceIdentifier(long l, String string2, String string3, String string4) {
        return 0;
    }

    private static final String $$robo$$android_content_res_AssetManager$nativeGetResourceName(long l, int n) {
        return null;
    }

    private static final String $$robo$$android_content_res_AssetManager$nativeGetResourcePackageName(long l, int n) {
        return null;
    }

    private static final String $$robo$$android_content_res_AssetManager$nativeGetResourceTypeName(long l, int n) {
        return null;
    }

    private static final String $$robo$$android_content_res_AssetManager$nativeGetResourceEntryName(long l, int n) {
        return null;
    }

    private static final String[] $$robo$$android_content_res_AssetManager$nativeGetLocales(long l, boolean bl) {
        return null;
    }

    private static final Configuration[] $$robo$$android_content_res_AssetManager$nativeGetSizeConfigurations(long l) {
        return null;
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeApplyStyle(long l, long l2, int n, int n2, long l3, int[] nArray, long l4, long l5) {
    }

    private static final boolean $$robo$$android_content_res_AssetManager$nativeResolveAttrs(long l, long l2, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        return false;
    }

    private static final boolean $$robo$$android_content_res_AssetManager$nativeRetrieveAttributes(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        return false;
    }

    private static final long $$robo$$android_content_res_AssetManager$nativeThemeCreate(long l) {
        return 0L;
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeThemeDestroy(long l) {
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeThemeApplyStyle(long l, long l2, int n, boolean bl) {
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeThemeCopy(long l, long l2) {
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeThemeClear(long l) {
    }

    private static final int $$robo$$android_content_res_AssetManager$nativeThemeGetAttributeValue(long l, long l2, int n, TypedValue typedValue, boolean bl) {
        return 0;
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeThemeDump(long l, long l2, int n, String string2, String string3) {
    }

    private static final int $$robo$$android_content_res_AssetManager$nativeThemeGetChangingConfigurations(long l) {
        return 0;
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeAssetDestroy(long l) {
    }

    private static final int $$robo$$android_content_res_AssetManager$nativeAssetReadChar(long l) {
        return 0;
    }

    private static final int $$robo$$android_content_res_AssetManager$nativeAssetRead(long l, byte[] byArray, int n, int n2) {
        return 0;
    }

    private static final long $$robo$$android_content_res_AssetManager$nativeAssetSeek(long l, long l2, int n) {
        return 0L;
    }

    private static final long $$robo$$android_content_res_AssetManager$nativeAssetGetLength(long l) {
        return 0L;
    }

    private static final long $$robo$$android_content_res_AssetManager$nativeAssetGetRemainingLength(long l) {
        return 0L;
    }

    private static final void $$robo$$android_content_res_AssetManager$nativeVerifySystemIdmaps() {
    }

    private static final int $$robo$$android_content_res_AssetManager$getGlobalAssetCount() {
        return 0;
    }

    private static final String $$robo$$android_content_res_AssetManager$getAssetAllocations() {
        return null;
    }

    private static final int $$robo$$android_content_res_AssetManager$getGlobalAssetManagerCount() {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_content_res_AssetManager$__constructor__(boolean x0, 1 x1) {
    }

    static /* synthetic */ ApkAssets[] access$102(AssetManager x0, ApkAssets[] x1) {
        x0.mApkAssets = x1;
        return x1;
    }

    static void __staticInitializer__() {
        sSync = new Object();
        sEmptyApkAssets = new ApkAssets[0];
        sSystem = null;
        sSystemApkAssets = new ApkAssets[0];
    }

    private void __constructor__() {
        this.$$robo$$android_content_res_AssetManager$__constructor__();
    }

    public AssetManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetManager$__constructor__(), this);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_content_res_AssetManager$__constructor__(bl);
    }

    public AssetManager(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetManager$__constructor__(boolean ), this, bl);
    }

    private static void createSystemAssetsInZygoteLocked() {
        InvokeDynamicSupport.bootstrapStatic("createSystemAssetsInZygoteLocked", $$robo$$android_content_res_AssetManager$createSystemAssetsInZygoteLocked());
    }

    private static void loadStaticRuntimeOverlays(ArrayList<ApkAssets> arrayList) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("loadStaticRuntimeOverlays", $$robo$$android_content_res_AssetManager$loadStaticRuntimeOverlays(java.util.ArrayList<android.content.res.ApkAssets> ), arrayList);
    }

    public static AssetManager getSystem() {
        return InvokeDynamicSupport.bootstrapStatic("getSystem", $$robo$$android_content_res_AssetManager$getSystem());
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_res_AssetManager$close(), this);
    }

    public void setApkAssets(ApkAssets[] apkAssetsArray, boolean bl) {
        InvokeDynamicSupport.bootstrap("setApkAssets", $$robo$$android_content_res_AssetManager$setApkAssets(android.content.res.ApkAssets[] boolean ), this, apkAssetsArray, bl);
    }

    private void invalidateCachesLocked(int n) {
        InvokeDynamicSupport.bootstrap("invalidateCachesLocked", $$robo$$android_content_res_AssetManager$invalidateCachesLocked(int ), this, n);
    }

    public ApkAssets[] getApkAssets() {
        return InvokeDynamicSupport.bootstrap("getApkAssets", $$robo$$android_content_res_AssetManager$getApkAssets(), this);
    }

    public int findCookieForPath(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("findCookieForPath", $$robo$$android_content_res_AssetManager$findCookieForPath(java.lang.String ), this, string2);
    }

    @Deprecated
    public int addAssetPath(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("addAssetPath", $$robo$$android_content_res_AssetManager$addAssetPath(java.lang.String ), this, string2);
    }

    @Deprecated
    public int addAssetPathAsSharedLibrary(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("addAssetPathAsSharedLibrary", $$robo$$android_content_res_AssetManager$addAssetPathAsSharedLibrary(java.lang.String ), this, string2);
    }

    @Deprecated
    public int addOverlayPath(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("addOverlayPath", $$robo$$android_content_res_AssetManager$addOverlayPath(java.lang.String ), this, string2);
    }

    private int addAssetPathInternal(String string2, boolean bl, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("addAssetPathInternal", $$robo$$android_content_res_AssetManager$addAssetPathInternal(java.lang.String boolean boolean ), this, string2, bl, bl2);
    }

    private void ensureValidLocked() {
        InvokeDynamicSupport.bootstrap("ensureValidLocked", $$robo$$android_content_res_AssetManager$ensureValidLocked(), this);
    }

    private void ensureOpenLocked() {
        InvokeDynamicSupport.bootstrap("ensureOpenLocked", $$robo$$android_content_res_AssetManager$ensureOpenLocked(), this);
    }

    boolean getResourceValue(int n, int n2, TypedValue typedValue, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getResourceValue", $$robo$$android_content_res_AssetManager$getResourceValue(int int android.util.TypedValue boolean ), this, n, n2, typedValue, bl);
    }

    CharSequence getResourceText(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceText", $$robo$$android_content_res_AssetManager$getResourceText(int ), this, n);
    }

    CharSequence getResourceBagText(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getResourceBagText", $$robo$$android_content_res_AssetManager$getResourceBagText(int int ), this, n, n2);
    }

    int getResourceArraySize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getResourceArraySize", $$robo$$android_content_res_AssetManager$getResourceArraySize(int ), this, n);
    }

    int getResourceArray(int n, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrap("getResourceArray", $$robo$$android_content_res_AssetManager$getResourceArray(int int[] ), this, n, nArray);
    }

    String[] getResourceStringArray(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceStringArray", $$robo$$android_content_res_AssetManager$getResourceStringArray(int ), this, n);
    }

    CharSequence[] getResourceTextArray(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceTextArray", $$robo$$android_content_res_AssetManager$getResourceTextArray(int ), this, n);
    }

    int[] getResourceIntArray(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceIntArray", $$robo$$android_content_res_AssetManager$getResourceIntArray(int ), this, n);
    }

    int[] getStyleAttributes(int n) {
        return InvokeDynamicSupport.bootstrap("getStyleAttributes", $$robo$$android_content_res_AssetManager$getStyleAttributes(int ), this, n);
    }

    boolean getThemeValue(long l, int n, TypedValue typedValue, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getThemeValue", $$robo$$android_content_res_AssetManager$getThemeValue(long int android.util.TypedValue boolean ), this, l, n, typedValue, bl);
    }

    void dumpTheme(long l, int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("dumpTheme", $$robo$$android_content_res_AssetManager$dumpTheme(long int java.lang.String java.lang.String ), this, l, n, string2, string3);
    }

    String getResourceName(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceName", $$robo$$android_content_res_AssetManager$getResourceName(int ), this, n);
    }

    String getResourcePackageName(int n) {
        return InvokeDynamicSupport.bootstrap("getResourcePackageName", $$robo$$android_content_res_AssetManager$getResourcePackageName(int ), this, n);
    }

    String getResourceTypeName(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceTypeName", $$robo$$android_content_res_AssetManager$getResourceTypeName(int ), this, n);
    }

    String getResourceEntryName(int n) {
        return InvokeDynamicSupport.bootstrap("getResourceEntryName", $$robo$$android_content_res_AssetManager$getResourceEntryName(int ), this, n);
    }

    int getResourceIdentifier(String string2, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrap("getResourceIdentifier", $$robo$$android_content_res_AssetManager$getResourceIdentifier(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    CharSequence getPooledStringForCookie(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getPooledStringForCookie", $$robo$$android_content_res_AssetManager$getPooledStringForCookie(int int ), this, n, n2);
    }

    public InputStream open(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("open", $$robo$$android_content_res_AssetManager$open(java.lang.String ), this, string2);
    }

    public InputStream open(String string2, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("open", $$robo$$android_content_res_AssetManager$open(java.lang.String int ), this, string2, n);
    }

    public AssetFileDescriptor openFd(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openFd", $$robo$$android_content_res_AssetManager$openFd(java.lang.String ), this, string2);
    }

    public String[] list(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("list", $$robo$$android_content_res_AssetManager$list(java.lang.String ), this, string2);
    }

    public InputStream openNonAsset(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAsset", $$robo$$android_content_res_AssetManager$openNonAsset(java.lang.String ), this, string2);
    }

    public InputStream openNonAsset(String string2, int n) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAsset", $$robo$$android_content_res_AssetManager$openNonAsset(java.lang.String int ), this, string2, n);
    }

    public InputStream openNonAsset(int n, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAsset", $$robo$$android_content_res_AssetManager$openNonAsset(int java.lang.String ), this, n, string2);
    }

    public InputStream openNonAsset(int n, String string2, int n2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAsset", $$robo$$android_content_res_AssetManager$openNonAsset(int java.lang.String int ), this, n, string2, n2);
    }

    public AssetFileDescriptor openNonAssetFd(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAssetFd", $$robo$$android_content_res_AssetManager$openNonAssetFd(java.lang.String ), this, string2);
    }

    public AssetFileDescriptor openNonAssetFd(int n, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openNonAssetFd", $$robo$$android_content_res_AssetManager$openNonAssetFd(int java.lang.String ), this, n, string2);
    }

    public XmlResourceParser openXmlResourceParser(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openXmlResourceParser", $$robo$$android_content_res_AssetManager$openXmlResourceParser(java.lang.String ), this, string2);
    }

    public XmlResourceParser openXmlResourceParser(int n, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openXmlResourceParser", $$robo$$android_content_res_AssetManager$openXmlResourceParser(int java.lang.String ), this, n, string2);
    }

    XmlBlock openXmlBlockAsset(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openXmlBlockAsset", $$robo$$android_content_res_AssetManager$openXmlBlockAsset(java.lang.String ), this, string2);
    }

    XmlBlock openXmlBlockAsset(int n, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("openXmlBlockAsset", $$robo$$android_content_res_AssetManager$openXmlBlockAsset(int java.lang.String ), this, n, string2);
    }

    void xmlBlockGone(int n) {
        InvokeDynamicSupport.bootstrap("xmlBlockGone", $$robo$$android_content_res_AssetManager$xmlBlockGone(int ), this, n);
    }

    void applyStyle(long l, int n, int n2, XmlBlock.Parser parser, int[] nArray, long l2, long l3) {
        InvokeDynamicSupport.bootstrap("applyStyle", $$robo$$android_content_res_AssetManager$applyStyle(long int int android.content.res.XmlBlock$Parser int[] long long ), this, l, n, n2, parser, nArray, l2, l3);
    }

    boolean resolveAttrs(long l, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        return (boolean)InvokeDynamicSupport.bootstrap("resolveAttrs", $$robo$$android_content_res_AssetManager$resolveAttrs(long int int int[] int[] int[] int[] ), this, l, n, n2, nArray, nArray2, nArray3, nArray4);
    }

    boolean retrieveAttributes(XmlBlock.Parser parser, int[] nArray, int[] nArray2, int[] nArray3) {
        return (boolean)InvokeDynamicSupport.bootstrap("retrieveAttributes", $$robo$$android_content_res_AssetManager$retrieveAttributes(android.content.res.XmlBlock$Parser int[] int[] int[] ), this, parser, nArray, nArray2, nArray3);
    }

    long createTheme() {
        return (long)InvokeDynamicSupport.bootstrap("createTheme", $$robo$$android_content_res_AssetManager$createTheme(), this);
    }

    void releaseTheme(long l) {
        InvokeDynamicSupport.bootstrap("releaseTheme", $$robo$$android_content_res_AssetManager$releaseTheme(long ), this, l);
    }

    void applyStyleToTheme(long l, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("applyStyleToTheme", $$robo$$android_content_res_AssetManager$applyStyleToTheme(long int boolean ), this, l, n, bl);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_res_AssetManager$finalize(), this);
    }

    public boolean isUpToDate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUpToDate", $$robo$$android_content_res_AssetManager$isUpToDate(), this);
    }

    public String[] getLocales() {
        return InvokeDynamicSupport.bootstrap("getLocales", $$robo$$android_content_res_AssetManager$getLocales(), this);
    }

    public String[] getNonSystemLocales() {
        return InvokeDynamicSupport.bootstrap("getNonSystemLocales", $$robo$$android_content_res_AssetManager$getNonSystemLocales(), this);
    }

    Configuration[] getSizeConfigurations() {
        return InvokeDynamicSupport.bootstrap("getSizeConfigurations", $$robo$$android_content_res_AssetManager$getSizeConfigurations(), this);
    }

    public void setConfiguration(int n, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        InvokeDynamicSupport.bootstrap("setConfiguration", $$robo$$android_content_res_AssetManager$setConfiguration(int int java.lang.String int int int int int int int int int int int int int int int ), this, n, n2, string2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17);
    }

    public SparseArray<String> getAssignedPackageIdentifiers() {
        return InvokeDynamicSupport.bootstrap("getAssignedPackageIdentifiers", $$robo$$android_content_res_AssetManager$getAssignedPackageIdentifiers(), this);
    }

    private void incRefsLocked(long l) {
        InvokeDynamicSupport.bootstrap("incRefsLocked", $$robo$$android_content_res_AssetManager$incRefsLocked(long ), this, l);
    }

    private void decRefsLocked(long l) {
        InvokeDynamicSupport.bootstrap("decRefsLocked", $$robo$$android_content_res_AssetManager$decRefsLocked(long ), this, l);
    }

    private static long nativeCreate() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreate", $$robo$$android_content_res_AssetManager$nativeCreate());
    }

    private static void nativeDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDestroy", $$robo$$android_content_res_AssetManager$nativeDestroy(long ), (long)l);
    }

    private static void nativeSetApkAssets(long l, ApkAssets[] apkAssetsArray, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetApkAssets", $$robo$$android_content_res_AssetManager$nativeSetApkAssets(long android.content.res.ApkAssets[] boolean ), (long)l, (ApkAssets[])apkAssetsArray, (boolean)bl);
    }

    private static void nativeSetConfiguration(long l, int n, int n2, String string2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetConfiguration", $$robo$$android_content_res_AssetManager$nativeSetConfiguration(long int int java.lang.String int int int int int int int int int int int int int int int ), (long)l, (int)n, (int)n2, (String)string2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10, (int)n11, (int)n12, (int)n13, (int)n14, (int)n15, (int)n16, (int)n17);
    }

    private static SparseArray<String> nativeGetAssignedPackageIdentifiers(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetAssignedPackageIdentifiers", $$robo$$android_content_res_AssetManager$nativeGetAssignedPackageIdentifiers(long ), (long)l);
    }

    private static String[] nativeList(long l, String string2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("nativeList", $$robo$$android_content_res_AssetManager$nativeList(long java.lang.String ), (long)l, (String)string2);
    }

    private static long nativeOpenAsset(long l, String string2, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpenAsset", $$robo$$android_content_res_AssetManager$nativeOpenAsset(long java.lang.String int ), (long)l, (String)string2, (int)n);
    }

    private static ParcelFileDescriptor nativeOpenAssetFd(long l, String string2, long[] lArray) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("nativeOpenAssetFd", $$robo$$android_content_res_AssetManager$nativeOpenAssetFd(long java.lang.String long[] ), (long)l, (String)string2, (long[])lArray);
    }

    private static long nativeOpenNonAsset(long l, int n, String string2, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpenNonAsset", $$robo$$android_content_res_AssetManager$nativeOpenNonAsset(long int java.lang.String int ), (long)l, (int)n, (String)string2, (int)n2);
    }

    private static ParcelFileDescriptor nativeOpenNonAssetFd(long l, int n, String string2, long[] lArray) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("nativeOpenNonAssetFd", $$robo$$android_content_res_AssetManager$nativeOpenNonAssetFd(long int java.lang.String long[] ), (long)l, (int)n, (String)string2, (long[])lArray);
    }

    private static long nativeOpenXmlAsset(long l, int n, String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpenXmlAsset", $$robo$$android_content_res_AssetManager$nativeOpenXmlAsset(long int java.lang.String ), (long)l, (int)n, (String)string2);
    }

    private static int nativeGetResourceValue(long l, int n, short s, TypedValue typedValue, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetResourceValue", $$robo$$android_content_res_AssetManager$nativeGetResourceValue(long int short android.util.TypedValue boolean ), (long)l, (int)n, (short)s, (TypedValue)typedValue, (boolean)bl);
    }

    private static int nativeGetResourceBagValue(long l, int n, int n2, TypedValue typedValue) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetResourceBagValue", $$robo$$android_content_res_AssetManager$nativeGetResourceBagValue(long int int android.util.TypedValue ), (long)l, (int)n, (int)n2, (TypedValue)typedValue);
    }

    private static int[] nativeGetStyleAttributes(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetStyleAttributes", $$robo$$android_content_res_AssetManager$nativeGetStyleAttributes(long int ), (long)l, (int)n);
    }

    private static String[] nativeGetResourceStringArray(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetResourceStringArray", $$robo$$android_content_res_AssetManager$nativeGetResourceStringArray(long int ), (long)l, (int)n);
    }

    private static int[] nativeGetResourceStringArrayInfo(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetResourceStringArrayInfo", $$robo$$android_content_res_AssetManager$nativeGetResourceStringArrayInfo(long int ), (long)l, (int)n);
    }

    private static int[] nativeGetResourceIntArray(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetResourceIntArray", $$robo$$android_content_res_AssetManager$nativeGetResourceIntArray(long int ), (long)l, (int)n);
    }

    private static int nativeGetResourceArraySize(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetResourceArraySize", $$robo$$android_content_res_AssetManager$nativeGetResourceArraySize(long int ), (long)l, (int)n);
    }

    private static int nativeGetResourceArray(long l, int n, int[] nArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetResourceArray", $$robo$$android_content_res_AssetManager$nativeGetResourceArray(long int int[] ), (long)l, (int)n, (int[])nArray);
    }

    private static int nativeGetResourceIdentifier(long l, String string2, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetResourceIdentifier", $$robo$$android_content_res_AssetManager$nativeGetResourceIdentifier(long java.lang.String java.lang.String java.lang.String ), (long)l, (String)string2, (String)string3, (String)string4);
    }

    private static String nativeGetResourceName(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetResourceName", $$robo$$android_content_res_AssetManager$nativeGetResourceName(long int ), (long)l, (int)n);
    }

    private static String nativeGetResourcePackageName(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetResourcePackageName", $$robo$$android_content_res_AssetManager$nativeGetResourcePackageName(long int ), (long)l, (int)n);
    }

    private static String nativeGetResourceTypeName(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetResourceTypeName", $$robo$$android_content_res_AssetManager$nativeGetResourceTypeName(long int ), (long)l, (int)n);
    }

    private static String nativeGetResourceEntryName(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetResourceEntryName", $$robo$$android_content_res_AssetManager$nativeGetResourceEntryName(long int ), (long)l, (int)n);
    }

    private static String[] nativeGetLocales(long l, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetLocales", $$robo$$android_content_res_AssetManager$nativeGetLocales(long boolean ), (long)l, (boolean)bl);
    }

    private static Configuration[] nativeGetSizeConfigurations(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetSizeConfigurations", $$robo$$android_content_res_AssetManager$nativeGetSizeConfigurations(long ), (long)l);
    }

    private static void nativeApplyStyle(long l, long l2, int n, int n2, long l3, int[] nArray, long l4, long l5) {
        InvokeDynamicSupport.bootstrapStatic("nativeApplyStyle", $$robo$$android_content_res_AssetManager$nativeApplyStyle(long long int int long int[] long long ), (long)l, (long)l2, (int)n, (int)n2, (long)l3, (int[])nArray, (long)l4, (long)l5);
    }

    private static boolean nativeResolveAttrs(long l, long l2, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeResolveAttrs", $$robo$$android_content_res_AssetManager$nativeResolveAttrs(long long int int int[] int[] int[] int[] ), (long)l, (long)l2, (int)n, (int)n2, (int[])nArray, (int[])nArray2, (int[])nArray3, (int[])nArray4);
    }

    private static boolean nativeRetrieveAttributes(long l, long l2, int[] nArray, int[] nArray2, int[] nArray3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeRetrieveAttributes", $$robo$$android_content_res_AssetManager$nativeRetrieveAttributes(long long int[] int[] int[] ), (long)l, (long)l2, (int[])nArray, (int[])nArray2, (int[])nArray3);
    }

    private static long nativeThemeCreate(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeThemeCreate", $$robo$$android_content_res_AssetManager$nativeThemeCreate(long ), (long)l);
    }

    private static void nativeThemeDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeThemeDestroy", $$robo$$android_content_res_AssetManager$nativeThemeDestroy(long ), (long)l);
    }

    private static void nativeThemeApplyStyle(long l, long l2, int n, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeThemeApplyStyle", $$robo$$android_content_res_AssetManager$nativeThemeApplyStyle(long long int boolean ), (long)l, (long)l2, (int)n, (boolean)bl);
    }

    static void nativeThemeCopy(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nativeThemeCopy", $$robo$$android_content_res_AssetManager$nativeThemeCopy(long long ), (long)l, (long)l2);
    }

    static void nativeThemeClear(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeThemeClear", $$robo$$android_content_res_AssetManager$nativeThemeClear(long ), (long)l);
    }

    private static int nativeThemeGetAttributeValue(long l, long l2, int n, TypedValue typedValue, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeThemeGetAttributeValue", $$robo$$android_content_res_AssetManager$nativeThemeGetAttributeValue(long long int android.util.TypedValue boolean ), (long)l, (long)l2, (int)n, (TypedValue)typedValue, (boolean)bl);
    }

    private static void nativeThemeDump(long l, long l2, int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("nativeThemeDump", $$robo$$android_content_res_AssetManager$nativeThemeDump(long long int java.lang.String java.lang.String ), (long)l, (long)l2, (int)n, (String)string2, (String)string3);
    }

    static int nativeThemeGetChangingConfigurations(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeThemeGetChangingConfigurations", $$robo$$android_content_res_AssetManager$nativeThemeGetChangingConfigurations(long ), (long)l);
    }

    private static void nativeAssetDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeAssetDestroy", $$robo$$android_content_res_AssetManager$nativeAssetDestroy(long ), (long)l);
    }

    private static int nativeAssetReadChar(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeAssetReadChar", $$robo$$android_content_res_AssetManager$nativeAssetReadChar(long ), (long)l);
    }

    private static int nativeAssetRead(long l, byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeAssetRead", $$robo$$android_content_res_AssetManager$nativeAssetRead(long byte[] int int ), (long)l, (byte[])byArray, (int)n, (int)n2);
    }

    private static long nativeAssetSeek(long l, long l2, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeAssetSeek", $$robo$$android_content_res_AssetManager$nativeAssetSeek(long long int ), (long)l, (long)l2, (int)n);
    }

    private static long nativeAssetGetLength(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeAssetGetLength", $$robo$$android_content_res_AssetManager$nativeAssetGetLength(long ), (long)l);
    }

    private static long nativeAssetGetRemainingLength(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeAssetGetRemainingLength", $$robo$$android_content_res_AssetManager$nativeAssetGetRemainingLength(long ), (long)l);
    }

    private static void nativeVerifySystemIdmaps() {
        InvokeDynamicSupport.bootstrapStatic("nativeVerifySystemIdmaps", $$robo$$android_content_res_AssetManager$nativeVerifySystemIdmaps());
    }

    public static int getGlobalAssetCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalAssetCount", $$robo$$android_content_res_AssetManager$getGlobalAssetCount());
    }

    public static String getAssetAllocations() {
        return InvokeDynamicSupport.bootstrapStatic("getAssetAllocations", $$robo$$android_content_res_AssetManager$getAssetAllocations());
    }

    public static int getGlobalAssetManagerCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalAssetManagerCount", $$robo$$android_content_res_AssetManager$getGlobalAssetManagerCount());
    }

    private /* synthetic */ void __constructor__(boolean bl, 1 var2_2) {
        this.$$robo$$android_content_res_AssetManager$__constructor__(bl, var2_2);
    }

    public /* synthetic */ AssetManager(boolean bl, 1 var2_2) {
        this(bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetManager$__constructor__(boolean android.content.res.AssetManager$1 ), this, bl, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AssetManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AssetManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class AssetInputStream
    extends InputStream
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long mAssetNativePtr;
        private long mLength;
        private long mMarkPos;
        /* synthetic */ AssetManager this$0;

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$getAssetInt() {
            throw new UnsupportedOperationException();
        }

        private final long $$robo$$android_content_res_AssetManager_AssetInputStream$getNativeAsset() {
            return this.mAssetNativePtr;
        }

        private void $$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(AssetManager this$0, long assetNativePtr) {
            this.this$0 = this$0;
            this.mAssetNativePtr = assetNativePtr;
            this.mLength = AssetManager.nativeAssetGetLength(assetNativePtr);
        }

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$read() throws IOException {
            this.ensureOpen();
            return AssetManager.nativeAssetReadChar(this.mAssetNativePtr);
        }

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$read(byte[] b) throws IOException {
            this.ensureOpen();
            Preconditions.checkNotNull(b, "b");
            return AssetManager.nativeAssetRead(this.mAssetNativePtr, b, 0, b.length);
        }

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$read(byte[] b, int off, int len) throws IOException {
            this.ensureOpen();
            Preconditions.checkNotNull(b, "b");
            return AssetManager.nativeAssetRead(this.mAssetNativePtr, b, off, len);
        }

        private final long $$robo$$android_content_res_AssetManager_AssetInputStream$skip(long n) throws IOException {
            this.ensureOpen();
            long pos = AssetManager.nativeAssetSeek(this.mAssetNativePtr, 0L, 0);
            if (pos + n > this.mLength) {
                n = this.mLength - pos;
            }
            if (n > 0L) {
                AssetManager.nativeAssetSeek(this.mAssetNativePtr, n, 0);
            }
            return n;
        }

        private final int $$robo$$android_content_res_AssetManager_AssetInputStream$available() throws IOException {
            this.ensureOpen();
            long len = AssetManager.nativeAssetGetRemainingLength(this.mAssetNativePtr);
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }

        private final boolean $$robo$$android_content_res_AssetManager_AssetInputStream$markSupported() {
            return true;
        }

        private final void $$robo$$android_content_res_AssetManager_AssetInputStream$mark(int readlimit) {
            this.ensureOpen();
            this.mMarkPos = AssetManager.nativeAssetSeek(this.mAssetNativePtr, 0L, 0);
        }

        private final void $$robo$$android_content_res_AssetManager_AssetInputStream$reset() throws IOException {
            this.ensureOpen();
            AssetManager.nativeAssetSeek(this.mAssetNativePtr, this.mMarkPos, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_content_res_AssetManager_AssetInputStream$close() throws IOException {
            if (this.mAssetNativePtr != 0L) {
                AssetManager.nativeAssetDestroy(this.mAssetNativePtr);
                this.mAssetNativePtr = 0L;
                AssetManager assetManager = this.this$0;
                synchronized (assetManager) {
                    this.this$0.decRefsLocked(this.hashCode());
                }
            }
        }

        private final void $$robo$$android_content_res_AssetManager_AssetInputStream$finalize() throws Throwable {
            this.close();
        }

        private final void $$robo$$android_content_res_AssetManager_AssetInputStream$ensureOpen() {
            if (this.mAssetNativePtr == 0L) {
                throw new IllegalStateException("AssetInputStream is closed");
            }
        }

        private /* synthetic */ void $$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(AssetManager x0, long x1, 1 x2) {
        }

        public int getAssetInt() {
            return (int)InvokeDynamicSupport.bootstrap("getAssetInt", $$robo$$android_content_res_AssetManager_AssetInputStream$getAssetInt(), this);
        }

        public long getNativeAsset() {
            return (long)InvokeDynamicSupport.bootstrap("getNativeAsset", $$robo$$android_content_res_AssetManager_AssetInputStream$getNativeAsset(), this);
        }

        private void __constructor__(AssetManager assetManager, long l) {
            this.$$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(assetManager, l);
        }

        public AssetInputStream(AssetManager assetManager, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(android.content.res.AssetManager long ), this, assetManager, l);
        }

        @Override
        public int read() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_content_res_AssetManager_AssetInputStream$read(), this);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_content_res_AssetManager_AssetInputStream$read(byte[] ), this, byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_content_res_AssetManager_AssetInputStream$read(byte[] int int ), this, byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return (long)InvokeDynamicSupport.bootstrap("skip", $$robo$$android_content_res_AssetManager_AssetInputStream$skip(long ), this, l);
        }

        @Override
        public int available() throws IOException {
            return (int)InvokeDynamicSupport.bootstrap("available", $$robo$$android_content_res_AssetManager_AssetInputStream$available(), this);
        }

        @Override
        public boolean markSupported() {
            return (boolean)InvokeDynamicSupport.bootstrap("markSupported", $$robo$$android_content_res_AssetManager_AssetInputStream$markSupported(), this);
        }

        @Override
        public void mark(int n) {
            InvokeDynamicSupport.bootstrap("mark", $$robo$$android_content_res_AssetManager_AssetInputStream$mark(int ), this, n);
        }

        @Override
        public void reset() throws IOException {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_content_res_AssetManager_AssetInputStream$reset(), this);
        }

        @Override
        public void close() throws IOException {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_content_res_AssetManager_AssetInputStream$close(), this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_content_res_AssetManager_AssetInputStream$finalize(), this);
        }

        private void ensureOpen() {
            InvokeDynamicSupport.bootstrap("ensureOpen", $$robo$$android_content_res_AssetManager_AssetInputStream$ensureOpen(), this);
        }

        private /* synthetic */ void __constructor__(AssetManager assetManager, long l, 1 var4_3) {
            this.$$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(assetManager, l, var4_3);
        }

        public /* synthetic */ AssetInputStream(AssetManager assetManager, long l, 1 var4_3) {
            this(assetManager, l);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetManager_AssetInputStream$__constructor__(android.content.res.AssetManager long android.content.res.AssetManager$1 ), this, assetManager, l, var4_3);
        }

        public /* synthetic */ AssetInputStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AssetInputStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ArrayList<ApkAssets> mUserApkAssets;

        private void $$robo$$android_content_res_AssetManager_Builder$__constructor__() {
            this.mUserApkAssets = new ArrayList();
        }

        private final Builder $$robo$$android_content_res_AssetManager_Builder$addApkAssets(ApkAssets apkAssets) {
            this.mUserApkAssets.add(apkAssets);
            return this;
        }

        private final AssetManager $$robo$$android_content_res_AssetManager_Builder$build() {
            ApkAssets[] systemApkAssets = AssetManager.getSystem().getApkAssets();
            int totalApkAssetCount = systemApkAssets.length + this.mUserApkAssets.size();
            ApkAssets[] apkAssets = new ApkAssets[totalApkAssetCount];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)systemApkAssets, (int)0, (Object)apkAssets, (int)0, (int)systemApkAssets.length);
            int userApkAssetCount = this.mUserApkAssets.size();
            for (int i = 0; i < userApkAssetCount; ++i) {
                apkAssets[i + systemApkAssets.length] = this.mUserApkAssets.get(i);
            }
            AssetManager assetManager = new AssetManager(false, null);
            AssetManager.access$102(assetManager, apkAssets);
            AssetManager.nativeSetApkAssets(assetManager.mObject, apkAssets, false);
            return assetManager;
        }

        private void __constructor__() {
            this.$$robo$$android_content_res_AssetManager_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_content_res_AssetManager_Builder$__constructor__(), this);
        }

        public Builder addApkAssets(ApkAssets apkAssets) {
            return InvokeDynamicSupport.bootstrap("addApkAssets", $$robo$$android_content_res_AssetManager_Builder$addApkAssets(android.content.res.ApkAssets ), this, apkAssets);
        }

        public AssetManager build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_content_res_AssetManager_Builder$build(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

