/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.res.Resources;
import android.database.CharArrayBuffer;
import android.database.CursorWindowAllocationException;
import android.database.sqlite.SQLiteClosable;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseIntArray;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.CloseGuard;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CursorWindow
extends SQLiteClosable
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String STATS_TAG = "CursorWindowStats";
    private static int sCursorWindowSize;
    public long mWindowPtr;
    private int mStartPos;
    private String mName;
    private CloseGuard mCloseGuard;
    public static Parcelable.Creator<CursorWindow> CREATOR;
    private static LongSparseArray<Integer> sWindowToPidMap;

    private static final long $$robo$$android_database_CursorWindow$nativeCreate(String string2, int n) {
        return 0L;
    }

    private static final long $$robo$$android_database_CursorWindow$nativeCreateFromParcel(Parcel parcel) {
        return 0L;
    }

    private static final void $$robo$$android_database_CursorWindow$nativeDispose(long l) {
    }

    private static final void $$robo$$android_database_CursorWindow$nativeWriteToParcel(long l, Parcel parcel) {
    }

    private static final String $$robo$$android_database_CursorWindow$nativeGetName(long l) {
        return null;
    }

    private static final byte[] $$robo$$android_database_CursorWindow$nativeGetBlob(long l, int n, int n2) {
        return null;
    }

    private static final String $$robo$$android_database_CursorWindow$nativeGetString(long l, int n, int n2) {
        return null;
    }

    private static final void $$robo$$android_database_CursorWindow$nativeCopyStringToBuffer(long l, int n, int n2, CharArrayBuffer charArrayBuffer) {
    }

    private static final boolean $$robo$$android_database_CursorWindow$nativePutBlob(long l, byte[] byArray, int n, int n2) {
        return false;
    }

    private static final boolean $$robo$$android_database_CursorWindow$nativePutString(long l, String string2, int n, int n2) {
        return false;
    }

    @FastNative
    private static final void $$robo$$android_database_CursorWindow$nativeClear(long l) {
    }

    @FastNative
    private static final int $$robo$$android_database_CursorWindow$nativeGetNumRows(long l) {
        return 0;
    }

    @FastNative
    private static final boolean $$robo$$android_database_CursorWindow$nativeSetNumColumns(long l, int n) {
        return false;
    }

    @FastNative
    private static final boolean $$robo$$android_database_CursorWindow$nativeAllocRow(long l) {
        return false;
    }

    @FastNative
    private static final void $$robo$$android_database_CursorWindow$nativeFreeLastRow(long l) {
    }

    @FastNative
    private static final int $$robo$$android_database_CursorWindow$nativeGetType(long l, int n, int n2) {
        return 0;
    }

    @FastNative
    private static final long $$robo$$android_database_CursorWindow$nativeGetLong(long l, int n, int n2) {
        return 0L;
    }

    @FastNative
    private static final double $$robo$$android_database_CursorWindow$nativeGetDouble(long l, int n, int n2) {
        return 0.0;
    }

    @FastNative
    private static final boolean $$robo$$android_database_CursorWindow$nativePutLong(long l, long l2, int n, int n2) {
        return false;
    }

    @FastNative
    private static final boolean $$robo$$android_database_CursorWindow$nativePutDouble(long l, double d, int n, int n2) {
        return false;
    }

    @FastNative
    private static final boolean $$robo$$android_database_CursorWindow$nativePutNull(long l, int n, int n2) {
        return false;
    }

    private void $$robo$$android_database_CursorWindow$__constructor__(String name) {
    }

    private void $$robo$$android_database_CursorWindow$__constructor__(String name, long windowSizeBytes) {
        this.mCloseGuard = CloseGuard.get();
        this.mStartPos = 0;
        this.mName = name != null && name.length() != 0 ? name : "<unnamed>";
        this.mWindowPtr = CursorWindow.nativeCreate(this.mName, (int)windowSizeBytes);
        if (this.mWindowPtr == 0L) {
            throw new CursorWindowAllocationException("Cursor window allocation of " + windowSizeBytes + " bytes failed. " + this.printStats());
        }
        this.mCloseGuard.open("close");
        this.recordNewWindow(Binder.getCallingPid(), this.mWindowPtr);
    }

    @Deprecated
    private void $$robo$$android_database_CursorWindow$__constructor__(boolean localWindow) {
    }

    private void $$robo$$android_database_CursorWindow$__constructor__(Parcel source) {
        this.mCloseGuard = CloseGuard.get();
        this.mStartPos = source.readInt();
        this.mWindowPtr = CursorWindow.nativeCreateFromParcel(source);
        if (this.mWindowPtr == 0L) {
            throw new CursorWindowAllocationException("Cursor window could not be created from binder.");
        }
        this.mName = CursorWindow.nativeGetName(this.mWindowPtr);
        this.mCloseGuard.open("close");
    }

    private final void $$robo$$android_database_CursorWindow$finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_database_CursorWindow$dispose() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.close();
        }
        if (this.mWindowPtr != 0L) {
            this.recordClosingOfWindow(this.mWindowPtr);
            CursorWindow.nativeDispose(this.mWindowPtr);
            this.mWindowPtr = 0L;
        }
    }

    private final String $$robo$$android_database_CursorWindow$getName() {
        return this.mName;
    }

    private final void $$robo$$android_database_CursorWindow$clear() {
        this.acquireReference();
        try {
            this.mStartPos = 0;
            CursorWindow.nativeClear(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    private final int $$robo$$android_database_CursorWindow$getStartPosition() {
        return this.mStartPos;
    }

    private final void $$robo$$android_database_CursorWindow$setStartPosition(int pos) {
        this.mStartPos = pos;
    }

    private final int $$robo$$android_database_CursorWindow$getNumRows() {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetNumRows(this.mWindowPtr);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    private final boolean $$robo$$android_database_CursorWindow$setNumColumns(int columnNum) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeSetNumColumns(this.mWindowPtr, columnNum);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private final boolean $$robo$$android_database_CursorWindow$allocRow() {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeAllocRow(this.mWindowPtr);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private final void $$robo$$android_database_CursorWindow$freeLastRow() {
        this.acquireReference();
        try {
            CursorWindow.nativeFreeLastRow(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_database_CursorWindow$isNull(int row, int column) {
        return this.getType(row, column) == 0;
    }

    @Deprecated
    private final boolean $$robo$$android_database_CursorWindow$isBlob(int row, int column) {
        int type = this.getType(row, column);
        return type == 4 || type == 0;
    }

    @Deprecated
    private final boolean $$robo$$android_database_CursorWindow$isLong(int row, int column) {
        return this.getType(row, column) == 1;
    }

    @Deprecated
    private final boolean $$robo$$android_database_CursorWindow$isFloat(int row, int column) {
        return this.getType(row, column) == 2;
    }

    @Deprecated
    private final boolean $$robo$$android_database_CursorWindow$isString(int row, int column) {
        int type = this.getType(row, column);
        return type == 3 || type == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_database_CursorWindow$getType(int row, int column) {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetType(this.mWindowPtr, row - this.mStartPos, column);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] $$robo$$android_database_CursorWindow$getBlob(int row, int column) {
        this.acquireReference();
        try {
            byte[] byArray = CursorWindow.nativeGetBlob(this.mWindowPtr, row - this.mStartPos, column);
            return byArray;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_database_CursorWindow$getString(int row, int column) {
        this.acquireReference();
        try {
            String string2 = CursorWindow.nativeGetString(this.mWindowPtr, row - this.mStartPos, column);
            return string2;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_CursorWindow$copyStringToBuffer(int row, int column, CharArrayBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        this.acquireReference();
        try {
            CursorWindow.nativeCopyStringToBuffer(this.mWindowPtr, row - this.mStartPos, column, buffer);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_database_CursorWindow$getLong(int row, int column) {
        this.acquireReference();
        try {
            long l = CursorWindow.nativeGetLong(this.mWindowPtr, row - this.mStartPos, column);
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final double $$robo$$android_database_CursorWindow$getDouble(int row, int column) {
        this.acquireReference();
        try {
            double d = CursorWindow.nativeGetDouble(this.mWindowPtr, row - this.mStartPos, column);
            return d;
        }
        finally {
            this.releaseReference();
        }
    }

    private final short $$robo$$android_database_CursorWindow$getShort(int row, int column) {
        return (short)this.getLong(row, column);
    }

    private final int $$robo$$android_database_CursorWindow$getInt(int row, int column) {
        return (int)this.getLong(row, column);
    }

    private final float $$robo$$android_database_CursorWindow$getFloat(int row, int column) {
        return (float)this.getDouble(row, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_CursorWindow$putBlob(byte[] value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutBlob(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_CursorWindow$putString(String value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutString(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_CursorWindow$putLong(long value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutLong(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_CursorWindow$putDouble(double value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutDouble(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_database_CursorWindow$putNull(int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutNull(this.mWindowPtr, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    private static final CursorWindow $$robo$$android_database_CursorWindow$newFromParcel(Parcel p) {
        return CREATOR.createFromParcel(p);
    }

    private final int $$robo$$android_database_CursorWindow$describeContents() {
        return 0;
    }

    private final void $$robo$$android_database_CursorWindow$writeToParcel(Parcel dest, int flags) {
        this.acquireReference();
        try {
            dest.writeInt(this.mStartPos);
            CursorWindow.nativeWriteToParcel(this.mWindowPtr, dest);
        }
        finally {
            this.releaseReference();
        }
        if ((flags & 1) != 0) {
            this.releaseReference();
        }
    }

    private final void $$robo$$android_database_CursorWindow$onAllReferencesReleased() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_CursorWindow$recordNewWindow(int pid, long window) {
        LongSparseArray<Integer> longSparseArray = sWindowToPidMap;
        synchronized (longSparseArray) {
            sWindowToPidMap.put(window, pid);
            if (Log.isLoggable("CursorWindowStats", 2)) {
                Log.i("CursorWindowStats", "Created a new Cursor. " + this.printStats());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_database_CursorWindow$recordClosingOfWindow(long window) {
        LongSparseArray<Integer> longSparseArray = sWindowToPidMap;
        synchronized (longSparseArray) {
            if (sWindowToPidMap.size() == 0) {
                return;
            }
            sWindowToPidMap.delete(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_database_CursorWindow$printStats() {
        StringBuilder buff = new StringBuilder();
        int myPid = Process.myPid();
        int total = 0;
        SparseIntArray pidCounts = new SparseIntArray();
        LongSparseArray<Integer> longSparseArray = sWindowToPidMap;
        synchronized (longSparseArray) {
            int size = sWindowToPidMap.size();
            if (size == 0) {
                return "";
            }
            for (int indx = 0; indx < size; ++indx) {
                int pid = sWindowToPidMap.valueAt(indx);
                int value = pidCounts.get(pid);
                pidCounts.put(pid, ++value);
            }
        }
        int numPids = pidCounts.size();
        for (int i = 0; i < numPids; ++i) {
            buff.append(" (# cursors opened by ");
            int pid = pidCounts.keyAt(i);
            if (pid == myPid) {
                buff.append("this proc=");
            } else {
                buff.append("pid " + pid + "=");
            }
            int num = pidCounts.get(pid);
            buff.append(num + ")");
            total += num;
        }
        String s = buff.length() > 980 ? buff.substring(0, 980) : buff.toString();
        return "# Open Cursors=" + total + s;
    }

    private static final int $$robo$$android_database_CursorWindow$getCursorWindowSize() {
        if (sCursorWindowSize < 0) {
            sCursorWindowSize = Resources.getSystem().getInteger(17694758) * 1024;
        }
        return sCursorWindowSize;
    }

    private final String $$robo$$android_database_CursorWindow$toString() {
        return this.getName() + " {" + Long.toHexString(this.mWindowPtr) + "}";
    }

    private /* synthetic */ void $$robo$$android_database_CursorWindow$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        sCursorWindowSize = -1;
        CREATOR = new Parcelable.Creator<CursorWindow>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_database_CursorWindow_1$__constructor__() {
            }

            private final CursorWindow $$robo$$android_database_CursorWindow_1$createFromParcel(Parcel source) {
                return new CursorWindow(source, null);
            }

            private final CursorWindow[] $$robo$$android_database_CursorWindow_1$newArray(int size) {
                return new CursorWindow[size];
            }

            private void __constructor__() {
                this.$$robo$$android_database_CursorWindow_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_CursorWindow_1$__constructor__(), this);
            }

            @Override
            public CursorWindow createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_database_CursorWindow_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public CursorWindow[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_database_CursorWindow_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sWindowToPidMap = new LongSparseArray();
    }

    private static long nativeCreate(String string2, int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreate", $$robo$$android_database_CursorWindow$nativeCreate(java.lang.String int ), (String)string2, (int)n);
    }

    private static long nativeCreateFromParcel(Parcel parcel) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeCreateFromParcel", $$robo$$android_database_CursorWindow$nativeCreateFromParcel(android.os.Parcel ), (Parcel)parcel);
    }

    private static void nativeDispose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDispose", $$robo$$android_database_CursorWindow$nativeDispose(long ), (long)l);
    }

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteToParcel", $$robo$$android_database_CursorWindow$nativeWriteToParcel(long android.os.Parcel ), (long)l, (Parcel)parcel);
    }

    private static String nativeGetName(long l) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetName", $$robo$$android_database_CursorWindow$nativeGetName(long ), (long)l);
    }

    private static byte[] nativeGetBlob(long l, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetBlob", $$robo$$android_database_CursorWindow$nativeGetBlob(long int int ), (long)l, (int)n, (int)n2);
    }

    private static String nativeGetString(long l, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetString", $$robo$$android_database_CursorWindow$nativeGetString(long int int ), (long)l, (int)n, (int)n2);
    }

    private static void nativeCopyStringToBuffer(long l, int n, int n2, CharArrayBuffer charArrayBuffer) {
        InvokeDynamicSupport.bootstrapStatic("nativeCopyStringToBuffer", $$robo$$android_database_CursorWindow$nativeCopyStringToBuffer(long int int android.database.CharArrayBuffer ), (long)l, (int)n, (int)n2, (CharArrayBuffer)charArrayBuffer);
    }

    private static boolean nativePutBlob(long l, byte[] byArray, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativePutBlob", $$robo$$android_database_CursorWindow$nativePutBlob(long byte[] int int ), (long)l, (byte[])byArray, (int)n, (int)n2);
    }

    private static boolean nativePutString(long l, String string2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativePutString", $$robo$$android_database_CursorWindow$nativePutString(long java.lang.String int int ), (long)l, (String)string2, (int)n, (int)n2);
    }

    private static void nativeClear(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeClear", $$robo$$android_database_CursorWindow$nativeClear(long ), (long)l);
    }

    private static int nativeGetNumRows(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetNumRows", $$robo$$android_database_CursorWindow$nativeGetNumRows(long ), (long)l);
    }

    private static boolean nativeSetNumColumns(long l, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeSetNumColumns", $$robo$$android_database_CursorWindow$nativeSetNumColumns(long int ), (long)l, (int)n);
    }

    private static boolean nativeAllocRow(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeAllocRow", $$robo$$android_database_CursorWindow$nativeAllocRow(long ), (long)l);
    }

    private static void nativeFreeLastRow(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeFreeLastRow", $$robo$$android_database_CursorWindow$nativeFreeLastRow(long ), (long)l);
    }

    private static int nativeGetType(long l, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetType", $$robo$$android_database_CursorWindow$nativeGetType(long int int ), (long)l, (int)n, (int)n2);
    }

    private static long nativeGetLong(long l, int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeGetLong", $$robo$$android_database_CursorWindow$nativeGetLong(long int int ), (long)l, (int)n, (int)n2);
    }

    private static double nativeGetDouble(long l, int n, int n2) {
        return (double)InvokeDynamicSupport.bootstrapStatic("nativeGetDouble", $$robo$$android_database_CursorWindow$nativeGetDouble(long int int ), (long)l, (int)n, (int)n2);
    }

    private static boolean nativePutLong(long l, long l2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativePutLong", $$robo$$android_database_CursorWindow$nativePutLong(long long int int ), (long)l, (long)l2, (int)n, (int)n2);
    }

    private static boolean nativePutDouble(long l, double d, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativePutDouble", $$robo$$android_database_CursorWindow$nativePutDouble(long double int int ), (long)l, (double)d, (int)n, (int)n2);
    }

    private static boolean nativePutNull(long l, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativePutNull", $$robo$$android_database_CursorWindow$nativePutNull(long int int ), (long)l, (int)n, (int)n2);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_database_CursorWindow$__constructor__(string2);
    }

    public CursorWindow(String string2) {
        this(string2, CursorWindow.getCursorWindowSize());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_CursorWindow$__constructor__(java.lang.String ), this, string2);
    }

    private void __constructor__(String string2, long l) {
        this.$$robo$$android_database_CursorWindow$__constructor__(string2, l);
    }

    public CursorWindow(String string2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_CursorWindow$__constructor__(java.lang.String long ), this, string2, l);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_database_CursorWindow$__constructor__(bl);
    }

    public CursorWindow(boolean bl) {
        this((String)null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_CursorWindow$__constructor__(boolean ), this, bl);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_database_CursorWindow$__constructor__(parcel);
    }

    public CursorWindow(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_CursorWindow$__constructor__(android.os.Parcel ), this, parcel);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_database_CursorWindow$finalize(), this);
    }

    private void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_database_CursorWindow$dispose(), this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_database_CursorWindow$getName(), this);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_database_CursorWindow$clear(), this);
    }

    public int getStartPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getStartPosition", $$robo$$android_database_CursorWindow$getStartPosition(), this);
    }

    public void setStartPosition(int n) {
        InvokeDynamicSupport.bootstrap("setStartPosition", $$robo$$android_database_CursorWindow$setStartPosition(int ), this, n);
    }

    public int getNumRows() {
        return (int)InvokeDynamicSupport.bootstrap("getNumRows", $$robo$$android_database_CursorWindow$getNumRows(), this);
    }

    public boolean setNumColumns(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNumColumns", $$robo$$android_database_CursorWindow$setNumColumns(int ), this, n);
    }

    public boolean allocRow() {
        return (boolean)InvokeDynamicSupport.bootstrap("allocRow", $$robo$$android_database_CursorWindow$allocRow(), this);
    }

    public void freeLastRow() {
        InvokeDynamicSupport.bootstrap("freeLastRow", $$robo$$android_database_CursorWindow$freeLastRow(), this);
    }

    @Deprecated
    public boolean isNull(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNull", $$robo$$android_database_CursorWindow$isNull(int int ), this, n, n2);
    }

    @Deprecated
    public boolean isBlob(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBlob", $$robo$$android_database_CursorWindow$isBlob(int int ), this, n, n2);
    }

    @Deprecated
    public boolean isLong(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLong", $$robo$$android_database_CursorWindow$isLong(int int ), this, n, n2);
    }

    @Deprecated
    public boolean isFloat(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFloat", $$robo$$android_database_CursorWindow$isFloat(int int ), this, n, n2);
    }

    @Deprecated
    public boolean isString(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isString", $$robo$$android_database_CursorWindow$isString(int int ), this, n, n2);
    }

    public int getType(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_database_CursorWindow$getType(int int ), this, n, n2);
    }

    public byte[] getBlob(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getBlob", $$robo$$android_database_CursorWindow$getBlob(int int ), this, n, n2);
    }

    public String getString(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_database_CursorWindow$getString(int int ), this, n, n2);
    }

    public void copyStringToBuffer(int n, int n2, CharArrayBuffer charArrayBuffer) {
        InvokeDynamicSupport.bootstrap("copyStringToBuffer", $$robo$$android_database_CursorWindow$copyStringToBuffer(int int android.database.CharArrayBuffer ), this, n, n2, charArrayBuffer);
    }

    public long getLong(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$android_database_CursorWindow$getLong(int int ), this, n, n2);
    }

    public double getDouble(int n, int n2) {
        return (double)InvokeDynamicSupport.bootstrap("getDouble", $$robo$$android_database_CursorWindow$getDouble(int int ), this, n, n2);
    }

    public short getShort(int n, int n2) {
        return (short)InvokeDynamicSupport.bootstrap("getShort", $$robo$$android_database_CursorWindow$getShort(int int ), this, n, n2);
    }

    public int getInt(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_database_CursorWindow$getInt(int int ), this, n, n2);
    }

    public float getFloat(int n, int n2) {
        return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$android_database_CursorWindow$getFloat(int int ), this, n, n2);
    }

    public boolean putBlob(byte[] byArray, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("putBlob", $$robo$$android_database_CursorWindow$putBlob(byte[] int int ), this, byArray, n, n2);
    }

    public boolean putString(String string2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("putString", $$robo$$android_database_CursorWindow$putString(java.lang.String int int ), this, string2, n, n2);
    }

    public boolean putLong(long l, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("putLong", $$robo$$android_database_CursorWindow$putLong(long int int ), this, l, n, n2);
    }

    public boolean putDouble(double d, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("putDouble", $$robo$$android_database_CursorWindow$putDouble(double int int ), this, d, n, n2);
    }

    public boolean putNull(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("putNull", $$robo$$android_database_CursorWindow$putNull(int int ), this, n, n2);
    }

    public static CursorWindow newFromParcel(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("newFromParcel", $$robo$$android_database_CursorWindow$newFromParcel(android.os.Parcel ), (Parcel)parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_database_CursorWindow$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_database_CursorWindow$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    protected void onAllReferencesReleased() {
        InvokeDynamicSupport.bootstrap("onAllReferencesReleased", $$robo$$android_database_CursorWindow$onAllReferencesReleased(), this);
    }

    private void recordNewWindow(int n, long l) {
        InvokeDynamicSupport.bootstrap("recordNewWindow", $$robo$$android_database_CursorWindow$recordNewWindow(int long ), this, n, l);
    }

    private void recordClosingOfWindow(long l) {
        InvokeDynamicSupport.bootstrap("recordClosingOfWindow", $$robo$$android_database_CursorWindow$recordClosingOfWindow(long ), this, l);
    }

    private String printStats() {
        return InvokeDynamicSupport.bootstrap("printStats", $$robo$$android_database_CursorWindow$printStats(), this);
    }

    private static int getCursorWindowSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCursorWindowSize", $$robo$$android_database_CursorWindow$getCursorWindowSize());
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_database_CursorWindow$toString(), this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_database_CursorWindow$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ CursorWindow(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_CursorWindow$__constructor__(android.os.Parcel android.database.CursorWindow$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(CursorWindow.class);
    }

    public /* synthetic */ CursorWindow() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CursorWindow)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

