/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.os.CancellationSignal;
import android.text.TextUtils;
import android.util.Log;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SQLiteQueryBuilder
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "SQLiteQueryBuilder";
    private static Pattern sLimitPattern;
    private Map<String, String> mProjectionMap;
    private String mTables;
    private StringBuilder mWhereClause;
    private boolean mDistinct;
    private SQLiteDatabase.CursorFactory mFactory;
    private boolean mStrict;

    private void $$robo$$android_database_sqlite_SQLiteQueryBuilder$__constructor__() {
        this.mProjectionMap = null;
        this.mTables = "";
        this.mWhereClause = null;
        this.mDistinct = false;
        this.mFactory = null;
    }

    private final void $$robo$$android_database_sqlite_SQLiteQueryBuilder$setDistinct(boolean distinct) {
        this.mDistinct = distinct;
    }

    private final String $$robo$$android_database_sqlite_SQLiteQueryBuilder$getTables() {
        return this.mTables;
    }

    private final void $$robo$$android_database_sqlite_SQLiteQueryBuilder$setTables(String inTables) {
        this.mTables = inTables;
    }

    private final void $$robo$$android_database_sqlite_SQLiteQueryBuilder$appendWhere(CharSequence inWhere) {
        if (this.mWhereClause == null) {
            this.mWhereClause = new StringBuilder(inWhere.length() + 16);
        }
        if (this.mWhereClause.length() == 0) {
            this.mWhereClause.append('(');
        }
        this.mWhereClause.append(inWhere);
    }

    private final void $$robo$$android_database_sqlite_SQLiteQueryBuilder$appendWhereEscapeString(String inWhere) {
        if (this.mWhereClause == null) {
            this.mWhereClause = new StringBuilder(inWhere.length() + 16);
        }
        if (this.mWhereClause.length() == 0) {
            this.mWhereClause.append('(');
        }
        DatabaseUtils.appendEscapedSQLString(this.mWhereClause, inWhere);
    }

    private final void $$robo$$android_database_sqlite_SQLiteQueryBuilder$setProjectionMap(Map<String, String> columnMap) {
        this.mProjectionMap = columnMap;
    }

    private final void $$robo$$android_database_sqlite_SQLiteQueryBuilder$setCursorFactory(SQLiteDatabase.CursorFactory factory) {
        this.mFactory = factory;
    }

    private final void $$robo$$android_database_sqlite_SQLiteQueryBuilder$setStrict(boolean flag) {
        this.mStrict = flag;
    }

    private static final String $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildQueryString(boolean distinct, String tables, String[] columns, String where, String groupBy, String having, String orderBy, String limit) {
        if (TextUtils.isEmpty(groupBy) && !TextUtils.isEmpty(having)) {
            throw new IllegalArgumentException("HAVING clauses are only permitted when using a groupBy clause");
        }
        if (!TextUtils.isEmpty(limit) && !sLimitPattern.matcher(limit).matches()) {
            throw new IllegalArgumentException("invalid LIMIT clauses:" + limit);
        }
        StringBuilder query = new StringBuilder(120);
        query.append("SELECT ");
        if (distinct) {
            query.append("DISTINCT ");
        }
        if (columns != null && columns.length != 0) {
            SQLiteQueryBuilder.appendColumns(query, columns);
        } else {
            query.append("* ");
        }
        query.append("FROM ");
        query.append(tables);
        SQLiteQueryBuilder.appendClause(query, " WHERE ", where);
        SQLiteQueryBuilder.appendClause(query, " GROUP BY ", groupBy);
        SQLiteQueryBuilder.appendClause(query, " HAVING ", having);
        SQLiteQueryBuilder.appendClause(query, " ORDER BY ", orderBy);
        SQLiteQueryBuilder.appendClause(query, " LIMIT ", limit);
        return query.toString();
    }

    private static final void $$robo$$android_database_sqlite_SQLiteQueryBuilder$appendClause(StringBuilder s, String name, String clause) {
        if (!TextUtils.isEmpty(clause)) {
            s.append(name);
            s.append(clause);
        }
    }

    private static final void $$robo$$android_database_sqlite_SQLiteQueryBuilder$appendColumns(StringBuilder s, String[] columns) {
        int n = columns.length;
        for (int i = 0; i < n; ++i) {
            String column = columns[i];
            if (column == null) continue;
            if (i > 0) {
                s.append(", ");
            }
            s.append(column);
        }
        s.append(' ');
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteQueryBuilder$query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder) {
        return this.query(db, projectionIn, selection, selectionArgs, groupBy, having, sortOrder, null, null);
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteQueryBuilder$query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit) {
        return this.query(db, projectionIn, selection, selectionArgs, groupBy, having, sortOrder, limit, null);
    }

    private final Cursor $$robo$$android_database_sqlite_SQLiteQueryBuilder$query(SQLiteDatabase db, String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit, CancellationSignal cancellationSignal) {
        if (this.mTables == null) {
            return null;
        }
        if (this.mStrict && selection != null && selection.length() > 0) {
            String sqlForValidation = this.buildQuery(projectionIn, "(" + selection + ")", groupBy, having, sortOrder, limit);
            db.validateSql(sqlForValidation, cancellationSignal);
        }
        String sql = this.buildQuery(projectionIn, selection, groupBy, having, sortOrder, limit);
        if (Log.isLoggable("SQLiteQueryBuilder", 3)) {
            Log.d("SQLiteQueryBuilder", "Performing query: " + sql);
        }
        return db.rawQueryWithFactory(this.mFactory, sql, selectionArgs, SQLiteDatabase.findEditTable(this.mTables), cancellationSignal);
    }

    private final String $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildQuery(String[] projectionIn, String selection, String groupBy, String having, String sortOrder, String limit) {
        boolean hasBaseWhereClause;
        String[] projection = this.computeProjection(projectionIn);
        StringBuilder where = new StringBuilder();
        boolean bl = hasBaseWhereClause = this.mWhereClause != null && this.mWhereClause.length() > 0;
        if (hasBaseWhereClause) {
            where.append(this.mWhereClause.toString());
            where.append(')');
        }
        if (selection != null && selection.length() > 0) {
            if (hasBaseWhereClause) {
                where.append(" AND ");
            }
            where.append('(');
            where.append(selection);
            where.append(')');
        }
        return SQLiteQueryBuilder.buildQueryString(this.mDistinct, this.mTables, projection, where.toString(), groupBy, having, sortOrder, limit);
    }

    @Deprecated
    private final String $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildQuery(String[] projectionIn, String selection, String[] selectionArgs, String groupBy, String having, String sortOrder, String limit) {
        return this.buildQuery(projectionIn, selection, groupBy, having, sortOrder, limit);
    }

    private final String $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildUnionSubQuery(String typeDiscriminatorColumn, String[] unionColumns, Set<String> columnsPresentInTable, int computedColumnsOffset, String typeDiscriminatorValue, String selection, String groupBy, String having) {
        int unionColumnsCount = unionColumns.length;
        String[] projectionIn = new String[unionColumnsCount];
        for (int i = 0; i < unionColumnsCount; ++i) {
            String unionColumn = unionColumns[i];
            projectionIn[i] = unionColumn.equals(typeDiscriminatorColumn) ? "'" + typeDiscriminatorValue + "' AS " + typeDiscriminatorColumn : (i <= computedColumnsOffset || columnsPresentInTable.contains(unionColumn) ? unionColumn : "NULL AS " + unionColumn);
        }
        return this.buildQuery(projectionIn, selection, groupBy, having, null, null);
    }

    @Deprecated
    private final String $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildUnionSubQuery(String typeDiscriminatorColumn, String[] unionColumns, Set<String> columnsPresentInTable, int computedColumnsOffset, String typeDiscriminatorValue, String selection, String[] selectionArgs, String groupBy, String having) {
        return this.buildUnionSubQuery(typeDiscriminatorColumn, unionColumns, columnsPresentInTable, computedColumnsOffset, typeDiscriminatorValue, selection, groupBy, having);
    }

    private final String $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildUnionQuery(String[] subQueries, String sortOrder, String limit) {
        StringBuilder query = new StringBuilder(128);
        int subQueryCount = subQueries.length;
        String unionOperator = this.mDistinct ? " UNION " : " UNION ALL ";
        for (int i = 0; i < subQueryCount; ++i) {
            if (i > 0) {
                query.append(unionOperator);
            }
            query.append(subQueries[i]);
        }
        SQLiteQueryBuilder.appendClause(query, " ORDER BY ", sortOrder);
        SQLiteQueryBuilder.appendClause(query, " LIMIT ", limit);
        return query.toString();
    }

    private final String[] $$robo$$android_database_sqlite_SQLiteQueryBuilder$computeProjection(String[] projectionIn) {
        if (projectionIn != null && projectionIn.length > 0) {
            if (this.mProjectionMap != null) {
                String[] projection = new String[projectionIn.length];
                int length = projectionIn.length;
                for (int i = 0; i < length; ++i) {
                    String userColumn = projectionIn[i];
                    String column = this.mProjectionMap.get(userColumn);
                    if (column != null) {
                        projection[i] = column;
                        continue;
                    }
                    if (!this.mStrict && (userColumn.contains(" AS ") || userColumn.contains(" as "))) {
                        projection[i] = userColumn;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid column " + projectionIn[i]);
                }
                return projection;
            }
            return projectionIn;
        }
        if (this.mProjectionMap != null) {
            Set<Map.Entry<String, String>> entrySet = this.mProjectionMap.entrySet();
            String[] projection = new String[entrySet.size()];
            Iterator<Map.Entry<String, String>> entryIter = entrySet.iterator();
            int i = 0;
            while (entryIter.hasNext()) {
                Map.Entry<String, String> entry = entryIter.next();
                if (entry.getKey().equals("_count")) continue;
                projection[i++] = entry.getValue();
            }
            return projection;
        }
        return null;
    }

    static void __staticInitializer__() {
        sLimitPattern = Pattern.compile("\\s*\\d+\\s*(,\\s*\\d+\\s*)?");
    }

    private void __constructor__() {
        this.$$robo$$android_database_sqlite_SQLiteQueryBuilder$__constructor__();
    }

    public SQLiteQueryBuilder() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_database_sqlite_SQLiteQueryBuilder$__constructor__(), this);
    }

    public void setDistinct(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDistinct", $$robo$$android_database_sqlite_SQLiteQueryBuilder$setDistinct(boolean ), this, bl);
    }

    public String getTables() {
        return InvokeDynamicSupport.bootstrap("getTables", $$robo$$android_database_sqlite_SQLiteQueryBuilder$getTables(), this);
    }

    public void setTables(String string2) {
        InvokeDynamicSupport.bootstrap("setTables", $$robo$$android_database_sqlite_SQLiteQueryBuilder$setTables(java.lang.String ), this, string2);
    }

    public void appendWhere(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("appendWhere", $$robo$$android_database_sqlite_SQLiteQueryBuilder$appendWhere(java.lang.CharSequence ), this, charSequence);
    }

    public void appendWhereEscapeString(String string2) {
        InvokeDynamicSupport.bootstrap("appendWhereEscapeString", $$robo$$android_database_sqlite_SQLiteQueryBuilder$appendWhereEscapeString(java.lang.String ), this, string2);
    }

    public void setProjectionMap(Map<String, String> map) {
        InvokeDynamicSupport.bootstrap("setProjectionMap", $$robo$$android_database_sqlite_SQLiteQueryBuilder$setProjectionMap(java.util.Map<java.lang.String, java.lang.String> ), this, map);
    }

    public void setCursorFactory(SQLiteDatabase.CursorFactory cursorFactory) {
        InvokeDynamicSupport.bootstrap("setCursorFactory", $$robo$$android_database_sqlite_SQLiteQueryBuilder$setCursorFactory(android.database.sqlite.SQLiteDatabase$CursorFactory ), this, cursorFactory);
    }

    public void setStrict(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStrict", $$robo$$android_database_sqlite_SQLiteQueryBuilder$setStrict(boolean ), this, bl);
    }

    public static String buildQueryString(boolean bl, String string2, String[] stringArray, String string3, String string4, String string5, String string6, String string7) {
        return InvokeDynamicSupport.bootstrapStatic("buildQueryString", $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildQueryString(boolean java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), (boolean)bl, (String)string2, (String[])stringArray, (String)string3, (String)string4, (String)string5, (String)string6, (String)string7);
    }

    private static void appendClause(StringBuilder stringBuilder, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("appendClause", $$robo$$android_database_sqlite_SQLiteQueryBuilder$appendClause(java.lang.StringBuilder java.lang.String java.lang.String ), (StringBuilder)stringBuilder, (String)string2, (String)string3);
    }

    public static void appendColumns(StringBuilder stringBuilder, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("appendColumns", $$robo$$android_database_sqlite_SQLiteQueryBuilder$appendColumns(java.lang.StringBuilder java.lang.String[] ), (StringBuilder)stringBuilder, (String[])stringArray);
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_database_sqlite_SQLiteQueryBuilder$query(android.database.sqlite.SQLiteDatabase java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String ), this, sQLiteDatabase, stringArray, string2, stringArray2, string3, string4, string5);
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_database_sqlite_SQLiteQueryBuilder$query(android.database.sqlite.SQLiteDatabase java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String ), this, sQLiteDatabase, stringArray, string2, stringArray2, string3, string4, string5, string6);
    }

    public Cursor query(SQLiteDatabase sQLiteDatabase, String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_database_sqlite_SQLiteQueryBuilder$query(android.database.sqlite.SQLiteDatabase java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String android.os.CancellationSignal ), this, sQLiteDatabase, stringArray, string2, stringArray2, string3, string4, string5, string6, cancellationSignal);
    }

    public String buildQuery(String[] stringArray, String string2, String string3, String string4, String string5, String string6) {
        return InvokeDynamicSupport.bootstrap("buildQuery", $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildQuery(java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), this, stringArray, string2, string3, string4, string5, string6);
    }

    @Deprecated
    public String buildQuery(String[] stringArray, String string2, String[] stringArray2, String string3, String string4, String string5, String string6) {
        return InvokeDynamicSupport.bootstrap("buildQuery", $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildQuery(java.lang.String[] java.lang.String java.lang.String[] java.lang.String java.lang.String java.lang.String java.lang.String ), this, stringArray, string2, stringArray2, string3, string4, string5, string6);
    }

    public String buildUnionSubQuery(String string2, String[] stringArray, Set<String> set, int n, String string3, String string4, String string5, String string6) {
        return InvokeDynamicSupport.bootstrap("buildUnionSubQuery", $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildUnionSubQuery(java.lang.String java.lang.String[] java.util.Set<java.lang.String> int java.lang.String java.lang.String java.lang.String java.lang.String ), this, string2, stringArray, set, n, string3, string4, string5, string6);
    }

    @Deprecated
    public String buildUnionSubQuery(String string2, String[] stringArray, Set<String> set, int n, String string3, String string4, String[] stringArray2, String string5, String string6) {
        return InvokeDynamicSupport.bootstrap("buildUnionSubQuery", $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildUnionSubQuery(java.lang.String java.lang.String[] java.util.Set<java.lang.String> int java.lang.String java.lang.String java.lang.String[] java.lang.String java.lang.String ), this, string2, stringArray, set, n, string3, string4, stringArray2, string5, string6);
    }

    public String buildUnionQuery(String[] stringArray, String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("buildUnionQuery", $$robo$$android_database_sqlite_SQLiteQueryBuilder$buildUnionQuery(java.lang.String[] java.lang.String java.lang.String ), this, stringArray, string2, string3);
    }

    private String[] computeProjection(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("computeProjection", $$robo$$android_database_sqlite_SQLiteQueryBuilder$computeProjection(java.lang.String[] ), this, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(SQLiteQueryBuilder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SQLiteQueryBuilder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

