/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.os.Debug;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DdmHandleHeap
extends ChunkHandler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int CHUNK_HPIF;
    public static int CHUNK_HPSG;
    public static int CHUNK_HPDU;
    public static int CHUNK_HPDS;
    public static int CHUNK_NHSG;
    public static int CHUNK_HPGC;
    public static int CHUNK_REAE;
    public static int CHUNK_REAQ;
    public static int CHUNK_REAL;
    private static DdmHandleHeap mInstance;

    private void $$robo$$android_ddm_DdmHandleHeap$__constructor__() {
    }

    private static final void $$robo$$android_ddm_DdmHandleHeap$register() {
        DdmServer.registerHandler(CHUNK_HPIF, mInstance);
        DdmServer.registerHandler(CHUNK_HPSG, mInstance);
        DdmServer.registerHandler(CHUNK_HPDU, mInstance);
        DdmServer.registerHandler(CHUNK_HPDS, mInstance);
        DdmServer.registerHandler(CHUNK_NHSG, mInstance);
        DdmServer.registerHandler(CHUNK_HPGC, mInstance);
        DdmServer.registerHandler(CHUNK_REAE, mInstance);
        DdmServer.registerHandler(CHUNK_REAQ, mInstance);
        DdmServer.registerHandler(CHUNK_REAL, mInstance);
    }

    private final void $$robo$$android_ddm_DdmHandleHeap$connected() {
    }

    private final void $$robo$$android_ddm_DdmHandleHeap$disconnected() {
    }

    private final Chunk $$robo$$android_ddm_DdmHandleHeap$handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_HPIF) {
            return this.handleHPIF(request);
        }
        if (type == CHUNK_HPSG) {
            return this.handleHPSGNHSG(request, false);
        }
        if (type == CHUNK_HPDU) {
            return this.handleHPDU(request);
        }
        if (type == CHUNK_HPDS) {
            return this.handleHPDS(request);
        }
        if (type == CHUNK_NHSG) {
            return this.handleHPSGNHSG(request, true);
        }
        if (type == CHUNK_HPGC) {
            return this.handleHPGC(request);
        }
        if (type == CHUNK_REAE) {
            return this.handleREAE(request);
        }
        if (type == CHUNK_REAQ) {
            return this.handleREAQ(request);
        }
        if (type == CHUNK_REAL) {
            return this.handleREAL(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    private final Chunk $$robo$$android_ddm_DdmHandleHeap$handleHPIF(Chunk request) {
        ByteBuffer in = DdmHandleHeap.wrapChunk(request);
        byte when = in.get();
        boolean ok = DdmVmInternal.heapInfoNotify(when);
        if (!ok) {
            return DdmHandleHeap.createFailChunk(1, "Unsupported HPIF what");
        }
        return null;
    }

    private final Chunk $$robo$$android_ddm_DdmHandleHeap$handleHPSGNHSG(Chunk request, boolean isNative) {
        byte what;
        ByteBuffer in = DdmHandleHeap.wrapChunk(request);
        byte when = in.get();
        boolean ok = DdmVmInternal.heapSegmentNotify(when, what = in.get(), isNative);
        if (!ok) {
            return DdmHandleHeap.createFailChunk(1, "Unsupported HPSG what/when");
        }
        return null;
    }

    private final Chunk $$robo$$android_ddm_DdmHandleHeap$handleHPDU(Chunk request) {
        byte result;
        ByteBuffer in = DdmHandleHeap.wrapChunk(request);
        int len = in.getInt();
        String fileName = DdmHandleHeap.getString(in, len);
        try {
            Debug.dumpHprofData(fileName);
            result = 0;
        }
        catch (UnsupportedOperationException uoe) {
            Log.w("ddm-heap", "hprof dumps not supported in this VM");
            result = -1;
        }
        catch (IOException ioe) {
            result = -1;
        }
        catch (RuntimeException re) {
            result = -1;
        }
        byte[] reply = new byte[]{result};
        return new Chunk(CHUNK_HPDU, reply, 0, reply.length);
    }

    private final Chunk $$robo$$android_ddm_DdmHandleHeap$handleHPDS(Chunk request) {
        ByteBuffer in = DdmHandleHeap.wrapChunk(request);
        String failMsg = null;
        try {
            Debug.dumpHprofDataDdms();
        }
        catch (UnsupportedOperationException uoe) {
            failMsg = "hprof dumps not supported in this VM";
        }
        catch (RuntimeException re) {
            failMsg = "Exception: " + re.getMessage();
        }
        if (failMsg != null) {
            Log.w("ddm-heap", failMsg);
            return DdmHandleHeap.createFailChunk(1, failMsg);
        }
        return null;
    }

    private final Chunk $$robo$$android_ddm_DdmHandleHeap$handleHPGC(Chunk request) {
        Runtime.getRuntime().gc();
        return null;
    }

    private final Chunk $$robo$$android_ddm_DdmHandleHeap$handleREAE(Chunk request) {
        ByteBuffer in = DdmHandleHeap.wrapChunk(request);
        boolean enable = in.get() != 0;
        DdmVmInternal.enableRecentAllocations(enable);
        return null;
    }

    private final Chunk $$robo$$android_ddm_DdmHandleHeap$handleREAQ(Chunk request) {
        byte[] reply = new byte[]{DdmVmInternal.getRecentAllocationStatus() ? (byte)1 : 0};
        return new Chunk(CHUNK_REAQ, reply, 0, reply.length);
    }

    private final Chunk $$robo$$android_ddm_DdmHandleHeap$handleREAL(Chunk request) {
        byte[] reply = DdmVmInternal.getRecentAllocations();
        return new Chunk(CHUNK_REAL, reply, 0, reply.length);
    }

    static void __staticInitializer__() {
        CHUNK_HPIF = DdmHandleHeap.type("HPIF");
        CHUNK_HPSG = DdmHandleHeap.type("HPSG");
        CHUNK_HPDU = DdmHandleHeap.type("HPDU");
        CHUNK_HPDS = DdmHandleHeap.type("HPDS");
        CHUNK_NHSG = DdmHandleHeap.type("NHSG");
        CHUNK_HPGC = DdmHandleHeap.type("HPGC");
        CHUNK_REAE = DdmHandleHeap.type("REAE");
        CHUNK_REAQ = DdmHandleHeap.type("REAQ");
        CHUNK_REAL = DdmHandleHeap.type("REAL");
        mInstance = new DdmHandleHeap();
    }

    private void __constructor__() {
        this.$$robo$$android_ddm_DdmHandleHeap$__constructor__();
    }

    public DdmHandleHeap() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_ddm_DdmHandleHeap$__constructor__(), this);
    }

    public static void register() {
        InvokeDynamicSupport.bootstrapStatic("register", $$robo$$android_ddm_DdmHandleHeap$register());
    }

    @Override
    public void connected() {
        InvokeDynamicSupport.bootstrap("connected", $$robo$$android_ddm_DdmHandleHeap$connected(), this);
    }

    @Override
    public void disconnected() {
        InvokeDynamicSupport.bootstrap("disconnected", $$robo$$android_ddm_DdmHandleHeap$disconnected(), this);
    }

    @Override
    public Chunk handleChunk(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleChunk", $$robo$$android_ddm_DdmHandleHeap$handleChunk(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleHPIF(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleHPIF", $$robo$$android_ddm_DdmHandleHeap$handleHPIF(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleHPSGNHSG(Chunk chunk, boolean bl) {
        return InvokeDynamicSupport.bootstrap("handleHPSGNHSG", $$robo$$android_ddm_DdmHandleHeap$handleHPSGNHSG(org.apache.harmony.dalvik.ddmc.Chunk boolean ), this, chunk, bl);
    }

    private Chunk handleHPDU(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleHPDU", $$robo$$android_ddm_DdmHandleHeap$handleHPDU(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleHPDS(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleHPDS", $$robo$$android_ddm_DdmHandleHeap$handleHPDS(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleHPGC(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleHPGC", $$robo$$android_ddm_DdmHandleHeap$handleHPGC(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleREAE(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleREAE", $$robo$$android_ddm_DdmHandleHeap$handleREAE(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleREAQ(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleREAQ", $$robo$$android_ddm_DdmHandleHeap$handleREAQ(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleREAL(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleREAL", $$robo$$android_ddm_DdmHandleHeap$handleREAL(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    static {
        RobolectricInternals.classInitializing(DdmHandleHeap.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DdmHandleHeap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

