/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DdmHandleThread
extends ChunkHandler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int CHUNK_THEN;
    public static int CHUNK_THCR;
    public static int CHUNK_THDE;
    public static int CHUNK_THST;
    public static int CHUNK_STKL;
    private static DdmHandleThread mInstance;

    private void $$robo$$android_ddm_DdmHandleThread$__constructor__() {
    }

    private static final void $$robo$$android_ddm_DdmHandleThread$register() {
        DdmServer.registerHandler(CHUNK_THEN, mInstance);
        DdmServer.registerHandler(CHUNK_THST, mInstance);
        DdmServer.registerHandler(CHUNK_STKL, mInstance);
    }

    private final void $$robo$$android_ddm_DdmHandleThread$connected() {
    }

    private final void $$robo$$android_ddm_DdmHandleThread$disconnected() {
    }

    private final Chunk $$robo$$android_ddm_DdmHandleThread$handleChunk(Chunk request) {
        int type = request.type;
        if (type == CHUNK_THEN) {
            return this.handleTHEN(request);
        }
        if (type == CHUNK_THST) {
            return this.handleTHST(request);
        }
        if (type == CHUNK_STKL) {
            return this.handleSTKL(request);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name(type));
    }

    private final Chunk $$robo$$android_ddm_DdmHandleThread$handleTHEN(Chunk request) {
        ByteBuffer in = DdmHandleThread.wrapChunk(request);
        boolean enable = in.get() != 0;
        DdmVmInternal.threadNotify(enable);
        return null;
    }

    private final Chunk $$robo$$android_ddm_DdmHandleThread$handleTHST(Chunk request) {
        ByteBuffer in = DdmHandleThread.wrapChunk(request);
        byte[] status = DdmVmInternal.getThreadStats();
        if (status != null) {
            return new Chunk(CHUNK_THST, status, 0, status.length);
        }
        return DdmHandleThread.createFailChunk(1, "Can't build THST chunk");
    }

    private final Chunk $$robo$$android_ddm_DdmHandleThread$handleSTKL(Chunk request) {
        ByteBuffer in = DdmHandleThread.wrapChunk(request);
        int threadId = in.getInt();
        StackTraceElement[] trace = DdmVmInternal.getStackTraceById(threadId);
        if (trace == null) {
            return DdmHandleThread.createFailChunk(1, "Stack trace unavailable");
        }
        return this.createStackChunk(trace, threadId);
    }

    private final Chunk $$robo$$android_ddm_DdmHandleThread$createStackChunk(StackTraceElement[] trace, int threadId) {
        int bufferSize = 0;
        bufferSize += 4;
        bufferSize += 4;
        bufferSize += 4;
        for (StackTraceElement elem : trace) {
            bufferSize += 4 + elem.getClassName().length() * 2;
            bufferSize += 4 + elem.getMethodName().length() * 2;
            bufferSize += 4;
            if (elem.getFileName() != null) {
                bufferSize += elem.getFileName().length() * 2;
            }
            bufferSize += 4;
        }
        ByteBuffer out = ByteBuffer.allocate(bufferSize);
        out.putInt(0);
        out.putInt(threadId);
        out.putInt(trace.length);
        for (StackTraceElement elem : trace) {
            out.putInt(elem.getClassName().length());
            DdmHandleThread.putString(out, elem.getClassName());
            out.putInt(elem.getMethodName().length());
            DdmHandleThread.putString(out, elem.getMethodName());
            if (elem.getFileName() != null) {
                out.putInt(elem.getFileName().length());
                DdmHandleThread.putString(out, elem.getFileName());
            } else {
                out.putInt(0);
            }
            out.putInt(elem.getLineNumber());
        }
        return new Chunk(CHUNK_STKL, out);
    }

    static void __staticInitializer__() {
        CHUNK_THEN = DdmHandleThread.type("THEN");
        CHUNK_THCR = DdmHandleThread.type("THCR");
        CHUNK_THDE = DdmHandleThread.type("THDE");
        CHUNK_THST = DdmHandleThread.type("THST");
        CHUNK_STKL = DdmHandleThread.type("STKL");
        mInstance = new DdmHandleThread();
    }

    private void __constructor__() {
        this.$$robo$$android_ddm_DdmHandleThread$__constructor__();
    }

    public DdmHandleThread() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_ddm_DdmHandleThread$__constructor__(), this);
    }

    public static void register() {
        InvokeDynamicSupport.bootstrapStatic("register", $$robo$$android_ddm_DdmHandleThread$register());
    }

    @Override
    public void connected() {
        InvokeDynamicSupport.bootstrap("connected", $$robo$$android_ddm_DdmHandleThread$connected(), this);
    }

    @Override
    public void disconnected() {
        InvokeDynamicSupport.bootstrap("disconnected", $$robo$$android_ddm_DdmHandleThread$disconnected(), this);
    }

    @Override
    public Chunk handleChunk(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleChunk", $$robo$$android_ddm_DdmHandleThread$handleChunk(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleTHEN(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleTHEN", $$robo$$android_ddm_DdmHandleThread$handleTHEN(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleTHST(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleTHST", $$robo$$android_ddm_DdmHandleThread$handleTHST(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk handleSTKL(Chunk chunk) {
        return InvokeDynamicSupport.bootstrap("handleSTKL", $$robo$$android_ddm_DdmHandleThread$handleSTKL(org.apache.harmony.dalvik.ddmc.Chunk ), this, chunk);
    }

    private Chunk createStackChunk(StackTraceElement[] stackTraceElementArray, int n) {
        return InvokeDynamicSupport.bootstrap("createStackChunk", $$robo$$android_ddm_DdmHandleThread$createStackChunk(java.lang.StackTraceElement[] int ), this, stackTraceElementArray, n);
    }

    static {
        RobolectricInternals.classInitializing(DdmHandleThread.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DdmHandleThread)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

