/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLFrame;
import android.filterfw.core.NativeBuffer;
import android.filterfw.core.SimpleFrame;
import android.graphics.Bitmap;
import java.nio.ByteBuffer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NativeFrame
extends Frame
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int nativeFrameId;

    private void $$robo$$android_filterfw_core_NativeFrame$__constructor__(FrameFormat format, FrameManager frameManager) {
        this.nativeFrameId = -1;
        int capacity = format.getSize();
        this.nativeAllocate(capacity);
        this.setReusable(capacity != 0);
    }

    private final synchronized void $$robo$$android_filterfw_core_NativeFrame$releaseNativeAllocation() {
        this.nativeDeallocate();
        this.nativeFrameId = -1;
    }

    private final synchronized boolean $$robo$$android_filterfw_core_NativeFrame$hasNativeAllocation() {
        return this.nativeFrameId != -1;
    }

    private final int $$robo$$android_filterfw_core_NativeFrame$getCapacity() {
        return this.getNativeCapacity();
    }

    private final Object $$robo$$android_filterfw_core_NativeFrame$getObjectValue() {
        if (this.getFormat().getBaseType() != 8) {
            return this.getData();
        }
        Class structClass = this.getFormat().getObjectClass();
        if (structClass == null) {
            throw new RuntimeException("Attempting to get object data from frame that does not specify a structure object class!");
        }
        if (!NativeBuffer.class.isAssignableFrom(structClass)) {
            throw new RuntimeException("NativeFrame object class must be a subclass of NativeBuffer!");
        }
        NativeBuffer structData = null;
        try {
            structData = (NativeBuffer)structClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not instantiate new structure instance of type '" + structClass + "'!");
        }
        if (!this.getNativeBuffer(structData)) {
            throw new RuntimeException("Could not get the native structured data for frame!");
        }
        structData.attachToFrame(this);
        return structData;
    }

    private final void $$robo$$android_filterfw_core_NativeFrame$setInts(int[] ints) {
        this.assertFrameMutable();
        if (ints.length * NativeFrame.nativeIntSize() > this.getFormat().getSize()) {
            throw new RuntimeException("NativeFrame cannot hold " + ints.length + " integers. (Can only hold " + this.getFormat().getSize() / NativeFrame.nativeIntSize() + " integers).");
        }
        if (!this.setNativeInts(ints)) {
            throw new RuntimeException("Could not set int values for native frame!");
        }
    }

    private final int[] $$robo$$android_filterfw_core_NativeFrame$getInts() {
        return this.getNativeInts(this.getFormat().getSize());
    }

    private final void $$robo$$android_filterfw_core_NativeFrame$setFloats(float[] floats) {
        this.assertFrameMutable();
        if (floats.length * NativeFrame.nativeFloatSize() > this.getFormat().getSize()) {
            throw new RuntimeException("NativeFrame cannot hold " + floats.length + " floats. (Can only hold " + this.getFormat().getSize() / NativeFrame.nativeFloatSize() + " floats).");
        }
        if (!this.setNativeFloats(floats)) {
            throw new RuntimeException("Could not set int values for native frame!");
        }
    }

    private final float[] $$robo$$android_filterfw_core_NativeFrame$getFloats() {
        return this.getNativeFloats(this.getFormat().getSize());
    }

    private final void $$robo$$android_filterfw_core_NativeFrame$setData(ByteBuffer buffer, int offset, int length) {
        this.assertFrameMutable();
        byte[] bytes = buffer.array();
        if (length + offset > buffer.limit()) {
            throw new RuntimeException("Offset and length exceed buffer size in native setData: " + (length + offset) + " bytes given, but only " + buffer.limit() + " bytes available!");
        }
        if (this.getFormat().getSize() != length) {
            throw new RuntimeException("Data size in setData does not match native frame size: Frame size is " + this.getFormat().getSize() + " bytes, but " + length + " bytes given!");
        }
        if (!this.setNativeData(bytes, offset, length)) {
            throw new RuntimeException("Could not set native frame data!");
        }
    }

    private final ByteBuffer $$robo$$android_filterfw_core_NativeFrame$getData() {
        byte[] data = this.getNativeData(this.getFormat().getSize());
        return data == null ? null : ByteBuffer.wrap(data);
    }

    private final void $$robo$$android_filterfw_core_NativeFrame$setBitmap(Bitmap bitmap) {
        int bps;
        int byteCount;
        this.assertFrameMutable();
        if (this.getFormat().getNumberOfDimensions() != 2) {
            throw new RuntimeException("Attempting to set Bitmap for non 2-dimensional native frame!");
        }
        if (this.getFormat().getWidth() != bitmap.getWidth() || this.getFormat().getHeight() != bitmap.getHeight()) {
            throw new RuntimeException("Bitmap dimensions do not match native frame dimensions!");
        }
        Bitmap rgbaBitmap = NativeFrame.convertBitmapToRGBA(bitmap);
        if (!this.setNativeBitmap(rgbaBitmap, byteCount = rgbaBitmap.getByteCount(), bps = this.getFormat().getBytesPerSample())) {
            throw new RuntimeException("Could not set native frame bitmap data!");
        }
    }

    private final Bitmap $$robo$$android_filterfw_core_NativeFrame$getBitmap() {
        int bps;
        int byteCount;
        if (this.getFormat().getNumberOfDimensions() != 2) {
            throw new RuntimeException("Attempting to get Bitmap for non 2-dimensional native frame!");
        }
        Bitmap result = Bitmap.createBitmap(this.getFormat().getWidth(), this.getFormat().getHeight(), Bitmap.Config.ARGB_8888);
        if (!this.getNativeBitmap(result, byteCount = result.getByteCount(), bps = this.getFormat().getBytesPerSample())) {
            throw new RuntimeException("Could not get bitmap data from native frame!");
        }
        return result;
    }

    private final void $$robo$$android_filterfw_core_NativeFrame$setDataFromFrame(Frame frame) {
        if (this.getFormat().getSize() < frame.getFormat().getSize()) {
            throw new RuntimeException("Attempting to assign frame of size " + frame.getFormat().getSize() + " to smaller native frame of size " + this.getFormat().getSize() + "!");
        }
        if (frame instanceof NativeFrame) {
            this.nativeCopyFromNative((NativeFrame)frame);
        } else if (frame instanceof GLFrame) {
            this.nativeCopyFromGL((GLFrame)frame);
        } else if (frame instanceof SimpleFrame) {
            this.setObjectValue(frame.getObjectValue());
        } else {
            super.setDataFromFrame(frame);
        }
    }

    private final String $$robo$$android_filterfw_core_NativeFrame$toString() {
        return "NativeFrame id: " + this.nativeFrameId + " (" + this.getFormat() + ") of size " + this.getCapacity();
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$nativeAllocate(int n) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$nativeDeallocate() {
        return false;
    }

    private final int $$robo$$android_filterfw_core_NativeFrame$getNativeCapacity() {
        return 0;
    }

    private static final int $$robo$$android_filterfw_core_NativeFrame$nativeIntSize() {
        return 0;
    }

    private static final int $$robo$$android_filterfw_core_NativeFrame$nativeFloatSize() {
        return 0;
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$setNativeData(byte[] byArray, int n, int n2) {
        return false;
    }

    private final byte[] $$robo$$android_filterfw_core_NativeFrame$getNativeData(int n) {
        return null;
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$getNativeBuffer(NativeBuffer nativeBuffer) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$setNativeInts(int[] nArray) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$setNativeFloats(float[] fArray) {
        return false;
    }

    private final int[] $$robo$$android_filterfw_core_NativeFrame$getNativeInts(int n) {
        return null;
    }

    private final float[] $$robo$$android_filterfw_core_NativeFrame$getNativeFloats(int n) {
        return null;
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$setNativeBitmap(Bitmap bitmap, int n, int n2) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$getNativeBitmap(Bitmap bitmap, int n, int n2) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$nativeCopyFromNative(NativeFrame nativeFrame) {
        return false;
    }

    private final boolean $$robo$$android_filterfw_core_NativeFrame$nativeCopyFromGL(GLFrame gLFrame) {
        return false;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"filterfw");
    }

    private void __constructor__(FrameFormat frameFormat, FrameManager frameManager) {
        this.$$robo$$android_filterfw_core_NativeFrame$__constructor__(frameFormat, frameManager);
    }

    public NativeFrame(FrameFormat frameFormat, FrameManager frameManager) {
        super(frameFormat, frameManager);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterfw_core_NativeFrame$__constructor__(android.filterfw.core.FrameFormat android.filterfw.core.FrameManager ), this, frameFormat, frameManager);
    }

    @Override
    protected synchronized void releaseNativeAllocation() {
        InvokeDynamicSupport.bootstrap("releaseNativeAllocation", $$robo$$android_filterfw_core_NativeFrame$releaseNativeAllocation(), this);
    }

    @Override
    protected synchronized boolean hasNativeAllocation() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNativeAllocation", $$robo$$android_filterfw_core_NativeFrame$hasNativeAllocation(), this);
    }

    @Override
    public int getCapacity() {
        return (int)InvokeDynamicSupport.bootstrap("getCapacity", $$robo$$android_filterfw_core_NativeFrame$getCapacity(), this);
    }

    @Override
    public Object getObjectValue() {
        return InvokeDynamicSupport.bootstrap("getObjectValue", $$robo$$android_filterfw_core_NativeFrame$getObjectValue(), this);
    }

    @Override
    public void setInts(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setInts", $$robo$$android_filterfw_core_NativeFrame$setInts(int[] ), this, nArray);
    }

    @Override
    public int[] getInts() {
        return InvokeDynamicSupport.bootstrap("getInts", $$robo$$android_filterfw_core_NativeFrame$getInts(), this);
    }

    @Override
    public void setFloats(float[] fArray) {
        InvokeDynamicSupport.bootstrap("setFloats", $$robo$$android_filterfw_core_NativeFrame$setFloats(float[] ), this, fArray);
    }

    @Override
    public float[] getFloats() {
        return InvokeDynamicSupport.bootstrap("getFloats", $$robo$$android_filterfw_core_NativeFrame$getFloats(), this);
    }

    @Override
    public void setData(ByteBuffer byteBuffer, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setData", $$robo$$android_filterfw_core_NativeFrame$setData(java.nio.ByteBuffer int int ), this, byteBuffer, n, n2);
    }

    @Override
    public ByteBuffer getData() {
        return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_filterfw_core_NativeFrame$getData(), this);
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_filterfw_core_NativeFrame$setBitmap(android.graphics.Bitmap ), this, bitmap);
    }

    @Override
    public Bitmap getBitmap() {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_filterfw_core_NativeFrame$getBitmap(), this);
    }

    @Override
    public void setDataFromFrame(Frame frame) {
        InvokeDynamicSupport.bootstrap("setDataFromFrame", $$robo$$android_filterfw_core_NativeFrame$setDataFromFrame(android.filterfw.core.Frame ), this, frame);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_filterfw_core_NativeFrame$toString(), this);
    }

    private boolean nativeAllocate(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeAllocate", $$robo$$android_filterfw_core_NativeFrame$nativeAllocate(int ), this, n);
    }

    private boolean nativeDeallocate() {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeDeallocate", $$robo$$android_filterfw_core_NativeFrame$nativeDeallocate(), this);
    }

    private int getNativeCapacity() {
        return (int)InvokeDynamicSupport.bootstrap("getNativeCapacity", $$robo$$android_filterfw_core_NativeFrame$getNativeCapacity(), this);
    }

    private static int nativeIntSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeIntSize", $$robo$$android_filterfw_core_NativeFrame$nativeIntSize());
    }

    private static int nativeFloatSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeFloatSize", $$robo$$android_filterfw_core_NativeFrame$nativeFloatSize());
    }

    private boolean setNativeData(byte[] byArray, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeData", $$robo$$android_filterfw_core_NativeFrame$setNativeData(byte[] int int ), this, byArray, n, n2);
    }

    private byte[] getNativeData(int n) {
        return InvokeDynamicSupport.bootstrap("getNativeData", $$robo$$android_filterfw_core_NativeFrame$getNativeData(int ), this, n);
    }

    private boolean getNativeBuffer(NativeBuffer nativeBuffer) {
        return (boolean)InvokeDynamicSupport.bootstrap("getNativeBuffer", $$robo$$android_filterfw_core_NativeFrame$getNativeBuffer(android.filterfw.core.NativeBuffer ), this, nativeBuffer);
    }

    private boolean setNativeInts(int[] nArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeInts", $$robo$$android_filterfw_core_NativeFrame$setNativeInts(int[] ), this, nArray);
    }

    private boolean setNativeFloats(float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeFloats", $$robo$$android_filterfw_core_NativeFrame$setNativeFloats(float[] ), this, fArray);
    }

    private int[] getNativeInts(int n) {
        return InvokeDynamicSupport.bootstrap("getNativeInts", $$robo$$android_filterfw_core_NativeFrame$getNativeInts(int ), this, n);
    }

    private float[] getNativeFloats(int n) {
        return InvokeDynamicSupport.bootstrap("getNativeFloats", $$robo$$android_filterfw_core_NativeFrame$getNativeFloats(int ), this, n);
    }

    private boolean setNativeBitmap(Bitmap bitmap, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNativeBitmap", $$robo$$android_filterfw_core_NativeFrame$setNativeBitmap(android.graphics.Bitmap int int ), this, bitmap, n, n2);
    }

    private boolean getNativeBitmap(Bitmap bitmap, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getNativeBitmap", $$robo$$android_filterfw_core_NativeFrame$getNativeBitmap(android.graphics.Bitmap int int ), this, bitmap, n, n2);
    }

    private boolean nativeCopyFromNative(NativeFrame nativeFrame) {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeCopyFromNative", $$robo$$android_filterfw_core_NativeFrame$nativeCopyFromNative(android.filterfw.core.NativeFrame ), this, nativeFrame);
    }

    private boolean nativeCopyFromGL(GLFrame gLFrame) {
        return (boolean)InvokeDynamicSupport.bootstrap("nativeCopyFromGL", $$robo$$android_filterfw_core_NativeFrame$nativeCopyFromGL(android.filterfw.core.GLFrame ), this, gLFrame);
    }

    static {
        RobolectricInternals.classInitializing(NativeFrame.class);
    }

    public /* synthetic */ NativeFrame() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeFrame)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

