/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.ui;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterSurfaceView;
import android.filterfw.core.Frame;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.util.Log;
import android.view.SurfaceHolder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SurfaceRenderFilter
extends Filter
implements SurfaceHolder.Callback,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int RENDERMODE_STRETCH = 0;
    private int RENDERMODE_FIT = 1;
    private int RENDERMODE_FILL_CROP = 2;
    @GenerateFinalPort(name="surfaceView")
    private FilterSurfaceView mSurfaceView;
    @GenerateFieldPort(name="renderMode", hasDefault=true)
    private String mRenderModeString;
    private boolean mIsBound;
    private ShaderProgram mProgram;
    private GLFrame mScreen;
    private int mRenderMode;
    private float mAspectRatio;
    private int mScreenWidth;
    private int mScreenHeight;
    private boolean mLogVerbose;
    private static String TAG = "SurfaceRenderFilter";

    private void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$__constructor__(String name) {
        this.RENDERMODE_STRETCH = 0;
        this.RENDERMODE_FIT = 1;
        this.RENDERMODE_FILL_CROP = 2;
        this.mIsBound = false;
        this.mRenderMode = 1;
        this.mAspectRatio = 1.0f;
        this.mLogVerbose = Log.isLoggable("SurfaceRenderFilter", 2);
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$setupPorts() {
        if (this.mSurfaceView == null) {
            throw new RuntimeException("NULL SurfaceView passed to SurfaceRenderFilter");
        }
        this.addMaskedInputPort("frame", ImageFormat.create(3));
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$updateRenderMode() {
        if (this.mRenderModeString != null) {
            if (this.mRenderModeString.equals("stretch")) {
                this.mRenderMode = 0;
            } else if (this.mRenderModeString.equals("fit")) {
                this.mRenderMode = 1;
            } else if (this.mRenderModeString.equals("fill_crop")) {
                this.mRenderMode = 2;
            } else {
                throw new RuntimeException("Unknown render mode '" + this.mRenderModeString + "'!");
            }
        }
        this.updateTargetRect();
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$prepare(FilterContext context) {
        this.mProgram = ShaderProgram.createIdentity(context);
        this.mProgram.setSourceRect(0.0f, 1.0f, 1.0f, -1.0f);
        this.mProgram.setClearsOutput(true);
        this.mProgram.setClearColor(0.0f, 0.0f, 0.0f);
        this.updateRenderMode();
        MutableFrameFormat screenFormat = ImageFormat.create(this.mSurfaceView.getWidth(), this.mSurfaceView.getHeight(), 3, 3);
        this.mScreen = (GLFrame)context.getFrameManager().newBoundFrame(screenFormat, 101, 0L);
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$open(FilterContext context) {
        this.mSurfaceView.unbind();
        this.mSurfaceView.bindToListener(this, context.getGLEnvironment());
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$process(FilterContext context) {
        int target;
        GLEnvironment glEnv;
        if (!this.mIsBound) {
            Log.w("SurfaceRenderFilter", this + ": Ignoring frame as there is no surface to render to!");
            return;
        }
        if (this.mLogVerbose) {
            Log.v("SurfaceRenderFilter", "Starting frame processing");
        }
        if ((glEnv = this.mSurfaceView.getGLEnv()) != context.getGLEnvironment()) {
            throw new RuntimeException("Surface created under different GLEnvironment!");
        }
        Frame input = this.pullInput("frame");
        boolean createdFrame = false;
        float currentAspectRatio = (float)input.getFormat().getWidth() / (float)input.getFormat().getHeight();
        if (currentAspectRatio != this.mAspectRatio) {
            if (this.mLogVerbose) {
                Log.v("SurfaceRenderFilter", "New aspect ratio: " + currentAspectRatio + ", previously: " + this.mAspectRatio);
            }
            this.mAspectRatio = currentAspectRatio;
            this.updateTargetRect();
        }
        Frame gpuFrame = null;
        if (this.mLogVerbose) {
            Log.v("SurfaceRenderFilter", "Got input format: " + input.getFormat());
        }
        if ((target = input.getFormat().getTarget()) != 3) {
            gpuFrame = context.getFrameManager().duplicateFrameToTarget(input, 3);
            createdFrame = true;
        } else {
            gpuFrame = input;
        }
        glEnv.activateSurfaceWithId(this.mSurfaceView.getSurfaceId());
        this.mProgram.process(gpuFrame, (Frame)this.mScreen);
        glEnv.swapBuffers();
        if (createdFrame) {
            gpuFrame.release();
        }
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$fieldPortValueUpdated(String name, FilterContext context) {
        this.updateTargetRect();
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$close(FilterContext context) {
        this.mSurfaceView.unbind();
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$tearDown(FilterContext context) {
        if (this.mScreen != null) {
            this.mScreen.release();
        }
    }

    private final synchronized void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$surfaceCreated(SurfaceHolder holder) {
        this.mIsBound = true;
    }

    private final synchronized void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        if (this.mScreen != null) {
            this.mScreenWidth = width;
            this.mScreenHeight = height;
            this.mScreen.setViewport(0, 0, this.mScreenWidth, this.mScreenHeight);
            this.updateTargetRect();
        }
    }

    private final synchronized void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$surfaceDestroyed(SurfaceHolder holder) {
        this.mIsBound = false;
    }

    private final void $$robo$$android_filterpacks_ui_SurfaceRenderFilter$updateTargetRect() {
        if (this.mScreenWidth > 0 && this.mScreenHeight > 0 && this.mProgram != null) {
            float screenAspectRatio = (float)this.mScreenWidth / (float)this.mScreenHeight;
            float relativeAspectRatio = screenAspectRatio / this.mAspectRatio;
            switch (this.mRenderMode) {
                case 0: {
                    this.mProgram.setTargetRect(0.0f, 0.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    if (relativeAspectRatio > 1.0f) {
                        this.mProgram.setTargetRect(0.5f - 0.5f / relativeAspectRatio, 0.0f, 1.0f / relativeAspectRatio, 1.0f);
                        break;
                    }
                    this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * relativeAspectRatio, 1.0f, relativeAspectRatio);
                    break;
                }
                case 2: {
                    if (relativeAspectRatio > 1.0f) {
                        this.mProgram.setTargetRect(0.0f, 0.5f - 0.5f * relativeAspectRatio, 1.0f, relativeAspectRatio);
                        break;
                    }
                    this.mProgram.setTargetRect(0.5f - 0.5f / relativeAspectRatio, 0.0f, 1.0f / relativeAspectRatio, 1.0f);
                }
            }
        }
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_ui_SurfaceRenderFilter$__constructor__(string2);
    }

    public SurfaceRenderFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$__constructor__(java.lang.String ), this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$setupPorts(), this);
    }

    public void updateRenderMode() {
        InvokeDynamicSupport.bootstrap("updateRenderMode", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$updateRenderMode(), this);
    }

    @Override
    public void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$prepare(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void open(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("open", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$open(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$process(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), this, string2, filterContext);
    }

    @Override
    public void close(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$close(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("tearDown", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$tearDown(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public synchronized void surfaceCreated(SurfaceHolder surfaceHolder) {
        InvokeDynamicSupport.bootstrap("surfaceCreated", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$surfaceCreated(android.view.SurfaceHolder ), this, surfaceHolder);
    }

    @Override
    public synchronized void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("surfaceChanged", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$surfaceChanged(android.view.SurfaceHolder int int int ), this, surfaceHolder, n, n2, n3);
    }

    @Override
    public synchronized void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        InvokeDynamicSupport.bootstrap("surfaceDestroyed", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$surfaceDestroyed(android.view.SurfaceHolder ), this, surfaceHolder);
    }

    private void updateTargetRect() {
        InvokeDynamicSupport.bootstrap("updateTargetRect", $$robo$$android_filterpacks_ui_SurfaceRenderFilter$updateTargetRect(), this);
    }

    public /* synthetic */ SurfaceRenderFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceRenderFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

