/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videoproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.opengl.GLES20;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BackDropperFilter
extends Filter
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int BACKGROUND_STRETCH = 0;
    private int BACKGROUND_FIT = 1;
    private int BACKGROUND_FILL_CROP = 2;
    @GenerateFieldPort(name="backgroundFitMode", hasDefault=true)
    private int mBackgroundFitMode;
    @GenerateFieldPort(name="learningDuration", hasDefault=true)
    private int mLearningDuration;
    @GenerateFieldPort(name="learningVerifyDuration", hasDefault=true)
    private int mLearningVerifyDuration;
    @GenerateFieldPort(name="acceptStddev", hasDefault=true)
    private float mAcceptStddev;
    @GenerateFieldPort(name="hierLrgScale", hasDefault=true)
    private float mHierarchyLrgScale;
    @GenerateFieldPort(name="hierMidScale", hasDefault=true)
    private float mHierarchyMidScale;
    @GenerateFieldPort(name="hierSmlScale", hasDefault=true)
    private float mHierarchySmlScale;
    @GenerateFieldPort(name="maskWidthExp", hasDefault=true)
    private int mMaskWidthExp;
    @GenerateFieldPort(name="maskHeightExp", hasDefault=true)
    private int mMaskHeightExp;
    @GenerateFieldPort(name="hierLrgExp", hasDefault=true)
    private int mHierarchyLrgExp;
    @GenerateFieldPort(name="hierMidExp", hasDefault=true)
    private int mHierarchyMidExp;
    @GenerateFieldPort(name="hierSmlExp", hasDefault=true)
    private int mHierarchySmlExp;
    @GenerateFieldPort(name="lumScale", hasDefault=true)
    private float mLumScale;
    @GenerateFieldPort(name="chromaScale", hasDefault=true)
    private float mChromaScale;
    @GenerateFieldPort(name="maskBg", hasDefault=true)
    private float mMaskBg;
    @GenerateFieldPort(name="maskFg", hasDefault=true)
    private float mMaskFg;
    @GenerateFieldPort(name="exposureChange", hasDefault=true)
    private float mExposureChange;
    @GenerateFieldPort(name="whitebalanceredChange", hasDefault=true)
    private float mWhiteBalanceRedChange;
    @GenerateFieldPort(name="whitebalanceblueChange", hasDefault=true)
    private float mWhiteBalanceBlueChange;
    @GenerateFieldPort(name="autowbToggle", hasDefault=true)
    private int mAutoWBToggle;
    @GenerateFieldPort(name="learningAdaptRate", hasDefault=true)
    private float mAdaptRateLearning;
    @GenerateFieldPort(name="adaptRateBg", hasDefault=true)
    private float mAdaptRateBg;
    @GenerateFieldPort(name="adaptRateFg", hasDefault=true)
    private float mAdaptRateFg;
    @GenerateFieldPort(name="maskVerifyRate", hasDefault=true)
    private float mVerifyRate;
    @GenerateFieldPort(name="learningDoneListener", hasDefault=true)
    private LearningDoneListener mLearningDoneListener;
    @GenerateFieldPort(name="useTheForce", hasDefault=true)
    private boolean mUseTheForce;
    @GenerateFinalPort(name="provideDebugOutputs", hasDefault=true)
    private boolean mProvideDebugOutputs;
    @GenerateFieldPort(name="mirrorBg", hasDefault=true)
    private boolean mMirrorBg;
    @GenerateFieldPort(name="orientation", hasDefault=true)
    private int mOrientation;
    private static int DEFAULT_LEARNING_DURATION = 40;
    private static int DEFAULT_LEARNING_VERIFY_DURATION = 10;
    private static float DEFAULT_ACCEPT_STDDEV = 0.85f;
    private static float DEFAULT_HIER_LRG_SCALE = 0.7f;
    private static float DEFAULT_HIER_MID_SCALE = 0.6f;
    private static float DEFAULT_HIER_SML_SCALE = 0.5f;
    private static int DEFAULT_MASK_WIDTH_EXPONENT = 8;
    private static int DEFAULT_MASK_HEIGHT_EXPONENT = 8;
    private static int DEFAULT_HIER_LRG_EXPONENT = 3;
    private static int DEFAULT_HIER_MID_EXPONENT = 2;
    private static int DEFAULT_HIER_SML_EXPONENT = 0;
    private static float DEFAULT_Y_SCALE_FACTOR = 0.4f;
    private static float DEFAULT_UV_SCALE_FACTOR = 1.35f;
    private static float DEFAULT_MASK_BLEND_BG = 0.65f;
    private static float DEFAULT_MASK_BLEND_FG = 0.95f;
    private static float DEFAULT_EXPOSURE_CHANGE = 1.0f;
    private static float DEFAULT_WHITE_BALANCE_RED_CHANGE = 0.0f;
    private static float DEFAULT_WHITE_BALANCE_BLUE_CHANGE = 0.0f;
    private static int DEFAULT_WHITE_BALANCE_TOGGLE = 0;
    private static float DEFAULT_LEARNING_ADAPT_RATE = 0.2f;
    private static float DEFAULT_ADAPT_RATE_BG = 0.0f;
    private static float DEFAULT_ADAPT_RATE_FG = 0.0f;
    private static float DEFAULT_MASK_VERIFY_RATE = 0.25f;
    private static int DEFAULT_LEARNING_DONE_THRESHOLD = 20;
    private static float[] DEFAULT_BG_FIT_TRANSFORM;
    private static String MASK_SMOOTH_EXPONENT = "2.0";
    private static String DISTANCE_STORAGE_SCALE = "0.6";
    private static String VARIANCE_STORAGE_SCALE = "5.0";
    private static String DEFAULT_AUTO_WB_SCALE = "0.25";
    private static String MIN_VARIANCE = "3.0";
    private static String RGB_TO_YUV_MATRIX = "0.299, -0.168736,  0.5,      0.000, 0.587, -0.331264, -0.418688, 0.000, 0.114,  0.5,      -0.081312, 0.000, 0.000,  0.5,       0.5,      1.000 ";
    private static String[] mInputNames;
    private static String[] mOutputNames;
    private static String[] mDebugOutputNames;
    private FrameFormat mOutputFormat;
    private MutableFrameFormat mMemoryFormat;
    private MutableFrameFormat mMaskFormat;
    private MutableFrameFormat mAverageFormat;
    private boolean mLogVerbose;
    private static String TAG = "BackDropperFilter";
    private static String mSharedUtilShader;
    private static String mBgDistanceShader = "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform sampler2D tex_sampler_2;\nuniform float subsample_level;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 fg_rgb = texture2D(tex_sampler_0, v_texcoord, subsample_level);\n  vec4 fg = coeff_yuv * vec4(fg_rgb.rgb, 1.);\n  vec4 mean = texture2D(tex_sampler_1, v_texcoord);\n  vec4 variance = inv_var_scale * texture2D(tex_sampler_2, v_texcoord);\n\n  float dist_y = gauss_dist_y(fg.r, mean.r, variance.r);\n  float dist_uv = gauss_dist_uv(fg.gb, mean.gb, variance.gb);\n  gl_FragColor = vec4(0.5*fg.rg, dist_scale*dist_y, dist_scale*dist_uv);\n}\n";
    private static String mBgMaskShader = "uniform sampler2D tex_sampler_0;\nuniform float accept_variance;\nuniform vec2 yuv_weights;\nuniform float scale_lrg;\nuniform float scale_mid;\nuniform float scale_sml;\nuniform float exp_lrg;\nuniform float exp_mid;\nuniform float exp_sml;\nvarying vec2 v_texcoord;\nbool is_fg(vec2 dist_yc, float accept_variance) {\n  return ( dot(yuv_weights, dist_yc) >= accept_variance );\n}\nvoid main() {\n  vec4 dist_lrg_sc = texture2D(tex_sampler_0, v_texcoord, exp_lrg);\n  vec4 dist_mid_sc = texture2D(tex_sampler_0, v_texcoord, exp_mid);\n  vec4 dist_sml_sc = texture2D(tex_sampler_0, v_texcoord, exp_sml);\n  vec2 dist_lrg = inv_dist_scale * dist_lrg_sc.ba;\n  vec2 dist_mid = inv_dist_scale * dist_mid_sc.ba;\n  vec2 dist_sml = inv_dist_scale * dist_sml_sc.ba;\n  vec2 norm_dist = 0.75 * dist_sml / accept_variance;\n  bool is_fg_lrg = is_fg(dist_lrg, accept_variance * scale_lrg);\n  bool is_fg_mid = is_fg_lrg || is_fg(dist_mid, accept_variance * scale_mid);\n  float is_fg_sml =\n      float(is_fg_mid || is_fg(dist_sml, accept_variance * scale_sml));\n  float alpha = 0.5 * is_fg_sml + 0.3 * float(is_fg_mid) + 0.2 * float(is_fg_lrg);\n  gl_FragColor = vec4(alpha, norm_dist, is_fg_sml);\n}\n";
    private static String mAutomaticWhiteBalance = "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform float pyramid_depth;\nuniform bool autowb_toggle;\nvarying vec2 v_texcoord;\nvoid main() {\n   vec4 mean_video = texture2D(tex_sampler_0, v_texcoord, pyramid_depth);\n   vec4 mean_bg = texture2D(tex_sampler_1, v_texcoord, pyramid_depth);\n   float green_normalizer = mean_video.g / mean_bg.g;\n   vec4 adjusted_value = vec4(mean_bg.r / mean_video.r * green_normalizer, 1., \n                         mean_bg.b / mean_video.b * green_normalizer, 1.) * auto_wb_scale; \n   gl_FragColor = autowb_toggle ? adjusted_value : vec4(auto_wb_scale);\n}\n";
    private static String mBgSubtractShader = "uniform mat3 bg_fit_transform;\nuniform float mask_blend_bg;\nuniform float mask_blend_fg;\nuniform float exposure_change;\nuniform float whitebalancered_change;\nuniform float whitebalanceblue_change;\nuniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform sampler2D tex_sampler_2;\nuniform sampler2D tex_sampler_3;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec2 bg_texcoord = (bg_fit_transform * vec3(v_texcoord, 1.)).xy;\n  vec4 bg_rgb = texture2D(tex_sampler_1, bg_texcoord);\n  vec4 wb_auto_scale = texture2D(tex_sampler_3, v_texcoord) * exposure_change / auto_wb_scale;\n  vec4 wb_manual_scale = vec4(1. + whitebalancered_change, 1., 1. + whitebalanceblue_change, 1.);\n  vec4 fg_rgb = texture2D(tex_sampler_0, v_texcoord);\n  vec4 fg_adjusted = fg_rgb * wb_manual_scale * wb_auto_scale;\n  vec4 mask = texture2D(tex_sampler_2, v_texcoord, \n                      2.0);\n  float alpha = smoothstep(mask_blend_bg, mask_blend_fg, mask.a);\n  gl_FragColor = mix(bg_rgb, fg_adjusted, alpha);\n";
    private static String mBgSubtractForceShader = "  vec4 ghost_rgb = (fg_adjusted * 0.7 + vec4(0.3,0.3,0.4,0.))*0.65 + \n                   0.35*bg_rgb;\n  float glow_start = 0.75 * mask_blend_bg; \n  float glow_max   = mask_blend_bg; \n  gl_FragColor = mask.a < glow_start ? bg_rgb : \n                 mask.a < glow_max ? mix(bg_rgb, vec4(0.9,0.9,1.0,1.0), \n                                     (mask.a - glow_start) / (glow_max - glow_start) ) : \n                 mask.a < mask_blend_fg ? mix(vec4(0.9,0.9,1.0,1.0), ghost_rgb, \n                                    (mask.a - glow_max) / (mask_blend_fg - glow_max) ) : \n                 ghost_rgb;\n}\n";
    private static String mUpdateBgModelMeanShader = "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform sampler2D tex_sampler_2;\nuniform float subsample_level;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 fg_rgb = texture2D(tex_sampler_0, v_texcoord, subsample_level);\n  vec4 fg = coeff_yuv * vec4(fg_rgb.rgb, 1.);\n  vec4 mean = texture2D(tex_sampler_1, v_texcoord);\n  vec4 mask = texture2D(tex_sampler_2, v_texcoord, \n                      2.0);\n\n  float alpha = local_adapt_rate(mask.a);\n  vec4 new_mean = mix(mean, fg, alpha);\n  gl_FragColor = new_mean;\n}\n";
    private static String mUpdateBgModelVarianceShader = "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform sampler2D tex_sampler_2;\nuniform sampler2D tex_sampler_3;\nuniform float subsample_level;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 fg_rgb = texture2D(tex_sampler_0, v_texcoord, subsample_level);\n  vec4 fg = coeff_yuv * vec4(fg_rgb.rgb, 1.);\n  vec4 mean = texture2D(tex_sampler_1, v_texcoord);\n  vec4 variance = inv_var_scale * texture2D(tex_sampler_2, v_texcoord);\n  vec4 mask = texture2D(tex_sampler_3, v_texcoord, \n                      2.0);\n\n  float alpha = local_adapt_rate(mask.a);\n  vec4 cur_variance = (fg-mean)*(fg-mean);\n  vec4 new_variance = mix(variance, cur_variance, alpha);\n  new_variance = max(new_variance, vec4(min_variance));\n  gl_FragColor = var_scale * new_variance;\n}\n";
    private static String mMaskVerifyShader = "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform float verify_rate;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 lastmask = texture2D(tex_sampler_0, v_texcoord);\n  vec4 mask = texture2D(tex_sampler_1, v_texcoord);\n  float newmask = mix(lastmask.a, mask.a, verify_rate);\n  gl_FragColor = vec4(0., 0., 0., newmask);\n}\n";
    private ShaderProgram mBgDistProgram;
    private ShaderProgram mBgMaskProgram;
    private ShaderProgram mBgSubtractProgram;
    private ShaderProgram mBgUpdateMeanProgram;
    private ShaderProgram mBgUpdateVarianceProgram;
    private ShaderProgram mCopyOutProgram;
    private ShaderProgram mAutomaticWhiteBalanceProgram;
    private ShaderProgram mMaskVerifyProgram;
    private ShaderProgram copyShaderProgram;
    private boolean mPingPong;
    private GLFrame[] mBgMean;
    private GLFrame[] mBgVariance;
    private GLFrame[] mMaskVerify;
    private GLFrame mDistance;
    private GLFrame mAutoWB;
    private GLFrame mMask;
    private GLFrame mVideoInput;
    private GLFrame mBgInput;
    private GLFrame mMaskAverage;
    private boolean isOpen;
    private int mFrameCount;
    private boolean mStartLearning;
    private boolean mBackgroundFitModeChanged;
    private float mRelativeAspect;
    private int mPyramidDepth;
    private int mSubsampleLevel;
    private long startTime;

    private void $$robo$$android_filterpacks_videoproc_BackDropperFilter$__constructor__(String name) {
        this.BACKGROUND_STRETCH = 0;
        this.BACKGROUND_FIT = 1;
        this.BACKGROUND_FILL_CROP = 2;
        this.mBackgroundFitMode = 2;
        this.mLearningDuration = 40;
        this.mLearningVerifyDuration = 10;
        this.mAcceptStddev = 0.85f;
        this.mHierarchyLrgScale = 0.7f;
        this.mHierarchyMidScale = 0.6f;
        this.mHierarchySmlScale = 0.5f;
        this.mMaskWidthExp = 8;
        this.mMaskHeightExp = 8;
        this.mHierarchyLrgExp = 3;
        this.mHierarchyMidExp = 2;
        this.mHierarchySmlExp = 0;
        this.mLumScale = 0.4f;
        this.mChromaScale = 1.35f;
        this.mMaskBg = 0.65f;
        this.mMaskFg = 0.95f;
        this.mExposureChange = 1.0f;
        this.mWhiteBalanceRedChange = 0.0f;
        this.mWhiteBalanceBlueChange = 0.0f;
        this.mAutoWBToggle = 0;
        this.mAdaptRateLearning = 0.2f;
        this.mAdaptRateBg = 0.0f;
        this.mAdaptRateFg = 0.0f;
        this.mVerifyRate = 0.25f;
        this.mLearningDoneListener = null;
        this.mUseTheForce = false;
        this.mProvideDebugOutputs = false;
        this.mMirrorBg = false;
        this.mOrientation = 0;
        this.startTime = -1L;
        this.mLogVerbose = Log.isLoggable("BackDropperFilter", 2);
        String adjStr = SystemProperties.get("ro.media.effect.bgdropper.adj");
        if (adjStr.length() > 0) {
            try {
                this.mAcceptStddev += Float.parseFloat(adjStr);
                if (this.mLogVerbose) {
                    Log.v("BackDropperFilter", "Adjusting accept threshold by " + adjStr + ", now " + this.mAcceptStddev);
                }
            }
            catch (NumberFormatException e) {
                Log.e("BackDropperFilter", "Badly formatted property ro.media.effect.bgdropper.adj: " + adjStr);
            }
        }
    }

    private final void $$robo$$android_filterpacks_videoproc_BackDropperFilter$setupPorts() {
        MutableFrameFormat imageFormat = ImageFormat.create(3, 0);
        for (String inputName : mInputNames) {
            this.addMaskedInputPort(inputName, imageFormat);
        }
        for (String outputName : mOutputNames) {
            this.addOutputBasedOnInput(outputName, "video");
        }
        if (this.mProvideDebugOutputs) {
            for (String outputName : mDebugOutputNames) {
                this.addOutputBasedOnInput(outputName, "video");
            }
        }
    }

    private final FrameFormat $$robo$$android_filterpacks_videoproc_BackDropperFilter$getOutputFormat(String portName, FrameFormat inputFormat) {
        MutableFrameFormat format = inputFormat.mutableCopy();
        if (!Arrays.asList(mOutputNames).contains(portName)) {
            format.setDimensions(0, 0);
        }
        return format;
    }

    private final boolean $$robo$$android_filterpacks_videoproc_BackDropperFilter$createMemoryFormat(FrameFormat inputFormat) {
        if (this.mMemoryFormat != null) {
            return false;
        }
        if (inputFormat.getWidth() == 0 || inputFormat.getHeight() == 0) {
            throw new RuntimeException("Attempting to process input frame with unknown size");
        }
        this.mMaskFormat = inputFormat.mutableCopy();
        int maskWidth = (int)Math.pow(2.0, this.mMaskWidthExp);
        int maskHeight = (int)Math.pow(2.0, this.mMaskHeightExp);
        this.mMaskFormat.setDimensions(maskWidth, maskHeight);
        this.mPyramidDepth = Math.max(this.mMaskWidthExp, this.mMaskHeightExp);
        this.mMemoryFormat = this.mMaskFormat.mutableCopy();
        int widthExp = Math.max(this.mMaskWidthExp, this.pyramidLevel(inputFormat.getWidth()));
        int heightExp = Math.max(this.mMaskHeightExp, this.pyramidLevel(inputFormat.getHeight()));
        this.mPyramidDepth = Math.max(widthExp, heightExp);
        int memWidth = Math.max(maskWidth, (int)Math.pow(2.0, widthExp));
        int memHeight = Math.max(maskHeight, (int)Math.pow(2.0, heightExp));
        this.mMemoryFormat.setDimensions(memWidth, memHeight);
        this.mSubsampleLevel = this.mPyramidDepth - Math.max(this.mMaskWidthExp, this.mMaskHeightExp);
        if (this.mLogVerbose) {
            Log.v("BackDropperFilter", "Mask frames size " + maskWidth + " x " + maskHeight);
            Log.v("BackDropperFilter", "Pyramid levels " + widthExp + " x " + heightExp);
            Log.v("BackDropperFilter", "Memory frames size " + memWidth + " x " + memHeight);
        }
        this.mAverageFormat = inputFormat.mutableCopy();
        this.mAverageFormat.setDimensions(1, 1);
        return true;
    }

    private final void $$robo$$android_filterpacks_videoproc_BackDropperFilter$prepare(FilterContext context) {
        if (this.mLogVerbose) {
            Log.v("BackDropperFilter", "Preparing BackDropperFilter!");
        }
        this.mBgMean = new GLFrame[2];
        this.mBgVariance = new GLFrame[2];
        this.mMaskVerify = new GLFrame[2];
        this.copyShaderProgram = ShaderProgram.createIdentity(context);
    }

    private final void $$robo$$android_filterpacks_videoproc_BackDropperFilter$allocateFrames(FrameFormat inputFormat, FilterContext context) {
        int i;
        if (!this.createMemoryFormat(inputFormat)) {
            return;
        }
        if (this.mLogVerbose) {
            Log.v("BackDropperFilter", "Allocating BackDropperFilter frames");
        }
        int numBytes = this.mMaskFormat.getSize();
        byte[] initialBgMean = new byte[numBytes];
        byte[] initialBgVariance = new byte[numBytes];
        byte[] initialMaskVerify = new byte[numBytes];
        for (i = 0; i < numBytes; ++i) {
            initialBgMean[i] = -128;
            initialBgVariance[i] = 10;
            initialMaskVerify[i] = 0;
        }
        for (i = 0; i < 2; ++i) {
            this.mBgMean[i] = (GLFrame)context.getFrameManager().newFrame(this.mMaskFormat);
            this.mBgMean[i].setData(initialBgMean, 0, numBytes);
            this.mBgVariance[i] = (GLFrame)context.getFrameManager().newFrame(this.mMaskFormat);
            this.mBgVariance[i].setData(initialBgVariance, 0, numBytes);
            this.mMaskVerify[i] = (GLFrame)context.getFrameManager().newFrame(this.mMaskFormat);
            this.mMaskVerify[i].setData(initialMaskVerify, 0, numBytes);
        }
        if (this.mLogVerbose) {
            Log.v("BackDropperFilter", "Done allocating texture for Mean and Variance objects!");
        }
        this.mDistance = (GLFrame)context.getFrameManager().newFrame(this.mMaskFormat);
        this.mMask = (GLFrame)context.getFrameManager().newFrame(this.mMaskFormat);
        this.mAutoWB = (GLFrame)context.getFrameManager().newFrame(this.mAverageFormat);
        this.mVideoInput = (GLFrame)context.getFrameManager().newFrame(this.mMemoryFormat);
        this.mBgInput = (GLFrame)context.getFrameManager().newFrame(this.mMemoryFormat);
        this.mMaskAverage = (GLFrame)context.getFrameManager().newFrame(this.mAverageFormat);
        this.mBgDistProgram = new ShaderProgram(context, mSharedUtilShader + "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform sampler2D tex_sampler_2;\nuniform float subsample_level;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 fg_rgb = texture2D(tex_sampler_0, v_texcoord, subsample_level);\n  vec4 fg = coeff_yuv * vec4(fg_rgb.rgb, 1.);\n  vec4 mean = texture2D(tex_sampler_1, v_texcoord);\n  vec4 variance = inv_var_scale * texture2D(tex_sampler_2, v_texcoord);\n\n  float dist_y = gauss_dist_y(fg.r, mean.r, variance.r);\n  float dist_uv = gauss_dist_uv(fg.gb, mean.gb, variance.gb);\n  gl_FragColor = vec4(0.5*fg.rg, dist_scale*dist_y, dist_scale*dist_uv);\n}\n");
        this.mBgDistProgram.setHostValue("subsample_level", Float.valueOf(this.mSubsampleLevel));
        this.mBgMaskProgram = new ShaderProgram(context, mSharedUtilShader + "uniform sampler2D tex_sampler_0;\nuniform float accept_variance;\nuniform vec2 yuv_weights;\nuniform float scale_lrg;\nuniform float scale_mid;\nuniform float scale_sml;\nuniform float exp_lrg;\nuniform float exp_mid;\nuniform float exp_sml;\nvarying vec2 v_texcoord;\nbool is_fg(vec2 dist_yc, float accept_variance) {\n  return ( dot(yuv_weights, dist_yc) >= accept_variance );\n}\nvoid main() {\n  vec4 dist_lrg_sc = texture2D(tex_sampler_0, v_texcoord, exp_lrg);\n  vec4 dist_mid_sc = texture2D(tex_sampler_0, v_texcoord, exp_mid);\n  vec4 dist_sml_sc = texture2D(tex_sampler_0, v_texcoord, exp_sml);\n  vec2 dist_lrg = inv_dist_scale * dist_lrg_sc.ba;\n  vec2 dist_mid = inv_dist_scale * dist_mid_sc.ba;\n  vec2 dist_sml = inv_dist_scale * dist_sml_sc.ba;\n  vec2 norm_dist = 0.75 * dist_sml / accept_variance;\n  bool is_fg_lrg = is_fg(dist_lrg, accept_variance * scale_lrg);\n  bool is_fg_mid = is_fg_lrg || is_fg(dist_mid, accept_variance * scale_mid);\n  float is_fg_sml =\n      float(is_fg_mid || is_fg(dist_sml, accept_variance * scale_sml));\n  float alpha = 0.5 * is_fg_sml + 0.3 * float(is_fg_mid) + 0.2 * float(is_fg_lrg);\n  gl_FragColor = vec4(alpha, norm_dist, is_fg_sml);\n}\n");
        this.mBgMaskProgram.setHostValue("accept_variance", Float.valueOf(this.mAcceptStddev * this.mAcceptStddev));
        float[] yuvWeights = new float[]{this.mLumScale, this.mChromaScale};
        this.mBgMaskProgram.setHostValue("yuv_weights", yuvWeights);
        this.mBgMaskProgram.setHostValue("scale_lrg", Float.valueOf(this.mHierarchyLrgScale));
        this.mBgMaskProgram.setHostValue("scale_mid", Float.valueOf(this.mHierarchyMidScale));
        this.mBgMaskProgram.setHostValue("scale_sml", Float.valueOf(this.mHierarchySmlScale));
        this.mBgMaskProgram.setHostValue("exp_lrg", Float.valueOf(this.mSubsampleLevel + this.mHierarchyLrgExp));
        this.mBgMaskProgram.setHostValue("exp_mid", Float.valueOf(this.mSubsampleLevel + this.mHierarchyMidExp));
        this.mBgMaskProgram.setHostValue("exp_sml", Float.valueOf(this.mSubsampleLevel + this.mHierarchySmlExp));
        this.mBgSubtractProgram = this.mUseTheForce ? new ShaderProgram(context, mSharedUtilShader + "uniform mat3 bg_fit_transform;\nuniform float mask_blend_bg;\nuniform float mask_blend_fg;\nuniform float exposure_change;\nuniform float whitebalancered_change;\nuniform float whitebalanceblue_change;\nuniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform sampler2D tex_sampler_2;\nuniform sampler2D tex_sampler_3;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec2 bg_texcoord = (bg_fit_transform * vec3(v_texcoord, 1.)).xy;\n  vec4 bg_rgb = texture2D(tex_sampler_1, bg_texcoord);\n  vec4 wb_auto_scale = texture2D(tex_sampler_3, v_texcoord) * exposure_change / auto_wb_scale;\n  vec4 wb_manual_scale = vec4(1. + whitebalancered_change, 1., 1. + whitebalanceblue_change, 1.);\n  vec4 fg_rgb = texture2D(tex_sampler_0, v_texcoord);\n  vec4 fg_adjusted = fg_rgb * wb_manual_scale * wb_auto_scale;\n  vec4 mask = texture2D(tex_sampler_2, v_texcoord, \n                      2.0);\n  float alpha = smoothstep(mask_blend_bg, mask_blend_fg, mask.a);\n  gl_FragColor = mix(bg_rgb, fg_adjusted, alpha);\n" + "  vec4 ghost_rgb = (fg_adjusted * 0.7 + vec4(0.3,0.3,0.4,0.))*0.65 + \n                   0.35*bg_rgb;\n  float glow_start = 0.75 * mask_blend_bg; \n  float glow_max   = mask_blend_bg; \n  gl_FragColor = mask.a < glow_start ? bg_rgb : \n                 mask.a < glow_max ? mix(bg_rgb, vec4(0.9,0.9,1.0,1.0), \n                                     (mask.a - glow_start) / (glow_max - glow_start) ) : \n                 mask.a < mask_blend_fg ? mix(vec4(0.9,0.9,1.0,1.0), ghost_rgb, \n                                    (mask.a - glow_max) / (mask_blend_fg - glow_max) ) : \n                 ghost_rgb;\n}\n") : new ShaderProgram(context, mSharedUtilShader + "uniform mat3 bg_fit_transform;\nuniform float mask_blend_bg;\nuniform float mask_blend_fg;\nuniform float exposure_change;\nuniform float whitebalancered_change;\nuniform float whitebalanceblue_change;\nuniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform sampler2D tex_sampler_2;\nuniform sampler2D tex_sampler_3;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec2 bg_texcoord = (bg_fit_transform * vec3(v_texcoord, 1.)).xy;\n  vec4 bg_rgb = texture2D(tex_sampler_1, bg_texcoord);\n  vec4 wb_auto_scale = texture2D(tex_sampler_3, v_texcoord) * exposure_change / auto_wb_scale;\n  vec4 wb_manual_scale = vec4(1. + whitebalancered_change, 1., 1. + whitebalanceblue_change, 1.);\n  vec4 fg_rgb = texture2D(tex_sampler_0, v_texcoord);\n  vec4 fg_adjusted = fg_rgb * wb_manual_scale * wb_auto_scale;\n  vec4 mask = texture2D(tex_sampler_2, v_texcoord, \n                      2.0);\n  float alpha = smoothstep(mask_blend_bg, mask_blend_fg, mask.a);\n  gl_FragColor = mix(bg_rgb, fg_adjusted, alpha);\n" + "}\n");
        this.mBgSubtractProgram.setHostValue("bg_fit_transform", DEFAULT_BG_FIT_TRANSFORM);
        this.mBgSubtractProgram.setHostValue("mask_blend_bg", Float.valueOf(this.mMaskBg));
        this.mBgSubtractProgram.setHostValue("mask_blend_fg", Float.valueOf(this.mMaskFg));
        this.mBgSubtractProgram.setHostValue("exposure_change", Float.valueOf(this.mExposureChange));
        this.mBgSubtractProgram.setHostValue("whitebalanceblue_change", Float.valueOf(this.mWhiteBalanceBlueChange));
        this.mBgSubtractProgram.setHostValue("whitebalancered_change", Float.valueOf(this.mWhiteBalanceRedChange));
        this.mBgUpdateMeanProgram = new ShaderProgram(context, mSharedUtilShader + "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform sampler2D tex_sampler_2;\nuniform float subsample_level;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 fg_rgb = texture2D(tex_sampler_0, v_texcoord, subsample_level);\n  vec4 fg = coeff_yuv * vec4(fg_rgb.rgb, 1.);\n  vec4 mean = texture2D(tex_sampler_1, v_texcoord);\n  vec4 mask = texture2D(tex_sampler_2, v_texcoord, \n                      2.0);\n\n  float alpha = local_adapt_rate(mask.a);\n  vec4 new_mean = mix(mean, fg, alpha);\n  gl_FragColor = new_mean;\n}\n");
        this.mBgUpdateMeanProgram.setHostValue("subsample_level", Float.valueOf(this.mSubsampleLevel));
        this.mBgUpdateVarianceProgram = new ShaderProgram(context, mSharedUtilShader + "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform sampler2D tex_sampler_2;\nuniform sampler2D tex_sampler_3;\nuniform float subsample_level;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 fg_rgb = texture2D(tex_sampler_0, v_texcoord, subsample_level);\n  vec4 fg = coeff_yuv * vec4(fg_rgb.rgb, 1.);\n  vec4 mean = texture2D(tex_sampler_1, v_texcoord);\n  vec4 variance = inv_var_scale * texture2D(tex_sampler_2, v_texcoord);\n  vec4 mask = texture2D(tex_sampler_3, v_texcoord, \n                      2.0);\n\n  float alpha = local_adapt_rate(mask.a);\n  vec4 cur_variance = (fg-mean)*(fg-mean);\n  vec4 new_variance = mix(variance, cur_variance, alpha);\n  new_variance = max(new_variance, vec4(min_variance));\n  gl_FragColor = var_scale * new_variance;\n}\n");
        this.mBgUpdateVarianceProgram.setHostValue("subsample_level", Float.valueOf(this.mSubsampleLevel));
        this.mCopyOutProgram = ShaderProgram.createIdentity(context);
        this.mAutomaticWhiteBalanceProgram = new ShaderProgram(context, mSharedUtilShader + "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform float pyramid_depth;\nuniform bool autowb_toggle;\nvarying vec2 v_texcoord;\nvoid main() {\n   vec4 mean_video = texture2D(tex_sampler_0, v_texcoord, pyramid_depth);\n   vec4 mean_bg = texture2D(tex_sampler_1, v_texcoord, pyramid_depth);\n   float green_normalizer = mean_video.g / mean_bg.g;\n   vec4 adjusted_value = vec4(mean_bg.r / mean_video.r * green_normalizer, 1., \n                         mean_bg.b / mean_video.b * green_normalizer, 1.) * auto_wb_scale; \n   gl_FragColor = autowb_toggle ? adjusted_value : vec4(auto_wb_scale);\n}\n");
        this.mAutomaticWhiteBalanceProgram.setHostValue("pyramid_depth", Float.valueOf(this.mPyramidDepth));
        this.mAutomaticWhiteBalanceProgram.setHostValue("autowb_toggle", this.mAutoWBToggle);
        this.mMaskVerifyProgram = new ShaderProgram(context, mSharedUtilShader + "uniform sampler2D tex_sampler_0;\nuniform sampler2D tex_sampler_1;\nuniform float verify_rate;\nvarying vec2 v_texcoord;\nvoid main() {\n  vec4 lastmask = texture2D(tex_sampler_0, v_texcoord);\n  vec4 mask = texture2D(tex_sampler_1, v_texcoord);\n  float newmask = mix(lastmask.a, mask.a, verify_rate);\n  gl_FragColor = vec4(0., 0., 0., newmask);\n}\n");
        this.mMaskVerifyProgram.setHostValue("verify_rate", Float.valueOf(this.mVerifyRate));
        if (this.mLogVerbose) {
            Log.v("BackDropperFilter", "Shader width set to " + this.mMemoryFormat.getWidth());
        }
        this.mRelativeAspect = 1.0f;
        this.mFrameCount = 0;
        this.mStartLearning = true;
    }

    private final void $$robo$$android_filterpacks_videoproc_BackDropperFilter$process(FilterContext context) {
        Frame video = this.pullInput("video");
        Frame background = this.pullInput("background");
        this.allocateFrames(video.getFormat(), context);
        if (this.mStartLearning) {
            if (this.mLogVerbose) {
                Log.v("BackDropperFilter", "Starting learning");
            }
            this.mBgUpdateMeanProgram.setHostValue("bg_adapt_rate", Float.valueOf(this.mAdaptRateLearning));
            this.mBgUpdateMeanProgram.setHostValue("fg_adapt_rate", Float.valueOf(this.mAdaptRateLearning));
            this.mBgUpdateVarianceProgram.setHostValue("bg_adapt_rate", Float.valueOf(this.mAdaptRateLearning));
            this.mBgUpdateVarianceProgram.setHostValue("fg_adapt_rate", Float.valueOf(this.mAdaptRateLearning));
            this.mFrameCount = 0;
        }
        int inputIndex = this.mPingPong ? 0 : 1;
        int outputIndex = this.mPingPong ? 1 : 0;
        this.mPingPong = !this.mPingPong;
        this.updateBgScaling(video, background, this.mBackgroundFitModeChanged);
        this.mBackgroundFitModeChanged = false;
        this.copyShaderProgram.process(video, (Frame)this.mVideoInput);
        this.copyShaderProgram.process(background, (Frame)this.mBgInput);
        this.mVideoInput.generateMipMap();
        this.mVideoInput.setTextureParameter(10241, 9985);
        this.mBgInput.generateMipMap();
        this.mBgInput.setTextureParameter(10241, 9985);
        if (this.mStartLearning) {
            this.copyShaderProgram.process(this.mVideoInput, (Frame)this.mBgMean[inputIndex]);
            this.mStartLearning = false;
        }
        Frame[] distInputs = new Frame[]{this.mVideoInput, this.mBgMean[inputIndex], this.mBgVariance[inputIndex]};
        this.mBgDistProgram.process(distInputs, (Frame)this.mDistance);
        this.mDistance.generateMipMap();
        this.mDistance.setTextureParameter(10241, 9985);
        this.mBgMaskProgram.process(this.mDistance, (Frame)this.mMask);
        this.mMask.generateMipMap();
        this.mMask.setTextureParameter(10241, 9985);
        Frame[] autoWBInputs = new Frame[]{this.mVideoInput, this.mBgInput};
        this.mAutomaticWhiteBalanceProgram.process(autoWBInputs, (Frame)this.mAutoWB);
        if (this.mFrameCount <= this.mLearningDuration) {
            this.pushOutput("video", video);
            if (this.mFrameCount == this.mLearningDuration - this.mLearningVerifyDuration) {
                this.copyShaderProgram.process(this.mMask, (Frame)this.mMaskVerify[outputIndex]);
                this.mBgUpdateMeanProgram.setHostValue("bg_adapt_rate", Float.valueOf(this.mAdaptRateBg));
                this.mBgUpdateMeanProgram.setHostValue("fg_adapt_rate", Float.valueOf(this.mAdaptRateFg));
                this.mBgUpdateVarianceProgram.setHostValue("bg_adapt_rate", Float.valueOf(this.mAdaptRateBg));
                this.mBgUpdateVarianceProgram.setHostValue("fg_adapt_rate", Float.valueOf(this.mAdaptRateFg));
            } else if (this.mFrameCount > this.mLearningDuration - this.mLearningVerifyDuration) {
                Frame[] maskVerifyInputs = new Frame[]{this.mMaskVerify[inputIndex], this.mMask};
                this.mMaskVerifyProgram.process(maskVerifyInputs, (Frame)this.mMaskVerify[outputIndex]);
                this.mMaskVerify[outputIndex].generateMipMap();
                this.mMaskVerify[outputIndex].setTextureParameter(10241, 9985);
            }
            if (this.mFrameCount == this.mLearningDuration) {
                this.copyShaderProgram.process(this.mMaskVerify[outputIndex], (Frame)this.mMaskAverage);
                ByteBuffer mMaskAverageByteBuffer = this.mMaskAverage.getData();
                byte[] mask_average = mMaskAverageByteBuffer.array();
                int bi = mask_average[3] & 0xFF;
                if (this.mLogVerbose) {
                    Log.v("BackDropperFilter", String.format("Mask_average is %d, threshold is %d", bi, 20));
                }
                if (bi >= 20) {
                    this.mStartLearning = true;
                } else {
                    if (this.mLogVerbose) {
                        Log.v("BackDropperFilter", "Learning done");
                    }
                    if (this.mLearningDoneListener != null) {
                        this.mLearningDoneListener.onLearningDone(this);
                    }
                }
            }
        } else {
            Frame output = context.getFrameManager().newFrame(video.getFormat());
            Frame[] subtractInputs = new Frame[]{video, background, this.mMask, this.mAutoWB};
            this.mBgSubtractProgram.process(subtractInputs, output);
            this.pushOutput("video", output);
            output.release();
        }
        if (this.mFrameCount < this.mLearningDuration - this.mLearningVerifyDuration || (double)this.mAdaptRateBg > 0.0 || (double)this.mAdaptRateFg > 0.0) {
            Frame[] meanUpdateInputs = new Frame[]{this.mVideoInput, this.mBgMean[inputIndex], this.mMask};
            this.mBgUpdateMeanProgram.process(meanUpdateInputs, (Frame)this.mBgMean[outputIndex]);
            this.mBgMean[outputIndex].generateMipMap();
            this.mBgMean[outputIndex].setTextureParameter(10241, 9985);
            Frame[] varianceUpdateInputs = new Frame[]{this.mVideoInput, this.mBgMean[inputIndex], this.mBgVariance[inputIndex], this.mMask};
            this.mBgUpdateVarianceProgram.process(varianceUpdateInputs, (Frame)this.mBgVariance[outputIndex]);
            this.mBgVariance[outputIndex].generateMipMap();
            this.mBgVariance[outputIndex].setTextureParameter(10241, 9985);
        }
        if (this.mProvideDebugOutputs) {
            Frame dbg1 = context.getFrameManager().newFrame(video.getFormat());
            this.mCopyOutProgram.process(video, dbg1);
            this.pushOutput("debug1", dbg1);
            dbg1.release();
            Frame dbg2 = context.getFrameManager().newFrame(this.mMemoryFormat);
            this.mCopyOutProgram.process(this.mMask, dbg2);
            this.pushOutput("debug2", dbg2);
            dbg2.release();
        }
        ++this.mFrameCount;
        if (this.mLogVerbose && this.mFrameCount % 30 == 0) {
            if (this.startTime == -1L) {
                context.getGLEnvironment().activate();
                GLES20.glFinish();
                this.startTime = SystemClock.elapsedRealtime();
            } else {
                context.getGLEnvironment().activate();
                GLES20.glFinish();
                long endTime = SystemClock.elapsedRealtime();
                Log.v("BackDropperFilter", "Avg. frame duration: " + String.format("%.2f", (double)(endTime - this.startTime) / 30.0) + " ms. Avg. fps: " + String.format("%.2f", 1000.0 / ((double)(endTime - this.startTime) / 30.0)));
                this.startTime = endTime;
            }
        }
    }

    private final void $$robo$$android_filterpacks_videoproc_BackDropperFilter$close(FilterContext context) {
        if (this.mMemoryFormat == null) {
            return;
        }
        if (this.mLogVerbose) {
            Log.v("BackDropperFilter", "Filter Closing!");
        }
        for (int i = 0; i < 2; ++i) {
            this.mBgMean[i].release();
            this.mBgVariance[i].release();
            this.mMaskVerify[i].release();
        }
        this.mDistance.release();
        this.mMask.release();
        this.mAutoWB.release();
        this.mVideoInput.release();
        this.mBgInput.release();
        this.mMaskAverage.release();
        this.mMemoryFormat = null;
    }

    private final synchronized void $$robo$$android_filterpacks_videoproc_BackDropperFilter$relearn() {
        this.mStartLearning = true;
    }

    private final void $$robo$$android_filterpacks_videoproc_BackDropperFilter$fieldPortValueUpdated(String name, FilterContext context) {
        if (name.equals("backgroundFitMode")) {
            this.mBackgroundFitModeChanged = true;
        } else if (name.equals("acceptStddev")) {
            this.mBgMaskProgram.setHostValue("accept_variance", Float.valueOf(this.mAcceptStddev * this.mAcceptStddev));
        } else if (name.equals("hierLrgScale")) {
            this.mBgMaskProgram.setHostValue("scale_lrg", Float.valueOf(this.mHierarchyLrgScale));
        } else if (name.equals("hierMidScale")) {
            this.mBgMaskProgram.setHostValue("scale_mid", Float.valueOf(this.mHierarchyMidScale));
        } else if (name.equals("hierSmlScale")) {
            this.mBgMaskProgram.setHostValue("scale_sml", Float.valueOf(this.mHierarchySmlScale));
        } else if (name.equals("hierLrgExp")) {
            this.mBgMaskProgram.setHostValue("exp_lrg", Float.valueOf(this.mSubsampleLevel + this.mHierarchyLrgExp));
        } else if (name.equals("hierMidExp")) {
            this.mBgMaskProgram.setHostValue("exp_mid", Float.valueOf(this.mSubsampleLevel + this.mHierarchyMidExp));
        } else if (name.equals("hierSmlExp")) {
            this.mBgMaskProgram.setHostValue("exp_sml", Float.valueOf(this.mSubsampleLevel + this.mHierarchySmlExp));
        } else if (name.equals("lumScale") || name.equals("chromaScale")) {
            float[] yuvWeights = new float[]{this.mLumScale, this.mChromaScale};
            this.mBgMaskProgram.setHostValue("yuv_weights", yuvWeights);
        } else if (name.equals("maskBg")) {
            this.mBgSubtractProgram.setHostValue("mask_blend_bg", Float.valueOf(this.mMaskBg));
        } else if (name.equals("maskFg")) {
            this.mBgSubtractProgram.setHostValue("mask_blend_fg", Float.valueOf(this.mMaskFg));
        } else if (name.equals("exposureChange")) {
            this.mBgSubtractProgram.setHostValue("exposure_change", Float.valueOf(this.mExposureChange));
        } else if (name.equals("whitebalanceredChange")) {
            this.mBgSubtractProgram.setHostValue("whitebalancered_change", Float.valueOf(this.mWhiteBalanceRedChange));
        } else if (name.equals("whitebalanceblueChange")) {
            this.mBgSubtractProgram.setHostValue("whitebalanceblue_change", Float.valueOf(this.mWhiteBalanceBlueChange));
        } else if (name.equals("autowbToggle")) {
            this.mAutomaticWhiteBalanceProgram.setHostValue("autowb_toggle", this.mAutoWBToggle);
        }
    }

    private final void $$robo$$android_filterpacks_videoproc_BackDropperFilter$updateBgScaling(Frame video, Frame background, boolean fitModeChanged) {
        float backgroundAspect;
        float foregroundAspect = (float)video.getFormat().getWidth() / (float)video.getFormat().getHeight();
        float currentRelativeAspect = foregroundAspect / (backgroundAspect = (float)background.getFormat().getWidth() / (float)background.getFormat().getHeight());
        if (currentRelativeAspect != this.mRelativeAspect || fitModeChanged) {
            this.mRelativeAspect = currentRelativeAspect;
            float xMin = 0.0f;
            float xWidth = 1.0f;
            float yMin = 0.0f;
            float yWidth = 1.0f;
            switch (this.mBackgroundFitMode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.mRelativeAspect > 1.0f) {
                        xMin = 0.5f - 0.5f * this.mRelativeAspect;
                        xWidth = 1.0f * this.mRelativeAspect;
                        break;
                    }
                    yMin = 0.5f - 0.5f / this.mRelativeAspect;
                    yWidth = 1.0f / this.mRelativeAspect;
                    break;
                }
                case 2: {
                    if (this.mRelativeAspect > 1.0f) {
                        yMin = 0.5f - 0.5f / this.mRelativeAspect;
                        yWidth = 1.0f / this.mRelativeAspect;
                        break;
                    }
                    xMin = 0.5f - 0.5f * this.mRelativeAspect;
                    xWidth = this.mRelativeAspect;
                }
            }
            if (this.mMirrorBg) {
                if (this.mLogVerbose) {
                    Log.v("BackDropperFilter", "Mirroring the background!");
                }
                if (this.mOrientation == 0 || this.mOrientation == 180) {
                    xWidth = -xWidth;
                    xMin = 1.0f - xMin;
                } else {
                    yWidth = -yWidth;
                    yMin = 1.0f - yMin;
                }
            }
            if (this.mLogVerbose) {
                Log.v("BackDropperFilter", "bgTransform: xMin, yMin, xWidth, yWidth : " + xMin + ", " + yMin + ", " + xWidth + ", " + yWidth + ", mRelAspRatio = " + this.mRelativeAspect);
            }
            float[] bgTransform = new float[]{xWidth, 0.0f, 0.0f, 0.0f, yWidth, 0.0f, xMin, yMin, 1.0f};
            this.mBgSubtractProgram.setHostValue("bg_fit_transform", bgTransform);
        }
    }

    private final int $$robo$$android_filterpacks_videoproc_BackDropperFilter$pyramidLevel(int size) {
        return (int)Math.floor(Math.log10(size) / Math.log10(2.0)) - 1;
    }

    static void __staticInitializer__() {
        DEFAULT_BG_FIT_TRANSFORM = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        mInputNames = new String[]{"video", "background"};
        mOutputNames = new String[]{"video"};
        mDebugOutputNames = new String[]{"debug1", "debug2"};
        mSharedUtilShader = "precision mediump float;\nuniform float fg_adapt_rate;\nuniform float bg_adapt_rate;\nconst mat4 coeff_yuv = mat4(0.299, -0.168736,  0.5,      0.000, 0.587, -0.331264, -0.418688, 0.000, 0.114,  0.5,      -0.081312, 0.000, 0.000,  0.5,       0.5,      1.000 );\nconst float dist_scale = 0.6;\nconst float inv_dist_scale = 1. / dist_scale;\nconst float var_scale=5.0;\nconst float inv_var_scale = 1. / var_scale;\nconst float min_variance = inv_var_scale *3.0/ 256.;\nconst float auto_wb_scale = 0.25;\n\nfloat gauss_dist_y(float y, float mean, float variance) {\n  float dist = (y - mean) * (y - mean) / variance;\n  return dist;\n}\nfloat gauss_dist_uv(vec2 uv, vec2 mean, vec2 variance) {\n  vec2 dist = (uv - mean) * (uv - mean) / variance;\n  return dist.r + dist.g;\n}\nfloat local_adapt_rate(float alpha) {\n  return mix(bg_adapt_rate, fg_adapt_rate, alpha);\n}\n\n";
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_filterpacks_videoproc_BackDropperFilter$__constructor__(string2);
    }

    public BackDropperFilter(String string2) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_filterpacks_videoproc_BackDropperFilter$__constructor__(java.lang.String ), this, string2);
    }

    @Override
    public void setupPorts() {
        InvokeDynamicSupport.bootstrap("setupPorts", $$robo$$android_filterpacks_videoproc_BackDropperFilter$setupPorts(), this);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return InvokeDynamicSupport.bootstrap("getOutputFormat", $$robo$$android_filterpacks_videoproc_BackDropperFilter$getOutputFormat(java.lang.String android.filterfw.core.FrameFormat ), this, string2, frameFormat);
    }

    private boolean createMemoryFormat(FrameFormat frameFormat) {
        return (boolean)InvokeDynamicSupport.bootstrap("createMemoryFormat", $$robo$$android_filterpacks_videoproc_BackDropperFilter$createMemoryFormat(android.filterfw.core.FrameFormat ), this, frameFormat);
    }

    @Override
    public void prepare(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("prepare", $$robo$$android_filterpacks_videoproc_BackDropperFilter$prepare(android.filterfw.core.FilterContext ), this, filterContext);
    }

    private void allocateFrames(FrameFormat frameFormat, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("allocateFrames", $$robo$$android_filterpacks_videoproc_BackDropperFilter$allocateFrames(android.filterfw.core.FrameFormat android.filterfw.core.FilterContext ), this, frameFormat, filterContext);
    }

    @Override
    public void process(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("process", $$robo$$android_filterpacks_videoproc_BackDropperFilter$process(android.filterfw.core.FilterContext ), this, filterContext);
    }

    @Override
    public void close(FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_filterpacks_videoproc_BackDropperFilter$close(android.filterfw.core.FilterContext ), this, filterContext);
    }

    public synchronized void relearn() {
        InvokeDynamicSupport.bootstrap("relearn", $$robo$$android_filterpacks_videoproc_BackDropperFilter$relearn(), this);
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        InvokeDynamicSupport.bootstrap("fieldPortValueUpdated", $$robo$$android_filterpacks_videoproc_BackDropperFilter$fieldPortValueUpdated(java.lang.String android.filterfw.core.FilterContext ), this, string2, filterContext);
    }

    private void updateBgScaling(Frame frame, Frame frame2, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateBgScaling", $$robo$$android_filterpacks_videoproc_BackDropperFilter$updateBgScaling(android.filterfw.core.Frame android.filterfw.core.Frame boolean ), this, frame, frame2, bl);
    }

    private int pyramidLevel(int n) {
        return (int)InvokeDynamicSupport.bootstrap("pyramidLevel", $$robo$$android_filterpacks_videoproc_BackDropperFilter$pyramidLevel(int ), this, n);
    }

    static {
        RobolectricInternals.classInitializing(BackDropperFilter.class);
    }

    public /* synthetic */ BackDropperFilter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackDropperFilter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface LearningDoneListener {
        public void onLearningDone(BackDropperFilter var1);
    }
}

