/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ComposeShader;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.PrecomputedText;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BaseCanvas
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected long mNativeCanvasWrapper;
    protected int mScreenDensity;
    protected int mDensity;
    private boolean mAllowHwBitmapsInSwMode;

    private void $$robo$$android_graphics_BaseCanvas$__constructor__() {
        this.mScreenDensity = 0;
        this.mDensity = 0;
        this.mAllowHwBitmapsInSwMode = false;
    }

    private final void $$robo$$android_graphics_BaseCanvas$throwIfCannotDraw(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
        if (!bitmap.isPremultiplied() && bitmap.getConfig() == Bitmap.Config.ARGB_8888 && bitmap.hasAlpha()) {
            throw new RuntimeException("Canvas: trying to use a non-premultiplied bitmap " + bitmap);
        }
        this.throwIfHwBitmapInSwMode(bitmap);
    }

    private static final void $$robo$$android_graphics_BaseCanvas$checkRange(int length, int offset, int count) {
        if ((offset | count) < 0 || offset + count > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private final boolean $$robo$$android_graphics_BaseCanvas$isHardwareAccelerated() {
        return false;
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawArc(float left, float top, float right, float bottom, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawArc(this.mNativeCanvasWrapper, left, top, right, bottom, startAngle, sweepAngle, useCenter, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        this.drawArc(oval.left, oval.top, oval.right, oval.bottom, startAngle, sweepAngle, useCenter, paint);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawARGB(int a, int r, int g, int b) {
        this.drawColor(Color.argb(a, r, g, b));
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, paint != null ? paint.getNativeInstance() : 0L, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawBitmapMatrix(this.mNativeCanvasWrapper, bitmap, matrix.ni(), paint != null ? paint.getNativeInstance() : 0L);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        int bottom;
        int right;
        int left;
        int top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwBitmapInSwMode(paint);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0;
            left = 0;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        BaseCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        float bottom;
        float right;
        float left;
        float top;
        long nativePaint;
        if (dst == null) {
            throw new NullPointerException();
        }
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwBitmapInSwMode(paint);
        long l = nativePaint = paint == null ? 0L : paint.getNativeInstance();
        if (src == null) {
            top = 0.0f;
            left = 0.0f;
            right = bitmap.getWidth();
            bottom = bitmap.getHeight();
        } else {
            left = src.left;
            right = src.right;
            top = src.top;
            bottom = src.bottom;
        }
        BaseCanvas.nDrawBitmap(this.mNativeCanvasWrapper, bitmap, left, top, right, bottom, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mScreenDensity, bitmap.mDensity);
    }

    @Deprecated
    private final void $$robo$$android_graphics_BaseCanvas$drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        if (width == 0 || height == 0) {
            return;
        }
        BaseCanvas.nDrawBitmap(this.mNativeCanvasWrapper, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.getNativeInstance() : 0L);
    }

    @Deprecated
    private final void $$robo$$android_graphics_BaseCanvas$drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        BaseCanvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            BaseCanvas.checkRange(colors.length, colorOffset, count);
        }
        BaseCanvas.nDrawBitmapMesh(this.mNativeCanvasWrapper, bitmap, meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.getNativeInstance() : 0L);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawCircle(float cx, float cy, float radius, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx, cy, radius, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawColor(int color2) {
        BaseCanvas.nDrawColor(this.mNativeCanvasWrapper, color2, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawColor(int color2, PorterDuff.Mode mode) {
        BaseCanvas.nDrawColor(this.mNativeCanvasWrapper, color2, mode.nativeInt);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawLine(this.mNativeCanvasWrapper, startX, startY, stopX, stopY, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawLines(float[] pts, int offset, int count, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawLines(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawLines(float[] pts, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        this.drawLines(pts, 0, pts.length, paint);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawOval(float left, float top, float right, float bottom, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawOval(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawOval(RectF oval, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        this.drawOval(oval.left, oval.top, oval.right, oval.bottom, paint);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawPaint(Paint paint) {
        BaseCanvas.nDrawPaint(this.mNativeCanvasWrapper, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwBitmapInSwMode(paint);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        BaseCanvas.nDrawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        this.throwIfCannotDraw(bitmap);
        this.throwIfHasHwBitmapInSwMode(paint);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        BaseCanvas.nDrawNinePatch(this.mNativeCanvasWrapper, bitmap.getNativeInstance(), patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint, this.mDensity, patch.getDensity());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawPath(Path path, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        if (path.isSimplePath && path.rects != null) {
            BaseCanvas.nDrawRegion(this.mNativeCanvasWrapper, path.rects.mNativeRegion, paint.getNativeInstance());
        } else {
            BaseCanvas.nDrawPath(this.mNativeCanvasWrapper, path.readOnlyNI(), paint.getNativeInstance());
        }
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawPoint(float x, float y, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawPoint(this.mNativeCanvasWrapper, x, y, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawPoints(float[] pts, int offset, int count, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawPoints(this.mNativeCanvasWrapper, pts, offset, count, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawPoints(float[] pts, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        this.drawPoints(pts, 0, pts.length, paint);
    }

    @Deprecated
    private final void $$robo$$android_graphics_BaseCanvas$drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        for (int i = 0; i < count; ++i) {
            this.drawText(text, index + i, 1, pos[i * 2], pos[i * 2 + 1], paint);
        }
    }

    @Deprecated
    private final void $$robo$$android_graphics_BaseCanvas$drawPosText(String text, float[] pos, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        this.drawPosText(text.toCharArray(), 0, text.length(), pos, paint);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawRect(float left, float top, float right, float bottom, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawRect(this.mNativeCanvasWrapper, left, top, right, bottom, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawRect(Rect r, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawRect(RectF rect, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawRGB(int r, int g, int b) {
        this.drawColor(Color.rgb(r, g, b));
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawRoundRect(float left, float top, float right, float bottom, float rx, float ry, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left, top, right, bottom, rx, ry, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        this.drawRoundRect(rect.left, rect.top, rect.right, rect.bottom, rx, ry, paint);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawText(this.mNativeCanvasWrapper, text, index, count, x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            BaseCanvas.nDrawText(this.mNativeCanvasWrapper, text.toString(), start, end, x, y, paint.mBidiFlags, paint.getNativeInstance());
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            BaseCanvas.nDrawText(this.mNativeCanvasWrapper, buf, 0, end - start, x, y, paint.mBidiFlags, paint.getNativeInstance());
            TemporaryBuffer.recycle(buf);
        }
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawText(String text, float x, float y, Paint paint) {
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawText(this.mNativeCanvasWrapper, text, 0, text.length(), x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawText(this.mNativeCanvasWrapper, text, start, end, x, y, paint.mBidiFlags, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawTextOnPath(this.mNativeCanvasWrapper, text, index, count, path.readOnlyNI(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() > 0) {
            this.throwIfHasHwBitmapInSwMode(paint);
            BaseCanvas.nDrawTextOnPath(this.mNativeCanvasWrapper, text, path.readOnlyNI(), hOffset, vOffset, paint.mBidiFlags, paint.getNativeInstance());
        }
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((index | count | contextIndex | contextCount | index - contextIndex | contextIndex + contextCount - (index + count) | text.length - (contextIndex + contextCount)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawTextRun(this.mNativeCanvasWrapper, text, index, count, contextIndex, contextCount, x, y, isRtl, paint.getNativeInstance(), 0L);
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, boolean isRtl, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((start | end | contextStart | contextEnd | start - contextStart | end - start | contextEnd - end | text.length() - contextEnd) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            BaseCanvas.nDrawTextRun(this.mNativeCanvasWrapper, text.toString(), start, end, contextStart, contextEnd, x, y, isRtl, paint.getNativeInstance());
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, isRtl, paint);
        } else {
            int paraIndex;
            PrecomputedText mt;
            int contextLen = contextEnd - contextStart;
            int len = end - start;
            char[] buf = TemporaryBuffer.obtain(contextLen);
            TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
            long measuredTextPtr = 0L;
            if (text instanceof PrecomputedText && end <= (mt = (PrecomputedText)text).getParagraphEnd(paraIndex = mt.findParaIndex(start))) {
                measuredTextPtr = mt.getMeasuredParagraph(paraIndex).getNativePtr();
            }
            BaseCanvas.nDrawTextRun(this.mNativeCanvasWrapper, buf, start - contextStart, len, 0, contextLen, x, y, isRtl, paint.getNativeInstance(), measuredTextPtr);
            TemporaryBuffer.recycle(buf);
        }
    }

    private final void $$robo$$android_graphics_BaseCanvas$drawVertices(Canvas.VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        BaseCanvas.checkRange(verts.length, vertOffset, vertexCount);
        if (this.isHardwareAccelerated()) {
            return;
        }
        if (texs != null) {
            BaseCanvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            BaseCanvas.checkRange(colors.length, colorOffset, vertexCount / 2);
        }
        if (indices != null) {
            BaseCanvas.checkRange(indices.length, indexOffset, indexCount);
        }
        this.throwIfHasHwBitmapInSwMode(paint);
        BaseCanvas.nDrawVertices(this.mNativeCanvasWrapper, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.getNativeInstance());
    }

    private final void $$robo$$android_graphics_BaseCanvas$setHwBitmapsInSwModeEnabled(boolean enabled) {
        this.mAllowHwBitmapsInSwMode = enabled;
    }

    private final boolean $$robo$$android_graphics_BaseCanvas$isHwBitmapsInSwModeEnabled() {
        return this.mAllowHwBitmapsInSwMode;
    }

    private final void $$robo$$android_graphics_BaseCanvas$onHwBitmapInSwMode() {
        if (!this.mAllowHwBitmapsInSwMode) {
            throw new IllegalArgumentException("Software rendering doesn't support hardware bitmaps");
        }
    }

    private final void $$robo$$android_graphics_BaseCanvas$throwIfHwBitmapInSwMode(Bitmap bitmap) {
        if (!this.isHardwareAccelerated() && bitmap.getConfig() == Bitmap.Config.HARDWARE) {
            this.onHwBitmapInSwMode();
        }
    }

    private final void $$robo$$android_graphics_BaseCanvas$throwIfHasHwBitmapInSwMode(Paint p) {
        if (this.isHardwareAccelerated() || p == null) {
            return;
        }
        this.throwIfHasHwBitmapInSwMode(p.getShader());
    }

    private final void $$robo$$android_graphics_BaseCanvas$throwIfHasHwBitmapInSwMode(Shader shader) {
        if (shader == null) {
            return;
        }
        if (shader instanceof BitmapShader) {
            this.throwIfHwBitmapInSwMode(((BitmapShader)shader).mBitmap);
        }
        if (shader instanceof ComposeShader) {
            this.throwIfHasHwBitmapInSwMode(((ComposeShader)shader).mShaderA);
            this.throwIfHasHwBitmapInSwMode(((ComposeShader)shader).mShaderB);
        }
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawBitmap(long l, Bitmap bitmap, float f, float f2, long l2, int n, int n2, int n3) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawBitmap(long l, Bitmap bitmap, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, long l2, int n, int n2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawBitmap(long l, int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawColor(long l, int n, int n2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawPaint(long l, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawPoint(long l, float f, float f2, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawPoints(long l, float[] fArray, int n, int n2, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawLine(long l, float f, float f2, float f3, float f4, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawLines(long l, float[] fArray, int n, int n2, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawRect(long l, float f, float f2, float f3, float f4, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawOval(long l, float f, float f2, float f3, float f4, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawCircle(long l, float f, float f2, float f3, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawArc(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawPath(long l, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawRegion(long l, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawNinePatch(long l, long l2, long l3, float f, float f2, float f3, float f4, long l4, int n, int n2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawBitmapMatrix(long l, Bitmap bitmap, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawBitmapMesh(long l, Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawVertices(long l, int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int[] nArray, int n5, short[] sArray, int n6, int n7, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawText(long l, char[] cArray, int n, int n2, float f, float f2, int n3, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawText(long l, String string2, int n, int n2, float f, float f2, int n3, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawTextRun(long l, String string2, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawTextRun(long l, char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawTextOnPath(long l, char[] cArray, int n, int n2, long l2, float f, float f2, int n3, long l3) {
    }

    private static final void $$robo$$android_graphics_BaseCanvas$nDrawTextOnPath(long l, String string2, long l2, float f, float f2, int n, long l3) {
    }

    private void __constructor__() {
        this.$$robo$$android_graphics_BaseCanvas$__constructor__();
    }

    public BaseCanvas() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_graphics_BaseCanvas$__constructor__(), this);
    }

    protected void throwIfCannotDraw(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("throwIfCannotDraw", $$robo$$android_graphics_BaseCanvas$throwIfCannotDraw(android.graphics.Bitmap ), this, bitmap);
    }

    protected static void checkRange(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("checkRange", $$robo$$android_graphics_BaseCanvas$checkRange(int int int ), (int)n, (int)n2, (int)n3);
    }

    public boolean isHardwareAccelerated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareAccelerated", $$robo$$android_graphics_BaseCanvas$isHardwareAccelerated(), this);
    }

    public void drawArc(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawArc", $$robo$$android_graphics_BaseCanvas$drawArc(float float float float float float boolean android.graphics.Paint ), this, f, f2, f3, f4, f5, f6, bl, paint);
    }

    public void drawArc(RectF rectF, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawArc", $$robo$$android_graphics_BaseCanvas$drawArc(android.graphics.RectF float float boolean android.graphics.Paint ), this, rectF, f, f2, bl, paint);
    }

    public void drawARGB(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("drawARGB", $$robo$$android_graphics_BaseCanvas$drawARGB(int int int int ), this, n, n2, n3, n4);
    }

    public void drawBitmap(Bitmap bitmap, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_BaseCanvas$drawBitmap(android.graphics.Bitmap float float android.graphics.Paint ), this, bitmap, f, f2, paint);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_BaseCanvas$drawBitmap(android.graphics.Bitmap android.graphics.Matrix android.graphics.Paint ), this, bitmap, matrix, paint);
    }

    public void drawBitmap(Bitmap bitmap, Rect rect, Rect rect2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_BaseCanvas$drawBitmap(android.graphics.Bitmap android.graphics.Rect android.graphics.Rect android.graphics.Paint ), this, bitmap, rect, rect2, paint);
    }

    public void drawBitmap(Bitmap bitmap, Rect rect, RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_BaseCanvas$drawBitmap(android.graphics.Bitmap android.graphics.Rect android.graphics.RectF android.graphics.Paint ), this, bitmap, rect, rectF, paint);
    }

    @Deprecated
    public void drawBitmap(int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_BaseCanvas$drawBitmap(int[] int int float float int int boolean android.graphics.Paint ), this, nArray, n, n2, f, f2, n3, n4, bl, paint);
    }

    @Deprecated
    public void drawBitmap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmap", $$robo$$android_graphics_BaseCanvas$drawBitmap(int[] int int int int int int boolean android.graphics.Paint ), this, nArray, n, n2, n3, n4, n5, n6, bl, paint);
    }

    public void drawBitmapMesh(Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawBitmapMesh", $$robo$$android_graphics_BaseCanvas$drawBitmapMesh(android.graphics.Bitmap int int float[] int int[] int android.graphics.Paint ), this, bitmap, n, n2, fArray, n3, nArray, n4, paint);
    }

    public void drawCircle(float f, float f2, float f3, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawCircle", $$robo$$android_graphics_BaseCanvas$drawCircle(float float float android.graphics.Paint ), this, f, f2, f3, paint);
    }

    public void drawColor(int n) {
        InvokeDynamicSupport.bootstrap("drawColor", $$robo$$android_graphics_BaseCanvas$drawColor(int ), this, n);
    }

    public void drawColor(int n, PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("drawColor", $$robo$$android_graphics_BaseCanvas$drawColor(int android.graphics.PorterDuff$Mode ), this, n, mode);
    }

    public void drawLine(float f, float f2, float f3, float f4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLine", $$robo$$android_graphics_BaseCanvas$drawLine(float float float float android.graphics.Paint ), this, f, f2, f3, f4, paint);
    }

    public void drawLines(float[] fArray, int n, int n2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLines", $$robo$$android_graphics_BaseCanvas$drawLines(float[] int int android.graphics.Paint ), this, fArray, n, n2, paint);
    }

    public void drawLines(float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawLines", $$robo$$android_graphics_BaseCanvas$drawLines(float[] android.graphics.Paint ), this, fArray, paint);
    }

    public void drawOval(float f, float f2, float f3, float f4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawOval", $$robo$$android_graphics_BaseCanvas$drawOval(float float float float android.graphics.Paint ), this, f, f2, f3, f4, paint);
    }

    public void drawOval(RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawOval", $$robo$$android_graphics_BaseCanvas$drawOval(android.graphics.RectF android.graphics.Paint ), this, rectF, paint);
    }

    public void drawPaint(Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPaint", $$robo$$android_graphics_BaseCanvas$drawPaint(android.graphics.Paint ), this, paint);
    }

    public void drawPatch(NinePatch ninePatch, Rect rect, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPatch", $$robo$$android_graphics_BaseCanvas$drawPatch(android.graphics.NinePatch android.graphics.Rect android.graphics.Paint ), this, ninePatch, rect, paint);
    }

    public void drawPatch(NinePatch ninePatch, RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPatch", $$robo$$android_graphics_BaseCanvas$drawPatch(android.graphics.NinePatch android.graphics.RectF android.graphics.Paint ), this, ninePatch, rectF, paint);
    }

    public void drawPath(Path path, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPath", $$robo$$android_graphics_BaseCanvas$drawPath(android.graphics.Path android.graphics.Paint ), this, path, paint);
    }

    public void drawPoint(float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPoint", $$robo$$android_graphics_BaseCanvas$drawPoint(float float android.graphics.Paint ), this, f, f2, paint);
    }

    public void drawPoints(float[] fArray, int n, int n2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPoints", $$robo$$android_graphics_BaseCanvas$drawPoints(float[] int int android.graphics.Paint ), this, fArray, n, n2, paint);
    }

    public void drawPoints(float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPoints", $$robo$$android_graphics_BaseCanvas$drawPoints(float[] android.graphics.Paint ), this, fArray, paint);
    }

    @Deprecated
    public void drawPosText(char[] cArray, int n, int n2, float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPosText", $$robo$$android_graphics_BaseCanvas$drawPosText(char[] int int float[] android.graphics.Paint ), this, cArray, n, n2, fArray, paint);
    }

    @Deprecated
    public void drawPosText(String string2, float[] fArray, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawPosText", $$robo$$android_graphics_BaseCanvas$drawPosText(java.lang.String float[] android.graphics.Paint ), this, string2, fArray, paint);
    }

    public void drawRect(float f, float f2, float f3, float f4, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRect", $$robo$$android_graphics_BaseCanvas$drawRect(float float float float android.graphics.Paint ), this, f, f2, f3, f4, paint);
    }

    public void drawRect(Rect rect, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRect", $$robo$$android_graphics_BaseCanvas$drawRect(android.graphics.Rect android.graphics.Paint ), this, rect, paint);
    }

    public void drawRect(RectF rectF, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRect", $$robo$$android_graphics_BaseCanvas$drawRect(android.graphics.RectF android.graphics.Paint ), this, rectF, paint);
    }

    public void drawRGB(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("drawRGB", $$robo$$android_graphics_BaseCanvas$drawRGB(int int int ), this, n, n2, n3);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRoundRect", $$robo$$android_graphics_BaseCanvas$drawRoundRect(float float float float float float android.graphics.Paint ), this, f, f2, f3, f4, f5, f6, paint);
    }

    public void drawRoundRect(RectF rectF, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawRoundRect", $$robo$$android_graphics_BaseCanvas$drawRoundRect(android.graphics.RectF float float android.graphics.Paint ), this, rectF, f, f2, paint);
    }

    public void drawText(char[] cArray, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_BaseCanvas$drawText(char[] int int float float android.graphics.Paint ), this, cArray, n, n2, f, f2, paint);
    }

    public void drawText(CharSequence charSequence, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_BaseCanvas$drawText(java.lang.CharSequence int int float float android.graphics.Paint ), this, charSequence, n, n2, f, f2, paint);
    }

    public void drawText(String string2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_BaseCanvas$drawText(java.lang.String float float android.graphics.Paint ), this, string2, f, f2, paint);
    }

    public void drawText(String string2, int n, int n2, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawText", $$robo$$android_graphics_BaseCanvas$drawText(java.lang.String int int float float android.graphics.Paint ), this, string2, n, n2, f, f2, paint);
    }

    public void drawTextOnPath(char[] cArray, int n, int n2, Path path, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextOnPath", $$robo$$android_graphics_BaseCanvas$drawTextOnPath(char[] int int android.graphics.Path float float android.graphics.Paint ), this, cArray, n, n2, path, f, f2, paint);
    }

    public void drawTextOnPath(String string2, Path path, float f, float f2, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextOnPath", $$robo$$android_graphics_BaseCanvas$drawTextOnPath(java.lang.String android.graphics.Path float float android.graphics.Paint ), this, string2, path, f, f2, paint);
    }

    public void drawTextRun(char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextRun", $$robo$$android_graphics_BaseCanvas$drawTextRun(char[] int int int int float float boolean android.graphics.Paint ), this, cArray, n, n2, n3, n4, f, f2, bl, paint);
    }

    public void drawTextRun(CharSequence charSequence, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawTextRun", $$robo$$android_graphics_BaseCanvas$drawTextRun(java.lang.CharSequence int int int int float float boolean android.graphics.Paint ), this, charSequence, n, n2, n3, n4, f, f2, bl, paint);
    }

    public void drawVertices(Canvas.VertexMode vertexMode, int n, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, short[] sArray, int n5, int n6, Paint paint) {
        InvokeDynamicSupport.bootstrap("drawVertices", $$robo$$android_graphics_BaseCanvas$drawVertices(android.graphics.Canvas$VertexMode int float[] int float[] int int[] int short[] int int android.graphics.Paint ), this, vertexMode, n, fArray, n2, fArray2, n3, nArray, n4, sArray, n5, n6, paint);
    }

    public void setHwBitmapsInSwModeEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHwBitmapsInSwModeEnabled", $$robo$$android_graphics_BaseCanvas$setHwBitmapsInSwModeEnabled(boolean ), this, bl);
    }

    public boolean isHwBitmapsInSwModeEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHwBitmapsInSwModeEnabled", $$robo$$android_graphics_BaseCanvas$isHwBitmapsInSwModeEnabled(), this);
    }

    protected void onHwBitmapInSwMode() {
        InvokeDynamicSupport.bootstrap("onHwBitmapInSwMode", $$robo$$android_graphics_BaseCanvas$onHwBitmapInSwMode(), this);
    }

    private void throwIfHwBitmapInSwMode(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("throwIfHwBitmapInSwMode", $$robo$$android_graphics_BaseCanvas$throwIfHwBitmapInSwMode(android.graphics.Bitmap ), this, bitmap);
    }

    private void throwIfHasHwBitmapInSwMode(Paint paint) {
        InvokeDynamicSupport.bootstrap("throwIfHasHwBitmapInSwMode", $$robo$$android_graphics_BaseCanvas$throwIfHasHwBitmapInSwMode(android.graphics.Paint ), this, paint);
    }

    private void throwIfHasHwBitmapInSwMode(Shader shader) {
        InvokeDynamicSupport.bootstrap("throwIfHasHwBitmapInSwMode", $$robo$$android_graphics_BaseCanvas$throwIfHasHwBitmapInSwMode(android.graphics.Shader ), this, shader);
    }

    private static void nDrawBitmap(long l, Bitmap bitmap, float f, float f2, long l2, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("nDrawBitmap", $$robo$$android_graphics_BaseCanvas$nDrawBitmap(long android.graphics.Bitmap float float long int int int ), (long)l, (Bitmap)bitmap, (float)f, (float)f2, (long)l2, (int)n, (int)n2, (int)n3);
    }

    private static void nDrawBitmap(long l, Bitmap bitmap, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, long l2, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawBitmap", $$robo$$android_graphics_BaseCanvas$nDrawBitmap(long android.graphics.Bitmap float float float float float float float float long int int ), (long)l, (Bitmap)bitmap, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (float)f7, (float)f8, (long)l2, (int)n, (int)n2);
    }

    private static void nDrawBitmap(long l, int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawBitmap", $$robo$$android_graphics_BaseCanvas$nDrawBitmap(long int[] int int float float int int boolean long ), (long)l, (int[])nArray, (int)n, (int)n2, (float)f, (float)f2, (int)n3, (int)n4, (boolean)bl, (long)l2);
    }

    private static void nDrawColor(long l, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawColor", $$robo$$android_graphics_BaseCanvas$nDrawColor(long int int ), (long)l, (int)n, (int)n2);
    }

    private static void nDrawPaint(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawPaint", $$robo$$android_graphics_BaseCanvas$nDrawPaint(long long ), (long)l, (long)l2);
    }

    private static void nDrawPoint(long l, float f, float f2, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawPoint", $$robo$$android_graphics_BaseCanvas$nDrawPoint(long float float long ), (long)l, (float)f, (float)f2, (long)l2);
    }

    private static void nDrawPoints(long l, float[] fArray, int n, int n2, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawPoints", $$robo$$android_graphics_BaseCanvas$nDrawPoints(long float[] int int long ), (long)l, (float[])fArray, (int)n, (int)n2, (long)l2);
    }

    private static void nDrawLine(long l, float f, float f2, float f3, float f4, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawLine", $$robo$$android_graphics_BaseCanvas$nDrawLine(long float float float float long ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (long)l2);
    }

    private static void nDrawLines(long l, float[] fArray, int n, int n2, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawLines", $$robo$$android_graphics_BaseCanvas$nDrawLines(long float[] int int long ), (long)l, (float[])fArray, (int)n, (int)n2, (long)l2);
    }

    private static void nDrawRect(long l, float f, float f2, float f3, float f4, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawRect", $$robo$$android_graphics_BaseCanvas$nDrawRect(long float float float float long ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (long)l2);
    }

    private static void nDrawOval(long l, float f, float f2, float f3, float f4, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawOval", $$robo$$android_graphics_BaseCanvas$nDrawOval(long float float float float long ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (long)l2);
    }

    private static void nDrawCircle(long l, float f, float f2, float f3, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawCircle", $$robo$$android_graphics_BaseCanvas$nDrawCircle(long float float float long ), (long)l, (float)f, (float)f2, (float)f3, (long)l2);
    }

    private static void nDrawArc(long l, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawArc", $$robo$$android_graphics_BaseCanvas$nDrawArc(long float float float float float float boolean long ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (boolean)bl, (long)l2);
    }

    private static void nDrawRoundRect(long l, float f, float f2, float f3, float f4, float f5, float f6, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawRoundRect", $$robo$$android_graphics_BaseCanvas$nDrawRoundRect(long float float float float float float long ), (long)l, (float)f, (float)f2, (float)f3, (float)f4, (float)f5, (float)f6, (long)l2);
    }

    private static void nDrawPath(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nDrawPath", $$robo$$android_graphics_BaseCanvas$nDrawPath(long long long ), (long)l, (long)l2, (long)l3);
    }

    private static void nDrawRegion(long l, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nDrawRegion", $$robo$$android_graphics_BaseCanvas$nDrawRegion(long long long ), (long)l, (long)l2, (long)l3);
    }

    private static void nDrawNinePatch(long l, long l2, long l3, float f, float f2, float f3, float f4, long l4, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawNinePatch", $$robo$$android_graphics_BaseCanvas$nDrawNinePatch(long long long float float float float long int int ), (long)l, (long)l2, (long)l3, (float)f, (float)f2, (float)f3, (float)f4, (long)l4, (int)n, (int)n2);
    }

    private static void nDrawBitmapMatrix(long l, Bitmap bitmap, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nDrawBitmapMatrix", $$robo$$android_graphics_BaseCanvas$nDrawBitmapMatrix(long android.graphics.Bitmap long long ), (long)l, (Bitmap)bitmap, (long)l2, (long)l3);
    }

    private static void nDrawBitmapMesh(long l, Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawBitmapMesh", $$robo$$android_graphics_BaseCanvas$nDrawBitmapMesh(long android.graphics.Bitmap int int float[] int int[] int long ), (long)l, (Bitmap)bitmap, (int)n, (int)n2, (float[])fArray, (int)n3, (int[])nArray, (int)n4, (long)l2);
    }

    private static void nDrawVertices(long l, int n, int n2, float[] fArray, int n3, float[] fArray2, int n4, int[] nArray, int n5, short[] sArray, int n6, int n7, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawVertices", $$robo$$android_graphics_BaseCanvas$nDrawVertices(long int int float[] int float[] int int[] int short[] int int long ), (long)l, (int)n, (int)n2, (float[])fArray, (int)n3, (float[])fArray2, (int)n4, (int[])nArray, (int)n5, (short[])sArray, (int)n6, (int)n7, (long)l2);
    }

    private static void nDrawText(long l, char[] cArray, int n, int n2, float f, float f2, int n3, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawText", $$robo$$android_graphics_BaseCanvas$nDrawText(long char[] int int float float int long ), (long)l, (char[])cArray, (int)n, (int)n2, (float)f, (float)f2, (int)n3, (long)l2);
    }

    private static void nDrawText(long l, String string2, int n, int n2, float f, float f2, int n3, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawText", $$robo$$android_graphics_BaseCanvas$nDrawText(long java.lang.String int int float float int long ), (long)l, (String)string2, (int)n, (int)n2, (float)f, (float)f2, (int)n3, (long)l2);
    }

    private static void nDrawTextRun(long l, String string2, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawTextRun", $$robo$$android_graphics_BaseCanvas$nDrawTextRun(long java.lang.String int int int int float float boolean long ), (long)l, (String)string2, (int)n, (int)n2, (int)n3, (int)n4, (float)f, (float)f2, (boolean)bl, (long)l2);
    }

    private static void nDrawTextRun(long l, char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, long l2, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nDrawTextRun", $$robo$$android_graphics_BaseCanvas$nDrawTextRun(long char[] int int int int float float boolean long long ), (long)l, (char[])cArray, (int)n, (int)n2, (int)n3, (int)n4, (float)f, (float)f2, (boolean)bl, (long)l2, (long)l3);
    }

    private static void nDrawTextOnPath(long l, char[] cArray, int n, int n2, long l2, float f, float f2, int n3, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nDrawTextOnPath", $$robo$$android_graphics_BaseCanvas$nDrawTextOnPath(long char[] int int long float float int long ), (long)l, (char[])cArray, (int)n, (int)n2, (long)l2, (float)f, (float)f2, (int)n3, (long)l3);
    }

    private static void nDrawTextOnPath(long l, String string2, long l2, float f, float f2, int n, long l3) {
        InvokeDynamicSupport.bootstrapStatic("nDrawTextOnPath", $$robo$$android_graphics_BaseCanvas$nDrawTextOnPath(long java.lang.String long float float int long ), (long)l, (String)string2, (long)l2, (float)f, (float)f2, (int)n, (long)l3);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseCanvas)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

